!*  WRITTEN ON 3/31/94 BY Dr. Albion Taylor  NOAA / OAR / ARL
!$$$

subroutine xysize(strcmp,x,y,dist)

  implicit none

  real, intent(in)  :: x,y
  real, intent(out) :: dist
  REAL STRCMP(9)

  real, parameter :: rearth = 6371.2
  real, parameter :: almst1 = .99999
  DOUBLE PRECISION YMERC,EFACT,RADIAL,TEMP
  DOUBLE PRECISION XI0,ETA0,XI,ETA

  print *,'xysize: ',x,y
 !print *,strcmp

      XI0 = ( X - STRCMP(3) ) * STRCMP(7) / REARTH
      ETA0 = ( Y - STRCMP(4) ) * STRCMP(7) /REARTH
      XI = XI0 * STRCMP(5) - ETA0 * STRCMP(6)
      ETA = ETA0 * STRCMP(5) + XI0 * STRCMP(6)
      RADIAL = 2. * ETA - STRCMP(1) * (XI*XI + ETA*ETA)
      EFACT = STRCMP(1) * RADIAL
     !print *,'+++',x,y,EFACT

      IF (EFACT .GT. ALMST1) THEN
        IF (STRCMP(1).GT.ALMST1) THEN
          dist   = 2. * STRCMP(7)
        ELSE
          dist   = 0.
        ENDIF
        RETURN
      ENDIF

      IF (ABS(EFACT) .LT. 1.E-2) THEN
        TEMP = (EFACT / (2. - EFACT) )**2
        YMERC = RADIAL / (2. - EFACT) * (1.    + TEMP *                        &
                                        (1./3. + TEMP *                        &
                                        (1./5. + TEMP *                        &
                                        (1./7. ))))
        !print *,'place 1',ymerc
      ELSE
        YMERC = - LOG( 1. - EFACT ) /2. /STRCMP(1)
        !print *,'place 2',ymerc
      ENDIF

      IF (YMERC .GT. 6.) THEN
        IF (STRCMP(1) .GT. ALMST1) THEN
          dist   = 2. * STRCMP(7)
        ELSE
          dist   = 0.
        ENDIF
      ELSE IF (YMERC .LT. -6.) THEN
        IF (STRCMP(1) .LT. -ALMST1) THEN
          dist   = 2. * STRCMP(7)
        ELSE
          dist   = 0.
        ENDIF
      ELSE
       !print *,'here c'
        EFACT = EXP(YMERC)
        dist   = 2. * STRCMP(7) * EXP (STRCMP(1) * YMERC)                      &
                               / (EFACT + 1./EFACT)
      ENDIF
   print *,dist

  RETURN
end subroutine xysize
