import Ngl
import numpy as np
from netCDF4 import Dataset
import math
import sys
from MPASUtils import outline_voronoi_cells


#
# Center latitude and longitude of plot
#
cenlat = 90.0
cenlon = 0.0

#
# The bounding box for the plot
#
leftAngle   = 30.0
rightAngle  = 30.0
bottomAngle = 30.0
topAngle    = 30.0


if __name__ == "__main__":

    r2d = 180.0 / math.pi

    if len(sys.argv) != 2:
        print('')
        print('Usage: '+sys.argv[0]+' <mesh filename>')
        print('')
        exit(1)

    gname = sys.argv[1]
    g = Dataset(gname)

    wks_type = 'png'
    wks = Ngl.open_wks(wks_type,'regional_mesh')
    cmap = Ngl.read_colormap_file('mpas_mesh.rgb')
    Ngl.define_colormap(wks, cmap[:,0:3])

    res = Ngl.Resources()

    res.mpProjection      = 'Orthographic'
    res.mpDataBaseVersion = 'MediumRes'
    res.mpCenterLatF      = cenlat
    res.mpCenterLonF      = cenlon
    res.mpGridAndLimbOn   = False
    res.mpOutlineOn       = False
    res.mpFillOn          = True
    res.mpPerimOn         = False
    res.nglFrame          = False
    res.mpLimitMode       = 'Angles'
    res.mpLeftAngleF      = leftAngle
    res.mpRightAngleF     = rightAngle
    res.mpBottomAngleF    = bottomAngle
    res.mpTopAngleF       = topAngle
    res.mpOceanFillColor  = 2
    res.mpInlandWaterFillColor  = 2
    res.mpLandFillColor  = 3


    #
    # Set mesh filename as title of plot
    #
    #res.tiMainString = gname


    #
    # The purpose of this next line is simply to set up a graphic ('map')
    #    that uses the projection specified above, and over which we
    #    can draw polygons
    #
    map = Ngl.map(wks,res)


    #
    # Draw mesh outline
    #
    lonVertex = g.variables['lonVertex'][:] * r2d
    latVertex = g.variables['latVertex'][:] * r2d
    verticesOnCell = g.variables['verticesOnCell'][:]
    nEdgesOnCell = g.variables['nEdgesOnCell'][:]

    g.close()

    outline_voronoi_cells(wks, map, nEdgesOnCell, lonVertex, latVertex, verticesOnCell)
    Ngl.draw(map)


    #
    # Draw map outline
    #
    mres = Ngl.Resources()
    mres.mpProjection      = 'Orthographic'
    mres.mpCenterLatF      = cenlat
    mres.mpCenterLonF      = cenlon
    mres.mpGridAndLimbOn   = False
    mres.mpOutlineOn       = True
    mres.mpFillOn          = False
    mres.mpPerimOn         = False
    mres.nglFrame          = False
    mres.mpLimitMode       = 'Angles'
    mres.mpLeftAngleF      = leftAngle
    mres.mpRightAngleF     = rightAngle
    mres.mpBottomAngleF    = bottomAngle
    mres.mpTopAngleF       = topAngle
    mres.mpDataBaseVersion = 'MediumRes'
    mres.mpOutlineBoundarySets = 'GeophysicalAndUSStates'
    mapo = Ngl.map(wks,mres)

    Ngl.frame(wks)

    Ngl.end()
