import Ngl
import numpy as np
from netCDF4 import Dataset
import math
from MPASUtils import val_to_index, fill_voronoi_cells, draw_label_bar, outline_voronoi_cells
import sys


if __name__ == "__main__":

    #
    # Get the name of the file containing the static information
    #
    if len(sys.argv) != 2:
        print('')
        print('Usage: '+sys.argv[0]+' <filename>')
        print('')
        exit(0)

    #
    # Center latitude and longitude
    #
    cenlat = 0.0
    cenlon = 0.0
 

    #
    # Set plotting window
    #
    mapLeft   = -125.0
    mapRight  = -110.0
    mapBottom =   15.0
    mapTop    =   20.0

    g = Dataset(sys.argv[1])

    #
    # The field to be plotted
    #
    h = g.variables['precipw'][0,:]

    r2d = 180.0 / math.pi             # radians to degrees

    rlist = Ngl.Resources()
#    rlist.wkWidth = 1200
#    rlist.wkHeight = 1200
    rlist.wkColorMap = 'GMT_ocean'

    wks_type = 'png'
    wks = Ngl.open_wks(wks_type,'labels',rlist)

    nColors = 80
    cnLevels = np.linspace(0.0, 50.0, nColors+1)

    nEdgesOnCell = g.variables['nEdgesOnCell'][:]
    verticesOnCell = g.variables['verticesOnCell'][:]
    verticesOnEdge = g.variables['verticesOnEdge'][:]
    x   = g.variables['lonCell'][:] * r2d
    y   = g.variables['latCell'][:] * r2d
    lonCell = g.variables['lonCell'][:] * r2d
    latCell = g.variables['latCell'][:] * r2d
    lonVertex = g.variables['lonVertex'][:] * r2d
    latVertex = g.variables['latVertex'][:] * r2d
    verticesOnEdge = g.variables['verticesOnEdge'][:]

    res = Ngl.Resources()

    res.nglPaperOrientation  = 'portrait'

    res.mpProjection      = 'CylindricalEquidistant'
    res.mpDataBaseVersion = 'MediumRes'
    res.mpCenterLatF      = cenlat
    res.mpCenterLonF      = cenlon
    res.mpGridAndLimbOn   = False
    res.mpOutlineOn       = False
    res.mpFillOn          = True
    res.mpPerimOn         = False
    res.nglFrame          = False
    res.mpLimitMode      = 'LatLon'
    res.mpMinLonF        = mapLeft
    res.mpMaxLonF        = mapRight
    res.mpMinLatF        = mapBottom
    res.mpMaxLatF        = mapTop
    res.mpOceanFillColor  = 2
    res.mpInlandWaterFillColor  = 2
    res.mpLandFillColor  = 3

    #
    # Set field name and units
    #
#    res.nglLeftString   = 'blah_long_name'
#    res.nglRightString  = '['+'blah_units'+']'
#    res.tiMainString    = 'arctic.init.nc'


    nCells = len(g.dimensions['nCells'])
    maxEdges = len(g.dimensions['maxEdges'])

    #
    # The purpose of this next line is simply to set up a graphic ('map')
    #    that uses the projection specified above, and over which we
    #    can draw polygons
    #
    map = Ngl.map(wks,res)


    cres = Ngl.Resources()
    cres.txFontColor = 0        # background color
    cres.txFontHeightF = 0.025


    #
    # Draw polygons for cells
    #
    fill_voronoi_cells(wks, map, cnLevels, nColors, nEdgesOnCell, lonVertex, latVertex, verticesOnCell, h)
    Ngl.draw(map)

    #
    # Draw cell outlines
    #
    outline_voronoi_cells(wks, map, nEdgesOnCell, lonVertex, latVertex, verticesOnCell, h, line_width=0.5)
    Ngl.draw(map)

    #
    # Draw label bar
    #
    draw_label_bar(wks, cnLevels, nColors)


    #
    # Draw map outline
    #
    mres = Ngl.Resources()
    mres.mpProjection      = 'CylindricalEquidistant'
    mres.mpCenterLatF      = cenlat
    mres.mpCenterLonF      = cenlon
    mres.mpGridAndLimbOn   = False
    mres.mpOutlineOn       = True
    mres.mpFillOn          = False
    mres.mpPerimOn         = False
    mres.nglFrame          = False
    mres.mpLimitMode       = 'LatLon'
    mres.mpMinLonF         = mapLeft
    mres.mpMaxLonF         = mapRight
    mres.mpMinLatF         = mapBottom
    mres.mpMaxLatF         = mapTop
    mres.mpDataBaseVersion = 'MediumRes'
    mres.mpOutlineBoundarySets = 'GeophysicalAndUSStates'
    mapo = Ngl.map(wks,mres)

    Ngl.frame(wks)

    Ngl.end()
