import Ngl
import numpy as np
from netCDF4 import Dataset
import math
import sys


if __name__ == "__main__":

    #
    # Get the name of the file containing the static information
    #
    if len(sys.argv) != 2:
        print('')
        print('Usage: '+sys.argv[0]+' <filename>')
        print('')
        exit(0)

    #
    # The (lat,lon) the plot is to be centered over
    #
    cenLat   = 0.0
    cenLon   = 0.0

    #
    # Projection to use for plot
    #
    projection = 'CylindricalEquidistant'


    r2d = 180.0 / math.pi             # radians to degrees

    f = Dataset(sys.argv[1])

    rlist = Ngl.Resources()
#    rlist.wkWidth = 1200
#    rlist.wkHeight = 1200

    cmap = ['white', 'black', 'lightskyblue1', 'lightskyblue1', 'bisque']
    rlist.wkColorMap = cmap

    wks_type = 'png'
    wks = Ngl.open_wks(wks_type, 'mesh_resolution', rlist)

    lonCell = f.variables['lonCell'][:] * r2d
    latCell = f.variables['latCell'][:] * r2d

    res = Ngl.Resources()

    res.sfXArray             = lonCell
    res.sfYArray             = latCell

    res.cnFillOn             = False
    res.cnLinesOn            = True
    res.cnLineLabelsOn       = True

    res.cnLevelSpacingF      = 10.0
    res.cnInfoLabelOn        = True
    res.lbLabelAutoStride    = True
    res.lbBoxLinesOn         = False

    res.mpProjection      = projection
    res.mpDataBaseVersion = 'MediumRes'
    res.mpCenterLatF      = cenLat
    res.mpCenterLonF      = cenLon
    res.mpGridAndLimbOn   = True
    res.mpGridAndLimbDrawOrder = 'PreDraw'
    res.mpGridLineColor   = 'Background'
    res.mpOutlineOn       = True
    res.mpDataBaseVersion = 'Ncarg4_1'
    res.mpDataSetName     = 'Earth..3'
    res.mpOutlineBoundarySets = 'Geophysical'
    res.mpFillOn          = True
    res.mpPerimOn         = True
    res.cnLineThicknessF  = 2.0
    res.cnLineColor       = 'NavyBlue'
    res.mpOceanFillColor  = 3
    res.mpInlandWaterFillColor  = 3
    res.mpLandFillColor  = 4

    minSpacingKm = math.sqrt(np.min(f.variables['areaCell'][:])*2.0/math.sqrt(3.0))*6371.229
    print('Approx. min grid distance is ', minSpacingKm)

    fld = minSpacingKm / (f.variables['meshDensity'][:]**0.25)
    res.cnLineDashPattern = 0
    map = Ngl.contour_map(wks, fld, res)

    Ngl.end()
