import Ngl
import numpy as np
from netCDF4 import Dataset
import math
import sys
from MPASUtils import outline_voronoi_cells, label_voronoi_cells


#
# Center latitude and longitude of plot
#
cenlat = 90.0
cenlon = 0.0

#
# The bounding box for the plot
#
leftAngle   = 30.0
rightAngle  = 30.0
bottomAngle = 30.0
topAngle    = 30.0


if __name__ == "__main__":

    r2d = 180.0 / math.pi

    if len(sys.argv) != 2:
        print('')
        print('Usage: '+sys.argv[0]+' <mesh filename>')
        print('')
        exit(1)

    gname = sys.argv[1]
    g = Dataset(gname)

    wks_type = 'pdf'
    wks = Ngl.open_wks(wks_type,'regional_mesh')
    cmap = Ngl.read_colormap_file('mpas_mesh.rgb')
    Ngl.define_colormap(wks, cmap[:,0:3])

    res = Ngl.Resources()

    res.mpProjection      = 'Orthographic'
    res.mpDataBaseVersion = 'MediumRes'
    res.mpCenterLatF      = cenlat
    res.mpCenterLonF      = cenlon
    res.mpGridAndLimbOn   = False
    res.mpOutlineOn       = False
    res.mpFillOn          = True
    res.mpPerimOn         = False
    res.nglFrame          = False
    res.mpLimitMode       = 'Angles'
    res.mpLeftAngleF      = leftAngle
    res.mpRightAngleF     = rightAngle
    res.mpBottomAngleF    = bottomAngle
    res.mpTopAngleF       = topAngle
    res.mpOceanFillColor  = 2
    res.mpInlandWaterFillColor  = 2
    res.mpLandFillColor  = 3
    res.nglDraw = False


    #
    # Set mesh filename as title of plot
    #
    #res.tiMainString = gname


    #
    # The purpose of this next line is simply to set up a graphic ('map')
    #    that uses the projection specified above, and over which we
    #    can draw polygons
    #
    map = Ngl.map(wks,res)


    #
    # Draw mesh outline
    #
    lonCell = g.variables['lonCell'][:] * r2d
    latCell = g.variables['latCell'][:] * r2d
    lonEdge = g.variables['lonEdge'][:] * r2d
    latEdge = g.variables['latEdge'][:] * r2d
    lonVertex = g.variables['lonVertex'][:] * r2d
    latVertex = g.variables['latVertex'][:] * r2d
    verticesOnEdge = g.variables['verticesOnEdge'][:]
    verticesOnCell = g.variables['verticesOnCell'][:]
    nEdgesOnCell = g.variables['nEdgesOnCell'][:]
    fld = g.variables['precipw'][0,:]

#    outline_voronoi_cells(wks, map, nEdgesOnCell, lonVertex, latVertex, verticesOnCell)
    label_voronoi_cells(wks, map, latCell, lonCell, fld, format_string='{:5.1f}', text_color='black', text_size=0.0020)

    #
    # Contour one field
    #
    res = Ngl.Resources()
    res.sfXArray             = lonCell
    res.sfYArray             = latCell
    res.cnFillOn             = False
    res.cnLinesOn            = True
    res.cnLineLabelsOn       = True
    res.cnLevelSpacingF      = 2.0
    res.cnInfoLabelOn        = True
    res.lbLabelAutoStride    = True
    res.lbBoxLinesOn         = False
    res.cnLineThicknessF  = 2.0
    res.cnLineColor       = 'NavyBlue'
    res.nglFrame          = False
    res.nglDraw = False

    res.cnLineDashPattern = 0
    contours = Ngl.contour(wks, fld, res)

    Ngl.overlay(map, contours)

    #
    # Contour a second field
    #
    res = Ngl.Resources()
    res.sfXArray             = lonCell
    res.sfYArray             = latCell
    res.cnFillOn             = False
    res.cnLinesOn            = True
    res.cnLineLabelsOn       = True
    res.cnLevelSpacingF      = 2.0
    res.cnInfoLabelOn        = True
    res.lbLabelAutoStride    = True
    res.lbBoxLinesOn         = False
    res.cnLineThicknessF  = 1.0
    res.cnLineColor       = 'red'
    res.nglFrame          = False
    res.nglDraw = False

    res.cnLineDashPattern = 0
    fld = g.variables['skintemp'][0,:]
    contours = Ngl.contour(wks, fld, res)

    Ngl.overlay(map, contours)

    g.close()

    #
    # Draw map outline
    #
    mres = Ngl.Resources()
    mres.mpProjection      = 'Orthographic'
    mres.mpCenterLatF      = cenlat
    mres.mpCenterLonF      = cenlon
    mres.mpGridAndLimbOn   = False
    mres.mpOutlineOn       = True
    mres.mpFillOn          = False
    mres.mpPerimOn         = False
    mres.nglFrame          = False
    mres.mpLimitMode       = 'Angles'
    mres.mpLeftAngleF      = leftAngle
    mres.mpRightAngleF     = rightAngle
    mres.mpBottomAngleF    = bottomAngle
    mres.mpTopAngleF       = topAngle
    mres.mpDataBaseVersion = 'MediumRes'
    mres.mpOutlineBoundarySets = 'GeophysicalAndUSStates'
    mres.nglDraw = False
#    mapo = Ngl.map(wks,mres)

#    Ngl.overlay(map, mapo)

    Ngl.frame(wks)
    Ngl.draw(map)

    Ngl.end()
