#!/bin/ksh
#########################################################################
# Script: da_run_suite_wrapper.ksh
#
# Purpose: Provide user-modifiable interface to da_run_suite.ksh script.
#
# Description:
#
# Here are a few examples of environment variables you may want to 
# change in da_run_suite_wrapper.ksh:
#
# 1) "export RUN_WRFVAR=true" runs WRFVAR.
# 2) "export REL_DIR=$HOME/trunk" points to directory
# containing all code (I always include all components as subdirectories
# e.g. $REL_DIR/wrfvar contains the WRFVAR code.
# 3) "export INITIAL_DATE=2003010100" begins the experiment at 00 UTC
# 1 January 2003.

# You will see a more complete list of environment variables, and their default
# values in da_run_suite.ksh. If one is hard-wired (i.e. not an environment
# variable) then email wrfhelp@ucar.edu and we will add it for the next
# release.
#########################################################################
#set echo 

# 1 Decide which stages to run (run if true):
#--------------------------------------------
# Step 1: run assimilation at initial time (parallel)
# run assimilation at final time if verifying against own analysis (parallel)
export RUN_WRFVAR=true
export RUN_UPDATE_BC=true

# Step 2: run WRF Non-Linear and Adjoint Model (serial)
#export RUN_ADJ_SENS=true

# Step 3: run adjoint of the Data Assimilation at initial time (parallel)
#export RUN_OBS_IMPACT=true

# 2 Experiment details:
#-----------------------------
export CLEAN=false
export CYCLING=false
export CYCLE_NUMBER=0

# 3 Job details:
#------------------------
export NUM_PROCS=4
export RUN_CMD="mpirun -np $NUM_PROCS"
#export RUN_CMD=" "
export SUBMIT="none"
#export LSF_EXCLUSIVE=" "

# 4 Time info:
#-------------------------------
export INITIAL_DATE=2007010100
export FINAL_DATE=2007010100
export LBC_FREQ=06
export CYCLE_PERIOD=06
export LONG_FCST_TIME_1=00
export LONG_FCST_TIME_2=06
export LONG_FCST_TIME_3=12
export LONG_FCST_TIME_4=18
export LONG_FCST_RANGE_1=24
export LONG_FCST_RANGE_2=06
export LONG_FCST_RANGE_3=06
export LONG_FCST_RANGE_4=06

# 5 Directories:
#------------------------------------
export REL_DIR=/wrfhelp/SOURCE_CODE/FSO

export DAT_DIR=/wrfhelp/DATA/WRFDA/ASR180
export WRFVAR_DIR=$REL_DIR/WRFDA
export WRFPLUS_DIR=$REL_DIR/WRFPLUS
export SCRIPTS_DIR=$REL_DIR/tools/var/scripts
export GRAPHICS_DIR=$REL_DIR/tools/var/graphics/ncl
export BUILD_DIR=$WRFVAR_DIR/var/build

export REG_DIR=/data1/$USER/DA/FSO
export RUN_DIR=$REG_DIR/run
export EXP_DIR=${RUN_DIR}

export FC_DIR=${RUN_DIR}/fc
export OB_DIR=${DAT_DIR}/ob
export RC_DIR=${DAT_DIR}/rc
export BE_DIR=${DAT_DIR}/be
export DA_BACK_ERRORS=${BE_DIR}/be_d01.dat

# 6 Namelist parameters:
#--------------------------
#time_control
#domain
export NL_E_WE=61
export NL_E_SN=61
export NL_DX=180000
export NL_DY=180000
export NL_TIME_STEP=900
export NL_E_VERT=41
export NL_P_TOP_REQUESTED=1000

# physics
export NL_MP_PHYSICS=4
export NL_SF_SFCLAY_PHYSICS=1
export NL_SF_SURFACE_PHYSICS=2
export NL_NUM_SOIL_LAYERS=4
export NL_CU_PHYSICS=5

# WRFDA
export WINDOW_START=-3 # use +-3h time window for statistics
export WINDOW_END=3
export NL_CALCULATE_CG_COST_FN=false
export NL_ORTHONORM_GRADIENT=true
export NL_NTMAX=100
export NL_USE_LANCZOS=true
export NL_WRITE_LANCZOS=true
export NL_EPS=1E-5

# WRFPLUS
export DOUBLE=true

# 7 FSO options:
#---------------
export ADJ_REF=1       # 1 -> Own Analysis
                       # 2 -> NCEP Analysis (default)
		       # 3 -> Observations
export ADJ_MEASURE=4   

## setup the targeted domain
export ADJ_ISTART=10 
export ADJ_IEND=50
export ADJ_JSTART=10
export ADJ_JEND=50
export ADJ_KSTART=1
export ADJ_KEND=27

export ADJ_RUN_NL=true
export ADJ_RUN_PLUS=true

# 8 Satellite radiances:
#--------------------------
export NL_USE_AMSUAOBS=false
export NL_USE_AMSUBOBS=false
export NL_USE_MHSOBS=false
export NL_USE_AIRSOBS=false
export NL_RTM_OPTION=2        # 1:rttov; 2:crtm
export  NL_RTMINIT_NSENSOR=0  #2 #1 # amsua, amsub, mhs
export NL_RTMINIT_PLATFORM=9  #,10 #,1,1,1,1,1,1,1
export    NL_RTMINIT_SATID=2  #,2  #,15,16,18,15,16,17,18
export   NL_RTMINIT_SENSOR=11 #,3 #,3,3,3,4,4,4,15
export NL_THINNING=true
export NL_THINNING_MESH=125.0 #,90.0

### CRTM related setup
export DA_CRTM_COEFFS=${WRFVAR_DIR}/var/run/crtm_coeffs
export NL_USE_CRTM_KMATRIX=true
export NL_WRITE_JACOBIAN=false
export NL_CRTM_CLOUD=false

### VarBC related setup
export NL_USE_VARBC=false
export NL_VARBC_FACTOR=2.0
export DA_VARBC_IN=${WRFVAR_DIR}/var/run/VARBC.in

# 9 Run Script:
#--------------------------
export SCRIPT=$SCRIPTS_DIR/da_run_suite.ksh
$SCRIPTS_DIR/da_run_job.ksh
exit 0

