;*************************************************
; WRF: panel three different variables at the same time step
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"   
load "./WRF_contributed.ncl.test"     ; copied on 4/5/4 from /fs/cgd/data0/shea/nclGSUN. 

begin
   ;************************************************
   ; open file and read in data
   ;************************************************

   works = "pdf"
   date = "2006102712"
   year = "2006"
   month = "10"
   day = "28" 
   hour = "00" 
   date_title = year+month+day+hour
   dir = "/data1/classxx/VAR/hybrid/" + date + "/"
   file_type = "wrfout_d01"
   filename1 = file_type + "_" + year + "-" + month + "-" + day + "_" + hour + ":00:00"
   filename2 = file_type + "_" + year + "-" + month + "-" + day + "_" + hour + ":00:00.vari"
   file1 = addfile(dir + filename1 +".nc", "r")
   file2 = addfile(dir + filename2 +".nc", "r")

   ;************************************************
   ; Read vertical coordinate for plot labels
   ;************************************************

   znu   = file1->ZNU(0,:)                          ; (Time, bottom_top)

   ;************************************************
   ; Read fields
   ;************************************************

   var = "U"
   units = " (m/s)"
   kl = 32

   f1 = file1->U    ; ens_mean
   f2 = file2->U    ; variance from the file   
   
   d1 = sqrt(abs(f2-(f1*f1))) ; Convert variance to standard deviation.
   
   ;************************************************
   ; create plots  
   ;************************************************

  ; wks_type@wkOrientation = "landscape"
   wks = gsn_open_wks(works, "mean_std_dev")  ; ps,pdf,x11,ncgm,eps
   gsn_define_colormap(wks ,"BlAqGrYeOrReVi200"); choose colormap

   res                       = True             ; plot mods desired
   res@gsnSpreadColors       = True             ; use full range of colormap
   res@cnFillOn              = True             ; color plot desired
   res@cnLinesOn             = False            ; turn off contour lines
   res@cnLineLabelsOn        = False            ; turn off contour labels
   res@lbLabelAutoStride     = True             ; let NCL figure lb stride
   WRF_map_c(file1,res,0)                          ; set map resources    

   ;************************************************
   ; allocate array for 6 plots
   ;************************************************
   plts                      = new (2,"graphic")   
   ;************************************************
   ; Specify (arbitrarily chosen) subscripts 
   ; This could also be done in a do loop or explicitly specified
   ;************************************************
   nt                        = 0                ; last time step
   ;************************************************
   ; Tell NCL not to draw or advance frame for individual plots
   ;************************************************
   res@cnLevelSelectionMode = "ManualLevels" ; set manual contour levels
   res@gsnDraw               = False            ; (a) do not draw
   res@gsnFrame              = False            ; (b) do not advance 'frame'

   res@gsnLeftString         = var + units
   res@gsnRightString        = "Level=" + kl
   res@gsnPaperOrientation   = "portrait"
   res@gsnMaximize           = False
  
   plts(0)                   = gsn_csm_contour_map(wks,f1(nt,kl,:,:),res)
   plts(1)                   = gsn_csm_contour_map(wks,d1(nt,kl,:,:),res)
   
   ;************************************************
   ; create panel: panel plots have their own set of resources
   ;************************************************
   resP                  = True                   ; modify the panel plot
   resP@txString         = "ens_mean and std_deviation for " + date_title
   ;resP@gsnMaximize      = True                   ; maximize panel area
   resP@gsnPanelRowSpec  = True                   ; specify 1 top, 2 lower level
   gsn_panel(wks,plts,(/2,2/),resP)               ; now draw as one plot

end

