;
; Author: Xiaoyan Zhang   MMM/NCAR
;
; Purpose: plot the obs impact from FSO
;          input_data: gts_omb_oma.
; 8/30/2011: code only availabe for U,V,T,P,Q,GPS
;            and conventional observation instrument
;
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
;============================================================
; Main code
;============================================================

  start_date   = "2007010100"
  end_date     = "2007010112"
  cycle_period = 12
  date         = start_date
  datdir1      = "/kukui7/xinzhang/fso/run/"        ; the path before DATE
  datdir2      = "/obsimpact/working/"                      ; the path after  DATE
  filename_gts   = "gts_omb_oma_01"

;---------------------------------------------------------------------------
; functions and procedures
;---------------------------------------------------------------------------
function read_info(ndata:integer, idata:integer, cdata:character, nlevel:integer, ilevel:integer, type:string)
local info, ibeg, iend, n, is, ie
begin ; begin of function read_info
   if ( type .eq. "id" ) then
      ibeg = 16
      iend = 20
   end if
   if ( type .eq. "lat" ) then
      ibeg = 21
      iend = 29
   end if
   if ( type .eq. "lon" ) then
      ibeg = 30
      iend = 38
   end if
   if ( type .eq. "pre" .or. type .eq. "hgt" ) then
      ibeg = 39
      iend = 55
   end if
   if ( type .eq. "id" ) then
      info = new(sum(nlevel),string)
   else
      info = new(sum(nlevel),float)
   end if
   do n = 0, ndata-1
      if ( nlevel(n) .gt. 0 ) then
         if ( n .eq. 0 ) then
            is = 0
            ie = nlevel(n) - 1
         else
            is = ie + 1
            ie = is + nlevel(n) - 1
         end if
         if ( type .eq. "id" ) then
            info(is:ie) = charactertostring(cdata(ilevel(n)+1:ilevel(n)+nlevel(n),ibeg:iend))
         else
            info(is:ie) = stringtofloat(charactertostring(cdata(ilevel(n)+1:ilevel(n)+nlevel(n),ibeg:iend)))
         end if
      end if
   end do
   return(info)
end ; end of function read_info

function read_data(ndata:integer, idata:integer, cdata:character, nlevel:integer, ilevel:integer, \
                   otype:string, field:string)
local data, k, ibeg, iend, n, is, ie
begin ; begin of function read_data
   data = new((/sum(nlevel),5/),float)
   data@_FillValue = -888888
   if ( otype .eq. "synop" .or. otype .eq. "metar" .or. otype .eq. "ships" .or. \
        otype .eq. "buoy"  .or. otype .eq. "sonde_sfc" ) then
      if ( field .eq. "u" )  then
         ibeg = (/56,73,90,98,115/)
         iend = (/72,89,97,114,131/)
      end if
      if ( field .eq. "v" )  then
         ibeg = (/132,149,166,174,191/)
         iend = (/148,165,173,190,207/)
      end if
      if ( field .eq. "t" )  then
         ibeg = (/208,225,242,250,267/)
         iend = (/224,241,249,266,283/)
      end if
      if ( field .eq. "p" )  then
         ibeg = (/284,301,318,326,343/)
         iend = (/300,317,325,342,359/)
      end if
      if ( field .eq. "q" )  then
         ibeg = (/360,377,394,402,419/)
         iend = (/376,393,401,418,435/)
      end if
   end if
   if ( otype .eq. "geoamv" .or. otype .eq. "polaramv" .or.   \
        otype .eq. "pilot"  .or. otype .eq. "profiler" .or.   \
        otype .eq. "qscat"  .or. otype .eq. "bogus" ) then
      if ( field .eq. "u" )  then
         ibeg = (/56,73,90,98,115/)
         iend = (/72,89,97,114,131/)
      end if
      if ( field .eq. "v" )  then
         ibeg = (/132,149,166,174,191/)
         iend = (/148,165,173,190,207/)
      end if
   end if
   if ( otype .eq. "gpspw" ) then
      if ( field .eq. "tpw" ) then
         ibeg = (/56,73,90,98,115/)
         iend = (/72,89,97,114,131/)
      end if
   end if
   if ( otype .eq. "ssmir" ) then
      if ( field .eq. "spd" ) then
         ibeg = (/56,73,90,98,115/)
         iend = (/72,89,97,114,131/)
      end if
   end if
   if ( otype .eq. "gpsref" ) then
      if ( field .eq. "ref" ) then
         ibeg = (/56,73,90,98,115/)
         iend = (/72,89,97,114,131/)
      end if
   end if
   if ( otype .eq. "airsr" ) then
      if ( field .eq. "t" )  then
         ibeg = (/56,73,90,98,115/)
         iend = (/72,89,97,114,131/)
      end if
      if ( field .eq. "q" )  then
         ibeg = (/132,149,166,174,191/)
         iend = (/148,165,173,190,207/)
      end if
   end if
   if ( otype .eq. "sound" ) then
      if ( field .eq. "u" )  then
         ibeg = (/56,73,90,98,115/)
         iend = (/72,89,97,114,131/)
      end if
      if ( field .eq. "v" )  then
         ibeg = (/132,149,166,174,191/)
         iend = (/148,165,173,190,207/)
      end if
      if ( field .eq. "t" )  then
         ibeg = (/208,225,242,250,267/)
         iend = (/224,241,249,266,283/)
      end if
      if ( field .eq. "q" )  then
         ibeg = (/284,301,318,326,343/)
         iend = (/300,317,325,342,359/)
      end if
   end if
   if ( otype .eq. "airep" ) then
      if ( field .eq. "u" )  then
         ibeg = (/56,73,90,98,115/)
         iend = (/72,89,97,114,131/)
      end if
      if ( field .eq. "v" )  then
         ibeg = (/132,149,166,174,191/)
         iend = (/148,165,173,190,207/)
      end if
      if ( field .eq. "t" )  then
         ibeg = (/208,225,242,250,267/)
         iend = (/224,241,249,266,283/)
      end if
   end if
   if ( otype .eq. "tamdar" ) then
      if ( field .eq. "u" )  then
         ibeg = (/56,73,90,98,115/)
         iend = (/72,89,97,114,131/)
      end if
      if ( field .eq. "v" )  then
         ibeg = (/132,149,166,174,191/)
         iend = (/148,165,173,190,207/)
      end if
      if ( field .eq. "t" )  then
         ibeg = (/208,225,242,250,267/)
         iend = (/224,241,249,266,283/)
      end if
      if ( field .eq. "q" )  then
         ibeg = (/284,301,318,326,343/)
         iend = (/300,317,325,342,359/)
      end if
   end if
   if ( otype .eq. "radar" ) then
      if ( field .eq. "rv" )  then
         ibeg = (/56,73,90,98,115/)
         iend = (/72,89,97,114,131/)
      end if
      if ( field .eq. "rf" )  then
         ibeg = (/132,149,166,174,191/)
         iend = (/148,165,173,190,207/)
      end if
   end if

   do n = 0, ndata-1
      if ( nlevel(n) .gt. 0 ) then
         if ( n .eq. 0 ) then
            is = 0
            ie = nlevel(n) - 1
         else
            is = ie + 1
            ie = is + nlevel(n) - 1
         end if
         do k = 0, 4   ; obs, inv, qc, err, inc
            data(is:ie,k) = stringtofloat(charactertostring(cdata(ilevel(n)+1:ilevel(n)+nlevel(n),ibeg(k):iend(k))))
         end do
      end if
   end do
   return(data)
end ; end of function read_data

undef("plot_levs_impact")
procedure plot_levs_impact(wks:graphic, otype:string, vars:string, obs_number:integer, pressure:float, nlevs:integer, levels_sum:float)
begin
   
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;; Start to creat bar plot ;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  wks = gsn_open_wks("pdf","multi_levs_obs_impact")
  res                             = True
  res@gsnMaximize                 = True    ; Maximize plot in frame
  res@gsnDraw                     = False   ; Don't draw
  res@gsnFrame                    = False   ; Don't advance frame
  res@vpWidthF                    = 0.6     ; Make long and
  res@vpHeightF                   = 0.6     ; narrow
;---Set axes limits. Add extra space for X max.
  res@trXMinF                     = min(levels_sum(:))
  res@trXMaxF                     = max(levels_sum(:))
  res@tiMainString                = otype+"  "+vars
  res@tiMainFontHeightF           = 0.015
  res@trYMinF                     = 0
  res@trYMaxF                     = nlevs + 1
  res@tiYAxisString               = "Pressur (hPa)"  ; yaxis string
  res@tiYAxisSide                 = "right"
  res@tiYAxisFontHeightF          = 0.02
  res@gsnTickMarksPointOutward    = True
  ;---Put variable labels on Y axis
  res@tmYUseLeft                  = False   ; Make right axis independent of left
  res@tmYLOn                      = False   ; Turn off left tickmarks
  res@tmYROn                      = True    ; Turn on right tickmarks
  res@tmYLLabelsOn                = False   ; Turn off left labels
  res@tmYRLabelsOn                = True    ; Turn on right labels
  res@tmYRMinorOn                 = False   ; Turn off minor ticks on Y axis
  res@tmYRLabelFontHeightF        = 0.015   ; Increase font height
  res@tmYRLabelDeltaF             = 0.1     ; Increase space b/w ticks and labels
  res@tmYRMode                    = "Explicit"
  res@tmYRValues                  = ispan(1,nlevs(0),1)
  res@tmYRLabels                  = pressure
;---Put variable labels on X axis
  res@tmXBLabelFontHeightF        = 0.012   ; Increase font height
  res@tmXBLabelDeltaF             = 0.1     ; Increase space b/w ticks and labels
  res@tmXBMajorLengthF            = 0.01
  res@tiXAxisString = "Forecast error contribution (J/kg)"  ; xaxis string
  res@tiXAxisFontHeightF          = 0.02
;---Create blank plot without X grid lines
  plot_without_xgrid = gsn_blank_plot(wks,res)
  ;---Create blank plot with X grid lines
;  res@tmXMinorGrid                = True
;  res@tmXMinorGridLineDashPattern = 2       ; Dashed lines
;  res@tmXMinorGridThicknessF      = 1.0     ; default is 2 (?)
  res@tmXMajorGrid                = True    ; Turn on grid lines
  res@tmXMajorGridLineDashPattern = 2       ; Dashed lines
  res@tmXMajorGridThicknessF      = 1.0     ; default is 2 (?)
  plot_with_xgrid = gsn_blank_plot(wks,res)
;---Arrays to hold the bar values and the bars themselves.
  xbar = new(5,float)
  ybar = new(5,float)
  dum1 = new(nlevs(0),graphic)
  dum2 = new(nlevs(0),graphic)

;---Set some resources for the bars.
  bres                            = True
  bres@gsEdgesOn                  = True      ; Outline the polygons (bars)
  bres@gsEdgeThicknessF           = 2.0
  bres@gsEdgeColor                = "black"
;
;;;; plot the impact for U,V,T,Q, & total
  
  do i=1,nlevs(0)

;---Do longer bar first.
    bres@gsFillColor = "blue"
    xbar      = (/0,levels_sum(i-1),levels_sum(i-1),0,0/)
    ybar       =(/i-0.25,i-0.25,i+0.25,i+0.25,i-0.25/)
    dum2(i-1) = gsn_add_polygon(wks,plot_without_xgrid,xbar,ybar,bres)
  end do
  draw(plot_with_xgrid)
  draw(plot_without_xgrid)
  frame(wks)

;;; plot the time series for
  res2                            = True
;---Put variable labels on X axis
  res2@trXMinF                     = 0
  res2@trXMaxF                     = max(obs_number)
;  res2@trYMinF                     = 0
;  res2@trYMaxF                     = nlevs 
  res2@trYReverse                  = True
 res2@tmXBMode                    = "Explicit"
  res2@tmXBLabelsOn                = True    ; Turn on bottom labels
  res2@tmXBValues                  = ispan(0,max(obs_number),10)
  res2@tmXBLabels                  = res2@tmXBValues    ; Turn on bottom labels
;  res2@tmXBMinorOn                 = True   ; Turn off minor ticks on Y axis
;  res2@tmXBMinorValues             = res@tmXBValues
  res2@tmXBLabelFontHeightF        = 0.012   ; Increase font height
  res2@tmXBLabelDeltaF             = 0.1     ; Increase space b/w ticks and labels
  res2@tmXBMajorLengthF            = 0.01
;  res2@tmXBLabelAngleF             = -45
  res2@tmXTOn                      = False   ; Turn off top tickmarks
  res2@tiYAxisString = "Pressure (hPa)"  ; xaxis string
  res2@tiYAxisFontHeightF          = 0.02
  res2@tiXAxisString = "Numbers of Obs"  ; xaxis string
  res2@tiXAxisFontHeightF          = 0.02
  res2@tiYAxisAngleF               = 90
  res2@xyLineThicknesses           = 2.0               ; make 2nd lines thicker
  res2@xyLineColors                = "blue"          ; change line color
;---Put variable labels on Y axis
;  res2@tmYLMode                    = "Explicit"
  res2@tmYLOn                      = True   ; Turn off left tickmarks
  res2@tmYLLabelsOn                = True   ; Turn off left labels
;  res2@tmYLLabelFontHeightF        = 0.015   ; Increase font height
;  res2@tmYLLabelDeltaF             = 0.1     ; Increase space b/w ticks and labels
  res2@tmYLValues                  = ispan(1,nlevs(0),1)
  res2@tmYLLabels                  = pressure
  x = new(nlevs(0),integer) 
  do i = 0,nlevs(0)-1
    x(i) = obs_number(i)
  end do
  res2@tiMainString                = otype+"  "+vars
  res2@tiMainFontHeightF           = 0.015
  plot = gsn_csm_xy(wks,x(:),pressure(:),res2) 
  draw(plot)
  frame(wks)
end ; end of function plot_levs_impact

;---------------------------------------------------------------------------
; main procedures
;---------------------------------------------------------------------------
begin
  plevs  = (/ (/1005.,995./),(/855.,845/),(/705.,695./),(/505.,495./),\
              (/305.,295./),(/205.,195./),(/105.,95./), \
             (/55.,45./), (/45.,0./)  /)
  mid_plevs = (plevs(:,0)+plevs(:,1))/2
  plevs = plevs * 100.
  print(plevs)
  plevs@_FillValue = -999.
  nplevs = dimsizes(plevs)

  print(mid_plevs)
  proc_sound = True
  proc_tamdar= False
 
  dir_date = stringtointeger((/date/))
; dir_date = dir_date - 2000000000

  gts_fullname = datdir1+dir_date+datdir2+filename_gts

  if ( .not. isfilepresent(gts_fullname) ) then
     print("Can not find the file "+gts_fullname+"  Will skip it")
  else
     if ( stringtointeger(systemfunc("wc -l "+gts_fullname)) .eq. 0 ) then
        print("no data found in "+gts_fullname+"  Will skip it")
     else
        print("Reading data from "+gts_fullname)
        print("This may take a while......")
        data  = asciiread(gts_fullname, -1, "string")    ; -1 means read all rows.
        cdata = stringtochar(data)
        nline = dimsizes(cdata(:,0))

        nsound     = 0
        ntamdar    = 0
;;;;;;;;processing sounding data
        if ( proc_sound ) then
           ob_string = "               sound"
           isound = ind(chartostring(cdata(:,0:19)).eq.ob_string)
           print(isound)
           if ( .not.ismissing(isound) ) then
              nsound = stringtointeger(charactertostring(cdata(isound,20:27))) ; number of obs
              print(nsound)
              if ( nsound .gt. 0 ) then
                 nlevel_sound = new(nsound,integer)
                 ilevel_sound = new(nsound,integer)
                 ilevel_sound(0) = isound+1
                 nlevel_sound(0) = stringtointeger(charactertostring(cdata(ilevel_sound(0),0:7)))
                 do k = 1, nsound-1
                   ilevel_sound(k) = ilevel_sound(k-1)+nlevel_sound(k-1)+1
                   nlevel_sound(k) = stringtointeger(charactertostring(cdata(ilevel_sound(k),0:7)))
                 end do
              end if
           end if
        end if

        if ( proc_sound .and. nsound .gt. 0 ) then ;sounding plot
          sound_id  = read_info(nsound, isound, cdata, nlevel_sound, ilevel_sound, "id")
          sound_lat = read_info(nsound, isound, cdata, nlevel_sound, ilevel_sound, "lat")
          sound_lon = read_info(nsound, isound, cdata, nlevel_sound, ilevel_sound, "lon")
          sound_pre = read_info(nsound, isound, cdata, nlevel_sound, ilevel_sound, "pre")
          sound_u   = read_data(nsound, isound, cdata, nlevel_sound, ilevel_sound, "sound", "u")
          sound_v   = read_data(nsound, isound, cdata, nlevel_sound, ilevel_sound, "sound", "v")
          sound_t   = read_data(nsound, isound, cdata, nlevel_sound, ilevel_sound, "sound", "t")
          sound_q   = read_data(nsound, isound, cdata, nlevel_sound, ilevel_sound, "sound", "q")
          levs_sum  = new((/nplevs(0),5/),float)
          nsound_used = new((/nplevs(0),5/),integer)
          levs_sum  = 0.0
          pres      = sound_pre  
          print(dimsizes(sound_u))
          print(dimsizes(pres))
           do k = 0, nplevs(0)-1
           if ( .not.ismissing(plevs(k,0)) .and. .not.ismissing(plevs(k,1)) ) then
             u_inv = mask(sound_u(:,1), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             print("plevs(k,0) ="+plevs(k,0)+"u_inv="+u_inv)
             v_inv = mask(sound_v(:,1), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             t_inv = mask(sound_t(:,1), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             q_inv = mask(sound_q(:,1), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             u_qc = mask(sound_u(:,2), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             v_qc = mask(sound_v(:,2), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             t_qc = mask(sound_t(:,2), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             q_qc = mask(sound_q(:,2), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             u = mask(u_inv(:), u_qc(:).ge.0,True)
             v = mask(v_inv(:), v_qc(:).ge.0,True)
             t = mask(t_inv(:), t_qc(:).ge.0,True)
             q = mask(q_inv(:), q_qc(:).ge.0,True)
             nn = num(.not.ismissing(u))
             n1 = num(.not.ismissing(u_inv))
             print("k = " +k+" no_qc = "+n1+" qc ="+nn)
             nsound_used(k,0) = num(.not.ismissing(u)) 
             nsound_used(k,1) = num(.not.ismissing(v)) 
             nsound_used(k,2) = num(.not.ismissing(t)) 
             nsound_used(k,3) = num(.not.ismissing(q)) 
             nsound_used(k,4) = sum(nsound_used(k,0:3))
              
             levs_sum(k,0) = levs_sum(k,0)+sum(u)
             levs_sum(k,1) = levs_sum(k,0)+sum(v)
             levs_sum(k,2) = levs_sum(k,0)+sum(t)
             levs_sum(k,3) = levs_sum(k,0)+sum(q)
             levs_sum(k,4) = sum(levs_sum(k,0:3))
           end if
           end do
           print(levs_sum(:,0))
           variables = (/"U","V","T","Q","Total"/)
           wks = gsn_open_wks("pdf","multi_levs_sound_"+start_date)
           do i = 0,dimsizes(variables)-1
             plot_levs_impact(wks, "SOUND",variables(i),nsound_used(:,i),mid_plevs,nplevs,levs_sum(:,i))
           end do
        destroy(wks)
        delete(pres)
        delete(u)
        delete(v)
        delete(t)
        delete(q)
        delete(levs_sum)
        delete(u_inv)
        delete(v_inv)
        delete(t_inv)
        delete(q_inv)
        delete(u_qc)
        delete(v_qc)
        delete(t_qc)
        delete(q_qc)
        delete(ilevel_sound)
        delete(nlevel_sound)
        delete(sound_id)
        delete(sound_lat)
        delete(sound_lon)
        delete(sound_pre)
        delete(sound_u)
        delete(sound_v)
        delete(sound_t)
        delete(sound_q)
        end if ; end of sounding plot
;;;;;;;;End of processing sounding data
;---------------------------------------------------------------------------------------
;;;;;;;;processing tamdar data
        if ( proc_tamdar ) then
           ob_string = "              tamdar"
           itamdar = ind(chartostring(cdata(:,0:19)).eq.ob_string)
           if ( .not.ismissing(itamdar) ) then
              ntamdar = stringtointeger(charactertostring(cdata(itamdar,20:27))) ; number of obs
              print(ntamdar)
              if ( ntamdar .gt. 0 ) then
                 nlevel_tamdar = new(ntamdar,integer)
                 ilevel_tamdar = new(ntamdar,integer)
                 ilevel_tamdar(0) = itamdar+1
                 nlevel_tamdar(0) = stringtointeger(charactertostring(cdata(ilevel_tamdar(0),0:7)))
                 do k = 1, ntamdar-1
                   ilevel_tamdar(k) = ilevel_tamdar(k-1)+nlevel_tamdar(k-1)+1
                   nlevel_tamdar(k) = stringtointeger(charactertostring(cdata(ilevel_tamdar(k),0:7)))
                 end do
              end if
           end if
        end if

        if ( proc_tamdar .and. ntamdar .gt. 0 ) then ;tamdaring plot
          tamdar_id  = read_info(ntamdar, itamdar, cdata, nlevel_tamdar, ilevel_tamdar, "id")
          tamdar_lat = read_info(ntamdar, itamdar, cdata, nlevel_tamdar, ilevel_tamdar, "lat")
          tamdar_lon = read_info(ntamdar, itamdar, cdata, nlevel_tamdar, ilevel_tamdar, "lon")
          tamdar_pre = read_info(ntamdar, itamdar, cdata, nlevel_tamdar, ilevel_tamdar, "pre")
          tamdar_u   = read_data(ntamdar, itamdar, cdata, nlevel_tamdar, ilevel_tamdar, "tamdar", "u")
          tamdar_v   = read_data(ntamdar, itamdar, cdata, nlevel_tamdar, ilevel_tamdar, "tamdar", "v")
          tamdar_t   = read_data(ntamdar, itamdar, cdata, nlevel_tamdar, ilevel_tamdar, "tamdar", "t")
          tamdar_q   = read_data(ntamdar, itamdar, cdata, nlevel_tamdar, ilevel_tamdar, "tamdar", "q")
          ntamdar_used = new((/nplevs(0),5/),integer)
          levs_sum  = new((/nplevs(0),5/),float)
          levs_sum  = 0.0
          pres      = tamdar_pre  
          print(dimsizes(tamdar_u))
          print(dimsizes(pres))
           do k = 0, nplevs(0)-1
           if ( .not.ismissing(plevs(k,0)) .and. .not.ismissing(plevs(k,1)) ) then
             u_inv = mask(tamdar_u(:,1), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             v_inv = mask(tamdar_v(:,1), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             t_inv = mask(tamdar_t(:,1), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             q_inv = mask(tamdar_q(:,1), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             u_qc = mask(tamdar_u(:,2), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             v_qc = mask(tamdar_v(:,2), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             t_qc = mask(tamdar_t(:,2), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             q_qc = mask(tamdar_q(:,2), pres(:).le.plevs(k,0).and.pres(:).ge.plevs(k,1), True)
             u = mask(u_inv(:), u_qc(:).ge.0,True)
             v = mask(v_inv(:), v_qc(:).ge.0,True)
             t = mask(t_inv(:), t_qc(:).ge.0,True)
             q = mask(q_inv(:), q_qc(:).ge.0,True)
             nn = num(.not.ismissing(u))
             n1 = num(.not.ismissing(u_inv))
             print("k = " +k+" no_qc = "+n1+" qc ="+nn)
             ntamdar_used(k,0) = num(.not.ismissing(u))
             ntamdar_used(k,1) = num(.not.ismissing(v))
             ntamdar_used(k,2) = num(.not.ismissing(t))
             ntamdar_used(k,3) = num(.not.ismissing(q))
             ntamdar_used(k,4) = sum(ntamdar_used(k,0:3))
 
             levs_sum(k,0) = levs_sum(k,0)+sum(u)
             levs_sum(k,1) = levs_sum(k,0)+sum(v)
             levs_sum(k,2) = levs_sum(k,0)+sum(t)
             levs_sum(k,3) = levs_sum(k,0)+sum(q)
             levs_sum(k,4) = sum(levs_sum(k,0:3))
                           
           end if
           end do
           print(levs_sum(:,0))
           variables = (/"U","V","T","Q","Total"/)
           wks = gsn_open_wks("pdf","multi_levs_tamdar_"+start_date)
           do i = 0,dimsizes(variables)-1
             plot_levs_impact(wks, "TAMDAR",variables(i),ntamdar_used(:,i),mid_plevs,nplevs,levs_sum(:,i))
           end do
        end if ; end of tamdar plot
        destroy(wks)
;;;;;;;;End of processing tamdar data
        destroy(wks)
        ;delete(pres)
        ;delete(u)
        ;delete(v)
        ;delete(t)
        ;delete(q)
        ;delete(levs_sum)
        ;delete(u_inv)
        ;delete(v_inv)
        ;delete(t_inv)
        ;delete(q_inv)
        ;delete(u_qc)
        ;delete(v_qc)
        ;delete(t_qc)
        ;delete(q_qc)

     end if
  end if  ; end of if plot_gts and input_source=netcdf
end
