load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"

begin

  a = addfile("../2012102718/var/wrfvar_output_d01_2012102718.nc","r")

  type = "x11"
  wks = gsn_open_wks(type,"slp_vector")

  res = True

  times  = wrf_user_getvar(a,"times",-1) ; get times in the file
  ntimes = dimsizes(times)          ; number of times in the file

  do it = 0,ntimes-1,2                  ; TIME LOOP

    print("Working on time: " + times(it) )
    res@TimeLabel = times(it)           ; Set Valid time to use on plots

    p   = wrf_user_getvar(a,"slp",it)
    u  = wrf_user_getvar(a,"ua",it)
    v  = wrf_user_getvar(a,"va",it)
    lat2d = wrf_user_getvar(a,"XLAT",it)
    lon2d = wrf_user_getvar(a,"XLONG",it)
    latS = 22.0
    latN = 38.0
    lonW = -83.0
    lonE = -67.0
    ji = region_ind(lat2d, lon2d, latS, latN, lonW, lonE)
    jStrt = ji(0)
    jLast = ji(1)
    iStrt = ji(2)
    iLast = ji(3)
    LAT2D=lat2d(jStrt:jLast, iStrt:iLast)
    LON2D=lon2d(jStrt:jLast, iStrt:iLast)

    z_plane1 = p
    u_plane1 = u(0,:,:)
    v_plane1 = v(0,:,:)
    speed = sqrt(u_plane1^2+v_plane1^2)

    zz = z_plane1(jStrt:jLast, iStrt:iLast)
    zz@lat2d=LAT2D(:,:)
    zz@lon2d=LON2D(:,:) 
    u_plane=u_plane1(jStrt:jLast, iStrt:iLast)
    v_plane=v_plane1(jStrt:jLast, iStrt:iLast)
    speed_plane = speed(jStrt:jLast, iStrt:iLast)
    u_plane@lat2d=LAT2D(:,:)
    u_plane@lon2d=LON2D(:,:)
    v_plane@lat2d=LAT2D(:,:)
    v_plane@lon2d=LON2D(:,:)
    speed_plane@lat2d=LAT2D(:,:)
    speed_plane@lon2d=LON2D(:,:)

    opts_r = True
    opts_r@mpGridAndLimbOn        = False
    opts_r@mpGeophysicalLineThicknessF = 2.
    opts_r@mpGeophysicalLineColor = "black"
    opts_r@mpNationalLineThicknessF= 2.
    opts_r@mpNationalLineColor = "black"
    opts_r@mpLimitMode             = "Corners"
    opts_r@mpLeftCornerLatF  =  latS
    opts_r@mpRightCornerLatF =  latN
    opts_r@mpLeftCornerLonF  = lonW
    opts_r@mpRightCornerLonF = lonE 

    opts_r@cnFillOn            = True
    opts_r@cnLinesOn             = False     
    opts_r@gsnFrame         = False
    opts_r@gsnLeftString    = "SLP(hPa)"
    opts_r@gsnRightString  = ""
    opts_r@cnLevelSelectionMode = "ManualLevels"
    opts_r@cnLevelSpacingF          =   2.  
    opts_r@cnMinLevelValF          = 974.
    opts_r@cnMaxLevelValF          = 1010.
    plot1=gsn_csm_contour_map(wks,zz,opts_r)       
    
    resV                  = True                      ; vector only resources
    resV@gsnRightString     = ""
    resV@gsnLeftString     = ""
    resV@gsnFrame         = False
    resV@gsnRightString  = "Wind(m/s)"
    resV@mpGridAndLimbOn        = False
    resV@mpGeophysicalLineThicknessF = 2.
    resV@mpGeophysicalLineColor = "black"
    resV@mpNationalLineThicknessF= 2.
    resV@mpNationalLineColor = "black"
    resV@mpLimitMode             = "Corners"
    resV@mpLeftCornerLatF  =  latS
    resV@mpRightCornerLatF =  latN
    resV@mpLeftCornerLonF  = lonW
    resV@mpRightCornerLonF = lonE
    resV@vcRefMagnitudeF  = 10.0                       ; add a reference vector
    resV@vcRefAnnoOn               = True
    resV@vcRefAnnoString1          = "10"
    resV@vcRefAnnoSide             = "Top"
    resV@vcRefAnnoString2On        = False
    resV@vcRefAnnoPerimOn          = False
    resV@vcRefAnnoOrthogonalPosF   = -0.15
    resV@vcRefAnnoParallelPosF     = 0.999
    resV@vcRefLengthF     = 0.045                     ; what the ref length is
    resV@vcGlyphStyle     = "CurlyVector"             ; turn on curley vectors
    resV@vcMinDistanceF          = 0.04
    plot2 = gsn_csm_vector_map(wks,u_plane,v_plane,resV)

    lat = (/29.9,29.9/)
    lon = (/-80.5,-68.5/)
    gsres = True
    gsres@gsLineColor      = "black"
    gsres@gsLineThicknessF = 4.0
    gsn_polyline(wks,plot2,lon,lat,gsres)

    frame(wks)
  end do        ; END OF TIME LOOP

end
