load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"

begin
  a = addfile("/glade/scratch/cyang/data/rerun_amsr2/run_sandy_cloud_chan9-12_nomovr/2012102718/var/wrfvar_output_d01_2012102718.nc","r")
  type = "x11"
  wks = gsn_open_wks(type,"cross_section")
  gsn_define_colormap(wks,"MPL_rainbow")  

  res = True
  res@MainTitle = "REAL-TIME WRF"
  res@Footer = False
  
  pltres = True

  times  = wrf_user_getvar(a,"times",-1) ; get times in the file
  ntimes = dimsizes(times)          ; number of times in the file
  FirstTime = True

  do it = 0,ntimes-1,2                  ; TIME LOOP

    print("Working on time: " + times(it) )
    res@TimeLabel = times(it)           ; Set Valid time to use on plots

    tc  = wrf_user_getvar(a,"tc",it)     ; T in C
    rh = wrf_user_getvar(a,"rh",it)      ; relative humidity
    zz   = wrf_user_getvar(a, "z",it)     ; grid point height
    p   = wrf_user_getvar(a,"p",it)
    w   = wrf_user_getvar(a,"wa",it)
    u   = wrf_user_getvar(a,"ua",it)
    v   =  wrf_user_getvar(a,"va",it)
    speed = sqrt(u^2+v^2)
    tmean = dim_avg_n(tc,(/1,2/))
    dims=dimsizes(tc)

    do i = 0,dims(1)-1
       do j = 0,dims(2)-1
          do k = 0,38
             tc(k,i,j)= tc(k,i,j)-tmean(k)
          end do
       end do
    end do

    z  = zz(0:38,:,:)

    if ( FirstTime ) then                ; get height info for labels
       zmin = 0.
       zmax = max(z)/1000.
       nz   = floattoint(zmax/2 + 1)
       FirstTime = False
    end if
;---------------------------------------------------------------
    lat = (/29.9,29.9/)
    lon = (/-80.5,-68.5/)

    opts = True
    opts@returnInt = False    ; Return real values (set to True for integer values) 
    loc1  = wrf_user_ll_to_ij (a, lon(0), lat(0), opts)
    print("start Y/X location is: " +loc1)
    loc2  = wrf_user_ll_to_ij (a, lon(1), lat(1), opts)
    print("end Y/X location is: " +loc2)

    plane = (/  loc1(0),loc1(1),  loc2(0),loc2(1)  /) 

    angle = 0. 
    opts = True                                  ; start and end points not specified
    rh_plane = wrf_user_intrp3d(rh(0:38,:,:),z,"v",plane,angle,opts)
    tc_plane = wrf_user_intrp3d(tc(0:38,:,:),z,"v",plane,angle,opts)
    w_plane = wrf_user_intrp3d(speed(0:38,:,:),z,"v",plane,angle,opts)
    dim = dimsizes(rh_plane)            ; Find the data span - for use in labels
    print(max(w_plane))

    zspan = dim(0)
    nlon  = dim(1)        

 ; Options for XY Plots
    opts_xy                         = res
    opts_xy@tiYAxisString           = "Height (km)"
    opts_xy@tiXAxisString           = "Number of grid"
    opts_xy@cnMissingValPerimOn     = True
    opts_xy@cnMissingValFillColor   = 0
    opts_xy@cnMissingValFillPattern = 11
    opts_xy@tmYLMode                = "Explicit"
    opts_xy@tmYLValues              = fspan(0,zspan,nz)          ; Create tick marks
    opts_xy@tmYLLabels              = sprintf("%.1f",fspan(zmin,zmax,nz))  ; Create labels
  ; opts_xy@tmXBMode                = "Explicit"
  ; opts_xy@tmXBValues              = fspan(0,nlon,8)          ; Create tick marks
  ; opts_xy@tmXBLabels              = sprintf("%.1f",fspan(lon(0),lon(1),8))
    opts_xy@lbTitleString    = " "
  ; opts_xy@lbTitleOn       =  False
  ; opts_xy@trYMaxF         = 100
      
    opts_xy@tiXAxisFontHeightF      = 0.020
    opts_xy@tiYAxisFontHeightF      = 0.020
    opts_xy@tmXBMajorLengthF        = 0.02
    opts_xy@tmYLMajorLengthF        = 0.02
    opts_xy@tmYLLabelFontHeightF    = 0.015
    opts_xy@PlotOrientation         = tc_plane@Orientation
      
  ; Plotting options for RH
    opts_rh = opts_xy
    opts_rh@ContourParameters       = (/ 10., 90., 10. /)
    opts_rh@pmLabelBarOrthogonalPosF = -0.07
  ; opts_rh@cnFillOn                = True
    opts_rh@cnFillColors            = (/"White","White","White", \
                                      "White","Chartreuse","Green", \
                                      "Green3","Green4", \
                                      "ForestGreen","PaleGreen4"/)

  ; Plotting options for Temperature
    opts_tc = opts_xy
    opts_tc@cnInfoLabelOrthogonalPosF = 0.00
    opts_tc@cnFillOn                = True
  ; opts_tc@ContourParameters  = (/ 4. /)
  ; opts_tc@trYMaxF  = 35
    opts_tc@cnLevelSelectionMode = "ManualLevels"
    opts_tc@cnMinLevelValF = -2.
    opts_tc@cnMaxLevelValF = 12.
    opts_tc@cnLevelSpacingF = 1.

    opts_w = opts_xy
    opts_w@cnFillOn                = True
    opts_w@cnInfoLabelOrthogonalPosF = 0.00
   ;opts_w@ContourParameters  = (/ 2.5 /)
    opts_w@cnLevelSelectionMode = "ManualLevels"
    opts_w@cnMinLevelValF = 5.
    opts_w@cnMaxLevelValF = 38.
    opts_w@cnLevelSpacingF = 2.5

  ; Get the contour info for the rh and temp
    contour_tc = wrf_contour(a,wks,tc_plane,opts_tc)
    contour_rh = wrf_contour(a,wks,rh_plane,opts_rh)
    contour_w  = wrf_contour(a,wks,w_plane,opts_w)

  ; MAKE PLOTS         
    plot = wrf_overlays(a,wks,(/contour_tc/),pltres)
  ; plot = wrf_overlays(a,wks,(/contour_rh/),pltres)
    plot = wrf_overlays(a,wks,(/contour_w/),pltres)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  end do        ; END OF TIME LOOP

end
