;ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
; Copyright (C) 2006
; University Corporation for Atmospheric Research
; All Rights Reserved
;ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
; Author: 
;          Syed RH Rizvi Org: NCAR/NESL/MMM/DAS  
;          Date: 07/22/2010
; Purpose: 
;    To plot XY, XZ and YZ cross-sections of the analysis increments 
;    generated by WRFDA with write_increments=true option
;
;#########################################################################
; Description:
;
;  It is automativcally driven by var/scripts/da_plot_psot_anal_inc.ksh
;  To run it independently, it needs following environment variable
;  works  -- Work
;  expt   -- Typical character string to name the plot
;  kl     -- Vertical sigma level
;  xlon   -- Co-ordinate in WE-direction
;  xlat   -- Co-ordinale in SN direction
;  bakfile - Full path of First Guess file
;  anal_inc_file- Full path of analysis_increments file
;  GRAPHICS_DIR -- Full path GRAPHICS_DIR path
;#########################################################################

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRF_contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl"
;=========================================================;
begin
   ;********************************************************
   ; open file 
     first_guess     = addfile(bakfile+".nc", "r")
   ;********************************************************

; Read global attributes
  cen_lat = first_guess@CEN_LAT
  cen_lon = first_guess@CEN_LON
  map_proj= first_guess@MAP_PROJ
  truelat1= first_guess@TRUELAT1
  truelat2= first_guess@TRUELAT2
; Read Lat & Long
  lat = first_guess->XLAT(0,:,:)
  lon = first_guess->XLONG (0,:,:)
  T = first_guess->T(0,:,:,:)
  xyz = dimsizes(T)
  delete ( T )
  nz = xyz(0)
  ny = xyz(1)
  nx = xyz(2)

   print ("cen_lon : " +cen_lon)
   print ("cen_lat : " +cen_lat)
   print ("map_proj:" +map_proj)
   print ("truelat1:" +truelat1)
   print ("truelat2:" +truelat2)
   print ("nx " +nx)
   print ("ny " +ny)
   print ("nz " +nz)

  ixlat=floattointeger(xlat)
  ixlon=floattointeger(xlon)

  znu = first_guess->ZNU(0,:)


   ;*************************************************

   var1="U"
   units1="(mps)"
   var2="V"
   units2="(mps)"
   var3="T"
   units3="(K)"
   var4="Q"
   units4="(g/Kg)"

   ;**********************No need change lines here onward **********************

   ;****************************************************
   ; Read records from ANALYSIS INCREMENT file
   ;****************************************************
   inc_3d = fbinrecread( anal_inc_file, 0, (/ 7*(nz), ny, nx /) , "double" )
   inc_2d = fbinrecread( anal_inc_file, 1, (/ 2, ny, nx /) , "double" )

   inc_u = new ((/nz,ny,nx/),"double")
   inc_v = new ((/nz,ny,nx/),"double")
   inc_w = new ((/nz,ny,nx/),"double")
   inc_p = new ((/nz,ny,nx/),"double")
   inc_t = new ((/nz,ny,nx/),"double")
   inc_q = new ((/nz,ny,nx/),"double")
   inc_ph= new ((/nz,ny,nx/),"double")
   inc_mu= new ((/ny,nx/),"double")
   inc_ps= new ((/ny,nx/),"double")


   do ik = 0, nz-1
      inc_u (ik,0:ny-1,0:nx-1) = inc_3d(       ik,0:ny-1,0:nx-1)
      inc_v (ik,0:ny-1,0:nx-1) = inc_3d(  nz+ik,0:ny-1,0:nx-1)
      inc_w (ik,0:ny-1,0:nx-1) = inc_3d(2*nz+ik,0:ny-1,0:nx-1)
      inc_p (ik,0:ny-1,0:nx-1) = inc_3d(3*nz+ik,0:ny-1,0:nx-1)
      inc_t (ik,0:ny-1,0:nx-1) = inc_3d(4*nz+ik,0:ny-1,0:nx-1)
      inc_q (ik,0:ny-1,0:nx-1) = inc_3d(5*nz+ik,0:ny-1,0:nx-1)

      inc_ph (ik,0:ny-1,0:nx-1) = inc_3d(6*nz+ik,0:ny-1,0:nx-1)
   end do

      inc_mu(0:ny-1,0:nx-1) = inc_2d(0,0:ny-1,0:nx-1)
      inc_ps(0:ny-1,0:nx-1) = inc_2d(1,0:ny-1,0:nx-1)


   ;*****************************************************


;#########################################################################
; Now create XY cross-sesction
;#########################################################################

   xy_u= inc_u(kl-1,:,:)
   xy_v= inc_v(kl-1,:,:)
   xy_t= inc_t(kl-1,:,:)
   xy_q =inc_q(kl-1,:,:)*1000.

   print(" For XY-plot U Max/Min "+max(xy_u)+" "+min(xy_u))
   print(" For XY-plot V Max/Min "+max(xy_v)+" "+min(xy_v))
   print(" For XY-plot T Max/Min "+max(xy_t)+" "+min(xy_t))
   print(" For XY-plot Q Max/Min "+max(xy_q)+" "+min(xy_q))

   ;********************************************************
   ; create plots  
   ;********************************************************

   plts                      = new (4,"graphic")

   wks = gsn_open_wks(works,expt)           ; ps,pdf,x11,ncgm,eps
   gsn_define_colormap(wks,"gui_default")             ; select color map


   res                       = True                   ; plot mods desired

   res@gsnDraw               = False                   ; (a) do not draw
   res@gsnFrame              = False                   ; (b) do not advance 'frame'

   res@gsnMaximize           = True                   ; uncomment to maximize size

   res@cnFillOn              = True                   ; turn on color
   res@lbLabelFontHeightF    = 0.02 
   res@lbLabelAutoStride     = True            ; let NCL determine label spacing

  res@tfDoNDCOverlay        = True           ; Set True otherwise it will ask for co-ordinates
  res@gsnSpreadColors       = True           ; use entire color map

  res@mpGridAndLimbOn       = True            ; trun on lat/lon lines
  res@pmTickMarkDisplayMode = "Always"        ; turn on tickmarks
  res@tmXTOn = False                          ; turn off top   labels
  res@tmYROn = False                          ; turn off right labels
  res@gsnLeftStringFontHeightF =.04
  res@gsnRightStringFontHeightF =.04


   WRF_map_c(first_guess,res,0)                ; set map resources

   ;*********** Plot the Variables ******************
   res@gsnLeftString         = var1+"("+kl+")"
   res@gsnRightString        = units1                  

   plts(0)                   = gsn_csm_contour_map(wks,xy_u,res)

   res@gsnLeftString         = var2+"("+kl+")"
   res@gsnRightString        = units2                  

   plts(1)                   = gsn_csm_contour_map(wks,xy_v,res)

   res@gsnLeftString         = var3+"("+kl+")"
   res@gsnRightString        = units3                  
   plts(2)                   = gsn_csm_contour_map(wks,xy_t,res)

   res@gsnLeftString         = var4+"("+kl+")"
   res@gsnRightString        = units4                  
   plts(3)                   = gsn_csm_contour_map(wks,xy_q,res)


   ;************************************************
   ; create panel: panel plots have their own set of resources
   ;************************************************
   ;-------------------------------------------------------------------------------
   resP                  = True                   ; modify the panel plot
   resP@gsnFrame = False
   ; resP@gsnPanelBottom = 0.15
   resP@gsnPanelTop = 0.9 
   resP@txFontHeightF = 0.02
   resP@txString         = ""        
   resP@gsnMaximize      = True                   ; maximize panel area
   resP@gsnPanelRowSpec  = True                   ; specify 1 top, 2 lower level
   gsn_panel(wks,plts,(/2,2/),resP)               ; now draw as one plot

   frame(wks)                                     ; now advance frame
   delete ( plts )
   delete ( res  )
   delete ( resP )

;*************************************************************************
; Now create XZ cross-sesction
;*************************************************************************
;
  xlong    = first_guess->XLONG(0,ixlat-1,:)
  xlong@units = "degrees_east"

   xz_u= inc_u(:,ixlat-1,:)
   xz_v= inc_v(:,ixlat-1,:)
   xz_t= inc_t(:,ixlat-1,:)
   xz_q= inc_q(:,ixlat-1,:)*1000.

   print(" For XZ-plot U Max/Min "+max(xz_u)+" "+min(xz_u))
   print(" For XZ-plot V Max/Min "+max(xz_v)+" "+min(xz_v))
   print(" For XZ-plot T Max/Min "+max(xz_t)+" "+min(xz_t))
   print(" For XZ-plot Q Max/Min "+max(xz_q)+" "+min(xz_q))

   xz_u!0 = "lev" 
   xz_v!0 = "lev" 
   xz_t!0 = "lev" 
   xz_q!0 = "lev"
   xz_u!1 = "lon" 
   xz_v!1 = "lon" 
   xz_t!1 = "lon" 
   xz_q!1 = "lon"  

   xz_u&lev = znu   
   xz_v&lev = znu  
   xz_t&lev = znu  
   xz_q&lev = znu
   xz_u&lon = xlong 
   xz_v&lon = xlong
   xz_t&lon = xlong
   xz_q&lon = xlong 

;*************************************************************************
; create plots
;*************************************************************************

  plts                      = new (4,"graphic")

  gsn_define_colormap(wks,"gui_default")           ; select color map

  res                       = True            ; plot mods desired
  res@gsnMaximize           = True            ; uncomment to maximize size

  res@cnFillOn              = True            ; turn on color
  res@gsnSpreadColors       = True            ; use entire color map
  res@lbLabelAutoStride     = True            ; let NCL determine label spacing
  res@trYReverse            = True            ; reverse y axis
  res@tmXBTickSpacingF      = 15.              ; force labeling every 5 deg lon

  res@gsnDraw               = False            ; (a) do not draw
  res@gsnFrame              = False            ; (b) do not advance 'frame'


  res@gsnLeftString         = var1
  res@gsnRightString        = units1                  
  plts(0)                   = gsn_csm_contour(wks,xz_u,res)

  res@gsnLeftString         = var2
  res@gsnRightString        = units2                  
  plts(1)                   = gsn_csm_contour(wks,xz_v,res)

  res@gsnLeftString         = var3
  res@gsnRightString        = units3                  
  plts(2)                   = gsn_csm_contour(wks,xz_t,res)

  res@gsnLeftString         = var4
  res@gsnRightString        = units4                  
  plts(3)                   = gsn_csm_contour(wks,xz_q,res)

;*************************************************************************
; create panel: panel plots have their own set of resources
;*************************************************************************
  resP                  = True                   ; modify the panel plot
  resP@gsnFrame         = False                  ; don't advance panel plot
  resP@gsnMaximize      = True                   ; maximize panel area
  resP@gsnPanelRowSpec  = True                   ; specify 1 top, 2 lower level
  gsn_panel(wks,plts,(/2,2/),resP)               ; now draw as one plot

  frame(wks)                                     ; now advance frame
  delete ( plts )
  delete ( res  )
  delete ( resP )

;*************************************************************************
; Now create YZ cross-sesction
;*************************************************************************
;
  xlatt  = first_guess->XLAT(0,:,ixlon-1)
  xlatt@units = "degrees_north"

   yz_u= inc_u(:,:,ixlon-1)
   yz_v= inc_v(:,:,ixlon-1)
   yz_t= inc_t(:,:,ixlon-1)
   yz_q= inc_q(:,:,ixlon-1)*1000.

   print(" For YZ-plot U Max/Min "+max(yz_u)+" "+min(yz_u))
   print(" For YZ-plot V Max/Min "+max(yz_v)+" "+min(yz_v))
   print(" For YZ-plot T Max/Min "+max(yz_t)+" "+min(yz_t))
   print(" For YZ-plot Q Max/Min "+max(yz_q)+" "+min(yz_q))

   yz_u!0 = "lev" 
   yz_v!0 = "lev" 
   yz_t!0 = "lev" 
   yz_q!0 = "lev"
   yz_u!1 = "lat"
   yz_v!1 = "lat" 
   yz_t!1 = "lat" 
   yz_q!1 = "lat"  

   yz_u&lev = znu   
   yz_v&lev = znu  
   yz_t&lev = znu  
   yz_q&lev = znu
   yz_u&lat = xlatt 
   yz_v&lat = xlatt
   yz_t&lat = xlatt
   yz_q&lat = xlatt 

;*************************************************************************
; create plots
;*************************************************************************

  plts                      = new (4,"graphic")

  gsn_define_colormap(wks,"gui_default")           ; select color map

  res                       = True            ; plot mods desired
  res@gsnMaximize           = True            ; uncomment to maximize size

  res@cnFillOn              = True            ; turn on color
  res@gsnSpreadColors       = True            ; use entire color map
  res@lbLabelAutoStride     = True            ; let NCL determine label spacing
  res@trYReverse            = True            ; reverse y axis
  res@tmXBTickSpacingF      = 15.              ; force labeling every 5 deg lon

  res@gsnDraw               = False            ; (a) do not draw
  res@gsnFrame              = False            ; (b) do not advance 'frame'


  res@gsnLeftString         = var1
  res@gsnRightString        = units1                  
  plts(0)                   = gsn_csm_contour(wks,yz_u,res)

  res@gsnLeftString         = var2
  res@gsnRightString        = units2                  
  plts(1)                   = gsn_csm_contour(wks,yz_v,res)

  res@gsnLeftString         = var3
  res@gsnRightString        = units3                  
  plts(2)                   = gsn_csm_contour(wks,yz_t,res)

  res@gsnLeftString         = var4
  res@gsnRightString        = units4                  
  plts(3)                   = gsn_csm_contour(wks,yz_q,res)

;*************************************************************************
; create panel: panel plots have their own set of resources
;*************************************************************************
  resP                  = True                   ; modify the panel plot
  resP@gsnFrame         = False                  ; don't advance panel plot
  resP@gsnMaximize      = True                   ; maximize panel area
  resP@gsnPanelRowSpec  = True                   ; specify 1 top, 2 lower level
  gsn_panel(wks,plts,(/2,2/),resP)               ; now draw as one plot

  frame(wks)                                     ; now advance frame
  delete ( plts )
  delete ( res  )
  delete ( resP )

end
