!                           DISCLAIMER
!
!   This file was generated by TAF version 1.7.18
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     a_module_advect_em
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use module_bc
use a_module_bc
use module_model_constants
use module_wrf_error
use module_advect_em

USE module_trace, only : trace_entry, trace_exit
#ifdef DM_PARALLEL
use module_dm
#endif

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains

subroutine a_advect_scalar( field, a_field, field_old, a_field_old, a_tendency, ru, a_ru, rv, a_rv, rom, a_rom, config_flags, msft,&
& fzm, fzp, rdx, rdy, rdzw, ids, ide, jds, jde, kds, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_field(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_field_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rom(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_tendency(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: field_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kds
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: rdzw(kms:kme)
real, intent(in) :: rom(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
#ifdef DM_PARALLEL
real a_fqx(its-3:ite+3,kts:kte)
#else
real a_fqx(its:ite+1,kts:kte)
#endif
real a_fqy(its:ite,kts:kte,2)
real a_ub
real a_vb
real a_vel
real a_vflux(its:ite,kts:kte)
logical degrade_xe
logical degrade_xs
logical degrade_ye
logical degrade_ys
integer horz_order
integer i
integer i_end
integer i_end_f
integer i_start
integer i_start_f
integer j
integer j1
integer j2
integer j3
integer j4
integer j_end
integer j_end_f
integer j_start
integer j_start_f
integer jp0
integer jp1
integer jtmp
integer k
integer ktf
real mrdx
real mrdy
logical specified
real ub
real vb
real vel
integer vert_order
#ifdef DM_PARALLEL
integer ips, ipe, jps, jpe, kps, kpe
#endif
integer i_start_l, i_end_l
integer i_start_f_l, i_end_f_l
integer j_start_l, j_end_l
integer j_start_f_l, j_end_f_l
real walls(7),gwalls
real iwalls(ims:ime)
real kwalls(kms:kme)

   call trace_entry("a_advect_scalar")

#ifdef DM_PARALLEL
ips = its
ipe = ite
jps = jts
jpe = jte
kps = kts
kpe = kte
#endif

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_fqx(:,:) = 0.
a_fqy(:,:,:) = 0.
a_vflux(:,:) = 0.
!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
ktf = min(kte,kde-1)
! recompute : ktf
horz_order = config_flags%h_sca_adv_order
! recompute : horz_order
vert_order = config_flags%v_sca_adv_order
! recompute : vert_order
horizontal_order_tesu: if (horz_order .eq. 6) then
  CALL wrf_error_fatal ( ' horz_order == 6 does not pass AD/TL check' )
  ktf = min(kte,kde-1)
else if (horz_order .eq. 5) then horizontal_order_tesu
  ktf = min(kte,kde-1)
else if (horz_order .eq. 4) then horizontal_order_tesu
  CALL wrf_error_fatal ( ' horz_order == 4 does not pass AD/TL check' )
  ktf = min(kte,kde-1)
else if (horz_order .eq. 3) then horizontal_order_tesu
  CALL wrf_error_fatal ( ' horz_order == 3 does not pass AD/TL check' )
  ktf = min(kte,kde-1)
endif horizontal_order_tesu
! recompute : ktf
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
a_vert_order_test: if (vert_order .eq. 6) then
  CALL wrf_error_fatal ( ' vert_order == 6 does not pass AD/TL check' )
  do j = j_end, j_start, -1

    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k)   = a_vflux(i,k)  +a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    walls(3)=fzp(ktf); walls(4)=fzm(ktf)
    walls(5)=fzp(kts+1); walls(6)=fzm(kts+1)

    do i = i_start, i_end
      k = ktf-1
! recompute : k
      vel = rom(i,k,j)
! recompute : vel
      k = ktf
! recompute : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*rom(i,k,j)
      a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*walls(3)
      a_field(i,k,j) = a_field(i,k,j)+walls(2)*walls(4)
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(4)*field(i,k,j)+walls(3)*field(i,k-1,j))
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:3728
! recompute vars : k
      k = ktf-1
! recompute vars : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_field(i,k-2,j) = a_field(i,k-2,j)-0.083333333*walls(2)
      a_field(i,k-1,j) = a_field(i,k-1,j)+0.58333333*walls(2)
      a_field(i,k+1,j) = a_field(i,k+1,j)-0.083333333*walls(2)
      a_field(i,k,j)   = a_field(i,k,j)+0.58333333*walls(2)
      a_vel = walls(1)*(0.58333333*(field(i,k,j)+field(i,k-1,j))-0.083333333*(field(i,k+1,j)+field(i,k-2,j)))
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:3728
! recompute vars : k
      k = ktf-1
! recompute vars : k
      a_rom(i,k,j) = a_rom(i,k,j)+a_vel
!     
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3723
! recompute vars : k
      k = kts+2
! recompute vars : k
! recdepend vars : i,j,k,rom
! recompute pos : ASSIGN_STMT module_advect_em.f90:3724
! recompute vars : vel
      vel = rom(i,k,j)
! recompute vars : vel
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_field(i,k-2,j) = a_field(i,k-2,j)-0.083333333*walls(2)
      a_field(i,k-1,j) = a_field(i,k-1,j)+0.58333333*walls(2)
      a_field(i,k+1,j) = a_field(i,k+1,j)-0.083333333*walls(2)
      a_field(i,k,j)   = a_field(i,k,j)+0.58333333*walls(2)
      a_vel = walls(1)*(0.58333333*(field(i,k,j)+field(i,k-1,j))-0.083333333*(field(i,k+1,j)+field(i,k-2,j)))
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3723
! recompute vars : k
      k = kts+2
! recompute vars : k
      a_rom(i,k,j) = a_rom(i,k,j)+a_vel
!     
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3720
! recompute vars : k
      k = kts+1
! recompute vars : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*rom(i,k,j)
      a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*walls(5)
      a_field(i,k,j)   = a_field(i,k,j)+walls(2)*walls(6)
      a_rom(i,k,j)     = a_rom(i,k,j)+walls(1)*(walls(6)*field(i,k,j)+walls(5)*field(i,k-1,j))
    end do

    a_vflux(i_start:i_end,kts+1:kts+2) = 0.
    a_vflux(i_start:i_end,ktf-1:ktf) = 0.

    do k = kts+3, ktf-2
      do i = i_start, i_end
!       vel = rom(i,k,j)
! recompute : vel
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*rom(i,k,j)

        a_field(i,k-3,j) = a_field(i,k-3,j)+0.016666667*walls(2)
        a_field(i,k-2,j) = a_field(i,k-2,j)-0.13333333*walls(2)
        a_field(i,k-1,j) = a_field(i,k-1,j)+0.61666667*walls(2)
        a_field(i,k+2,j) = a_field(i,k+2,j)+0.016666667*walls(2)
        a_field(i,k+1,j) = a_field(i,k+1,j)-0.13333333*walls(2)
        a_field(i,k,j)   = a_field(i,k,j)+0.61666667*walls(2)
        a_vel = walls(1)*(0.61666667*(field(i,k,j)+field(i,k-1,j))-0.13333333*(field(i,k+1,j)+field(i,k-2,j))+&
&0.016666667*(field(i,k+2,j)+field(i,k-3,j)))
        a_rom(i,k,j) = a_rom(i,k,j)+a_vel
      end do
    end do

  a_vflux(i_start:i_end,kts+3:ktf-2) = 0.

  end do

else if (vert_order .eq. 5) then a_vert_order_test
  CALL wrf_error_fatal ( ' vert_order == 5 does not pass AD/TL check' )
  do j = j_end, j_start, -1
    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k)   = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    walls(3)=fzp(ktf); walls(4)=fzm(ktf)
    walls(5)=fzp(kts+1); walls(6)=fzm(kts+1)

    do i = i_start, i_end
      k = ktf-1
! recompute : k
      vel = rom(i,k,j)
      walls(7)=sign(1.,-vel)
! recompute : vel
      k = ktf
! recompute : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*rom(i,k,j)
      a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*walls(3)
      a_field(i,k,j) = a_field(i,k,j)+walls(2)*walls(4)
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(4)*field(i,k,j)+walls(3)*field(i,k-1,j))
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:3769
! recompute vars : k
      k = ktf-1
! recompute vars : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_field(i,k-2,j) = a_field(i,k-2,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(7))
      a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*(0.58333333+0.25*walls(7))
      a_field(i,k+1,j) = a_field(i,k+1,j)+walls(2)*((-0.083333333)+0.083333333*walls(7))
      a_field(i,k,j)   = a_field(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(7))
      a_vel = walls(1)*(0.58333333*(field(i,k,j)+field(i,k-1,j))-0.083333333*(field(i,k+1,j)+field(i,k-2,j))+0.083333333*&
&(field(i,k+1,j)-field(i,k-2,j)-3.*(field(i,k,j)-field(i,k-1,j)))*walls(7))
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:3769
! recompute vars : k
      k = ktf-1
! recompute vars : k
      a_rom(i,k,j) = a_rom(i,k,j)+a_vel
!     
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3764
! recompute vars : k
      k = kts+2
! recompute vars : k
! recdepend vars : i,j,k,rom
! recompute pos : ASSIGN_STMT module_advect_em.f90:3765
! recompute vars : vel
      vel = rom(i,k,j)
! recompute vars : vel
      walls(7)=sign(1.,-vel)
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_field(i,k-2,j) = a_field(i,k-2,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(7))
      a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*(0.58333333+0.25*walls(7))
      a_field(i,k+1,j) = a_field(i,k+1,j)+walls(2)*((-0.083333333)+0.083333333*walls(7))
      a_field(i,k,j)   = a_field(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(7))
      a_vel = walls(1)*(0.58333333*(field(i,k,j)+field(i,k-1,j))-0.083333333*(field(i,k+1,j)+field(i,k-2,j))+0.083333333*&
&(field(i,k+1,j)-field(i,k-2,j)-3.*(field(i,k,j)-field(i,k-1,j)))*walls(7))
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3764
! recompute vars : k
      k = kts+2
! recompute vars : k
      a_rom(i,k,j) = a_rom(i,k,j)+a_vel
!     
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3761
! recompute vars : k
      k = kts+1
! recompute vars : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*rom(i,k,j)
      a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*walls(5)
      a_field(i,k,j)   = a_field(i,k,j)+walls(2)*walls(6)
      a_rom(i,k,j)     = a_rom(i,k,j)+walls(1)*(walls(6)*field(i,k,j)+walls(5)*field(i,k-1,j))
    end do

    a_vflux(i_start:i_end,kts+1:kts+2) = 0.
    a_vflux(i_start:i_end,ktf-1:ktf) = 0.

    do k = kts+3, ktf-2
      do i = i_start, i_end
        vel = rom(i,k,j)
! recompute : vel
        walls(3)=sign(1.,-vel)
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_field(i,k-3,j) = a_field(i,k-3,j)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
        a_field(i,k-2,j) = a_field(i,k-2,j)+walls(2)*((-0.13333333)-0.083333333*walls(3))
        a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
        a_field(i,k+2,j) = a_field(i,k+2,j)+walls(2)*(0.016666667-0.016666667*walls(3))
        a_field(i,k+1,j) = a_field(i,k+1,j)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
        a_field(i,k,j) = a_field(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
        a_vel = walls(1)*(0.61666667*(field(i,k,j)+field(i,k-1,j))-0.13333333*(field(i,k+1,j)+field(i,k-2,j))+&
&0.016666667*(field(i,k+2,j)+field(i,k-3,j))-0.016666667*(field(i,k+2,j)-field(i,k-3,j)-5.*(field(i,k+1,j)-field(i,k-2,j))+&
&10.*(field(i,k,j)-field(i,k-1,j)))*walls(3))
        a_rom(i,k,j) = a_rom(i,k,j)+a_vel
!       
      end do
    end do

  a_vflux(i_start:i_end,kts+3:ktf-2) = 0.

  end do
else if (vert_order .eq. 4) then a_vert_order_test
  CALL wrf_error_fatal ( ' vert_order == 4 does not pass AD/TL check' )
  do j = j_end, j_start, -1
    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    walls(4)=fzp(kts+1); walls(7)=fzm(kts+1)
    walls(5)=fzp(ktf); walls(6)=fzm(ktf)

    do i = i_start, i_end
      k = ktf
! recompute : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*rom(i,k,j)
      a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*walls(5)
      a_field(i,k,j) = a_field(i,k,j)+walls(2)*walls(6)
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(6)*field(i,k,j)+walls(5)*field(i,k-1,j))
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3802
! recompute vars : k
      k = kts+1
! recompute vars : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*rom(i,k,j)
      a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*walls(4)
      a_field(i,k,j) = a_field(i,k,j)+walls(2)*walls(7)
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(7)*field(i,k,j)+walls(4)*field(i,k-1,j))
    end do

    a_vflux(i_start:i_end,kts+1) = 0.
    a_vflux(i_start:i_end,ktf) = 0.

    do k = kts+2, ktf-1
      do i = i_start, i_end
        vel = rom(i,k,j)
! recompute : vel
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_field(i,k-2,j) = a_field(i,k-2,j)-0.083333333*walls(2)
        a_field(i,k-1,j) = a_field(i,k-1,j)+0.58333333*walls(2)
        a_field(i,k+1,j) = a_field(i,k+1,j)-0.083333333*walls(2)
        a_field(i,k,j) = a_field(i,k,j)+0.58333333*walls(2)
        a_vel = walls(1)*(0.58333333*(field(i,k,j)+field(i,k-1,j))-0.083333333*(field(i,k+1,j)+field(i,k-2,j)))
        a_rom(i,k,j) = a_rom(i,k,j)+a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+2:ktf-1) = 0.

  end do
else if (vert_order .eq. 3) then a_vert_order_test
  do j = j_end, j_start, -1
    do k = kts, ktf
       gwalls=rdzw(k)
!      do i = i_start, i_end
!        a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!        a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!      end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    walls(4)=fzp(kts+1); walls(7)=fzm(kts+1)
    walls(5)=fzp(ktf); walls(6)=fzm(ktf)

    do i = i_start, i_end
      k = ktf
! recompute : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*rom(i,k,j)
      a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*walls(5)
      a_field(i,k,j) = a_field(i,k,j)+walls(2)*walls(6)
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(6)*field(i,k,j)+walls(5)*field(i,k-1,j))
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3831
! recompute vars : k
      k = kts+1
! recompute vars : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*rom(i,k,j)
      a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*walls(4)
      a_field(i,k,j) = a_field(i,k,j)+walls(2)*walls(7)
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(7)*field(i,k,j)+walls(4)*field(i,k-1,j))
    end do

    a_vflux(i_start:i_end,kts+1) = 0.
    a_vflux(i_start:i_end,ktf) = 0.

    do k = kts+2, ktf-1
      do i = i_start, i_end
        vel = rom(i,k,j)
! recompute : vel
        walls(3)=sign(1.,-vel)
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_field(i,k-2,j) = a_field(i,k-2,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_field(i,k+1,j) = a_field(i,k+1,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_field(i,k,j) = a_field(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_vel = walls(1)*(0.58333333*(field(i,k,j)+field(i,k-1,j))-0.083333333*(field(i,k+1,j)+field(i,k-2,j))+&
&0.083333333*(field(i,k+1,j)-field(i,k-2,j)-3.*(field(i,k,j)-field(i,k-1,j)))*walls(3))
        a_rom(i,k,j) = a_rom(i,k,j)+a_vel
      end do
    end do

    a_vflux(i_start:i_end,kts+2:ktf-1) = 0.

  end do
else if (vert_order .eq. 2) then a_vert_order_test
  CALL wrf_error_fatal ( ' vert_order == 2 does not pass AD/TL check' )

  do j = j_start, j_end
    do k = kts, ktf
       gwalls=rdzw(k)
!      do i = i_start, i_end
!        a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!        a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!      end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls

    end do

    do k = kts+1, ktf
      walls(3)=fzp(k); walls(4)=fzm(k)
      do i = i_start, i_end
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*rom(i,k,j)
        a_field(i,k-1,j) = a_field(i,k-1,j)+walls(2)*walls(3)
        a_field(i,k,j) = a_field(i,k,j)+walls(2)*walls(4)
        a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(4)*field(i,k,j)+walls(3)*field(i,k-1,j))
      end do
    end do

    a_vflux(i_start:i_end,kts+1:ktf) = 0.

  end do
endif a_vert_order_test
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:3621
! recompute vars : i_start
i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:3622
! recompute vars : i_end
i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:3624
! recompute vars : j_end
j_end = min(jte,jde-1)
! recompute vars : j_end
if (config_flags%open_ye .and. jte .eq. jde) then
  CALL wrf_error_fatal ( ' open_ye == true does not pass AD/TL check' )
  do k = kts, ktf
    do i = i_start, i_end
      walls(2)=0.5*(rv(i,k,jte-1)+rv(i,k,jte))
      vb = max(walls(2),0.)
! recompute : vb
      walls(1)=a_tendency(i,k,j_end)*rdy
      a_field(i,k,j_end) = a_field(i,k,j_end)-walls(1)*(rv(i,k,jte)-rv(i,k,jte-1))
      a_field_old(i,k,j_end-1) = a_field_old(i,k,j_end-1)+walls(1)*vb
      a_field_old(i,k,j_end) = a_field_old(i,k,j_end)-walls(1)*vb
      a_rv(i,k,jte-1) = a_rv(i,k,jte-1)+walls(1)*field(i,k,j_end)
      a_rv(i,k,jte) = a_rv(i,k,jte)-walls(1)*field(i,k,j_end)
      a_vb = -walls(1)*(field_old(i,k,j_end)-field_old(i,k,j_end-1))
   
      walls(1)=0.5*a_vb*(0.5+sign(0.5,walls(2)))
      a_rv(i,k,jte-1) = a_rv(i,k,jte-1)+walls(1)
      a_rv(i,k,jte)   = a_rv(i,k,jte)  +walls(1)
    end do
  end do
endif
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:3621
! recompute vars : i_start
i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:3622
! recompute vars : i_end
i_end = min(ite,ide-1)
! recompute vars : i_end
if (config_flags%open_ys .and. jts .eq. jds) then
  CALL wrf_error_fatal ( ' open_ys == true does not pass AD/TL check' )
  do k = kts, ktf
    do i = i_start, i_end
      walls(2)=0.5*(rv(i,k,jts)+rv(i,k,jts+1))
      vb = min(walls(2),0.)
! recompute : vb
      walls(1)=a_tendency(i,k,jts)*rdy
      a_field(i,k,jts) = a_field(i,k,jts)-walls(1)*(rv(i,k,jts+1)-rv(i,k,jts))
      a_field_old(i,k,jts+1) = a_field_old(i,k,jts+1)-walls(1)*vb
      a_field_old(i,k,jts)   = a_field_old(i,k,jts)+walls(1)*vb
      a_rv(i,k,jts+1) = a_rv(i,k,jts+1)-walls(1)*field(i,k,jts)
      a_rv(i,k,jts)   = a_rv(i,k,jts)+walls(1)*field(i,k,jts)
      a_vb = -walls(1)*(field_old(i,k,jts+1)-field_old(i,k,jts))

      walls(1)=0.5*a_vb*(0.5+sign(0.5,0.-walls(2)))
      a_rv(i,k,jts+1) = a_rv(i,k,jts+1)+walls(1)
      a_rv(i,k,jts) = a_rv(i,k,jts)    +walls(1)
    end do
  end do
endif
! recdepend vars : ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:3622
! recompute vars : i_end
i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3623
! recompute vars : j_start
j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:3624
! recompute vars : j_end
j_end = min(jte,jde-1)
! recompute vars : j_end
if (config_flags%open_xe .and. ite .eq. ide) then
  CALL wrf_error_fatal ( ' open_xe == true does not pass AD/TL check' )

  do j = j_start, j_end
    do k = kts, ktf
      walls(2)=0.5*(ru(ite-1,k,j)+ru(ite,k,j))
      ub = max(walls(2),0.)
! recompute : ub
      walls(1)=a_tendency(i_end,k,j)*rdx
      a_field(i_end,k,j) = a_field(i_end,k,j)-walls(1)*(ru(ite,k,j)-ru(ite-1,k,j))
      a_field_old(i_end-1,k,j) = a_field_old(i_end-1,k,j)+walls(1)*ub
      a_field_old(i_end,k,j) = a_field_old(i_end,k,j)-walls(1)*ub
      a_ru(ite-1,k,j) = a_ru(ite-1,k,j)+walls(1)*field(i_end,k,j)
      a_ru(ite,k,j) = a_ru(ite,k,j)-walls(1)*field(i_end,k,j)
      a_ub =-walls(1)*(field_old(i_end,k,j)-field_old(i_end-1,k,j))

      walls(1)=0.5*a_ub*(0.5+sign(0.5,walls(2)))
      a_ru(ite-1,k,j) = a_ru(ite-1,k,j)+walls(1)
      a_ru(ite,k,j) = a_ru(ite,k,j)    +walls(1)
    end do
  end do
endif
! recdepend vars : jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3623
! recompute vars : j_start
j_start = jts
! recompute vars : j_start
! recdepend vars : j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:3624
! recompute vars : j_end
j_end = min(jte,jde-1)
! recompute vars : j_end
if (config_flags%open_xs .and. its .eq. ids) then
  CALL wrf_error_fatal ( ' open_xs == true does not pass AD/TL check' )

  do j = j_start, j_end
    do k = kts, ktf
      walls(2)=0.5*(ru(its,k,j)+ru(its+1,k,j))
      ub = min(walls(2),0.)
! recompute : ub
      walls(1)=a_tendency(its,k,j)*rdx
      a_field(its,k,j) = a_field(its,k,j)-walls(1)*(ru(its+1,k,j)-ru(its,k,j))
      a_field_old(its+1,k,j) = a_field_old(its+1,k,j)-walls(1)*ub
      a_field_old(its,k,j) = a_field_old(its,k,j)+walls(1)*ub
      a_ru(its+1,k,j) = a_ru(its+1,k,j)-walls(1)*field(its,k,j)
      a_ru(its,k,j) = a_ru(its,k,j)+walls(1)*field(its,k,j)
      a_ub =-walls(1)*(field_old(its+1,k,j)-field_old(its,k,j))

      walls(1)=0.5*a_ub*(0.5+sign(0.5,0.-walls(2)))
      a_ru(its+1,k,j) = a_ru(its+1,k,j)+walls(1)
      a_ru(its,k,j) = a_ru(its,k,j)    +walls(1)
    end do
  end do
endif
! recdepend vars : kde,kte
! recompute pos : ASSIGN_STMT module_advect_em.f90:2795
! recompute vars : ktf
ktf = min(kte,kde-1)
! recompute vars : ktf
a_horizontal_order_test: if (horz_order .eq. 6) then
  CALL wrf_error_fatal ( ' horz_order == 6 does not pass AD/TL check' )
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-3) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-3) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
! recompute : ktf
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start_f = jds+3
  endif
! recompute : j_start_f
  if (degrade_ye) then
    j_end_f = jde-3
  endif
! recompute : j_end_f
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = i_start+2
  endif
! recompute : i_start,i_start_f
  if (degrade_xe) then
    i_end = min(ide-2,ite)
    i_end_f = ide-3
  endif
! recompute : i_end,i_end_f
  do j = j_end, j_start, -1
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do
    if (degrade_xe) then
      i = ide-2
! recompute : i
      do k = kts, ktf
        vel = ru(i,k,j)
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_field(i-2,k,j) = a_field(i-2,k,j)-0.083333333*walls(2)
        a_field(i-1,k,j) = a_field(i-1,k,j)+0.58333333*walls(2)
        a_field(i+1,k,j) = a_field(i+1,k,j)-0.083333333*walls(2)
        a_field(i,k,j) = a_field(i,k,j)+0.58333333*walls(2)
        a_vel = walls(1)*(0.58333333*(field(i,k,j)+field(i-1,k,j))-0.083333333*(field(i+1,k,j)+field(i-2,k,j)))
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel
      end do
      a_fqx(ide-2,kts:ktf) = 0.

      if (i_end .eq. ide-2) then
        i = ide-1
! recompute : i
        kwalls(kts:ktf)=ru(ide-1,kts:ktf,j)
        do k = kts, ktf
          walls(1)=0.5*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_field(i-1,k,j) = a_field(i-1,k,j)+walls(1)*kwalls(k)
          a_field(i,k,j) = a_field(i,k,j)+walls(1)*kwalls(k)
          a_ru(i,k,j) = a_ru(i,k,j)+walls(1)*(field(i,k,j)+field(i-1,k,j))
        end do
        a_fqx(ide-1,kts:ktf) = 0.

      endif
    endif

    if (degrade_xs) then
      i = ids+2
! recompute : i
      do k = kts, ktf
        vel = ru(i,k,j)
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_field(i-2,k,j) = a_field(i-2,k,j)-0.083333333*walls(2)
        a_field(i-1,k,j) = a_field(i-1,k,j)+0.58333333*walls(2)
        a_field(i+1,k,j) = a_field(i+1,k,j)-0.083333333*walls(2)
        a_field(i,k,j) = a_field(i,k,j)+0.58333333*walls(2)
        a_vel =walls(1)*(0.58333333*(field(i,k,j)+field(i-1,k,j))-0.083333333*(field(i+1,k,j)+field(i-2,k,j)))
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel
      end do
      a_fqx(ids+2,kts:ktf) = 0.

      if (i_start .eq. ids+1) then
        i = ids+1
! recompute : i
        do k = kts, ktf
          walls(1)=0.5*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_field(i-1,k,j) = a_field(i-1,k,j)+walls(1)*ru(i,k,j)
          a_field(i,k,j) = a_field(i,k,j)+walls(1)*ru(i,k,j)
          a_ru(i,k,j) = a_ru(i,k,j)+walls(1)*(field(i,k,j)+field(i-1,k,j))
        end do
        a_fqx(ids+1,kts:ktf) = 0.

      endif
    endif

    do k = kts, ktf
      do i = i_start_f, i_end_f
        vel = ru(i,k,j)
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_field(i-3,k,j) = a_field(i-3,k,j)+0.016666667*walls(2)
        a_field(i-2,k,j) = a_field(i-2,k,j)-0.13333333*walls(2)
        a_field(i-1,k,j) = a_field(i-1,k,j)+0.61666667*walls(2)
        a_field(i+2,k,j) = a_field(i+2,k,j)+0.016666667*walls(2)
        a_field(i+1,k,j) = a_field(i+1,k,j)-0.13333333*walls(2)
        a_field(i,k,j) = a_field(i,k,j)+0.61666667*walls(2)
        a_vel =walls(1)*(0.61666667*(field(i,k,j)+field(i-1,k,j))-0.13333333*(field(i+1,k,j)+field(i-2,k,j))+0.016666667*&
&(field(i+2,k,j)+field(i-3,k,j)))
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel
      end do
    end do
    a_fqx(i_start_f:i_end_f,kts:ktf) = 0.

  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:2833
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:2834
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2835
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:2836
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
! recdepend vars : degrade_ys,i_end,i_start,j_end,j_start,jds,jts
! recompute pos : IF_STMT module_advect_em.f90:2844
! recompute vars : j_start
  if (degrade_ys) then
    j_start = max(jts,jds+1)
  endif
! recompute vars : j_start
! recdepend vars : degrade_ye,i_end,i_start,j_end,j_start,jde,jte
! recompute pos : IF_STMT module_advect_em.f90:2849
! recompute vars : j_end
  if (degrade_ye) then
    j_end = min(jte,jde-2)
  endif
! recompute vars : j_end
  a_j_loop_y_flux_6: do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:2856
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:2857
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    j_loop_y_flux_9c: do j4 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do j_loop_y_flux_9c
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msft(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = rv(i,k,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_field(i,k,j-3) = a_field(i,k,j-3)+0.016666667*walls(2)
          a_field(i,k,j-2) = a_field(i,k,j-2)-0.13333333*walls(2)
          a_field(i,k,j-1) = a_field(i,k,j-1)+0.61666667*walls(2)
          a_field(i,k,j+2) = a_field(i,k,j+2)+0.016666667*walls(2)
          a_field(i,k,j+1) = a_field(i,k,j+1)-0.13333333*walls(2)
          a_field(i,k,j) = a_field(i,k,j)+0.61666667*walls(2)
          a_vel =walls(1)*(0.61666667*(field(i,k,j)+field(i,k,j-1))-0.13333333*(field(i,k,j+1)+field(i,k,j-2))+&
&0.016666667*(field(i,k,j+2)+field(i,k,j-3)))
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel
        end do
      end do
    else if (j .eq. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_field(i,k,j-1) = a_field(i,k,j-1)+walls(1)*rv(i,k,j)
          a_field(i,k,j) = a_field(i,k,j)+walls(1)*rv(i,k,j)
          a_rv(i,k,j) = a_rv(i,k,j)+walls(1)*(field(i,k,j)+field(i,k,j-1))
        end do
      end do
    else if (j .eq. jds+2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = rv(i,k,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_field(i,k,j-2) = a_field(i,k,j-2)-0.083333333*walls(2)
          a_field(i,k,j-1) = a_field(i,k,j-1)+0.58333333*walls(2)
          a_field(i,k,j+1) = a_field(i,k,j+1)-0.083333333*walls(2)
          a_field(i,k,j) = a_field(i,k,j)+0.58333333*walls(2)
          a_vel =walls(1)*(0.58333333*(field(i,k,j)+field(i,k,j-1))-0.083333333*(field(i,k,j+1)+field(i,k,j-2)))
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel
        end do
      end do
    else if (j .eq. jde-1) then
      do k = kts, ktf
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_field(i,k,j-1) = a_field(i,k,j-1)+walls(1)*rv(i,k,j)
          a_field(i,k,j) = a_field(i,k,j)+walls(1)*rv(i,k,j)
          a_rv(i,k,j) = a_rv(i,k,j)+walls(1)*(field(i,k,j)+field(i,k,j-1))
        end do
      end do
    else if (j .eq. jde-2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = rv(i,k,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_field(i,k,j-2) = a_field(i,k,j-2)-0.083333333*walls(2)
          a_field(i,k,j-1) = a_field(i,k,j-1)+0.58333333*walls(2)
          a_field(i,k,j+1) = a_field(i,k,j+1)-0.083333333*walls(2)
          a_field(i,k,j) = a_field(i,k,j)+0.58333333*walls(2)
          a_vel =walls(1)*(0.58333333*(field(i,k,j)+field(i,k,j-1))-0.083333333*(field(i,k,j+1)+field(i,k,j-2)))
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel
        end do
      end do
    endif
  end do a_j_loop_y_flux_6
else if (horz_order .eq. 5) then a_horizontal_order_test
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-3) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-3) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
! ktf=MIN(kte,kde-1)  !ADDED BY WALLS
! recompute : ktf
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
!   j_start = MAX(jts,jds+1)     !ADDED BY WALLS
    j_start_f = jds+3
  endif
! recompute : j_start_f
  if (degrade_ye) then
!   j_end = MIN(jte,jde-2)   !ADDED BY WALLS
    j_end_f = jde-3
  endif
! recompute : j_end_f
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f

  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = i_start+2
    i_start_l = i_start
    i_start_f_l = i_start_f
  else
    i_start_l = i_start - 3
    i_start_f_l = i_start_f - 2
  endif

! recompute : i_start,i_start_f
  if (degrade_xe) then
    i_end = min(ide-2,ite)
    i_end_f = ide-3
    i_end_l = i_end
    i_end_f_l = i_end_f
  else
    i_end_l = i_end + 3
    i_end_f_l = i_end_f + 2
  endif
#ifdef DM_PARALLEL
!xinzhang parallel tunning
#include "HALO_ADJ_ADVECT_SCALAR.inc"
#endif
! recompute : i_end,i_end_f




  do j = j_end, j_start, -1
    do k = kts, ktf
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!     do i = i_start_l, i_end_l
      do i = i_start, i_end   !ADDED BY WALLS
        mrdx = msft(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do



    if (degrade_xe) then
      i = ide-2
! recompute : i
      do k = kts, ktf
        vel = ru(i,k,j)
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_field(i-2,k,j) = a_field(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_field(i-1,k,j) = a_field(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_field(i+1,k,j) = a_field(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_field(i,k,j) = a_field(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_vel =walls(1)*(0.58333333*(field(i,k,j)+field(i-1,k,j))-0.083333333*(field(i+1,k,j)+field(i-2,k,j))+0.083333333*&
&(field(i+1,k,j)-field(i-2,k,j)-3.*(field(i,k,j)-field(i-1,k,j)))*walls(3))
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel
      end do
      if (i_end .eq. ide-2) then
        i = ide-1
! recompute : i
        kwalls(kts:ktf)=ru(ide-1,kts:ktf,j)
        do k = kts, ktf
          walls(1)=0.5*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_field(i-1,k,j) = a_field(i-1,k,j)+walls(1)*kwalls(k)
          a_field(i,k,j) = a_field(i,k,j)+walls(1)*kwalls(k)
          a_ru(i,k,j) = a_ru(i,k,j)+walls(1)*(field(i,k,j)+field(i-1,k,j))
        end do
        a_fqx(ide-1,kts:ktf) = 0.

      endif
    endif
    if (degrade_xs) then
      i = ids+2
! recompute : i
      do k = kts, ktf
        vel = ru(i,k,j)
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_field(i-2,k,j) = a_field(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_field(i-1,k,j) = a_field(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_field(i+1,k,j) = a_field(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_field(i,k,j) = a_field(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_vel =walls(1)*(0.58333333*(field(i,k,j)+field(i-1,k,j))-0.083333333*(field(i+1,k,j)+field(i-2,k,j))+0.083333333*&
&(field(i+1,k,j)-field(i-2,k,j)-3.*(field(i,k,j)-field(i-1,k,j)))*walls(3))
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel
      end do
      if (i_start .eq. ids+1) then
        i = ids+1
! recompute : i
        kwalls(kts:ktf)=ru(ids+1,kts:ktf,j)
        do k = kts, ktf
          walls(1)=0.5*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_field(i-1,k,j) = a_field(i-1,k,j)+walls(1)*kwalls(k)
          a_field(i,k,j) = a_field(i,k,j)+walls(1)*kwalls(k)
          a_ru(i,k,j) = a_ru(i,k,j)+walls(1)*(field(i,k,j)+field(i-1,k,j))
        end do
        a_fqx(ids+1,kts:ktf) = 0.

      endif
    endif
    do k = kts, ktf
!     do i = i_start_f_l, i_end_f_l
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
        DO i = i_start_f, i_end_f  !ADDED BY WALLS
        vel = ru(i,k,j)
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_field(i-3,k,j) = a_field(i-3,k,j)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
        a_field(i-2,k,j) = a_field(i-2,k,j)+walls(2)*((-0.13333333)-0.083333333*walls(3))
        a_field(i-1,k,j) = a_field(i-1,k,j)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
        a_field(i+2,k,j) = a_field(i+2,k,j)+walls(2)*(0.016666667-0.016666667*walls(3))
        a_field(i+1,k,j) = a_field(i+1,k,j)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
        a_field(i,k,j) = a_field(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
        a_vel =walls(1)*(0.61666667*(field(i,k,j)+field(i-1,k,j))-0.13333333*(field(i+1,k,j)+field(i-2,k,j))+0.016666667*&
&(field(i+2,k,j)+field(i-3,k,j))-0.016666667*(field(i+2,k,j)-field(i-3,k,j)-5.*(field(i+1,k,j)-field(i-2,k,j))+10.*&
&(field(i,k,j)-field(i-1,k,j)))*walls(3))
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel
      end do
    end do
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:3057
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:3058
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3059
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:3060
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
! recdepend vars : degrade_ys,i_end,i_start,j_end,j_start,jds,jts
! recompute pos : IF_STMT module_advect_em.f90:3068
! recompute vars : j_start
  if (degrade_ys) then
    j_start = max(jts,jds+1)
    j_start_l = j_start
    j_start_f_l = j_start_f
  else
    j_start_l = j_start - 2
    j_start_f_l = j_start_f - 2
  endif
! recompute vars : j_start
! recdepend vars : degrade_ye,i_end,i_start,j_end,j_start,jde,jte
! recompute pos : IF_STMT module_advect_em.f90:3073
! recompute vars : j_end
  if (degrade_ye) then
    j_end = min(jte,jde-2)
    j_end_l = j_end
    j_end_f_l = j_end_f
  else
    j_end_l = j_end + 3
    j_end_f_l = j_end_f + 3
  endif
! recompute vars : j_end
  a_j_loop_y_flux_5: do j = j_end_l+1, j_start_l, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:3080
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:3081
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    j_loop_y_flux_9a: do j1 = jds+1, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do j_loop_y_flux_9a
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msft(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
!   if (j .ge. j_start_f_l .and. j .le. j_end_f_l) then
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
    if (j .ge. j_start_f .and. j .le. j_end_f) then    !ADDED BY WALLS
      do k = kts, ktf
        do i = i_start, i_end
          vel = rv(i,k,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_field(i,k,j-3) = a_field(i,k,j-3)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
          a_field(i,k,j-2) = a_field(i,k,j-2)+walls(2)*((-0.13333333)-0.083333333*walls(3))
          a_field(i,k,j-1) = a_field(i,k,j-1)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
          a_field(i,k,j+2) = a_field(i,k,j+2)+walls(2)*(0.016666667-0.016666667*walls(3))
          a_field(i,k,j+1) = a_field(i,k,j+1)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
          a_field(i,k,j) = a_field(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
          a_vel =walls(1)*(0.61666667*(field(i,k,j)+field(i,k,j-1))-0.13333333*(field(i,k,j+1)+field(i,k,j-2))+&
&0.016666667*(field(i,k,j+2)+field(i,k,j-3))-0.016666667*(field(i,k,j+2)-field(i,k,j-3)-5.*(field(i,k,j+1)-field(i,k,j-2)&
&)+10.*(field(i,k,j)-field(i,k,j-1)))*walls(3))
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel
        end do
      end do
    else if (j .eq. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_field(i,k,j-1) = a_field(i,k,j-1)+walls(1)*rv(i,k,j)
          a_field(i,k,j) = a_field(i,k,j)+walls(1)*rv(i,k,j)
          a_rv(i,k,j) = a_rv(i,k,j)+walls(1)*(field(i,k,j)+field(i,k,j-1))
        end do
      end do
    else if (j .eq. jds+2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = rv(i,k,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_field(i,k,j-2) = a_field(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
          a_field(i,k,j-1) = a_field(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
          a_field(i,k,j+1) = a_field(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
          a_field(i,k,j) = a_field(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
          a_vel =walls(1)*(0.58333333*(field(i,k,j)+field(i,k,j-1))-0.083333333*(field(i,k,j+1)+field(i,k,j-2))+&
&0.083333333*(field(i,k,j+1)-field(i,k,j-2)-3.*(field(i,k,j)-field(i,k,j-1)))*walls(3))
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel
        end do
      end do
    else if (j .eq. jde-1) then
      do k = kts, ktf
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_field(i,k,j-1) = a_field(i,k,j-1)+walls(1)*rv(i,k,j)
          a_field(i,k,j) = a_field(i,k,j)+walls(1)*rv(i,k,j)
          a_rv(i,k,j) = a_rv(i,k,j)+walls(1)*(field(i,k,j)+field(i,k,j-1))
        end do
      end do
    else if (j .eq. jde-2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = rv(i,k,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_field(i,k,j-2) = a_field(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
          a_field(i,k,j-1) = a_field(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
          a_field(i,k,j+1) = a_field(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
          a_field(i,k,j) = a_field(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
          a_vel =walls(1)*(0.58333333*(field(i,k,j)+field(i,k,j-1))-0.083333333*(field(i,k,j+1)+field(i,k,j-2))+&
&0.083333333*(field(i,k,j+1)-field(i,k,j-2)-3.*(field(i,k,j)-field(i,k,j-1)))*walls(3))
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel
        end do
      end do
    endif
  end do a_j_loop_y_flux_5
else if (horz_order .eq. 4) then a_horizontal_order_test
  CALL wrf_error_fatal ( ' horz_order == 4 does not pass AD/TL check' )
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
! recompute : ktf
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
! recompute : i_start_f
  if (degrade_xe) then
    i_end_f = ide-2
  endif
! recompute : i_end_f
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start = jds+1
    j_start_f = j_start+1
  endif
! recompute : j_start,j_start_f
  if (degrade_ye) then
    j_end = jde-2
    j_end_f = jde-2
  endif
! recompute : j_end,j_end_f
  do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:3365
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:3366
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    do j2 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msft(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .lt. j_start_f .and. degrade_ys) then
      do k = kts, ktf
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_field(i,k,j_start-1) = a_field(i,k,j_start-1)+walls(1)*rv(i,k,j_start)
          a_field(i,k,j_start) = a_field(i,k,j_start)+walls(1)*rv(i,k,j_start)
          a_rv(i,k,j_start) = a_rv(i,k,j_start)+walls(1)*(field(i,k,j_start)+field(i,k,j_start-1))
        end do
      end do
    else if (j .gt. j_end_f .and. degrade_ye) then
      do k = kts, ktf
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_field(i,k,j_end+1) = a_field(i,k,j_end+1)+walls(1)*rv(i,k,j_end+1)
          a_field(i,k,j_end) = a_field(i,k,j_end)+walls(1)*rv(i,k,j_end+1)
          a_rv(i,k,j_end+1) = a_rv(i,k,j_end+1)+walls(1)*(field(i,k,j_end+1)+field(i,k,j_end))
        end do
      end do
    else
      do k = kts, ktf
        do i = i_start, i_end
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*rv(i,k,j)
          a_field(i,k,j-2) = a_field(i,k,j-2)-0.083333333*walls(2)
          a_field(i,k,j-1) = a_field(i,k,j-1)+0.58333333*walls(2)
          a_field(i,k,j+1) = a_field(i,k,j+1)-0.083333333*walls(2)
          a_field(i,k,j) = a_field(i,k,j)+0.58333333*walls(2)
          a_rv(i,k,j) = a_rv(i,k,j)+walls(1)*(0.58333333*(field(i,k,j)+field(i,k,j-1))-0.083333333*(field(i,k,j+1)+field(i,k,&
&j-2)))
        end do
      end do
    endif
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:3278
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:3279
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3280
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:3281
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
! recdepend vars : degrade_xs,i_end,i_start,ids,j_end,j_start
! recompute pos : IF_STMT module_advect_em.f90:3289
! recompute vars : i_start
  if (degrade_xs) then
    i_start = ids+1
  endif
! recompute vars : i_start
! recdepend vars : degrade_xe,i_end,i_start,ide,j_end,j_start
! recompute pos : IF_STMT module_advect_em.f90:3294
! recompute vars : i_end
  if (degrade_xe) then
    i_end = ide-2
  endif
! recompute vars : i_end
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do
    if (degrade_xe) then
      kwalls(kts:ktf)=ru(i_end+1,kts:ktf,j)
      do k = kts, ktf
        walls(1) =0.5*a_fqx(i_end+1,k); a_fqx(i_end+1,k)= 0.
        a_field(i_end+1,k,j) = a_field(i_end+1,k,j)+walls(1)*kwalls(k)
        a_field(i_end,k,j) = a_field(i_end,k,j)+walls(1)*kwalls(k)
        a_ru(i_end+1,k,j) = a_ru(i_end+1,k,j)+walls(1)*(field(i_end+1,k,j)+field(i_end,k,j))
      end do
    endif
    if (degrade_xs) then
      kwalls(kts:ktf)=ru(i_start,kts:ktf,j)
      do k = kts, ktf
        walls(1) =0.5*a_fqx(i_start,k); a_fqx(i_start,k) = 0.
        a_field(i_start-1,k,j) = a_field(i_start-1,k,j)+walls(1)*kwalls(k)
        a_field(i_start,k,j) = a_field(i_start,k,j)+walls(1)*kwalls(k)
        a_ru(i_start,k,j) = a_ru(i_start,k,j)+walls(1)*(field(i_start,k,j)+field(i_start-1,k,j))
      end do
    endif
    do k = kts, ktf
      do i = i_start_f, i_end_f
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*ru(i,k,j)
        a_field(i-2,k,j) = a_field(i-2,k,j)-0.083333333*walls(2)
        a_field(i-1,k,j) = a_field(i-1,k,j)+0.58333333*walls(2)
        a_field(i+1,k,j) = a_field(i+1,k,j)-0.083333333*walls(2)
        a_field(i,k,j) = a_field(i,k,j)+0.58333333*walls(2)
        a_ru(i,k,j) = a_ru(i,k,j)+walls(1)*(0.58333333*(field(i,k,j)+field(i-1,k,j))-0.083333333*(field(i+1,k,j)+field(i-2,k,j)))
      end do
    end do
  end do
else if (horz_order .eq. 3) then a_horizontal_order_test
  CALL wrf_error_fatal ( ' horz_order == 3 does not pass AD/TL check' )
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
! recompute : ktf
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
! recompute : i_start_f
  if (degrade_xe) then
    i_end_f = ide-2
  endif
! recompute : i_end_f
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start = jds+1
    j_start_f = j_start+1
  endif
! recompute : j_start,j_start_f
  if (degrade_ye) then
    j_end = jde-2
    j_end_f = jde-2
  endif
! recompute : j_end,j_end_f
  do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:3525
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:3526
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    do j3 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msft(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .lt. j_start_f .and. degrade_ys) then
      do k = kts, ktf
        do i = i_start, i_end
          gwalls =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_field(i,k,j_start-1) = a_field(i,k,j_start-1)+gwalls*rv(i,k,j_start)
          a_field(i,k,j_start) = a_field(i,k,j_start)+gwalls*rv(i,k,j_start)
          a_rv(i,k,j_start) = a_rv(i,k,j_start)+gwalls*(field(i,k,j_start)+field(i,k,j_start-1))
        end do
      end do
    else if (j .gt. j_end_f .and. degrade_ye) then
      do k = kts, ktf
        do i = i_start, i_end
          gwalls =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_field(i,k,j_end+1) = a_field(i,k,j_end+1)+gwalls*rv(i,k,j_end+1)
          a_field(i,k,j_end) = a_field(i,k,j_end)+gwalls*rv(i,k,j_end+1)
          a_rv(i,k,j_end+1) = a_rv(i,k,j_end+1)+gwalls*(field(i,k,j_end+1)+field(i,k,j_end))
        end do
      end do
    else
      do k = kts, ktf
        do i = i_start, i_end
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*rv(i,k,j)
          a_field(i,k,j-2) = a_field(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*sign(1.,rv(i,k,j)))
          a_field(i,k,j-1) = a_field(i,k,j-1)+walls(2)*(0.58333333+0.25*sign(1.,rv(i,k,j)))
          a_field(i,k,j+1) = a_field(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*sign(1.,rv(i,k,j)))
          a_field(i,k,j) = a_field(i,k,j)+walls(2)*(0.58333333+(-0.25)*sign(1.,rv(i,k,j)))
          a_rv(i,k,j) = a_rv(i,k,j)+walls(1)*(0.58333333*(field(i,k,j)+field(i,k,j-1))-0.083333333*(field(i,k,j+1)+field(i,k,&
&j-2))+0.083333333*(field(i,k,j+1)-field(i,k,j-2)-3.*(field(i,k,j)-field(i,k,j-1)))*sign(1.,rv(i,k,j)))
        end do
      end do
    endif
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:3438
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:3439
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3440
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:3441
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
! recdepend vars : degrade_xs,i_end,i_start,ids,j_end,j_start
! recompute pos : IF_STMT module_advect_em.f90:3449
! recompute vars : i_start
  if (degrade_xs) then
    i_start = ids+1
  endif
! recompute vars : i_start
! recdepend vars : degrade_xe,i_end,i_start,ide,j_end,j_start
! recompute pos : IF_STMT module_advect_em.f90:3454
! recompute vars : i_end
  if (degrade_xe) then
    i_end = ide-2
  endif
! recompute vars : i_end
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do
    if (degrade_xe) then
      kwalls(kts:ktf)=ru(i_end+1,kts:ktf,j)
      do k = kts, ktf
        gwalls =0.5*a_fqx(i_end+1,k); a_fqx(i_end+1,k)= 0.
        a_field(i_end+1,k,j) = a_field(i_end+1,k,j)+gwalls*kwalls(k)
        a_field(i_end,k,j) = a_field(i_end,k,j)+gwalls*kwalls(k)
        a_ru(i_end+1,k,j) = a_ru(i_end+1,k,j)+gwalls*(field(i_end+1,k,j)+field(i_end,k,j))
      end do
    endif
    if (degrade_xs) then
      kwalls(kts:ktf)=ru(i_start,kts:ktf,j)
      do k = kts, ktf
        gwalls =0.5*a_fqx(i_start,k); a_fqx(i_start,k) = 0.
        a_field(i_start-1,k,j) = a_field(i_start-1,k,j)+gwalls*kwalls(k)
        a_field(i_start,k,j) = a_field(i_start,k,j)+gwalls*kwalls(k)
        a_ru(i_start,k,j) = a_ru(i_start,k,j)+gwalls*(field(i_start,k,j)+field(i_start-1,k,j))
      end do
    endif
    do k = kts, ktf
      do i = i_start_f, i_end_f
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*ru(i,k,j)
        a_field(i-2,k,j) = a_field(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*sign(1.,ru(i,k,j)))
        a_field(i-1,k,j) = a_field(i-1,k,j)+walls(2)*(0.58333333+0.25*sign(1.,ru(i,k,j)))
        a_field(i+1,k,j) = a_field(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*sign(1.,ru(i,k,j)))
        a_field(i,k,j) = a_field(i,k,j)+walls(2)*(0.58333333+(-0.25)*sign(1.,ru(i,k,j)))
        a_ru(i,k,j) = a_ru(i,k,j)+walls(1)*(0.58333333*(field(i,k,j)+field(i-1,k,j))-0.083333333*(field(i+1,k,j)+field(i-2,k,j))+&
&0.083333333*(field(i+1,k,j)-field(i-2,k,j)-3.*(field(i,k,j)-field(i-1,k,j)))*sign(1.,ru(i,k,j)))
      end do
    end do
  end do
else if (horz_order .eq. 2) then a_horizontal_order_test
  CALL wrf_error_fatal ( ' horz_order == 2 does not pass AD/TL check' )
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
! recompute : j_start
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-2,jte)
  endif
! recompute : j_end
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdy = msft(i,j)*rdy
! recompute : mrdy
        gwalls=0.5*a_tendency(i,k,j)*mrdy
        a_field(i,k,j-1) = a_field(i,k,j-1)+gwalls*rv(i,k,j)
        a_field(i,k,j+1) = a_field(i,k,j+1)-gwalls*rv(i,k,j+1)
        a_field(i,k,j) = a_field(i,k,j)-gwalls*(rv(i,k,j+1)-rv(i,k,j))
        a_rv(i,k,j+1) = a_rv(i,k,j+1)-gwalls*(field(i,k,j+1)+field(i,k,j))
        a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(field(i,k,j)+field(i,k,j-1))
      end do
    end do
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:3574
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:3575
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:3576
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:3577
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
!  recdepend vars : config_flags,i_end,i_start,ids,its,j_end,j_start,spe
! cified
! recompute pos : IF_STMT module_advect_em.f90:3579
! recompute vars : i_start
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
! recompute vars : i_start
!  recdepend vars : config_flags,i_end,i_start,ide,ite,j_end,j_start,spe
! cified
! recompute pos : IF_STMT module_advect_em.f90:3580
! recompute vars : i_end
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-2,ite)
  endif
! recompute vars : i_end
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
! recompute : mrdx
        gwalls=0.5*a_tendency(i,k,j)*mrdx
        a_field(i-1,k,j) = a_field(i-1,k,j)+gwalls*ru(i,k,j)
        a_field(i+1,k,j) = a_field(i+1,k,j)-gwalls*ru(i+1,k,j)
        a_field(i,k,j) = a_field(i,k,j)-gwalls*(ru(i+1,k,j)-ru(i,k,j))
        a_ru(i+1,k,j) = a_ru(i+1,k,j)-gwalls*(field(i+1,k,j)+field(i,k,j))
        a_ru(i,k,j) = a_ru(i,k,j)+gwalls*(field(i,k,j)+field(i-1,k,j))
      end do
    end do
  end do
endif a_horizontal_order_test

   call trace_exit("a_advect_scalar")

end subroutine a_advect_scalar


subroutine a_advect_u( u, a_u, u_old, a_u_old, a_tendency, ru, a_ru, rv, a_rv, rom, a_rom, mut, a_mut, config_flags, msfu, fzm, &
&fzp, rdx, rdy, rdzw, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: a_mut(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_rom(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_tendency(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u_old(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: rdzw(kms:kme)
real, intent(in) :: rom(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u_old(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_dvm
real a_dvp
real a_fqx(its-1:ite+1,kts:kte)
real a_fqy(its:ite,kts:kte,2)
real a_ub
real a_vb
real a_vel
real a_vflux(its:ite,kts:kte)
real a_vw
logical degrade_xe
logical degrade_xs
logical degrade_ye
logical degrade_ys
real dvm
real dvp
integer horz_order
integer i
integer i_end
integer i_end_f
integer i_start
integer i_start_f
integer im
integer imax
integer imin
integer ip
integer j
integer j1
integer j2
integer j3
integer j4
integer j_end
integer j_end_f
integer j_start
integer j_start_f
integer jp0
integer jp1
integer jtmp
integer k
integer ktf
real mrdx
real mrdy
logical specified
real ub
real vb
real vel
integer vert_order
real vw
real walls(7),gwalls
real iwalls(ims:ime)
real kwalls(kms:kme)

   call trace_entry("a_advect_u")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_fqx(:,:) = 0.
a_fqy(:,:,:) = 0.
a_vflux(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
horz_order = config_flags%h_mom_adv_order
! recompute : horz_order
vert_order = config_flags%v_mom_adv_order
! recompute : vert_order
ktf = min(kte,kde-1)
! recompute : ktf
imin = ids
! recompute : imin
imax = ide-1
! recompute : imax
if (config_flags%open_xs) then
  imin = ids
endif
! recompute : imin
if (config_flags%open_xe) then
  imax = ide-1
endif
! recompute : imax
i_start = its
! recompute : i_start
i_end = ite
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
if (config_flags%open_ys .or. specified) then
  i_start = max(ids+1,its)
endif
! recompute : i_start
if (config_flags%open_ye .or. specified) then
  i_end = min(ide-1,ite)
endif
! recompute : i_end
a_vert_order_test: if (vert_order .eq. 6) then
  do j = j_end, j_start, -1
    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls

    end do

    walls(3)=fzp(kts+1); walls(4)=fzm(kts+1)
    walls(5)=fzp(ktf); walls(6)=fzm(ktf)

    do i = i_start, i_end
      
      k = ktf-1
! recompute : k
      vel = 0.5*(rom(i,k,j)+rom(i-1,k,j))
! recompute : vel
      k = ktf
! recompute : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i-1,k,j) = a_rom(i-1,k,j)+walls(1)*(walls(6)*u(i,k,j)+walls(5)*u(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(6)*u(i,k,j)+walls(5)*u(i,k-1,j))
      a_u(i,k-1,j) = a_u(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(5)
      a_u(i,k,j) = a_u(i,k,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(6)
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:1251
! recompute vars : k
      k = ktf-1
! recompute vars : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_u(i,k-2,j) = a_u(i,k-2,j)-0.083333333*walls(2)
      a_u(i,k-1,j) = a_u(i,k-1,j)+0.58333333*walls(2)
      a_u(i,k+1,j) = a_u(i,k+1,j)-0.083333333*walls(2)
      a_u(i,k,j) = a_u(i,k,j)+0.58333333*walls(2)
      a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i,k-1,j))-0.083333333*(u(i,k+1,j)+u(i,k-2,j)))
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:1251
! recompute vars : k
      k = ktf-1
! recompute vars : k
      a_rom(i-1,k,j) = a_rom(i-1,k,j)+0.5*a_vel
      a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1246
! recompute vars : k
      k = kts+2
! recompute vars : k
! recdepend vars : i,j,k,rom
! recompute pos : ASSIGN_STMT module_advect_em.f90:1247
! recompute vars : vel
      vel = 0.5*(rom(i,k,j)+rom(i-1,k,j))
! recompute vars : vel
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_u(i,k-2,j) = a_u(i,k-2,j)-0.083333333*walls(2)
      a_u(i,k-1,j) = a_u(i,k-1,j)+0.58333333*walls(2)
      a_u(i,k+1,j) = a_u(i,k+1,j)-0.083333333*walls(2)
      a_u(i,k,j) = a_u(i,k,j)+0.58333333*walls(2)
      a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i,k-1,j))-0.083333333*(u(i,k+1,j)+u(i,k-2,j)))
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1246
! recompute vars : k
      k = kts+2
! recompute vars : k
      a_rom(i-1,k,j) = a_rom(i-1,k,j)+0.5*a_vel
      a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1243
! recompute vars : k
      k = kts+1
! recompute vars : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i-1,k,j) = a_rom(i-1,k,j)+walls(1)*(walls(4)*u(i,k,j)+walls(3)*u(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(4)*u(i,k,j)+walls(3)*u(i,k-1,j))
      a_u(i,k-1,j) = a_u(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(3)
      a_u(i,k,j) = a_u(i,k,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(4)
    end do

    a_vflux(i_start:i_end,kts+1:kts+2) = 0.
    a_vflux(i_start:i_end,ktf-1:ktf) = 0.

    do k = kts+3, ktf-2
      do i = i_start, i_end
        vel = 0.5*(rom(i-1,k,j)+rom(i,k,j))
! recompute : vel
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_u(i,k-3,j) = a_u(i,k-3,j)+0.016666667*walls(2)
        a_u(i,k-2,j) = a_u(i,k-2,j)-0.13333333*walls(2)
        a_u(i,k-1,j) = a_u(i,k-1,j)+0.61666667*walls(2)
        a_u(i,k+2,j) = a_u(i,k+2,j)+0.016666667*walls(2)
        a_u(i,k+1,j) = a_u(i,k+1,j)-0.13333333*walls(2)
        a_u(i,k,j) = a_u(i,k,j)+0.61666667*walls(2)
        a_vel =walls(1)*(0.61666667*(u(i,k,j)+u(i,k-1,j))-0.13333333*(u(i,k+1,j)+u(i,k-2,j))+0.016666667*(u(i,k+2,j)+&
&u(i,k-3,j)))
        a_rom(i-1,k,j) = a_rom(i-1,k,j)+0.5*a_vel
        a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+3:ktf-2) = 0.
  end do
else if (vert_order .eq. 5) then a_vert_order_test
  do j = j_end, j_start, -1
    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    walls(4)=fzp(kts+1); walls(7)=fzm(kts+1)
    walls(5)=fzp(ktf); walls(6)=fzm(ktf)

    do i = i_start, i_end
      k = ktf-1
! recompute : k
      vel = 0.5*(rom(i,k,j)+rom(i-1,k,j))
      walls(3)=sign(1.,-vel)
! recompute : vel
      k = ktf
! recompute : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i-1,k,j) = a_rom(i-1,k,j)+walls(1)*(walls(6)*u(i,k,j)+walls(5)*u(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(6)*u(i,k,j)+walls(5)*u(i,k-1,j))
      a_u(i,k-1,j) = a_u(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(5)
      a_u(i,k,j) = a_u(i,k,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(6)
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:1291
! recompute vars : k
      k = ktf-1
! recompute vars : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_u(i,k-2,j) = a_u(i,k-2,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
      a_u(i,k-1,j) = a_u(i,k-1,j)+walls(2)*(0.58333333+0.25*walls(3))
      a_u(i,k+1,j) = a_u(i,k+1,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
      a_u(i,k,j) = a_u(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
      a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i,k-1,j))-0.083333333*(u(i,k+1,j)+u(i,k-2,j))+0.083333333*(u(i,k+1,j)-u(i,&
&k-2,j)-3.*(u(i,k,j)-u(i,k-1,j)))*walls(3))
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:1291
! recompute vars : k
      k = ktf-1
! recompute vars : k
      a_rom(i-1,k,j) = a_rom(i-1,k,j)+0.5*a_vel
      a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1286
! recompute vars : k
      k = kts+2
! recompute vars : k
! recdepend vars : i,j,k,rom
! recompute pos : ASSIGN_STMT module_advect_em.f90:1287
! recompute vars : vel
      vel = 0.5*(rom(i,k,j)+rom(i-1,k,j))
! recompute vars : vel
      walls(3)=sign(1.,-vel)
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_u(i,k-2,j) = a_u(i,k-2,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
      a_u(i,k-1,j) = a_u(i,k-1,j)+walls(2)*(0.58333333+0.25*walls(3))
      a_u(i,k+1,j) = a_u(i,k+1,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
      a_u(i,k,j) = a_u(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
      a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i,k-1,j))-0.083333333*(u(i,k+1,j)+u(i,k-2,j))+0.083333333*(u(i,k+1,j)-u(i,&
&k-2,j)-3.*(u(i,k,j)-u(i,k-1,j)))*walls(3))
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1286
! recompute vars : k
      k = kts+2
! recompute vars : k
      a_rom(i-1,k,j) = a_rom(i-1,k,j)+0.5*a_vel
      a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1283
! recompute vars : k
      k = kts+1
! recompute vars : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i-1,k,j) = a_rom(i-1,k,j)+walls(1)*(walls(7)*u(i,k,j)+walls(4)*u(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(7)*u(i,k,j)+walls(4)*u(i,k-1,j))
      a_u(i,k-1,j) = a_u(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(4)
      a_u(i,k,j) = a_u(i,k,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(7)
    end do

    a_vflux(i_start:i_end,kts+1:kts+2) = 0.
    a_vflux(i_start:i_end,ktf-1:ktf) = 0.

    do k = kts+3, ktf-2
      do i = i_start, i_end
        vel = 0.5*(rom(i-1,k,j)+rom(i,k,j))
! recompute : vel
        walls(3)=sign(1.,-vel)
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_u(i,k-3,j) = a_u(i,k-3,j)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
        a_u(i,k-2,j) = a_u(i,k-2,j)+walls(2)*((-0.13333333)-0.083333333*walls(3))
        a_u(i,k-1,j) = a_u(i,k-1,j)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
        a_u(i,k+2,j) = a_u(i,k+2,j)+walls(2)*(0.016666667-0.016666667*walls(3))
        a_u(i,k+1,j) = a_u(i,k+1,j)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
        a_u(i,k,j) = a_u(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
        a_vel =walls(1)*(0.61666667*(u(i,k,j)+u(i,k-1,j))-0.13333333*(u(i,k+1,j)+u(i,k-2,j))+0.016666667*(u(i,k+2,j)+&
&u(i,k-3,j))-0.016666667*(u(i,k+2,j)-u(i,k-3,j)-5.*(u(i,k+1,j)-u(i,k-2,j))+10.*(u(i,k,j)-u(i,k-1,j)))*walls(3))
        a_rom(i-1,k,j) = a_rom(i-1,k,j)+0.5*a_vel
        a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+3:ktf-2) = 0.

  end do
else if (vert_order .eq. 4) then a_vert_order_test
  do j = j_end, j_start, -1
    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    walls(3)=fzp(kts+1); walls(4)=fzm(kts+1)
    walls(5)=fzp(ktf); walls(6)=fzm(ktf)

    do i = i_start, i_end
      k = ktf
! recompute : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i-1,k,j) = a_rom(i-1,k,j)+walls(1)*(walls(6)*u(i,k,j)+walls(5)*u(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(6)*u(i,k,j)+walls(5)*u(i,k-1,j))
      a_u(i,k-1,j) = a_u(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(5)
      a_u(i,k,j) = a_u(i,k,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(6)
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1323
! recompute vars : k
      k = kts+1
! recompute vars : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i-1,k,j) = a_rom(i-1,k,j)+walls(1)*(walls(4)*u(i,k,j)+walls(3)*u(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(4)*u(i,k,j)+walls(3)*u(i,k-1,j))
      a_u(i,k-1,j) = a_u(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(3)
      a_u(i,k,j) = a_u(i,k,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(4)
    end do

    a_vflux(i_start:i_end,kts+1) = 0.
    a_vflux(i_start:i_end,ktf) = 0.

    do k = kts+2, ktf-1
      do i = i_start, i_end
        vel = 0.5*(rom(i-1,k,j)+rom(i,k,j))
! recompute : vel
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_u(i,k-2,j) = a_u(i,k-2,j)-0.083333333*walls(2)
        a_u(i,k-1,j) = a_u(i,k-1,j)+0.58333333*walls(2)
        a_u(i,k+1,j) = a_u(i,k+1,j)-0.083333333*walls(2)
        a_u(i,k,j) = a_u(i,k,j)+0.58333333*walls(2)
        a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i,k-1,j))-0.083333333*(u(i,k+1,j)+u(i,k-2,j)))
        a_rom(i-1,k,j) = a_rom(i-1,k,j)+0.5*a_vel
        a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+2:ktf-1) = 0.

  end do
else if (vert_order .eq. 3) then a_vert_order_test
  do j = j_end, j_start, -1
    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    walls(3)=fzp(kts+1); walls(4)=fzm(kts+1)
    walls(5)=fzp(ktf); walls(6)=fzm(ktf)

    do i = i_start, i_end
      k = ktf
! recompute : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i-1,k,j) = a_rom(i-1,k,j)+walls(1)*(walls(6)*u(i,k,j)+walls(5)*u(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(6)*u(i,k,j)+walls(5)*u(i,k-1,j))
      a_u(i,k-1,j) = a_u(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(5)
      a_u(i,k,j) = a_u(i,k,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(6)
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1353
! recompute vars : k
      k = kts+1
! recompute vars : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i-1,k,j) = a_rom(i-1,k,j)+walls(1)*(walls(4)*u(i,k,j)+walls(3)*u(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(4)*u(i,k,j)+walls(3)*u(i,k-1,j))
      a_u(i,k-1,j) = a_u(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(3)
      a_u(i,k,j) = a_u(i,k,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(4)
    end do

    a_vflux(i_start:i_end,kts+1) = 0.
    a_vflux(i_start:i_end,ktf) = 0.

    do k = kts+2, ktf-1
      do i = i_start, i_end
        vel = 0.5*(rom(i-1,k,j)+rom(i,k,j))
! recompute : vel
        walls(3)=sign(1.,-vel)
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_u(i,k-2,j) = a_u(i,k-2,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_u(i,k-1,j) = a_u(i,k-1,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_u(i,k+1,j) = a_u(i,k+1,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_u(i,k,j) = a_u(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i,k-1,j))-0.083333333*(u(i,k+1,j)+u(i,k-2,j))+0.083333333*(u(i,k+1,j)-&
&u(i,k-2,j)-3.*(u(i,k,j)-u(i,k-1,j)))*walls(3))
        a_rom(i-1,k,j) = a_rom(i-1,k,j)+0.5*a_vel
        a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+2:ktf-1) = 0.

  end do
else if (vert_order .eq. 2) then a_vert_order_test
  do j = j_start, j_end
    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    do k = kts+1, ktf
      walls(3)=fzp(k); walls(4)=fzm(k)
      do i = i_start, i_end
        walls(1)=0.5*a_vflux(i,k)
!       a_vflux(i,k) = 0.
        a_rom(i-1,k,j) = a_rom(i-1,k,j)+walls(1)*(walls(4)*u(i,k,j)+walls(3)*u(i,k-1,j))
        a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(4)*u(i,k,j)+walls(3)*u(i,k-1,j))
        a_u(i,k-1,j) = a_u(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(3)
        a_u(i,k,j) = a_u(i,k,j)+walls(1)*(rom(i,k,j)+rom(i-1,k,j))*walls(4)
      end do
    end do

    a_vflux(i_start:i_end,kts+1:ktf) = 0.

  end do
endif a_vert_order_test
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:1152
! recompute vars : i_start
i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:1153
! recompute vars : i_end
i_end = min(ite,ide)
! recompute vars : i_end
! recdepend vars : config_flags,i_end,i_start,ids,its
! recompute pos : IF_STMT module_advect_em.f90:1157
! recompute vars : i_start
if (config_flags%open_xs) then
  i_start = max(ids+1,its)
endif
! recompute vars : i_start
! recdepend vars : config_flags,i_end,i_start,ide,ite
! recompute pos : IF_STMT module_advect_em.f90:1161
! recompute vars : i_end
if (config_flags%open_xe) then
  i_end = min(ite,ide-1)
endif
! recompute vars : i_end
if (config_flags%open_ye .and. jte .eq. jde) then
  do i = i_start, i_end  !!! How to swap i,k circulations?
    mrdy = msfu(i,jte-1)*rdy
! recompute : mrdy
    ip = min(imax,i)
! recompute : ip
    im = max(imin,i-1)
! recompute : im
    do k = kts, ktf
      vw = 0.5*(rv(ip,k,jte)+rv(im,k,jte))
! recompute : vw
      vb = max(vw,0.)
! recompute : vb
      dvm = rv(ip,k,jte)-rv(ip,k,jte-1)
! recompute : dvm
      dvp = rv(im,k,jte)-rv(im,k,jte-1)
! recompute : dvp
      gwalls=a_tendency(i,k,jte-1)*mrdy
      a_dvm = -0.5*gwalls*u(i,k,jte-1)
      a_dvp = -0.5*gwalls*u(i,k,jte-1)
      a_u(i,k,jte-1) = a_u(i,k,jte-1)-0.5*gwalls*(dvm+dvp)
      a_u_old(i,k,jte-2) = a_u_old(i,k,jte-2)+gwalls*vb
      a_u_old(i,k,jte-1) = a_u_old(i,k,jte-1)-gwalls*vb
      a_vb = -gwalls*(u_old(i,k,jte-1)-u_old(i,k,jte-2))
      a_rv(im,k,jte-1) = a_rv(im,k,jte-1)-a_dvp
      a_rv(im,k,jte) = a_rv(im,k,jte)+a_dvp
      a_rv(ip,k,jte-1) = a_rv(ip,k,jte-1)-a_dvm
      a_rv(ip,k,jte) = a_rv(ip,k,jte)+a_dvm
      a_vw = 0.5*a_vb*(0.5+sign(0.5,vw-0.))
      a_rv(im,k,jte) = a_rv(im,k,jte)+a_vw
      a_rv(ip,k,jte) = a_rv(ip,k,jte)+a_vw
    end do
  end do
endif
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:1152
! recompute vars : i_start
i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:1153
! recompute vars : i_end
i_end = min(ite,ide)
! recompute vars : i_end
! recdepend vars : config_flags,i_end,i_start,ids,its
! recompute pos : IF_STMT module_advect_em.f90:1157
! recompute vars : i_start
if (config_flags%open_xs) then
  i_start = max(ids+1,its)
endif
! recompute vars : i_start
! recdepend vars : config_flags,i_end,i_start,ide,ite
! recompute pos : IF_STMT module_advect_em.f90:1161
! recompute vars : i_end
if (config_flags%open_xe) then
  i_end = min(ite,ide-1)
endif
! recompute vars : i_end
if (config_flags%open_ys .and. jts .eq. jds) then
  do i = i_start, i_end
    mrdy = msfu(i,jts)*rdy
! recompute : mrdy
    ip = min(imax,i)
! recompute : ip
    im = max(imin,i-1)
! recompute : im
    do k = kts, ktf
      vw = 0.5*(rv(ip,k,jts)+rv(im,k,jts))
! recompute : vw
      vb = min(vw,0.)
! recompute : vb
      dvm = rv(ip,k,jts+1)-rv(ip,k,jts)
! recompute : dvm
      dvp = rv(im,k,jts+1)-rv(im,k,jts)
! recompute : dvp
      gwalls=a_tendency(i,k,jts)
      a_dvm = -0.5*gwalls*mrdy*u(i,k,jts)
      a_dvp = -0.5*gwalls*mrdy*u(i,k,jts)
      a_u(i,k,jts) = a_u(i,k,jts)-0.5*gwalls*mrdy*(dvm+dvp)
      a_u_old(i,k,jts+1) = a_u_old(i,k,jts+1)-gwalls*mrdy*vb
      a_u_old(i,k,jts) = a_u_old(i,k,jts)+gwalls*mrdy*vb
      a_vb = -gwalls*mrdy*(u_old(i,k,jts+1)-u_old(i,k,jts))
      a_rv(im,k,jts+1) = a_rv(im,k,jts+1)+a_dvp
      a_rv(im,k,jts) = a_rv(im,k,jts)-a_dvp
      a_rv(ip,k,jts+1) = a_rv(ip,k,jts+1)+a_dvm
      a_rv(ip,k,jts) = a_rv(ip,k,jts)-a_dvm
      a_vw = 0.5*a_vb*(0.5+sign(0.5,0.-vw))
      a_rv(im,k,jts) = a_rv(im,k,jts)+a_vw
      a_rv(ip,k,jts) = a_rv(ip,k,jts)+a_vw
    end do
  end do
endif
if (config_flags%open_xe .and. ite .eq. ide) then
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  do j = j_start, j_end
    do k = kts, ktf
      ub = max(ru(ite,k,j)+cb*mut(ite-1,j),0.)
! recompute : ub
      gwalls=a_tendency(ite,k,j)*rdx
      a_u_old(ite-1,k,j) = a_u_old(ite-1,k,j)+gwalls*ub
      a_u_old(ite,k,j) = a_u_old(ite,k,j)-gwalls*ub
      a_ub =-gwalls*(u_old(ite,k,j)-u_old(ite-1,k,j))

      gwalls=a_ub*(0.5+sign(0.5,ru(ite,k,j)+cb*mut(ite-1,j)-0.))
      a_mut(ite-1,j) = a_mut(ite-1,j)+gwalls*cb
      a_ru(ite,k,j)  = a_ru(ite,k,j) +gwalls
    end do
  end do
endif
if (config_flags%open_xs .and. its .eq. ids) then
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  do j = j_start, j_end
    do k = kts, ktf
      ub = min(ru(its,k,j)-cb*mut(its,j),0.)
! recompute : ub
      gwalls=a_tendency(its,k,j)*rdx
      a_u_old(its+1,k,j) = a_u_old(its+1,k,j)-gwalls*ub
      a_u_old(its,k,j)   = a_u_old(its,k,j)+gwalls*ub
      a_ub =-gwalls*(u_old(its+1,k,j)-u_old(its,k,j))

      gwalls=a_ub*(0.5+sign(0.5,0.-(ru(its,k,j)-cb*mut(its,j))))
      a_mut(its,j)  = a_mut(its,j) -gwalls*cb
      a_ru(its,k,j) = a_ru(its,k,j)+gwalls
    end do
  end do
endif
a_horizontal_order_test: if (horz_order .eq. 6) then
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-3) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start_f = jds+3
  endif
! recompute : j_start_f
  if (degrade_ye) then
    j_end_f = jde-3
  endif
! recompute : j_end_f
  i_start = its
! recompute : i_start
  i_end = ite
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = ids+3
  endif
! recompute : i_start,i_start_f
  if (degrade_xe) then
    i_end = min(ide-1,ite)
    i_end_f = ide-2
  endif
! recompute : i_end,i_end_f
  do j = j_end, j_start, -1
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfu(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do
    if (degrade_xe) then
      i = ide-1
! recompute : i
      do k = kts, ktf
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_u(i-2,k,j) = a_u(i-2,k,j)-0.083333333*walls(2)
        a_u(i-1,k,j) = a_u(i-1,k,j)+0.58333333*walls(2)
        a_u(i+1,k,j) = a_u(i+1,k,j)-0.083333333*walls(2)
        a_u(i,k,j) = a_u(i,k,j)+0.58333333*walls(2)
        a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i-1,k,j))-0.083333333*(u(i+1,k,j)+u(i-2,k,j)))
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
      end do
      a_fqx(ide-1,kts:ktf) = 0.

      if (i_end .eq. ide-1) then
        i = ide
! recompute : i
        do k = kts, ktf
          ub = u(i,k,j)
! recompute : ub
          if (specified .and. u(i-1,k,j) .gt. 0.) then
            ub = u(i-1,k,j)
          endif
! recompute : ub
          gwalls=0.25*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_ru(i-1,k,j) = a_ru(i-1,k,j)+gwalls*(u(i-1,k,j)+ub)
          a_ru(i,k,j) = a_ru(i,k,j)+gwalls*(u(i-1,k,j)+ub)
          a_u(i-1,k,j) = a_u(i-1,k,j)+gwalls*(ru(i,k,j)+ru(i-1,k,j))
          a_ub =gwalls*(ru(i,k,j)+ru(i-1,k,j))
          if (specified .and. u(i-1,k,j) .gt. 0.) then
            a_u(i-1,k,j) = a_u(i-1,k,j)+a_ub
          else
            a_u(i,k,j) = a_u(i,k,j)+a_ub
          endif
        end do
        a_fqx(ide,kts:ktf) = 0.

      endif
    endif
    if (degrade_xs) then
      i = ids+2
!     kwalls(kts:ktf)=0.5*(ru(ids+2,kts:ktf,j)+ru(ids+1,kts:ktf,j))
! recompute : i
      do k = kts, ktf
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_u(i-2,k,j) = a_u(i-2,k,j)-0.083333333*walls(2)
        a_u(i-1,k,j) = a_u(i-1,k,j)+0.58333333*walls(2)
        a_u(i+1,k,j) = a_u(i+1,k,j)-0.083333333*walls(2)
        a_u(i,k,j) = a_u(i,k,j)+0.58333333*walls(2)
        a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i-1,k,j))-0.083333333*(u(i+1,k,j)+u(i-2,k,j)))
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
      end do
      a_fqx(ids+2,kts:ktf) = 0.

      if (i_start .eq. ids+1) then
        i = ids+1
! recompute : i
        do k = kts, ktf
          ub = u(i-1,k,j)
! recompute : ub
          if (specified .and. u(i,k,j) .lt. 0.) then
            ub = u(i,k,j)
          endif
! recompute : ub
          gwalls=0.25*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_ru(i-1,k,j) = a_ru(i-1,k,j)+gwalls*(u(i,k,j)+ub)
          a_ru(i,k,j) = a_ru(i,k,j)+gwalls*(u(i,k,j)+ub)
          a_u(i,k,j) = a_u(i,k,j)+gwalls*(ru(i,k,j)+ru(i-1,k,j))
          a_ub =gwalls*(ru(i,k,j)+ru(i-1,k,j))
          if (specified .and. u(i,k,j) .lt. 0.) then
            a_u(i,k,j) = a_u(i,k,j)+a_ub
          else
            a_u(i-1,k,j) = a_u(i-1,k,j)+a_ub
          endif
        end do
        a_fqx(ids+1,kts:ktf) = 0.

      endif
    endif

    do k = kts, ktf
      do i = i_start_f, i_end_f
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_u(i-3,k,j) = a_u(i-3,k,j)+0.016666667*walls(2)
        a_u(i-2,k,j) = a_u(i-2,k,j)-0.13333333*walls(2)
        a_u(i-1,k,j) = a_u(i-1,k,j)+0.61666667*walls(2)
        a_u(i+2,k,j) = a_u(i+2,k,j)+0.016666667*walls(2)
        a_u(i+1,k,j) = a_u(i+1,k,j)-0.13333333*walls(2)
        a_u(i,k,j) = a_u(i,k,j)+0.61666667*walls(2)
        a_vel =walls(1)*(0.61666667*(u(i,k,j)+u(i-1,k,j))-0.13333333*(u(i+1,k,j)+u(i-2,k,j))+0.016666667*(u(i+2,k,j)+u(i-&
&3,k,j)))
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
      end do
    end do
    a_fqx(i_start_f:i_end_f,kts:ktf) = 0.

  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:249
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:250
! recompute vars : i_end
  i_end = ite
! recompute vars : i_end
! recdepend vars : config_flags,i_end,i_start,ids,its,specified
! recompute pos : IF_STMT module_advect_em.f90:251
! recompute vars : i_start
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
! recompute vars : i_start
! recdepend vars : config_flags,i_end,i_start,ide,ite,specified
! recompute pos : IF_STMT module_advect_em.f90:252
! recompute vars : i_end
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-1,ite)
  endif
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:254
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:255
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
! recdepend vars : degrade_ys,i_end,i_start,j_end,j_start,jds,jts
! recompute pos : IF_STMT module_advect_em.f90:263
! recompute vars : j_start
  if (degrade_ys) then
    j_start = max(jts,jds+1)
  endif
! recompute vars : j_start
! recdepend vars : degrade_ye,i_end,i_start,j_end,j_start,jde,jte
! recompute pos : IF_STMT module_advect_em.f90:268
! recompute vars : j_end
  if (degrade_ye) then
    j_end = min(jte,jde-2)
  endif
! recompute vars : j_end
  a_j_loop_y_flux_6: do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:275
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:276
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    j_loop_y_flux_9c: do j4 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do j_loop_y_flux_9c
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfu(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_u(i,k,j-3) = a_u(i,k,j-3)+0.016666667*walls(2)
          a_u(i,k,j-2) = a_u(i,k,j-2)-0.13333333*walls(2)
          a_u(i,k,j-1) = a_u(i,k,j-1)+0.61666667*walls(2)
          a_u(i,k,j+2) = a_u(i,k,j+2)+0.016666667*walls(2)
          a_u(i,k,j+1) = a_u(i,k,j+1)-0.13333333*walls(2)
          a_u(i,k,j) = a_u(i,k,j)+0.61666667*walls(2)
          a_vel =walls(1)*(0.61666667*(u(i,k,j)+u(i,k,j-1))-0.13333333*(u(i,k,j+1)+u(i,k,j-2))+0.016666667*(u(i,k,j+2)&
&+u(i,k,j-3)))
          a_rv(i-1,k,j) = a_rv(i-1,k,j)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
        end do
      end do
    else if (j .eq. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i-1,k,j) = a_rv(i-1,k,j)+gwalls*(u(i,k,j)+u(i,k,j-1))
          a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(u(i,k,j)+u(i,k,j-1))
          a_u(i,k,j-1) = a_u(i,k,j-1)+gwalls*(rv(i,k,j)+rv(i-1,k,j))
          a_u(i,k,j) = a_u(i,k,j)+gwalls*(rv(i,k,j)+rv(i-1,k,j))
        end do
      end do
    else if (j .eq. jds+2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_u(i,k,j-2) = a_u(i,k,j-2)-0.083333333*walls(2)
          a_u(i,k,j-1) = a_u(i,k,j-1)+0.58333333*walls(2)
          a_u(i,k,j+1) = a_u(i,k,j+1)-0.083333333*walls(2)
          a_u(i,k,j) = a_u(i,k,j)+0.58333333*walls(2)
          a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i,k,j-1))-0.083333333*(u(i,k,j+1)+u(i,k,j-2)))
          a_rv(i-1,k,j) = a_rv(i-1,k,j)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
        end do
      end do
    else if (j .eq. jde-1) then
      do k = kts, ktf
        do i = i_start, i_end
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i-1,k,j) = a_rv(i-1,k,j)+gwalls*(u(i,k,j)+u(i,k,j-1))
          a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(u(i,k,j)+u(i,k,j-1))
          a_u(i,k,j-1) = a_u(i,k,j-1)+gwalls*(rv(i,k,j)+rv(i-1,k,j))
          a_u(i,k,j) = a_u(i,k,j)+gwalls*(rv(i,k,j)+rv(i-1,k,j))
        end do
      end do
    else if (j .eq. jde-2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_u(i,k,j-2) = a_u(i,k,j-2)-0.083333333*walls(2)
          a_u(i,k,j-1) = a_u(i,k,j-1)+0.58333333*walls(2)
          a_u(i,k,j+1) = a_u(i,k,j+1)-0.083333333*walls(2)
          a_u(i,k,j) = a_u(i,k,j)+0.58333333*walls(2)
          a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i,k,j-1))-0.083333333*(u(i,k,j+1)+u(i,k,j-2)))
          a_rv(i-1,k,j) = a_rv(i-1,k,j)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
        end do
      end do
    endif
  end do a_j_loop_y_flux_6
else if (horz_order .eq. 5) then a_horizontal_order_test
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-3) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start_f = jds+3
  endif
! recompute : j_start_f
  if (degrade_ye) then
    j_end_f = jde-3
  endif
! recompute : j_end_f
  i_start = its
! recompute : i_start
  i_end = ite
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = ids+3
  endif
! recompute : i_start,i_start_f
  if (degrade_xe) then
    i_end = min(ide-1,ite)
    i_end_f = ide-2
  endif
! recompute : i_end,i_end_f
  do j = j_end, j_start, -1
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfu(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do
    if (degrade_xe) then
      do k = kts, ktf
        i = ide-1
! recompute : i
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_u(i-2,k,j) = a_u(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_u(i-1,k,j) = a_u(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_u(i+1,k,j) = a_u(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_u(i,k,j) = a_u(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i-1,k,j))-0.083333333*(u(i+1,k,j)+u(i-2,k,j))+0.083333333*(u(i+1,k,j)-u(i-&
&2,k,j)-3.*(u(i,k,j)-u(i-1,k,j)))*walls(3))
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
      end do

      if (i_end .eq. ide-1) then
        i = ide
! recompute : i
        do k = kts, ktf
          ub = u(i,k,j)
! recompute : ub
          if (specified .and. u(i-1,k,j) .gt. 0.) then
            ub = u(i-1,k,j)
          endif
! recompute : ub
          gwalls=0.25*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_ru(i-1,k,j) = a_ru(i-1,k,j)+gwalls*(u(i-1,k,j)+ub)
          a_ru(i,k,j) = a_ru(i,k,j)+gwalls*(u(i-1,k,j)+ub)
          a_u(i-1,k,j) = a_u(i-1,k,j)+gwalls*(ru(i,k,j)+ru(i-1,k,j))
          a_ub =gwalls*(ru(i,k,j)+ru(i-1,k,j))
          if (specified .and. u(i-1,k,j) .gt. 0.) then
            a_u(i-1,k,j) = a_u(i-1,k,j)+a_ub
          else
            a_u(i,k,j) = a_u(i,k,j)+a_ub
          endif
        end do
        a_fqx(ide,kts:ktf) = 0.

      endif
    endif
    if (degrade_xs) then
      i = ids+2
! recompute : i
      do k = kts, ktf
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_u(i-2,k,j) = a_u(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_u(i-1,k,j) = a_u(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_u(i+1,k,j) = a_u(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_u(i,k,j) = a_u(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i-1,k,j))-0.083333333*(u(i+1,k,j)+u(i-2,k,j))+0.083333333*(u(i+1,k,j)-u(i-&
&2,k,j)-3.*(u(i,k,j)-u(i-1,k,j)))*walls(3))
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
      end do

      if (i_start .eq. ids+1) then
        i = ids+1
! recompute : i
        do k = kts, ktf
          ub = u(i-1,k,j)
! recompute : ub
          if (specified .and. u(i,k,j) .lt. 0.) then
            ub = u(i,k,j)
          endif
! recompute : ub
          gwalls=0.25*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_ru(i-1,k,j) = a_ru(i-1,k,j)+gwalls*(u(i,k,j)+ub)
          a_ru(i,k,j) = a_ru(i,k,j)+gwalls*(u(i,k,j)+ub)
          a_u(i,k,j) = a_u(i,k,j)+gwalls*(ru(i,k,j)+ru(i-1,k,j))
          a_ub =gwalls*(ru(i,k,j)+ru(i-1,k,j))
          if (specified .and. u(i,k,j) .lt. 0.) then
            a_u(i,k,j) = a_u(i,k,j)+a_ub
          else
            a_u(i-1,k,j) = a_u(i-1,k,j)+a_ub
          endif
        end do
        a_fqx(ids+1,kts:ktf) = 0.

      endif
    endif
    do k = kts, ktf
      
      do i = i_start_f, i_end_f
        
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_u(i-3,k,j) = a_u(i-3,k,j)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
        a_u(i-2,k,j) = a_u(i-2,k,j)+walls(2)*((-0.13333333)-0.083333333*walls(3))
        a_u(i-1,k,j) = a_u(i-1,k,j)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
        a_u(i+2,k,j) = a_u(i+2,k,j)+walls(2)*(0.016666667-0.016666667*walls(3))
        a_u(i+1,k,j) = a_u(i+1,k,j)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
        a_u(i,k,j) = a_u(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
        a_vel =walls(1)*(0.61666667*(u(i,k,j)+u(i-1,k,j))-0.13333333*(u(i+1,k,j)+u(i-2,k,j))+0.016666667*(u(i+2,k,j)+u(i-&
&3,k,j))-0.016666667*(u(i+2,k,j)-u(i-3,k,j)-5.*(u(i+1,k,j)-u(i-2,k,j))+10.*(u(i,k,j)-u(i-1,k,j)))*walls(3))
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
        
      end do
    end do
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:488
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:489
! recompute vars : i_end
  i_end = ite
! recompute vars : i_end
! recdepend vars : config_flags,i_end,i_start,ids,its,specified
! recompute pos : IF_STMT module_advect_em.f90:490
! recompute vars : i_start
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
! recompute vars : i_start
! recdepend vars : config_flags,i_end,i_start,ide,ite,specified
! recompute pos : IF_STMT module_advect_em.f90:491
! recompute vars : i_end
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-1,ite)
  endif
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:493
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:494
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
! recdepend vars : degrade_ys,i_end,i_start,j_end,j_start,jds,jts
! recompute pos : IF_STMT module_advect_em.f90:502
! recompute vars : j_start
  if (degrade_ys) then
    j_start = max(jts,jds+1)
  endif
! recompute vars : j_start
! recdepend vars : degrade_ye,i_end,i_start,j_end,j_start,jde,jte
! recompute pos : IF_STMT module_advect_em.f90:507
! recompute vars : j_end
  if (degrade_ye) then
    j_end = min(jte,jde-2)
  endif
! recompute vars : j_end
  a_j_loop_y_flux_5: do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:514
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:515
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    j_loop_y_flux_9a: do j1 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do j_loop_y_flux_9a
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfu(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_u(i,k,j-3) = a_u(i,k,j-3)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
          a_u(i,k,j-2) = a_u(i,k,j-2)+walls(2)*((-0.13333333)-0.083333333*walls(3))
          a_u(i,k,j-1) = a_u(i,k,j-1)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
          a_u(i,k,j+2) = a_u(i,k,j+2)+walls(2)*(0.016666667-0.016666667*walls(3))
          a_u(i,k,j+1) = a_u(i,k,j+1)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
          a_u(i,k,j) = a_u(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
          a_vel =walls(1)*(0.61666667*(u(i,k,j)+u(i,k,j-1))-0.13333333*(u(i,k,j+1)+u(i,k,j-2))+0.016666667*(u(i,k,j+2)&
&+u(i,k,j-3))-0.016666667*(u(i,k,j+2)-u(i,k,j-3)-5.*(u(i,k,j+1)-u(i,k,j-2))+10.*(u(i,k,j)-u(i,k,j-1)))*walls(3))
          a_rv(i-1,k,j) = a_rv(i-1,k,j)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
          
        end do
      end do
    else if (j .eq. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i-1,k,j) = a_rv(i-1,k,j)+gwalls*(u(i,k,j)+u(i,k,j-1))
          a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(u(i,k,j)+u(i,k,j-1))
          a_u(i,k,j-1) = a_u(i,k,j-1)+gwalls*(rv(i,k,j)+rv(i-1,k,j))
          a_u(i,k,j) = a_u(i,k,j)+gwalls*(rv(i,k,j)+rv(i-1,k,j))
        end do
      end do
    else if (j .eq. jds+2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_u(i,k,j-2) = a_u(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
          a_u(i,k,j-1) = a_u(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
          a_u(i,k,j+1) = a_u(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
          a_u(i,k,j) = a_u(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
          a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i,k,j-1))-0.083333333*(u(i,k,j+1)+u(i,k,j-2))+0.083333333*(u(i,k,j+&
&1)-u(i,k,j-2)-3.*(u(i,k,j)-u(i,k,j-1)))*walls(3))
          a_rv(i-1,k,j) = a_rv(i-1,k,j)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
        end do
      end do
    else if (j .eq. jde-1) then
      do k = kts, ktf
        do i = i_start, i_end
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i-1,k,j) = a_rv(i-1,k,j)+gwalls*(u(i,k,j)+u(i,k,j-1))
          a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(u(i,k,j)+u(i,k,j-1))
          a_u(i,k,j-1) = a_u(i,k,j-1)+gwalls*(rv(i,k,j)+rv(i-1,k,j))
          a_u(i,k,j) = a_u(i,k,j)+gwalls*(rv(i,k,j)+rv(i-1,k,j))
        end do
      end do
    else if (j .eq. jde-2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_u(i,k,j-2) = a_u(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
          a_u(i,k,j-1) = a_u(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
          a_u(i,k,j+1) = a_u(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
          a_u(i,k,j) = a_u(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
          a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i,k,j-1))-0.083333333*(u(i,k,j+1)+u(i,k,j-2))+0.083333333*(u(i,k,j+&
&1)-u(i,k,j-2)-3.*(u(i,k,j)-u(i,k,j-1)))*walls(3))
          a_rv(i-1,k,j) = a_rv(i-1,k,j)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
          
        end do
      end do
    endif
  end do a_j_loop_y_flux_5
else if (horz_order .eq. 4) then a_horizontal_order_test
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-1) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
  i_start = its
! recompute : i_start
  i_end = ite
! recompute : i_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
! recompute : i_start_f
  if (degrade_xe) then
    i_end_f = ide-1
  endif
! recompute : i_end_f
  i_start = its
! recompute : i_start
  i_end = ite
! recompute : i_end
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
! recompute : i_start
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-1,ite)
  endif
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start = jds+1
    j_start_f = j_start+1
  endif
! recompute : j_start,j_start_f
  if (degrade_ye) then
    j_end = jde-2
    j_end_f = jde-2
  endif
! recompute : j_end,j_end_f
  do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:816
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:817
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    do j2 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfu(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .lt. j_start_f .and. degrade_ys) then
      do k = kts, ktf
        do i = i_start, i_end
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i-1,k,j_start) = a_rv(i-1,k,j_start)+gwalls*(u(i,k,j_start)+u(i,k,j_start-1))
          a_rv(i,k,j_start) = a_rv(i,k,j_start)+gwalls*(u(i,k,j_start)+u(i,k,j_start-1))
          a_u(i,k,j_start-1) = a_u(i,k,j_start-1)+gwalls*(rv(i,k,j_start)+rv(i-1,k,j_start))
          a_u(i,k,j_start) = a_u(i,k,j_start)+gwalls*(rv(i,k,j_start)+rv(i-1,k,j_start))
        end do
      end do
    else if (j .gt. j_end_f .and. degrade_ye) then
      do k = kts, ktf
        do i = i_start, i_end
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i-1,k,j_end+1) = a_rv(i-1,k,j_end+1)+gwalls*(u(i,k,j_end+1)+u(i,k,j_end))
          a_rv(i,k,j_end+1) = a_rv(i,k,j_end+1)+gwalls*(u(i,k,j_end+1)+u(i,k,j_end))
          a_u(i,k,j_end+1) = a_u(i,k,j_end+1)+gwalls*(rv(i,k,j_end+1)+rv(i-1,k,j_end+1))
          a_u(i,k,j_end) = a_u(i,k,j_end)+gwalls*(rv(i,k,j_end+1)+rv(i-1,k,j_end+1))
        end do
      end do
    else
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_u(i,k,j-2) = a_u(i,k,j-2)-0.083333333*walls(2)
          a_u(i,k,j-1) = a_u(i,k,j-1)+0.58333333*walls(2)
          a_u(i,k,j+1) = a_u(i,k,j+1)-0.083333333*walls(2)
          a_u(i,k,j) = a_u(i,k,j)+0.58333333*walls(2)
          a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i,k,j-1))-0.083333333*(u(i,k,j+1)+u(i,k,j-2)))
          a_rv(i-1,k,j) = a_rv(i-1,k,j)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
        end do
      end do
    endif
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:720
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:721
! recompute vars : i_end
  i_end = ite
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:722
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:723
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
! recdepend vars : degrade_xs,i_end,i_start,ids,j_end,j_start
! recompute pos : IF_STMT module_advect_em.f90:731
! recompute vars : i_start
  if (degrade_xs) then
    i_start = ids+1
  endif
! recompute vars : i_start
! recdepend vars : degrade_xe,i_end,i_start,ide,j_end,j_start
! recompute pos : IF_STMT module_advect_em.f90:736
! recompute vars : i_end
  if (degrade_xe) then
    i_end = ide-1
  endif
! recompute vars : i_end
  do j = j_end, j_start, -1
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfu(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do

    if (degrade_xe) then
      i = i_end+1
! recompute : i
      do k = kts, ktf
        ub = u(i,k,j)
! recompute : ub
        if (specified .and. u(i-1,k,j) .gt. 0.) then
          ub = u(i-1,k,j)
        endif
! recompute : ub
        gwalls=0.25*a_fqx(i,k)
!       a_fqx(i,k) = 0.
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+gwalls*(u(i-1,k,j)+ub)
        a_ru(i,k,j) = a_ru(i,k,j)+gwalls*(u(i-1,k,j)+ub)
        a_u(i-1,k,j) = a_u(i-1,k,j)+gwalls*(ru(i,k,j)+ru(i-1,k,j))
        a_ub =gwalls*(ru(i,k,j)+ru(i-1,k,j))
        if (specified .and. u(i-1,k,j) .gt. 0.) then
          a_u(i-1,k,j) = a_u(i-1,k,j)+a_ub
        else
          a_u(i,k,j) = a_u(i,k,j)+a_ub
        endif
      end do
      a_fqx(i_end+1,kts:ktf) = 0.
    endif

    if (degrade_xs) then
      i = i_start
! recompute : i
      do k = kts, ktf
        ub = u(i-1,k,j)
! recompute : ub
        if (specified .and. u(i,k,j) .lt. 0.) then
          ub = u(i,k,j)
        endif
! recompute : ub
        gwalls=0.25*a_fqx(i,k)
!       a_fqx(i,k) = 0.
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+gwalls*(u(i,k,j)+ub)
        a_ru(i,k,j) = a_ru(i,k,j)+gwalls*(u(i,k,j)+ub)
        a_u(i,k,j) = a_u(i,k,j)+gwalls*(ru(i,k,j)+ru(i-1,k,j))
        a_ub =gwalls*(ru(i,k,j)+ru(i-1,k,j))
        if (specified .and. u(i,k,j) .lt. 0.) then
          a_u(i,k,j) = a_u(i,k,j)+a_ub
        else
          a_u(i-1,k,j) = a_u(i-1,k,j)+a_ub
        endif
      end do
      a_fqx(i_start,kts:ktf) = 0.
    endif

    do k = kts, ktf
      do i = i_start_f, i_end_f
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_u(i-2,k,j) = a_u(i-2,k,j)-0.083333333*walls(2)
        a_u(i-1,k,j) = a_u(i-1,k,j)+0.58333333*walls(2)
        a_u(i+1,k,j) = a_u(i+1,k,j)-0.083333333*walls(2)
        a_u(i,k,j) = a_u(i,k,j)+0.58333333*walls(2)
        a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i-1,k,j))-0.083333333*(u(i+1,k,j)+u(i-2,k,j)))
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
      end do
    end do
    a_fqx(i_start_f:i_end_f,kts:ktf) = 0.

  end do
else if (horz_order .eq. 3) then a_horizontal_order_test
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-1) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
  i_start = its
! recompute : i_start
  i_end = ite
! recompute : i_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
! recompute : i_start_f
  if (degrade_xe) then
    i_end_f = ide-1
  endif
! recompute : i_end_f
  i_start = its
! recompute : i_start
  i_end = ite
! recompute : i_end
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
! recompute : i_start
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-1,ite)
  endif
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start = jds+1
    j_start_f = j_start+1
  endif
! recompute : j_start,j_start_f
  if (degrade_ye) then
    j_end = jde-2
    j_end_f = jde-2
  endif
! recompute : j_end,j_end_f
  do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:994
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:995
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    do j3 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do
!      if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfu(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .lt. j_start_f .and. degrade_ys) then
      do k = kts, ktf
        do i = i_start, i_end
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i-1,k,j_start) = a_rv(i-1,k,j_start)+gwalls*(u(i,k,j_start)+u(i,k,j_start-1))
          a_rv(i,k,j_start) = a_rv(i,k,j_start)+gwalls*(u(i,k,j_start)+u(i,k,j_start-1))
          a_u(i,k,j_start-1) = a_u(i,k,j_start-1)+gwalls*(rv(i,k,j_start)+rv(i-1,k,j_start))
          a_u(i,k,j_start) = a_u(i,k,j_start)+gwalls*(rv(i,k,j_start)+rv(i-1,k,j_start))
        end do
      end do
    else if (j .gt. j_end_f .and. degrade_ye) then
      do k = kts, ktf
        do i = i_start, i_end
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i-1,k,j_end+1) = a_rv(i-1,k,j_end+1)+gwalls*(u(i,k,j_end+1)+u(i,k,j_end))
          a_rv(i,k,j_end+1) = a_rv(i,k,j_end+1)+gwalls*(u(i,k,j_end+1)+u(i,k,j_end))
          a_u(i,k,j_end+1) = a_u(i,k,j_end+1)+gwalls*(rv(i,k,j_end+1)+rv(i-1,k,j_end+1))
          a_u(i,k,j_end) = a_u(i,k,j_end)+gwalls*(rv(i,k,j_end+1)+rv(i-1,k,j_end+1))
        end do
      end do
    else
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_u(i,k,j-2) = a_u(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
          a_u(i,k,j-1) = a_u(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
          a_u(i,k,j+1) = a_u(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
          a_u(i,k,j) = a_u(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
          a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i,k,j-1))-0.083333333*(u(i,k,j+1)+u(i,k,j-2))+0.083333333*(u(i,k,j+&
&1)-u(i,k,j-2)-3.*(u(i,k,j)-u(i,k,j-1)))*walls(3))
          a_rv(i-1,k,j) = a_rv(i-1,k,j)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
        end do
      end do
    endif
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:899
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:900
! recompute vars : i_end
  i_end = ite
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:901
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:902
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
! recdepend vars : degrade_xs,i_end,i_start,ids,j_end,j_start
! recompute pos : IF_STMT module_advect_em.f90:910
! recompute vars : i_start
  if (degrade_xs) then
    i_start = ids+1
  endif
! recompute vars : i_start
! recdepend vars : degrade_xe,i_end,i_start,ide,j_end,j_start
! recompute pos : IF_STMT module_advect_em.f90:915
! recompute vars : i_end
  if (degrade_xe) then
    i_end = ide-1
  endif
! recompute vars : i_end
  do j = j_end, j_start, -1
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfu(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do

    if (degrade_xe) then
      i = i_end+1
! recompute : i
      do k = kts, ktf
        ub = u(i,k,j)
! recompute : ub
        if (specified .and. u(i-1,k,j) .gt. 0.) then
          ub = u(i-1,k,j)
        endif
! recompute : ub
        gwalls=0.25*a_fqx(i,k)
!       a_fqx(i,k) = 0.
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+gwalls*(u(i-1,k,j)+ub)
        a_ru(i,k,j) = a_ru(i,k,j)+gwalls*(u(i-1,k,j)+ub)
        a_u(i-1,k,j) = a_u(i-1,k,j)+gwalls*(ru(i,k,j)+ru(i-1,k,j))
        a_ub =gwalls*(ru(i,k,j)+ru(i-1,k,j))
        if (specified .and. u(i-1,k,j) .gt. 0.) then
          a_u(i-1,k,j) = a_u(i-1,k,j)+a_ub
        else
          a_u(i,k,j) = a_u(i,k,j)+a_ub
        endif
      end do
      a_fqx(i_end+1,kts:ktf) = 0.
    endif

    if (degrade_xs) then
      i = i_start
! recompute : i
      do k = kts, ktf
        ub = u(i-1,k,j)
! recompute : ub
        if (specified .and. u(i,k,j) .lt. 0.) then
          ub = u(i,k,j)
        endif
! recompute : ub
        gwalls=0.25*a_fqx(i,k)
!       a_fqx(i,k) = 0.
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+gwalls*(u(i,k,j)+ub)
        a_ru(i,k,j) = a_ru(i,k,j)+gwalls*(u(i,k,j)+ub)
        a_u(i,k,j) = a_u(i,k,j)+gwalls*(ru(i,k,j)+ru(i-1,k,j))
        a_ub =gwalls*(ru(i,k,j)+ru(i-1,k,j))
        if (specified .and. u(i,k,j) .lt. 0.) then
          a_u(i,k,j) = a_u(i,k,j)+a_ub
        else
          a_u(i-1,k,j) = a_u(i-1,k,j)+a_ub
        endif
      end do
      a_fqx(i_start,kts:ktf) = 0.
    endif

    do k = kts, ktf
      do i = i_start_f, i_end_f
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_u(i-2,k,j) = a_u(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_u(i-1,k,j) = a_u(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_u(i+1,k,j) = a_u(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_u(i,k,j) = a_u(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_vel =walls(1)*(0.58333333*(u(i,k,j)+u(i-1,k,j))-0.083333333*(u(i+1,k,j)+u(i-2,k,j))+0.083333333*(u(i+1,k,j)-u(i-&
&2,k,j)-3.*(u(i,k,j)-u(i-1,k,j)))*walls(3))
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
        
      end do
    end do
  end do
else if (horz_order .eq. 2) then a_horizontal_order_test
  i_start = its
! recompute : i_start
  i_end = ite
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  if (config_flags%open_xs) then
    i_start = max(ids+1,its)
  endif
! recompute : i_start
  if (config_flags%open_xe) then
    i_end = min(ide-1,ite)
  endif
! recompute : i_end
  if (specified) then
    i_start = max(ids+2,its)
  endif
! recompute : i_start
  if (specified) then
    i_end = min(ide-2,ite)
  endif
! recompute : i_end
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
! recompute : j_start
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-2,jte)
  endif
! recompute : j_end
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdy = msfu(i,j)*rdy
! recompute : mrdy
        gwalls=0.25*a_tendency(i,k,j)*mrdy
        a_rv(i-1,k,j+1) = a_rv(i-1,k,j+1)-gwalls*(u(i,k,j+1)+u(i,k,j))
        a_rv(i,k,j+1) = a_rv(i,k,j+1)-gwalls*(u(i,k,j+1)+u(i,k,j))
        a_rv(i-1,k,j) = a_rv(i-1,k,j)+gwalls*(u(i,k,j)+u(i,k,j-1))
        a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(u(i,k,j)+u(i,k,j-1))
        a_u(i,k,j-1) = a_u(i,k,j-1)+gwalls*(rv(i,k,j)+rv(i-1,k,j))
        a_u(i,k,j+1) = a_u(i,k,j+1)-gwalls*(rv(i,k,j+1)+rv(i-1,k,j+1))
        a_u(i,k,j) = a_u(i,k,j)-gwalls*(rv(i,k,j+1)+rv(i-1,k,j+1)-(rv(i,k,j)+rv(i-1,k,j)))
      end do
    end do
  end do
! recdepend vars : jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1049
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:1050
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
  if (specified .and. ite .ge. ide-1) then
    do j = j_start, j_end
      do k = kts, ktf
        i = ide-1
! recompute : i
        mrdx = msfu(i,j)*rdx
! recompute : mrdx
        ub = u(i+1,k,j)
! recompute : ub
        if (u(i,k,j) .gt. 0.) then
          ub = u(i,k,j)
        endif
! recompute : ub
        gwalls=0.25*a_tendency(i,k,j)*mrdx
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+gwalls*(u(i,k,j)+u(i-1,k,j))
        a_ru(i+1,k,j) = a_ru(i+1,k,j)-gwalls*(ub+u(i,k,j))
        a_ru(i,k,j) = a_ru(i,k,j)-gwalls*(ub+u(i,k,j)-(u(i,k,j)+u(i-1,k,j)))
        a_u(i-1,k,j) = a_u(i-1,k,j)+gwalls*(ru(i,k,j)+ru(i-1,k,j))
        a_u(i,k,j) = a_u(i,k,j)-gwalls*(ru(i+1,k,j)+ru(i,k,j)-(ru(i,k,j)+ru(i-1,k,j)))
        a_ub =-gwalls*(ru(i+1,k,j)+ru(i,k,j))
        if (u(i,k,j) .gt. 0.) then
          a_u(i,k,j) = a_u(i,k,j)+a_ub
        else
          a_u(i+1,k,j) = a_u(i+1,k,j)+a_ub
        endif
      end do
    end do
  endif
! recdepend vars : jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1049
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:1050
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
  if (specified .and. its .le. ids+1) then
    do j = j_start, j_end
      
      do k = kts, ktf
        
        i = ids+1
! recompute : i
        mrdx = msfu(i,j)*rdx
! recompute : mrdx
        ub = u(i-1,k,j)
! recompute : ub
        if (u(i,k,j) .lt. 0.) then
          ub = u(i,k,j)
        endif
! recompute : ub
        gwalls=0.25*a_tendency(i,k,j)*mrdx
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+gwalls*(u(i,k,j)+ub)
        a_ru(i+1,k,j) = a_ru(i+1,k,j)-gwalls*(u(i+1,k,j)+u(i,k,j))
        a_ru(i,k,j) = a_ru(i,k,j)-gwalls*(u(i+1,k,j)+u(i,k,j)-(u(i,k,j)+ub))
        a_u(i+1,k,j) = a_u(i+1,k,j)-gwalls*(ru(i+1,k,j)+ru(i,k,j))
        a_u(i,k,j) = a_u(i,k,j)-gwalls*(ru(i+1,k,j)+ru(i,k,j)-(ru(i,k,j)+ru(i-1,k,j)))
        a_ub =gwalls*(ru(i,k,j)+ru(i-1,k,j))
        if (u(i,k,j) .lt. 0.) then
          a_u(i,k,j) = a_u(i,k,j)+a_ub
        else
          a_u(i-1,k,j) = a_u(i-1,k,j)+a_ub
        endif
      end do
    end do
  endif
! recdepend vars : jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1049
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:1050
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfu(i,j)*rdx
! recompute : mrdx
        gwalls=0.25*a_tendency(i,k,j)*mrdx
        a_ru(i-1,k,j) = a_ru(i-1,k,j)+gwalls*(u(i,k,j)+u(i-1,k,j))
        a_ru(i+1,k,j) = a_ru(i+1,k,j)-gwalls*(u(i+1,k,j)+u(i,k,j))
        a_ru(i,k,j) = a_ru(i,k,j)-gwalls*(u(i+1,k,j)+u(i,k,j)-(u(i,k,j)+u(i-1,k,j)))
        a_u(i-1,k,j) = a_u(i-1,k,j)+gwalls*(ru(i,k,j)+ru(i-1,k,j))
        a_u(i+1,k,j) = a_u(i+1,k,j)-gwalls*(ru(i+1,k,j)+ru(i,k,j))
        a_u(i,k,j) = a_u(i,k,j)-gwalls*(ru(i+1,k,j)+ru(i,k,j)-(ru(i,k,j)+ru(i-1,k,j)))
      end do
    end do
  end do
endif a_horizontal_order_test

   call trace_exit("a_advect_u")

end subroutine a_advect_u


subroutine a_advect_v( v, a_v, v_old, a_v_old, a_tendency, ru, a_ru, rv, a_rv, rom, a_rom, mut, a_mut, config_flags, msfv, fzm, &
&fzp, rdx, rdy, rdzw, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: a_mut(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_rom(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_tendency(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v_old(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: rdzw(kms:kme)
real, intent(in) :: rom(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v_old(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_dum
real a_dup
real a_fqx(its:ite+1,kts:kte)
real a_fqy(its:ite,kts:kte,2)
real a_ub
real a_uw
real a_vb
real a_vel
real a_vflux(its:ite,kts:kte)
logical degrade_xe
logical degrade_xs
logical degrade_ye
logical degrade_ys
real dum
real dup
integer horz_order
integer i
integer i_end
integer i_end_f
integer i_start
integer i_start_f
integer j
integer j1
integer j2
integer j3
integer j4
integer j_end
integer j_end_f
integer j_start
integer j_start_f
integer jm
integer jmax
integer jmin
integer jp
integer jp0
integer jp1
integer jtmp
integer k
integer ktf
real mrdx
real mrdy
logical specified
real ub
real uw
real vb
real vel
integer vert_order
real walls(7),gwalls
real iwalls(ims:ime)
real kwalls(kms:kme)

   call trace_entry("a_advect_v")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_fqx(:,:) = 0.
a_fqy(:,:,:) = 0.
a_vflux(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
ktf = min(kte,kde-1)
! recompute : ktf
horz_order = config_flags%h_mom_adv_order
! recompute : horz_order
vert_order = config_flags%v_mom_adv_order
! recompute : vert_order
horizontal_order_tesu: if (horz_order .eq. 6) then
  ktf = min(kte,kde-1)
else if (horz_order .eq. 4) then horizontal_order_tesu
  ktf = min(kte,kde-1)
else if (horz_order .eq. 3) then horizontal_order_tesu
  ktf = min(kte,kde-1)
endif horizontal_order_tesu
! recompute : ktf
jmin = jds
! recompute : jmin
jmax = jde-1
! recompute : jmax
if (config_flags%open_ys) then
  jmin = jds
endif
! recompute : jmin
if (config_flags%open_ye) then
  jmax = jde-1
endif
! recompute : jmax
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = jte
! recompute : j_end
if (config_flags%open_ys .or. specified) then
  j_start = max(jds+1,jts)
endif
! recompute : j_start
if (config_flags%open_ye .or. specified) then
  j_end = min(jde-1,jte)
endif
! recompute : j_end
a_vert_order_test: if (vert_order .eq. 6) then
  do j = j_end, j_start, -1
    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    walls(3)=fzp(kts+1); walls(4)=fzm(kts+1)
    walls(5)=fzp(ktf); walls(6)=fzm(ktf)

    do i = i_start, i_end
      k = ktf-1
! recompute : k
      vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
! recompute : vel
      k = ktf
! recompute : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k,j-1) = a_rom(i,k,j-1)+walls(1)*(walls(6)*v(i,k,j)+walls(5)*v(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(6)*v(i,k,j)+walls(5)*v(i,k-1,j))
      a_v(i,k-1,j) = a_v(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(5)
      a_v(i,k,j) = a_v(i,k,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(6)
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:2544
! recompute vars : k
      k = ktf-1
! recompute vars : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_v(i,k-2,j) = a_v(i,k-2,j)-0.083333333*walls(2)
      a_v(i,k-1,j) = a_v(i,k-1,j)+0.58333333*walls(2)
      a_v(i,k+1,j) = a_v(i,k+1,j)-0.083333333*walls(2)
      a_v(i,k,j) = a_v(i,k,j)+0.58333333*walls(2)
      a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i,k-1,j))-0.083333333*(v(i,k+1,j)+v(i,k-2,j)))
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:2544
! recompute vars : k
      k = ktf-1
! recompute vars : k
      a_rom(i,k,j-1) = a_rom(i,k,j-1)+0.5*a_vel
      a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2539
! recompute vars : k
      k = kts+2
! recompute vars : k
! recdepend vars : i,j,k,rom
! recompute pos : ASSIGN_STMT module_advect_em.f90:2540
! recompute vars : vel
      vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
! recompute vars : vel
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_v(i,k-2,j) = a_v(i,k-2,j)-0.083333333*walls(2)
      a_v(i,k-1,j) = a_v(i,k-1,j)+0.58333333*walls(2)
      a_v(i,k+1,j) = a_v(i,k+1,j)-0.083333333*walls(2)
      a_v(i,k,j) = a_v(i,k,j)+0.58333333*walls(2)
      a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i,k-1,j))-0.083333333*(v(i,k+1,j)+v(i,k-2,j)))
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2539
! recompute vars : k
      k = kts+2
! recompute vars : k
      a_rom(i,k,j-1) = a_rom(i,k,j-1)+0.5*a_vel
      a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2536
! recompute vars : k
      k = kts+1
! recompute vars : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k,j-1) = a_rom(i,k,j-1)+walls(1)*(walls(4)*v(i,k,j)+walls(3)*v(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(4)*v(i,k,j)+walls(3)*v(i,k-1,j))
      a_v(i,k-1,j) = a_v(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(3)
      a_v(i,k,j) = a_v(i,k,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(4)
    end do

    a_vflux(i_start:i_end,kts+1:kts+2) = 0.
    a_vflux(i_start:i_end,ktf-1:ktf) = 0.

    do k = kts+3, ktf-2
      do i = i_start, i_end
        vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
! recompute : vel
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_v(i,k-3,j) = a_v(i,k-3,j)+0.016666667*walls(2)
        a_v(i,k-2,j) = a_v(i,k-2,j)-0.13333333*walls(2)
        a_v(i,k-1,j) = a_v(i,k-1,j)+0.61666667*walls(2)
        a_v(i,k+2,j) = a_v(i,k+2,j)+0.016666667*walls(2)
        a_v(i,k+1,j) = a_v(i,k+1,j)-0.13333333*walls(2)
        a_v(i,k,j) = a_v(i,k,j)+0.61666667*walls(2)
        a_vel =walls(1)*(0.61666667*(v(i,k,j)+v(i,k-1,j))-0.13333333*(v(i,k+1,j)+v(i,k-2,j))+0.016666667*(v(i,k+2,j)+&
&v(i,k-3,j)))
        a_rom(i,k,j-1) = a_rom(i,k,j-1)+0.5*a_vel
        a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+3:ktf-2) = 0.

  end do
else if (vert_order .eq. 5) then a_vert_order_test
  do j = j_end, j_start, -1
    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    walls(7)=fzp(kts+1); walls(4)=fzm(kts+1)
    walls(5)=fzp(ktf); walls(6)=fzm(ktf)

    do i = i_start, i_end
      k = ktf-1
! recompute : k
      vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
      walls(3)=sign(1.,-vel)
! recompute : vel
      k = ktf
! recompute : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k,j-1) = a_rom(i,k,j-1)+walls(1)*(walls(6)*v(i,k,j)+walls(5)*v(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(6)*v(i,k,j)+walls(5)*v(i,k-1,j))
      a_v(i,k-1,j) = a_v(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(5)
      a_v(i,k,j) = a_v(i,k,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(6)
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:2587
! recompute vars : k
      k = ktf-1
! recompute vars : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_v(i,k-2,j) = a_v(i,k-2,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
      a_v(i,k-1,j) = a_v(i,k-1,j)+walls(2)*(0.58333333+0.25*walls(3))
      a_v(i,k+1,j) = a_v(i,k+1,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
      a_v(i,k,j) = a_v(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
      a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i,k-1,j))-0.083333333*(v(i,k+1,j)+v(i,k-2,j))+0.083333333*(v(i,k+1,j)-v(i,&
&k-2,j)-3.*(v(i,k,j)-v(i,k-1,j)))*walls(3))
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:2587
! recompute vars : k
      k = ktf-1
! recompute vars : k
      a_rom(i,k,j-1) = a_rom(i,k,j-1)+0.5*a_vel
      a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2582
! recompute vars : k
      k = kts+2
! recompute vars : k
! recdepend vars : i,j,k,rom
! recompute pos : ASSIGN_STMT module_advect_em.f90:2583
! recompute vars : vel
      vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
! recompute vars : vel
      walls(3)=sign(1.,-vel)
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_v(i,k-2,j) = a_v(i,k-2,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
      a_v(i,k-1,j) = a_v(i,k-1,j)+walls(2)*(0.58333333+0.25*walls(3))
      a_v(i,k+1,j) = a_v(i,k+1,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
      a_v(i,k,j) = a_v(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
      a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i,k-1,j))-0.083333333*(v(i,k+1,j)+v(i,k-2,j))+0.083333333*(v(i,k+1,j)-v(i,&
&k-2,j)-3.*(v(i,k,j)-v(i,k-1,j)))*walls(3))
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2582
! recompute vars : k
      k = kts+2
! recompute vars : k
      a_rom(i,k,j-1) = a_rom(i,k,j-1)+0.5*a_vel
      a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2579
! recompute vars : k
      k = kts+1
! recompute vars : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k,j-1) = a_rom(i,k,j-1)+walls(1)*(walls(4)*v(i,k,j)+walls(7)*v(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(4)*v(i,k,j)+walls(7)*v(i,k-1,j))
      a_v(i,k-1,j) = a_v(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(7)
      a_v(i,k,j) = a_v(i,k,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(4)
    end do

    a_vflux(i_start:i_end,kts+1:kts+2) = 0.
    a_vflux(i_start:i_end,ktf-1:ktf) = 0.

    do k = kts+3, ktf-2
      do i = i_start, i_end
        vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
! recompute : vel
        walls(3)=sign(1.,-vel)
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_v(i,k-3,j) = a_v(i,k-3,j)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
        a_v(i,k-2,j) = a_v(i,k-2,j)+walls(2)*((-0.13333333)-0.083333333*walls(3))
        a_v(i,k-1,j) = a_v(i,k-1,j)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
        a_v(i,k+2,j) = a_v(i,k+2,j)+walls(2)*(0.016666667-0.016666667*walls(3))
        a_v(i,k+1,j) = a_v(i,k+1,j)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
        a_v(i,k,j) = a_v(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
        a_vel =walls(1)*(0.61666667*(v(i,k,j)+v(i,k-1,j))-0.13333333*(v(i,k+1,j)+v(i,k-2,j))+0.016666667*(v(i,k+2,j)+&
&v(i,k-3,j))-0.016666667*(v(i,k+2,j)-v(i,k-3,j)-5.*(v(i,k+1,j)-v(i,k-2,j))+10.*(v(i,k,j)-v(i,k-1,j)))*walls(3))
        a_rom(i,k,j-1) = a_rom(i,k,j-1)+0.5*a_vel
        a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+3:ktf-2) = 0.

  end do
else if (vert_order .eq. 4) then a_vert_order_test
  do j = j_end, j_start, -1
    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    walls(3)=fzp(kts+1); walls(4)=fzm(kts+1)
    walls(5)=fzp(ktf); walls(6)=fzm(ktf)

    do i = i_start, i_end
      k = ktf
! recompute : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k,j-1) = a_rom(i,k,j-1)+walls(1)*(walls(6)*v(i,k,j)+walls(5)*v(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(6)*v(i,k,j)+walls(5)*v(i,k-1,j))
      a_v(i,k-1,j) = a_v(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(5)
      a_v(i,k,j) = a_v(i,k,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(6)
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2622
! recompute vars : k
      k = kts+1
! recompute vars : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k,j-1) = a_rom(i,k,j-1)+walls(1)*(walls(4)*v(i,k,j)+walls(3)*v(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(4)*v(i,k,j)+walls(3)*v(i,k-1,j))
      a_v(i,k-1,j) = a_v(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(3)
      a_v(i,k,j) = a_v(i,k,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(4)
    end do

    a_vflux(i_start:i_end,kts+1) = 0.
    a_vflux(i_start:i_end,ktf) = 0.

    do k = kts+2, ktf-1
      do i = i_start, i_end
        vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
! recompute : vel
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_v(i,k-2,j) = a_v(i,k-2,j)-0.083333333*walls(2)
        a_v(i,k-1,j) = a_v(i,k-1,j)+0.58333333*walls(2)
        a_v(i,k+1,j) = a_v(i,k+1,j)-0.083333333*walls(2)
        a_v(i,k,j) = a_v(i,k,j)+0.58333333*walls(2)
        a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i,k-1,j))-0.083333333*(v(i,k+1,j)+v(i,k-2,j)))
        a_rom(i,k,j-1) = a_rom(i,k,j-1)+0.5*a_vel
        a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+2:ktf-1) = 0.

  end do
else if (vert_order .eq. 3) then a_vert_order_test
  do j = j_end, j_start, -1
    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    walls(3)=fzp(kts+1); walls(4)=fzm(kts+1)
    walls(5)=fzp(ktf); walls(6)=fzm(ktf)

    do i = i_start, i_end
      k = ktf
! recompute : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k,j-1) = a_rom(i,k,j-1)+walls(1)*(walls(6)*v(i,k,j)+walls(5)*v(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(6)*v(i,k,j)+walls(5)*v(i,k-1,j))
      a_v(i,k-1,j) = a_v(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(5)
      a_v(i,k,j) = a_v(i,k,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(6)
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2655
! recompute vars : k
      k = kts+1
! recompute vars : k
      walls(1)=0.5*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k,j-1) = a_rom(i,k,j-1)+walls(1)*(walls(4)*v(i,k,j)+walls(3)*v(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(4)*v(i,k,j)+walls(3)*v(i,k-1,j))
      a_v(i,k-1,j) = a_v(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(3)
      a_v(i,k,j) = a_v(i,k,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(4)
    end do

    a_vflux(i_start:i_end,kts+1) = 0.
    a_vflux(i_start:i_end,ktf) = 0.

    do k = kts+2, ktf-1
      do i = i_start, i_end
        vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
! recompute : vel
        walls(3)=sign(1.,-vel)
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_v(i,k-2,j) = a_v(i,k-2,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_v(i,k-1,j) = a_v(i,k-1,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_v(i,k+1,j) = a_v(i,k+1,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_v(i,k,j) = a_v(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i,k-1,j))-0.083333333*(v(i,k+1,j)+v(i,k-2,j))+0.083333333*(v(i,k+1,j)-&
&v(i,k-2,j)-3.*(v(i,k,j)-v(i,k-1,j)))*walls(3))
        a_rom(i,k,j-1) = a_rom(i,k,j-1)+0.5*a_vel
        a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+2:ktf-1) = 0.

  end do
else if (vert_order .eq. 2) then a_vert_order_test
  do j = j_start, j_end
    do k = kts, ktf
      gwalls=rdzw(k)
!     do i = i_start, i_end
!       a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!       a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!     end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*gwalls
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*gwalls
    end do

    do k = kts+1, ktf
      walls(2)=fzp(k); walls(3)=fzm(k)
      do i = i_start, i_end
        walls(1)=0.5*a_vflux(i,k)
!       a_vflux(i,k) = 0.
        a_rom(i,k,j-1) = a_rom(i,k,j-1)+walls(1)*(walls(3)*v(i,k,j)+walls(2)*v(i,k-1,j))
        a_rom(i,k,j) = a_rom(i,k,j)+walls(1)*(walls(3)*v(i,k,j)+walls(2)*v(i,k-1,j))
        a_v(i,k-1,j) = a_v(i,k-1,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(2)
        a_v(i,k,j) = a_v(i,k,j)+walls(1)*(rom(i,k,j)+rom(i,k,j-1))*walls(3)
      end do
    end do

    a_vflux(i_start:i_end,kts+1:ktf) = 0.

  end do
endif a_vert_order_test
! recdepend vars : jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2438
! recompute vars : j_start
j_start = jts
! recompute vars : j_start
! recdepend vars : j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:2439
! recompute vars : j_end
j_end = min(jte,jde)
! recompute vars : j_end
! recdepend vars : config_flags,j_end,j_start,jds,jts
! recompute pos : IF_STMT module_advect_em.f90:2444
! recompute vars : j_start
if (config_flags%open_ys) then
  j_start = max(jds+1,jts)
endif
! recompute vars : j_start
! recdepend vars : config_flags,j_end,j_start,jde,jte
! recompute pos : IF_STMT module_advect_em.f90:2448
! recompute vars : j_end
if (config_flags%open_ye) then
  j_end = min(jte,jde-1)
endif
! recompute vars : j_end
if (config_flags%open_xe .and. ite .eq. ide) then
  do j = j_start, j_end
    mrdx = msfv(ite-1,j)*rdx
! recompute : mrdx
    jp = min(jmax,j)
! recompute : jp
    jm = max(jmin,j-1)
! recompute : jm
    do k = kts, ktf
      uw = 0.5*(ru(ite,k,jp)+ru(ite,k,jm))
! recompute : uw
      ub = max(uw,0.)
! recompute : ub
      dup = ru(ite,k,jp)-ru(ite-1,k,jp)
! recompute : dup
      dum = ru(ite,k,jm)-ru(ite-1,k,jm)
! recompute : dum
      a_dum = -0.5*a_tendency(ite-1,k,j)*mrdx*v(ite-1,k,j)
      a_dup = -0.5*a_tendency(ite-1,k,j)*mrdx*v(ite-1,k,j)
      a_ub =-a_tendency(ite-1,k,j)*mrdx*(v_old(ite-1,k,j)-v_old(ite-2,k,j))
      a_v(ite-1,k,j) = a_v(ite-1,k,j)-0.5*a_tendency(ite-1,k,j)*mrdx*(dup+dum)
      a_v_old(ite-2,k,j) = a_v_old(ite-2,k,j)+a_tendency(ite-1,k,j)*mrdx*ub
      a_v_old(ite-1,k,j) = a_v_old(ite-1,k,j)-a_tendency(ite-1,k,j)*mrdx*ub
      a_ru(ite-1,k,jm) = a_ru(ite-1,k,jm)-a_dum
      a_ru(ite,k,jm) = a_ru(ite,k,jm)+a_dum
      a_ru(ite-1,k,jp) = a_ru(ite-1,k,jp)-a_dup
      a_ru(ite,k,jp) = a_ru(ite,k,jp)+a_dup
      a_uw = a_ub*(0.5+sign(0.5,uw-0.))
      
      a_ru(ite,k,jm) = a_ru(ite,k,jm)+0.5*a_uw
      a_ru(ite,k,jp) = a_ru(ite,k,jp)+0.5*a_uw
    end do
  end do
endif
! recdepend vars : jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2438
! recompute vars : j_start
j_start = jts
! recompute vars : j_start
! recdepend vars : j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:2439
! recompute vars : j_end
j_end = min(jte,jde)
! recompute vars : j_end
! recdepend vars : config_flags,j_end,j_start,jds,jts
! recompute pos : IF_STMT module_advect_em.f90:2444
! recompute vars : j_start
if (config_flags%open_ys) then
  j_start = max(jds+1,jts)
endif
! recompute vars : j_start
! recdepend vars : config_flags,j_end,j_start,jde,jte
! recompute pos : IF_STMT module_advect_em.f90:2448
! recompute vars : j_end
if (config_flags%open_ye) then
  j_end = min(jte,jde-1)
endif
! recompute vars : j_end
if (config_flags%open_xs .and. its .eq. ids) then
  do j = j_start, j_end
    mrdx = msfv(its,j)*rdx
! recompute : mrdx
    jp = min(jmax,j)
! recompute : jp
    jm = max(jmin,j-1)
! recompute : jm
    do k = kts, ktf
      uw = 0.5*(ru(its,k,jp)+ru(its,k,jm))
! recompute : uw
      ub = min(uw,0.)
! recompute : ub
      dup = ru(its+1,k,jp)-ru(its,k,jp)
! recompute : dup
      dum = ru(its+1,k,jm)-ru(its,k,jm)
! recompute : dum
      gwalls=a_tendency(its,k,j)*mrdx
      a_dum = -0.5*gwalls*v(its,k,j)
      a_dup = -0.5*gwalls*v(its,k,j)
      a_ub =-gwalls*(v_old(its+1,k,j)-v_old(its,k,j))
      a_v(its,k,j) = a_v(its,k,j)-0.5*gwalls*(dup+dum)
      a_v_old(its+1,k,j) = a_v_old(its+1,k,j)-gwalls*ub
      a_v_old(its,k,j) = a_v_old(its,k,j)+gwalls*ub
      a_ru(its+1,k,jm) = a_ru(its+1,k,jm)+a_dum
      a_ru(its,k,jm) = a_ru(its,k,jm)-a_dum
      a_ru(its+1,k,jp) = a_ru(its+1,k,jp)+a_dup
      a_ru(its,k,jp) = a_ru(its,k,jp)-a_dup
      a_uw = a_ub*(0.5+sign(0.5,0.-uw))
      
      a_ru(its,k,jm) = a_ru(its,k,jm)+0.5*a_uw
      a_ru(its,k,jp) = a_ru(its,k,jp)+0.5*a_uw
    end do
  end do
endif
if (config_flags%open_ye .and. jte .eq. jde) then
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  do k = kts, ktf
    do i = i_start, i_end
      vb = max(rv(i,k,jte)+cb*mut(i,jte-1),0.)
! recompute : vb
      a_v_old(i,k,jte-1) = a_v_old(i,k,jte-1)+a_tendency(i,k,jte)*rdy*vb
      a_v_old(i,k,jte) = a_v_old(i,k,jte)-a_tendency(i,k,jte)*rdy*vb
      a_vb = -a_tendency(i,k,jte)*rdy*(v_old(i,k,jte)-v_old(i,k,jte-1))
      a_mut(i,jte-1) = a_mut(i,jte-1)+a_vb*(0.5+sign(0.5,rv(i,k,jte)+cb*mut(i,jte-1)-0.))*cb
      a_rv(i,k,jte) = a_rv(i,k,jte)+a_vb*(0.5+sign(0.5,rv(i,k,jte)+cb*mut(i,jte-1)-0.))
    end do
  end do
endif
if (config_flags%open_ys .and. jts .eq. jds) then
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  do k = kts, ktf
    do i = i_start, i_end
      vb = min(rv(i,k,jts)-cb*mut(i,jts),0.)
! recompute : vb
      gwalls=a_tendency(i,k,jts)*rdy
      a_v_old(i,k,jts+1) = a_v_old(i,k,jts+1)-gwalls*vb
      a_v_old(i,k,jts) = a_v_old(i,k,jts)+gwalls*vb
      a_vb = -gwalls*(v_old(i,k,jts+1)-v_old(i,k,jts))
      a_mut(i,jts) = a_mut(i,jts)-a_vb*(0.5+sign(0.5,0.-(rv(i,k,jts)-cb*mut(i,jts))))*cb
      a_rv(i,k,jts) = a_rv(i,k,jts)+a_vb*(0.5+sign(0.5,0.-(rv(i,k,jts)-cb*mut(i,jts))))
    end do
  end do
endif
! recdepend vars : kde,kte
! recompute pos : ASSIGN_STMT module_advect_em.f90:1491
! recompute vars : ktf
ktf = min(kte,kde-1)
! recompute vars : ktf
a_horizontal_order_test: if (horz_order .eq. 6) then
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-3) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
! recompute : ktf
  j_start = jts
! recompute : j_start
  j_end = jte
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start_f = jds+3
  endif
! recompute : j_start_f
  if (degrade_ye) then
    j_end_f = jde-2
  endif
! recompute : j_end_f
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = jte
! recompute : j_end
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
! recompute : j_start
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-1,jte)
  endif
! recompute : j_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = i_start+2
  endif
! recompute : i_start,i_start_f
  if (degrade_xe) then
    i_end = min(ide-2,ite)
    i_end_f = ide-3
  endif
! recompute : i_end,i_end_f
  do j = j_end, j_start, -1
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfv(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do
    if (degrade_xe) then
      i = ide-2
! recompute : i
      do k = kts, ktf
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_v(i-2,k,j) = a_v(i-2,k,j)-0.083333333*walls(2)
        a_v(i-1,k,j) = a_v(i-1,k,j)+0.58333333*walls(2)
        a_v(i+1,k,j) = a_v(i+1,k,j)-0.083333333*walls(2)
        a_v(i,k,j) = a_v(i,k,j)+0.58333333*walls(2)
        a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i-1,k,j))-0.083333333*(v(i+1,k,j)+v(i-2,k,j)))
        a_ru(i,k,j-1) = a_ru(i,k,j-1)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
      end do
      a_fqx(ide-2,kts:ktf) = 0.

      if (i_end .eq. ide-2) then
        i = ide-1
! recompute : i
        do k = kts, ktf
          gwalls=0.25*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_ru(i_end+1,k,j-1) = a_ru(i_end+1,k,j-1)+gwalls*(v(i_end+1,k,j)+v(i_end,k,j))
          a_ru(i_end+1,k,j) = a_ru(i_end+1,k,j)+gwalls*(v(i_end+1,k,j)+v(i_end,k,j))
          a_v(i_end+1,k,j) = a_v(i_end+1,k,j)+gwalls*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))
          a_v(i_end,k,j) = a_v(i_end,k,j)+gwalls*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))
        end do
        a_fqx(ide-1,kts:ktf) = 0.
      endif

    endif
    if (degrade_xs) then
      i = ids+2
! recompute : i
      do k = kts, ktf
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_v(i-2,k,j) = a_v(i-2,k,j)-0.083333333*walls(2)
        a_v(i-1,k,j) = a_v(i-1,k,j)+0.58333333*walls(2)
        a_v(i+1,k,j) = a_v(i+1,k,j)-0.083333333*walls(2)
        a_v(i,k,j) = a_v(i,k,j)+0.58333333*walls(2)
        a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i-1,k,j))-0.083333333*(v(i+1,k,j)+v(i-2,k,j)))
        a_ru(i,k,j-1) = a_ru(i,k,j-1)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
      end do
      a_fqx(ids+2,kts:ktf) = 0.

      if (i_start .eq. ids+1) then
        i = ids+1
! recompute : i
        do k = kts, ktf
          gwalls=0.25*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_ru(i,k,j-1) = a_ru(i,k,j-1)+gwalls*(v(i,k,j)+v(i-1,k,j))
          a_ru(i,k,j) = a_ru(i,k,j)+gwalls*(v(i,k,j)+v(i-1,k,j))
          a_v(i-1,k,j) = a_v(i-1,k,j)+gwalls*(ru(i,k,j)+ru(i,k,j-1))
          a_v(i,k,j) = a_v(i,k,j)+gwalls*(ru(i,k,j)+ru(i,k,j-1))
        end do
        a_fqx(ids+1,kts:ktf) = 0.
      endif

    endif

    do k = kts, ktf
      do i = i_start_f, i_end_f
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_v(i-3,k,j) = a_v(i-3,k,j)+0.016666667*walls(2)
        a_v(i-2,k,j) = a_v(i-2,k,j)-0.13333333*walls(2)
        a_v(i-1,k,j) = a_v(i-1,k,j)+0.61666667*walls(2)
        a_v(i+2,k,j) = a_v(i+2,k,j)+0.016666667*walls(2)
        a_v(i+1,k,j) = a_v(i+1,k,j)-0.13333333*walls(2)
        a_v(i,k,j) = a_v(i,k,j)+0.61666667*walls(2)
        a_vel =walls(1)*(0.61666667*(v(i,k,j)+v(i-1,k,j))-0.13333333*(v(i+1,k,j)+v(i-2,k,j))+0.016666667*(v(i+2,k,j)+v(i-&
&3,k,j)))
        a_ru(i,k,j-1) = a_ru(i,k,j-1)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
      end do
    end do
    a_fqx(i_start_f:i_end_f,kts:ktf) = 0.

  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:1530
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:1531
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1532
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:1533
! recompute vars : j_end
  j_end = jte
! recompute vars : j_end
! recdepend vars : degrade_ys,i_end,i_start,j_end,j_start,jds,jts
! recompute pos : IF_STMT module_advect_em.f90:1541
! recompute vars : j_start
  if (degrade_ys) then
    j_start = max(jts,jds+1)
  endif
! recompute vars : j_start
! recdepend vars : degrade_ye,i_end,i_start,j_end,j_start,jde,jte
! recompute pos : IF_STMT module_advect_em.f90:1546
! recompute vars : j_end
  if (degrade_ye) then
    j_end = min(jte,jde-1)
  endif
! recompute vars : j_end
  a_j_loop_y_flux_6: do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:1553
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:1554
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    j_loop_y_flux_9c: do j4 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do j_loop_y_flux_9c
!     if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfv(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_v(i,k,j-3) = a_v(i,k,j-3)+0.016666667*walls(2)
          a_v(i,k,j-2) = a_v(i,k,j-2)-0.13333333*walls(2)
          a_v(i,k,j-1) = a_v(i,k,j-1)+0.61666667*walls(2)
          a_v(i,k,j+2) = a_v(i,k,j+2)+0.016666667*walls(2)
          a_v(i,k,j+1) = a_v(i,k,j+1)-0.13333333*walls(2)
          a_v(i,k,j) = a_v(i,k,j)+0.61666667*walls(2)
          a_vel =walls(1)*(0.61666667*(v(i,k,j)+v(i,k,j-1))-0.13333333*(v(i,k,j+1)+v(i,k,j-2))+0.016666667*(v(i,k,j+2)&
&+v(i,k,j-3)))
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
          
        end do
      end do
    else if (j .eq. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          vb = v(i,k,j-1)
! recompute : vb
          if (specified .and. v(i,k,j) .lt. 0.) then
            vb = v(i,k,j)
          endif
! recompute : vb
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+gwalls*(v(i,k,j)+vb)
          a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(v(i,k,j)+vb)
          a_v(i,k,j) = a_v(i,k,j)+gwalls*(rv(i,k,j)+rv(i,k,j-1))
          a_vb = gwalls*(rv(i,k,j)+rv(i,k,j-1))
          if (specified .and. v(i,k,j) .lt. 0.) then
            a_v(i,k,j) = a_v(i,k,j)+a_vb
          else
            a_v(i,k,j-1) = a_v(i,k,j-1)+a_vb
          endif
        end do
      end do
    else if (j .eq. jds+2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_v(i,k,j-2) = a_v(i,k,j-2)-0.083333333*walls(2)
          a_v(i,k,j-1) = a_v(i,k,j-1)+0.58333333*walls(2)
          a_v(i,k,j+1) = a_v(i,k,j+1)-0.083333333*walls(2)
          a_v(i,k,j) = a_v(i,k,j)+0.58333333*walls(2)
          a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i,k,j-1))-0.083333333*(v(i,k,j+1)+v(i,k,j-2)))
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
          
        end do
      end do
    else if (j .eq. jde) then
      do k = kts, ktf
        do i = i_start, i_end
          vb = v(i,k,j)
! recompute : vb
          if (specified .and. v(i,k,j-1) .gt. 0.) then
            vb = v(i,k,j-1)
          endif
! recompute : vb
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+gwalls*(vb+v(i,k,j-1))
          a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(vb+v(i,k,j-1))
          a_v(i,k,j-1) = a_v(i,k,j-1)+gwalls*(rv(i,k,j)+rv(i,k,j-1))
          a_vb = gwalls*(rv(i,k,j)+rv(i,k,j-1))
          if (specified .and. v(i,k,j-1) .gt. 0.) then
            a_v(i,k,j-1) = a_v(i,k,j-1)+a_vb
          else
            a_v(i,k,j) = a_v(i,k,j)+a_vb
          endif
        end do
      end do
    else if (j .eq. jde-1) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_v(i,k,j-2) = a_v(i,k,j-2)-0.083333333*walls(2)
          a_v(i,k,j-1) = a_v(i,k,j-1)+0.58333333*walls(2)
          a_v(i,k,j+1) = a_v(i,k,j+1)-0.083333333*walls(2)
          a_v(i,k,j) = a_v(i,k,j)+0.58333333*walls(2)
          a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i,k,j-1))-0.083333333*(v(i,k,j+1)+v(i,k,j-2)))
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
          
        end do
      end do
    endif
  end do a_j_loop_y_flux_6
else if (horz_order .eq. 5) then a_horizontal_order_test
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-3) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
  j_start = jts
! recompute : j_start
  j_end = jte
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start_f = jds+3
  endif
! recompute : j_start_f
  if (degrade_ye) then
    j_end_f = jde-2
  endif
! recompute : j_end_f
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = jte
! recompute : j_end
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
! recompute : j_start
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-1,jte)
  endif
! recompute : j_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = i_start+2
  endif
! recompute : i_start,i_start_f
  if (degrade_xe) then
    i_end = min(ide-2,ite)
    i_end_f = ide-3
  endif
! recompute : i_end,i_end_f
  do j = j_end, j_start, -1
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfv(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do
    if (degrade_xe) then
      i = ide-2
! recompute : i
      do k = kts, ktf
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_v(i-2,k,j) = a_v(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_v(i-1,k,j) = a_v(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_v(i+1,k,j) = a_v(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_v(i,k,j) = a_v(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i-1,k,j))-0.083333333*(v(i+1,k,j)+v(i-2,k,j))+0.083333333*(v(i+1,k,j)-v(i-&
&2,k,j)-3.*(v(i,k,j)-v(i-1,k,j)))*walls(3))
        a_ru(i,k,j-1) = a_ru(i,k,j-1)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
      end do

      if (i_end .eq. ide-2) then
        i = ide-1
! recompute : i
        do k = kts, ktf
          gwalls=0.25*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_ru(i_end+1,k,j-1) = a_ru(i_end+1,k,j-1)+gwalls*(v(i_end+1,k,j)+v(i_end,k,j))
          a_ru(i_end+1,k,j) = a_ru(i_end+1,k,j)+gwalls*(v(i_end+1,k,j)+v(i_end,k,j))
          a_v(i_end+1,k,j) = a_v(i_end+1,k,j)+gwalls*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))
          a_v(i_end,k,j) = a_v(i_end,k,j)+gwalls*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))
        end do
        a_fqx(ide-1,kts:ktf) = 0.
      endif

    endif
    if (degrade_xs) then
      i = ids+2
! recompute : i
      do k = kts, ktf
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_v(i-2,k,j) = a_v(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_v(i-1,k,j) = a_v(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_v(i+1,k,j) = a_v(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_v(i,k,j) = a_v(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i-1,k,j))-0.083333333*(v(i+1,k,j)+v(i-2,k,j))+0.083333333*(v(i+1,k,j)-v(i-&
&2,k,j)-3.*(v(i,k,j)-v(i-1,k,j)))*walls(3))
        a_ru(i,k,j-1) = a_ru(i,k,j-1)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
        
      end do
      if (i_start .eq. ids+1) then
        i = ids+1
! recompute : i
        do k = kts, ktf
          gwalls=0.25*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_ru(i,k,j-1) = a_ru(i,k,j-1)+gwalls*(v(i,k,j)+v(i-1,k,j))
          a_ru(i,k,j) = a_ru(i,k,j)+gwalls*(v(i,k,j)+v(i-1,k,j))
          a_v(i-1,k,j) = a_v(i-1,k,j)+gwalls*(ru(i,k,j)+ru(i,k,j-1))
          a_v(i,k,j) = a_v(i,k,j)+gwalls*(ru(i,k,j)+ru(i,k,j-1))
        end do
        a_fqx(ids+1,kts:ktf) = 0.
      endif
    endif

    do k = kts, ktf
      do i = i_start_f, i_end_f
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel) 
        a_v(i-3,k,j) = a_v(i-3,k,j)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
        a_v(i-2,k,j) = a_v(i-2,k,j)+walls(2)*((-0.13333333)-0.083333333*walls(3))
        a_v(i-1,k,j) = a_v(i-1,k,j)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
        a_v(i+2,k,j) = a_v(i+2,k,j)+walls(2)*(0.016666667-0.016666667*walls(3))
        a_v(i+1,k,j) = a_v(i+1,k,j)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
        a_v(i,k,j) = a_v(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
        a_vel =walls(1)*(0.61666667*(v(i,k,j)+v(i-1,k,j))-0.13333333*(v(i+1,k,j)+v(i-2,k,j))+0.016666667*(v(i+2,k,j)+v(i-&
&3,k,j))-0.016666667*(v(i+2,k,j)-v(i-3,k,j)-5.*(v(i+1,k,j)-v(i-2,k,j))+10.*(v(i,k,j)-v(i-1,k,j)))*walls(3))
        a_ru(i,k,j-1) = a_ru(i,k,j-1)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
        
      end do
    end do
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:1765
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:1766
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:1767
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:1768
! recompute vars : j_end
  j_end = jte
! recompute vars : j_end
! recdepend vars : degrade_ys,i_end,i_start,j_end,j_start,jds,jts
! recompute pos : IF_STMT module_advect_em.f90:1776
! recompute vars : j_start
  if (degrade_ys) then
    j_start = max(jts,jds+1)
  endif
! recompute vars : j_start
! recdepend vars : degrade_ye,i_end,i_start,j_end,j_start,jde,jte
! recompute pos : IF_STMT module_advect_em.f90:1781
! recompute vars : j_end
  if (degrade_ye) then
    j_end = min(jte,jde-1)
  endif
! recompute vars : j_end
  a_j_loop_y_flux_5: do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:1788
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:1789
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    j_loop_y_flux_9a: do j1 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do j_loop_y_flux_9a
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfv(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_v(i,k,j-3) = a_v(i,k,j-3)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
          a_v(i,k,j-2) = a_v(i,k,j-2)+walls(2)*((-0.13333333)-0.083333333*walls(3))
          a_v(i,k,j-1) = a_v(i,k,j-1)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
          a_v(i,k,j+2) = a_v(i,k,j+2)+walls(2)*(0.016666667-0.016666667*walls(3))
          a_v(i,k,j+1) = a_v(i,k,j+1)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
          a_v(i,k,j) = a_v(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
          a_vel =walls(1)*(0.61666667*(v(i,k,j)+v(i,k,j-1))-0.13333333*(v(i,k,j+1)+v(i,k,j-2))+0.016666667*(v(i,k,j+2)&
&+v(i,k,j-3))-0.016666667*(v(i,k,j+2)-v(i,k,j-3)-5.*(v(i,k,j+1)-v(i,k,j-2))+10.*(v(i,k,j)-v(i,k,j-1)))*walls(3))
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
          
        end do
      end do
    else if (j .eq. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          vb = v(i,k,j-1)
! recompute : vb
          if (specified .and. v(i,k,j) .lt. 0.) then
            vb = v(i,k,j)
          endif
! recompute : vb
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+gwalls*(v(i,k,j)+vb)
          a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(v(i,k,j)+vb)
          a_v(i,k,j) = a_v(i,k,j)+gwalls*(rv(i,k,j)+rv(i,k,j-1))
          a_vb = gwalls*(rv(i,k,j)+rv(i,k,j-1))
          if (specified .and. v(i,k,j) .lt. 0.) then
            a_v(i,k,j) = a_v(i,k,j)+a_vb
          else
            a_v(i,k,j-1) = a_v(i,k,j-1)+a_vb
          endif
        end do
      end do
    else if (j .eq. jds+2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_v(i,k,j-2) = a_v(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
          a_v(i,k,j-1) = a_v(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
          a_v(i,k,j+1) = a_v(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
          a_v(i,k,j) = a_v(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
          a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i,k,j-1))-0.083333333*(v(i,k,j+1)+v(i,k,j-2))+0.083333333*(v(i,k,j+&
&1)-v(i,k,j-2)-3.*(v(i,k,j)-v(i,k,j-1)))*walls(3))
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
          
        end do
      end do
    else if (j .eq. jde) then
      do k = kts, ktf
        do i = i_start, i_end
          vb = v(i,k,j)
! recompute : vb
          if (specified .and. v(i,k,j-1) .gt. 0.) then
            vb = v(i,k,j-1)
          endif
! recompute : vb
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+gwalls*(vb+v(i,k,j-1))
          a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(vb+v(i,k,j-1))
          a_v(i,k,j-1) = a_v(i,k,j-1)+gwalls*(rv(i,k,j)+rv(i,k,j-1))
          a_vb = gwalls*(rv(i,k,j)+rv(i,k,j-1))
          if (specified .and. v(i,k,j-1) .gt. 0.) then
            a_v(i,k,j-1) = a_v(i,k,j-1)+a_vb
          else
            a_v(i,k,j) = a_v(i,k,j)+a_vb
          endif
        end do
      end do
    else if (j .eq. jde-1) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_v(i,k,j-2) = a_v(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
          a_v(i,k,j-1) = a_v(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
          a_v(i,k,j+1) = a_v(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
          a_v(i,k,j) = a_v(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
          a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i,k,j-1))-0.083333333*(v(i,k,j+1)+v(i,k,j-2))+0.083333333*(v(i,k,j+&
&1)-v(i,k,j-2)-3.*(v(i,k,j)-v(i,k,j-1)))*walls(3))
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
          
        end do
      end do
    endif
  end do a_j_loop_y_flux_5
else if (horz_order .eq. 4) then a_horizontal_order_test
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-1) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
! recompute : ktf
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = jte
! recompute : j_end
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
! recompute : j_start
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-1,jte)
  endif
! recompute : j_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
! recompute : i_start,i_start_f
  if (degrade_xe) then
    i_end = ide-2
    i_end_f = ide-2
  endif
! recompute : i_end,i_end_f
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfv(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do
    if (degrade_xe) then
      do k = kts, ktf
        gwalls=0.25*a_fqx(i_end+1,k); a_fqx(i_end+1,k)=0.
        a_ru(i_end+1,k,j-1) = a_ru(i_end+1,k,j-1)+gwalls*(v(i_end+1,k,j)+v(i_end,k,j))
        a_ru(i_end+1,k,j) = a_ru(i_end+1,k,j)+gwalls*(v(i_end+1,k,j)+v(i_end,k,j))
        a_v(i_end+1,k,j) = a_v(i_end+1,k,j)+gwalls*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))
        a_v(i_end,k,j) = a_v(i_end,k,j)+gwalls*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))
      end do
    endif
    if (degrade_xs) then
      do k = kts, ktf
        gwalls=0.25*a_fqx(i_start,k); a_fqx(i_start,k) = 0.
        a_ru(i_start,k,j-1) = a_ru(i_start,k,j-1)+gwalls*(v(i_start,k,j)+v(i_start-1,k,j))
        a_ru(i_start,k,j) = a_ru(i_start,k,j)+gwalls*(v(i_start,k,j)+v(i_start-1,k,j))
        a_v(i_start-1,k,j) = a_v(i_start-1,k,j)+gwalls*(ru(i_start,k,j)+ru(i_start,k,j-1))
        a_v(i_start,k,j) = a_v(i_start,k,j)+gwalls*(ru(i_start,k,j)+ru(i_start,k,j-1))
      end do
    endif

    do k = kts, ktf
      do i = i_start_f, i_end_f
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_v(i-2,k,j) = a_v(i-2,k,j)-0.083333333*walls(2)
        a_v(i-1,k,j) = a_v(i-1,k,j)+0.58333333*walls(2)
        a_v(i+1,k,j) = a_v(i+1,k,j)-0.083333333*walls(2)
        a_v(i,k,j) = a_v(i,k,j)+0.58333333*walls(2)
        a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i-1,k,j))-0.083333333*(v(i+1,k,j)+v(i-2,k,j)))
        a_ru(i,k,j-1) = a_ru(i,k,j-1)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
      end do
    end do
    a_fqx(i_start_f:i_end_f,kts:ktf) = 0.

  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:1998
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:1999
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2000
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:2001
! recompute vars : j_end
  j_end = jte
! recompute vars : j_end
! recdepend vars : degrade_ys,i_end,i_start,j_end,j_start,jds
! recompute pos : IF_STMT module_advect_em.f90:2010
! recompute vars : j_start
  if (degrade_ys) then
    j_start = jds+1
  endif
! recompute vars : j_start
! recdepend vars : degrade_ye,i_end,i_start,j_end,j_start,jde
! recompute pos : IF_STMT module_advect_em.f90:2015
! recompute vars : j_end
  if (degrade_ye) then
    j_end = jde-1
  endif
! recompute vars : j_end
  do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:2023
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
! recdepend vars : jp0
! recompute pos : ASSIGN_STMT module_advect_em.f90:2024
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
    do j2 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfv(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .eq. j_start .and. degrade_ys) then
      do k = kts, ktf
        do i = i_start, i_end
          vb = v(i,k,j-1)
! recompute : vb
          if (specified .and. v(i,k,j) .lt. 0.) then
            vb = v(i,k,j)
          endif
! recompute : vb
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+gwalls*(v(i,k,j)+vb)
          a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(v(i,k,j)+vb)
          a_v(i,k,j) = a_v(i,k,j)+gwalls*(rv(i,k,j)+rv(i,k,j-1))
          a_vb = gwalls*(rv(i,k,j)+rv(i,k,j-1))
          if (specified .and. v(i,k,j) .lt. 0.) then
            a_v(i,k,j) = a_v(i,k,j)+a_vb
          endif
          a_v(i,k,j-1) = a_v(i,k,j-1)+a_vb
        end do
      end do
    else if (j .eq. j_end+1 .and. degrade_ye) then
      do k = kts, ktf
        do i = i_start, i_end
          vb = v(i,k,j)
! recompute : vb
          if (specified .and. v(i,k,j-1) .gt. 0.) then
            vb = v(i,k,j-1)
          endif
! recompute : vb
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+gwalls*(vb+v(i,k,j-1))
          a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(vb+v(i,k,j-1))
          a_v(i,k,j-1) = a_v(i,k,j-1)+gwalls*(rv(i,k,j)+rv(i,k,j-1))
          a_vb = gwalls*(rv(i,k,j)+rv(i,k,j-1))
          if (specified .and. v(i,k,j-1) .gt. 0.) then
            a_v(i,k,j-1) = a_v(i,k,j-1)+a_vb
          else
            a_v(i,k,j) = a_v(i,k,j)+a_vb
          endif
        end do
      end do
    else
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_v(i,k,j-2) = a_v(i,k,j-2)-0.083333333*walls(2)
          a_v(i,k,j-1) = a_v(i,k,j-1)+0.58333333*walls(2)
          a_v(i,k,j+1) = a_v(i,k,j+1)-0.083333333*walls(2)
          a_v(i,k,j) = a_v(i,k,j)+0.58333333*walls(2)
          a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i,k,j-1))-0.083333333*(v(i,k,j+1)+v(i,k,j-2)))
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
          
        end do
      end do
    endif
  end do
else if (horz_order .eq. 3) then a_horizontal_order_test
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-1) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
! recompute : ktf
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = jte
! recompute : j_end
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
! recompute : j_start
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-1,jte)
  endif
! recompute : j_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
! recompute : i_start,i_start_f
  if (degrade_xe) then
    i_end = ide-2
    i_end_f = ide-2
  endif
! recompute : i_end,i_end_f
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfv(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do
    if (degrade_xe) then
      do k = kts, ktf
        gwalls=0.25*a_fqx(i_end+1,k); a_fqx(i_end+1,k)=0.
        a_ru(i_end+1,k,j-1) = a_ru(i_end+1,k,j-1)+gwalls*(v(i_end+1,k,j)+v(i_end,k,j))
        a_ru(i_end+1,k,j) = a_ru(i_end+1,k,j)+gwalls*(v(i_end+1,k,j)+v(i_end,k,j))
        a_v(i_end+1,k,j) = a_v(i_end+1,k,j)+gwalls*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))
        a_v(i_end,k,j) = a_v(i_end,k,j)+gwalls*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))
      end do
    endif
    if (degrade_xs) then
      do k = kts, ktf
        gwalls=0.25*a_fqx(i_start,k); a_fqx(i_start,k) = 0.
        a_ru(i_start,k,j-1) = a_ru(i_start,k,j-1)+gwalls*(v(i_start,k,j)+v(i_start-1,k,j))
        a_ru(i_start,k,j) = a_ru(i_start,k,j)+gwalls*(v(i_start,k,j)+v(i_start-1,k,j))
        a_v(i_start-1,k,j) = a_v(i_start-1,k,j)+gwalls*(ru(i_start,k,j)+ru(i_start,k,j-1))
        a_v(i_start,k,j) = a_v(i_start,k,j)+gwalls*(ru(i_start,k,j)+ru(i_start,k,j-1))
      end do
    endif
    do k = kts, ktf
      
      do i = i_start_f, i_end_f
        
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_v(i-2,k,j) = a_v(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_v(i-1,k,j) = a_v(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_v(i+1,k,j) = a_v(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_v(i,k,j) = a_v(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i-1,k,j))-0.083333333*(v(i+1,k,j)+v(i-2,k,j))+0.083333333*(v(i+1,k,j)-v(i-&
&2,k,j)-3.*(v(i,k,j)-v(i-1,k,j)))*walls(3))
        a_ru(i,k,j-1) = a_ru(i,k,j-1)+0.5*a_vel
        a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_vel
        
      end do
    end do
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:2173
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:2174
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:2175
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:2176
! recompute vars : j_end
  j_end = jte
! recompute vars : j_end
! recdepend vars : degrade_ys,i_end,i_start,j_end,j_start,jds
! recompute pos : IF_STMT module_advect_em.f90:2185
! recompute vars : j_start
  if (degrade_ys) then
    j_start = jds+1
  endif
! recompute vars : j_start
! recdepend vars : degrade_ye,i_end,i_start,j_end,j_start,jde
! recompute pos : IF_STMT module_advect_em.f90:2190
! recompute vars : j_end
  if (degrade_ye) then
    j_end = jde-1
  endif
! recompute vars : j_end
  do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:2198
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
! recdepend vars : jp0
! recompute pos : ASSIGN_STMT module_advect_em.f90:2199
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
    do j3 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfv(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .eq. j_start .and. degrade_ys) then
      do k = kts, ktf
        do i = i_start, i_end
          vb = v(i,k,j-1)
! recompute : vb
          if (specified .and. v(i,k,j) .lt. 0.) then
            vb = v(i,k,j)
          endif
! recompute : vb
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+gwalls*(v(i,k,j)+vb)
          a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(v(i,k,j)+vb)
          a_v(i,k,j) = a_v(i,k,j)+gwalls*(rv(i,k,j)+rv(i,k,j-1))
          a_vb = gwalls*(rv(i,k,j)+rv(i,k,j-1))
          if (specified .and. v(i,k,j) .lt. 0.) then
            a_v(i,k,j) = a_v(i,k,j)+a_vb
          else
            a_v(i,k,j-1) = a_v(i,k,j-1)+a_vb
          endif
        end do
      end do
    else if (j .eq. j_end+1 .and. degrade_ye) then
      do k = kts, ktf
        do i = i_start, i_end
          vb = v(i,k,j)
! recompute : vb
          if (specified .and. v(i,k,j-1) .gt. 0.) then
            vb = v(i,k,j-1)
          endif
! recompute : vb
          gwalls=0.25*a_fqy(i,k,jp1); a_fqy(i,k,jp1) = 0.
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+gwalls*(vb+v(i,k,j-1))
          a_rv(i,k,j) = a_rv(i,k,j)+gwalls*(vb+v(i,k,j-1))
          a_v(i,k,j-1) = a_v(i,k,j-1)+gwalls*(rv(i,k,j)+rv(i,k,j-1))
          a_vb = gwalls*(rv(i,k,j)+rv(i,k,j-1))
          if (specified .and. v(i,k,j-1) .gt. 0.) then
            a_v(i,k,j-1) = a_v(i,k,j-1)+a_vb
          else
            a_v(i,k,j) = a_v(i,k,j)+a_vb
          endif
        end do
      end do
    else
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_v(i,k,j-2) = a_v(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
          a_v(i,k,j-1) = a_v(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
          a_v(i,k,j+1) = a_v(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
          a_v(i,k,j) = a_v(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
          a_vel =walls(1)*(0.58333333*(v(i,k,j)+v(i,k,j-1))-0.083333333*(v(i,k,j+1)+v(i,k,j-2))+0.083333333*(v(i,k,j+&
&1)-v(i,k,j-2)-3.*(v(i,k,j)-v(i,k,j-1)))*walls(3))
          a_rv(i,k,j-1) = a_rv(i,k,j-1)+0.5*a_vel
          a_rv(i,k,j) = a_rv(i,k,j)+0.5*a_vel
          
        end do
      end do
    endif
  end do
else if (horz_order .eq. 2) then a_horizontal_order_test
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = jte
! recompute : j_end
  if (config_flags%open_ys) then
    j_start = max(jds+1,jts)
  endif
! recompute : j_start
  if (config_flags%open_ye) then
    j_end = min(jde-1,jte)
  endif
! recompute : j_end
  if (specified) then
    j_start = max(jds+2,jts)
  endif
! recompute : j_start
  if (specified) then
    j_end = min(jde-2,jte)
  endif
! recompute : j_end
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
! recompute : i_start
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-2,ite)
  endif
! recompute : i_end
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfv(i,j)*rdx
! recompute : mrdx
        gwalls=0.25*a_tendency(i,k,j)*mrdx
        a_ru(i+1,k,j-1) = a_ru(i+1,k,j-1)-gwalls*(v(i+1,k,j)+v(i,k,j))
        a_ru(i,k,j-1) = a_ru(i,k,j-1)+gwalls*(v(i,k,j)+v(i-1,k,j))
        a_ru(i+1,k,j) = a_ru(i+1,k,j)-gwalls*(v(i+1,k,j)+v(i,k,j))
        a_ru(i,k,j) = a_ru(i,k,j)+gwalls*(v(i,k,j)+v(i-1,k,j))
        a_v(i-1,k,j) = a_v(i-1,k,j)+gwalls*(ru(i,k,j)+ru(i,k,j-1))
        a_v(i+1,k,j) = a_v(i+1,k,j)-gwalls*(ru(i+1,k,j)+ru(i+1,k,j-1))
        a_v(i,k,j) = a_v(i,k,j)-gwalls*(ru(i+1,k,j)+ru(i+1,k,j-1)-(ru(i,k,j)+ru(i,k,j-1)))
      end do
    end do
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:2319
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:2320
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
  if (specified .and. jte .ge. jde-1) then
    j = jde-1
! recompute : j
    do k = kts, ktf
      do i = i_start, i_end
        mrdy = msfv(i,j)*rdy
! recompute : mrdy
        vb = v(i,k,j+1)
! recompute : vb
        if (v(i,k,j) .gt. 0.) then
          vb = v(i,k,j)
        endif
! recompute : vb
        gwalls=0.25*a_tendency(i,k,j)*mrdy
        a_rv(i,k,j-1) = a_rv(i,k,j-1)+gwalls*(v(i,k,j)+v(i,k,j-1))
        a_rv(i,k,j+1) = a_rv(i,k,j+1)-gwalls*(vb+v(i,k,j))
        a_rv(i,k,j) = a_rv(i,k,j)-gwalls*(vb+v(i,k,j)-(v(i,k,j)+v(i,k,j-1)))
        a_v(i,k,j-1) = a_v(i,k,j-1)+gwalls*(rv(i,k,j)+rv(i,k,j-1))
        a_v(i,k,j) = a_v(i,k,j)-gwalls*(rv(i,k,j+1)+rv(i,k,j)-(rv(i,k,j)+rv(i,k,j-1)))
        a_vb = -gwalls*(rv(i,k,j+1)+rv(i,k,j))
        if (v(i,k,j) .gt. 0.) then
          a_v(i,k,j) = a_v(i,k,j)+a_vb
        else
          a_v(i,k,j+1) = a_v(i,k,j+1)+a_vb
        endif
      end do
    end do
  endif
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:2319
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:2320
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
  if (specified .and. jts .le. jds+1) then
    j = jds+1
! recompute : j
    do k = kts, ktf
      do i = i_start, i_end
        mrdy = msfv(i,j)*rdy
! recompute : mrdy
        vb = v(i,k,j-1)
! recompute : vb
        if (v(i,k,j) .lt. 0.) then
          vb = v(i,k,j)
        endif
! recompute : vb
        gwalls=0.25*a_tendency(i,k,j)*mrdy
        a_rv(i,k,j-1) = a_rv(i,k,j-1)+gwalls*(v(i,k,j)+vb)
        a_rv(i,k,j+1) = a_rv(i,k,j+1)-gwalls*(v(i,k,j+1)+v(i,k,j))
        a_rv(i,k,j) = a_rv(i,k,j)-gwalls*(v(i,k,j+1)+v(i,k,j)-(v(i,k,j)+vb))
        a_v(i,k,j+1) = a_v(i,k,j+1)-gwalls*(rv(i,k,j+1)+rv(i,k,j))
        a_v(i,k,j) = a_v(i,k,j)-gwalls*(rv(i,k,j+1)+rv(i,k,j)-(rv(i,k,j)+rv(i,k,j-1)))
        a_vb = gwalls*(rv(i,k,j)+rv(i,k,j-1))
        if (v(i,k,j) .lt. 0.) then
          a_v(i,k,j) = a_v(i,k,j)+a_vb
        else
          a_v(i,k,j-1) = a_v(i,k,j-1)+a_vb
        endif
      end do
    end do
  endif
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:2319
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:2320
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdy = msfv(i,j)*rdy
! recompute : mrdy
        gwalls=0.25*a_tendency(i,k,j)*mrdy
        a_rv(i,k,j-1) = a_rv(i,k,j-1)+gwalls*(v(i,k,j)+v(i,k,j-1))
        a_rv(i,k,j+1) = a_rv(i,k,j+1)-gwalls*(v(i,k,j+1)+v(i,k,j))
        a_rv(i,k,j) = a_rv(i,k,j)-gwalls*(v(i,k,j+1)+v(i,k,j)-(v(i,k,j)+v(i,k,j-1)))
        a_v(i,k,j-1) = a_v(i,k,j-1)+gwalls*(rv(i,k,j)+rv(i,k,j-1))
        a_v(i,k,j+1) = a_v(i,k,j+1)-gwalls*(rv(i,k,j+1)+rv(i,k,j))
        a_v(i,k,j) = a_v(i,k,j)-gwalls*(rv(i,k,j+1)+rv(i,k,j)-(rv(i,k,j)+rv(i,k,j-1)))
      end do
    end do
  end do
endif a_horizontal_order_test

   call trace_exit("a_advect_v")

end subroutine a_advect_v


subroutine a_advect_w( w, a_w, w_old, a_w_old, a_tendency, ru, a_ru, rv, a_rv, rom, a_rom, config_flags, msft, fzm, fzp, rdx, rdy, &
&rdzu, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_rom(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_tendency(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w_old(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: rdzu(kms:kme)
real, intent(in) :: rom(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w_old(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_fqx(its:ite+1,kts:kte)
real a_fqy(its:ite,kts:kte,2)
real a_ub
real a_uw
real a_vb
real a_vel
real a_vflux(its:ite,kts:kte)
real a_vw
logical degrade_xe
logical degrade_xs
logical degrade_ye
logical degrade_ys
integer horz_order
integer i
integer i_end
integer i_end_f
integer i_start
integer i_start_f
integer j
integer j1
integer j2
integer j3
integer j4
integer j_end
integer j_end_f
integer j_start
integer j_start_f
integer jp0
integer jp1
integer jtmp
integer k
integer ktf
real mrdx
real mrdy
logical specified
real ub
real uw
real vb
real vel
integer vert_order
real vw
real walls(7),gwalls
real iwalls(ims:ime)
real kwalls(kms:kme)

   call trace_entry("a_advect_w")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_fqx(:,:) = 0.
a_fqy(:,:,:) = 0.
a_vflux(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
ktf = min(kte,kde-1)
! recompute : ktf
horz_order = config_flags%h_sca_adv_order
! recompute : horz_order
vert_order = config_flags%v_sca_adv_order
! recompute : vert_order
horizontal_order_tesu: if (horz_order .eq. 6) then
else if (horz_order .eq. 4) then horizontal_order_tesu
  ktf = min(kte,kde-1)
else if (horz_order .eq. 3) then horizontal_order_tesu
  ktf = min(kte,kde-1)
endif horizontal_order_tesu
! recompute : ktf
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end; revised by walls
a_vert_order_test: if (vert_order .eq. 6) then
  do j = j_end, j_start, -1
!   k = ktf+1
! recompute : k
!   do i = i_start, i_end
!     a_vflux(i,k) = a_vflux(i,k)+2*a_tendency(i,k,j)*rdzu(k-1)
!   end do

    a_vflux(i_start:i_end,ktf+1) = a_vflux(i_start:i_end,ktf+1)+2*a_tendency(i_start:i_end,ktf+1,j)*rdzu(ktf)

    do k = kts+1, ktf
!      gwalls=rdzu(k)
!      do i = i_start, i_end
!        a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!        a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!      end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*rdzu(k)
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*rdzu(k)
    end do

    do i = i_start, i_end
      k = ktf
! recompute : k
      vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
! recompute : vel
      k = ktf+1
! recompute : k
      gwalls=0.25*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k-1,j) = a_rom(i,k-1,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_w(i,k-1,j) = a_w(i,k-1,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
      a_w(i,k,j) = a_w(i,k,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:5204
! recompute vars : k
      k = ktf
! recompute vars : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k-1,j))-0.083333333*(w(i,k+1,j)+w(i,k-2,j)))
      a_w(i,k-2,j) = a_w(i,k-2,j)-0.083333333*walls(2)
      a_w(i,k-1,j) = a_w(i,k-1,j)+0.58333333*walls(2)
      a_w(i,k+1,j) = a_w(i,k+1,j)-0.083333333*walls(2)
      a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:5204
! recompute vars : k
      k = ktf
! recompute vars : k
      a_rom(i,k-1,j) = a_rom(i,k-1,j)+0.5*a_vel
      a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:5198
! recompute vars : k
      k = kts+2
! recompute vars : k
! recdepend vars : i,j,k,rom
! recompute pos : ASSIGN_STMT module_advect_em.f90:5199
! recompute vars : vel
      vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
! recompute vars : vel
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k-1,j))-0.083333333*(w(i,k+1,j)+w(i,k-2,j)))
      a_w(i,k-2,j) = a_w(i,k-2,j)-0.083333333*walls(2)
      a_w(i,k-1,j) = a_w(i,k-1,j)+0.58333333*walls(2)
      a_w(i,k+1,j) = a_w(i,k+1,j)-0.083333333*walls(2)
      a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:5198
! recompute vars : k
      k = kts+2
! recompute vars : k
      a_rom(i,k-1,j) = a_rom(i,k-1,j)+0.5*a_vel
      a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:5195
! recompute vars : k
      k = kts+1
! recompute vars : k
      gwalls=0.25*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k-1,j) = a_rom(i,k-1,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_w(i,k-1,j) = a_w(i,k-1,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
      a_w(i,k,j) = a_w(i,k,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
    end do

    a_vflux(i_start:i_end,kts+1:kts+2) = 0.
    a_vflux(i_start:i_end,ktf:ktf+1) = 0.

    do k = kts+3, ktf-1
      do i = i_start, i_end
        vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
! recompute : vel
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_vel =walls(1)*(0.61666667*(w(i,k,j)+w(i,k-1,j))-0.13333333*(w(i,k+1,j)+w(i,k-2,j))+0.016666667*(w(i,k+2,j)+&
&w(i,k-3,j)))
        a_w(i,k-3,j) = a_w(i,k-3,j)+0.016666667*walls(2)
        a_w(i,k-2,j) = a_w(i,k-2,j)-0.13333333*walls(2)
        a_w(i,k-1,j) = a_w(i,k-1,j)+0.61666667*walls(2)
        a_w(i,k+2,j) = a_w(i,k+2,j)+0.016666667*walls(2)
        a_w(i,k+1,j) = a_w(i,k+1,j)-0.13333333*walls(2)
        a_w(i,k,j) = a_w(i,k,j)+0.61666667*walls(2)
        a_rom(i,k-1,j) = a_rom(i,k-1,j)+0.5*a_vel
        a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+3:ktf-1) = 0.

  end do
else if (vert_order .eq. 5) then a_vert_order_test
  do j = j_end, j_start, -1
!   k = ktf+1
! recompute : k; revised by walls
!   gwalls=rdzu(k-1)
!   do i = i_start, i_end
!     a_vflux(i,k) = a_vflux(i,k)+2*a_tendency(i,k,j)*gwalls
!   end do

    a_vflux(i_start:i_end,ktf+1) =a_vflux(i_start:i_end,ktf+1)+2*a_tendency(i_start:i_end,ktf+1,j)*rdzu(ktf)

    do k = kts+1, ktf
!      gwalls=rdzu(k)
!      do i = i_start, i_end
!        a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!        a_vflux(i,k)   = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!      end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*rdzu(k)
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*rdzu(k)
    end do

    do i = i_start, i_end
      k = ktf
! recompute : k
      vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
      walls(3)=sign(1.,-vel)
! recompute : vel
      k = ktf+1
! recompute : k
      gwalls=0.25*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k-1,j) = a_rom(i,k-1,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_w(i,k-1,j) = a_w(i,k-1,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
      a_w(i,k,j) = a_w(i,k,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:5252
! recompute vars : k
      k = ktf
! recompute vars : k
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k-1,j))-0.083333333*(w(i,k+1,j)+w(i,k-2,j))+0.083333333*(w(i,k+1,j)-w(i,&
&k-2,j)-3.*(w(i,k,j)-w(i,k-1,j)))*walls(3))
      a_w(i,k-2,j) = a_w(i,k-2,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
      a_w(i,k-1,j) = a_w(i,k-1,j)+walls(2)*(0.58333333+0.25*walls(3))
      a_w(i,k+1,j) = a_w(i,k+1,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
      a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:5252
! recompute vars : k
      k = ktf
! recompute vars : k
      a_rom(i,k-1,j) = a_rom(i,k-1,j)+0.5*a_vel
      a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:5247
! recompute vars : k
      k = kts+2
! recompute vars : k
! recdepend vars : i,j,k,rom
! recompute pos : ASSIGN_STMT module_advect_em.f90:5248
! recompute vars : vel
      vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
! recompute vars : vel
      walls(3)=sign(1.,-vel)
      walls(1)=a_vflux(i,k)
!     a_vflux(i,k) = 0.
      walls(2)=walls(1)*vel
      a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k-1,j))-0.083333333*(w(i,k+1,j)+w(i,k-2,j))+0.083333333*(w(i,k+1,j)-w(i,&
&k-2,j)-3.*(w(i,k,j)-w(i,k-1,j)))*walls(3))
      a_w(i,k-2,j) = a_w(i,k-2,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
      a_w(i,k-1,j) = a_w(i,k-1,j)+walls(2)*(0.58333333+0.25*walls(3))
      a_w(i,k+1,j) = a_w(i,k+1,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
      a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:5247
! recompute vars : k
      k = kts+2
! recompute vars : k
      a_rom(i,k-1,j) = a_rom(i,k-1,j)+0.5*a_vel
      a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:5244
! recompute vars : k
      k = kts+1
! recompute vars : k
      gwalls=0.25*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k-1,j) = a_rom(i,k-1,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_w(i,k-1,j) = a_w(i,k-1,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
      a_w(i,k,j) = a_w(i,k,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
    end do

    a_vflux(i_start:i_end,kts+1:kts+2) = 0.
    a_vflux(i_start:i_end,ktf:ktf+1) = 0.

    do k = kts+3, ktf-1
      do i = i_start, i_end
        vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
! recompute : vel
        walls(3)=sign(1.,-vel)
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_vel =walls(1)*(0.61666667*(w(i,k,j)+w(i,k-1,j))-0.13333333*(w(i,k+1,j)+w(i,k-2,j))+0.016666667*(w(i,k+2,j)+&
&w(i,k-3,j))-0.016666667*(w(i,k+2,j)-w(i,k-3,j)-5.*(w(i,k+1,j)-w(i,k-2,j))+10.*(w(i,k,j)-w(i,k-1,j)))*walls(3))
        a_w(i,k-3,j) = a_w(i,k-3,j)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
        a_w(i,k-2,j) = a_w(i,k-2,j)+walls(2)*((-0.13333333)-0.083333333*walls(3))
        a_w(i,k-1,j) = a_w(i,k-1,j)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
        a_w(i,k+2,j) = a_w(i,k+2,j)+walls(2)*(0.016666667-0.016666667*walls(3))
        a_w(i,k+1,j) = a_w(i,k+1,j)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
        a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
        a_rom(i,k-1,j) = a_rom(i,k-1,j)+0.5*a_vel
        a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+3:ktf-1) = 0.

  end do
else if (vert_order .eq. 4) then a_vert_order_test
  do j = j_end, j_start, -1
!   k = ktf+1
! recompute : k; revised by walls
!   do i = i_start, i_end
!     a_vflux(i,k) = a_vflux(i,k)+2*a_tendency(i,k,j)*rdzu(k-1)
!   end do

    a_vflux(i_start:i_end,ktf+1) = a_vflux(i_start:i_end,ktf+1)+2*a_tendency(i_start:i_end,ktf+1,j)*rdzu(ktf)

    do k = kts+1, ktf
!      gwalls=rdzu(k)
!      do i = i_start, i_end
!        a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!        a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!      end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*rdzu(k)
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*rdzu(k)
    end do

    do i = i_start, i_end
      k = ktf+1
! recompute : k
      gwalls=0.25*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k-1,j) = a_rom(i,k-1,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_w(i,k-1,j) = a_w(i,k-1,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
      a_w(i,k,j) = a_w(i,k,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:5292
! recompute vars : k
      k = kts+1
! recompute vars : k
      gwalls=0.25*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k-1,j) = a_rom(i,k-1,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_rom(i,k,j) = a_rom(i,k,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_w(i,k-1,j) = a_w(i,k-1,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
      a_w(i,k,j) = a_w(i,k,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
    end do

    a_vflux(i_start:i_end,kts+1) = 0.
    a_vflux(i_start:i_end,ktf+1) = 0.

    do k = kts+2, ktf
      do i = i_start, i_end
        vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
! recompute : vel
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k-1,j))-0.083333333*(w(i,k+1,j)+w(i,k-2,j)))
        a_w(i,k-2,j) = a_w(i,k-2,j)-0.083333333*walls(2)
        a_w(i,k-1,j) = a_w(i,k-1,j)+0.58333333*walls(2)
        a_w(i,k+1,j) = a_w(i,k+1,j)-0.083333333*walls(2)
        a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
        a_rom(i,k-1,j) = a_rom(i,k-1,j)+0.5*a_vel
        a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+2:ktf) = 0.

  end do
else if (vert_order .eq. 3) then a_vert_order_test
  do j = j_end, j_start, -1
!    k = ktf+1
! recompute : k
!    do i = i_start, i_end
!      a_vflux(i,k) = a_vflux(i,k)+2*a_tendency(i,k,j)*rdzu(k-1)
!    end do

    a_vflux(i_start:i_end,ktf+1) = a_vflux(i_start:i_end,ktf+1)+2*a_tendency(i_start:i_end,ktf+1,j)*rdzu(ktf)

    do k = kts+1, ktf
!      gwalls=rdzu(k)
!      do i = i_start, i_end
!        a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!        a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!      end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*rdzu(k)
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*rdzu(k)
    end do

    do i = i_start, i_end
      k = ktf+1
! recompute : k
      gwalls=0.25*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k-1,j) = a_rom(i,k-1,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_rom(i,k,j)   = a_rom(i,k,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_w(i,k-1,j)   = a_w(i,k-1,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
      a_w(i,k,j)     = a_w(i,k,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_advect_em.f90:5328
! recompute vars : k
      k = kts+1
! recompute vars : k
      gwalls=0.25*a_vflux(i,k)
!     a_vflux(i,k) = 0.
      a_rom(i,k-1,j) = a_rom(i,k-1,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_rom(i,k,j)   = a_rom(i,k,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
      a_w(i,k-1,j)   = a_w(i,k-1,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
      a_w(i,k,j)     = a_w(i,k,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
    end do

    a_vflux(i_start:i_end,kts+1) = 0.
    a_vflux(i_start:i_end,ktf+1) = 0.

    do k = kts+2, ktf
      do i = i_start, i_end
        vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
! recompute : vel
        walls(3)=sign(1.,-vel)
        walls(1)=a_vflux(i,k)
!       a_vflux(i,k) = 0.
        walls(2)=walls(1)*vel
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k-1,j))-0.083333333*(w(i,k+1,j)+w(i,k-2,j))+0.083333333*(w(i,k+1,j)-&
&w(i,k-2,j)-3.*(w(i,k,j)-w(i,k-1,j)))*walls(3))
        a_w(i,k-2,j) = a_w(i,k-2,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_w(i,k-1,j) = a_w(i,k-1,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_w(i,k+1,j) = a_w(i,k+1,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_rom(i,k-1,j) = a_rom(i,k-1,j)+0.5*a_vel
        a_rom(i,k,j) = a_rom(i,k,j)+0.5*a_vel
      end do
    end do
    a_vflux(i_start:i_end,kts+2:ktf) = 0.

  end do
else if (vert_order .eq. 2) then a_vert_order_test
  do j = j_end, j_start, -1
!    k = ktf+1
! recompute : k
!    do i = i_start, i_end
!      a_vflux(i,k) = a_vflux(i,k)+2*a_tendency(i,k,j)*rdzu(k-1)
!    end do

    a_vflux(i_start:i_end,ktf+1) = a_vflux(i_start:i_end,ktf+1)+2*a_tendency(i_start:i_end,ktf+1,j)*rdzu(ktf)

    do k = kts+1, ktf
!      gwalls=rdzu(k)
!      do i = i_start, i_end
!        a_vflux(i,k+1) = a_vflux(i,k+1)-a_tendency(i,k,j)*gwalls
!        a_vflux(i,k)   = a_vflux(i,k)+a_tendency(i,k,j)*gwalls
!      end do

      a_vflux(i_start:i_end,k+1) = a_vflux(i_start:i_end,k+1)-a_tendency(i_start:i_end,k,j)*rdzu(k)
      a_vflux(i_start:i_end,k)   = a_vflux(i_start:i_end,k)+a_tendency(i_start:i_end,k,j)*rdzu(k)
    end do

    do k = kts+1, ktf+1
      do i = i_start, i_end
        gwalls=0.25*a_vflux(i,k)
!       a_vflux(i,k) = 0.
        a_rom(i,k-1,j) = a_rom(i,k-1,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
        a_rom(i,k,j) = a_rom(i,k,j)+gwalls*(w(i,k,j)+w(i,k-1,j))
        a_w(i,k-1,j) = a_w(i,k-1,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
        a_w(i,k,j) = a_w(i,k,j)+gwalls*(rom(i,k,j)+rom(i,k-1,j))
      end do
    end do

    a_vflux(i_start:i_end,kts+1:ktf+1) = 0.

  end do
endif a_vert_order_test
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:5015
! recompute vars : i_start
i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:5016
! recompute vars : i_end
i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:5018
! recompute vars : j_end
j_end = min(jte,jde-1)
! recompute vars : j_end
if (config_flags%open_ye .and. jte .eq. jde) then
  k = ktf+1
! recompute : k
  walls(5)=fzm(k-1); walls(6)=fzp(k-1)
  do i = i_start, i_end
    vw = 0.5*((2.-walls(5))*(rv(i,k-1,jte-1)+rv(i,k-1,jte))-walls(6)*(rv(i,k-2,jte-1)+rv(i,k-2,jte)))
! recompute : vw
    vb = max(vw,0.)
! recompute : vb
    walls(1)=a_tendency(i,k,j_end)*rdy
    a_rv(i,k-2,jte-1) = a_rv(i,k-2,jte-1)-walls(1)*w(i,k,j_end)*walls(6)
    a_rv(i,k-2,jte) = a_rv(i,k-2,jte)+walls(1)*w(i,k,j_end)*walls(6)
    a_rv(i,k-1,jte-1) = a_rv(i,k-1,jte-1)+walls(1)*w(i,k,j_end)*(2.-walls(5))
    a_rv(i,k-1,jte) = a_rv(i,k-1,jte)-walls(1)*w(i,k,j_end)*(2-walls(5))
    a_vb = -walls(1)*(w_old(i,k,j_end)-w_old(i,k,j_end-1))
    a_w(i,k,j_end) = a_w(i,k,j_end)-walls(1)*((2.-walls(5))*(rv(i,k-1,jte)-rv(i,k-1,jte-1))-walls(6)*(rv(i,k-2,&
&jte)-rv(i,k-2,jte-1)))
    a_w_old(i,k,j_end-1) = a_w_old(i,k,j_end-1)+walls(1)*vb
    a_w_old(i,k,j_end) = a_w_old(i,k,j_end)-walls(1)*vb
    a_vw = 0.5*a_vb*(0.5+sign(0.5,vw-0.))
    a_rv(i,k-2,jte-1) = a_rv(i,k-2,jte-1)-a_vw*walls(6)
    a_rv(i,k-2,jte) = a_rv(i,k-2,jte)-a_vw*walls(6)
    a_rv(i,k-1,jte-1) = a_rv(i,k-1,jte-1)+a_vw*(2-walls(5))
    a_rv(i,k-1,jte) = a_rv(i,k-1,jte)+a_vw*(2-walls(5))
  end do
  do i = i_start, i_end
    do k = kts+1, ktf
      walls(2)=fzp(k); walls(3)=fzm(k)
      vw = 0.5*(walls(3)*(rv(i,k,jte-1)+rv(i,k,jte))+walls(2)*(rv(i,k-1,jte-1)+rv(i,k-1,jte)))
! recompute : vw
      vb = max(vw,0.)
! recompute : vb
      walls(1)=a_tendency(i,k,j_end)*rdy
      a_rv(i,k-1,jte-1) = a_rv(i,k-1,jte-1)+walls(1)*w(i,k,j_end)*walls(2)
      a_rv(i,k-1,jte) = a_rv(i,k-1,jte)-walls(1)*w(i,k,j_end)*walls(2)
      a_rv(i,k,jte-1) = a_rv(i,k,jte-1)+walls(1)*w(i,k,j_end)*walls(3)
      a_rv(i,k,jte) = a_rv(i,k,jte)-walls(1)*w(i,k,j_end)*walls(3)
      a_vb = -walls(1)*(w_old(i,k,j_end)-w_old(i,k,j_end-1))
      a_w(i,k,j_end) = a_w(i,k,j_end)-walls(1)*(walls(3)*(rv(i,k,jte)-rv(i,k,jte-1))+walls(2)*(rv(i,k-1,jte)-rv(i,k-1,&
&jte-1)))
      a_w_old(i,k,j_end-1) = a_w_old(i,k,j_end-1)+walls(1)*vb
      a_w_old(i,k,j_end) = a_w_old(i,k,j_end)-walls(1)*vb
      a_vw = 0.5*a_vb*(0.5+sign(0.5,vw-0.))
      a_rv(i,k-1,jte-1) = a_rv(i,k-1,jte-1)+a_vw*walls(2)
      a_rv(i,k-1,jte) = a_rv(i,k-1,jte)+a_vw*walls(2)
      a_rv(i,k,jte-1) = a_rv(i,k,jte-1)+a_vw*walls(3)
      a_rv(i,k,jte) = a_rv(i,k,jte)+a_vw*walls(3)
    end do
  end do
endif
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:5015
! recompute vars : i_start
i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:5016
! recompute vars : i_end
i_end = min(ite,ide-1)
! recompute vars : i_end
if (config_flags%open_ys .and. jts .eq. jds) then
  k = ktf+1
! recompute : k
  walls(5)=fzm(k-1); walls(6)=fzp(k-1)
  do i = i_start, i_end
    vw = 0.5*((2.-walls(5))*(rv(i,k-1,jts)+rv(i,k-1,jts+1))-walls(6)*(rv(i,k-2,jts)+rv(i,k-2,jts+1)))
! recompute : vw
    vb = min(vw,0.)
! recompute : vb
    walls(1)=a_tendency(i,k,jts)*rdy
    a_rv(i,k-2,jts+1) = a_rv(i,k-2,jts+1)+walls(1)*w(i,k,jts)*walls(6)
    a_rv(i,k-2,jts) = a_rv(i,k-2,jts)-walls(1)*w(i,k,jts)*walls(6)
    a_rv(i,k-1,jts+1) = a_rv(i,k-1,jts+1)-walls(1)*w(i,k,jts)*(2-walls(5))
    a_rv(i,k-1,jts) = a_rv(i,k-1,jts)+walls(1)*w(i,k,jts)*(2.-walls(5))
    a_vb = -walls(1)*(w_old(i,k,jts+1)-w_old(i,k,jts))
    a_w(i,k,jts) = a_w(i,k,jts)-walls(1)*((2.-walls(5))*(rv(i,k-1,jts+1)-rv(i,k-1,jts))-walls(6)*(rv(i,k-2,jts+1)-&
&rv(i,k-2,jts)))
    a_w_old(i,k,jts+1) = a_w_old(i,k,jts+1)-walls(1)*vb
    a_w_old(i,k,jts) = a_w_old(i,k,jts)+walls(1)*vb
    a_vw = 0.5*a_vb*(0.5+sign(0.5,0.-vw))
    a_rv(i,k-2,jts+1) = a_rv(i,k-2,jts+1)-a_vw*walls(6)
    a_rv(i,k-2,jts) = a_rv(i,k-2,jts)-a_vw*walls(6)
    a_rv(i,k-1,jts+1) = a_rv(i,k-1,jts+1)+a_vw*(2-walls(5))
    a_rv(i,k-1,jts) = a_rv(i,k-1,jts)+a_vw*(2-walls(5))
  end do
  do i = i_start, i_end
    do k = kts+1, ktf
      walls(2)=fzp(k); walls(3)=fzm(k)
      vw = 0.5*(walls(3)*(rv(i,k,jts)+rv(i,k,jts+1))+walls(2)*(rv(i,k-1,jts)+rv(i,k-1,jts+1)))
! recompute : vw
      vb = min(vw,0.)
! recompute : vb
      walls(1)=a_tendency(i,k,jts)*rdy
      a_rv(i,k-1,jts+1) = a_rv(i,k-1,jts+1)-walls(1)*w(i,k,jts)*walls(2)
      a_rv(i,k-1,jts) = a_rv(i,k-1,jts)+walls(1)*w(i,k,jts)*walls(2)
      a_rv(i,k,jts+1) = a_rv(i,k,jts+1)-walls(1)*w(i,k,jts)*walls(3)
      a_rv(i,k,jts) = a_rv(i,k,jts)+walls(1)*w(i,k,jts)*walls(3)
      a_vb = -walls(1)*(w_old(i,k,jts+1)-w_old(i,k,jts))
      a_w(i,k,jts) = a_w(i,k,jts)-walls(1)*(walls(3)*(rv(i,k,jts+1)-rv(i,k,jts))+walls(2)*(rv(i,k-1,jts+1)-rv(i,k-1,jts)&
&))
      a_w_old(i,k,jts+1) = a_w_old(i,k,jts+1)-walls(1)*vb
      a_w_old(i,k,jts) = a_w_old(i,k,jts)+walls(1)*vb
      a_vw = 0.5*a_vb*(0.5+sign(0.5,0.-vw))
      a_rv(i,k-1,jts+1) = a_rv(i,k-1,jts+1)+a_vw*walls(2)
      a_rv(i,k-1,jts) = a_rv(i,k-1,jts)+a_vw*walls(2)
      a_rv(i,k,jts+1) = a_rv(i,k,jts+1)+a_vw*walls(3)
      a_rv(i,k,jts) = a_rv(i,k,jts)+a_vw*walls(3)
    end do
  end do
endif
! recdepend vars : ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:5016
! recompute vars : i_end
i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:5017
! recompute vars : j_start
j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:5018
! recompute vars : j_end
j_end = min(jte,jde-1)
! recompute vars : j_end
if (config_flags%open_xe .and. ite .eq. ide) then
  k = ktf+1
! recompute : k
  walls(5)=fzm(k-1); walls(6)=fzp(k-1)
  do j = j_start, j_end
    
    uw = 0.5*((2.-walls(5))*(ru(ite-1,k-1,j)+ru(ite,k-1,j))-walls(6)*(ru(ite-1,k-2,j)+ru(ite,k-2,j)))
! recompute : uw
    ub = max(uw,0.)
! recompute : ub
    walls(1)=a_tendency(i_end,k,j)*rdx
    a_ru(ite-1,k-2,j) = a_ru(ite-1,k-2,j)-walls(1)*w(i_end,k,j)*walls(6)
    a_ru(ite,k-2,j) = a_ru(ite,k-2,j)+walls(1)*w(i_end,k,j)*walls(6)
    a_ru(ite-1,k-1,j) = a_ru(ite-1,k-1,j)+walls(1)*w(i_end,k,j)*(2.-walls(5))
    a_ru(ite,k-1,j) = a_ru(ite,k-1,j)-walls(1)*w(i_end,k,j)*(2-walls(5))
    a_ub =-walls(1)*(w_old(i_end,k,j)-w_old(i_end-1,k,j))
    a_w(i_end,k,j) = a_w(i_end,k,j)-walls(1)*((2.-walls(5))*(ru(ite,k-1,j)-ru(ite-1,k-1,j))-walls(6)*(ru(ite,k-2,&
&j)-ru(ite-1,k-2,j)))
    a_w_old(i_end-1,k,j) = a_w_old(i_end-1,k,j)+walls(1)*ub
    a_w_old(i_end,k,j) = a_w_old(i_end,k,j)-walls(1)*ub
    a_uw = a_ub*(0.5+sign(0.5,uw-0.))
    
    a_ru(ite-1,k-2,j) = a_ru(ite-1,k-2,j)-0.5*a_uw*walls(6)
    a_ru(ite,k-2,j) = a_ru(ite,k-2,j)-0.5*a_uw*walls(6)
    a_ru(ite-1,k-1,j) = a_ru(ite-1,k-1,j)+0.5*a_uw*(2-walls(5))
    a_ru(ite,k-1,j) = a_ru(ite,k-1,j)+0.5*a_uw*(2-walls(5))
  end do
  do j = j_start, j_end
    do k = kts+1, ktf
      walls(2)=fzp(k); walls(3)=fzm(k)
      uw = 0.5*(walls(3)*(ru(ite-1,k,j)+ru(ite,k,j))+walls(2)*(ru(ite-1,k-1,j)+ru(ite,k-1,j)))
! recompute : uw
      ub = max(uw,0.)
! recompute : ub
      walls(1)=a_tendency(i_end,k,j)*rdx
      a_ru(ite-1,k-1,j) = a_ru(ite-1,k-1,j)+walls(1)*w(i_end,k,j)*walls(2)
      a_ru(ite,k-1,j) = a_ru(ite,k-1,j)-walls(1)*w(i_end,k,j)*walls(2)
      a_ru(ite-1,k,j) = a_ru(ite-1,k,j)+walls(1)*w(i_end,k,j)*walls(3)
      a_ru(ite,k,j) = a_ru(ite,k,j)-walls(1)*w(i_end,k,j)*walls(3)
      a_ub =-walls(1)*(w_old(i_end,k,j)-w_old(i_end-1,k,j))
      a_w(i_end,k,j) = a_w(i_end,k,j)-walls(1)*(walls(3)*(ru(ite,k,j)-ru(ite-1,k,j))+walls(2)*(ru(ite,k-1,j)-ru(ite-1,&
&k-1,j)))
      a_w_old(i_end-1,k,j) = a_w_old(i_end-1,k,j)+walls(1)*ub
      a_w_old(i_end,k,j) = a_w_old(i_end,k,j)-walls(1)*ub
      a_uw = a_ub*(0.5+sign(0.5,uw-0.))
      
      a_ru(ite-1,k-1,j) = a_ru(ite-1,k-1,j)+0.5*a_uw*walls(2)
      a_ru(ite,k-1,j) = a_ru(ite,k-1,j)+0.5*a_uw*walls(2)
      a_ru(ite-1,k,j) = a_ru(ite-1,k,j)+0.5*a_uw*walls(3)
      a_ru(ite,k,j) = a_ru(ite,k,j)+0.5*a_uw*walls(3)
    end do
  end do
endif
! recdepend vars : jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:5017
! recompute vars : j_start
j_start = jts
! recompute vars : j_start
! recdepend vars : j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:5018
! recompute vars : j_end
j_end = min(jte,jde-1)
! recompute vars : j_end
if (config_flags%open_xs .and. its .eq. ids) then
  k = ktf+1
! recompute : k
  walls(5)=fzm(k-1); walls(6)=fzp(k-1)
  do j = j_start, j_end
    
    uw = 0.5*((2.-walls(5))*(ru(its,k-1,j)+ru(its+1,k-1,j))-walls(6)*(ru(its,k-2,j)+ru(its+1,k-2,j)))
! recompute : uw
    ub = min(uw,0.)
! recompute : ub
    walls(1)=a_tendency(its,k,j)*rdx
    a_ru(its+1,k-2,j) = a_ru(its+1,k-2,j)+walls(1)*w(its,k,j)*walls(6)
    a_ru(its,k-2,j) = a_ru(its,k-2,j)-walls(1)*w(its,k,j)*walls(6)
    a_ru(its+1,k-1,j) = a_ru(its+1,k-1,j)-walls(1)*w(its,k,j)*(2-walls(5))
    a_ru(its,k-1,j) = a_ru(its,k-1,j)+walls(1)*w(its,k,j)*(2.-walls(5))
    a_ub =-walls(1)*(w_old(its+1,k,j)-w_old(its,k,j))
    a_w(its,k,j) = a_w(its,k,j)-walls(1)*((2.-walls(5))*(ru(its+1,k-1,j)-ru(its,k-1,j))-walls(6)*(ru(its+1,k-2,j)-&
&ru(its,k-2,j)))
    a_w_old(its+1,k,j) = a_w_old(its+1,k,j)-walls(1)*ub
    a_w_old(its,k,j) = a_w_old(its,k,j)+walls(1)*ub
    a_uw = a_ub*(0.5+sign(0.5,0.-uw))
    
    a_ru(its+1,k-2,j) = a_ru(its+1,k-2,j)-0.5*a_uw*walls(6)
    a_ru(its,k-2,j) = a_ru(its,k-2,j)-0.5*a_uw*walls(6)
    a_ru(its+1,k-1,j) = a_ru(its+1,k-1,j)+0.5*a_uw*(2-walls(5))
    a_ru(its,k-1,j) = a_ru(its,k-1,j)+0.5*a_uw*(2-walls(5))
  end do
  do j = j_start, j_end
    do k = kts+1, ktf
      walls(2)=fzp(k); walls(3)=fzm(k)
      uw = 0.5*(walls(3)*(ru(its,k,j)+ru(its+1,k,j))+walls(2)*(ru(its,k-1,j)+ru(its+1,k-1,j)))
! recompute : uw
      ub = min(uw,0.)
! recompute : ub
      walls(1)=a_tendency(its,k,j)*rdx
      a_ru(its+1,k-1,j) = a_ru(its+1,k-1,j)-walls(1)*w(its,k,j)*walls(2)
      a_ru(its,k-1,j) = a_ru(its,k-1,j)+walls(1)*w(its,k,j)*walls(2)
      a_ru(its+1,k,j) = a_ru(its+1,k,j)-walls(1)*w(its,k,j)*walls(3)
      a_ru(its,k,j) = a_ru(its,k,j)+walls(1)*w(its,k,j)*walls(3)
      a_ub =-walls(1)*(w_old(its+1,k,j)-w_old(its,k,j))
      a_w(its,k,j) = a_w(its,k,j)-walls(1)*(walls(3)*(ru(its+1,k,j)-ru(its,k,j))+walls(2)*(ru(its+1,k-1,j)-ru(its,k-1,j)&
&))
      a_w_old(its+1,k,j) = a_w_old(its+1,k,j)-walls(1)*ub
      a_w_old(its,k,j) = a_w_old(its,k,j)+walls(1)*ub
      a_uw = a_ub*(0.5+sign(0.5,0.-uw))
      
      a_ru(its+1,k-1,j) = a_ru(its+1,k-1,j)+0.5*a_uw*walls(2)
      a_ru(its,k-1,j) = a_ru(its,k-1,j)+0.5*a_uw*walls(2)
      a_ru(its+1,k,j) = a_ru(its+1,k,j)+0.5*a_uw*walls(3)
      a_ru(its,k,j) = a_ru(its,k,j)+0.5*a_uw*walls(3)
    end do
  end do
endif
! recdepend vars : kde,kte
! recompute pos : ASSIGN_STMT module_advect_em.f90:3963
! recompute vars : ktf
ktf = min(kte,kde-1)
! recompute vars : ktf
a_horizontal_order_test: if (horz_order .eq. 6) then
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-3) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-3) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start_f = jds+3
  endif
! recompute : j_start_f
  if (degrade_ye) then
    j_end_f = jde-3
  endif
! recompute : j_end_f
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = i_start+2
  endif
! recompute : i_start,i_start_f
  if (degrade_xe) then
    i_end = min(ide-2,ite)
    i_end_f = ide-3
  endif
! recompute : i_end,i_end_f
  do j = j_end, j_start, -1
    do k = kts+1, ktf+1
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do

    if (degrade_xe) then
      i = ide-2
! recompute : i
      k = ktf+1
! recompute : k
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
      vel = (2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j)
! recompute : vel 
      walls(1)=a_fqx(i,k)
!     a_fqx(i,k) = 0.
      walls(2)=walls(1)*vel
      a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))
      a_w(i-2,k,j) = a_w(i-2,k,j)-0.083333333*walls(2)
      a_w(i-1,k,j) = a_w(i-1,k,j)+0.58333333*walls(2)
      a_w(i+1,k,j) = a_w(i+1,k,j)-0.083333333*walls(2)
      a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
      a_ru(i,k-2,j) = a_ru(i,k-2,j)-a_vel*walls(6)
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*(2-walls(5))
      do k = kts+1, ktf
        vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))
        a_w(i-2,k,j) = a_w(i-2,k,j)-0.083333333*walls(2)
        a_w(i-1,k,j) = a_w(i-1,k,j)+0.58333333*walls(2)
        a_w(i+1,k,j) = a_w(i+1,k,j)-0.083333333*walls(2)
        a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*fzp(k)
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel*fzm(k)
      end do
      a_fqx(ide-2,kts+1:ktf+1) = 0.

      if (i_end .eq. ide-2) then
        i = ide-1
! recompute : i
        k = ktf+1
        walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
        walls(1)=0.5*a_fqx(i,k)
!       a_fqx(i,k) = 0.
        a_ru(i,k-2,j) = a_ru(i,k-2,j)-walls(1)*walls(6)*(w(i,k,j)+w(i-1,k,j))
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+walls(1)*(2-walls(5))*(w(i,k,j)+w(i-1,k,j))
        a_w(i-1,k,j) = a_w(i-1,k,j)+walls(1)*((2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j))
        a_w(i,k,j) = a_w(i,k,j)+walls(1)*((2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j))
        do k = kts+1, ktf
          gwalls=0.5*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_ru(i,k-1,j) = a_ru(i,k-1,j)+gwalls*fzp(k)*(w(i,k,j)+w(i-1,k,j))
          a_ru(i,k,j) = a_ru(i,k,j)+gwalls*fzm(k)*(w(i,k,j)+w(i-1,k,j))
          a_w(i-1,k,j) = a_w(i-1,k,j)+gwalls*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))
          a_w(i,k,j) = a_w(i,k,j)+gwalls*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))
        end do
        a_fqx(ide-1,kts+1:ktf+1) = 0.

      endif
    endif

    if (degrade_xs) then
      i = i_start+1
! recompute : i
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      vel = (2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j)
! recompute : vel
      walls(1)=a_fqx(i,k)
!     a_fqx(i,k) = 0.
      walls(2)=walls(1)*vel
      a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))
      a_w(i-2,k,j) = a_w(i-2,k,j)-0.083333333*walls(2)
      a_w(i-1,k,j) = a_w(i-1,k,j)+0.58333333*walls(2)
      a_w(i+1,k,j) = a_w(i+1,k,j)-0.083333333*walls(2)
      a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
      a_ru(i,k-2,j) = a_ru(i,k-2,j)-a_vel*walls(6)
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*(2-walls(5))
      
      k = ktf
      vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
! recompute : vel
      walls(1)=a_fqx(i,k)
!     a_fqx(i,k) = 0.
      walls(2)=walls(1)*vel
      a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))
      a_w(i-2,k,j) = a_w(i-2,k,j)-0.083333333*walls(2)
      a_w(i-1,k,j) = a_w(i-1,k,j)+0.58333333*walls(2)
      a_w(i+1,k,j) = a_w(i+1,k,j)-0.083333333*walls(2)
      a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*fzp(k)
      a_ru(i,k,j) = a_ru(i,k,j)+a_vel*fzm(k)
      
      do k = kts+1, ktf-1
        vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))
        a_w(i-2,k,j) = a_w(i-2,k,j)-0.083333333*walls(2)
        a_w(i-1,k,j) = a_w(i-1,k,j)+0.58333333*walls(2)
        a_w(i+1,k,j) = a_w(i+1,k,j)-0.083333333*walls(2)
        a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*fzp(k)
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel*fzm(k)
      end do
      a_fqx(i_start+1,kts+1:ktf+1) = 0.

      if (i_start .eq. ids+1) then
        i = ids+1
! recompute : i
        k = ktf+1
        walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
        walls(1)=0.5*a_fqx(i,k)
!       a_fqx(i,k) = 0.
        a_ru(i,k-2,j) = a_ru(i,k-2,j)-walls(1)*walls(6)*(w(i,k,j)+w(i-1,k,j))
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+walls(1)*(2-walls(5))*(w(i,k,j)+w(i-1,k,j))
        a_w(i-1,k,j) = a_w(i-1,k,j)+walls(1)*((2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j))
        a_w(i,k,j) = a_w(i,k,j)+walls(1)*((2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j))
        do k = kts+1, ktf
          walls(1)=0.5*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_ru(i,k-1,j) = a_ru(i,k-1,j)+walls(1)*fzp(k)*(w(i,k,j)+w(i-1,k,j))
          a_ru(i,k,j) = a_ru(i,k,j)+walls(1)*fzm(k)*(w(i,k,j)+w(i-1,k,j))
          a_w(i-1,k,j) = a_w(i-1,k,j)+walls(1)*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))
          a_w(i,k,j) = a_w(i,k,j)+walls(1)*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))
        end do
        a_fqx(ids+1,kts+1:ktf+1) = 0.

      endif
    endif
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:4174
! recompute vars : k
    k = ktf+1
    walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute vars : k

    do i = i_start_f, i_end_f
      vel = (2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j)
! recompute : vel
      walls(1)=a_fqx(i,k)
!     a_fqx(i,k) = 0.
      walls(2)=walls(1)*vel
      a_vel =walls(1)*(0.61666667*(w(i,k,j)+w(i-1,k,j))-0.13333333*(w(i+1,k,j)+w(i-2,k,j))+0.016666667*(w(i+2,k,j)+w(i-3,&
&k,j)))
      a_w(i-3,k,j) = a_w(i-3,k,j)+0.016666667*walls(2)
      a_w(i-2,k,j) = a_w(i-2,k,j)-0.13333333*walls(2)
      a_w(i-1,k,j) = a_w(i-1,k,j)+0.61666667*walls(2)
      a_w(i+2,k,j) = a_w(i+2,k,j)+0.016666667*walls(2)
      a_w(i+1,k,j) = a_w(i+1,k,j)-0.13333333*walls(2)
      a_w(i,k,j) = a_w(i,k,j)+0.61666667*walls(2)
      a_ru(i,k-2,j) = a_ru(i,k-2,j)-a_vel*walls(6)
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*(2-walls(5))
    end do
    a_fqx(i_start_f:i_end_f,ktf+1) = 0.

    do k = kts+1, ktf
      walls(3)=fzp(k); walls(4)=fzm(k)
      do i = i_start_f, i_end_f
        vel = walls(4)*ru(i,k,j)+walls(3)*ru(i,k-1,j)
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_vel =walls(1)*(0.61666667*(w(i,k,j)+w(i-1,k,j))-0.13333333*(w(i+1,k,j)+w(i-2,k,j))+0.016666667*(w(i+2,k,j)+w(i-&
&3,k,j)))
        a_w(i-3,k,j) = a_w(i-3,k,j)+0.016666667*walls(2)
        a_w(i-2,k,j) = a_w(i-2,k,j)-0.13333333*walls(2)
        a_w(i-1,k,j) = a_w(i-1,k,j)+0.61666667*walls(2)
        a_w(i+2,k,j) = a_w(i+2,k,j)+0.016666667*walls(2)
        a_w(i+1,k,j) = a_w(i+1,k,j)-0.13333333*walls(2)
        a_w(i,k,j) = a_w(i,k,j)+0.61666667*walls(2)
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*walls(3)
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel*walls(4)
      end do
    end do
    a_fqx(i_start_f:i_end_f,kts+1:ktf) = 0.

  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:4000
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:4001
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:4002
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:4003
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
! recdepend vars : degrade_ys,i_end,i_start,j_end,j_start,jds,jts
! recompute pos : IF_STMT module_advect_em.f90:4011
! recompute vars : j_start
  if (degrade_ys) then
    j_start = max(jts,jds+1)
  endif
! recompute vars : j_start
! recdepend vars : degrade_ye,i_end,i_start,j_end,j_start,jde,jte
! recompute pos : IF_STMT module_advect_em.f90:4016
! recompute vars : j_end
  if (degrade_ye) then
    j_end = min(jte,jde-2)
  endif
! recompute vars : j_end
  a_j_loop_y_flux_6: do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:4023
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:4024
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    j_loop_y_flux_9c: do j4 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do j_loop_y_flux_9c
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts+1, ktf+1
        do i = i_start, i_end
          mrdy = msft(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        
        vel = (2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j)
! recompute : vel
        walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
        a_vel =walls(1)*(0.61666667*(w(i,k,j)+w(i,k,j-1))-0.13333333*(w(i,k,j+1)+w(i,k,j-2))+0.016666667*(w(i,k,j+2)+&
&w(i,k,j-3)))
        a_w(i,k,j-3) = a_w(i,k,j-3)+0.016666667*walls(2)
        a_w(i,k,j-2) = a_w(i,k,j-2)-0.13333333*walls(2)
        a_w(i,k,j-1) = a_w(i,k,j-1)+0.61666667*walls(2)
        a_w(i,k,j+2) = a_w(i,k,j+2)+0.016666667*walls(2)
        a_w(i,k,j+1) = a_w(i,k,j+1)-0.13333333*walls(2)
        a_w(i,k,j) = a_w(i,k,j)+0.61666667*walls(2)
        a_rv(i,k-2,j) = a_rv(i,k-2,j)-a_vel*walls(6)
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*(2-walls(5))
        
      end do
      do k = kts+1, ktf
        
        walls(3)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          
          vel = walls(4)*rv(i,k,j)+walls(3)*rv(i,k-1,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_vel =walls(1)*(0.61666667*(w(i,k,j)+w(i,k,j-1))-0.13333333*(w(i,k,j+1)+w(i,k,j-2))+0.016666667*(w(i,k,j+2)&
&+w(i,k,j-3)))
          a_w(i,k,j-3) = a_w(i,k,j-3)+0.016666667*walls(2)
          a_w(i,k,j-2) = a_w(i,k,j-2)-0.13333333*walls(2)
          a_w(i,k,j-1) = a_w(i,k,j-1)+0.61666667*walls(2)
          a_w(i,k,j+2) = a_w(i,k,j+2)+0.016666667*walls(2)
          a_w(i,k,j+1) = a_w(i,k,j+1)-0.13333333*walls(2)
          a_w(i,k,j) = a_w(i,k,j)+0.61666667*walls(2)
          a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*walls(3)
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel*walls(4)
          
        end do
      end do
    else if (j .eq. jds+1) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
        a_rv(i,k-2,j) = a_rv(i,k-2,j)-walls(1)*walls(6)*(w(i,k,j)+w(i,k,j-1))
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+walls(1)*(2-walls(5))*(w(i,k,j)+w(i,k,j-1))
        a_w(i,k,j-1) = a_w(i,k,j-1)+walls(1)*((2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j))
        a_w(i,k,j) = a_w(i,k,j)+walls(1)*((2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j))
      end do
      do k = kts+1, ktf
        walls(3)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_rv(i,k-1,j) = a_rv(i,k-1,j)+walls(1)*walls(3)*(w(i,k,j)+w(i,k,j-1))
          a_rv(i,k,j) = a_rv(i,k,j)+walls(1)*walls(4)*(w(i,k,j)+w(i,k,j-1))
          a_w(i,k,j-1) = a_w(i,k,j-1)+walls(1)*(walls(4)*rv(i,k,j)+walls(3)*rv(i,k-1,j))
          a_w(i,k,j) = a_w(i,k,j)+walls(1)*(walls(4)*rv(i,k,j)+walls(3)*rv(i,k-1,j))
        end do
      end do
    else if (j .eq. jds+2) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        
        vel = (2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2)))
        a_w(i,k,j-2) = a_w(i,k,j-2)-0.083333333*walls(2)
        a_w(i,k,j-1) = a_w(i,k,j-1)+0.58333333*walls(2)
        a_w(i,k,j+1) = a_w(i,k,j+1)-0.083333333*walls(2)
        a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
        a_rv(i,k-2,j) = a_rv(i,k-2,j)-a_vel*walls(6)
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*(2-walls(5))
        
      end do
      do k = kts+1, ktf
        
        walls(3)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          
          vel = walls(4)*rv(i,k,j)+walls(3)*rv(i,k-1,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2)))
          a_w(i,k,j-2) = a_w(i,k,j-2)-0.083333333*walls(2)
          a_w(i,k,j-1) = a_w(i,k,j-1)+0.58333333*walls(2)
          a_w(i,k,j+1) = a_w(i,k,j+1)-0.083333333*walls(2)
          a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
          a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*walls(3)
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel*walls(4)
          
        end do
      end do
    else if (j .eq. jde-1) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
        a_rv(i,k-2,j) = a_rv(i,k-2,j)-walls(1)*walls(6)*(w(i,k,j)+w(i,k,j-1))
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+walls(1)*(2-walls(5))*(w(i,k,j)+w(i,k,j-1))
        a_w(i,k,j-1) = a_w(i,k,j-1)+walls(1)*((2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j))
        a_w(i,k,j) = a_w(i,k,j)+walls(1)*((2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j))
      end do
      do k = kts+1, ktf
        walls(3)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_rv(i,k-1,j) = a_rv(i,k-1,j)+walls(1)*walls(3)*(w(i,k,j)+w(i,k,j-1))
          a_rv(i,k,j) = a_rv(i,k,j)+walls(1)*walls(4)*(w(i,k,j)+w(i,k,j-1))
          a_w(i,k,j-1) = a_w(i,k,j-1)+walls(1)*(walls(4)*rv(i,k,j)+walls(3)*rv(i,k-1,j))
          a_w(i,k,j) = a_w(i,k,j)+walls(1)*(walls(4)*rv(i,k,j)+walls(3)*rv(i,k-1,j))
        end do
      end do
    else if (j .eq. jde-2) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        
        vel = (2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2)))
        a_w(i,k,j-2)  = a_w(i,k,j-2)-0.083333333*walls(2)
        a_w(i,k,j-1)  = a_w(i,k,j-1)+0.58333333*walls(2)
        a_w(i,k,j+1)  = a_w(i,k,j+1)-0.083333333*walls(2)
        a_w(i,k,j)    = a_w(i,k,j)+0.58333333*walls(2)
        a_rv(i,k-2,j) = a_rv(i,k-2,j)-a_vel*walls(6)
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*(2-walls(5))
        
      end do
      do k = kts+1, ktf
        
        walls(3)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          
          vel = walls(4)*rv(i,k,j)+walls(3)*rv(i,k-1,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2)))
          a_w(i,k,j-2) = a_w(i,k,j-2)-0.083333333*walls(2)
          a_w(i,k,j-1) = a_w(i,k,j-1)+0.58333333*walls(2)
          a_w(i,k,j+1) = a_w(i,k,j+1)-0.083333333*walls(2)
          a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
          a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*walls(3)
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel*walls(4)
          
        end do
      end do
    endif
  end do a_j_loop_y_flux_6
else if (horz_order .eq. 5) then a_horizontal_order_test
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-3) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-3) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start_f = jds+3
  endif
! recompute : j_start_f
  if (degrade_ye) then
    j_end_f = jde-3
  endif
! recompute : j_end_f
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = i_start+2
  endif
! recompute : i_start,i_start_f
  if (degrade_xe) then
    i_end = min(ide-2,ite)
    i_end_f = ide-3
  endif
! recompute : i_end,i_end_f
  do j = j_end, j_start, -1
    do k = kts+1, ktf+1
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do
    if (degrade_xe) then
      i = ide-2
! recompute : i
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      vel = (2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j)
! recompute : vel
      walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
      a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j))+0.083333333*(w(i+1,k,j)-w(i-2,&
&k,j)-3.*(w(i,k,j)-w(i-1,k,j)))*walls(3))
      a_w(i-2,k,j) = a_w(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
      a_w(i-1,k,j) = a_w(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
      a_w(i+1,k,j) = a_w(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
      a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
      a_ru(i,k-2,j) = a_ru(i,k-2,j)-a_vel*walls(6)
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*(2-walls(5))
      
      do k = kts+1, ktf
        
        vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j))+0.083333333*(w(i+1,k,j)-w(i-&
&2,k,j)-3.*(w(i,k,j)-w(i-1,k,j)))*walls(3))
        a_w(i-2,k,j) = a_w(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_w(i-1,k,j) = a_w(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_w(i+1,k,j) = a_w(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*fzp(k)
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel*fzm(k)
      end do

      if (i_end .eq. ide-2) then
        i = ide-1
! recompute : i
        k = ktf+1
        walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
        walls(1)=0.5*a_fqx(i,k)
!       a_fqx(i,k) = 0.
        a_ru(i,k-2,j) = a_ru(i,k-2,j)-walls(1)*walls(6)*(w(i,k,j)+w(i-1,k,j))
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+walls(1)*(2-walls(5))*(w(i,k,j)+w(i-1,k,j))
        a_w(i-1,k,j) = a_w(i-1,k,j)+walls(1)*((2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j))
        a_w(i,k,j) = a_w(i,k,j)+walls(1)*((2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j))
        do k = kts+1, ktf
          walls(1)=0.5*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_ru(i,k-1,j) = a_ru(i,k-1,j)+walls(1)*fzp(k)*(w(i,k,j)+w(i-1,k,j))
          a_ru(i,k,j) = a_ru(i,k,j)+walls(1)*fzm(k)*(w(i,k,j)+w(i-1,k,j))
          a_w(i-1,k,j) = a_w(i-1,k,j)+walls(1)*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))
          a_w(i,k,j) = a_w(i,k,j)+walls(1)*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))
        end do
        a_fqx(ide-1,kts+1:ktf+1) = 0.
      endif
    endif

    if (degrade_xs) then
      i = i_start+1
! recompute : i
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      vel = (2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j)
! recompute : vel
      walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
      a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j))+0.083333333*(w(i+1,k,j)-w(i-2,&
&k,j)-3.*(w(i,k,j)-w(i-1,k,j)))*walls(3))
      a_w(i-2,k,j) = a_w(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
      a_w(i-1,k,j) = a_w(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
      a_w(i+1,k,j) = a_w(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
      a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
      a_ru(i,k-2,j) = a_ru(i,k-2,j)-a_vel*walls(6)
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*(2-walls(5))
      
      do k = kts+1, ktf
        
        vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j))+0.083333333*(w(i+1,k,j)-w(i-&
&2,k,j)-3.*(w(i,k,j)-w(i-1,k,j)))*walls(3))
        a_w(i-2,k,j) = a_w(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_w(i-1,k,j) = a_w(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_w(i+1,k,j) = a_w(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*fzp(k)
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel*fzm(k)
      end do

      if (i_start .eq. ids+1) then
        i = ids+1
! recompute : i
        k = ktf+1
        walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
        walls(1)=0.5*a_fqx(i,k)
!       a_fqx(i,k) = 0.
        a_ru(i,k-2,j) = a_ru(i,k-2,j)-walls(1)*walls(6)*(w(i,k,j)+w(i-1,k,j))
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+walls(1)*(2-walls(5))*(w(i,k,j)+w(i-1,k,j))
        a_w(i-1,k,j) = a_w(i-1,k,j)+walls(1)*((2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j))
        a_w(i,k,j) = a_w(i,k,j)+walls(1)*((2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j))
        do k = kts+1, ktf
          walls(1)=0.5*a_fqx(i,k)
!         a_fqx(i,k) = 0.
          a_ru(i,k-1,j) = a_ru(i,k-1,j)+walls(1)*fzp(k)*(w(i,k,j)+w(i-1,k,j))
          a_ru(i,k,j) = a_ru(i,k,j)+walls(1)*fzm(k)*(w(i,k,j)+w(i-1,k,j))
          a_w(i-1,k,j) = a_w(i-1,k,j)+walls(1)*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))
          a_w(i,k,j) = a_w(i,k,j)+walls(1)*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))
        end do
        a_fqx(ids+1,kts+1:ktf+1) = 0.

      endif
    endif
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:4456
! recompute vars : k
    k = ktf+1
    walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute vars : k
    do i = i_start_f, i_end_f
      
      vel = (2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j)
! recompute : vel
      walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
      a_vel =walls(1)*(0.61666667*(w(i,k,j)+w(i-1,k,j))-0.13333333*(w(i+1,k,j)+w(i-2,k,j))+0.016666667*(w(i+2,k,j)+w(i-3,&
&k,j))-0.016666667*(w(i+2,k,j)-w(i-3,k,j)-5.*(w(i+1,k,j)-w(i-2,k,j))+10.*(w(i,k,j)-w(i-1,k,j)))*walls(3))
      a_w(i-3,k,j) = a_w(i-3,k,j)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
      a_w(i-2,k,j) = a_w(i-2,k,j)+walls(2)*((-0.13333333)-0.083333333*walls(3))
      a_w(i-1,k,j) = a_w(i-1,k,j)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
      a_w(i+2,k,j) = a_w(i+2,k,j)+walls(2)*(0.016666667-0.016666667*walls(3))
      a_w(i+1,k,j) = a_w(i+1,k,j)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
      a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
      a_ru(i,k-2,j) = a_ru(i,k-2,j)-a_vel*walls(6)
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*(2-walls(5))
      
    end do
    do k = kts+1, ktf
      
      walls(5)=fzp(k); walls(4)=fzm(k)
      do i = i_start_f, i_end_f
        
        vel = walls(4)*ru(i,k,j)+walls(5)*ru(i,k-1,j)
! recompute : vel
        walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_vel =walls(1)*(0.61666667*(w(i,k,j)+w(i-1,k,j))-0.13333333*(w(i+1,k,j)+w(i-2,k,j))+0.016666667*(w(i+2,k,j)+w(i-&
&3,k,j))-0.016666667*(w(i+2,k,j)-w(i-3,k,j)-5.*(w(i+1,k,j)-w(i-2,k,j))+10.*(w(i,k,j)-w(i-1,k,j)))*walls(3))
        a_w(i-3,k,j) = a_w(i-3,k,j)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
        a_w(i-2,k,j) = a_w(i-2,k,j)+walls(2)*((-0.13333333)-0.083333333*walls(3))
        a_w(i-1,k,j) = a_w(i-1,k,j)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
        a_w(i+2,k,j) = a_w(i+2,k,j)+walls(2)*(0.016666667-0.016666667*walls(3))
        a_w(i+1,k,j) = a_w(i+1,k,j)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
        a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*walls(5)
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel*walls(4)
        
      end do
    end do
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:4282
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:4283
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:4284
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:4285
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
! recdepend vars : degrade_ys,i_end,i_start,j_end,j_start,jds,jts
! recompute pos : IF_STMT module_advect_em.f90:4293
! recompute vars : j_start
  if (degrade_ys) then
    j_start = max(jts,jds+1)
  endif
! recompute vars : j_start
! recdepend vars : degrade_ye,i_end,i_start,j_end,j_start,jde,jte
! recompute pos : IF_STMT module_advect_em.f90:4298
! recompute vars : j_end
  if (degrade_ye) then
    j_end = min(jte,jde-2)
  endif
! recompute vars : j_end
  a_j_loop_y_flux_5: do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:4305
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:4306
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    j_loop_y_flux_9a: do j1 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do j_loop_y_flux_9a
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts+1, ktf+1
        do i = i_start, i_end
          mrdy = msft(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        vel = (2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_vel =walls(1)*(0.61666667*(w(i,k,j)+w(i,k,j-1))-0.13333333*(w(i,k,j+1)+w(i,k,j-2))+0.016666667*(w(i,k,j+2)+&
&w(i,k,j-3))-0.016666667*(w(i,k,j+2)-w(i,k,j-3)-5.*(w(i,k,j+1)-w(i,k,j-2))+10.*(w(i,k,j)-w(i,k,j-1)))*walls(3))
        a_w(i,k,j-3) = a_w(i,k,j-3)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
        a_w(i,k,j-2) = a_w(i,k,j-2)+walls(2)*((-0.13333333)-0.083333333*walls(3))
        a_w(i,k,j-1) = a_w(i,k,j-1)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
        a_w(i,k,j+2) = a_w(i,k,j+2)+walls(2)*(0.016666667-0.016666667*walls(3))
        a_w(i,k,j+1) = a_w(i,k,j+1)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
        a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
        a_rv(i,k-2,j) = a_rv(i,k-2,j)-a_vel*walls(6)
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*(2-walls(5))
        
      end do
      do k = kts+1, ktf
        
        walls(5)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          
          vel = walls(4)*rv(i,k,j)+walls(5)*rv(i,k-1,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_vel =walls(1)*(0.61666667*(w(i,k,j)+w(i,k,j-1))-0.13333333*(w(i,k,j+1)+w(i,k,j-2))+0.016666667*(w(i,k,j+2)&
&+w(i,k,j-3))-0.016666667*(w(i,k,j+2)-w(i,k,j-3)-5.*(w(i,k,j+1)-w(i,k,j-2))+10.*(w(i,k,j)-w(i,k,j-1)))*walls(3))
          a_w(i,k,j-3) = a_w(i,k,j-3)+walls(2)*(0.016666667-(-0.016666667)*walls(3))
          a_w(i,k,j-2) = a_w(i,k,j-2)+walls(2)*((-0.13333333)-0.083333333*walls(3))
          a_w(i,k,j-1) = a_w(i,k,j-1)+walls(2)*(0.61666667-(-0.16666667)*walls(3))
          a_w(i,k,j+2) = a_w(i,k,j+2)+walls(2)*(0.016666667-0.016666667*walls(3))
          a_w(i,k,j+1) = a_w(i,k,j+1)+walls(2)*((-0.13333333)-(-0.083333333)*walls(3))
          a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.61666667-0.16666667*walls(3))
          a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*walls(5)
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel*walls(4)
          
        end do
      end do
    else if (j .eq. jds+1) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
        a_rv(i,k-2,j) = a_rv(i,k-2,j)-walls(1)*walls(6)*(w(i,k,j)+w(i,k,j-1))
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+walls(1)*(2-walls(5))*(w(i,k,j)+w(i,k,j-1))
        a_w(i,k,j-1) = a_w(i,k,j-1)+walls(1)*((2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j))
        a_w(i,k,j) = a_w(i,k,j)+walls(1)*((2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j))
      end do
      do k = kts+1, ktf
        walls(3)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_rv(i,k-1,j) = a_rv(i,k-1,j)+walls(1)*walls(3)*(w(i,k,j)+w(i,k,j-1))
          a_rv(i,k,j) = a_rv(i,k,j)+walls(1)*walls(4)*(w(i,k,j)+w(i,k,j-1))
          a_w(i,k,j-1) = a_w(i,k,j-1)+walls(1)*(walls(4)*rv(i,k,j)+walls(3)*rv(i,k-1,j))
          a_w(i,k,j) = a_w(i,k,j)+walls(1)*(walls(4)*rv(i,k,j)+walls(3)*rv(i,k-1,j))
        end do
      end do
    else if (j .eq. jds+2) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        
        vel = (2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2))+0.083333333*(w(i,k,j+1)-&
&w(i,k,j-2)-3.*(w(i,k,j)-w(i,k,j-1)))*walls(3))
        a_w(i,k,j-2) = a_w(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_w(i,k,j-1) = a_w(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
        a_w(i,k,j+1) = a_w(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_rv(i,k-2,j) = a_rv(i,k-2,j)-a_vel*walls(6)
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*(2-walls(5))
      end do
      do k = kts+1, ktf
        walls(5)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          vel = walls(4)*rv(i,k,j)+walls(5)*rv(i,k-1,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2))+0.083333333*(w(i,k,j+&
&1)-w(i,k,j-2)-3.*(w(i,k,j)-w(i,k,j-1)))*walls(3))
          a_w(i,k,j-2) = a_w(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
          a_w(i,k,j-1) = a_w(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
          a_w(i,k,j+1) = a_w(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
          a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
          a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*walls(5)
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel*walls(4)
        end do
      end do
    else if (j .eq. jde-1) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
        a_rv(i,k-2,j) = a_rv(i,k-2,j)-walls(1)*walls(6)*(w(i,k,j)+w(i,k,j-1))
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+walls(1)*(2-walls(5))*(w(i,k,j)+w(i,k,j-1))
        a_w(i,k,j-1) = a_w(i,k,j-1)+walls(1)*((2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j))
        a_w(i,k,j) = a_w(i,k,j)+walls(1)*((2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j))
      end do
      do k = kts+1, ktf
        walls(3)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_rv(i,k-1,j) = a_rv(i,k-1,j)+walls(1)*walls(3)*(w(i,k,j)+w(i,k,j-1))
          a_rv(i,k,j) = a_rv(i,k,j)+walls(1)*walls(4)*(w(i,k,j)+w(i,k,j-1))
          a_w(i,k,j-1) = a_w(i,k,j-1)+walls(1)*(walls(4)*rv(i,k,j)+walls(3)*rv(i,k-1,j))
          a_w(i,k,j) = a_w(i,k,j)+walls(1)*(walls(4)*rv(i,k,j)+walls(3)*rv(i,k-1,j))
        end do
      end do
    else if (j .eq. jde-2) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        
        vel = (2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2))+0.083333333*(w(i,k,j+1)-&
&w(i,k,j-2)-3.*(w(i,k,j)-w(i,k,j-1)))*walls(3))
        a_w(i,k,j-2) = a_w(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_w(i,k,j-1) = a_w(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
        a_w(i,k,j+1) = a_w(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_rv(i,k-2,j) = a_rv(i,k-2,j)-a_vel*walls(6)
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*(2-walls(5))
        
      end do
      do k = kts+1, ktf
        
        walls(5)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          
          vel = walls(4)*rv(i,k,j)+walls(5)*rv(i,k-1,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2))+0.083333333*(w(i,k,j+&
&1)-w(i,k,j-2)-3.*(w(i,k,j)-w(i,k,j-1)))*walls(3))
          a_w(i,k,j-2) = a_w(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
          a_w(i,k,j-1) = a_w(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
          a_w(i,k,j+1) = a_w(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
          a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
          a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*walls(5)
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel*walls(4)
          
        end do
      end do
    endif
  end do a_j_loop_y_flux_5
else if (horz_order .eq. 4) then a_horizontal_order_test
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
! recompute : ktf
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
! recompute : i_start_f
  if (degrade_xe) then
    i_end_f = ide-2
  endif
! recompute : i_end_f
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start = jds+1
    j_start_f = j_start+1
  endif
! recompute : j_start,j_start_f
  if (degrade_ye) then
    j_end = jde-2
    j_end_f = jde-2
  endif
! recompute : j_end,j_end_f
  do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:4662
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:4663
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    do j2 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts+1, ktf+1
        do i = i_start, i_end
          mrdy = msft(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .lt. j_start_f .and. degrade_ys) then
      k = ktf+1
! recompute : k
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
      do i = i_start, i_end
        walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
        a_rv(i,k-2,j_start) = a_rv(i,k-2,j_start)-walls(1)*walls(6)*(w(i,k,j_start)+w(i,k,j_start-1))
        a_rv(i,k-1,j_start) = a_rv(i,k-1,j_start)+walls(1)*(2-walls(5))*(w(i,k,j_start)+w(i,k,j_start-1))
        a_w(i,k,j_start-1) = a_w(i,k,j_start-1)+walls(1)*((2.-walls(5))*rv(i,k-1,j_start)-walls(6)*rv(i,k-2,j_start))
        a_w(i,k,j_start) = a_w(i,k,j_start)+walls(1)*((2.-walls(5))*rv(i,k-1,j_start)-walls(6)*rv(i,k-2,j_start))
      end do
      do k = kts+1, ktf
        walls(3)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_rv(i,k-1,j_start) = a_rv(i,k-1,j_start)+walls(1)*walls(3)*(w(i,k,j_start)+w(i,k,j_start-1))
          a_rv(i,k,j_start) = a_rv(i,k,j_start)+walls(1)*walls(4)*(w(i,k,j_start)+w(i,k,j_start-1))
          a_w(i,k,j_start-1) = a_w(i,k,j_start-1)+walls(1)*(walls(4)*rv(i,k,j_start)+walls(3)*rv(i,k-1,j_start))
          a_w(i,k,j_start) = a_w(i,k,j_start)+walls(1)*(walls(4)*rv(i,k,j_start)+walls(3)*rv(i,k-1,j_start))
        end do
      end do
    else if (j .gt. j_end_f .and. degrade_ye) then
      k = ktf+1
! recompute : k
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
      do i = i_start, i_end
        walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
        a_rv(i,k-2,j_end+1) = a_rv(i,k-2,j_end+1)-walls(1)*walls(6)*(w(i,k,j_end+1)+w(i,k,j_end))
        a_rv(i,k-1,j_end+1) = a_rv(i,k-1,j_end+1)+walls(1)*(2-walls(5))*(w(i,k,j_end+1)+w(i,k,j_end))
        a_w(i,k,j_end+1) = a_w(i,k,j_end+1)+walls(1)*((2.-walls(5))*rv(i,k-1,j_end+1)-walls(6)*rv(i,k-2,j_end+1))
        a_w(i,k,j_end) = a_w(i,k,j_end)+walls(1)*((2.-walls(5))*rv(i,k-1,j_end+1)-walls(6)*rv(i,k-2,j_end+1))
      end do
      do k = kts+1, ktf
        walls(3)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_rv(i,k-1,j_end+1) = a_rv(i,k-1,j_end+1)+walls(1)*walls(3)*(w(i,k,j_end+1)+w(i,k,j_end))
          a_rv(i,k,j_end+1) = a_rv(i,k,j_end+1)+walls(1)*walls(4)*(w(i,k,j_end+1)+w(i,k,j_end))
          a_w(i,k,j_end+1) = a_w(i,k,j_end+1)+walls(1)*(walls(4)*rv(i,k,j_end+1)+walls(3)*rv(i,k-1,j_end+1))
          a_w(i,k,j_end) = a_w(i,k,j_end)+walls(1)*(walls(4)*rv(i,k,j_end+1)+walls(3)*rv(i,k-1,j_end+1))
        end do
      end do
    else
      k = ktf+1
! recompute : k
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
      do i = i_start, i_end
        vel = (2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2)))
        a_w(i,k,j-2) = a_w(i,k,j-2)-0.083333333*walls(2)
        a_w(i,k,j-1) = a_w(i,k,j-1)+0.58333333*walls(2)
        a_w(i,k,j+1) = a_w(i,k,j+1)-0.083333333*walls(2)
        a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
        a_rv(i,k-2,j) = a_rv(i,k-2,j)-a_vel*walls(6)
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*(2-walls(5))
      end do
      do k = kts+1, ktf
        walls(3)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          vel = walls(4)*rv(i,k,j)+walls(3)*rv(i,k-1,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel
          a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2)))
          a_w(i,k,j-2) = a_w(i,k,j-2)-0.083333333*walls(2)
          a_w(i,k,j-1) = a_w(i,k,j-1)+0.58333333*walls(2)
          a_w(i,k,j+1) = a_w(i,k,j+1)-0.083333333*walls(2)
          a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
          a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*walls(3)
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel*walls(4)
          
        end do
      end do
    endif
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:4560
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:4561
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:4562
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:4563
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
! recdepend vars : degrade_xs,i_end,i_start,ids,j_end,j_start
! recompute pos : IF_STMT module_advect_em.f90:4571
! recompute vars : i_start
  if (degrade_xs) then
    i_start = ids+1
  endif
! recompute vars : i_start
! recdepend vars : degrade_xe,i_end,i_start,ide,j_end,j_start
! recompute pos : IF_STMT module_advect_em.f90:4576
! recompute vars : i_end
  if (degrade_xe) then
    i_end = ide-2
  endif
! recompute vars : i_end
  do j = j_end, j_start, -1
    do k = kts+1, ktf+1
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do
    if (degrade_xe) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      walls(1) =0.5*a_fqx(i_end+1,k); a_fqx(i_end+1,k)= 0.
      a_ru(i_end+1,k-2,j) = a_ru(i_end+1,k-2,j)-walls(1)*walls(6)*(w(i_end+1,k,j)+w(i_end,k,j))
      a_ru(i_end+1,k-1,j) = a_ru(i_end+1,k-1,j)+walls(1)*(2-walls(5))*(w(i_end+1,k,j)+w(i_end,k,j))
      a_w(i_end+1,k,j) = a_w(i_end+1,k,j)+walls(1)*((2.-walls(5))*ru(i_end+1,k-1,j)-walls(6)*ru(i_end+1,k-2,j))
      a_w(i_end,k,j) = a_w(i_end,k,j)+walls(1)*((2.-walls(5))*ru(i_end+1,k-1,j)-walls(6)*ru(i_end+1,k-2,j))
      do k = kts+1, ktf
        walls(1) =0.5*a_fqx(i_end+1,k); a_fqx(i_end+1,k)= 0.
        a_ru(i_end+1,k-1,j) = a_ru(i_end+1,k-1,j)+walls(1)*fzp(k)*(w(i_end+1,k,j)+w(i_end,k,j))
        a_ru(i_end+1,k,j) = a_ru(i_end+1,k,j)+walls(1)*fzm(k)*(w(i_end+1,k,j)+w(i_end,k,j))
        a_w(i_end+1,k,j) = a_w(i_end+1,k,j)+walls(1)*(fzm(k)*ru(i_end+1,k,j)+fzp(k)*ru(i_end+1,k-1,j))
        a_w(i_end,k,j) = a_w(i_end,k,j)+walls(1)*(fzm(k)*ru(i_end+1,k,j)+fzp(k)*ru(i_end+1,k-1,j))
      end do
    endif
    if (degrade_xs) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      walls(1) =0.5*a_fqx(i_start,k); a_fqx(i_start,k) = 0.
      a_ru(i_start,k-2,j) = a_ru(i_start,k-2,j)-walls(1)*walls(6)*(w(i_start,k,j)+w(i_start-1,k,j))
      a_ru(i_start,k-1,j) = a_ru(i_start,k-1,j)+walls(1)*(2-walls(5))*(w(i_start,k,j)+w(i_start-1,k,j))
      a_w(i_start-1,k,j) = a_w(i_start-1,k,j)+walls(1)*((2.-walls(5))*ru(i_start,k-1,j)-walls(6)*ru(i_start,k-2,j))
      a_w(i_start,k,j) = a_w(i_start,k,j)+walls(1)*((2.-walls(5))*ru(i_start,k-1,j)-walls(6)*ru(i_start,k-2,j))
      do k = kts+1, ktf
        walls(1) =0.5*a_fqx(i_start,k); a_fqx(i_start,k) = 0.
        a_ru(i_start,k-1,j) = a_ru(i_start,k-1,j)+walls(1)*fzp(k)*(w(i_start,k,j)+w(i_start-1,k,j))
        a_ru(i_start,k,j) = a_ru(i_start,k,j)+walls(1)*fzm(k)*(w(i_start,k,j)+w(i_start-1,k,j))
        a_w(i_start-1,k,j) = a_w(i_start-1,k,j)+walls(1)*(fzm(k)*ru(i_start,k,j)+fzp(k)*ru(i_start,k-1,j))
        a_w(i_start,k,j) = a_w(i_start,k,j)+walls(1)*(fzm(k)*ru(i_start,k,j)+fzp(k)*ru(i_start,k-1,j))
      end do
    endif
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:4594
! recompute vars : k
    k = ktf+1
    walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute vars : k
    do i = i_start_f, i_end_f
      vel = (2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j)
! recompute : vel
      walls(1)=a_fqx(i,k)
!     a_fqx(i,k) = 0.
      walls(2)=walls(1)*vel
      a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))
      a_w(i-2,k,j) = a_w(i-2,k,j)-0.083333333*walls(2)
      a_w(i-1,k,j) = a_w(i-1,k,j)+0.58333333*walls(2)
      a_w(i+1,k,j) = a_w(i+1,k,j)-0.083333333*walls(2)
      a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
      a_ru(i,k-2,j) = a_ru(i,k-2,j)-a_vel*walls(6)
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*(2-walls(5))
    end do
    a_fqx(i_start_f:i_end_f,ktf+1) = 0.

    do k = kts+1, ktf
      walls(3)=fzp(k); walls(4)=fzm(k)
      do i = i_start_f, i_end_f
        vel = walls(4)*ru(i,k,j)+walls(3)*ru(i,k-1,j)
! recompute : vel
        walls(1)=a_fqx(i,k)
!       a_fqx(i,k) = 0.
        walls(2)=walls(1)*vel
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))
        a_w(i-2,k,j) = a_w(i-2,k,j)-0.083333333*walls(2)
        a_w(i-1,k,j) = a_w(i-1,k,j)+0.58333333*walls(2)
        a_w(i+1,k,j) = a_w(i+1,k,j)-0.083333333*walls(2)
        a_w(i,k,j) = a_w(i,k,j)+0.58333333*walls(2)
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*walls(3)
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel*walls(4)
      end do
    end do
    a_fqx(i_start_f:i_end_f,kts+1:ktf) = 0.

  end do
else if (horz_order .eq. 3) then a_horizontal_order_test
  degrade_xs =  .true. 
! recompute : degrade_xs
  degrade_xe =  .true. 
! recompute : degrade_xe
  degrade_ys =  .true. 
! recompute : degrade_ys
  degrade_ye =  .true. 
! recompute : degrade_ye
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
! recompute : degrade_xs
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
! recompute : degrade_xe
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
! recompute : degrade_ys
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
! recompute : degrade_ye
! recompute : ktf
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  i_start_f = i_start
! recompute : i_start_f
  i_end_f = i_end+1
! recompute : i_end_f
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
! recompute : i_start_f
  if (degrade_xe) then
    i_end_f = ide-2
  endif
! recompute : i_end_f
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  j_start_f = j_start
! recompute : j_start_f
  j_end_f = j_end+1
! recompute : j_end_f
  if (degrade_ys) then
    j_start = jds+1
    j_start_f = j_start+1
  endif
! recompute : j_start,j_start_f
  if (degrade_ye) then
    j_end = jde-2
    j_end_f = jde-2
  endif
! recompute : j_end,j_end_f
  do j = j_end+1, j_start, -1
! recompute pos : ASSIGN_STMT module_advect_em.f90:4859
! recompute vars : jp1
    jp1 = 2
! recompute vars : jp1
! recdepend vars : jp1
! recompute pos : ASSIGN_STMT module_advect_em.f90:4860
! recompute vars : jp0
    jp0 = 1
! recompute vars : jp0
    do j3 = j_start, j-1
      jtmp = jp1
      jp1 = jp0
      jp0 = jtmp
    end do
!    if (j .gt. j_start) then
    if (j .gt. jds+1) then
      do k = kts+1, ktf+1
        do i = i_start, i_end
          mrdy = msft(i,j-1)*a_tendency(i,k,j-1)*rdy
! recompute : mrdy
          a_fqy(i,k,jp0) = a_fqy(i,k,jp0)+mrdy
          a_fqy(i,k,jp1) = a_fqy(i,k,jp1)-mrdy
        end do
      end do
    endif
    if (j .lt. j_start_f .and. degrade_ys) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
        a_rv(i,k-2,j_start) = a_rv(i,k-2,j_start)-walls(1)*walls(6)*(w(i,k,j_start)+w(i,k,j_start-1))
        a_rv(i,k-1,j_start) = a_rv(i,k-1,j_start)+walls(1)*(2-walls(5))*(w(i,k,j_start)+w(i,k,j_start-1))
        a_w(i,k,j_start-1) = a_w(i,k,j_start-1)+walls(1)*((2.-walls(5))*rv(i,k-1,j_start)-walls(6)*rv(i,k-2,j_start))
        a_w(i,k,j_start) = a_w(i,k,j_start)+walls(1)*((2.-walls(5))*rv(i,k-1,j_start)-walls(6)*rv(i,k-2,j_start))
      end do
      do k = kts+1, ktf
        walls(3)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_rv(i,k-1,j_start) = a_rv(i,k-1,j_start)+walls(1)*walls(3)*(w(i,k,j_start)+w(i,k,j_start-1))
          a_rv(i,k,j_start) = a_rv(i,k,j_start)+walls(1)*walls(4)*(w(i,k,j_start)+w(i,k,j_start-1))
          a_w(i,k,j_start-1) = a_w(i,k,j_start-1)+walls(1)*(walls(4)*rv(i,k,j_start)+walls(3)*rv(i,k-1,j_start))
          a_w(i,k,j_start) = a_w(i,k,j_start)+walls(1)*(walls(4)*rv(i,k,j_start)+walls(3)*rv(i,k-1,j_start))
        end do
      end do
    else if (j .gt. j_end_f .and. degrade_ye) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
        a_rv(i,k-2,j_end+1) = a_rv(i,k-2,j_end+1)-walls(1)*walls(6)*(w(i,k,j_end+1)+w(i,k,j_end))
        a_rv(i,k-1,j_end+1) = a_rv(i,k-1,j_end+1)+walls(1)*(2-walls(5))*(w(i,k,j_end+1)+w(i,k,j_end))
        a_w(i,k,j_end+1) = a_w(i,k,j_end+1)+walls(1)*((2.-walls(5))*rv(i,k-1,j_end+1)-walls(6)*rv(i,k-2,j_end+1))
        a_w(i,k,j_end) = a_w(i,k,j_end)+walls(1)*((2.-walls(5))*rv(i,k-1,j_end+1)-walls(6)*rv(i,k-2,j_end+1))
      end do
      do k = kts+1, ktf
        walls(3)=fzp(k); walls(4)=fzm(k)
        do i = i_start, i_end
          walls(1) =0.5*a_fqy(i,k,jp1); a_fqy(i,k,jp1) =0.
          a_rv(i,k-1,j_end+1) = a_rv(i,k-1,j_end+1)+walls(1)*walls(3)*(w(i,k,j_end+1)+w(i,k,j_end))
          a_rv(i,k,j_end+1) = a_rv(i,k,j_end+1)+walls(1)*walls(4)*(w(i,k,j_end+1)+w(i,k,j_end))
          a_w(i,k,j_end+1) = a_w(i,k,j_end+1)+walls(1)*(walls(4)*rv(i,k,j_end+1)+walls(3)*rv(i,k-1,j_end+1))
          a_w(i,k,j_end) = a_w(i,k,j_end)+walls(1)*(walls(4)*rv(i,k,j_end+1)+walls(3)*rv(i,k-1,j_end+1))
        end do
      end do
    else
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      do i = i_start, i_end
        
        vel = (2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2))+0.083333333*(w(i,k,j+1)-&
&w(i,k,j-2)-3.*(w(i,k,j)-w(i,k,j-1)))*walls(3))
        a_w(i,k,j-2) = a_w(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_w(i,k,j-1) = a_w(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
        a_w(i,k,j+1) = a_w(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_rv(i,k-2,j) = a_rv(i,k-2,j)-a_vel*walls(6)
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*(2-walls(5))
        
      end do
      do k = kts+1, ktf
        walls(4)=fzp(k); walls(5)=fzm(k)
        do i = i_start, i_end
          vel = walls(5)*rv(i,k,j)+walls(4)*rv(i,k-1,j)
! recompute : vel
          walls(1)=a_fqy(i,k,jp1); a_fqy(i,k,jp1)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
          a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2))+0.083333333*(w(i,k,j+&
&1)-w(i,k,j-2)-3.*(w(i,k,j)-w(i,k,j-1)))*walls(3))
          a_w(i,k,j-2) = a_w(i,k,j-2)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
          a_w(i,k,j-1) = a_w(i,k,j-1)+walls(2)*(0.58333333+0.25*walls(3))
          a_w(i,k,j+1) = a_w(i,k,j+1)+walls(2)*((-0.083333333)+0.083333333*walls(3))
          a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
          a_rv(i,k-1,j) = a_rv(i,k-1,j)+a_vel*walls(4)
          a_rv(i,k,j) = a_rv(i,k,j)+a_vel*walls(5)
        end do
      end do
    endif
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:4757
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:4758
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:4759
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:4760
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
! recdepend vars : degrade_xs,i_end,i_start,ids,j_end,j_start
! recompute pos : IF_STMT module_advect_em.f90:4768
! recompute vars : i_start
  if (degrade_xs) then
    i_start = ids+1
  endif
! recompute vars : i_start
! recdepend vars : degrade_xe,i_end,i_start,ide,j_end,j_start
! recompute pos : IF_STMT module_advect_em.f90:4773
! recompute vars : i_end
  if (degrade_xe) then
    i_end = ide-2
  endif
! recompute vars : i_end
  do j = j_end, j_start, -1
    do k = kts+1, ktf+1
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
! recompute : mrdx
        a_fqx(i+1,k) = a_fqx(i+1,k)-a_tendency(i,k,j)*mrdx
        a_fqx(i,k) = a_fqx(i,k)+a_tendency(i,k,j)*mrdx
      end do
    end do
    if (degrade_xe) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      walls(1) =0.5*a_fqx(i_end+1,k); a_fqx(i_end+1,k)= 0.
      a_ru(i_end+1,k-2,j) = a_ru(i_end+1,k-2,j)-walls(1)*walls(6)*(w(i_end+1,k,j)+w(i_end,k,j))
      a_ru(i_end+1,k-1,j) = a_ru(i_end+1,k-1,j)+walls(1)*(2-walls(5))*(w(i_end+1,k,j)+w(i_end,k,j))
      a_w(i_end+1,k,j) = a_w(i_end+1,k,j)+walls(1)*((2.-walls(5))*ru(i_end+1,k-1,j)-walls(6)*ru(i_end+1,k-2,j))
      a_w(i_end,k,j) = a_w(i_end,k,j)+walls(1)*((2.-walls(5))*ru(i_end+1,k-1,j)-walls(6)*ru(i_end+1,k-2,j))
      do k = kts+1, ktf
        walls(1) =0.5*a_fqx(i_end+1,k); a_fqx(i_end+1,k)= 0.
        a_ru(i_end+1,k-1,j) = a_ru(i_end+1,k-1,j)+walls(1)*fzp(k)*(w(i_end+1,k,j)+w(i_end,k,j))
        a_ru(i_end+1,k,j) = a_ru(i_end+1,k,j)+walls(1)*fzm(k)*(w(i_end+1,k,j)+w(i_end,k,j))
        a_w(i_end+1,k,j) = a_w(i_end+1,k,j)+walls(1)*(fzm(k)*ru(i_end+1,k,j)+fzp(k)*ru(i_end+1,k-1,j))
        a_w(i_end,k,j) = a_w(i_end,k,j)+walls(1)*(fzm(k)*ru(i_end+1,k,j)+fzp(k)*ru(i_end+1,k-1,j))
      end do
    endif
    if (degrade_xs) then
      k = ktf+1
      walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
      walls(1) =0.5*a_fqx(i_start,k); a_fqx(i_start,k) = 0.
      a_ru(i_start,k-2,j) = a_ru(i_start,k-2,j)-walls(1)*walls(6)*(w(i_start,k,j)+w(i_start-1,k,j))
      a_ru(i_start,k-1,j) = a_ru(i_start,k-1,j)+walls(1)*(2-walls(5))*(w(i_start,k,j)+w(i_start-1,k,j))
      a_w(i_start-1,k,j) = a_w(i_start-1,k,j)+walls(1)*((2.-walls(5))*ru(i_start,k-1,j)-walls(6)*ru(i_start,k-2,j))
      a_w(i_start,k,j) = a_w(i_start,k,j)+walls(1)*((2.-walls(5))*ru(i_start,k-1,j)-walls(6)*ru(i_start,k-2,j))
      do k = kts+1, ktf
        walls(1) =0.5*a_fqx(i_start,k); a_fqx(i_start,k) = 0.
        a_ru(i_start,k-1,j) = a_ru(i_start,k-1,j)+walls(1)*fzp(k)*(w(i_start,k,j)+w(i_start-1,k,j))
        a_ru(i_start,k,j) = a_ru(i_start,k,j)+walls(1)*fzm(k)*(w(i_start,k,j)+w(i_start-1,k,j))
        a_w(i_start-1,k,j) = a_w(i_start-1,k,j)+walls(1)*(fzm(k)*ru(i_start,k,j)+fzp(k)*ru(i_start,k-1,j))
        a_w(i_start,k,j) = a_w(i_start,k,j)+walls(1)*(fzm(k)*ru(i_start,k,j)+fzp(k)*ru(i_start,k-1,j))
      end do
    endif
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_advect_em.f90:4790
! recompute vars : k
    k = ktf+1
    walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute vars : k
    do i = i_start_f, i_end_f
      vel = (2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j)
! recompute : vel
      walls(1)=a_fqx(i,k); a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
      a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j))+0.083333333*(w(i+1,k,j)-w(i-2,&
&k,j)-3.*(w(i,k,j)-w(i-1,k,j)))*walls(3))
      a_w(i-2,k,j) = a_w(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
      a_w(i-1,k,j) = a_w(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
      a_w(i+1,k,j) = a_w(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
      a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
      a_ru(i,k-2,j) = a_ru(i,k-2,j)-a_vel*walls(6)
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*(2-walls(5))
    end do

    do k = kts+1, ktf
      walls(5)=fzp(k); walls(6)=fzm(k)
      do i = i_start_f, i_end_f
        vel = walls(6)*ru(i,k,j)+walls(5)*ru(i,k-1,j)
! recompute : vel
        walls(1)=a_fqx(i,k)*vel; a_fqx(i,k)=0.; walls(2)=walls(1)*vel; walls(3)=sign(1.,vel)
        a_vel =walls(1)*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j))+0.083333333*(w(i+1,k,j)-w(i-&
&2,k,j)-3.*(w(i,k,j)-w(i-1,k,j)))*walls(3))
        a_w(i-2,k,j) = a_w(i-2,k,j)+walls(2)*((-0.083333333)+(-0.083333333)*walls(3))
        a_w(i-1,k,j) = a_w(i-1,k,j)+walls(2)*(0.58333333+0.25*walls(3))
        a_w(i+1,k,j) = a_w(i+1,k,j)+walls(2)*((-0.083333333)+0.083333333*walls(3))
        a_w(i,k,j) = a_w(i,k,j)+walls(2)*(0.58333333+(-0.25)*walls(3))
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+a_vel*walls(5)
        a_ru(i,k,j) = a_ru(i,k,j)+a_vel*walls(6)
      end do
    end do

  end do
else if (horz_order .eq. 2) then a_horizontal_order_test
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
! recompute : j_start
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-2,jte)
  endif
! recompute : j_end
  do j = j_end, j_start, -1
    k = ktf+1
    walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
    do i = i_start, i_end
      mrdy = msft(i,j)*rdy
! recompute : mrdy
      walls(1)=0.5*a_tendency(i,k,j)*mrdy
      a_rv(i,k-2,j+1) = a_rv(i,k-2,j+1)+walls(1)*walls(6)*(w(i,k,j+1)+w(i,k,j))
      a_rv(i,k-2,j) = a_rv(i,k-2,j)-walls(1)*walls(6)*(w(i,k,j)+w(i,k,j-1))
      a_rv(i,k-1,j+1) = a_rv(i,k-1,j+1)-walls(1)*(2-walls(5))*(w(i,k,j+1)+w(i,k,j))
      a_rv(i,k-1,j) = a_rv(i,k-1,j)+walls(1)*(2-walls(5))*(w(i,k,j)+w(i,k,j-1))
      a_w(i,k,j-1) = a_w(i,k,j-1)+walls(1)*((2.-walls(5))*rv(i,k-1,j)-walls(6)*rv(i,k-2,j))
      a_w(i,k,j+1) = a_w(i,k,j+1)-walls(1)*((2.-walls(5))*rv(i,k-1,j+1)-walls(6)*rv(i,k-2,j+1))
      a_w(i,k,j) = a_w(i,k,j)-walls(1)*((2.-walls(5))*rv(i,k-1,j+1)-walls(6)*rv(i,k-2,j+1)-((2.-walls(5))*rv(i,k-&
&1,j)-walls(6)*rv(i,k-2,j)))
    end do
    do k = kts+1, ktf
      walls(5)=fzp(k); walls(6)=fzm(k)
      do i = i_start, i_end
        mrdy = msft(i,j)*rdy
! recompute : mrdy
        walls(1)=0.5*a_tendency(i,k,j)*mrdy
        a_rv(i,k-1,j+1) = a_rv(i,k-1,j+1)-walls(1)*walls(5)*(w(i,k,j+1)+w(i,k,j))
        a_rv(i,k-1,j) = a_rv(i,k-1,j)+walls(1)*walls(5)*(w(i,k,j)+w(i,k,j-1))
        a_rv(i,k,j+1) = a_rv(i,k,j+1)-walls(1)*walls(6)*(w(i,k,j+1)+w(i,k,j))
        a_rv(i,k,j) = a_rv(i,k,j)+walls(1)*walls(6)*(w(i,k,j)+w(i,k,j-1))
        a_w(i,k,j-1) = a_w(i,k,j-1)+walls(1)*(walls(6)*rv(i,k,j)+walls(5)*rv(i,k-1,j))
        a_w(i,k,j+1) = a_w(i,k,j+1)-walls(1)*(walls(6)*rv(i,k,j+1)+walls(5)*rv(i,k-1,j+1))
        a_w(i,k,j) = a_w(i,k,j)-walls(1)*(walls(6)*rv(i,k,j+1)+walls(5)*rv(i,k-1,j+1)-(walls(6)*rv(i,k,j)+walls(5)*rv(i,&
&k-1,j)))
      end do
    end do
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_advect_em.f90:4929
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_advect_em.f90:4930
! recompute vars : i_end
  i_end = min(ite,ide-1)
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_advect_em.f90:4931
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_advect_em.f90:4932
! recompute vars : j_end
  j_end = min(jte,jde-1)
! recompute vars : j_end
!  recdepend vars : config_flags,i_end,i_start,ids,its,j_end,j_start,spe
! cified
! recompute pos : IF_STMT module_advect_em.f90:4934
! recompute vars : i_start
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
! recompute vars : i_start
!  recdepend vars : config_flags,i_end,i_start,ide,ite,j_end,j_start,spe
! cified
! recompute pos : IF_STMT module_advect_em.f90:4935
! recompute vars : i_end
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-2,ite)
  endif
! recompute vars : i_end
  do j = j_end, j_start, -1
    k = ktf+1
    walls(5)=fzm(k-1); walls(6)=fzp(k-1)
! recompute : k
    do i = i_start, i_end
      mrdx = msft(i,j)*rdx
! recompute : mrdx
      walls(1)=0.5*a_tendency(i,k,j)*mrdx
      a_ru(i+1,k-2,j) = a_ru(i+1,k-2,j)+walls(1)*walls(6)*(w(i+1,k,j)+w(i,k,j))
      a_ru(i,k-2,j) = a_ru(i,k-2,j)-walls(1)*walls(6)*(w(i,k,j)+w(i-1,k,j))
      a_ru(i+1,k-1,j) = a_ru(i+1,k-1,j)-walls(1)*(2-walls(5))*(w(i+1,k,j)+w(i,k,j))
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+walls(1)*(2-walls(5))*(w(i,k,j)+w(i-1,k,j))
      a_w(i-1,k,j) = a_w(i-1,k,j)+walls(1)*((2.-walls(5))*ru(i,k-1,j)-walls(6)*ru(i,k-2,j))
      a_w(i+1,k,j) = a_w(i+1,k,j)-walls(1)*((2.-walls(5))*ru(i+1,k-1,j)-walls(6)*ru(i+1,k-2,j))
      a_w(i,k,j) = a_w(i,k,j)-walls(1)*((2.-walls(5))*ru(i+1,k-1,j)-walls(6)*ru(i+1,k-2,j)-((2.-walls(5))*ru(i,k-&
&1,j)-walls(6)*ru(i,k-2,j)))
    end do
    do k = kts+1, ktf
      walls(2)=fzp(k); walls(3)=fzm(k)
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
! recompute : mrdx
        walls(1)=0.5*a_tendency(i,k,j)*mrdx
        a_ru(i+1,k-1,j) = a_ru(i+1,k-1,j)-walls(1)*walls(2)*(w(i+1,k,j)+w(i,k,j))
        a_ru(i,k-1,j) = a_ru(i,k-1,j)+walls(1)*walls(2)*(w(i,k,j)+w(i-1,k,j))
        a_ru(i+1,k,j) = a_ru(i+1,k,j)-walls(1)*walls(3)*(w(i+1,k,j)+w(i,k,j))
        a_ru(i,k,j) = a_ru(i,k,j)+walls(1)*walls(3)*(w(i,k,j)+w(i-1,k,j))
        a_w(i-1,k,j) = a_w(i-1,k,j)+walls(1)*(walls(3)*ru(i,k,j)+walls(2)*ru(i,k-1,j))
        a_w(i+1,k,j) = a_w(i+1,k,j)-walls(1)*(walls(3)*ru(i+1,k,j)+walls(2)*ru(i+1,k-1,j))
        a_w(i,k,j) = a_w(i,k,j)-walls(1)*(walls(3)*ru(i+1,k,j)+walls(2)*ru(i+1,k-1,j)-(walls(3)*ru(i,k,j)+walls(2)*ru(i,&
&k-1,j)))
      end do
    end do
  end do
endif a_horizontal_order_test

   call trace_exit("a_advect_w")

end subroutine a_advect_w

end module     a_module_advect_em


