!                           DISCLAIMER
!
!   This file was generated by TAF version 1.7.18
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     g_module_advect_em
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use module_bc
use g_module_bc
use module_model_constants
use module_wrf_error
use module_advect_em

USE module_trace, only : trace_entry, trace_exit

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains

subroutine g_advect_scalar( field, g_field, field_old, g_field_old, tendency, g_tendency, ru, g_ru, rv, g_rv, rom, g_rom, &
&config_flags, msft, fzm, fzp, rdx, rdy, rdzw, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: field_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
real, intent(in) :: g_field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_field_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rom(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_tendency(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: rdzw(kms:kme)
real, intent(in) :: rom(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: tendency(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
logical degrade_xe
logical degrade_xs
logical degrade_ye
logical degrade_ys
real fqx(its:ite+1,kts:kte)
real fqy(its:ite,kts:kte,2)
real g_fqx(its:ite+1,kts:kte)
real g_fqy(its:ite,kts:kte,2)
real g_ub
real g_vb
real g_vel
real g_vflux(its:ite,kts:kte)
integer horz_order
integer i
integer i_end
integer i_end_f
integer i_start
integer i_start_f
integer j
integer j_end
integer j_end_f
integer j_start
integer j_start_f
integer jp0
integer jp1
integer jtmp
integer k
integer ktf
real mrdx
real mrdy
logical specified
real ub
real vb
real vel
integer vert_order
real vflux(its:ite,kts:kte)

   call trace_entry("g_advect_scalar")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
ktf = min(kte,kde-1)
horz_order = config_flags%h_sca_adv_order
vert_order = config_flags%v_sca_adv_order
horizontal_order_tesu: if (horz_order .eq. 6) then
  CALL wrf_error_fatal ( ' horz_order == 6 does not pass AD/TL check' )
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-3) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-3) then
    degrade_ye =  .false. 
  endif
  ktf = min(kte,kde-1)
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = max(jts,jds+1)
    j_start_f = jds+3
  endif
  if (degrade_ye) then
    j_end = min(jte,jde-2)
    j_end_f = jde-3
  endif
  jp1 = 2
  jp0 = 1
  j_loop_y_flux_6: do j = j_start, j_end+1
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = g_rv(i,k,j)
          vel = rv(i,k,j)
          g_fqy(i,k,jp1) = 0.016666667*g_field(i,k,j-3)*vel-0.13333333*g_field(i,k,j-2)*vel+0.61666667*g_field(i,k,j-1)*vel+&
&0.016666667*g_field(i,k,j+2)*vel-0.13333333*g_field(i,k,j+1)*vel+0.61666667*g_field(i,k,j)*vel+g_vel*(0.61666667*&
&(field(i,k,j)+field(i,k,j-1))-0.13333333*(field(i,k,j+1)+field(i,k,j-2))+0.016666667*(field(i,k,j+2)+field(i,k,j-3)))
          fqy(i,k,jp1) = vel*(37./60.*(field(i,k,j)+field(i,k,j-1))-2./15.*(field(i,k,j+1)+field(i,k,j-2))+1./60.*(field(i,k,j+2)+&
&field(i,k,j-3)))
        end do
      end do
    else if (j .eq. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.5*g_field(i,k,j-1)*rv(i,k,j)+0.5*g_field(i,k,j)*rv(i,k,j)+0.5*g_rv(i,k,j)*(field(i,k,j)+field(i,k,j-1))
          fqy(i,k,jp1) = 0.5*rv(i,k,j)*(field(i,k,j)+field(i,k,j-1))
        end do
      end do
    else if (j .eq. jds+2) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = g_rv(i,k,j)
          vel = rv(i,k,j)
          g_fqy(i,k,jp1) = (-0.083333333)*g_field(i,k,j-2)*vel+0.58333333*g_field(i,k,j-1)*vel-0.083333333*g_field(i,k,j+1)*vel+&
&0.58333333*g_field(i,k,j)*vel+g_vel*(0.58333333*(field(i,k,j)+field(i,k,j-1))-0.083333333*(field(i,k,j+1)+field(i,k,j-2)))
          fqy(i,k,jp1) = vel*(7./12.*(field(i,k,j)+field(i,k,j-1))-1./12.*(field(i,k,j+1)+field(i,k,j-2)))
        end do
      end do
    else if (j .eq. jde-1) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.5*g_field(i,k,j-1)*rv(i,k,j)+0.5*g_field(i,k,j)*rv(i,k,j)+0.5*g_rv(i,k,j)*(field(i,k,j)+field(i,k,j-1))
          fqy(i,k,jp1) = 0.5*rv(i,k,j)*(field(i,k,j)+field(i,k,j-1))
        end do
      end do
    else if (j .eq. jde-2) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = g_rv(i,k,j)
          vel = rv(i,k,j)
          g_fqy(i,k,jp1) = (-0.083333333)*g_field(i,k,j-2)*vel+0.58333333*g_field(i,k,j-1)*vel-0.083333333*g_field(i,k,j+1)*vel+&
&0.58333333*g_field(i,k,j)*vel+g_vel*(0.58333333*(field(i,k,j)+field(i,k,j-1))-0.083333333*(field(i,k,j+1)+field(i,k,j-2)))
          fqy(i,k,jp1) = vel*(7./12.*(field(i,k,j)+field(i,k,j-1))-1./12.*(field(i,k,j+1)+field(i,k,j-2)))
        end do
      end do
    endif
    if (j .gt. j_start) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msft(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do j_loop_y_flux_6
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = i_start+2
  endif
  if (degrade_xe) then
    i_end = min(ide-2,ite)
    i_end_f = ide-3
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start_f, i_end_f
        g_vel = g_ru(i,k,j)
        vel = ru(i,k,j)
        g_fqx(i,k) = 0.016666667*g_field(i-3,k,j)*vel-0.13333333*g_field(i-2,k,j)*vel+0.61666667*g_field(i-1,k,j)*vel+0.016666667*&
&g_field(i+2,k,j)*vel-0.13333333*g_field(i+1,k,j)*vel+0.61666667*g_field(i,k,j)*vel+g_vel*(0.61666667*(field(i,k,j)+&
&field(i-1,k,j))-0.13333333*(field(i+1,k,j)+field(i-2,k,j))+0.016666667*(field(i+2,k,j)+field(i-3,k,j)))
        fqx(i,k) = vel*(37./60.*(field(i,k,j)+field(i-1,k,j))-2./15.*(field(i+1,k,j)+field(i-2,k,j))+1./60.*(field(i+2,k,j)+&
&field(i-3,k,j)))
      end do
    end do
    if (degrade_xs) then
      if (i_start .eq. ids+1) then
        i = ids+1
        do k = kts, ktf
          g_fqx(i,k) = 0.5*g_field(i-1,k,j)*ru(i,k,j)+0.5*g_field(i,k,j)*ru(i,k,j)+0.5*g_ru(i,k,j)*(field(i,k,j)+field(i-1,k,j))
          fqx(i,k) = 0.5*ru(i,k,j)*(field(i,k,j)+field(i-1,k,j))
        end do
      endif
      i = ids+2
      do k = kts, ktf
        g_vel = g_ru(i,k,j)
        vel = ru(i,k,j)
        g_fqx(i,k) = (-0.083333333)*g_field(i-2,k,j)*vel+0.58333333*g_field(i-1,k,j)*vel-0.083333333*g_field(i+1,k,j)*vel+&
&0.58333333*g_field(i,k,j)*vel+g_vel*(0.58333333*(field(i,k,j)+field(i-1,k,j))-0.083333333*(field(i+1,k,j)+field(i-2,k,j)))
        fqx(i,k) = vel*(7./12.*(field(i,k,j)+field(i-1,k,j))-1./12.*(field(i+1,k,j)+field(i-2,k,j)))
      end do
    endif
    if (degrade_xe) then
      if (i_end .eq. ide-2) then
        i = ide-1
        do k = kts, ktf
          g_fqx(i,k) = 0.5*g_field(i-1,k,j)*ru(i,k,j)+0.5*g_field(i,k,j)*ru(i,k,j)+0.5*g_ru(i,k,j)*(field(i,k,j)+field(i-1,k,j))
          fqx(i,k) = 0.5*ru(i,k,j)*(field(i,k,j)+field(i-1,k,j))
        end do
      endif
      i = ide-2
      do k = kts, ktf
        g_vel = g_ru(i,k,j)
        vel = ru(i,k,j)
        g_fqx(i,k) = (-0.083333333)*g_field(i-2,k,j)*vel+0.58333333*g_field(i-1,k,j)*vel-0.083333333*g_field(i+1,k,j)*vel+&
&0.58333333*g_field(i,k,j)*vel+g_vel*(0.58333333*(field(i,k,j)+field(i-1,k,j))-0.083333333*(field(i+1,k,j)+field(i-2,k,j)))
        fqx(i,k) = vel*(7./12.*(field(i,k,j)+field(i-1,k,j))-1./12.*(field(i+1,k,j)+field(i-2,k,j)))
      end do
    endif
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
else if (horz_order .eq. 5) then horizontal_order_tesu
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-3) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-3) then
    degrade_ye =  .false. 
  endif
  ktf = min(kte,kde-1)
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = max(jts,jds+1)
    j_start_f = jds+3
  endif
  if (degrade_ye) then
    j_end = min(jte,jde-2)
    j_end_f = jde-3
  endif
  jp1 = 2
  jp0 = 1
  j_loop_y_flux_5: do j = j_start, j_end+1
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = rv(i,k,j)

!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
          fqy(i,k,jp1) = vel*(37./60.*(field(i,k,j)+field(i,k,j-1))-2./15.*(field(i,k,j+1)+field(i,k,j-2))+1./60.*(field(i,k,j+2)+&
&field(i,k,j-3))-sign(1.,vel)*(1./60.)*(field(i,k,j+2)-field(i,k,j-3)-5.*(field(i,k,j+1)-field(i,k,j-2))+10.*(field(i,k,&
&j)-field(i,k,j-1))))

          g_fqy(i,k,jp1) = vel*(g_field(i,k,j-3)*(0.016666667-(-0.016666667)*sign(1.,vel))+g_field(i,k,j-2)*((-0.13333333)-&
&0.083333333*sign(1.,vel))+g_field(i,k,j-1)*(0.61666667-(-0.16666667)*sign(1.,vel))+g_field(i,k,j+2)*&
&(0.016666667-0.016666667*sign(1.,vel))+g_field(i,k,j+1)*((-0.13333333)-(-0.083333333)*sign(1.,vel))+g_field(i,k,j)*&
&(0.61666667-0.16666667*sign(1.,vel)))+g_rv(i,k,j)*fqy(i,k,jp1)/vel

else
          fqy(i,k,jp1) = 0.
          g_fqy(i,k,jp1) = g_rv(i,k,j)*(37./60.*(field(i,k,j)+field(i,k,j-1))&
&-2./15.*(field(i,k,j+1)+field(i,k,j-2))+1./60.*(field(i,k,j+2)+&
&field(i,k,j-3))-sign(1.,vel)*(1./60.)*(field(i,k,j+2)-field(i,k,j-3)-5.*(field(i,k,j+1)-field(i,k,j-2))+10.*(field(i,k,&
&j)-field(i,k,j-1))))

end if
        end do
      end do
    else if (j .eq. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.5*g_field(i,k,j-1)*rv(i,k,j)+0.5*g_field(i,k,j)*rv(i,k,j)+0.5*g_rv(i,k,j)*(field(i,k,j)+field(i,k,j-1))
          fqy(i,k,jp1) = 0.5*rv(i,k,j)*(field(i,k,j)+field(i,k,j-1))
        end do
      end do
    else if (j .eq. jds+2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = rv(i,k,j)
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
          fqy(i,k,jp1) = vel*(7./12.*(field(i,k,j)+field(i,k,j-1))-1./12.*(field(i,k,j+1)+field(i,k,j-2))+sign(1.,vel)*(1./12.)*&
&(field(i,k,j+1)-field(i,k,j-2)-3.*(field(i,k,j)-field(i,k,j-1))))
          g_fqy(i,k,jp1) = vel*(g_field(i,k,j-2)*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_field(i,k,j-1)*(0.58333333+0.25*&
&sign(1.,vel))+g_field(i,k,j+1)*((-0.083333333)+0.083333333*sign(1.,vel))+g_field(i,k,j)*(0.58333333+(-0.25)*&
&sign(1.,vel)))+g_rv(i,k,j)*fqy(i,k,jp1)/vel
else
  fqy(i,k,jp1) =0.
  g_fqy(i,k,jp1) =g_rv(i,k,j)*(7./12.*(field(i,k,j)+field(i,k,j-1))-1./12.*(field(i,k,j+1)+field(i,k,j-2))+sign(1.,vel)*(1./12.)*&
&(field(i,k,j+1)-field(i,k,j-2)-3.*(field(i,k,j)-field(i,k,j-1))))
end if
        end do
      end do
    else if (j .eq. jde-1) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.5*g_field(i,k,j-1)*rv(i,k,j)+0.5*g_field(i,k,j)*rv(i,k,j)+0.5*g_rv(i,k,j)*(field(i,k,j)+field(i,k,j-1))
          fqy(i,k,jp1) = 0.5*rv(i,k,j)*(field(i,k,j)+field(i,k,j-1))
        end do
      end do
    else if (j .eq. jde-2) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = g_rv(i,k,j)
          vel = rv(i,k,j)
          g_fqy(i,k,jp1) = g_field(i,k,j-2)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_field(i,k,j-1)*vel*(0.58333333+0.25*&
&sign(1.,vel))+g_field(i,k,j+1)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_field(i,k,j)*vel*(0.58333333+(-0.25)*&
&sign(1.,vel))+g_vel*(0.58333333*(field(i,k,j)+field(i,k,j-1))-0.083333333*(field(i,k,j+1)+field(i,k,j-2))+0.083333333*&
&(field(i,k,j+1)-field(i,k,j-2)-3.*(field(i,k,j)-field(i,k,j-1)))*sign(1.,vel))
          fqy(i,k,jp1) = vel*(7./12.*(field(i,k,j)+field(i,k,j-1))-1./12.*(field(i,k,j+1)+field(i,k,j-2))+sign(1.,vel)*(1./12.)*&
&(field(i,k,j+1)-field(i,k,j-2)-3.*(field(i,k,j)-field(i,k,j-1))))
        end do
      end do
    endif
    if (j .gt. j_start) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msft(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do j_loop_y_flux_5
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = i_start+2
  endif
  if (degrade_xe) then
    i_end = min(ide-2,ite)
    i_end_f = ide-3
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start_f, i_end_f
        vel = ru(i,k,j)
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
        fqx(i,k) = vel*(37./60.*(field(i,k,j)+field(i-1,k,j))-2./15.*(field(i+1,k,j)+field(i-2,k,j))+1./60.*(field(i+2,k,j)+&
&field(i-3,k,j))-sign(1.,vel)*(1./60.)*(field(i+2,k,j)-field(i-3,k,j)-5.*(field(i+1,k,j)-field(i-2,k,j))+10.*(field(i,k,j)-&
&field(i-1,k,j))))
        g_fqx(i,k) = g_field(i-3,k,j)*vel*(0.016666667-(-0.016666667)*sign(1.,vel))+g_field(i-2,k,j)*vel*((-0.13333333)-&
&0.083333333*sign(1.,vel))+g_field(i-1,k,j)*vel*(0.61666667-(-0.16666667)*sign(1.,vel))+g_field(i+2,k,j)*vel*(0.016666667-&
&0.016666667*sign(1.,vel))+g_field(i+1,k,j)*vel*((-0.13333333)-(-0.083333333)*sign(1.,vel))+g_field(i,k,j)*vel*(0.61666667-&
&0.16666667*sign(1.,vel))+g_ru(i,k,j)*fqx(i,k)/vel
else
fqx(i,k) =0.
g_fqx(i,k) =g_ru(i,k,j)*(37./60.*(field(i,k,j)+field(i-1,k,j))-2./15.*(field(i+1,k,j)+field(i-2,k,j))+1./60.*(field(i+2,k,j)+&
&field(i-3,k,j))-sign(1.,vel)*(1./60.)*(field(i+2,k,j)-field(i-3,k,j)-5.*(field(i+1,k,j)-field(i-2,k,j))+10.*(field(i,k,j)-&
&field(i-1,k,j))))
endif
      end do
    end do
    if (degrade_xs) then
      if (i_start .eq. ids+1) then
        i = ids+1
        do k = kts, ktf
          g_fqx(i,k) = 0.5*g_field(i-1,k,j)*ru(i,k,j)+0.5*g_field(i,k,j)*ru(i,k,j)+0.5*g_ru(i,k,j)*(field(i,k,j)+field(i-1,k,j))
          fqx(i,k) = 0.5*ru(i,k,j)*(field(i,k,j)+field(i-1,k,j))
        end do
      endif
      i = ids+2
      do k = kts, ktf
        g_vel = g_ru(i,k,j)
        vel = ru(i,k,j)
        g_fqx(i,k) = g_field(i-2,k,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_field(i-1,k,j)*vel*(0.58333333+0.25*&
&sign(1.,vel))+g_field(i+1,k,j)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_field(i,k,j)*vel*(0.58333333+(-0.25)*&
&sign(1.,vel))+g_vel*(0.58333333*(field(i,k,j)+field(i-1,k,j))-0.083333333*(field(i+1,k,j)+field(i-2,k,j))+0.083333333*&
&(field(i+1,k,j)-field(i-2,k,j)-3.*(field(i,k,j)-field(i-1,k,j)))*sign(1.,vel))
        fqx(i,k) = vel*(7./12.*(field(i,k,j)+field(i-1,k,j))-1./12.*(field(i+1,k,j)+field(i-2,k,j))+sign(1.,vel)*(1./12.)*(field(i+&
&1,k,j)-field(i-2,k,j)-3.*(field(i,k,j)-field(i-1,k,j))))
      end do
    endif
    if (degrade_xe) then
      if (i_end .eq. ide-2) then
        i = ide-1
        do k = kts, ktf
          g_fqx(i,k) = 0.5*g_field(i-1,k,j)*ru(i,k,j)+0.5*g_field(i,k,j)*ru(i,k,j)+0.5*g_ru(i,k,j)*(field(i,k,j)+field(i-1,k,j))
          fqx(i,k) = 0.5*ru(i,k,j)*(field(i,k,j)+field(i-1,k,j))
        end do
      endif
      i = ide-2
      do k = kts, ktf
        vel = ru(i,k,j)
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
        fqx(i,k) = vel*(7./12.*(field(i,k,j)+field(i-1,k,j))-1./12.*(field(i+1,k,j)+field(i-2,k,j))+sign(1.,vel)*(1./12.)*(field(i+&
&1,k,j)-field(i-2,k,j)-3.*(field(i,k,j)-field(i-1,k,j))))
        g_fqx(i,k) = g_field(i-2,k,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_field(i-1,k,j)*vel*(0.58333333+0.25*&
&sign(1.,vel))+g_field(i+1,k,j)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_field(i,k,j)*vel*(0.58333333+(-0.25)*&
&sign(1.,vel))+g_ru(i,k,j)*fqx(i,k)/vel
else 
fqx(i,k) =0.
g_fqx(i,k) =g_ru(i,k,j)*(7./12.*(field(i,k,j)+field(i-1,k,j))-1./12.*(field(i+1,k,j)+field(i-2,k,j))+sign(1.,vel)*(1./12.)*(field(i+&
&1,k,j)-field(i-2,k,j)-3.*(field(i,k,j)-field(i-1,k,j))))
end if
      end do
    endif
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
else if (horz_order .eq. 4) then horizontal_order_tesu
  CALL wrf_error_fatal ( ' horz_order == 4 does not pass AD/TL check' )
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
  ktf = min(kte,kde-1)
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
  if (degrade_xe) then
    i_end = ide-2
    i_end_f = ide-2
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start_f, i_end_f
        g_fqx(i,k) = (-0.083333333)*g_field(i-2,k,j)*ru(i,k,j)+0.58333333*g_field(i-1,k,j)*ru(i,k,j)-0.083333333*g_field(i+1,k,j)*&
&ru(i,k,j)+0.58333333*g_field(i,k,j)*ru(i,k,j)+g_ru(i,k,j)*(0.58333333*(field(i,k,j)+field(i-1,k,j))-0.083333333*(field(i+&
&1,k,j)+field(i-2,k,j)))
        fqx(i,k) = ru(i,k,j)*(7./12.*(field(i,k,j)+field(i-1,k,j))-1./12.*(field(i+1,k,j)+field(i-2,k,j)))
      end do
    end do
    if (degrade_xs) then
      do k = kts, ktf
        g_fqx(i_start,k) = 0.5*g_field(i_start-1,k,j)*ru(i_start,k,j)+0.5*g_field(i_start,k,j)*ru(i_start,k,j)+0.5*g_ru(i_start,k,&
&j)*(field(i_start,k,j)+field(i_start-1,k,j))
        fqx(i_start,k) = 0.5*ru(i_start,k,j)*(field(i_start,k,j)+field(i_start-1,k,j))
      end do
    endif
    if (degrade_xe) then
      do k = kts, ktf
        g_fqx(i_end+1,k) = 0.5*g_field(i_end+1,k,j)*ru(i_end+1,k,j)+0.5*g_field(i_end,k,j)*ru(i_end+1,k,j)+0.5*g_ru(i_end+1,k,j)*&
&(field(i_end+1,k,j)+field(i_end,k,j))
        fqx(i_end+1,k) = 0.5*ru(i_end+1,k,j)*(field(i_end+1,k,j)+field(i_end,k,j))
      end do
    endif
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = jds+1
    j_start_f = j_start+1
  endif
  if (degrade_ye) then
    j_end = jde-2
    j_end_f = jde-2
  endif
  jp1 = 2
  jp0 = 1
  do j = j_start, j_end+1
    if (j .lt. j_start_f .and. degrade_ys) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.5*g_field(i,k,j_start-1)*rv(i,k,j_start)+0.5*g_field(i,k,j_start)*rv(i,k,j_start)+0.5*g_rv(i,k,&
&j_start)*(field(i,k,j_start)+field(i,k,j_start-1))
          fqy(i,k,jp1) = 0.5*rv(i,k,j_start)*(field(i,k,j_start)+field(i,k,j_start-1))
        end do
      end do
    else if (j .gt. j_end_f .and. degrade_ye) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.5*g_field(i,k,j_end+1)*rv(i,k,j_end+1)+0.5*g_field(i,k,j_end)*rv(i,k,j_end+1)+0.5*g_rv(i,k,j_end+1)*&
&(field(i,k,j_end+1)+field(i,k,j_end))
          fqy(i,k,jp1) = 0.5*rv(i,k,j_end+1)*(field(i,k,j_end+1)+field(i,k,j_end))
        end do
      end do
    else
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = (-0.083333333)*g_field(i,k,j-2)*rv(i,k,j)+0.58333333*g_field(i,k,j-1)*rv(i,k,j)-0.083333333*g_field(i,k,&
&j+1)*rv(i,k,j)+0.58333333*g_field(i,k,j)*rv(i,k,j)+g_rv(i,k,j)*(0.58333333*(field(i,k,j)+field(i,k,j-1))-0.083333333*&
&(field(i,k,j+1)+field(i,k,j-2)))
          fqy(i,k,jp1) = rv(i,k,j)*(7./12.*(field(i,k,j)+field(i,k,j-1))-1./12.*(field(i,k,j+1)+field(i,k,j-2)))
        end do
      end do
    endif
    if (j .gt. j_start) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msft(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do
else if (horz_order .eq. 3) then horizontal_order_tesu
  CALL wrf_error_fatal ( ' horz_order == 3 does not pass AD/TL check' )
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
  ktf = min(kte,kde-1)
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
  if (degrade_xe) then
    i_end = ide-2
    i_end_f = ide-2
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start_f, i_end_f
        g_fqx(i,k) = g_field(i-2,k,j)*ru(i,k,j)*((-0.083333333)+(-0.083333333)*sign(1.,ru(i,k,j)))+g_field(i-1,k,j)*ru(i,k,j)*&
&(0.58333333+0.25*sign(1.,ru(i,k,j)))+g_field(i+1,k,j)*ru(i,k,j)*((-0.083333333)+0.083333333*sign(1.,ru(i,k,j)))+g_field(i,&
&k,j)*ru(i,k,j)*(0.58333333+(-0.25)*sign(1.,ru(i,k,j)))+g_ru(i,k,j)*(0.58333333*(field(i,k,j)+field(i-1,k,j))-0.083333333*&
&(field(i+1,k,j)+field(i-2,k,j))+0.083333333*(field(i+1,k,j)-field(i-2,k,j)-3.*(field(i,k,j)-field(i-1,k,j)))*sign(1.,ru(i,k,j)))
        fqx(i,k) = ru(i,k,j)*(7./12.*(field(i,k,j)+field(i-1,k,j))-1./12.*(field(i+1,k,j)+field(i-2,k,j))+sign(1.,ru(i,k,j))*(1./&
&12.)*(field(i+1,k,j)-field(i-2,k,j)-3.*(field(i,k,j)-field(i-1,k,j))))
      end do
    end do
    if (degrade_xs) then
      do k = kts, ktf
        g_fqx(i_start,k) = 0.5*g_field(i_start-1,k,j)*ru(i_start,k,j)+0.5*g_field(i_start,k,j)*ru(i_start,k,j)+0.5*g_ru(i_start,k,&
&j)*(field(i_start,k,j)+field(i_start-1,k,j))
        fqx(i_start,k) = 0.5*ru(i_start,k,j)*(field(i_start,k,j)+field(i_start-1,k,j))
      end do
    endif
    if (degrade_xe) then
      do k = kts, ktf
        g_fqx(i_end+1,k) = 0.5*g_field(i_end+1,k,j)*ru(i_end+1,k,j)+0.5*g_field(i_end,k,j)*ru(i_end+1,k,j)+0.5*g_ru(i_end+1,k,j)*&
&(field(i_end+1,k,j)+field(i_end,k,j))
        fqx(i_end+1,k) = 0.5*ru(i_end+1,k,j)*(field(i_end+1,k,j)+field(i_end,k,j))
      end do
    endif
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = jds+1
    j_start_f = j_start+1
  endif
  if (degrade_ye) then
    j_end = jde-2
    j_end_f = jde-2
  endif
  jp1 = 2
  jp0 = 1
  do j = j_start, j_end+1
    if (j .lt. j_start_f .and. degrade_ys) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.5*g_field(i,k,j_start-1)*rv(i,k,j_start)+0.5*g_field(i,k,j_start)*rv(i,k,j_start)+0.5*g_rv(i,k,&
&j_start)*(field(i,k,j_start)+field(i,k,j_start-1))
          fqy(i,k,jp1) = 0.5*rv(i,k,j_start)*(field(i,k,j_start)+field(i,k,j_start-1))
        end do
      end do
    else if (j .gt. j_end_f .and. degrade_ye) then
      do k = kts, ktf
        do i = i_start, i_end
  g_fqy(i,k,jp1) = 0.5*g_field(i,k,j_end+1)*rv(i,k,j_end+1)+0.5*g_field(i,k,j_end)*rv(i,k,j_end+1)+0.5*g_rv(i,k,j_end+1)*&
&(field(i,k,j_end+1)+field(i,k,j_end))
          fqy(i,k,jp1) = 0.5*rv(i,k,j_end+1)*(field(i,k,j_end+1)+field(i,k,j_end))
        end do
      end do
    else
      do k = kts, ktf
        do i = i_start, i_end
g_fqy(i,k,jp1) = g_field(i,k,j-2)*rv(i,k,j)*((-0.083333333)+(-0.083333333)*sign(1.,rv(i,k,j)))+g_field(i,k,j-1)*rv(i,k,j)&
&*(0.58333333+0.25*sign(1.,rv(i,k,j)))+g_field(i,k,j+1)*rv(i,k,j)*((-0.083333333)+0.083333333*sign(1.,rv(i,k,j)))+&
&g_field(i,k,j)*rv(i,k,j)*(0.58333333+(-0.25)*sign(1.,rv(i,k,j)))+g_rv(i,k,j)*(0.58333333*(field(i,k,j)+field(i,k,j-1))-&
&0.083333333*(field(i,k,j+1)+field(i,k,j-2))+0.083333333*(field(i,k,j+1)-field(i,k,j-2)-3.*(field(i,k,j)-field(i,k,j-1)))&
&*sign(1.,rv(i,k,j)))
fqy(i,k,jp1) = rv(i,k,j)*(7./12.*(field(i,k,j)+field(i,k,j-1))-1./12.*(field(i,k,j+1)+field(i,k,j-2))+sign(1.,rv(i,k,j))*&
&(1./12.)*(field(i,k,j+1)-field(i,k,j-2)-3.*(field(i,k,j)-field(i,k,j-1))))
        end do
      end do
    endif
    if (j .gt. j_start) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msft(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do
else if (horz_order .eq. 2) then horizontal_order_tesu
  CALL wrf_error_fatal ( ' horz_order == 2 does not pass AD/TL check' )
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-2,ite)
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
        g_tendency(i,k,j) = 0.5*g_field(i-1,k,j)*mrdx*ru(i,k,j)-0.5*g_field(i+1,k,j)*mrdx*ru(i+1,k,j)-0.5*g_field(i,k,j)*mrdx*&
&(ru(i+1,k,j)-ru(i,k,j))-0.5*g_ru(i+1,k,j)*mrdx*(field(i+1,k,j)+field(i,k,j))+0.5*g_ru(i,k,j)*mrdx*(field(i,k,j)+field(i-1,&
&k,j))+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*0.5*(ru(i+1,k,j)*(field(i+1,k,j)+field(i,k,j))-ru(i,k,j)*(field(i,k,j)+field(i-1,k,&
&j)))
      end do
    end do
  end do
  i_start = its
  i_end = min(ite,ide-1)
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-2,jte)
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdy = msft(i,j)*rdy
        g_tendency(i,k,j) = 0.5*g_field(i,k,j-1)*mrdy*rv(i,k,j)-0.5*g_field(i,k,j+1)*mrdy*rv(i,k,j+1)-0.5*g_field(i,k,j)*mrdy*&
&(rv(i,k,j+1)-rv(i,k,j))-0.5*g_rv(i,k,j+1)*mrdy*(field(i,k,j+1)+field(i,k,j))+0.5*g_rv(i,k,j)*mrdy*(field(i,k,j)+field(i,k,&
&j-1))+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdy*0.5*(rv(i,k,j+1)*(field(i,k,j+1)+field(i,k,j))-rv(i,k,j)*(field(i,k,j)+field(i,k,j-&
&1)))
      end do
    end do
  end do
else horizontal_order_tesu
  write(unit=wrf_err_message,fmt=*) 'module_advect: advect_scalar_6a, h_order not known ',horz_order
endif horizontal_order_tesu
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
if (config_flags%open_xs .and. its .eq. ids) then
  CALL wrf_error_fatal ( ' open_xs == true does not pass AD/TL check' )
  do j = j_start, j_end
    do k = kts, ktf
      g_ub = 0.5*g_ru(its+1,k,j)*(0.5+sign(0.5,0.-0.5*(ru(its,k,j)+ru(its+1,k,j))))+0.5*g_ru(its,k,j)*(0.5+sign(0.5,0.-0.5*(ru(its,&
&k,j)+ru(its+1,k,j))))
      ub = min(0.5*(ru(its,k,j)+ru(its+1,k,j)),0.)
      g_tendency(its,k,j) = (-(g_field(its,k,j)*rdx*(ru(its+1,k,j)-ru(its,k,j))))-g_field_old(its+1,k,j)*rdx*ub+g_field_old(its,k,&
&j)*rdx*ub-g_ru(its+1,k,j)*rdx*field(its,k,j)+g_ru(its,k,j)*rdx*field(its,k,j)+g_tendency(its,k,j)-g_ub*rdx*(field_old(its+1,&
&k,j)-field_old(its,k,j))
      tendency(its,k,j) = tendency(its,k,j)-rdx*(ub*(field_old(its+1,k,j)-field_old(its,k,j))+field(its,k,j)*(ru(its+1,k,j)-ru(its,&
&k,j)))
    end do
  end do
endif
if (config_flags%open_xe .and. ite .eq. ide) then
  CALL wrf_error_fatal ( ' open_xe == true does not pass AD/TL check' )
  do j = j_start, j_end
    do k = kts, ktf
      g_ub = 0.5*g_ru(ite-1,k,j)*(0.5+sign(0.5,0.5*(ru(ite-1,k,j)+ru(ite,k,j))-0.))+0.5*g_ru(ite,k,j)*(0.5+sign(0.5,0.5*(ru(ite-1,&
&k,j)+ru(ite,k,j))-0.))
      ub = max(0.5*(ru(ite-1,k,j)+ru(ite,k,j)),0.)
      g_tendency(i_end,k,j) = (-(g_field(i_end,k,j)*rdx*(ru(ite,k,j)-ru(ite-1,k,j))))+g_field_old(i_end-1,k,j)*rdx*ub-&
&g_field_old(i_end,k,j)*rdx*ub+g_ru(ite-1,k,j)*rdx*field(i_end,k,j)-g_ru(ite,k,j)*rdx*field(i_end,k,j)+g_tendency(i_end,k,j)-&
&g_ub*rdx*(field_old(i_end,k,j)-field_old(i_end-1,k,j))
      tendency(i_end,k,j) = tendency(i_end,k,j)-rdx*(ub*(field_old(i_end,k,j)-field_old(i_end-1,k,j))+field(i_end,k,j)*(ru(ite,k,j)&
&-ru(ite-1,k,j)))
    end do
  end do
endif
if (config_flags%open_ys .and. jts .eq. jds) then
  CALL wrf_error_fatal ( ' open_ys == true does not pass AD/TL check' )
  do i = i_start, i_end
    do k = kts, ktf
      g_vb = 0.5*g_rv(i,k,jts+1)*(0.5+sign(0.5,0.-0.5*(rv(i,k,jts)+rv(i,k,jts+1))))+0.5*g_rv(i,k,jts)*(0.5+sign(0.5,0.-0.5*(rv(i,k,&
&jts)+rv(i,k,jts+1))))
      vb = min(0.5*(rv(i,k,jts)+rv(i,k,jts+1)),0.)
      g_tendency(i,k,jts) = (-(g_field(i,k,jts)*rdy*(rv(i,k,jts+1)-rv(i,k,jts))))-g_field_old(i,k,jts+1)*rdy*vb+g_field_old(i,k,&
&jts)*rdy*vb-g_rv(i,k,jts+1)*rdy*field(i,k,jts)+g_rv(i,k,jts)*rdy*field(i,k,jts)+g_tendency(i,k,jts)-g_vb*rdy*(field_old(i,k,&
&jts+1)-field_old(i,k,jts))
      tendency(i,k,jts) = tendency(i,k,jts)-rdy*(vb*(field_old(i,k,jts+1)-field_old(i,k,jts))+field(i,k,jts)*(rv(i,k,jts+1)-rv(i,k,&
&jts)))
    end do
  end do
endif
if (config_flags%open_ye .and. jte .eq. jde) then
  CALL wrf_error_fatal ( ' open_ye == true does not pass AD/TL check' )
  do i = i_start, i_end
    do k = kts, ktf
      g_vb = 0.5*g_rv(i,k,jte-1)*(0.5+sign(0.5,0.5*(rv(i,k,jte-1)+rv(i,k,jte))-0.))+0.5*g_rv(i,k,jte)*(0.5+sign(0.5,0.5*(rv(i,k,&
&jte-1)+rv(i,k,jte))-0.))
      vb = max(0.5*(rv(i,k,jte-1)+rv(i,k,jte)),0.)
      g_tendency(i,k,j_end) = (-(g_field(i,k,j_end)*rdy*(rv(i,k,jte)-rv(i,k,jte-1))))+g_field_old(i,k,j_end-1)*rdy*vb-&
&g_field_old(i,k,j_end)*rdy*vb+g_rv(i,k,jte-1)*rdy*field(i,k,j_end)-g_rv(i,k,jte)*rdy*field(i,k,j_end)+g_tendency(i,k,j_end)-&
&g_vb*rdy*(field_old(i,k,j_end)-field_old(i,k,j_end-1))
      tendency(i,k,j_end) = tendency(i,k,j_end)-rdy*(vb*(field_old(i,k,j_end)-field_old(i,k,j_end-1))+field(i,k,j_end)*(rv(i,k,jte)&
&-rv(i,k,jte-1)))
    end do
  end do
endif
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
do i = i_start, i_end
  g_vflux(i,kts) = 0.
  vflux(i,kts) = 0.
  g_vflux(i,kte) = 0.
  vflux(i,kte) = 0.
end do
vert_order_tesu: if (vert_order .eq. 6) then
  CALL wrf_error_fatal ( ' vert_order == 6 does not pass AD/TL check' )
  do j = j_start, j_end
    do k = kts+3, ktf-2
      do i = i_start, i_end
        g_vel = g_rom(i,k,j)
        vel = rom(i,k,j)
        g_vflux(i,k) = 0.016666667*g_field(i,k-3,j)*vel-0.13333333*g_field(i,k-2,j)*vel+0.61666667*g_field(i,k-1,j)*vel+&
&0.016666667*g_field(i,k+2,j)*vel-0.13333333*g_field(i,k+1,j)*vel+0.61666667*g_field(i,k,j)*vel+g_vel*(0.61666667*(field(i,&
&k,j)+field(i,k-1,j))-0.13333333*(field(i,k+1,j)+field(i,k-2,j))+0.016666667*(field(i,k+2,j)+field(i,k-3,j)))
        vflux(i,k) = vel*(37./60.*(field(i,k,j)+field(i,k-1,j))-2./15.*(field(i,k+1,j)+field(i,k-2,j))+1./60.*(field(i,k+2,j)+&
&field(i,k-3,j)))
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = g_field(i,k-1,j)*rom(i,k,j)*fzp(k)+g_field(i,k,j)*rom(i,k,j)*fzm(k)+g_rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*&
&field(i,k-1,j))
      vflux(i,k) = rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*field(i,k-1,j))
      k = kts+2
      g_vel = g_rom(i,k,j)
      vel = rom(i,k,j)
      g_vflux(i,k) = (-0.083333333)*g_field(i,k-2,j)*vel+0.58333333*g_field(i,k-1,j)*vel-0.083333333*g_field(i,k+1,j)*vel+&
&0.58333333*g_field(i,k,j)*vel+g_vel*(0.58333333*(field(i,k,j)+field(i,k-1,j))-0.083333333*(field(i,k+1,j)+field(i,k-2,j)))
      vflux(i,k) = vel*(7./12.*(field(i,k,j)+field(i,k-1,j))-1./12.*(field(i,k+1,j)+field(i,k-2,j)))
      k = ktf-1
      g_vel = g_rom(i,k,j)
      vel = rom(i,k,j)
      g_vflux(i,k) = (-0.083333333)*g_field(i,k-2,j)*vel+0.58333333*g_field(i,k-1,j)*vel-0.083333333*g_field(i,k+1,j)*vel+&
&0.58333333*g_field(i,k,j)*vel+g_vel*(0.58333333*(field(i,k,j)+field(i,k-1,j))-0.083333333*(field(i,k+1,j)+field(i,k-2,j)))
      vflux(i,k) = vel*(7./12.*(field(i,k,j)+field(i,k-1,j))-1./12.*(field(i,k+1,j)+field(i,k-2,j)))
      k = ktf
      g_vflux(i,k) = g_field(i,k-1,j)*rom(i,k,j)*fzp(k)+g_field(i,k,j)*rom(i,k,j)*fzm(k)+g_rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*&
&field(i,k-1,j))
      vflux(i,k) = rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*field(i,k-1,j))
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else if (vert_order .eq. 5) then vert_order_tesu
  CALL wrf_error_fatal ( ' vert_order == 5 does not pass AD/TL check' )
  do j = j_start, j_end
    do k = kts+3, ktf-2
      do i = i_start, i_end
        g_vel = g_rom(i,k,j)
        vel = rom(i,k,j)
        g_vflux(i,k) = g_field(i,k-3,j)*vel*(0.016666667-(-0.016666667)*sign(1.,-vel))+g_field(i,k-2,j)*vel*((-0.13333333)-&
&0.083333333*sign(1.,-vel))+g_field(i,k-1,j)*vel*(0.61666667-(-0.16666667)*sign(1.,-vel))+g_field(i,k+2,j)*vel*&
&(0.016666667-0.016666667*sign(1.,-vel))+g_field(i,k+1,j)*vel*((-0.13333333)-(-0.083333333)*sign(1.,-vel))+g_field(i,k,j)*&
&vel*(0.61666667-0.16666667*sign(1.,-vel))+g_vel*(0.61666667*(field(i,k,j)+field(i,k-1,j))-0.13333333*(field(i,k+1,j)+&
&field(i,k-2,j))+0.016666667*(field(i,k+2,j)+field(i,k-3,j))-0.016666667*(field(i,k+2,j)-field(i,k-3,j)-5.*(field(i,k+1,j)-&
&field(i,k-2,j))+10.*(field(i,k,j)-field(i,k-1,j)))*sign(1.,-vel))
        vflux(i,k) = vel*(37./60.*(field(i,k,j)+field(i,k-1,j))-2./15.*(field(i,k+1,j)+field(i,k-2,j))+1./60.*(field(i,k+2,j)+&
&field(i,k-3,j))-sign(1.,-vel)*(1./60.)*(field(i,k+2,j)-field(i,k-3,j)-5.*(field(i,k+1,j)-field(i,k-2,j))+10.*(field(i,k,j)&
&-field(i,k-1,j))))
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = g_field(i,k-1,j)*rom(i,k,j)*fzp(k)+g_field(i,k,j)*rom(i,k,j)*fzm(k)+g_rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*&
&field(i,k-1,j))
      vflux(i,k) = rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*field(i,k-1,j))
      k = kts+2
      g_vel = g_rom(i,k,j)
      vel = rom(i,k,j)
      g_vflux(i,k) = g_field(i,k-2,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,-vel))+g_field(i,k-1,j)*vel*(0.58333333+0.25*&
&sign(1.,-vel))+g_field(i,k+1,j)*vel*((-0.083333333)+0.083333333*sign(1.,-vel))+g_field(i,k,j)*vel*(0.58333333+(-0.25)*&
&sign(1.,-vel))+g_vel*(0.58333333*(field(i,k,j)+field(i,k-1,j))-0.083333333*(field(i,k+1,j)+field(i,k-2,j))+0.083333333*&
&(field(i,k+1,j)-field(i,k-2,j)-3.*(field(i,k,j)-field(i,k-1,j)))*sign(1.,-vel))
      vflux(i,k) = vel*(7./12.*(field(i,k,j)+field(i,k-1,j))-1./12.*(field(i,k+1,j)+field(i,k-2,j))+sign(1.,-vel)*(1./12.)*&
&(field(i,k+1,j)-field(i,k-2,j)-3.*(field(i,k,j)-field(i,k-1,j))))
      k = ktf-1
      g_vel = g_rom(i,k,j)
      vel = rom(i,k,j)
      g_vflux(i,k) = g_field(i,k-2,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,-vel))+g_field(i,k-1,j)*vel*(0.58333333+0.25*&
&sign(1.,-vel))+g_field(i,k+1,j)*vel*((-0.083333333)+0.083333333*sign(1.,-vel))+g_field(i,k,j)*vel*(0.58333333+(-0.25)*&
&sign(1.,-vel))+g_vel*(0.58333333*(field(i,k,j)+field(i,k-1,j))-0.083333333*(field(i,k+1,j)+field(i,k-2,j))+0.083333333*&
&(field(i,k+1,j)-field(i,k-2,j)-3.*(field(i,k,j)-field(i,k-1,j)))*sign(1.,-vel))
      vflux(i,k) = vel*(7./12.*(field(i,k,j)+field(i,k-1,j))-1./12.*(field(i,k+1,j)+field(i,k-2,j))+sign(1.,-vel)*(1./12.)*&
&(field(i,k+1,j)-field(i,k-2,j)-3.*(field(i,k,j)-field(i,k-1,j))))
      k = ktf
  g_vflux(i,k) = g_field(i,k-1,j)*rom(i,k,j)*fzp(k)+g_field(i,k,j)*rom(i,k,j)*fzm(k)+g_rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*&
&field(i,k-1,j))
      vflux(i,k) = rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*field(i,k-1,j))
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else if (vert_order .eq. 4) then vert_order_tesu
  CALL wrf_error_fatal ( ' vert_order == 4 does not pass AD/TL check' )
  do j = j_start, j_end
    do k = kts+2, ktf-1
      do i = i_start, i_end
        g_vel = g_rom(i,k,j)
        vel = rom(i,k,j)
        g_vflux(i,k) = (-0.083333333)*g_field(i,k-2,j)*vel+0.58333333*g_field(i,k-1,j)*vel-0.083333333*g_field(i,k+1,j)*vel+&
&0.58333333*g_field(i,k,j)*vel+g_vel*(0.58333333*(field(i,k,j)+field(i,k-1,j))-0.083333333*(field(i,k+1,j)+field(i,k-2,j)))
        vflux(i,k) = vel*(7./12.*(field(i,k,j)+field(i,k-1,j))-1./12.*(field(i,k+1,j)+field(i,k-2,j)))
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = g_field(i,k-1,j)*rom(i,k,j)*fzp(k)+g_field(i,k,j)*rom(i,k,j)*fzm(k)+g_rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*&
&field(i,k-1,j))
      vflux(i,k) = rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*field(i,k-1,j))
      k = ktf
      g_vflux(i,k) = g_field(i,k-1,j)*rom(i,k,j)*fzp(k)+g_field(i,k,j)*rom(i,k,j)*fzm(k)+g_rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*&
&field(i,k-1,j))
      vflux(i,k) = rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*field(i,k-1,j))
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else if (vert_order .eq. 3) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+2, ktf-1
      do i = i_start, i_end
        vel = rom(i,k,j)
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
        vflux(i,k) = vel*(7./12.*(field(i,k,j)+field(i,k-1,j))-1./12.*(field(i,k+1,j)+field(i,k-2,j))+sign(1.,-vel)*(1./12.)*&
&(field(i,k+1,j)-field(i,k-2,j)-3.*(field(i,k,j)-field(i,k-1,j))))
        g_vflux(i,k) = vel*(g_field(i,k-2,j)*((-0.083333333)+(-0.083333333)*sign(1.,-vel))+g_field(i,k-1,j)*(0.58333333+0.25*&
&sign(1.,-vel))+g_field(i,k+1,j)*((-0.083333333)+0.083333333*sign(1.,-vel))+g_field(i,k,j)*(0.58333333+(-0.25)*&
&sign(1.,-vel)))+g_rom(i,k,j)*vflux(i,k)/vel
else
        vflux(i,k)=0.
g_vflux(i,k) =g_rom(i,k,j)*(7./12.*(field(i,k,j)+field(i,k-1,j))-1./12.*(field(i,k+1,j)+field(i,k-2,j))+sign(1.,-vel)*(1./12.)*&
&(field(i,k+1,j)-field(i,k-2,j)-3.*(field(i,k,j)-field(i,k-1,j))))
endif
      end do
    end do
    do i = i_start, i_end
      k = kts+1
    g_vflux(i,k) = g_field(i,k-1,j)*rom(i,k,j)*fzp(k)+g_field(i,k,j)*rom(i,k,j)*fzm(k)+g_rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*&
&field(i,k-1,j))
      vflux(i,k) = rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*field(i,k-1,j))
      k = ktf
    g_vflux(i,k) = g_field(i,k-1,j)*rom(i,k,j)*fzp(k)+g_field(i,k,j)*rom(i,k,j)*fzm(k)+g_rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*&
&field(i,k-1,j))
      vflux(i,k) = rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*field(i,k-1,j))
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else if (vert_order .eq. 2) then vert_order_tesu
  CALL wrf_error_fatal ( ' vert_order == 2 does not pass AD/TL check' )
  do j = j_start, j_end
    do k = kts+1, ktf
      do i = i_start, i_end
        g_vflux(i,k) = g_field(i,k-1,j)*rom(i,k,j)*fzp(k)+g_field(i,k,j)*rom(i,k,j)*fzm(k)+g_rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)&
&*field(i,k-1,j))
        vflux(i,k) = rom(i,k,j)*(fzm(k)*field(i,k,j)+fzp(k)*field(i,k-1,j))
      end do
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else vert_order_tesu
  write(unit=wrf_err_message,fmt=*) ' advect_scalar_6a, v_order not known ',vert_order
endif vert_order_tesu

   call trace_exit("g_advect_scalar")

end subroutine g_advect_scalar


subroutine g_advect_u( u, g_u, u_old, g_u_old, tendency, g_tendency, ru, g_ru, rv, g_rv, rom, g_rom, mut, g_mut, config_flags, &
&msfu, fzm, fzp, rdx, rdy, rdzw, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_mut(ims:ime,jms:jme)
real, intent(in) :: g_rom(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u_old(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: rdzw(kms:kme)
real, intent(in) :: rom(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u_old(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
logical degrade_xe
logical degrade_xs
logical degrade_ye
logical degrade_ys
real dvm
real dvp
real fqx(its-1:ite+1,kts:kte)
real fqy(its:ite,kts:kte,2)
real g_dvm
real g_dvp
real g_fqx(its-1:ite+1,kts:kte)
real g_fqy(its:ite,kts:kte,2)
real g_ub
real g_vb
real g_vel
real g_vflux(its:ite,kts:kte)
real g_vw
integer horz_order
integer i
integer i_end
integer i_end_f
integer i_start
integer i_start_f
integer im
integer imax
integer imin
integer ip
integer j
integer j_end
integer j_end_f
integer j_start
integer j_start_f
integer jp0
integer jp1
integer jtmp
integer k
integer ktf
real mrdx
real mrdy
logical specified
real ub
real vb
real vel
integer vert_order
real vflux(its:ite,kts:kte)
real vw
real walls(4)

   call trace_entry("g_advect_u")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
horz_order = config_flags%h_mom_adv_order
vert_order = config_flags%v_mom_adv_order
ktf = min(kte,kde-1)
horizontal_order_tesu: if (horz_order .eq. 6) then
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-3) then
    degrade_ye =  .false. 
  endif
  i_start = its
  i_end = ite
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-1,ite)
  endif
  j_start = jts
  j_end = min(jte,jde-1)
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = max(jts,jds+1)
    j_start_f = jds+3
  endif
  if (degrade_ye) then
    j_end = min(jte,jde-2)
    j_end_f = jde-3
  endif
  jp1 = 2
  jp0 = 1
  j_loop_y_flux_6: do j = j_start, j_end+1
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = 0.5*(g_rv(i-1,k,j)+g_rv(i,k,j))
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))

          walls(1)=0.61666667*(u(i,k,j)+u(i,k,j-1))
          walls(2)=0.13333333*(u(i,k,j+1)+u(i,k,j-2))
          walls(3)=0.016666667*(u(i,k,j+2)+u(i,k,j-3))

          g_fqy(i,k,jp1) = 0.016666667*g_u(i,k,j-3)*vel-0.13333333*g_u(i,k,j-2)*vel+0.61666667*g_u(i,k,j-1)*vel+0.016666667*g_u(i,&
&k,j+2)*vel-0.13333333*g_u(i,k,j+1)*vel+0.61666667*g_u(i,k,j)*vel+g_vel*(walls(1)-walls(2)+walls(3))
          fqy(i,k,jp1) = vel*(walls(1)-walls(2)+walls(3))
        end do
      end do
    else if (j .eq. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.25*g_rv(i-1,k,j)*(u(i,k,j)+u(i,k,j-1))+0.25*g_rv(i,k,j)*(u(i,k,j)+u(i,k,j-1))+0.25*g_u(i,k,j-1)*(rv(i,&
&k,j)+rv(i-1,k,j))+0.25*g_u(i,k,j)*(rv(i,k,j)+rv(i-1,k,j))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j)+rv(i-1,k,j))*(u(i,k,j)+u(i,k,j-1))
        end do
      end do
    else if (j .eq. jds+2) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = 0.5*g_rv(i-1,k,j)+0.5*g_rv(i,k,j)
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
          g_fqy(i,k,jp1) = (-0.083333333)*g_u(i,k,j-2)*vel+0.58333333*g_u(i,k,j-1)*vel-0.083333333*g_u(i,k,j+1)*vel+0.58333333*&
&g_u(i,k,j)*vel+g_vel*(0.58333333*(u(i,k,j)+u(i,k,j-1))-0.083333333*(u(i,k,j+1)+u(i,k,j-2)))
          fqy(i,k,jp1) = vel*(7./12.*(u(i,k,j)+u(i,k,j-1))-1./12.*(u(i,k,j+1)+u(i,k,j-2)))
        end do
      end do
    else if (j .eq. jde-1) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.25*g_rv(i-1,k,j)*(u(i,k,j)+u(i,k,j-1))+0.25*g_rv(i,k,j)*(u(i,k,j)+u(i,k,j-1))+0.25*g_u(i,k,j-1)*(rv(i,&
&k,j)+rv(i-1,k,j))+0.25*g_u(i,k,j)*(rv(i,k,j)+rv(i-1,k,j))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j)+rv(i-1,k,j))*(u(i,k,j)+u(i,k,j-1))
        end do
      end do
    else if (j .eq. jde-2) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = 0.5*g_rv(i-1,k,j)+0.5*g_rv(i,k,j)
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
          g_fqy(i,k,jp1) = (-0.083333333)*g_u(i,k,j-2)*vel+0.58333333*g_u(i,k,j-1)*vel-0.083333333*g_u(i,k,j+1)*vel+0.58333333*&
&g_u(i,k,j)*vel+g_vel*(0.58333333*(u(i,k,j)+u(i,k,j-1))-0.083333333*(u(i,k,j+1)+u(i,k,j-2)))
          fqy(i,k,jp1) = vel*(7./12.*(u(i,k,j)+u(i,k,j-1))-1./12.*(u(i,k,j+1)+u(i,k,j-2)))
        end do
      end do
    endif
    if (j .gt. j_start) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfu(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do j_loop_y_flux_6
  i_start = its
  i_end = ite
  j_start = jts
  j_end = min(jte,jde-1)
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = ids+3
  endif
  if (degrade_xe) then
    i_end = min(ide-1,ite)
    i_end_f = ide-2
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start_f, i_end_f
        g_vel = 0.5*g_ru(i-1,k,j)+0.5*g_ru(i,k,j)
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
        g_fqx(i,k) = 0.016666667*g_u(i-3,k,j)*vel-0.13333333*g_u(i-2,k,j)*vel+0.61666667*g_u(i-1,k,j)*vel+0.016666667*g_u(i+2,k,j)*&
&vel-0.13333333*g_u(i+1,k,j)*vel+0.61666667*g_u(i,k,j)*vel+g_vel*(0.61666667*(u(i,k,j)+u(i-1,k,j))-0.13333333*(u(i+1,k,j)+&
&u(i-2,k,j))+0.016666667*(u(i+2,k,j)+u(i-3,k,j)))
        fqx(i,k) = vel*(37./60.*(u(i,k,j)+u(i-1,k,j))-2./15.*(u(i+1,k,j)+u(i-2,k,j))+1./60.*(u(i+2,k,j)+u(i-3,k,j)))
      end do
    end do
    if (degrade_xs) then
      if (i_start .eq. ids+1) then
        i = ids+1
        do k = kts, ktf
          g_ub = g_u(i-1,k,j)
          ub = u(i-1,k,j)
          if (specified .and. u(i,k,j) .lt. 0.) then
            g_ub = g_u(i,k,j)
            ub = u(i,k,j)
          endif
          g_fqx(i,k) = 0.25*g_ru(i-1,k,j)*(u(i,k,j)+ub)+0.25*g_ru(i,k,j)*(u(i,k,j)+ub)+0.25*g_u(i,k,j)*(ru(i,k,j)+ru(i-1,k,j))+&
&0.25*g_ub*(ru(i,k,j)+ru(i-1,k,j))
          fqx(i,k) = 0.25*(ru(i,k,j)+ru(i-1,k,j))*(u(i,k,j)+ub)
        end do
      endif
      i = ids+2
      do k = kts, ktf
        g_vel = 0.5*g_ru(i-1,k,j)+0.5*g_ru(i,k,j)
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
        g_fqx(i,k) = (-0.083333333)*g_u(i-2,k,j)*vel+0.58333333*g_u(i-1,k,j)*vel-0.083333333*g_u(i+1,k,j)*vel+0.58333333*g_u(i,k,j)&
&*vel+g_vel*(0.58333333*(u(i,k,j)+u(i-1,k,j))-0.083333333*(u(i+1,k,j)+u(i-2,k,j)))
        fqx(i,k) = vel*(7./12.*(u(i,k,j)+u(i-1,k,j))-1./12.*(u(i+1,k,j)+u(i-2,k,j)))
      end do
    endif
    if (degrade_xe) then
      if (i_end .eq. ide-1) then
        i = ide
        do k = kts, ktf
          g_ub = g_u(i,k,j)
          ub = u(i,k,j)
          if (specified .and. u(i-1,k,j) .gt. 0.) then
            g_ub = g_u(i-1,k,j)
            ub = u(i-1,k,j)
          endif
          g_fqx(i,k) = 0.25*g_ru(i-1,k,j)*(u(i-1,k,j)+ub)+0.25*g_ru(i,k,j)*(u(i-1,k,j)+ub)+0.25*g_u(i-1,k,j)*(ru(i,k,j)+ru(i-1,k,j)&
&)+0.25*g_ub*(ru(i,k,j)+ru(i-1,k,j))
          fqx(i,k) = 0.25*(ru(i,k,j)+ru(i-1,k,j))*(u(i-1,k,j)+ub)
        end do
      endif
      do k = kts, ktf
        i = ide-1
        g_vel = 0.5*g_ru(i-1,k,j)+0.5*g_ru(i,k,j)
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
        g_fqx(i,k) = (-0.083333333)*g_u(i-2,k,j)*vel+0.58333333*g_u(i-1,k,j)*vel-0.083333333*g_u(i+1,k,j)*vel+0.58333333*g_u(i,k,j)&
&*vel+g_vel*(0.58333333*(u(i,k,j)+u(i-1,k,j))-0.083333333*(u(i+1,k,j)+u(i-2,k,j)))
        fqx(i,k) = vel*(7./12.*(u(i,k,j)+u(i-1,k,j))-1./12.*(u(i+1,k,j)+u(i-2,k,j)))
      end do
    endif
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfu(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
else if (horz_order .eq. 5) then horizontal_order_tesu
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-3) then
    degrade_ye =  .false. 
  endif
  i_start = its
  i_end = ite
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-1,ite)
  endif
  j_start = jts
  j_end = min(jte,jde-1)
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = max(jts,jds+1)
    j_start_f = jds+3
  endif
  if (degrade_ye) then
    j_end = min(jte,jde-2)
    j_end_f = jde-3
  endif
  jp1 = 2
  jp0 = 1
  j_loop_y_flux_5: do j = j_start, j_end+1
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
          fqy(i,k,jp1) = vel*(37./60.*(u(i,k,j)+u(i,k,j-1))-2./15.*(u(i,k,j+1)+u(i,k,j-2))+1./60.*(u(i,k,j+2)&
&+u(i,k,j-3))-sign(1.,vel)*(1./60.)*(u(i,k,j+2)-u(i,k,j-3)-5.*(u(i,k,j+1)-u(i,k,j-2))+10.*(u(i,k,j)-u(i,k,j-1))))
          g_fqy(i,k,jp1) = vel*(g_u(i,k,j-3)*(0.016666667&
&-(-0.016666667)*sign(1.,vel))+g_u(i,k,j-2)*((-0.13333333)-0.083333333*&
&sign(1.,vel))+g_u(i,k,j-1)*(0.61666667-(-0.16666667)*sign(1.,vel))+g_u(i,k,j+2)*(0.016666667-0.016666667*&
&sign(1.,vel))+g_u(i,k,j+1)*((-0.13333333)-(-0.083333333)*sign(1.,vel))+g_u(i,k,j)*(0.61666667-0.16666667*&
&sign(1.,vel)))+0.5*(g_rv(i-1,k,j)+g_rv(i,k,j))*fqy(i,k,jp1)/vel
else
fqy(i,k,jp1)=0.
g_fqy(i,k,jp1) =0.5*(g_rv(i-1,k,j)+g_rv(i,k,j))*(37./60.*(u(i,k,j)+u(i,k,j-1))&
&-2./15.*(u(i,k,j+1)+u(i,k,j-2))+1./60.*(u(i,k,j+2)&
&+u(i,k,j-3))-sign(1.,vel)*(1./60.)*(u(i,k,j+2)-u(i,k,j-3)-5.*(u(i,k,j+1)-u(i,k,j-2))+10.*(u(i,k,j)-u(i,k,j-1))))
endif
        end do
      end do
    else if (j .eq. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.25*g_rv(i-1,k,j)*(u(i,k,j)+u(i,k,j-1))+0.25*g_rv(i,k,j)*(u(i,k,j)&
&+u(i,k,j-1))+0.25*g_u(i,k,j-1)*(rv(i,&
&k,j)+rv(i-1,k,j))+0.25*g_u(i,k,j)*(rv(i,k,j)+rv(i-1,k,j))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j)+rv(i-1,k,j))*(u(i,k,j)+u(i,k,j-1))
        end do
      end do
    else if (j .eq. jds+2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
fqy(i,k,jp1) = vel*(7./12.*(u(i,k,j)+u(i,k,j-1))-1./12.*(u(i,k,j+1)+u(i,k,j-2))+sign(1.,vel)*(1./12.)*(u(i,k,j+1)-u(i,k,&
&j-2)-3.*(u(i,k,j)-u(i,k,j-1))))

g_fqy(i,k,jp1) = vel*(g_u(i,k,j-2)*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_u(i,k,j-1)*(0.58333333+0.25*sign(1.,&
&vel))+g_u(i,k,j+1)*((-0.083333333)+0.083333333*sign(1.,vel))+g_u(i,k,j)*(0.58333333+(-0.25)*sign(1.,vel)))&
&+0.5*(g_rv(i-1,k,j)+g_rv(i,k,j))*fqy(i,k,jp1)/vel
else
fqy(i,k,jp1)=0.
g_fqy(i,k,jp1) =0.5*(g_rv(i-1,k,j)+g_rv(i,k,j))*(7./12.*(u(i,k,j)+u(i,k,j-1))-1./12.*(u(i,k,j+1)&
&+u(i,k,j-2))+sign(1.,vel)*(1./12.)*(u(i,k,j+1)-u(i,k,&
&j-2)-3.*(u(i,k,j)-u(i,k,j-1))))
endif
        end do
      end do
    else if (j .eq. jde-1) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.25*g_rv(i-1,k,j)*(u(i,k,j)+u(i,k,j-1))+0.25*g_rv(i,k,j)*(u(i,k,j)&
&+u(i,k,j-1))+0.25*g_u(i,k,j-1)*(rv(i,&
&k,j)+rv(i-1,k,j))+0.25*g_u(i,k,j)*(rv(i,k,j)+rv(i-1,k,j))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j)+rv(i-1,k,j))*(u(i,k,j)+u(i,k,j-1))
        end do
      end do
    else if (j .eq. jde-2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
fqy(i,k,jp1) = vel*(7./12.*(u(i,k,j)+u(i,k,j-1))-1./12.*(u(i,k,j+1)+u(i,k,j-2))+sign(1.,vel)*(1./12.)*(u(i,k,j+1)-u(i,k,&
&j-2)-3.*(u(i,k,j)-u(i,k,j-1))))

g_fqy(i,k,jp1) = vel*(g_u(i,k,j-2)*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_u(i,k,j-1)*(0.58333333+0.25*sign(1.,&
&vel))+g_u(i,k,j+1)*((-0.083333333)+0.083333333*sign(1.,vel))+g_u(i,k,j)*(0.58333333+(-0.25)*sign(1.,vel)))&
&+0.5*(g_rv(i-1,k,j)+g_rv(i,k,j))*fqy(i,k,jp1)/vel
else
fqy(i,k,jp1)=0.
g_fqy(i,k,jp1) =0.5*(g_rv(i-1,k,j)+g_rv(i,k,j))*(7./12.*(u(i,k,j)+u(i,k,j-1))-1./12.*(u(i,k,j+1)+u(i,k,j-2))&
&+sign(1.,vel)*(1./12.)*(u(i,k,j+1)-u(i,k,j-2)-3.*(u(i,k,j)-u(i,k,j-1))))
endif
        end do
      end do
    endif
    if (j .gt. j_start) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfu(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do j_loop_y_flux_5
  i_start = its
  i_end = ite
  j_start = jts
  j_end = min(jte,jde-1)
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = ids+3
  endif
  if (degrade_xe) then
    i_end = min(ide-1,ite)
    i_end_f = ide-2
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start_f, i_end_f
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))

!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
        fqx(i,k) = vel*(37./60.*(u(i,k,j)+u(i-1,k,j))-2./15.*(u(i+1,k,j)+u(i-2,k,j))+1./60.*(u(i+2,k,j)+u(i-3,k,j))-sign(1.,vel)*&
&(1./60.)*(u(i+2,k,j)-u(i-3,k,j)-5.*(u(i+1,k,j)-u(i-2,k,j))+10.*(u(i,k,j)-u(i-1,k,j))))

        g_fqx(i,k) = vel*(g_u(i-3,k,j)*(0.016666667-(-0.016666667)*sign(1.,vel))+g_u(i-2,k,j)*((-0.13333333)-0.083333333*&
&sign(1.,vel))+g_u(i-1,k,j)*(0.61666667-(-0.16666667)*sign(1.,vel))+g_u(i+2,k,j)*(0.016666667-0.016666667*sign(1.,&
&vel))+g_u(i+1,k,j)*((-0.13333333)-(-0.083333333)*sign(1.,vel))+g_u(i,k,j)*(0.61666667-0.16666667*sign(1.,vel)))+&
&0.5*(g_ru(i-1,k,j)+g_ru(i,k,j))*fqx(i,k)/vel
else
        fqx(i,k)=0.
g_fqx(i,k) =0.5*(g_ru(i-1,k,j)+g_ru(i,k,j))*(37./60.*(u(i,k,j)+u(i-1,k,j))-2./15.*(u(i+1,k,j)&
&+u(i-2,k,j))+1./60.*(u(i+2,k,j)+u(i-3,k,j))-sign(1.,vel)*&
&(1./60.)*(u(i+2,k,j)-u(i-3,k,j)-5.*(u(i+1,k,j)-u(i-2,k,j))+10.*(u(i,k,j)-u(i-1,k,j))))
endif
      end do
    end do
    if (degrade_xs) then
      if (i_start .eq. ids+1) then
        i = ids+1
        do k = kts, ktf
          g_ub = g_u(i-1,k,j)
          ub = u(i-1,k,j)
          if (specified .and. u(i,k,j) .lt. 0.) then
            g_ub = g_u(i,k,j)
            ub = u(i,k,j)
          endif
          g_fqx(i,k) = 0.25*g_ru(i-1,k,j)*(u(i,k,j)+ub)+0.25*g_ru(i,k,j)*(u(i,k,j)+ub)+0.25*g_u(i,k,j)*(ru(i,k,j)+ru(i-1,k,j))+&
&0.25*g_ub*(ru(i,k,j)+ru(i-1,k,j))
          fqx(i,k) = 0.25*(ru(i,k,j)+ru(i-1,k,j))*(u(i,k,j)+ub)
        end do
      endif
      i = ids+2
      do k = kts, ktf
        g_vel = 0.5*g_ru(i-1,k,j)+0.5*g_ru(i,k,j)
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
        g_fqx(i,k) = g_u(i-2,k,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_u(i-1,k,j)*vel*(0.58333333+0.25*sign(1.,vel))+&
&g_u(i+1,k,j)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_u(i,k,j)*vel*(0.58333333+(-0.25)*sign(1.,vel))+g_vel*&
&(0.58333333*(u(i,k,j)+u(i-1,k,j))-0.083333333*(u(i+1,k,j)+u(i-2,k,j))+0.083333333*(u(i+1,k,j)-u(i-2,k,j)-3.*(u(i,k,j)-u(i-&
&1,k,j)))*sign(1.,vel))
        fqx(i,k) = vel*(7./12.*(u(i,k,j)+u(i-1,k,j))-1./12.*(u(i+1,k,j)+u(i-2,k,j))+sign(1.,vel)*(1./12.)*(u(i+1,k,j)-u(i-2,k,j)-&
&3.*(u(i,k,j)-u(i-1,k,j))))
      end do
    endif
    if (degrade_xe) then
      if (i_end .eq. ide-1) then
        i = ide
        do k = kts, ktf
          g_ub = g_u(i,k,j)
          ub = u(i,k,j)
          if (specified .and. u(i-1,k,j) .gt. 0.) then
            g_ub = g_u(i-1,k,j)
            ub = u(i-1,k,j)
          endif
          g_fqx(i,k) = 0.25*g_ru(i-1,k,j)*(u(i-1,k,j)+ub)+0.25*g_ru(i,k,j)*(u(i-1,k,j)+ub)+0.25*g_u(i-1,k,j)*(ru(i,k,j)+ru(i-1,k,j)&
&)+0.25*g_ub*(ru(i,k,j)+ru(i-1,k,j))
          fqx(i,k) = 0.25*(ru(i,k,j)+ru(i-1,k,j))*(u(i-1,k,j)+ub)
        end do
      endif
      do k = kts, ktf
        i = ide-1
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
        fqx(i,k) = vel*(7./12.*(u(i,k,j)+u(i-1,k,j))-1./12.*(u(i+1,k,j)+u(i-2,k,j))+sign(1.,vel)*(1./12.)*(u(i+1,k,j)-u(i-2,k,j)-&
&3.*(u(i,k,j)-u(i-1,k,j))))

        g_fqx(i,k) = vel*(g_u(i-2,k,j)*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_u(i-1,k,j)*(0.58333333+0.25*sign(1.,vel))+&
&g_u(i+1,k,j)*((-0.083333333)+0.083333333*sign(1.,vel))+g_u(i,k,j)*(0.58333333+(-0.25)*sign(1.,vel)))&
&+0.5*(g_ru(i-1,k,j)+g_ru(i,k,j))*fqx(i,k)/vel
else
        fqx(i,k)=0.
g_fqx(i,k) =0.5*(g_ru(i-1,k,j)+g_ru(i,k,j))*(7./12.*(u(i,k,j)+u(i-1,k,j))-1./12.*(u(i+1,k,j)+u(i-2,k,j))&
&+sign(1.,vel)*(1./12.)*(u(i+1,k,j)-u(i-2,k,j)-&
&3.*(u(i,k,j)-u(i-1,k,j))))
endif
      end do
    endif
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfu(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
else if (horz_order .eq. 4) then horizontal_order_tesu
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-1) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
  i_start = its
  i_end = ite
  j_start = jts
  j_end = min(jte,jde-1)
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
  if (degrade_xe) then
    i_end = ide-1
    i_end_f = ide-1
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start_f, i_end_f
        g_vel = 0.5*g_ru(i-1,k,j)+0.5*g_ru(i,k,j)
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
        g_fqx(i,k) = (-0.083333333)*g_u(i-2,k,j)*vel+0.58333333*g_u(i-1,k,j)*vel-0.083333333*g_u(i+1,k,j)*vel+0.58333333*g_u(i,k,j)&
&*vel+g_vel*(0.58333333*(u(i,k,j)+u(i-1,k,j))-0.083333333*(u(i+1,k,j)+u(i-2,k,j)))
        fqx(i,k) = vel*(7./12.*(u(i,k,j)+u(i-1,k,j))-1./12.*(u(i+1,k,j)+u(i-2,k,j)))
      end do
    end do
    if (degrade_xs) then
      i = i_start
      do k = kts, ktf
        g_ub = g_u(i-1,k,j)
        ub = u(i-1,k,j)
        if (specified .and. u(i,k,j) .lt. 0.) then
          g_ub = g_u(i,k,j)
          ub = u(i,k,j)
        endif
        g_fqx(i,k) = 0.25*g_ru(i-1,k,j)*(u(i,k,j)+ub)+0.25*g_ru(i,k,j)*(u(i,k,j)+ub)+0.25*g_u(i,k,j)*(ru(i,k,j)+ru(i-1,k,j))+0.25*&
&g_ub*(ru(i,k,j)+ru(i-1,k,j))
        fqx(i,k) = 0.25*(ru(i,k,j)+ru(i-1,k,j))*(u(i,k,j)+ub)
      end do
    endif
    if (degrade_xe) then
      i = i_end+1
      do k = kts, ktf
        g_ub = g_u(i,k,j)
        ub = u(i,k,j)
        if (specified .and. u(i-1,k,j) .gt. 0.) then
          g_ub = g_u(i-1,k,j)
          ub = u(i-1,k,j)
        endif
        g_fqx(i,k) = 0.25*g_ru(i-1,k,j)*(u(i-1,k,j)+ub)+0.25*g_ru(i,k,j)*(u(i-1,k,j)+ub)+0.25*g_u(i-1,k,j)*(ru(i,k,j)+ru(i-1,k,j))+&
&0.25*g_ub*(ru(i,k,j)+ru(i-1,k,j))
        fqx(i,k) = 0.25*(ru(i,k,j)+ru(i-1,k,j))*(u(i-1,k,j)+ub)
      end do
    endif
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfu(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
  i_start = its
  i_end = ite
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-1,ite)
  endif
  j_start = jts
  j_end = min(jte,jde-1)
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = jds+1
    j_start_f = j_start+1
  endif
  if (degrade_ye) then
    j_end = jde-2
    j_end_f = jde-2
  endif
  jp1 = 2
  jp0 = 1
  do j = j_start, j_end+1
    if (j .lt. j_start_f .and. degrade_ys) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.25*g_rv(i-1,k,j_start)*(u(i,k,j_start)+u(i,k,j_start-1))+0.25*g_rv(i,k,j_start)*(u(i,k,j_start)+u(i,k,&
&j_start-1))+0.25*g_u(i,k,j_start-1)*(rv(i,k,j_start)+rv(i-1,k,j_start))+0.25*g_u(i,k,j_start)*(rv(i,k,j_start)+rv(i-1,k,j_start))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j_start)+rv(i-1,k,j_start))*(u(i,k,j_start)+u(i,k,j_start-1))
        end do
      end do
    else if (j .gt. j_end_f .and. degrade_ye) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.25*g_rv(i-1,k,j_end+1)*(u(i,k,j_end+1)+u(i,k,j_end))+0.25*g_rv(i,k,j_end+1)*(u(i,k,j_end+1)+u(i,k,&
&j_end))+0.25*g_u(i,k,j_end+1)*(rv(i,k,j_end+1)+rv(i-1,k,j_end+1))+0.25*g_u(i,k,j_end)*(rv(i,k,j_end+1)+rv(i-1,k,j_end+1))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j_end+1)+rv(i-1,k,j_end+1))*(u(i,k,j_end+1)+u(i,k,j_end))
        end do
      end do
    else
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = 0.5*g_rv(i-1,k,j)+0.5*g_rv(i,k,j)
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
          g_fqy(i,k,jp1) = (-0.083333333)*g_u(i,k,j-2)*vel+0.58333333*g_u(i,k,j-1)*vel-0.083333333*g_u(i,k,j+1)*vel+0.58333333*&
&g_u(i,k,j)*vel+g_vel*(0.58333333*(u(i,k,j)+u(i,k,j-1))-0.083333333*(u(i,k,j+1)+u(i,k,j-2)))
          fqy(i,k,jp1) = vel*(7./12.*(u(i,k,j)+u(i,k,j-1))-1./12.*(u(i,k,j+1)+u(i,k,j-2)))
        end do
      end do
    endif
    if (j .gt. j_start) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfu(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do
else if (horz_order .eq. 3) then horizontal_order_tesu
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-1) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
  i_start = its
  i_end = ite
  j_start = jts
  j_end = min(jte,jde-1)
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
  if (degrade_xe) then
    i_end = ide-1
    i_end_f = ide-1
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start_f, i_end_f
        g_vel = 0.5*g_ru(i-1,k,j)+0.5*g_ru(i,k,j)
        vel = 0.5*(ru(i,k,j)+ru(i-1,k,j))
        g_fqx(i,k) = g_u(i-2,k,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_u(i-1,k,j)*vel*(0.58333333+0.25*sign(1.,vel))+&
&g_u(i+1,k,j)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_u(i,k,j)*vel*(0.58333333+(-0.25)*sign(1.,vel))+g_vel*&
&(0.58333333*(u(i,k,j)+u(i-1,k,j))-0.083333333*(u(i+1,k,j)+u(i-2,k,j))+0.083333333*(u(i+1,k,j)-u(i-2,k,j)-3.*(u(i,k,j)-u(i-&
&1,k,j)))*sign(1.,vel))
        fqx(i,k) = vel*(7./12.*(u(i,k,j)+u(i-1,k,j))-1./12.*(u(i+1,k,j)+u(i-2,k,j))+sign(1.,vel)*(1./12.)*(u(i+1,k,j)-u(i-2,k,j)-&
&3.*(u(i,k,j)-u(i-1,k,j))))
      end do
    end do
    if (degrade_xs) then
      i = i_start
      do k = kts, ktf
        g_ub = g_u(i-1,k,j)
        ub = u(i-1,k,j)
        if (specified .and. u(i,k,j) .lt. 0.) then
          g_ub = g_u(i,k,j)
          ub = u(i,k,j)
        endif
        g_fqx(i,k) = 0.25*g_ru(i-1,k,j)*(u(i,k,j)+ub)+0.25*g_ru(i,k,j)*(u(i,k,j)+ub)+0.25*g_u(i,k,j)*(ru(i,k,j)+ru(i-1,k,j))+0.25*&
&g_ub*(ru(i,k,j)+ru(i-1,k,j))
        fqx(i,k) = 0.25*(ru(i,k,j)+ru(i-1,k,j))*(u(i,k,j)+ub)
      end do
    endif
    if (degrade_xe) then
      i = i_end+1
      do k = kts, ktf
        g_ub = g_u(i,k,j)
        ub = u(i,k,j)
        if (specified .and. u(i-1,k,j) .gt. 0.) then
          g_ub = g_u(i-1,k,j)
          ub = u(i-1,k,j)
        endif
        g_fqx(i,k) = 0.25*g_ru(i-1,k,j)*(u(i-1,k,j)+ub)+0.25*g_ru(i,k,j)*(u(i-1,k,j)+ub)+0.25*g_u(i-1,k,j)*(ru(i,k,j)+ru(i-1,k,j))+&
&0.25*g_ub*(ru(i,k,j)+ru(i-1,k,j))
        fqx(i,k) = 0.25*(ru(i,k,j)+ru(i-1,k,j))*(u(i-1,k,j)+ub)
      end do
    endif
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfu(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
  i_start = its
  i_end = ite
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-1,ite)
  endif
  j_start = jts
  j_end = min(jte,jde-1)
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = jds+1
    j_start_f = j_start+1
  endif
  if (degrade_ye) then
    j_end = jde-2
    j_end_f = jde-2
  endif
  jp1 = 2
  jp0 = 1
  do j = j_start, j_end+1
    if (j .lt. j_start_f .and. degrade_ys) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.25*g_rv(i-1,k,j_start)*(u(i,k,j_start)+u(i,k,j_start-1))+0.25*g_rv(i,k,j_start)*(u(i,k,j_start)+u(i,k,&
&j_start-1))+0.25*g_u(i,k,j_start-1)*(rv(i,k,j_start)+rv(i-1,k,j_start))+0.25*g_u(i,k,j_start)*(rv(i,k,j_start)+rv(i-1,k,j_start))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j_start)+rv(i-1,k,j_start))*(u(i,k,j_start)+u(i,k,j_start-1))
        end do
      end do
    else if (j .gt. j_end_f .and. degrade_ye) then
      do k = kts, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.25*g_rv(i-1,k,j_end+1)*(u(i,k,j_end+1)+u(i,k,j_end))+0.25*g_rv(i,k,j_end+1)*(u(i,k,j_end+1)+u(i,k,&
&j_end))+0.25*g_u(i,k,j_end+1)*(rv(i,k,j_end+1)+rv(i-1,k,j_end+1))+0.25*g_u(i,k,j_end)*(rv(i,k,j_end+1)+rv(i-1,k,j_end+1))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j_end+1)+rv(i-1,k,j_end+1))*(u(i,k,j_end+1)+u(i,k,j_end))
        end do
      end do
    else
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = 0.5*g_rv(i-1,k,j)+0.5*g_rv(i,k,j)
          vel = 0.5*(rv(i,k,j)+rv(i-1,k,j))
          g_fqy(i,k,jp1) = g_u(i,k,j-2)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_u(i,k,j-1)*vel*(0.58333333+0.25*sign(1.,&
&vel))+g_u(i,k,j+1)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_u(i,k,j)*vel*(0.58333333+(-0.25)*sign(1.,vel))+g_vel*&
&(0.58333333*(u(i,k,j)+u(i,k,j-1))-0.083333333*(u(i,k,j+1)+u(i,k,j-2))+0.083333333*(u(i,k,j+1)-u(i,k,j-2)-3.*(u(i,k,j)-&
&u(i,k,j-1)))*sign(1.,vel))
          fqy(i,k,jp1) = vel*(7./12.*(u(i,k,j)+u(i,k,j-1))-1./12.*(u(i,k,j+1)+u(i,k,j-2))+sign(1.,vel)*(1./12.)*(u(i,k,j+1)-u(i,k,&
&j-2)-3.*(u(i,k,j)-u(i,k,j-1))))
        end do
      end do
    endif
    if (j .gt. j_start) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfu(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do
else if (horz_order .eq. 2) then horizontal_order_tesu
  i_start = its
  i_end = ite
  j_start = jts
  j_end = min(jte,jde-1)
  if (config_flags%open_xs) then
    i_start = max(ids+1,its)
  endif
  if (config_flags%open_xe) then
    i_end = min(ide-1,ite)
  endif
  if (specified) then
    i_start = max(ids+2,its)
  endif
  if (specified) then
    i_end = min(ide-2,ite)
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfu(i,j)*rdx
        g_tendency(i,k,j) = 0.25*g_ru(i-1,k,j)*mrdx*(u(i,k,j)+u(i-1,k,j))-0.25*g_ru(i+1,k,j)*mrdx*(u(i+1,k,j)+u(i,k,j))-0.25*&
&g_ru(i,k,j)*mrdx*(u(i+1,k,j)+u(i,k,j)-(u(i,k,j)+u(i-1,k,j)))+g_tendency(i,k,j)+0.25*g_u(i-1,k,j)*mrdx*(ru(i,k,j)+ru(i-1,k,&
&j))-0.25*g_u(i+1,k,j)*mrdx*(ru(i+1,k,j)+ru(i,k,j))-0.25*g_u(i,k,j)*mrdx*(ru(i+1,k,j)+ru(i,k,j)-(ru(i,k,j)+ru(i-1,k,j)))
        tendency(i,k,j) = tendency(i,k,j)-mrdx*0.25*((ru(i+1,k,j)+ru(i,k,j))*(u(i+1,k,j)+u(i,k,j))-(ru(i,k,j)+ru(i-1,k,j))*(u(i,k,&
&j)+u(i-1,k,j)))
      end do
    end do
  end do
  if (specified .and. its .le. ids+1) then
    do j = j_start, j_end
      do k = kts, ktf
        i = ids+1
        mrdx = msfu(i,j)*rdx
        g_ub = g_u(i-1,k,j)
        ub = u(i-1,k,j)
        if (u(i,k,j) .lt. 0.) then
          g_ub = g_u(i,k,j)
          ub = u(i,k,j)
        endif
        g_tendency(i,k,j) = 0.25*g_ru(i-1,k,j)*mrdx*(u(i,k,j)+ub)-0.25*g_ru(i+1,k,j)*mrdx*(u(i+1,k,j)+u(i,k,j))-0.25*g_ru(i,k,j)*&
&mrdx*(u(i+1,k,j)+u(i,k,j)-(u(i,k,j)+ub))+g_tendency(i,k,j)-0.25*g_u(i+1,k,j)*mrdx*(ru(i+1,k,j)+ru(i,k,j))-0.25*g_u(i,k,j)*&
&mrdx*(ru(i+1,k,j)+ru(i,k,j)-(ru(i,k,j)+ru(i-1,k,j)))+0.25*g_ub*mrdx*(ru(i,k,j)+ru(i-1,k,j))
        tendency(i,k,j) = tendency(i,k,j)-mrdx*0.25*((ru(i+1,k,j)+ru(i,k,j))*(u(i+1,k,j)+u(i,k,j))-(ru(i,k,j)+ru(i-1,k,j))*(u(i,k,&
&j)+ub))
      end do
    end do
  endif
  if (specified .and. ite .ge. ide-1) then
    do j = j_start, j_end
      do k = kts, ktf
        i = ide-1
        mrdx = msfu(i,j)*rdx
        g_ub = g_u(i+1,k,j)
        ub = u(i+1,k,j)
        if (u(i,k,j) .gt. 0.) then
          g_ub = g_u(i,k,j)
          ub = u(i,k,j)
        endif
        g_tendency(i,k,j) = 0.25*g_ru(i-1,k,j)*mrdx*(u(i,k,j)+u(i-1,k,j))-0.25*g_ru(i+1,k,j)*mrdx*(ub+u(i,k,j))-0.25*g_ru(i,k,j)*&
&mrdx*(ub+u(i,k,j)-(u(i,k,j)+u(i-1,k,j)))+g_tendency(i,k,j)+0.25*g_u(i-1,k,j)*mrdx*(ru(i,k,j)+ru(i-1,k,j))-0.25*g_u(i,k,j)*&
&mrdx*(ru(i+1,k,j)+ru(i,k,j)-(ru(i,k,j)+ru(i-1,k,j)))-0.25*g_ub*mrdx*(ru(i+1,k,j)+ru(i,k,j))
        tendency(i,k,j) = tendency(i,k,j)-mrdx*0.25*((ru(i+1,k,j)+ru(i,k,j))*(ub+u(i,k,j))-(ru(i,k,j)+ru(i-1,k,j))*(u(i,k,j)+u(i-1,&
&k,j)))
      end do
    end do
  endif
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-2,jte)
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdy = msfu(i,j)*rdy
        g_tendency(i,k,j) = (-(0.25*g_rv(i-1,k,j+1)*mrdy*(u(i,k,j+1)+u(i,k,j))))-0.25*g_rv(i,k,j+1)*mrdy*(u(i,k,j+1)+u(i,k,j))+&
&0.25*g_rv(i-1,k,j)*mrdy*(u(i,k,j)+u(i,k,j-1))+0.25*g_rv(i,k,j)*mrdy*(u(i,k,j)+u(i,k,j-1))+g_tendency(i,k,j)+0.25*g_u(i,k,&
&j-1)*mrdy*(rv(i,k,j)+rv(i-1,k,j))-0.25*g_u(i,k,j+1)*mrdy*(rv(i,k,j+1)+rv(i-1,k,j+1))-0.25*g_u(i,k,j)*mrdy*(rv(i,k,j+1)+&
&rv(i-1,k,j+1)-(rv(i,k,j)+rv(i-1,k,j)))
        tendency(i,k,j) = tendency(i,k,j)-mrdy*0.25*((rv(i,k,j+1)+rv(i-1,k,j+1))*(u(i,k,j+1)+u(i,k,j))-(rv(i,k,j)+rv(i-1,k,j))*&
&(u(i,k,j)+u(i,k,j-1)))
      end do
    end do
  end do
else horizontal_order_tesu
  write(unit=wrf_err_message,fmt=*) 'module_advect: advect_u_6a:  h_order not known ',horz_order
endif horizontal_order_tesu
if (config_flags%open_xs .and. its .eq. ids) then
  j_start = jts
  j_end = min(jte,jde-1)
  do j = j_start, j_end
    do k = kts, ktf
      g_ub = (-(g_mut(its,j)*(0.5+sign(0.5,0.-(ru(its,k,j)-cb*mut(its,j))))*cb))+g_ru(its,k,j)*(0.5+sign(0.5,0.-(ru(its,k,j)-cb*&
&mut(its,j))))
      ub = min(ru(its,k,j)-cb*mut(its,j),0.)
      g_tendency(its,k,j) = g_tendency(its,k,j)-g_u_old(its+1,k,j)*rdx*ub+g_u_old(its,k,j)*rdx*ub-g_ub*rdx*(u_old(its+1,k,j)-&
&u_old(its,k,j))
      tendency(its,k,j) = tendency(its,k,j)-rdx*ub*(u_old(its+1,k,j)-u_old(its,k,j))
    end do
  end do
endif
if (config_flags%open_xe .and. ite .eq. ide) then
  j_start = jts
  j_end = min(jte,jde-1)
  do j = j_start, j_end
    do k = kts, ktf
      g_ub = g_mut(ite-1,j)*(0.5+sign(0.5,ru(ite,k,j)+cb*mut(ite-1,j)-0.))*cb+g_ru(ite,k,j)*(0.5+sign(0.5,ru(ite,k,j)+cb*mut(ite-1,&
&j)-0.))
      ub = max(ru(ite,k,j)+cb*mut(ite-1,j),0.)
      g_tendency(ite,k,j) = g_tendency(ite,k,j)+g_u_old(ite-1,k,j)*rdx*ub-g_u_old(ite,k,j)*rdx*ub-g_ub*rdx*(u_old(ite,k,j)-&
&u_old(ite-1,k,j))
      tendency(ite,k,j) = tendency(ite,k,j)-rdx*ub*(u_old(ite,k,j)-u_old(ite-1,k,j))
    end do
  end do
endif
i_start = its
i_end = min(ite,ide)
imin = ids
imax = ide-1
if (config_flags%open_xs) then
  i_start = max(ids+1,its)
  imin = ids
endif
if (config_flags%open_xe) then
  i_end = min(ite,ide-1)
  imax = ide-1
endif
if (config_flags%open_ys .and. jts .eq. jds) then
  do i = i_start, i_end
    mrdy = msfu(i,jts)*rdy
    ip = min(imax,i)
    im = max(imin,i-1)
    do k = kts, ktf
      g_vw = 0.5*g_rv(im,k,jts)+0.5*g_rv(ip,k,jts)
      vw = 0.5*(rv(ip,k,jts)+rv(im,k,jts))
      g_vb = g_vw*(0.5+sign(0.5,0.-vw))
      vb = min(vw,0.)
      g_dvm = g_rv(ip,k,jts+1)-g_rv(ip,k,jts)
      dvm = rv(ip,k,jts+1)-rv(ip,k,jts)
      g_dvp = g_rv(im,k,jts+1)-g_rv(im,k,jts)
      dvp = rv(im,k,jts+1)-rv(im,k,jts)
      g_tendency(i,k,jts) = (-(0.5*g_dvm*mrdy*u(i,k,jts)))-0.5*g_dvp*mrdy*u(i,k,jts)+g_tendency(i,k,jts)-0.5*g_u(i,k,jts)*mrdy*&
&(dvm+dvp)-g_u_old(i,k,jts+1)*mrdy*vb+g_u_old(i,k,jts)*mrdy*vb-g_vb*mrdy*(u_old(i,k,jts+1)-u_old(i,k,jts))
      tendency(i,k,jts) = tendency(i,k,jts)-mrdy*(vb*(u_old(i,k,jts+1)-u_old(i,k,jts))+0.5*u(i,k,jts)*(dvm+dvp))
    end do
  end do
endif
if (config_flags%open_ye .and. jte .eq. jde) then
  do i = i_start, i_end
    mrdy = msfu(i,jte-1)*rdy
    ip = min(imax,i)
    im = max(imin,i-1)
    do k = kts, ktf
      g_vw = 0.5*g_rv(im,k,jte)+0.5*g_rv(ip,k,jte)
      vw = 0.5*(rv(ip,k,jte)+rv(im,k,jte))
      g_vb = g_vw*(0.5+sign(0.5,vw-0.))
      vb = max(vw,0.)
      g_dvm = (-g_rv(ip,k,jte-1))+g_rv(ip,k,jte)
      dvm = rv(ip,k,jte)-rv(ip,k,jte-1)
      g_dvp = (-g_rv(im,k,jte-1))+g_rv(im,k,jte)
      dvp = rv(im,k,jte)-rv(im,k,jte-1)
      g_tendency(i,k,jte-1) = (-(0.5*g_dvm*mrdy*u(i,k,jte-1)))-0.5*g_dvp*mrdy*u(i,k,jte-1)+g_tendency(i,k,jte-1)-0.5*g_u(i,k,jte-1)&
&*mrdy*(dvm+dvp)+g_u_old(i,k,jte-2)*mrdy*vb-g_u_old(i,k,jte-1)*mrdy*vb-g_vb*mrdy*(u_old(i,k,jte-1)-u_old(i,k,jte-2))
      tendency(i,k,jte-1) = tendency(i,k,jte-1)-mrdy*(vb*(u_old(i,k,jte-1)-u_old(i,k,jte-2))+0.5*u(i,k,jte-1)*(dvm+dvp))
    end do
  end do
endif
i_start = its
i_end = ite
j_start = jts
j_end = min(jte,jde-1)
if (config_flags%open_ys .or. specified) then
  i_start = max(ids+1,its)
endif
if (config_flags%open_ye .or. specified) then
  i_end = min(ide-1,ite)
endif
do i = i_start, i_end
  g_vflux(i,kts) = 0.
  vflux(i,kts) = 0.
  g_vflux(i,kte) = 0.
  vflux(i,kte) = 0.
end do
vert_order_tesu: if (vert_order .eq. 6) then
  do j = j_start, j_end
    do k = kts+3, ktf-2
      do i = i_start, i_end
        g_vel = 0.5*g_rom(i-1,k,j)+0.5*g_rom(i,k,j)
        vel = 0.5*(rom(i-1,k,j)+rom(i,k,j))
        g_vflux(i,k) = 0.016666667*g_u(i,k-3,j)*vel-0.13333333*g_u(i,k-2,j)*vel+0.61666667*g_u(i,k-1,j)*vel+0.016666667*g_u(i,k+2,&
&j)*vel-0.13333333*g_u(i,k+1,j)*vel+0.61666667*g_u(i,k,j)*vel+g_vel*(0.61666667*(u(i,k,j)+u(i,k-1,j))-0.13333333*(u(i,k+1,&
&j)+u(i,k-2,j))+0.016666667*(u(i,k+2,j)+u(i,k-3,j)))
        vflux(i,k) = vel*(37./60.*(u(i,k,j)+u(i,k-1,j))-2./15.*(u(i,k+1,j)+u(i,k-2,j))+1./60.*(u(i,k+2,j)+u(i,k-3,j)))
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = 0.5*g_rom(i-1,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+&
&0.5*g_u(i,k-1,j)*(rom(i,k,j)+rom(i-1,k,j))*fzp(k)+0.5*g_u(i,k,j)*(rom(i,k,j)+rom(i-1,k,j))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i-1,k,j))*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))
      k = kts+2
      g_vel = 0.5*g_rom(i-1,k,j)+0.5*g_rom(i,k,j)
      vel = 0.5*(rom(i,k,j)+rom(i-1,k,j))
      g_vflux(i,k) = (-0.083333333)*g_u(i,k-2,j)*vel+0.58333333*g_u(i,k-1,j)*vel-0.083333333*g_u(i,k+1,j)*vel+0.58333333*g_u(i,k,j)&
&*vel+g_vel*(0.58333333*(u(i,k,j)+u(i,k-1,j))-0.083333333*(u(i,k+1,j)+u(i,k-2,j)))
      vflux(i,k) = vel*(7./12.*(u(i,k,j)+u(i,k-1,j))-1./12.*(u(i,k+1,j)+u(i,k-2,j)))
      k = ktf-1
      g_vel = 0.5*g_rom(i-1,k,j)+0.5*g_rom(i,k,j)
      vel = 0.5*(rom(i,k,j)+rom(i-1,k,j))
      g_vflux(i,k) = (-0.083333333)*g_u(i,k-2,j)*vel+0.58333333*g_u(i,k-1,j)*vel-0.083333333*g_u(i,k+1,j)*vel+0.58333333*g_u(i,k,j)&
&*vel+g_vel*(0.58333333*(u(i,k,j)+u(i,k-1,j))-0.083333333*(u(i,k+1,j)+u(i,k-2,j)))
      vflux(i,k) = vel*(7./12.*(u(i,k,j)+u(i,k-1,j))-1./12.*(u(i,k+1,j)+u(i,k-2,j)))
      k = ktf
      g_vflux(i,k) = 0.5*g_rom(i-1,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+&
&0.5*g_u(i,k-1,j)*(rom(i,k,j)+rom(i-1,k,j))*fzp(k)+0.5*g_u(i,k,j)*(rom(i,k,j)+rom(i-1,k,j))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i-1,k,j))*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else if (vert_order .eq. 5) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+3, ktf-2
      do i = i_start, i_end
        g_vel = 0.5*g_rom(i-1,k,j)+0.5*g_rom(i,k,j)
        vel = 0.5*(rom(i-1,k,j)+rom(i,k,j))
        g_vflux(i,k) = g_u(i,k-3,j)*vel*(0.016666667-(-0.016666667)*sign(1.,-vel))+g_u(i,k-2,j)*vel*((-0.13333333)-0.083333333*&
&sign(1.,-vel))+g_u(i,k-1,j)*vel*(0.61666667-(-0.16666667)*sign(1.,-vel))+g_u(i,k+2,j)*vel*(0.016666667-0.016666667*&
&sign(1.,-vel))+g_u(i,k+1,j)*vel*((-0.13333333)-(-0.083333333)*sign(1.,-vel))+g_u(i,k,j)*vel*(0.61666667-0.16666667*&
&sign(1.,-vel))+g_vel*(0.61666667*(u(i,k,j)+u(i,k-1,j))-0.13333333*(u(i,k+1,j)+u(i,k-2,j))+0.016666667*(u(i,k+2,j)+u(i,k-3,&
&j))-0.016666667*(u(i,k+2,j)-u(i,k-3,j)-5.*(u(i,k+1,j)-u(i,k-2,j))+10.*(u(i,k,j)-u(i,k-1,j)))*sign(1.,-vel))
        vflux(i,k) = vel*(37./60.*(u(i,k,j)+u(i,k-1,j))-2./15.*(u(i,k+1,j)+u(i,k-2,j))+1./60.*(u(i,k+2,j)+u(i,k-3,j))-sign(1.,-vel)&
&*(1./60.)*(u(i,k+2,j)-u(i,k-3,j)-5.*(u(i,k+1,j)-u(i,k-2,j))+10.*(u(i,k,j)-u(i,k-1,j))))
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = 0.5*g_rom(i-1,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+&
&0.5*g_u(i,k-1,j)*(rom(i,k,j)+rom(i-1,k,j))*fzp(k)+0.5*g_u(i,k,j)*(rom(i,k,j)+rom(i-1,k,j))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i-1,k,j))*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))
      k = kts+2
      g_vel = 0.5*g_rom(i-1,k,j)+0.5*g_rom(i,k,j)
      vel = 0.5*(rom(i,k,j)+rom(i-1,k,j))
      g_vflux(i,k) = g_u(i,k-2,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,-vel))+g_u(i,k-1,j)*vel*(0.58333333+0.25*sign(1.,-vel)&
&)+g_u(i,k+1,j)*vel*((-0.083333333)+0.083333333*sign(1.,-vel))+g_u(i,k,j)*vel*(0.58333333+(-0.25)*sign(1.,-vel))+g_vel*&
&(0.58333333*(u(i,k,j)+u(i,k-1,j))-0.083333333*(u(i,k+1,j)+u(i,k-2,j))+0.083333333*(u(i,k+1,j)-u(i,k-2,j)-3.*(u(i,k,j)-u(i,k-&
&1,j)))*sign(1.,-vel))
      vflux(i,k) = vel*(7./12.*(u(i,k,j)+u(i,k-1,j))-1./12.*(u(i,k+1,j)+u(i,k-2,j))+sign(1.,-vel)*(1./12.)*(u(i,k+1,j)-u(i,k-2,j)-&
&3.*(u(i,k,j)-u(i,k-1,j))))
      k = ktf-1
      g_vel = 0.5*g_rom(i-1,k,j)+0.5*g_rom(i,k,j)
      vel = 0.5*(rom(i,k,j)+rom(i-1,k,j))
      g_vflux(i,k) = g_u(i,k-2,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,-vel))+g_u(i,k-1,j)*vel*(0.58333333+0.25*sign(1.,-vel)&
&)+g_u(i,k+1,j)*vel*((-0.083333333)+0.083333333*sign(1.,-vel))+g_u(i,k,j)*vel*(0.58333333+(-0.25)*sign(1.,-vel))+g_vel*&
&(0.58333333*(u(i,k,j)+u(i,k-1,j))-0.083333333*(u(i,k+1,j)+u(i,k-2,j))+0.083333333*(u(i,k+1,j)-u(i,k-2,j)-3.*(u(i,k,j)-u(i,k-&
&1,j)))*sign(1.,-vel))
      vflux(i,k) = vel*(7./12.*(u(i,k,j)+u(i,k-1,j))-1./12.*(u(i,k+1,j)+u(i,k-2,j))+sign(1.,-vel)*(1./12.)*(u(i,k+1,j)-u(i,k-2,j)-&
&3.*(u(i,k,j)-u(i,k-1,j))))
      k = ktf
      g_vflux(i,k) = 0.5*g_rom(i-1,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+&
&0.5*g_u(i,k-1,j)*(rom(i,k,j)+rom(i-1,k,j))*fzp(k)+0.5*g_u(i,k,j)*(rom(i,k,j)+rom(i-1,k,j))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i-1,k,j))*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else if (vert_order .eq. 4) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+2, ktf-1
      do i = i_start, i_end
        g_vel = 0.5*g_rom(i-1,k,j)+0.5*g_rom(i,k,j)
        vel = 0.5*(rom(i-1,k,j)+rom(i,k,j))
        g_vflux(i,k) = (-0.083333333)*g_u(i,k-2,j)*vel+0.58333333*g_u(i,k-1,j)*vel-0.083333333*g_u(i,k+1,j)*vel+0.58333333*g_u(i,k,&
&j)*vel+g_vel*(0.58333333*(u(i,k,j)+u(i,k-1,j))-0.083333333*(u(i,k+1,j)+u(i,k-2,j)))
        vflux(i,k) = vel*(7./12.*(u(i,k,j)+u(i,k-1,j))-1./12.*(u(i,k+1,j)+u(i,k-2,j)))
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = 0.5*g_rom(i-1,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+&
&0.5*g_u(i,k-1,j)*(rom(i,k,j)+rom(i-1,k,j))*fzp(k)+0.5*g_u(i,k,j)*(rom(i,k,j)+rom(i-1,k,j))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i-1,k,j))*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))
      k = ktf
      g_vflux(i,k) = 0.5*g_rom(i-1,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+&
&0.5*g_u(i,k-1,j)*(rom(i,k,j)+rom(i-1,k,j))*fzp(k)+0.5*g_u(i,k,j)*(rom(i,k,j)+rom(i-1,k,j))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i-1,k,j))*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else if (vert_order .eq. 3) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+2, ktf-1
      do i = i_start, i_end
        vel = 0.5*(rom(i-1,k,j)+rom(i,k,j))

!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
        vflux(i,k) = vel*(7./12.*(u(i,k,j)+u(i,k-1,j))-1./12.*(u(i,k+1,j)&
&+u(i,k-2,j))+sign(1.,-vel)*(1./12.)*(u(i,k+1,j)-u(i,k-2,j)&
&-3.*(u(i,k,j)-u(i,k-1,j))))

        g_vflux(i,k) = vel*(g_u(i,k-2,j)*((-0.083333333)+(-0.083333333)*sign(1.,-vel))+g_u(i,k-1,j)*(0.58333333+0.25*sign(1.,-&
&vel))+g_u(i,k+1,j)*((-0.083333333)+0.083333333*sign(1.,-vel))+g_u(i,k,j)*(0.58333333+(-0.25)*sign(1.,-vel)))&
&+0.5*(g_rom(i-1,k,j)+g_rom(i,k,j))*vflux(i,k)/vel
else
        vflux(i,k)=0.
g_vflux(i,k) =0.5*(g_rom(i-1,k,j)+g_rom(i,k,j))*(7./12.*(u(i,k,j)+u(i,k-1,j))-1./12.*(u(i,k+1,j)+u(i,k-2,j))&
&+sign(1.,-vel)*(1./12.)*(u(i,k+1,j)-u(i,k-2,j)-3.*(u(i,k,j)-u(i,k-1,j))))
endif
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = 0.5*g_rom(i-1,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+&
&0.5*g_u(i,k-1,j)*(rom(i,k,j)+rom(i-1,k,j))*fzp(k)+0.5*g_u(i,k,j)*(rom(i,k,j)+rom(i-1,k,j))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i-1,k,j))*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))
      k = ktf
      g_vflux(i,k) = 0.5*g_rom(i-1,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+&
&0.5*g_u(i,k-1,j)*(rom(i,k,j)+rom(i-1,k,j))*fzp(k)+0.5*g_u(i,k,j)*(rom(i,k,j)+rom(i-1,k,j))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i-1,k,j))*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else if (vert_order .eq. 2) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+1, ktf
      do i = i_start, i_end
        g_vflux(i,k) = 0.5*g_rom(i-1,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))+&
&0.5*g_u(i,k-1,j)*(rom(i,k,j)+rom(i-1,k,j))*fzp(k)+0.5*g_u(i,k,j)*(rom(i,k,j)+rom(i-1,k,j))*fzm(k)
        vflux(i,k) = 0.5*(rom(i,k,j)+rom(i-1,k,j))*(fzm(k)*u(i,k,j)+fzp(k)*u(i,k-1,j))
      end do
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
endif vert_order_tesu

   call trace_exit("g_advect_u")

end subroutine g_advect_u


subroutine g_advect_v( v, g_v, v_old, g_v_old, tendency, g_tendency, ru, g_ru, rv, g_rv, rom, g_rom, mut, g_mut, config_flags, &
&msfv, fzm, fzp, rdx, rdy, rdzw, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_mut(ims:ime,jms:jme)
real, intent(in) :: g_rom(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v_old(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: rdzw(kms:kme)
real, intent(in) :: rom(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v_old(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
logical degrade_xe
logical degrade_xs
logical degrade_ye
logical degrade_ys
real dum
real dup
real fqx(its:ite+1,kts:kte)
real fqy(its:ite,kts:kte,2)
real g_dum
real g_dup
real g_fqx(its:ite+1,kts:kte)
real g_fqy(its:ite,kts:kte,2)
real g_ub
real g_uw
real g_vb
real g_vel
real g_vflux(its:ite,kts:kte)
integer horz_order
integer i
integer i_end
integer i_end_f
integer i_start
integer i_start_f
integer j
integer j_end
integer j_end_f
integer j_start
integer j_start_f
integer jm
integer jmax
integer jmin
integer jp
integer jp0
integer jp1
integer jtmp
integer k
integer ktf
real mrdx
real mrdy
logical specified
real ub
real uw
real vb
real vel
integer vert_order
real vflux(its:ite,kts:kte)

   call trace_entry("g_advect_v")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
ktf = min(kte,kde-1)
horz_order = config_flags%h_mom_adv_order
vert_order = config_flags%v_mom_adv_order
horizontal_order_tesu: if (horz_order .eq. 6) then
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-3) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
  ktf = min(kte,kde-1)
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = jte
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = max(jts,jds+1)
    j_start_f = jds+3
  endif
  if (degrade_ye) then
    j_end = min(jte,jde-1)
    j_end_f = jde-2
  endif
  jp1 = 2
  jp0 = 1
  j_loop_y_flux_6: do j = j_start, j_end+1
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = 0.5*g_rv(i,k,j-1)+0.5*g_rv(i,k,j)
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
          g_fqy(i,k,jp1) = 0.016666667*g_v(i,k,j-3)*vel-0.13333333*g_v(i,k,j-2)*vel+0.61666667*g_v(i,k,j-1)*vel+0.016666667*g_v(i,&
&k,j+2)*vel-0.13333333*g_v(i,k,j+1)*vel+0.61666667*g_v(i,k,j)*vel+g_vel*(0.61666667*(v(i,k,j)+v(i,k,j-1))-0.13333333*&
&(v(i,k,j+1)+v(i,k,j-2))+0.016666667*(v(i,k,j+2)+v(i,k,j-3)))
          fqy(i,k,jp1) = vel*(37./60.*(v(i,k,j)+v(i,k,j-1))-2./15.*(v(i,k,j+1)+v(i,k,j-2))+1./60.*(v(i,k,j+2)+v(i,k,j-3)))
        end do
      end do
    else if (j .eq. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vb = g_v(i,k,j-1)
          vb = v(i,k,j-1)
          if (specified .and. v(i,k,j) .lt. 0.) then
            g_vb = g_v(i,k,j)
            vb = v(i,k,j)
          endif
          g_fqy(i,k,jp1) = 0.25*g_rv(i,k,j-1)*(v(i,k,j)+vb)+0.25*g_rv(i,k,j)*(v(i,k,j)+vb)+0.25*g_v(i,k,j)*(rv(i,k,j)+rv(i,k,j-1))+&
&0.25*g_vb*(rv(i,k,j)+rv(i,k,j-1))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j)+rv(i,k,j-1))*(v(i,k,j)+vb)
        end do
      end do
    else if (j .eq. jds+2) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = 0.5*g_rv(i,k,j-1)+0.5*g_rv(i,k,j)
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
          g_fqy(i,k,jp1) = (-0.083333333)*g_v(i,k,j-2)*vel+0.58333333*g_v(i,k,j-1)*vel-0.083333333*g_v(i,k,j+1)*vel+0.58333333*&
&g_v(i,k,j)*vel+g_vel*(0.58333333*(v(i,k,j)+v(i,k,j-1))-0.083333333*(v(i,k,j+1)+v(i,k,j-2)))
          fqy(i,k,jp1) = vel*(7./12.*(v(i,k,j)+v(i,k,j-1))-1./12.*(v(i,k,j+1)+v(i,k,j-2)))
        end do
      end do
    else if (j .eq. jde) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vb = g_v(i,k,j)
          vb = v(i,k,j)
          if (specified .and. v(i,k,j-1) .gt. 0.) then
            g_vb = g_v(i,k,j-1)
            vb = v(i,k,j-1)
          endif
          g_fqy(i,k,jp1) = 0.25*g_rv(i,k,j-1)*(vb+v(i,k,j-1))+0.25*g_rv(i,k,j)*(vb+v(i,k,j-1))+0.25*g_v(i,k,j-1)*(rv(i,k,j)+rv(i,k,&
&j-1))+0.25*g_vb*(rv(i,k,j)+rv(i,k,j-1))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j)+rv(i,k,j-1))*(vb+v(i,k,j-1))
        end do
      end do
    else if (j .eq. jde-1) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = 0.5*g_rv(i,k,j-1)+0.5*g_rv(i,k,j)
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
          g_fqy(i,k,jp1) = (-0.083333333)*g_v(i,k,j-2)*vel+0.58333333*g_v(i,k,j-1)*vel-0.083333333*g_v(i,k,j+1)*vel+0.58333333*&
&g_v(i,k,j)*vel+g_vel*(0.58333333*(v(i,k,j)+v(i,k,j-1))-0.083333333*(v(i,k,j+1)+v(i,k,j-2)))
          fqy(i,k,jp1) = vel*(7./12.*(v(i,k,j)+v(i,k,j-1))-1./12.*(v(i,k,j+1)+v(i,k,j-2)))
        end do
      end do
    endif
    if (j .gt. j_start) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfv(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do j_loop_y_flux_6
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = jte
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-1,jte)
  endif
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = i_start+2
  endif
  if (degrade_xe) then
    i_end = min(ide-2,ite)
    i_end_f = ide-3
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start_f, i_end_f
        g_vel = 0.5*g_ru(i,k,j-1)+0.5*g_ru(i,k,j)
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
        g_fqx(i,k) = 0.016666667*g_v(i-3,k,j)*vel-0.13333333*g_v(i-2,k,j)*vel+0.61666667*g_v(i-1,k,j)*vel+0.016666667*g_v(i+2,k,j)*&
&vel-0.13333333*g_v(i+1,k,j)*vel+0.61666667*g_v(i,k,j)*vel+g_vel*(0.61666667*(v(i,k,j)+v(i-1,k,j))-0.13333333*(v(i+1,k,j)+&
&v(i-2,k,j))+0.016666667*(v(i+2,k,j)+v(i-3,k,j)))
        fqx(i,k) = vel*(37./60.*(v(i,k,j)+v(i-1,k,j))-2./15.*(v(i+1,k,j)+v(i-2,k,j))+1./60.*(v(i+2,k,j)+v(i-3,k,j)))
      end do
    end do
    if (degrade_xs) then
      if (i_start .eq. ids+1) then
        i = ids+1
        do k = kts, ktf
          g_fqx(i,k) = 0.25*g_ru(i,k,j-1)*(v(i,k,j)+v(i-1,k,j))+0.25*g_ru(i,k,j)*(v(i,k,j)+v(i-1,k,j))+0.25*g_v(i-1,k,j)*(ru(i,k,j)&
&+ru(i,k,j-1))+0.25*g_v(i,k,j)*(ru(i,k,j)+ru(i,k,j-1))
          fqx(i,k) = 0.25*(ru(i,k,j)+ru(i,k,j-1))*(v(i,k,j)+v(i-1,k,j))
        end do
      endif
      i = ids+2
      do k = kts, ktf
        g_vel = 0.5*g_ru(i,k,j-1)+0.5*g_ru(i,k,j)
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
        g_fqx(i,k) = (-0.083333333)*g_v(i-2,k,j)*vel+0.58333333*g_v(i-1,k,j)*vel-0.083333333*g_v(i+1,k,j)*vel+0.58333333*g_v(i,k,j)&
&*vel+g_vel*(0.58333333*(v(i,k,j)+v(i-1,k,j))-0.083333333*(v(i+1,k,j)+v(i-2,k,j)))
        fqx(i,k) = vel*(7./12.*(v(i,k,j)+v(i-1,k,j))-1./12.*(v(i+1,k,j)+v(i-2,k,j)))
      end do
    endif
    if (degrade_xe) then
      if (i_end .eq. ide-2) then
        i = ide-1
        do k = kts, ktf
          g_fqx(i,k) = 0.25*g_ru(i_end+1,k,j-1)*(v(i_end+1,k,j)+v(i_end,k,j))+0.25*g_ru(i_end+1,k,j)*(v(i_end+1,k,j)+v(i_end,k,j))+&
&0.25*g_v(i_end+1,k,j)*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))+0.25*g_v(i_end,k,j)*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))
          fqx(i,k) = 0.25*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))*(v(i_end+1,k,j)+v(i_end,k,j))
        end do
      endif
      i = ide-2
      do k = kts, ktf
        g_vel = 0.5*g_ru(i,k,j-1)+0.5*g_ru(i,k,j)
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
        g_fqx(i,k) = (-0.083333333)*g_v(i-2,k,j)*vel+0.58333333*g_v(i-1,k,j)*vel-0.083333333*g_v(i+1,k,j)*vel+0.58333333*g_v(i,k,j)&
&*vel+g_vel*(0.58333333*(v(i,k,j)+v(i-1,k,j))-0.083333333*(v(i+1,k,j)+v(i-2,k,j)))
        fqx(i,k) = vel*(7./12.*(v(i,k,j)+v(i-1,k,j))-1./12.*(v(i+1,k,j)+v(i-2,k,j)))
      end do
    endif
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfv(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
else if (horz_order .eq. 5) then horizontal_order_tesu
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-3) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = jte
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = max(jts,jds+1)
    j_start_f = jds+3
  endif
  if (degrade_ye) then
    j_end = min(jte,jde-1)
    j_end_f = jde-2
  endif
  jp1 = 2
  jp0 = 1
  j_loop_y_flux_5: do j = j_start, j_end+1
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
fqy(i,k,jp1) = vel*(37./60.*(v(i,k,j)+v(i,k,j-1))-2./15.*(v(i,k,j+1)+v(i,k,j-2))+1./60.*(v(i,k,j+2)+v(i,k,j-3))-sign(1.,&
&vel)*(1./60.)*(v(i,k,j+2)-v(i,k,j-3)-5.*(v(i,k,j+1)-v(i,k,j-2))+10.*(v(i,k,j)-v(i,k,j-1))))

g_fqy(i,k,jp1) = vel*(g_v(i,k,j-3)*(0.016666667-(-0.016666667)*sign(1.,vel))+g_v(i,k,j-2)*((-0.13333333)-0.083333333*&
&sign(1.,vel))+g_v(i,k,j-1)*(0.61666667-(-0.16666667)*sign(1.,vel))+g_v(i,k,j+2)*(0.016666667-0.016666667*&
&sign(1.,vel))+g_v(i,k,j+1)*((-0.13333333)-(-0.083333333)*sign(1.,vel))+g_v(i,k,j)*(0.61666667-0.16666667*&
&sign(1.,vel))) +0.5*(g_rv(i,k,j-1)+g_rv(i,k,j))*fqy(i,k,jp1)/vel
else
        fqy(i,k,jp1)=0.
        g_fqy(i,k,jp1) =0.5*(g_rv(i,k,j-1)+g_rv(i,k,j))*(37./60.*(v(i,k,j)+v(i,k,j-1))&
&-2./15.*(v(i,k,j+1)+v(i,k,j-2))+1./60.*(v(i,k,j+2)+v(i,k,j-3))-sign(1.,&
&vel)*(1./60.)*(v(i,k,j+2)-v(i,k,j-3)-5.*(v(i,k,j+1)-v(i,k,j-2))+10.*(v(i,k,j)-v(i,k,j-1))))
endif
        end do
      end do
    else if (j .eq. jds+1) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vb = g_v(i,k,j-1)
          vb = v(i,k,j-1)
          if (specified .and. v(i,k,j) .lt. 0.) then
            g_vb = g_v(i,k,j)
            vb = v(i,k,j)
          endif
          g_fqy(i,k,jp1) = 0.25*g_rv(i,k,j-1)*(v(i,k,j)+vb)+0.25*g_rv(i,k,j)*(v(i,k,j)+vb)+0.25*g_v(i,k,j)*(rv(i,k,j)+rv(i,k,j-1))+&
&0.25*g_vb*(rv(i,k,j)+rv(i,k,j-1))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j)+rv(i,k,j-1))*(v(i,k,j)+vb)
        end do
      end do
    else if (j .eq. jds+2) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
fqy(i,k,jp1) = vel*(7./12.*(v(i,k,j)+v(i,k,j-1))-1./12.*(v(i,k,j+1)+v(i,k,j-2))+sign(1.,vel)*(1./12.)*(v(i,k,j+1)-v(i,k,&
&j-2)-3.*(v(i,k,j)-v(i,k,j-1))))

g_fqy(i,k,jp1) = vel*(g_v(i,k,j-2)*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_v(i,k,j-1)*(0.58333333+0.25*sign(1.,&
&vel))+g_v(i,k,j+1)*((-0.083333333)+0.083333333*sign(1.,vel))+g_v(i,k,j)*(0.58333333+(-0.25)*sign(1.,vel)))&
&+0.5*(g_rv(i,k,j-1)+g_rv(i,k,j))*fqy(i,k,jp1)/vel
else
          fqy(i,k,jp1)=0.
          g_fqy(i,k,jp1) =0.5*(g_rv(i,k,j-1)+g_rv(i,k,j))*(7./12.*(v(i,k,j)+v(i,k,j-1))&
&-1./12.*(v(i,k,j+1)+v(i,k,j-2))+sign(1.,vel)*(1./12.)*(v(i,k,j+1)-v(i,k,&
&j-2)-3.*(v(i,k,j)-v(i,k,j-1)))) 
endif
        end do
      end do
    else if (j .eq. jde) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vb = g_v(i,k,j)
          vb = v(i,k,j)
          if (specified .and. v(i,k,j-1) .gt. 0.) then
            g_vb = g_v(i,k,j-1)
            vb = v(i,k,j-1)
          endif
          g_fqy(i,k,jp1) = 0.25*g_rv(i,k,j-1)*(vb+v(i,k,j-1))+0.25*g_rv(i,k,j)*(vb+v(i,k,j-1))+0.25*g_v(i,k,j-1)*(rv(i,k,j)+rv(i,k,&
&j-1))+0.25*g_vb*(rv(i,k,j)+rv(i,k,j-1))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j)+rv(i,k,j-1))*(vb+v(i,k,j-1))
        end do
      end do
    else if (j .eq. jde-1) then
      do k = kts, ktf
        do i = i_start, i_end
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))

!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
          fqy(i,k,jp1) = vel*(7./12.*(v(i,k,j)+v(i,k,j-1))-1./12.*(v(i,k,j+1)+v(i,k,j-2))+sign(1.,vel)*(1./12.)*(v(i,k,j+1)-v(i,k,&
&j-2)-3.*(v(i,k,j)-v(i,k,j-1))))

          g_fqy(i,k,jp1) = vel*(g_v(i,k,j-2)*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_v(i,k,j-1)*(0.58333333+0.25*sign(1.,&
&vel))+g_v(i,k,j+1)*((-0.083333333)+0.083333333*sign(1.,vel))+g_v(i,k,j)*(0.58333333+(-0.25)*sign(1.,vel)))&
&+0.5*(g_rv(i,k,j-1)+g_rv(i,k,j))*fqy(i,k,jp1)/vel
else
          fqy(i,k,jp1)=0.
          g_fqy(i,k,jp1) =0.5*(g_rv(i,k,j-1)+g_rv(i,k,j))*(7./12.*(v(i,k,j)+v(i,k,j-1))&
&-1./12.*(v(i,k,j+1)+v(i,k,j-2))+sign(1.,vel)*(1./12.)*(v(i,k,j+1)-v(i,k,&
&j-2)-3.*(v(i,k,j)-v(i,k,j-1))))
endif
        end do
      end do
    endif
    if (j .gt. j_start) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfv(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do j_loop_y_flux_5
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = jte
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-1,jte)
  endif
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = i_start+2
  endif
  if (degrade_xe) then
    i_end = min(ide-2,ite)
    i_end_f = ide-3
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start_f, i_end_f
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))

!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
fqx(i,k) = vel*(37./60.*(v(i,k,j)+v(i-1,k,j))-2./15.*(v(i+1,k,j)+v(i-2,k,j))+1./60.*(v(i+2,k,j)+v(i-3,k,j))-sign(1.,vel)*&
&(1./60.)*(v(i+2,k,j)-v(i-3,k,j)-5.*(v(i+1,k,j)-v(i-2,k,j))+10.*(v(i,k,j)-v(i-1,k,j))))

        g_fqx(i,k) = vel*(g_v(i-3,k,j)*(0.016666667-(-0.016666667)*sign(1.,vel))+g_v(i-2,k,j)*((-0.13333333)-0.083333333*&
&sign(1.,vel))+g_v(i-1,k,j)*(0.61666667-(-0.16666667)*sign(1.,vel))+g_v(i+2,k,j)*(0.016666667-0.016666667*sign(1.,&
&vel))+g_v(i+1,k,j)*((-0.13333333)-(-0.083333333)*sign(1.,vel))+g_v(i,k,j)*(0.61666667-0.16666667*sign(1.,vel)))+&
&0.5*(g_ru(i,k,j-1)+g_ru(i,k,j))*fqx(i,k)/vel
else
        fqx(i,k)=0.
        g_fqx(i,k) =0.5*(g_ru(i,k,j-1)+g_ru(i,k,j))*(37./60.*(v(i,k,j)+v(i-1,k,j))-2./15.*(v(i+1,k,j)&
&+v(i-2,k,j))+1./60.*(v(i+2,k,j)+v(i-3,k,j))-sign(1.,vel)*&
&(1./60.)*(v(i+2,k,j)-v(i-3,k,j)-5.*(v(i+1,k,j)-v(i-2,k,j))+10.*(v(i,k,j)-v(i-1,k,j))))
endif
      end do
    end do
    if (degrade_xs) then
      if (i_start .eq. ids+1) then
        i = ids+1
        do k = kts, ktf
          g_fqx(i,k) = 0.25*g_ru(i,k,j-1)*(v(i,k,j)+v(i-1,k,j))+0.25*g_ru(i,k,j)*(v(i,k,j)+v(i-1,k,j))+0.25*g_v(i-1,k,j)*(ru(i,k,j)&
&+ru(i,k,j-1))+0.25*g_v(i,k,j)*(ru(i,k,j)+ru(i,k,j-1))
          fqx(i,k) = 0.25*(ru(i,k,j)+ru(i,k,j-1))*(v(i,k,j)+v(i-1,k,j))
        end do
      endif
      i = ids+2
      do k = kts, ktf
        g_vel = 0.5*g_ru(i,k,j-1)+0.5*g_ru(i,k,j)
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
        g_fqx(i,k) = g_v(i-2,k,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_v(i-1,k,j)*vel*(0.58333333+0.25*sign(1.,vel))+&
&g_v(i+1,k,j)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_v(i,k,j)*vel*(0.58333333+(-0.25)*sign(1.,vel))+g_vel*&
&(0.58333333*(v(i,k,j)+v(i-1,k,j))-0.083333333*(v(i+1,k,j)+v(i-2,k,j))+0.083333333*(v(i+1,k,j)-v(i-2,k,j)-3.*(v(i,k,j)-v(i-&
&1,k,j)))*sign(1.,vel))
        fqx(i,k) = vel*(7./12.*(v(i,k,j)+v(i-1,k,j))-1./12.*(v(i+1,k,j)+v(i-2,k,j))+sign(1.,vel)*(1./12.)*(v(i+1,k,j)-v(i-2,k,j)-&
&3.*(v(i,k,j)-v(i-1,k,j))))
      end do
    endif
    if (degrade_xe) then
      if (i_end .eq. ide-2) then
        i = ide-1
        do k = kts, ktf
          g_fqx(i,k) = 0.25*g_ru(i_end+1,k,j-1)*(v(i_end+1,k,j)+v(i_end,k,j))+0.25*g_ru(i_end+1,k,j)*(v(i_end+1,k,j)+v(i_end,k,j))+&
&0.25*g_v(i_end+1,k,j)*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))+0.25*g_v(i_end,k,j)*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))
          fqx(i,k) = 0.25*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))*(v(i_end+1,k,j)+v(i_end,k,j))
        end do
      endif
      i = ide-2
      do k = kts, ktf
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
        fqx(i,k) = vel*(7./12.*(v(i,k,j)+v(i-1,k,j))-1./12.*(v(i+1,k,j)+v(i-2,k,j))+sign(1.,vel)*(1./12.)*(v(i+1,k,j)-v(i-2,k,j)-&
&3.*(v(i,k,j)-v(i-1,k,j))))
        g_fqx(i,k) = vel*(g_v(i-2,k,j)*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_v(i-1,k,j)*(0.58333333+0.25*sign(1.,vel))+&
&g_v(i+1,k,j)*((-0.083333333)+0.083333333*sign(1.,vel))+g_v(i,k,j)*(0.58333333+(-0.25)*sign(1.,vel)))&
&+0.5*(g_ru(i,k,j-1)+g_ru(i,k,j))*fqx(i,k)/vel
else
        fqx(i,k)=0.
        g_fqx(i,k) =0.5*(g_ru(i,k,j-1)+g_ru(i,k,j))*(7./12.*(v(i,k,j)+v(i-1,k,j))&
&-1./12.*(v(i+1,k,j)+v(i-2,k,j))+sign(1.,vel)*(1./12.)*(v(i+1,k,j)-v(i-2,k,j)-&
&3.*(v(i,k,j)-v(i-1,k,j))))
endif
      end do
    endif
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfv(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
else if (horz_order .eq. 4) then horizontal_order_tesu
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-1) then
    degrade_ye =  .false. 
  endif
  ktf = min(kte,kde-1)
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = jte
  if (degrade_ys) then
    j_start = jds+1
  endif
  if (degrade_ye) then
    j_end = jde-1
  endif
  jp0 = 1
  jp1 = 2
  do j = j_start, j_end+1
    if (j .eq. j_start .and. degrade_ys) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vb = g_v(i,k,j-1)
          vb = v(i,k,j-1)
          if (specified .and. v(i,k,j) .lt. 0.) then
            g_vb = g_v(i,k,j)
            vb = v(i,k,j)
          endif
          g_fqy(i,k,jp1) = 0.25*g_rv(i,k,j-1)*(v(i,k,j)+vb)+0.25*g_rv(i,k,j)*(v(i,k,j)+vb)+0.25*g_v(i,k,j)*(rv(i,k,j)+rv(i,k,j-1))+&
&0.25*g_vb*(rv(i,k,j)+rv(i,k,j-1))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j)+rv(i,k,j-1))*(v(i,k,j)+vb)
        end do
      end do
    else if (j .eq. j_end+1 .and. degrade_ye) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vb = g_v(i,k,j)
          vb = v(i,k,j)
          if (specified .and. v(i,k,j-1) .gt. 0.) then
            g_vb = g_v(i,k,j-1)
            vb = v(i,k,j-1)
          endif
          g_fqy(i,k,jp1) = 0.25*g_rv(i,k,j-1)*(vb+v(i,k,j-1))+0.25*g_rv(i,k,j)*(vb+v(i,k,j-1))+0.25*g_v(i,k,j-1)*(rv(i,k,j)+rv(i,k,&
&j-1))+0.25*g_vb*(rv(i,k,j)+rv(i,k,j-1))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j)+rv(i,k,j-1))*(vb+v(i,k,j-1))
        end do
      end do
    else
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = 0.5*g_rv(i,k,j-1)+0.5*g_rv(i,k,j)
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
          g_fqy(i,k,jp1) = (-0.083333333)*g_v(i,k,j-2)*vel+0.58333333*g_v(i,k,j-1)*vel-0.083333333*g_v(i,k,j+1)*vel+0.58333333*&
&g_v(i,k,j)*vel+g_vel*(0.58333333*(v(i,k,j)+v(i,k,j-1))-0.083333333*(v(i,k,j+1)+v(i,k,j-2)))
          fqy(i,k,jp1) = vel*(7./12.*(v(i,k,j)+v(i,k,j-1))-1./12.*(v(i,k,j+1)+v(i,k,j-2)))
        end do
      end do
    endif
    if (j .gt. j_start) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfv(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = jte
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-1,jte)
  endif
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
  if (degrade_xe) then
    i_end = ide-2
    i_end_f = ide-2
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start_f, i_end_f
        g_vel = 0.5*g_ru(i,k,j-1)+0.5*g_ru(i,k,j)
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
        g_fqx(i,k) = (-0.083333333)*g_v(i-2,k,j)*vel+0.58333333*g_v(i-1,k,j)*vel-0.083333333*g_v(i+1,k,j)*vel+0.58333333*g_v(i,k,j)&
&*vel+g_vel*(0.58333333*(v(i,k,j)+v(i-1,k,j))-0.083333333*(v(i+1,k,j)+v(i-2,k,j)))
        fqx(i,k) = vel*(7./12.*(v(i,k,j)+v(i-1,k,j))-1./12.*(v(i+1,k,j)+v(i-2,k,j)))
      end do
    end do
    if (degrade_xs) then
      do k = kts, ktf
        g_fqx(i_start,k) = 0.25*g_ru(i_start,k,j-1)*(v(i_start,k,j)+v(i_start-1,k,j))+0.25*g_ru(i_start,k,j)*(v(i_start,k,j)+&
&v(i_start-1,k,j))+0.25*g_v(i_start-1,k,j)*(ru(i_start,k,j)+ru(i_start,k,j-1))+0.25*g_v(i_start,k,j)*(ru(i_start,k,j)+&
&ru(i_start,k,j-1))
        fqx(i_start,k) = 0.25*(ru(i_start,k,j)+ru(i_start,k,j-1))*(v(i_start,k,j)+v(i_start-1,k,j))
      end do
    endif
    if (degrade_xe) then
      do k = kts, ktf
        g_fqx(i_end+1,k) = 0.25*g_ru(i_end+1,k,j-1)*(v(i_end+1,k,j)+v(i_end,k,j))+0.25*g_ru(i_end+1,k,j)*(v(i_end+1,k,j)+v(i_end,k,&
&j))+0.25*g_v(i_end+1,k,j)*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))+0.25*g_v(i_end,k,j)*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))
        fqx(i_end+1,k) = 0.25*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))*(v(i_end+1,k,j)+v(i_end,k,j))
      end do
    endif
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfv(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
else if (horz_order .eq. 3) then horizontal_order_tesu
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-1) then
    degrade_ye =  .false. 
  endif
  ktf = min(kte,kde-1)
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = jte
  if (degrade_ys) then
    j_start = jds+1
  endif
  if (degrade_ye) then
    j_end = jde-1
  endif
  jp0 = 1
  jp1 = 2
  do j = j_start, j_end+1
    if (j .eq. j_start .and. degrade_ys) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vb = g_v(i,k,j-1)
          vb = v(i,k,j-1)
          if (specified .and. v(i,k,j) .lt. 0.) then
            g_vb = g_v(i,k,j)
            vb = v(i,k,j)
          endif
          g_fqy(i,k,jp1) = 0.25*g_rv(i,k,j-1)*(v(i,k,j)+vb)+0.25*g_rv(i,k,j)*(v(i,k,j)+vb)+0.25*g_v(i,k,j)*(rv(i,k,j)+rv(i,k,j-1))+&
&0.25*g_vb*(rv(i,k,j)+rv(i,k,j-1))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j)+rv(i,k,j-1))*(v(i,k,j)+vb)
        end do
      end do
    else if (j .eq. j_end+1 .and. degrade_ye) then
      do k = kts, ktf
        do i = i_start, i_end
          g_vb = g_v(i,k,j)
          vb = v(i,k,j)
          if (specified .and. v(i,k,j-1) .gt. 0.) then
            g_vb = g_v(i,k,j-1)
            vb = v(i,k,j-1)
          endif
          g_fqy(i,k,jp1) = 0.25*g_rv(i,k,j-1)*(vb+v(i,k,j-1))+0.25*g_rv(i,k,j)*(vb+v(i,k,j-1))+0.25*g_v(i,k,j-1)*(rv(i,k,j)+rv(i,k,&
&j-1))+0.25*g_vb*(rv(i,k,j)+rv(i,k,j-1))
          fqy(i,k,jp1) = 0.25*(rv(i,k,j)+rv(i,k,j-1))*(vb+v(i,k,j-1))
        end do
      end do
    else
      do k = kts, ktf
        do i = i_start, i_end
          g_vel = 0.5*g_rv(i,k,j-1)+0.5*g_rv(i,k,j)
          vel = 0.5*(rv(i,k,j)+rv(i,k,j-1))
          g_fqy(i,k,jp1) = g_v(i,k,j-2)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_v(i,k,j-1)*vel*(0.58333333+0.25*sign(1.,&
&vel))+g_v(i,k,j+1)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_v(i,k,j)*vel*(0.58333333+(-0.25)*sign(1.,vel))+g_vel*&
&(0.58333333*(v(i,k,j)+v(i,k,j-1))-0.083333333*(v(i,k,j+1)+v(i,k,j-2))+0.083333333*(v(i,k,j+1)-v(i,k,j-2)-3.*(v(i,k,j)-&
&v(i,k,j-1)))*sign(1.,vel))
          fqy(i,k,jp1) = vel*(7./12.*(v(i,k,j)+v(i,k,j-1))-1./12.*(v(i,k,j+1)+v(i,k,j-2))+sign(1.,vel)*(1./12.)*(v(i,k,j+1)-v(i,k,&
&j-2)-3.*(v(i,k,j)-v(i,k,j-1))))
        end do
      end do
    endif
    if (j .gt. j_start) then
      do k = kts, ktf
        do i = i_start, i_end
          mrdy = msfv(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = jte
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-1,jte)
  endif
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
  if (degrade_xe) then
    i_end = ide-2
    i_end_f = ide-2
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start_f, i_end_f
        g_vel = 0.5*g_ru(i,k,j-1)+0.5*g_ru(i,k,j)
        vel = 0.5*(ru(i,k,j)+ru(i,k,j-1))
        g_fqx(i,k) = g_v(i-2,k,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_v(i-1,k,j)*vel*(0.58333333+0.25*sign(1.,vel))+&
&g_v(i+1,k,j)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_v(i,k,j)*vel*(0.58333333+(-0.25)*sign(1.,vel))+g_vel*&
&(0.58333333*(v(i,k,j)+v(i-1,k,j))-0.083333333*(v(i+1,k,j)+v(i-2,k,j))+0.083333333*(v(i+1,k,j)-v(i-2,k,j)-3.*(v(i,k,j)-v(i-&
&1,k,j)))*sign(1.,vel))
        fqx(i,k) = vel*(7./12.*(v(i,k,j)+v(i-1,k,j))-1./12.*(v(i+1,k,j)+v(i-2,k,j))+sign(1.,vel)*(1./12.)*(v(i+1,k,j)-v(i-2,k,j)-&
&3.*(v(i,k,j)-v(i-1,k,j))))
      end do
    end do
    if (degrade_xs) then
      do k = kts, ktf
        g_fqx(i_start,k) = 0.25*g_ru(i_start,k,j-1)*(v(i_start,k,j)+v(i_start-1,k,j))+0.25*g_ru(i_start,k,j)*(v(i_start,k,j)+&
&v(i_start-1,k,j))+0.25*g_v(i_start-1,k,j)*(ru(i_start,k,j)+ru(i_start,k,j-1))+0.25*g_v(i_start,k,j)*(ru(i_start,k,j)+&
&ru(i_start,k,j-1))
        fqx(i_start,k) = 0.25*(ru(i_start,k,j)+ru(i_start,k,j-1))*(v(i_start,k,j)+v(i_start-1,k,j))
      end do
    endif
    if (degrade_xe) then
      do k = kts, ktf
        g_fqx(i_end+1,k) = 0.25*g_ru(i_end+1,k,j-1)*(v(i_end+1,k,j)+v(i_end,k,j))+0.25*g_ru(i_end+1,k,j)*(v(i_end+1,k,j)+v(i_end,k,&
&j))+0.25*g_v(i_end+1,k,j)*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))+0.25*g_v(i_end,k,j)*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))
        fqx(i_end+1,k) = 0.25*(ru(i_end+1,k,j)+ru(i_end+1,k,j-1))*(v(i_end+1,k,j)+v(i_end,k,j))
      end do
    endif
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfv(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
else if (horz_order .eq. 2) then horizontal_order_tesu
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = jte
  if (config_flags%open_ys) then
    j_start = max(jds+1,jts)
  endif
  if (config_flags%open_ye) then
    j_end = min(jde-1,jte)
  endif
  if (specified) then
    j_start = max(jds+2,jts)
  endif
  if (specified) then
    j_end = min(jde-2,jte)
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdy = msfv(i,j)*rdy
        g_tendency(i,k,j) = 0.25*g_rv(i,k,j-1)*mrdy*(v(i,k,j)+v(i,k,j-1))-0.25*g_rv(i,k,j+1)*mrdy*(v(i,k,j+1)+v(i,k,j))-0.25*&
&g_rv(i,k,j)*mrdy*(v(i,k,j+1)+v(i,k,j)-(v(i,k,j)+v(i,k,j-1)))+g_tendency(i,k,j)+0.25*g_v(i,k,j-1)*mrdy*(rv(i,k,j)+rv(i,k,j-&
&1))-0.25*g_v(i,k,j+1)*mrdy*(rv(i,k,j+1)+rv(i,k,j))-0.25*g_v(i,k,j)*mrdy*(rv(i,k,j+1)+rv(i,k,j)-(rv(i,k,j)+rv(i,k,j-1)))
        tendency(i,k,j) = tendency(i,k,j)-mrdy*0.25*((rv(i,k,j+1)+rv(i,k,j))*(v(i,k,j+1)+v(i,k,j))-(rv(i,k,j)+rv(i,k,j-1))*(v(i,k,&
&j)+v(i,k,j-1)))
      end do
    end do
  end do
  if (specified .and. jts .le. jds+1) then
    j = jds+1
    do k = kts, ktf
      do i = i_start, i_end
        mrdy = msfv(i,j)*rdy
        g_vb = g_v(i,k,j-1)
        vb = v(i,k,j-1)
        if (v(i,k,j) .lt. 0.) then
          g_vb = g_v(i,k,j)
          vb = v(i,k,j)
        endif
        g_tendency(i,k,j) = 0.25*g_rv(i,k,j-1)*mrdy*(v(i,k,j)+vb)-0.25*g_rv(i,k,j+1)*mrdy*(v(i,k,j+1)+v(i,k,j))-0.25*g_rv(i,k,j)*&
&mrdy*(v(i,k,j+1)+v(i,k,j)-(v(i,k,j)+vb))+g_tendency(i,k,j)-0.25*g_v(i,k,j+1)*mrdy*(rv(i,k,j+1)+rv(i,k,j))-0.25*g_v(i,k,j)*&
&mrdy*(rv(i,k,j+1)+rv(i,k,j)-(rv(i,k,j)+rv(i,k,j-1)))+0.25*g_vb*mrdy*(rv(i,k,j)+rv(i,k,j-1))
        tendency(i,k,j) = tendency(i,k,j)-mrdy*0.25*((rv(i,k,j+1)+rv(i,k,j))*(v(i,k,j+1)+v(i,k,j))-(rv(i,k,j)+rv(i,k,j-1))*(v(i,k,&
&j)+vb))
      end do
    end do
  endif
  if (specified .and. jte .ge. jde-1) then
    j = jde-1
    do k = kts, ktf
      do i = i_start, i_end
        mrdy = msfv(i,j)*rdy
        g_vb = g_v(i,k,j+1)
        vb = v(i,k,j+1)
        if (v(i,k,j) .gt. 0.) then
          g_vb = g_v(i,k,j)
          vb = v(i,k,j)
        endif
        g_tendency(i,k,j) = 0.25*g_rv(i,k,j-1)*mrdy*(v(i,k,j)+v(i,k,j-1))-0.25*g_rv(i,k,j+1)*mrdy*(vb+v(i,k,j))-0.25*g_rv(i,k,j)*&
&mrdy*(vb+v(i,k,j)-(v(i,k,j)+v(i,k,j-1)))+g_tendency(i,k,j)+0.25*g_v(i,k,j-1)*mrdy*(rv(i,k,j)+rv(i,k,j-1))-0.25*g_v(i,k,j)*&
&mrdy*(rv(i,k,j+1)+rv(i,k,j)-(rv(i,k,j)+rv(i,k,j-1)))-0.25*g_vb*mrdy*(rv(i,k,j+1)+rv(i,k,j))
        tendency(i,k,j) = tendency(i,k,j)-mrdy*0.25*((rv(i,k,j+1)+rv(i,k,j))*(vb+v(i,k,j))-(rv(i,k,j)+rv(i,k,j-1))*(v(i,k,j)+v(i,k,&
&j-1)))
      end do
    end do
  endif
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-2,ite)
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mrdx = msfv(i,j)*rdx
        g_tendency(i,k,j) = (-(0.25*g_ru(i+1,k,j-1)*mrdx*(v(i+1,k,j)+v(i,k,j))))+0.25*g_ru(i,k,j-1)*mrdx*(v(i,k,j)+v(i-1,k,j))-&
&0.25*g_ru(i+1,k,j)*mrdx*(v(i+1,k,j)+v(i,k,j))+0.25*g_ru(i,k,j)*mrdx*(v(i,k,j)+v(i-1,k,j))+g_tendency(i,k,j)+0.25*g_v(i-1,&
&k,j)*mrdx*(ru(i,k,j)+ru(i,k,j-1))-0.25*g_v(i+1,k,j)*mrdx*(ru(i+1,k,j)+ru(i+1,k,j-1))-0.25*g_v(i,k,j)*mrdx*(ru(i+1,k,j)+&
&ru(i+1,k,j-1)-(ru(i,k,j)+ru(i,k,j-1)))
        tendency(i,k,j) = tendency(i,k,j)-mrdx*0.25*((ru(i+1,k,j)+ru(i+1,k,j-1))*(v(i+1,k,j)+v(i,k,j))-(ru(i,k,j)+ru(i,k,j-1))*&
&(v(i,k,j)+v(i-1,k,j)))
      end do
    end do
  end do
else horizontal_order_tesu
  write(unit=wrf_err_message,fmt=*) 'module_advect: advect_v_6a: h_order not known ',horz_order
endif horizontal_order_tesu
if (config_flags%open_ys .and. jts .eq. jds) then
  i_start = its
  i_end = min(ite,ide-1)
  do i = i_start, i_end
    do k = kts, ktf
      g_vb = (-(g_mut(i,jts)*(0.5+sign(0.5,0.-(rv(i,k,jts)-cb*mut(i,jts))))*cb))+g_rv(i,k,jts)*(0.5+sign(0.5,0.-(rv(i,k,jts)-cb*&
&mut(i,jts))))
      vb = min(rv(i,k,jts)-cb*mut(i,jts),0.)
      g_tendency(i,k,jts) = g_tendency(i,k,jts)-g_v_old(i,k,jts+1)*rdy*vb+g_v_old(i,k,jts)*rdy*vb-g_vb*rdy*(v_old(i,k,jts+1)-&
&v_old(i,k,jts))
      tendency(i,k,jts) = tendency(i,k,jts)-rdy*vb*(v_old(i,k,jts+1)-v_old(i,k,jts))
    end do
  end do
endif
if (config_flags%open_ye .and. jte .eq. jde) then
  i_start = its
  i_end = min(ite,ide-1)
  do i = i_start, i_end
    do k = kts, ktf
      g_vb = g_mut(i,jte-1)*(0.5+sign(0.5,rv(i,k,jte)+cb*mut(i,jte-1)-0.))*cb+g_rv(i,k,jte)*(0.5+sign(0.5,rv(i,k,jte)+cb*mut(i,jte-&
&1)-0.))
      vb = max(rv(i,k,jte)+cb*mut(i,jte-1),0.)
      g_tendency(i,k,jte) = g_tendency(i,k,jte)+g_v_old(i,k,jte-1)*rdy*vb-g_v_old(i,k,jte)*rdy*vb-g_vb*rdy*(v_old(i,k,jte)-v_old(i,&
&k,jte-1))
      tendency(i,k,jte) = tendency(i,k,jte)-rdy*vb*(v_old(i,k,jte)-v_old(i,k,jte-1))
    end do
  end do
endif
j_start = jts
j_end = min(jte,jde)
jmin = jds
jmax = jde-1
if (config_flags%open_ys) then
  j_start = max(jds+1,jts)
  jmin = jds
endif
if (config_flags%open_ye) then
  j_end = min(jte,jde-1)
  jmax = jde-1
endif
if (config_flags%open_xs .and. its .eq. ids) then
  do j = j_start, j_end
    mrdx = msfv(its,j)*rdx
    jp = min(jmax,j)
    jm = max(jmin,j-1)
    do k = kts, ktf
      g_uw = 0.5*g_ru(its,k,jm)+0.5*g_ru(its,k,jp)
      uw = 0.5*(ru(its,k,jp)+ru(its,k,jm))
      g_ub = g_uw*(0.5+sign(0.5,0.-uw))
      ub = min(uw,0.)
      g_dup = g_ru(its+1,k,jp)-g_ru(its,k,jp)
      dup = ru(its+1,k,jp)-ru(its,k,jp)
      g_dum = g_ru(its+1,k,jm)-g_ru(its,k,jm)
      dum = ru(its+1,k,jm)-ru(its,k,jm)
      g_tendency(its,k,j) = (-(0.5*g_dum*mrdx*v(its,k,j)))-0.5*g_dup*mrdx*v(its,k,j)+g_tendency(its,k,j)-g_ub*mrdx*(v_old(its+1,k,&
&j)-v_old(its,k,j))-0.5*g_v(its,k,j)*mrdx*(dup+dum)-g_v_old(its+1,k,j)*mrdx*ub+g_v_old(its,k,j)*mrdx*ub
      tendency(its,k,j) = tendency(its,k,j)-mrdx*(ub*(v_old(its+1,k,j)-v_old(its,k,j))+0.5*v(its,k,j)*(dup+dum))
    end do
  end do
endif
if (config_flags%open_xe .and. ite .eq. ide) then
  do j = j_start, j_end
    mrdx = msfv(ite-1,j)*rdx
    jp = min(jmax,j)
    jm = max(jmin,j-1)
    do k = kts, ktf
      g_uw = 0.5*g_ru(ite,k,jm)+0.5*g_ru(ite,k,jp)
      uw = 0.5*(ru(ite,k,jp)+ru(ite,k,jm))
      g_ub = g_uw*(0.5+sign(0.5,uw-0.))
      ub = max(uw,0.)
      g_dup = (-g_ru(ite-1,k,jp))+g_ru(ite,k,jp)
      dup = ru(ite,k,jp)-ru(ite-1,k,jp)
      g_dum = (-g_ru(ite-1,k,jm))+g_ru(ite,k,jm)
      dum = ru(ite,k,jm)-ru(ite-1,k,jm)
      g_tendency(ite-1,k,j) = (-(0.5*g_dum*mrdx*v(ite-1,k,j)))-0.5*g_dup*mrdx*v(ite-1,k,j)+g_tendency(ite-1,k,j)-g_ub*mrdx*&
&(v_old(ite-1,k,j)-v_old(ite-2,k,j))-0.5*g_v(ite-1,k,j)*mrdx*(dup+dum)+g_v_old(ite-2,k,j)*mrdx*ub-g_v_old(ite-1,k,j)*mrdx*ub
      tendency(ite-1,k,j) = tendency(ite-1,k,j)-mrdx*(ub*(v_old(ite-1,k,j)-v_old(ite-2,k,j))+0.5*v(ite-1,k,j)*(dup+dum))
    end do
  end do
endif
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = jte
do i = i_start, i_end
  g_vflux(i,kts) = 0.
  vflux(i,kts) = 0.
  g_vflux(i,kte) = 0.
  vflux(i,kte) = 0.
end do
if (config_flags%open_ys .or. specified) then
  j_start = max(jds+1,jts)
endif
if (config_flags%open_ye .or. specified) then
  j_end = min(jde-1,jte)
endif
vert_order_tesu: if (vert_order .eq. 6) then
  do j = j_start, j_end
    do k = kts+3, ktf-2
      do i = i_start, i_end
        g_vel = 0.5*g_rom(i,k,j-1)+0.5*g_rom(i,k,j)
        vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
        g_vflux(i,k) = 0.016666667*g_v(i,k-3,j)*vel-0.13333333*g_v(i,k-2,j)*vel+0.61666667*g_v(i,k-1,j)*vel+0.016666667*g_v(i,k+2,&
&j)*vel-0.13333333*g_v(i,k+1,j)*vel+0.61666667*g_v(i,k,j)*vel+g_vel*(0.61666667*(v(i,k,j)+v(i,k-1,j))-0.13333333*(v(i,k+1,&
&j)+v(i,k-2,j))+0.016666667*(v(i,k+2,j)+v(i,k-3,j)))
        vflux(i,k) = vel*(37./60.*(v(i,k,j)+v(i,k-1,j))-2./15.*(v(i,k+1,j)+v(i,k-2,j))+1./60.*(v(i,k+2,j)+v(i,k-3,j)))
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = 0.5*g_rom(i,k,j-1)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+&
&0.5*g_v(i,k-1,j)*(rom(i,k,j)+rom(i,k,j-1))*fzp(k)+0.5*g_v(i,k,j)*(rom(i,k,j)+rom(i,k,j-1))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i,k,j-1))*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))
      k = kts+2
      g_vel = 0.5*g_rom(i,k,j-1)+0.5*g_rom(i,k,j)
      vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
      g_vflux(i,k) = (-0.083333333)*g_v(i,k-2,j)*vel+0.58333333*g_v(i,k-1,j)*vel-0.083333333*g_v(i,k+1,j)*vel+0.58333333*g_v(i,k,j)&
&*vel+g_vel*(0.58333333*(v(i,k,j)+v(i,k-1,j))-0.083333333*(v(i,k+1,j)+v(i,k-2,j)))
      vflux(i,k) = vel*(7./12.*(v(i,k,j)+v(i,k-1,j))-1./12.*(v(i,k+1,j)+v(i,k-2,j)))
      k = ktf-1
      g_vel = 0.5*g_rom(i,k,j-1)+0.5*g_rom(i,k,j)
      vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
      g_vflux(i,k) = (-0.083333333)*g_v(i,k-2,j)*vel+0.58333333*g_v(i,k-1,j)*vel-0.083333333*g_v(i,k+1,j)*vel+0.58333333*g_v(i,k,j)&
&*vel+g_vel*(0.58333333*(v(i,k,j)+v(i,k-1,j))-0.083333333*(v(i,k+1,j)+v(i,k-2,j)))
      vflux(i,k) = vel*(7./12.*(v(i,k,j)+v(i,k-1,j))-1./12.*(v(i,k+1,j)+v(i,k-2,j)))
      k = ktf
      g_vflux(i,k) = 0.5*g_rom(i,k,j-1)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+&
&0.5*g_v(i,k-1,j)*(rom(i,k,j)+rom(i,k,j-1))*fzp(k)+0.5*g_v(i,k,j)*(rom(i,k,j)+rom(i,k,j-1))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i,k,j-1))*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else if (vert_order .eq. 5) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+3, ktf-2
      do i = i_start, i_end
        g_vel = 0.5*g_rom(i,k,j-1)+0.5*g_rom(i,k,j)
        vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
        g_vflux(i,k) = g_v(i,k-3,j)*vel*(0.016666667-(-0.016666667)*sign(1.,-vel))+g_v(i,k-2,j)*vel*((-0.13333333)-0.083333333*&
&sign(1.,-vel))+g_v(i,k-1,j)*vel*(0.61666667-(-0.16666667)*sign(1.,-vel))+g_v(i,k+2,j)*vel*(0.016666667-0.016666667*&
&sign(1.,-vel))+g_v(i,k+1,j)*vel*((-0.13333333)-(-0.083333333)*sign(1.,-vel))+g_v(i,k,j)*vel*(0.61666667-0.16666667*&
&sign(1.,-vel))+g_vel*(0.61666667*(v(i,k,j)+v(i,k-1,j))-0.13333333*(v(i,k+1,j)+v(i,k-2,j))+0.016666667*(v(i,k+2,j)+v(i,k-3,&
&j))-0.016666667*(v(i,k+2,j)-v(i,k-3,j)-5.*(v(i,k+1,j)-v(i,k-2,j))+10.*(v(i,k,j)-v(i,k-1,j)))*sign(1.,-vel))
        vflux(i,k) = vel*(37./60.*(v(i,k,j)+v(i,k-1,j))-2./15.*(v(i,k+1,j)+v(i,k-2,j))+1./60.*(v(i,k+2,j)+v(i,k-3,j))-sign(1.,-vel)&
&*(1./60.)*(v(i,k+2,j)-v(i,k-3,j)-5.*(v(i,k+1,j)-v(i,k-2,j))+10.*(v(i,k,j)-v(i,k-1,j))))
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = 0.5*g_rom(i,k,j-1)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+&
&0.5*g_v(i,k-1,j)*(rom(i,k,j)+rom(i,k,j-1))*fzp(k)+0.5*g_v(i,k,j)*(rom(i,k,j)+rom(i,k,j-1))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i,k,j-1))*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))
      k = kts+2
      g_vel = 0.5*g_rom(i,k,j-1)+0.5*g_rom(i,k,j)
      vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
      g_vflux(i,k) = g_v(i,k-2,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,-vel))+g_v(i,k-1,j)*vel*(0.58333333+0.25*sign(1.,-vel)&
&)+g_v(i,k+1,j)*vel*((-0.083333333)+0.083333333*sign(1.,-vel))+g_v(i,k,j)*vel*(0.58333333+(-0.25)*sign(1.,-vel))+g_vel*&
&(0.58333333*(v(i,k,j)+v(i,k-1,j))-0.083333333*(v(i,k+1,j)+v(i,k-2,j))+0.083333333*(v(i,k+1,j)-v(i,k-2,j)-3.*(v(i,k,j)-v(i,k-&
&1,j)))*sign(1.,-vel))
      vflux(i,k) = vel*(7./12.*(v(i,k,j)+v(i,k-1,j))-1./12.*(v(i,k+1,j)+v(i,k-2,j))+sign(1.,-vel)*(1./12.)*(v(i,k+1,j)-v(i,k-2,j)-&
&3.*(v(i,k,j)-v(i,k-1,j))))
      k = ktf-1
      g_vel = 0.5*g_rom(i,k,j-1)+0.5*g_rom(i,k,j)
      vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
      g_vflux(i,k) = g_v(i,k-2,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,-vel))+g_v(i,k-1,j)*vel*(0.58333333+0.25*sign(1.,-vel)&
&)+g_v(i,k+1,j)*vel*((-0.083333333)+0.083333333*sign(1.,-vel))+g_v(i,k,j)*vel*(0.58333333+(-0.25)*sign(1.,-vel))+g_vel*&
&(0.58333333*(v(i,k,j)+v(i,k-1,j))-0.083333333*(v(i,k+1,j)+v(i,k-2,j))+0.083333333*(v(i,k+1,j)-v(i,k-2,j)-3.*(v(i,k,j)-v(i,k-&
&1,j)))*sign(1.,-vel))
      vflux(i,k) = vel*(7./12.*(v(i,k,j)+v(i,k-1,j))-1./12.*(v(i,k+1,j)+v(i,k-2,j))+sign(1.,-vel)*(1./12.)*(v(i,k+1,j)-v(i,k-2,j)-&
&3.*(v(i,k,j)-v(i,k-1,j))))
      k = ktf
      g_vflux(i,k) = 0.5*g_rom(i,k,j-1)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+&
&0.5*g_v(i,k-1,j)*(rom(i,k,j)+rom(i,k,j-1))*fzp(k)+0.5*g_v(i,k,j)*(rom(i,k,j)+rom(i,k,j-1))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i,k,j-1))*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else if (vert_order .eq. 4) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+2, ktf-1
      do i = i_start, i_end
        g_vel = 0.5*g_rom(i,k,j-1)+0.5*g_rom(i,k,j)
        vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
        g_vflux(i,k) = (-0.083333333)*g_v(i,k-2,j)*vel+0.58333333*g_v(i,k-1,j)*vel-0.083333333*g_v(i,k+1,j)*vel+0.58333333*g_v(i,k,&
&j)*vel+g_vel*(0.58333333*(v(i,k,j)+v(i,k-1,j))-0.083333333*(v(i,k+1,j)+v(i,k-2,j)))
        vflux(i,k) = vel*(7./12.*(v(i,k,j)+v(i,k-1,j))-1./12.*(v(i,k+1,j)+v(i,k-2,j)))
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = 0.5*g_rom(i,k,j-1)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+&
&0.5*g_v(i,k-1,j)*(rom(i,k,j)+rom(i,k,j-1))*fzp(k)+0.5*g_v(i,k,j)*(rom(i,k,j)+rom(i,k,j-1))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i,k,j-1))*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))
      k = ktf
      g_vflux(i,k) = 0.5*g_rom(i,k,j-1)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+&
&0.5*g_v(i,k-1,j)*(rom(i,k,j)+rom(i,k,j-1))*fzp(k)+0.5*g_v(i,k,j)*(rom(i,k,j)+rom(i,k,j-1))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i,k,j-1))*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else if (vert_order .eq. 3) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+2, ktf-1
      do i = i_start, i_end
        vel = 0.5*(rom(i,k,j)+rom(i,k,j-1))
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
        vflux(i,k) = vel*(7./12.*(v(i,k,j)+v(i,k-1,j))-1./12.*(v(i,k+1,j)+v(i,k-2,j))+sign(1.,-vel)*(1./12.)*(v(i,k+1,j)-v(i,k-2,j)&
&-3.*(v(i,k,j)-v(i,k-1,j))))
        g_vflux(i,k) = vel*(g_v(i,k-2,j)*((-0.083333333)+(-0.083333333)*sign(1.,-vel))+g_v(i,k-1,j)*(0.58333333+0.25*sign(1.,-&
&vel))+g_v(i,k+1,j)*((-0.083333333)+0.083333333*sign(1.,-vel))+g_v(i,k,j)*(0.58333333+(-0.25)*sign(1.,-vel)))&
&+0.5*(g_rom(i,k,j-1)+g_rom(i,k,j))*vflux(i,k)/vel
else
        vflux(i,k)=0.
        g_vflux(i,k) =0.5*(g_rom(i,k,j-1)+g_rom(i,k,j))*(7./12.*(v(i,k,j)+v(i,k-1,j))-1./12.*(v(i,k+1,j)+v(i,k-2,j))&
&+sign(1.,-vel)*(1./12.)*(v(i,k+1,j)-v(i,k-2,j)&
&-3.*(v(i,k,j)-v(i,k-1,j))))
endif
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = 0.5*g_rom(i,k,j-1)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+&
&0.5*g_v(i,k-1,j)*(rom(i,k,j)+rom(i,k,j-1))*fzp(k)+0.5*g_v(i,k,j)*(rom(i,k,j)+rom(i,k,j-1))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i,k,j-1))*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))
      k = ktf
      g_vflux(i,k) = 0.5*g_rom(i,k,j-1)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+&
&0.5*g_v(i,k-1,j)*(rom(i,k,j)+rom(i,k,j-1))*fzp(k)+0.5*g_v(i,k,j)*(rom(i,k,j)+rom(i,k,j-1))*fzm(k)
      vflux(i,k) = 0.5*(rom(i,k,j)+rom(i,k,j-1))*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
else if (vert_order .eq. 2) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+1, ktf
      do i = i_start, i_end
        g_vflux(i,k) = 0.5*g_rom(i,k,j-1)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+0.5*g_rom(i,k,j)*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))+&
&0.5*g_v(i,k-1,j)*(rom(i,k,j)+rom(i,k,j-1))*fzp(k)+0.5*g_v(i,k,j)*(rom(i,k,j)+rom(i,k,j-1))*fzm(k)
        vflux(i,k) = 0.5*(rom(i,k,j)+rom(i,k,j-1))*(fzm(k)*v(i,k,j)+fzp(k)*v(i,k-1,j))
      end do
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzw(k)+g_vflux(i,k)*rdzw(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzw(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
  end do
endif vert_order_tesu

   call trace_exit("g_advect_v")

end subroutine g_advect_v


subroutine g_advect_w( w, g_w, w_old, g_w_old, tendency, g_tendency, ru, g_ru, rv, g_rv, rom, g_rom, config_flags, msft, fzm, fzp, &
&rdx, rdy, rdzu, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_rom(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_w_old(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: rdzu(kms:kme)
real, intent(in) :: rom(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w_old(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
logical degrade_xe
logical degrade_xs
logical degrade_ye
logical degrade_ys
real fqx(its:ite+1,kts:kte)
real fqy(its:ite,kts:kte,2)
real g_fqx(its:ite+1,kts:kte)
real g_fqy(its:ite,kts:kte,2)
real g_ub
real g_uw
real g_vb
real g_vel
real g_vflux(its:ite,kts:kte)
real g_vw
integer horz_order
integer i
integer i_end
integer i_end_f
integer i_start
integer i_start_f
integer j
integer j_end
integer j_end_f
integer j_start
integer j_start_f
integer jp0
integer jp1
integer jtmp
integer k
integer ktf
real mrdx
real mrdy
logical specified
real ub
real uw
real vb
real vel
integer vert_order
real vflux(its:ite,kts:kte)
real vw
real walls(4)

   call trace_entry("g_advect_w")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
ktf = min(kte,kde-1)
horz_order = config_flags%h_sca_adv_order
vert_order = config_flags%v_sca_adv_order
horizontal_order_tesu: if (horz_order .eq. 6) then
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-3) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-3) then
    degrade_ye =  .false. 
  endif
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = max(jts,jds+1)
    j_start_f = jds+3
  endif
  if (degrade_ye) then
    j_end = min(jte,jde-2)
    j_end_f = jde-3
  endif
  jp1 = 2
  jp0 = 1
  j_loop_y_flux_6: do j = j_start, j_end+1
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts+1, ktf
        do i = i_start, i_end
          g_vel = g_rv(i,k-1,j)*fzp(k)+g_rv(i,k,j)*fzm(k)
          vel = fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
          g_fqy(i,k,jp1) = g_vel*(0.61666667*(w(i,k,j)+w(i,k,j-1))-0.13333333*(w(i,k,j+1)+w(i,k,j-2))+0.016666667*(w(i,k,j+2)+w(i,&
&k,j-3)))+0.016666667*g_w(i,k,j-3)*vel-0.13333333*g_w(i,k,j-2)*vel+0.61666667*g_w(i,k,j-1)*vel+0.016666667*g_w(i,k,j+2)*&
&vel-0.13333333*g_w(i,k,j+1)*vel+0.61666667*g_w(i,k,j)*vel
          fqy(i,k,jp1) = vel*(37./60.*(w(i,k,j)+w(i,k,j-1))-2./15.*(w(i,k,j+1)+w(i,k,j-2))+1./60.*(w(i,k,j+2)+w(i,k,j-3)))
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_vel = (-(g_rv(i,k-2,j)*fzp(k-1)))+g_rv(i,k-1,j)*(2-fzm(k-1))
        vel = (2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j)
        g_fqy(i,k,jp1) = g_vel*(0.61666667*(w(i,k,j)+w(i,k,j-1))-0.13333333*(w(i,k,j+1)+w(i,k,j-2))+0.016666667*(w(i,k,j+2)+w(i,k,&
&j-3)))+0.016666667*g_w(i,k,j-3)*vel-0.13333333*g_w(i,k,j-2)*vel+0.61666667*g_w(i,k,j-1)*vel+0.016666667*g_w(i,k,j+2)*vel-&
&0.13333333*g_w(i,k,j+1)*vel+0.61666667*g_w(i,k,j)*vel
        fqy(i,k,jp1) = vel*(37./60.*(w(i,k,j)+w(i,k,j-1))-2./15.*(w(i,k,j+1)+w(i,k,j-2))+1./60.*(w(i,k,j+2)+w(i,k,j-3)))
      end do
    else if (j .eq. jds+1) then
      do k = kts+1, ktf
        do i = i_start, i_end
          walls(1)=fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
          g_fqy(i,k,jp1) = 0.5*g_rv(i,k-1,j)*fzp(k)*(w(i,k,j)+w(i,k,j-1))+0.5*g_rv(i,k,j)*fzm(k)*(w(i,k,j)+w(i,k,j-1))+0.5*g_w(i,k,&
&j-1)*walls(1)+0.5*g_w(i,k,j)*walls(1)
          fqy(i,k,jp1) = 0.5*walls(1)*(w(i,k,j)+w(i,k,j-1))
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_fqy(i,k,jp1) = (-(0.5*g_rv(i,k-2,j)*fzp(k-1)*(w(i,k,j)+w(i,k,j-1))))+0.5*g_rv(i,k-1,j)*(2-fzm(k-1))*(w(i,k,j)+w(i,k,j-1))&
&+0.5*g_w(i,k,j-1)*((2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j))+0.5*g_w(i,k,j)*((2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j))
        fqy(i,k,jp1) = 0.5*((2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j))*(w(i,k,j)+w(i,k,j-1))
      end do
    else if (j .eq. jds+2) then
      do k = kts+1, ktf
        do i = i_start, i_end
          g_vel = g_rv(i,k-1,j)*fzp(k)+g_rv(i,k,j)*fzm(k)
          vel = fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
          g_fqy(i,k,jp1) = g_vel*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2)))-0.083333333*g_w(i,k,j-2)*&
&vel+0.58333333*g_w(i,k,j-1)*vel-0.083333333*g_w(i,k,j+1)*vel+0.58333333*g_w(i,k,j)*vel
          fqy(i,k,jp1) = vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2)))
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_vel = (-(g_rv(i,k-2,j)*fzp(k-1)))+g_rv(i,k-1,j)*(2-fzm(k-1))
        vel = (2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j)
        g_fqy(i,k,jp1) = g_vel*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2)))-0.083333333*g_w(i,k,j-2)*vel+&
&0.58333333*g_w(i,k,j-1)*vel-0.083333333*g_w(i,k,j+1)*vel+0.58333333*g_w(i,k,j)*vel
        fqy(i,k,jp1) = vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2)))
      end do
    else if (j .eq. jde-1) then
      do k = kts+1, ktf
        do i = i_start, i_end
          walls(1)=fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
          g_fqy(i,k,jp1) = 0.5*g_rv(i,k-1,j)*fzp(k)*(w(i,k,j)+w(i,k,j-1))+0.5*g_rv(i,k,j)*fzm(k)*(w(i,k,j)+w(i,k,j-1))+0.5*g_w(i,k,&
&j-1)*walls(1)+0.5*g_w(i,k,j)*walls(1)
          fqy(i,k,jp1) = 0.5*walls(1)*(w(i,k,j)+w(i,k,j-1))
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_fqy(i,k,jp1) = (-(0.5*g_rv(i,k-2,j)*fzp(k-1)*(w(i,k,j)+w(i,k,j-1))))+0.5*g_rv(i,k-1,j)*(2-fzm(k-1))*(w(i,k,j)+w(i,k,j-1))&
&+0.5*g_w(i,k,j-1)*((2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j))+0.5*g_w(i,k,j)*((2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j))
        fqy(i,k,jp1) = 0.5*((2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j))*(w(i,k,j)+w(i,k,j-1))
      end do
    else if (j .eq. jde-2) then
      do k = kts+1, ktf
        do i = i_start, i_end
          g_vel = g_rv(i,k-1,j)*fzp(k)+g_rv(i,k,j)*fzm(k)
          vel = fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
          g_fqy(i,k,jp1) = g_vel*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2)))-0.083333333*g_w(i,k,j-2)*&
&vel+0.58333333*g_w(i,k,j-1)*vel-0.083333333*g_w(i,k,j+1)*vel+0.58333333*g_w(i,k,j)*vel
          fqy(i,k,jp1) = vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2)))
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_vel = (-(g_rv(i,k-2,j)*fzp(k-1)))+g_rv(i,k-1,j)*(2-fzm(k-1))
        vel = (2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j)
        g_fqy(i,k,jp1) = g_vel*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2)))-0.083333333*g_w(i,k,j-2)*vel+&
&0.58333333*g_w(i,k,j-1)*vel-0.083333333*g_w(i,k,j+1)*vel+0.58333333*g_w(i,k,j)*vel
        fqy(i,k,jp1) = vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2)))
      end do
    endif
    if (j .gt. j_start) then
      do k = kts+1, ktf+1
        do i = i_start, i_end
          mrdy = msft(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do j_loop_y_flux_6
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = i_start+2
  endif
  if (degrade_xe) then
    i_end = min(ide-2,ite)
    i_end_f = ide-3
  endif
  do j = j_start, j_end
    do k = kts+1, ktf
      do i = i_start_f, i_end_f
        g_vel = g_ru(i,k-1,j)*fzp(k)+g_ru(i,k,j)*fzm(k)
        vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
        g_fqx(i,k) = g_vel*(0.61666667*(w(i,k,j)+w(i-1,k,j))-0.13333333*(w(i+1,k,j)+w(i-2,k,j))+0.016666667*(w(i+2,k,j)+w(i-3,k,j))&
&)+0.016666667*g_w(i-3,k,j)*vel-0.13333333*g_w(i-2,k,j)*vel+0.61666667*g_w(i-1,k,j)*vel+0.016666667*g_w(i+2,k,j)*vel-&
&0.13333333*g_w(i+1,k,j)*vel+0.61666667*g_w(i,k,j)*vel
        fqx(i,k) = vel*(37./60.*(w(i,k,j)+w(i-1,k,j))-2./15.*(w(i+1,k,j)+w(i-2,k,j))+1./60.*(w(i+2,k,j)+w(i-3,k,j)))
      end do
    end do
    k = ktf+1
    do i = i_start_f, i_end_f
      g_vel = (-(g_ru(i,k-2,j)*fzp(k-1)))+g_ru(i,k-1,j)*(2-fzm(k-1))
      vel = (2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j)
      g_fqx(i,k) = g_vel*(0.61666667*(w(i,k,j)+w(i-1,k,j))-0.13333333*(w(i+1,k,j)+w(i-2,k,j))+0.016666667*(w(i+2,k,j)+w(i-3,k,j)))+&
&0.016666667*g_w(i-3,k,j)*vel-0.13333333*g_w(i-2,k,j)*vel+0.61666667*g_w(i-1,k,j)*vel+0.016666667*g_w(i+2,k,j)*vel-&
&0.13333333*g_w(i+1,k,j)*vel+0.61666667*g_w(i,k,j)*vel
      fqx(i,k) = vel*(37./60.*(w(i,k,j)+w(i-1,k,j))-2./15.*(w(i+1,k,j)+w(i-2,k,j))+1./60.*(w(i+2,k,j)+w(i-3,k,j)))
    end do
    if (degrade_xs) then
      if (i_start .eq. ids+1) then
        i = ids+1
        do k = kts+1, ktf
          g_fqx(i,k) = 0.5*g_ru(i,k-1,j)*fzp(k)*(w(i,k,j)+w(i-1,k,j))+0.5*g_ru(i,k,j)*fzm(k)*(w(i,k,j)+w(i-1,k,j))+0.5*g_w(i-1,k,j)&
&*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))+0.5*g_w(i,k,j)*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))
          fqx(i,k) = 0.5*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))*(w(i,k,j)+w(i-1,k,j))
        end do
        k = ktf+1
        g_fqx(i,k) = (-(0.5*g_ru(i,k-2,j)*fzp(k-1)*(w(i,k,j)+w(i-1,k,j))))+0.5*g_ru(i,k-1,j)*(2-fzm(k-1))*(w(i,k,j)+w(i-1,k,j))+&
&0.5*g_w(i-1,k,j)*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))+0.5*g_w(i,k,j)*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))
        fqx(i,k) = 0.5*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))*(w(i,k,j)+w(i-1,k,j))
      endif
      do k = kts+1, ktf
        i = i_start+1
        g_vel = g_ru(i,k-1,j)*fzp(k)+g_ru(i,k,j)*fzm(k)
        vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
        g_fqx(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))-0.083333333*g_w(i-2,k,j)*vel+&
&0.58333333*g_w(i-1,k,j)*vel-0.083333333*g_w(i+1,k,j)*vel+0.58333333*g_w(i,k,j)*vel
        fqx(i,k) = vel*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)+w(i-2,k,j)))
      end do
      k = ktf+1
      g_vel = (-(g_ru(i,k-2,j)*fzp(k-1)))+g_ru(i,k-1,j)*(2-fzm(k-1))
      vel = (2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j)
      g_fqx(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))-0.083333333*g_w(i-2,k,j)*vel+&
&0.58333333*g_w(i-1,k,j)*vel-0.083333333*g_w(i+1,k,j)*vel+0.58333333*g_w(i,k,j)*vel
      fqx(i,k) = vel*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)+w(i-2,k,j)))
    endif
    if (degrade_xe) then
      if (i_end .eq. ide-2) then
        i = ide-1
        do k = kts+1, ktf
          g_fqx(i,k) = 0.5*g_ru(i,k-1,j)*fzp(k)*(w(i,k,j)+w(i-1,k,j))+0.5*g_ru(i,k,j)*fzm(k)*(w(i,k,j)+w(i-1,k,j))+0.5*g_w(i-1,k,j)&
&*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))+0.5*g_w(i,k,j)*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))
          fqx(i,k) = 0.5*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))*(w(i,k,j)+w(i-1,k,j))
        end do
        k = ktf+1
        g_fqx(i,k) = (-(0.5*g_ru(i,k-2,j)*fzp(k-1)*(w(i,k,j)+w(i-1,k,j))))+0.5*g_ru(i,k-1,j)*(2-fzm(k-1))*(w(i,k,j)+w(i-1,k,j))+&
&0.5*g_w(i-1,k,j)*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))+0.5*g_w(i,k,j)*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))
        fqx(i,k) = 0.5*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))*(w(i,k,j)+w(i-1,k,j))
      endif
      i = ide-2
      do k = kts+1, ktf
        g_vel = g_ru(i,k-1,j)*fzp(k)+g_ru(i,k,j)*fzm(k)
        vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
        g_fqx(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))-0.083333333*g_w(i-2,k,j)*vel+&
&0.58333333*g_w(i-1,k,j)*vel-0.083333333*g_w(i+1,k,j)*vel+0.58333333*g_w(i,k,j)*vel
        fqx(i,k) = vel*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)+w(i-2,k,j)))
      end do
      k = ktf+1
      g_vel = (-(g_ru(i,k-2,j)*fzp(k-1)))+g_ru(i,k-1,j)*(2-fzm(k-1))
      vel = (2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j)
      g_fqx(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))-0.083333333*g_w(i-2,k,j)*vel+&
&0.58333333*g_w(i-1,k,j)*vel-0.083333333*g_w(i+1,k,j)*vel+0.58333333*g_w(i,k,j)*vel
      fqx(i,k) = vel*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)+w(i-2,k,j)))
    endif
    do k = kts+1, ktf+1
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
else if (horz_order .eq. 5) then horizontal_order_tesu
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+2) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-3) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+2) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-3) then
    degrade_ye =  .false. 
  endif
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = max(jts,jds+1)
    j_start_f = jds+3
  endif
  if (degrade_ye) then
    j_end = min(jte,jde-2)
    j_end_f = jde-3
  endif
  jp1 = 2
  jp0 = 1
  j_loop_y_flux_5: do j = j_start, j_end+1
    if (j .ge. j_start_f .and. j .le. j_end_f) then
      do k = kts+1, ktf
        do i = i_start, i_end
          vel = fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
          fqy(i,k,jp1) = vel*(37./60.*(w(i,k,j)+w(i,k,j-1))-2./15.*(w(i,k,j+1)+w(i,k,j-2))+1./60.*(w(i,k,j+2)+w(i,k,j-3))-sign(1.,&
&vel)*(1./60.)*(w(i,k,j+2)-w(i,k,j-3)-5.*(w(i,k,j+1)-w(i,k,j-2))+10.*(w(i,k,j)-w(i,k,j-1))))

          g_fqy(i,k,jp1) = (g_rv(i,k-1,j)*fzp(k)+g_rv(i,k,j)*fzm(k))*fqy(i,k,jp1)/vel&
&+vel*(g_w(i,k,j-3)*(0.016666667-(-0.016666667)*sign(1.,vel))+g_w(i,k,j-2)*((-0.13333333)-0.083333333*sign(1.,vel))+g_w(i,k,j-&
&1)*(0.61666667-(-0.16666667)*sign(1.,vel))+g_w(i,k,j+2)*(0.016666667-0.016666667*sign(1.,vel))+g_w(i,k,j+1)*&
&((-0.13333333)-(-0.083333333)*sign(1.,vel))+g_w(i,k,j)*(0.61666667-0.16666667*sign(1.,vel)))
else
        fqy(i,k,jp1)=0.
        g_fqy(i,k,jp1) =(g_rv(i,k-1,j)*fzp(k)+g_rv(i,k,j)*fzm(k))*(37./60.*(w(i,k,j)&
&+w(i,k,j-1))-2./15.*(w(i,k,j+1)+w(i,k,j-2))+1./60.*(w(i,k,j+2)+w(i,k,j-3))-sign(1.,&
&vel)*(1./60.)*(w(i,k,j+2)-w(i,k,j-3)-5.*(w(i,k,j+1)-w(i,k,j-2))+10.*(w(i,k,j)-w(i,k,j-1))))
endif
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_vel = (-(g_rv(i,k-2,j)*fzp(k-1)))+g_rv(i,k-1,j)*(2-fzm(k-1))
        vel = (2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j)
        g_fqy(i,k,jp1) = g_vel*(0.61666667*(w(i,k,j)+w(i,k,j-1))-0.13333333*(w(i,k,j+1)+w(i,k,j-2))+0.016666667*(w(i,k,j+2)+w(i,k,&
&j-3))-0.016666667*(w(i,k,j+2)-w(i,k,j-3)-5.*(w(i,k,j+1)-w(i,k,j-2))+10.*(w(i,k,j)-w(i,k,j-1)))*sign(1.,vel))+g_w(i,k,j-3)*&
&vel*(0.016666667-(-0.016666667)*sign(1.,vel))+g_w(i,k,j-2)*vel*((-0.13333333)-0.083333333*sign(1.,vel))+g_w(i,k,j-1)*vel*&
&(0.61666667-(-0.16666667)*sign(1.,vel))+g_w(i,k,j+2)*vel*(0.016666667-0.016666667*sign(1.,vel))+g_w(i,k,j+1)*vel*((-&
&0.13333333)-(-0.083333333)*sign(1.,vel))+g_w(i,k,j)*vel*(0.61666667-0.16666667*sign(1.,vel))
        fqy(i,k,jp1) = vel*(37./60.*(w(i,k,j)+w(i,k,j-1))-2./15.*(w(i,k,j+1)+w(i,k,j-2))+1./60.*(w(i,k,j+2)+w(i,k,j-3))-sign(1.,&
&vel)*(1./60.)*(w(i,k,j+2)-w(i,k,j-3)-5.*(w(i,k,j+1)-w(i,k,j-2))+10.*(w(i,k,j)-w(i,k,j-1))))
      end do
    else if (j .eq. jds+1) then
      do k = kts+1, ktf
        do i = i_start, i_end
          walls(1)=fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
          walls(2)=w(i,k,j)+w(i,k,j-1)
          g_fqy(i,k,jp1) = 0.5*g_rv(i,k-1,j)*fzp(k)*walls(2)+0.5*g_rv(i,k,j)*fzm(k)*walls(2)+0.5*g_w(i,k,&
&j-1)*walls(1)+0.5*g_w(i,k,j)*walls(1)
          fqy(i,k,jp1) = 0.5*walls(1)*walls(2)
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        walls(2)=w(i,k,j)+w(i,k,j-1)
        g_fqy(i,k,jp1) = (-(0.5*g_rv(i,k-2,j)*fzp(k-1)*walls(2)))+0.5*g_rv(i,k-1,j)*(2-fzm(k-1))*walls(2)&
&+0.5*g_w(i,k,j-1)*((2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j))&
&+0.5*g_w(i,k,j)*((2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j))
        fqy(i,k,jp1) = 0.5*((2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j))*walls(2)
      end do

    else if (j .eq. jds+2) then
      do k = kts+1, ktf
        do i = i_start, i_end
          g_vel = g_rv(i,k-1,j)*fzp(k)+g_rv(i,k,j)*fzm(k)
          vel = fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
   fqy(i,k,jp1) = vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2))+sign(1.,vel)*(1./12.)*(w(i,k,j+1)-w(i,k,&
&j-2)-3.*(w(i,k,j)-w(i,k,j-1))))
   g_fqy(i,k,jp1) = g_vel*fqy(i,k,jp1)/vel&
&+vel*(g_w(i,k,j-2)*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_w(i,k,j-&
&1)*(0.58333333+0.25*sign(1.,vel))+g_w(i,k,j+1)*((-0.083333333)+0.083333333*sign(1.,vel))+g_w(i,k,j)*&
&(0.58333333+(-0.25)*sign(1.,vel)))
else
   fqy(i,k,jp1)=0.
   g_fqy(i,k,jp1) =g_vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2))+sign(1.,vel)*(1./12.)*(w(i,k,j+1)-w(i,k,&
&j-2)-3.*(w(i,k,j)-w(i,k,j-1))))
endif
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_vel = (-(g_rv(i,k-2,j)*fzp(k-1)))+g_rv(i,k-1,j)*(2-fzm(k-1))
        vel = (2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j)
        g_fqy(i,k,jp1) = g_vel*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2))+0.083333333*(w(i,k,j+1)-w(i,k,&
&j-2)-3.*(w(i,k,j)-w(i,k,j-1)))*sign(1.,vel))+g_w(i,k,j-2)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_w(i,k,j-1)*&
&vel*(0.58333333+0.25*sign(1.,vel))+g_w(i,k,j+1)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_w(i,k,j)*vel*(0.58333333+&
&(-0.25)*sign(1.,vel))
        fqy(i,k,jp1) = vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2))+sign(1.,vel)*(1./12.)*(w(i,k,j+1)-w(i,k,j-&
&2)-3.*(w(i,k,j)-w(i,k,j-1))))
      end do
    else if (j .eq. jde-1) then
      do k = kts+1, ktf
        do i = i_start, i_end
          walls(1)=fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
          walls(2)=w(i,k,j)+w(i,k,j-1)
          g_fqy(i,k,jp1) = 0.5*g_rv(i,k-1,j)*fzp(k)*walls(2)+0.5*g_rv(i,k,j)*fzm(k)*walls(2)+0.5*g_w(i,k,&
&j-1)*walls(1)+0.5*g_w(i,k,j)*walls(1)
          fqy(i,k,jp1) = 0.5*walls(1)*walls(2)
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        walls(1)=(2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j)
        walls(2)=w(i,k,j)+w(i,k,j-1)
        g_fqy(i,k,jp1) = (-(0.5*g_rv(i,k-2,j)*fzp(k-1)*walls(2)))+0.5*g_rv(i,k-1,j)*(2-fzm(k-1))*walls(2)&
&+0.5*g_w(i,k,j-1)*walls(1)+0.5*g_w(i,k,j)*walls(1)
        fqy(i,k,jp1) = 0.5*walls(1)*walls(2)
      end do
    else if (j .eq. jde-2) then
      do k = kts+1, ktf
        do i = i_start, i_end
          vel = fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
          fqy(i,k,jp1) = vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)&
&+w(i,k,j-2))+sign(1.,vel)*(1./12.)*(w(i,k,j+1)-w(i,k,&
&j-2)-3.*(w(i,k,j)-w(i,k,j-1))))
          g_fqy(i,k,jp1) = (g_rv(i,k-1,j)*fzp(k)+g_rv(i,k,j)*fzm(k))*fqy(i,k,jp1)/vel&
&+vel*(g_w(i,k,j-2)*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_w(i,k,j-&
&1)*(0.58333333+0.25*sign(1.,vel))+g_w(i,k,j+1)*((-0.083333333)+0.083333333*sign(1.,vel))+g_w(i,k,j)*&
&(0.58333333+(-0.25)*sign(1.,vel)))
else
        fqy(i,k,jp1)=0.
        g_fqy(i,k,jp1) =(g_rv(i,k-1,j)*fzp(k)+g_rv(i,k,j)*fzm(k))*(7./12.*(w(i,k,j)&
&+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2))+sign(1.,vel)*(1./12.)*(w(i,k,j+1)-w(i,k,&
&j-2)-3.*(w(i,k,j)-w(i,k,j-1))))
endif
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_vel = (-(g_rv(i,k-2,j)*fzp(k-1)))+g_rv(i,k-1,j)*(2-fzm(k-1))
        vel = (2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j)
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
fqy(i,k,jp1) = vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)&
&+w(i,k,j-2))+sign(1.,vel)*(1./12.)*(w(i,k,j+1)-w(i,k,j-&
&2)-3.*(w(i,k,j)-w(i,k,j-1))))
        g_fqy(i,k,jp1) = g_vel*fqy(i,k,jp1)/vel&
&+g_w(i,k,j-2)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_w(i,k,j-1)*&
&vel*(0.58333333+0.25*sign(1.,vel))+g_w(i,k,j+1)*vel*((-0.083333333)+0.083333333*sign(1.,vel))&
&+g_w(i,k,j)*vel*(0.58333333+(-0.25)*sign(1.,vel))
else
        fqy(i,k,jp1)=0.
        g_fqy(i,k,jp1) =g_vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2))&
&+sign(1.,vel)*(1./12.)*(w(i,k,j+1)-w(i,k,j-&
&2)-3.*(w(i,k,j)-w(i,k,j-1))))
endif
      end do
    endif

    if (j .gt. j_start) then
      do k = kts+1, ktf+1
        do i = i_start, i_end
          mrdy = msft(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do j_loop_y_flux_5
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = max(ids+1,its)
    i_start_f = i_start+2
  endif
  if (degrade_xe) then
    i_end = min(ide-2,ite)
    i_end_f = ide-3
  endif
  do j = j_start, j_end
    do k = kts+1, ktf
      do i = i_start_f, i_end_f
        g_vel = g_ru(i,k-1,j)*fzp(k)+g_ru(i,k,j)*fzm(k)
        vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
fqx(i,k) = vel*(37./60.*(w(i,k,j)+w(i-1,k,j))-2./15.*(w(i+1,k,j)+w(i-2,k,j))+1./60.*(w(i+2,k,j)+w(i-3,k,j))-sign(1.,vel)*&
&(1./60.)*(w(i+2,k,j)-w(i-3,k,j)-5.*(w(i+1,k,j)-w(i-2,k,j))+10.*(w(i,k,j)-w(i-1,k,j))))
g_fqx(i,k) = g_vel*fqx(i,k)/vel&
&+vel*(g_w(i-3,k,j)*(0.016666667-(-0.016666667)*sign(1.,vel))&
&+g_w(i-2,k,j)*((-0.13333333)-0.083333333*sign(1.,vel))+g_w(i-1,k,j)*&
&(0.61666667-(-0.16666667)*sign(1.,vel))+g_w(i+2,k,j)*(0.016666667-0.016666667*sign(1.,vel))+g_w(i+1,k,j)*((-&
&0.13333333)-(-0.083333333)*sign(1.,vel))+g_w(i,k,j)*(0.61666667-0.16666667*sign(1.,vel)))
else
        fqx(i,k)=0.
        g_fqx(i,k) = g_vel*(37./60.*(w(i,k,j)+w(i-1,k,j))-2./15.*(w(i+1,k,j)+w(i-2,k,j))&
&+1./60.*(w(i+2,k,j)+w(i-3,k,j))-sign(1.,vel)*&
&(1./60.)*(w(i+2,k,j)-w(i-3,k,j)-5.*(w(i+1,k,j)-w(i-2,k,j))+10.*(w(i,k,j)-w(i-1,k,j))))
endif
      end do
    end do
    k = ktf+1
    do i = i_start_f, i_end_f
      g_vel = (-(g_ru(i,k-2,j)*fzp(k-1)))+g_ru(i,k-1,j)*(2-fzm(k-1))
      vel = (2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j)
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
      fqx(i,k) = vel*(37./60.*(w(i,k,j)+w(i-1,k,j))-2./15.*(w(i+1,k,j)+w(i-2,k,j))&
&+1./60.*(w(i+2,k,j)+w(i-3,k,j))-sign(1.,vel)*(1./&
&60.)*(w(i+2,k,j)-w(i-3,k,j)-5.*(w(i+1,k,j)-w(i-2,k,j))+10.*(w(i,k,j)-w(i-1,k,j))))
      g_fqx(i,k) = g_vel*fqx(i,k)/vel&
&+g_w(i-3,k,j)*vel*&
&(0.016666667-(-0.016666667)*sign(1.,vel))+g_w(i-2,k,j)*vel*((-0.13333333)-0.083333333*sign(1.,vel))+g_w(i-1,k,j)*vel*&
&(0.61666667-(-0.16666667)*sign(1.,vel))+g_w(i+2,k,j)*vel*(0.016666667-0.016666667*sign(1.,vel))+g_w(i+1,k,j)*vel*((-&
&0.13333333)-(-0.083333333)*sign(1.,vel))+g_w(i,k,j)*vel*(0.61666667-0.16666667*sign(1.,vel))
else
fqx(i,k)=0.
g_fqx(i,k) =g_vel*(37./60.*(w(i,k,j)+w(i-1,k,j))-2./15.*(w(i+1,k,j)+w(i-2,k,j))&
&+1./60.*(w(i+2,k,j)+w(i-3,k,j))-sign(1.,vel)*(1./&
&60.)*(w(i+2,k,j)-w(i-3,k,j)-5.*(w(i+1,k,j)-w(i-2,k,j))+10.*(w(i,k,j)-w(i-1,k,j))))
endif
    end do
    if (degrade_xs) then
      if (i_start .eq. ids+1) then
        i = ids+1
        do k = kts+1, ktf
g_fqx(i,k) = 0.5*g_ru(i,k-1,j)*fzp(k)*(w(i,k,j)+w(i-1,k,j))+0.5*g_ru(i,k,j)*fzm(k)*(w(i,k,j)&
&+w(i-1,k,j))+0.5*g_w(i-1,k,j)&
&*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))+0.5*g_w(i,k,j)*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))
          fqx(i,k) = 0.5*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))*(w(i,k,j)+w(i-1,k,j))
        end do
        k = ktf+1
g_fqx(i,k) = (-(0.5*g_ru(i,k-2,j)*fzp(k-1)*(w(i,k,j)+w(i-1,k,j))))+0.5*g_ru(i,k-1,j)*(2-fzm(k-1))*(w(i,k,j)+w(i-1,k,j))+&
&0.5*g_w(i-1,k,j)*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))&
&+0.5*g_w(i,k,j)*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))
        fqx(i,k) = 0.5*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))*(w(i,k,j)+w(i-1,k,j))
      endif
      i = i_start+1
      do k = kts+1, ktf
        vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
        fqx(i,k) = vel*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)&
&+w(i-2,k,j))+sign(1.,vel)*(1./12.)*(w(i+1,k,j)-w(i-2,k,j)-&
&3.*(w(i,k,j)-w(i-1,k,j))))
        g_fqx(i,k) = (g_ru(i,k-1,j)*fzp(k)+g_ru(i,k,j)*fzm(k))*fqx(i,k)/vel&
&+vel*(g_w(i-2,k,j)*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_w(i-1,k,j)*&
&(0.58333333+0.25*sign(1.,vel))+g_w(i+1,k,j)*((-0.083333333)+0.083333333*sign(1.,vel))+g_w(i,k,j)*(0.58333333+(-&
&0.25)*sign(1.,vel)))
else
        fqx(i,k)=0.
        g_fqx(i,k) =(g_ru(i,k-1,j)*fzp(k)+g_ru(i,k,j)*fzm(k))*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)&
&+w(i-2,k,j))+sign(1.,vel)*(1./12.)*(w(i+1,k,j)-w(i-2,k,j)-3.*(w(i,k,j)-w(i-1,k,j))))
endif
      end do
      k = ktf+1
      g_vel = (-(g_ru(i,k-2,j)*fzp(k-1)))+g_ru(i,k-1,j)*(2-fzm(k-1))
      vel = (2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j)
      g_fqx(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)&
&+w(i-2,k,j))+0.083333333*(w(i+1,k,j)-w(i-2,k,j)-&
&3.*(w(i,k,j)-w(i-1,k,j)))*sign(1.,vel))+g_w(i-2,k,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_w(i-1,k,j)*vel*&
&(0.58333333+0.25*sign(1.,vel))+g_w(i+1,k,j)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_w(i,k,j)*vel*(0.58333333+(-0.25)&
&*sign(1.,vel))
      fqx(i,k) = vel*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)+w(i-2,k,j))&
&+sign(1.,vel)*(1./12.)*(w(i+1,k,j)-w(i-2,k,j)-3.*(w(i,k,j)-w(i-1,k,j))))
    endif
    if (degrade_xe) then
      if (i_end .eq. ide-2) then
        i = ide-1
        do k = kts+1, ktf
          g_fqx(i,k) = 0.5*g_ru(i,k-1,j)*fzp(k)*(w(i,k,j)+w(i-1,k,j))+0.5*g_ru(i,k,j)*fzm(k)*(w(i,k,j)+w(i-1,k,j))+0.5*g_w(i-1,k,j)&
&*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))+0.5*g_w(i,k,j)*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))
          fqx(i,k) = 0.5*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))*(w(i,k,j)+w(i-1,k,j))
        end do
        k = ktf+1
        g_fqx(i,k) = (-(0.5*g_ru(i,k-2,j)*fzp(k-1)*(w(i,k,j)+w(i-1,k,j))))+0.5*g_ru(i,k-1,j)*(2-fzm(k-1))*(w(i,k,j)+w(i-1,k,j))+&
&0.5*g_w(i-1,k,j)*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))+0.5*g_w(i,k,j)*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))
        fqx(i,k) = 0.5*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))*(w(i,k,j)+w(i-1,k,j))
      endif
      i = ide-2
      do k = kts+1, ktf
        vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
        fqx(i,k) = vel*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)+w(i-2,k,j))+sign(1.,vel)*(1./12.)*(w(i+1,k,j)-w(i-2,k,j)-&
&3.*(w(i,k,j)-w(i-1,k,j))))
        g_fqx(i,k) = (g_ru(i,k-1,j)*fzp(k)+g_ru(i,k,j)*fzm(k))*fqx(i,k)/vel&
&+vel*(g_w(i-2,k,j)*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_w(i-1,k,j)*&
&(0.58333333+0.25*sign(1.,vel))+g_w(i+1,k,j)*((-0.083333333)+0.083333333*sign(1.,vel))+g_w(i,k,j)*(0.58333333+(-&
&0.25)*sign(1.,vel)))
else
        fqx(i,k)=0.
        g_fqx(i,k) = (g_ru(i,k-1,j)*fzp(k)+g_ru(i,k,j)*fzm(k))*(7./12.*(w(i,k,j)+w(i-1,k,j))&
&-1./12.*(w(i+1,k,j)+w(i-2,k,j))+sign(1.,vel)*(1./12.)*(w(i+1,k,j)-w(i-2,k,j)-3.*(w(i,k,j)-w(i-1,k,j))))
endif
      end do
      k = ktf+1
      g_vel = (-(g_ru(i,k-2,j)*fzp(k-1)))+g_ru(i,k-1,j)*(2-fzm(k-1))
      vel = (2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j)
      g_fqx(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j))+0.083333333*(w(i+1,k,j)-w(i-2,k,j)-&
&3.*(w(i,k,j)-w(i-1,k,j)))*sign(1.,vel))+g_w(i-2,k,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_w(i-1,k,j)*vel*&
&(0.58333333+0.25*sign(1.,vel))+g_w(i+1,k,j)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_w(i,k,j)*vel*(0.58333333+(-0.25)&
&*sign(1.,vel))
      fqx(i,k) = vel*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)+w(i-2,k,j))+sign(1.,vel)*(1./12.)*(w(i+1,k,j)-w(i-2,k,j)-3.*&
&(w(i,k,j)-w(i-1,k,j))))
    endif
    do k = kts+1, ktf+1
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
else if (horz_order .eq. 4) then horizontal_order_tesu
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
  ktf = min(kte,kde-1)
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
  if (degrade_xe) then
    i_end = ide-2
    i_end_f = ide-2
  endif
  do j = j_start, j_end
    do k = kts+1, ktf
      do i = i_start_f, i_end_f
        g_vel = g_ru(i,k-1,j)*fzp(k)+g_ru(i,k,j)*fzm(k)
        vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
        g_fqx(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))-0.083333333*g_w(i-2,k,j)*vel+&
&0.58333333*g_w(i-1,k,j)*vel-0.083333333*g_w(i+1,k,j)*vel+0.58333333*g_w(i,k,j)*vel
        fqx(i,k) = vel*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)+w(i-2,k,j)))
      end do
    end do
    k = ktf+1
    do i = i_start_f, i_end_f
      g_vel = (-(g_ru(i,k-2,j)*fzp(k-1)))+g_ru(i,k-1,j)*(2-fzm(k-1))
      vel = (2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j)
      g_fqx(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j)))-0.083333333*g_w(i-2,k,j)*vel+&
&0.58333333*g_w(i-1,k,j)*vel-0.083333333*g_w(i+1,k,j)*vel+0.58333333*g_w(i,k,j)*vel
      fqx(i,k) = vel*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)+w(i-2,k,j)))
    end do
    if (degrade_xs) then
      do k = kts+1, ktf
        g_fqx(i_start,k) = 0.5*g_ru(i_start,k-1,j)*fzp(k)*(w(i_start,k,j)+w(i_start-1,k,j))+0.5*g_ru(i_start,k,j)*fzm(k)*&
&(w(i_start,k,j)+w(i_start-1,k,j))+0.5*g_w(i_start-1,k,j)*(fzm(k)*ru(i_start,k,j)+fzp(k)*ru(i_start,k-1,j))+0.5*&
&g_w(i_start,k,j)*(fzm(k)*ru(i_start,k,j)+fzp(k)*ru(i_start,k-1,j))
        fqx(i_start,k) = 0.5*(fzm(k)*ru(i_start,k,j)+fzp(k)*ru(i_start,k-1,j))*(w(i_start,k,j)+w(i_start-1,k,j))
      end do
      k = ktf+1
      g_fqx(i_start,k) = (-(0.5*g_ru(i_start,k-2,j)*fzp(k-1)*(w(i_start,k,j)+w(i_start-1,k,j))))+0.5*g_ru(i_start,k-1,j)*(2-fzm(k-&
&1))*(w(i_start,k,j)+w(i_start-1,k,j))+0.5*g_w(i_start-1,k,j)*((2.-fzm(k-1))*ru(i_start,k-1,j)-fzp(k-1)*ru(i_start,k-2,j))+&
&0.5*g_w(i_start,k,j)*((2.-fzm(k-1))*ru(i_start,k-1,j)-fzp(k-1)*ru(i_start,k-2,j))
      fqx(i_start,k) = 0.5*((2.-fzm(k-1))*ru(i_start,k-1,j)-fzp(k-1)*ru(i_start,k-2,j))*(w(i_start,k,j)+w(i_start-1,k,j))
    endif
    if (degrade_xe) then
      do k = kts+1, ktf
        g_fqx(i_end+1,k) = 0.5*g_ru(i_end+1,k-1,j)*fzp(k)*(w(i_end+1,k,j)+w(i_end,k,j))+0.5*g_ru(i_end+1,k,j)*fzm(k)*(w(i_end+1,k,&
&j)+w(i_end,k,j))+0.5*g_w(i_end+1,k,j)*(fzm(k)*ru(i_end+1,k,j)+fzp(k)*ru(i_end+1,k-1,j))+0.5*g_w(i_end,k,j)*(fzm(k)*&
&ru(i_end+1,k,j)+fzp(k)*ru(i_end+1,k-1,j))
        fqx(i_end+1,k) = 0.5*(fzm(k)*ru(i_end+1,k,j)+fzp(k)*ru(i_end+1,k-1,j))*(w(i_end+1,k,j)+w(i_end,k,j))
      end do
      k = ktf+1
      g_fqx(i_end+1,k) = (-(0.5*g_ru(i_end+1,k-2,j)*fzp(k-1)*(w(i_end+1,k,j)+w(i_end,k,j))))+0.5*g_ru(i_end+1,k-1,j)*(2-fzm(k-1))*&
&(w(i_end+1,k,j)+w(i_end,k,j))+0.5*g_w(i_end+1,k,j)*((2.-fzm(k-1))*ru(i_end+1,k-1,j)-fzp(k-1)*ru(i_end+1,k-2,j))+0.5*&
&g_w(i_end,k,j)*((2.-fzm(k-1))*ru(i_end+1,k-1,j)-fzp(k-1)*ru(i_end+1,k-2,j))
      fqx(i_end+1,k) = 0.5*((2.-fzm(k-1))*ru(i_end+1,k-1,j)-fzp(k-1)*ru(i_end+1,k-2,j))*(w(i_end+1,k,j)+w(i_end,k,j))
    endif
    do k = kts+1, ktf+1
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = jds+1
    j_start_f = j_start+1
  endif
  if (degrade_ye) then
    j_end = jde-2
    j_end_f = jde-2
  endif
  jp1 = 2
  jp0 = 1
  do j = j_start, j_end+1
    if (j .lt. j_start_f .and. degrade_ys) then
      do k = kts+1, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.5*g_rv(i,k-1,j_start)*fzp(k)*(w(i,k,j_start)+w(i,k,j_start-1))+0.5*g_rv(i,k,j_start)*fzm(k)*(w(i,k,&
&j_start)+w(i,k,j_start-1))+0.5*g_w(i,k,j_start-1)*(fzm(k)*rv(i,k,j_start)+fzp(k)*rv(i,k-1,j_start))+0.5*g_w(i,k,j_start)&
&*(fzm(k)*rv(i,k,j_start)+fzp(k)*rv(i,k-1,j_start))
          fqy(i,k,jp1) = 0.5*(fzm(k)*rv(i,k,j_start)+fzp(k)*rv(i,k-1,j_start))*(w(i,k,j_start)+w(i,k,j_start-1))
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_fqy(i,k,jp1) = (-(0.5*g_rv(i,k-2,j_start)*fzp(k-1)*(w(i,k,j_start)+w(i,k,j_start-1))))+0.5*g_rv(i,k-1,j_start)*(2-fzm(k-&
&1))*(w(i,k,j_start)+w(i,k,j_start-1))+0.5*g_w(i,k,j_start-1)*((2.-fzm(k-1))*rv(i,k-1,j_start)-fzp(k-1)*rv(i,k-2,j_start))+&
&0.5*g_w(i,k,j_start)*((2.-fzm(k-1))*rv(i,k-1,j_start)-fzp(k-1)*rv(i,k-2,j_start))
        fqy(i,k,jp1) = 0.5*((2.-fzm(k-1))*rv(i,k-1,j_start)-fzp(k-1)*rv(i,k-2,j_start))*(w(i,k,j_start)+w(i,k,j_start-1))
      end do
    else if (j .gt. j_end_f .and. degrade_ye) then
      do k = kts+1, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.5*g_rv(i,k-1,j_end+1)*fzp(k)*(w(i,k,j_end+1)+w(i,k,j_end))+0.5*g_rv(i,k,j_end+1)*fzm(k)*(w(i,k,j_end+&
&1)+w(i,k,j_end))+0.5*g_w(i,k,j_end+1)*(fzm(k)*rv(i,k,j_end+1)+fzp(k)*rv(i,k-1,j_end+1))+0.5*g_w(i,k,j_end)*(fzm(k)*rv(i,&
&k,j_end+1)+fzp(k)*rv(i,k-1,j_end+1))
          fqy(i,k,jp1) = 0.5*(fzm(k)*rv(i,k,j_end+1)+fzp(k)*rv(i,k-1,j_end+1))*(w(i,k,j_end+1)+w(i,k,j_end))
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_fqy(i,k,jp1) = (-(0.5*g_rv(i,k-2,j_end+1)*fzp(k-1)*(w(i,k,j_end+1)+w(i,k,j_end))))+0.5*g_rv(i,k-1,j_end+1)*(2-fzm(k-1))*&
&(w(i,k,j_end+1)+w(i,k,j_end))+0.5*g_w(i,k,j_end+1)*((2.-fzm(k-1))*rv(i,k-1,j_end+1)-fzp(k-1)*rv(i,k-2,j_end+1))+0.5*g_w(i,&
&k,j_end)*((2.-fzm(k-1))*rv(i,k-1,j_end+1)-fzp(k-1)*rv(i,k-2,j_end+1))
        fqy(i,k,jp1) = 0.5*((2.-fzm(k-1))*rv(i,k-1,j_end+1)-fzp(k-1)*rv(i,k-2,j_end+1))*(w(i,k,j_end+1)+w(i,k,j_end))
      end do
    else
      do k = kts+1, ktf
        do i = i_start, i_end
          g_vel = g_rv(i,k-1,j)*fzp(k)+g_rv(i,k,j)*fzm(k)
          vel = fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
          g_fqy(i,k,jp1) = g_vel*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2)))-0.083333333*g_w(i,k,j-2)*&
&vel+0.58333333*g_w(i,k,j-1)*vel-0.083333333*g_w(i,k,j+1)*vel+0.58333333*g_w(i,k,j)*vel
          fqy(i,k,jp1) = vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2)))
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_vel = (-(g_rv(i,k-2,j)*fzp(k-1)))+g_rv(i,k-1,j)*(2-fzm(k-1))
        vel = (2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j)
        g_fqy(i,k,jp1) = g_vel*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2)))-0.083333333*g_w(i,k,j-2)*vel+&
&0.58333333*g_w(i,k,j-1)*vel-0.083333333*g_w(i,k,j+1)*vel+0.58333333*g_w(i,k,j)*vel
        fqy(i,k,jp1) = vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2)))
      end do
    endif
    if (j .gt. j_start) then
      do k = kts+1, ktf+1
        do i = i_start, i_end
          mrdy = msft(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do
else if (horz_order .eq. 3) then horizontal_order_tesu
  degrade_xs =  .true. 
  degrade_xe =  .true. 
  degrade_ys =  .true. 
  degrade_ye =  .true. 
  if (config_flags%periodic_x .or. config_flags%symmetric_xs .or. its .gt. ids+1) then
    degrade_xs =  .false. 
  endif
  if (config_flags%periodic_x .or. config_flags%symmetric_xe .or. ite .lt. ide-2) then
    degrade_xe =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ys .or. jts .gt. jds+1) then
    degrade_ys =  .false. 
  endif
  if (config_flags%periodic_y .or. config_flags%symmetric_ye .or. jte .lt. jde-2) then
    degrade_ye =  .false. 
  endif
  ktf = min(kte,kde-1)
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  i_start_f = i_start
  i_end_f = i_end+1
  if (degrade_xs) then
    i_start = ids+1
    i_start_f = i_start+1
  endif
  if (degrade_xe) then
    i_end = ide-2
    i_end_f = ide-2
  endif
  do j = j_start, j_end
    do k = kts+1, ktf
      do i = i_start_f, i_end_f
        g_vel = g_ru(i,k-1,j)*fzp(k)+g_ru(i,k,j)*fzm(k)
        vel = fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)
        g_fqx(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j))+0.083333333*(w(i+1,k,j)-w(i-2,k,j)&
&-3.*(w(i,k,j)-w(i-1,k,j)))*sign(1.,vel))+g_w(i-2,k,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_w(i-1,k,j)*vel*&
&(0.58333333+0.25*sign(1.,vel))+g_w(i+1,k,j)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_w(i,k,j)*vel*(0.58333333+(-&
&0.25)*sign(1.,vel))
        fqx(i,k) = vel*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)+w(i-2,k,j))+sign(1.,vel)*(1./12.)*(w(i+1,k,j)-w(i-2,k,j)-&
&3.*(w(i,k,j)-w(i-1,k,j))))
      end do
    end do
    k = ktf+1
    do i = i_start_f, i_end_f
      g_vel = (-(g_ru(i,k-2,j)*fzp(k-1)))+g_ru(i,k-1,j)*(2-fzm(k-1))
      vel = (2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j)
      g_fqx(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i-1,k,j))-0.083333333*(w(i+1,k,j)+w(i-2,k,j))+0.083333333*(w(i+1,k,j)-w(i-2,k,j)-&
&3.*(w(i,k,j)-w(i-1,k,j)))*sign(1.,vel))+g_w(i-2,k,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_w(i-1,k,j)*vel*&
&(0.58333333+0.25*sign(1.,vel))+g_w(i+1,k,j)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_w(i,k,j)*vel*(0.58333333+(-0.25)&
&*sign(1.,vel))
      fqx(i,k) = vel*(7./12.*(w(i,k,j)+w(i-1,k,j))-1./12.*(w(i+1,k,j)+w(i-2,k,j))+sign(1.,vel)*(1./12.)*(w(i+1,k,j)-w(i-2,k,j)-3.*&
&(w(i,k,j)-w(i-1,k,j))))
    end do
    if (degrade_xs) then
      do k = kts+1, ktf
        g_fqx(i_start,k) = 0.5*g_ru(i_start,k-1,j)*fzp(k)*(w(i_start,k,j)+w(i_start-1,k,j))+0.5*g_ru(i_start,k,j)*fzm(k)*&
&(w(i_start,k,j)+w(i_start-1,k,j))+0.5*g_w(i_start-1,k,j)*(fzm(k)*ru(i_start,k,j)+fzp(k)*ru(i_start,k-1,j))+0.5*&
&g_w(i_start,k,j)*(fzm(k)*ru(i_start,k,j)+fzp(k)*ru(i_start,k-1,j))
        fqx(i_start,k) = 0.5*(fzm(k)*ru(i_start,k,j)+fzp(k)*ru(i_start,k-1,j))*(w(i_start,k,j)+w(i_start-1,k,j))
      end do
      k = ktf+1
      g_fqx(i_start,k) = (-(0.5*g_ru(i_start,k-2,j)*fzp(k-1)*(w(i_start,k,j)+w(i_start-1,k,j))))+0.5*g_ru(i_start,k-1,j)*(2-fzm(k-&
&1))*(w(i_start,k,j)+w(i_start-1,k,j))+0.5*g_w(i_start-1,k,j)*((2.-fzm(k-1))*ru(i_start,k-1,j)-fzp(k-1)*ru(i_start,k-2,j))+&
&0.5*g_w(i_start,k,j)*((2.-fzm(k-1))*ru(i_start,k-1,j)-fzp(k-1)*ru(i_start,k-2,j))
      fqx(i_start,k) = 0.5*((2.-fzm(k-1))*ru(i_start,k-1,j)-fzp(k-1)*ru(i_start,k-2,j))*(w(i_start,k,j)+w(i_start-1,k,j))
    endif
    if (degrade_xe) then
      do k = kts+1, ktf
        g_fqx(i_end+1,k) = 0.5*g_ru(i_end+1,k-1,j)*fzp(k)*(w(i_end+1,k,j)+w(i_end,k,j))+0.5*g_ru(i_end+1,k,j)*fzm(k)*(w(i_end+1,k,&
&j)+w(i_end,k,j))+0.5*g_w(i_end+1,k,j)*(fzm(k)*ru(i_end+1,k,j)+fzp(k)*ru(i_end+1,k-1,j))+0.5*g_w(i_end,k,j)*(fzm(k)*&
&ru(i_end+1,k,j)+fzp(k)*ru(i_end+1,k-1,j))
        fqx(i_end+1,k) = 0.5*(fzm(k)*ru(i_end+1,k,j)+fzp(k)*ru(i_end+1,k-1,j))*(w(i_end+1,k,j)+w(i_end,k,j))
      end do
      k = ktf+1
      g_fqx(i_end+1,k) = (-(0.5*g_ru(i_end+1,k-2,j)*fzp(k-1)*(w(i_end+1,k,j)+w(i_end,k,j))))+0.5*g_ru(i_end+1,k-1,j)*(2-fzm(k-1))*&
&(w(i_end+1,k,j)+w(i_end,k,j))+0.5*g_w(i_end+1,k,j)*((2.-fzm(k-1))*ru(i_end+1,k-1,j)-fzp(k-1)*ru(i_end+1,k-2,j))+0.5*&
&g_w(i_end,k,j)*((2.-fzm(k-1))*ru(i_end+1,k-1,j)-fzp(k-1)*ru(i_end+1,k-2,j))
      fqx(i_end+1,k) = 0.5*((2.-fzm(k-1))*ru(i_end+1,k-1,j)-fzp(k-1)*ru(i_end+1,k-2,j))*(w(i_end+1,k,j)+w(i_end,k,j))
    endif
    do k = kts+1, ktf+1
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
        g_tendency(i,k,j) = (-(g_fqx(i+1,k)*mrdx))+g_fqx(i,k)*mrdx+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)-mrdx*(fqx(i+1,k)-fqx(i,k))
      end do
    end do
  end do
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  j_start_f = j_start
  j_end_f = j_end+1
  if (degrade_ys) then
    j_start = jds+1
    j_start_f = j_start+1
  endif
  if (degrade_ye) then
    j_end = jde-2
    j_end_f = jde-2
  endif
  jp1 = 2
  jp0 = 1
  do j = j_start, j_end+1
    if (j .lt. j_start_f .and. degrade_ys) then
      do k = kts+1, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.5*g_rv(i,k-1,j_start)*fzp(k)*(w(i,k,j_start)+w(i,k,j_start-1))+0.5*g_rv(i,k,j_start)*fzm(k)*(w(i,k,&
&j_start)+w(i,k,j_start-1))+0.5*g_w(i,k,j_start-1)*(fzm(k)*rv(i,k,j_start)+fzp(k)*rv(i,k-1,j_start))+0.5*g_w(i,k,j_start)&
&*(fzm(k)*rv(i,k,j_start)+fzp(k)*rv(i,k-1,j_start))
          fqy(i,k,jp1) = 0.5*(fzm(k)*rv(i,k,j_start)+fzp(k)*rv(i,k-1,j_start))*(w(i,k,j_start)+w(i,k,j_start-1))
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_fqy(i,k,jp1) = (-(0.5*g_rv(i,k-2,j_start)*fzp(k-1)*(w(i,k,j_start)+w(i,k,j_start-1))))+0.5*g_rv(i,k-1,j_start)*(2-fzm(k-&
&1))*(w(i,k,j_start)+w(i,k,j_start-1))+0.5*g_w(i,k,j_start-1)*((2.-fzm(k-1))*rv(i,k-1,j_start)-fzp(k-1)*rv(i,k-2,j_start))+&
&0.5*g_w(i,k,j_start)*((2.-fzm(k-1))*rv(i,k-1,j_start)-fzp(k-1)*rv(i,k-2,j_start))
        fqy(i,k,jp1) = 0.5*((2.-fzm(k-1))*rv(i,k-1,j_start)-fzp(k-1)*rv(i,k-2,j_start))*(w(i,k,j_start)+w(i,k,j_start-1))
      end do
    else if (j .gt. j_end_f .and. degrade_ye) then
      do k = kts+1, ktf
        do i = i_start, i_end
          g_fqy(i,k,jp1) = 0.5*g_rv(i,k-1,j_end+1)*fzp(k)*(w(i,k,j_end+1)+w(i,k,j_end))+0.5*g_rv(i,k,j_end+1)*fzm(k)*(w(i,k,j_end+&
&1)+w(i,k,j_end))+0.5*g_w(i,k,j_end+1)*(fzm(k)*rv(i,k,j_end+1)+fzp(k)*rv(i,k-1,j_end+1))+0.5*g_w(i,k,j_end)*(fzm(k)*rv(i,&
&k,j_end+1)+fzp(k)*rv(i,k-1,j_end+1))
          fqy(i,k,jp1) = 0.5*(fzm(k)*rv(i,k,j_end+1)+fzp(k)*rv(i,k-1,j_end+1))*(w(i,k,j_end+1)+w(i,k,j_end))
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_fqy(i,k,jp1) = (-(0.5*g_rv(i,k-2,j_end+1)*fzp(k-1)*(w(i,k,j_end+1)+w(i,k,j_end))))+0.5*g_rv(i,k-1,j_end+1)*(2-fzm(k-1))*&
&(w(i,k,j_end+1)+w(i,k,j_end))+0.5*g_w(i,k,j_end+1)*((2.-fzm(k-1))*rv(i,k-1,j_end+1)-fzp(k-1)*rv(i,k-2,j_end+1))+0.5*g_w(i,&
&k,j_end)*((2.-fzm(k-1))*rv(i,k-1,j_end+1)-fzp(k-1)*rv(i,k-2,j_end+1))
        fqy(i,k,jp1) = 0.5*((2.-fzm(k-1))*rv(i,k-1,j_end+1)-fzp(k-1)*rv(i,k-2,j_end+1))*(w(i,k,j_end+1)+w(i,k,j_end))
      end do
    else
      do k = kts+1, ktf
        do i = i_start, i_end
          g_vel = g_rv(i,k-1,j)*fzp(k)+g_rv(i,k,j)*fzm(k)
          vel = fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
          g_fqy(i,k,jp1) = g_vel*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2))+0.083333333*(w(i,k,j+1)-w(i,&
&k,j-2)-3.*(w(i,k,j)-w(i,k,j-1)))*sign(1.,vel))+g_w(i,k,j-2)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_w(i,k,j-&
&1)*vel*(0.58333333+0.25*sign(1.,vel))+g_w(i,k,j+1)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_w(i,k,j)*vel*&
&(0.58333333+(-0.25)*sign(1.,vel))
          fqy(i,k,jp1) = vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2))+sign(1.,vel)*(1./12.)*(w(i,k,j+1)-w(i,k,&
&j-2)-3.*(w(i,k,j)-w(i,k,j-1))))
        end do
      end do
      k = ktf+1
      do i = i_start, i_end
        g_vel = (-(g_rv(i,k-2,j)*fzp(k-1)))+g_rv(i,k-1,j)*(2-fzm(k-1))
        vel = (2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j)
        g_fqy(i,k,jp1) = g_vel*(0.58333333*(w(i,k,j)+w(i,k,j-1))-0.083333333*(w(i,k,j+1)+w(i,k,j-2))+0.083333333*(w(i,k,j+1)-w(i,k,&
&j-2)-3.*(w(i,k,j)-w(i,k,j-1)))*sign(1.,vel))+g_w(i,k,j-2)*vel*((-0.083333333)+(-0.083333333)*sign(1.,vel))+g_w(i,k,j-1)*&
&vel*(0.58333333+0.25*sign(1.,vel))+g_w(i,k,j+1)*vel*((-0.083333333)+0.083333333*sign(1.,vel))+g_w(i,k,j)*vel*(0.58333333+&
&(-0.25)*sign(1.,vel))
        fqy(i,k,jp1) = vel*(7./12.*(w(i,k,j)+w(i,k,j-1))-1./12.*(w(i,k,j+1)+w(i,k,j-2))+sign(1.,vel)*(1./12.)*(w(i,k,j+1)-w(i,k,j-&
&2)-3.*(w(i,k,j)-w(i,k,j-1))))
      end do
    endif
    if (j .gt. j_start) then
      do k = kts+1, ktf+1
        do i = i_start, i_end
          mrdy = msft(i,j-1)*rdy
          g_tendency(i,k,j-1) = g_fqy(i,k,jp0)*mrdy-g_fqy(i,k,jp1)*mrdy+g_tendency(i,k,j-1)
          tendency(i,k,j-1) = tendency(i,k,j-1)-mrdy*(fqy(i,k,jp1)-fqy(i,k,jp0))
        end do
      end do
    endif
    jtmp = jp1
    jp1 = jp0
    jp0 = jtmp
  end do
else if (horz_order .eq. 2) then horizontal_order_tesu
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-2,ite)
  endif
  do j = j_start, j_end
    do k = kts+1, ktf
      do i = i_start, i_end
        mrdx = msft(i,j)*rdx
        g_tendency(i,k,j) = (-(0.5*g_ru(i+1,k-1,j)*mrdx*fzp(k)*(w(i+1,k,j)+w(i,k,j))))+0.5*g_ru(i,k-1,j)*mrdx*fzp(k)*(w(i,k,j)+w(i-&
&1,k,j))-0.5*g_ru(i+1,k,j)*mrdx*fzm(k)*(w(i+1,k,j)+w(i,k,j))+0.5*g_ru(i,k,j)*mrdx*fzm(k)*(w(i,k,j)+w(i-1,k,j))+&
&g_tendency(i,k,j)+0.5*g_w(i-1,k,j)*mrdx*(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j))-0.5*g_w(i+1,k,j)*mrdx*(fzm(k)*ru(i+1,k,j)+&
&fzp(k)*ru(i+1,k-1,j))-0.5*g_w(i,k,j)*mrdx*(fzm(k)*ru(i+1,k,j)+fzp(k)*ru(i+1,k-1,j)-(fzm(k)*ru(i,k,j)+fzp(k)*ru(i,k-1,j)))
        tendency(i,k,j) = tendency(i,k,j)-mrdx*0.5*((fzm(k)*ru(i+1,k,j)+fzp(k)*ru(i+1,k-1,j))*(w(i+1,k,j)+w(i,k,j))-(fzm(k)*ru(i,k,&
&j)+fzp(k)*ru(i,k-1,j))*(w(i,k,j)+w(i-1,k,j)))
      end do
    end do
    k = ktf+1
    do i = i_start, i_end
      mrdx = msft(i,j)*rdx
      g_tendency(i,k,j) = 0.5*g_ru(i+1,k-2,j)*mrdx*fzp(k-1)*(w(i+1,k,j)+w(i,k,j))-0.5*g_ru(i,k-2,j)*mrdx*fzp(k-1)*(w(i,k,j)+w(i-1,&
&k,j))-0.5*g_ru(i+1,k-1,j)*mrdx*(2-fzm(k-1))*(w(i+1,k,j)+w(i,k,j))+0.5*g_ru(i,k-1,j)*mrdx*(2-fzm(k-1))*(w(i,k,j)+w(i-1,k,j))+&
&g_tendency(i,k,j)+0.5*g_w(i-1,k,j)*mrdx*((2.-fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))-0.5*g_w(i+1,k,j)*mrdx*((2.-fzm(k-1)&
&)*ru(i+1,k-1,j)-fzp(k-1)*ru(i+1,k-2,j))-0.5*g_w(i,k,j)*mrdx*((2.-fzm(k-1))*ru(i+1,k-1,j)-fzp(k-1)*ru(i+1,k-2,j)-((2.-fzm(k-&
&1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j)))
      tendency(i,k,j) = tendency(i,k,j)-mrdx*0.5*(((2.-fzm(k-1))*ru(i+1,k-1,j)-fzp(k-1)*ru(i+1,k-2,j))*(w(i+1,k,j)+w(i,k,j))-((2.-&
&fzm(k-1))*ru(i,k-1,j)-fzp(k-1)*ru(i,k-2,j))*(w(i,k,j)+w(i-1,k,j)))
    end do
  end do
  i_start = its
  i_end = min(ite,ide-1)
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-2,jte)
  endif
  do j = j_start, j_end
    do k = kts+1, ktf
      do i = i_start, i_end
        mrdy = msft(i,j)*rdy
        walls(1)=fzm(k)*rv(i,k,j)+fzp(k)*rv(i,k-1,j)
        g_tendency(i,k,j) = (-(0.5*g_rv(i,k-1,j+1)*mrdy*fzp(k)*(w(i,k,j+1)+w(i,k,j))))+0.5*g_rv(i,k-1,j)*mrdy*fzp(k)*(w(i,k,j)+w(i,&
&k,j-1))-0.5*g_rv(i,k,j+1)*mrdy*fzm(k)*(w(i,k,j+1)+w(i,k,j))+0.5*g_rv(i,k,j)*mrdy*fzm(k)*(w(i,k,j)+w(i,k,j-1))+&
&g_tendency(i,k,j)+0.5*g_w(i,k,j-1)*mrdy*walls(1)-0.5*g_w(i,k,j+1)*mrdy*(fzm(k)*rv(i,k,j+1)+&
&fzp(k)*rv(i,k-1,j+1))-0.5*g_w(i,k,j)*mrdy*(fzm(k)*rv(i,k,j+1)+fzp(k)*rv(i,k-1,j+1)-walls(1))
        tendency(i,k,j) = tendency(i,k,j)-mrdy*0.5*((fzm(k)*rv(i,k,j+1)+fzp(k)*rv(i,k-1,j+1))*(w(i,k,j+1)+w(i,k,j))-(fzm(k)*rv(i,k,&
&j)+fzp(k)*rv(i,k-1,j))*(w(i,k,j)+w(i,k,j-1)))
      end do
    end do
    k = ktf+1
    do i = i_start, i_end
      mrdy = msft(i,j)*rdy
      g_tendency(i,k,j) = 0.5*g_rv(i,k-2,j+1)*mrdy*fzp(k-1)*(w(i,k,j+1)+w(i,k,j))-0.5*g_rv(i,k-2,j)*mrdy*fzp(k-1)*(w(i,k,j)+w(i,k,&
&j-1))-0.5*g_rv(i,k-1,j+1)*mrdy*(2-fzm(k-1))*(w(i,k,j+1)+w(i,k,j))+0.5*g_rv(i,k-1,j)*mrdy*(2-fzm(k-1))*(w(i,k,j)+w(i,k,j-1))+&
&g_tendency(i,k,j)+0.5*g_w(i,k,j-1)*mrdy*((2.-fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j))-0.5*g_w(i,k,j+1)*mrdy*((2.-fzm(k-1)&
&)*rv(i,k-1,j+1)-fzp(k-1)*rv(i,k-2,j+1))-0.5*g_w(i,k,j)*mrdy*((2.-fzm(k-1))*rv(i,k-1,j+1)-fzp(k-1)*rv(i,k-2,j+1)-((2.-fzm(k-&
&1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j)))
      tendency(i,k,j) = tendency(i,k,j)-mrdy*0.5*(((2.-fzm(k-1))*rv(i,k-1,j+1)-fzp(k-1)*rv(i,k-2,j+1))*(w(i,k,j+1)+w(i,k,j))-((2.-&
&fzm(k-1))*rv(i,k-1,j)-fzp(k-1)*rv(i,k-2,j))*(w(i,k,j)+w(i,k,j-1)))
    end do
  end do
else horizontal_order_tesu
  write(unit=wrf_err_message,fmt=*) ' advect_w_6a, h_order not known ',horz_order
endif horizontal_order_tesu
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
if (config_flags%open_xs .and. its .eq. ids) then
  do j = j_start, j_end
    do k = kts+1, ktf
      g_uw = 0.5*g_ru(its+1,k-1,j)*fzp(k)+0.5*g_ru(its,k-1,j)*fzp(k)+0.5*g_ru(its+1,k,j)*fzm(k)+0.5*g_ru(its,k,j)*fzm(k)
      uw = 0.5*(fzm(k)*(ru(its,k,j)+ru(its+1,k,j))+fzp(k)*(ru(its,k-1,j)+ru(its+1,k-1,j)))
      g_ub = g_uw*(0.5+sign(0.5,0.-uw))
      ub = min(uw,0.)
      g_tendency(its,k,j) = (-(g_ru(its+1,k-1,j)*rdx*w(its,k,j)*fzp(k)))+g_ru(its,k-1,j)*rdx*w(its,k,j)*fzp(k)-g_ru(its+1,k,j)*rdx*&
&w(its,k,j)*fzm(k)+g_ru(its,k,j)*rdx*w(its,k,j)*fzm(k)+g_tendency(its,k,j)-g_ub*rdx*(w_old(its+1,k,j)-w_old(its,k,j))-&
&g_w(its,k,j)*rdx*(fzm(k)*(ru(its+1,k,j)-ru(its,k,j))+fzp(k)*(ru(its+1,k-1,j)-ru(its,k-1,j)))-g_w_old(its+1,k,j)*rdx*ub+&
&g_w_old(its,k,j)*rdx*ub
      tendency(its,k,j) = tendency(its,k,j)-rdx*(ub*(w_old(its+1,k,j)-w_old(its,k,j))+w(its,k,j)*(fzm(k)*(ru(its+1,k,j)-ru(its,k,j)&
&)+fzp(k)*(ru(its+1,k-1,j)-ru(its,k-1,j))))
    end do
  end do
  k = ktf+1
  do j = j_start, j_end
    g_uw = (-(0.5*g_ru(its+1,k-2,j)*fzp(k-1)))-0.5*g_ru(its,k-2,j)*fzp(k-1)+0.5*g_ru(its+1,k-1,j)*(2-fzm(k-1))+0.5*g_ru(its,k-1,j)*&
&(2-fzm(k-1))
    uw = 0.5*((2.-fzm(k-1))*(ru(its,k-1,j)+ru(its+1,k-1,j))-fzp(k-1)*(ru(its,k-2,j)+ru(its+1,k-2,j)))
    g_ub = g_uw*(0.5+sign(0.5,0.-uw))
    ub = min(uw,0.)
    g_tendency(its,k,j) = g_ru(its+1,k-2,j)*rdx*w(its,k,j)*fzp(k-1)-g_ru(its,k-2,j)*rdx*w(its,k,j)*fzp(k-1)-g_ru(its+1,k-1,j)*rdx*&
&w(its,k,j)*(2-fzm(k-1))+g_ru(its,k-1,j)*rdx*w(its,k,j)*(2.-fzm(k-1))+g_tendency(its,k,j)-g_ub*rdx*(w_old(its+1,k,j)-w_old(its,&
&k,j))-g_w(its,k,j)*rdx*((2.-fzm(k-1))*(ru(its+1,k-1,j)-ru(its,k-1,j))-fzp(k-1)*(ru(its+1,k-2,j)-ru(its,k-2,j)))-g_w_old(its+1,&
&k,j)*rdx*ub+g_w_old(its,k,j)*rdx*ub
    tendency(its,k,j) = tendency(its,k,j)-rdx*(ub*(w_old(its+1,k,j)-w_old(its,k,j))+w(its,k,j)*((2.-fzm(k-1))*(ru(its+1,k-1,j)-&
&ru(its,k-1,j))-fzp(k-1)*(ru(its+1,k-2,j)-ru(its,k-2,j))))
  end do
endif
if (config_flags%open_xe .and. ite .eq. ide) then
  do j = j_start, j_end
    do k = kts+1, ktf
      g_uw = 0.5*g_ru(ite-1,k-1,j)*fzp(k)+0.5*g_ru(ite,k-1,j)*fzp(k)+0.5*g_ru(ite-1,k,j)*fzm(k)+0.5*g_ru(ite,k,j)*fzm(k)
      uw = 0.5*(fzm(k)*(ru(ite-1,k,j)+ru(ite,k,j))+fzp(k)*(ru(ite-1,k-1,j)+ru(ite,k-1,j)))
      g_ub = g_uw*(0.5+sign(0.5,uw-0.))
      ub = max(uw,0.)
      g_tendency(i_end,k,j) = g_ru(ite-1,k-1,j)*rdx*w(i_end,k,j)*fzp(k)-g_ru(ite,k-1,j)*rdx*w(i_end,k,j)*fzp(k)+g_ru(ite-1,k,j)*&
&rdx*w(i_end,k,j)*fzm(k)-g_ru(ite,k,j)*rdx*w(i_end,k,j)*fzm(k)+g_tendency(i_end,k,j)-g_ub*rdx*(w_old(i_end,k,j)-w_old(i_end-&
&1,k,j))-g_w(i_end,k,j)*rdx*(fzm(k)*(ru(ite,k,j)-ru(ite-1,k,j))+fzp(k)*(ru(ite,k-1,j)-ru(ite-1,k-1,j)))+g_w_old(i_end-1,k,j)*&
&rdx*ub-g_w_old(i_end,k,j)*rdx*ub
      tendency(i_end,k,j) = tendency(i_end,k,j)-rdx*(ub*(w_old(i_end,k,j)-w_old(i_end-1,k,j))+w(i_end,k,j)*(fzm(k)*(ru(ite,k,j)-&
&ru(ite-1,k,j))+fzp(k)*(ru(ite,k-1,j)-ru(ite-1,k-1,j))))
    end do
  end do
  k = ktf+1
  do j = j_start, j_end
    g_uw = (-(0.5*g_ru(ite-1,k-2,j)*fzp(k-1)))-0.5*g_ru(ite,k-2,j)*fzp(k-1)+0.5*g_ru(ite-1,k-1,j)*(2-fzm(k-1))+0.5*g_ru(ite,k-1,j)*&
&(2-fzm(k-1))
    uw = 0.5*((2.-fzm(k-1))*(ru(ite-1,k-1,j)+ru(ite,k-1,j))-fzp(k-1)*(ru(ite-1,k-2,j)+ru(ite,k-2,j)))
    g_ub = g_uw*(0.5+sign(0.5,uw-0.))
    ub = max(uw,0.)
    g_tendency(i_end,k,j) = (-(g_ru(ite-1,k-2,j)*rdx*w(i_end,k,j)*fzp(k-1)))+g_ru(ite,k-2,j)*rdx*w(i_end,k,j)*fzp(k-1)+g_ru(ite-1,&
&k-1,j)*rdx*w(i_end,k,j)*(2.-fzm(k-1))-g_ru(ite,k-1,j)*rdx*w(i_end,k,j)*(2-fzm(k-1))+g_tendency(i_end,k,j)-g_ub*rdx*&
&(w_old(i_end,k,j)-w_old(i_end-1,k,j))-g_w(i_end,k,j)*rdx*((2.-fzm(k-1))*(ru(ite,k-1,j)-ru(ite-1,k-1,j))-fzp(k-1)*(ru(ite,k-2,&
&j)-ru(ite-1,k-2,j)))+g_w_old(i_end-1,k,j)*rdx*ub-g_w_old(i_end,k,j)*rdx*ub
    tendency(i_end,k,j) = tendency(i_end,k,j)-rdx*(ub*(w_old(i_end,k,j)-w_old(i_end-1,k,j))+w(i_end,k,j)*((2.-fzm(k-1))*(ru(ite,k-&
&1,j)-ru(ite-1,k-1,j))-fzp(k-1)*(ru(ite,k-2,j)-ru(ite-1,k-2,j))))
  end do
endif
if (config_flags%open_ys .and. jts .eq. jds) then
  do i = i_start, i_end
    do k = kts+1, ktf
      g_vw = 0.5*g_rv(i,k-1,jts+1)*fzp(k)+0.5*g_rv(i,k-1,jts)*fzp(k)+0.5*g_rv(i,k,jts+1)*fzm(k)+0.5*g_rv(i,k,jts)*fzm(k)
      vw = 0.5*(fzm(k)*(rv(i,k,jts)+rv(i,k,jts+1))+fzp(k)*(rv(i,k-1,jts)+rv(i,k-1,jts+1)))
      g_vb = g_vw*(0.5+sign(0.5,0.-vw))
      vb = min(vw,0.)
      g_tendency(i,k,jts) = (-(g_rv(i,k-1,jts+1)*rdy*w(i,k,jts)*fzp(k)))+g_rv(i,k-1,jts)*rdy*w(i,k,jts)*fzp(k)-g_rv(i,k,jts+1)*rdy*&
&w(i,k,jts)*fzm(k)+g_rv(i,k,jts)*rdy*w(i,k,jts)*fzm(k)+g_tendency(i,k,jts)-g_vb*rdy*(w_old(i,k,jts+1)-w_old(i,k,jts))-g_w(i,&
&k,jts)*rdy*(fzm(k)*(rv(i,k,jts+1)-rv(i,k,jts))+fzp(k)*(rv(i,k-1,jts+1)-rv(i,k-1,jts)))-g_w_old(i,k,jts+1)*rdy*vb+g_w_old(i,&
&k,jts)*rdy*vb
      tendency(i,k,jts) = tendency(i,k,jts)-rdy*(vb*(w_old(i,k,jts+1)-w_old(i,k,jts))+w(i,k,jts)*(fzm(k)*(rv(i,k,jts+1)-rv(i,k,jts)&
&)+fzp(k)*(rv(i,k-1,jts+1)-rv(i,k-1,jts))))
    end do
  end do
  k = ktf+1
  do i = i_start, i_end
    g_vw = (-(0.5*g_rv(i,k-2,jts+1)*fzp(k-1)))-0.5*g_rv(i,k-2,jts)*fzp(k-1)+0.5*g_rv(i,k-1,jts+1)*(2-fzm(k-1))+0.5*g_rv(i,k-1,jts)*&
&(2-fzm(k-1))
    vw = 0.5*((2.-fzm(k-1))*(rv(i,k-1,jts)+rv(i,k-1,jts+1))-fzp(k-1)*(rv(i,k-2,jts)+rv(i,k-2,jts+1)))
    g_vb = g_vw*(0.5+sign(0.5,0.-vw))
    vb = min(vw,0.)
    g_tendency(i,k,jts) = g_rv(i,k-2,jts+1)*rdy*w(i,k,jts)*fzp(k-1)-g_rv(i,k-2,jts)*rdy*w(i,k,jts)*fzp(k-1)-g_rv(i,k-1,jts+1)*rdy*&
&w(i,k,jts)*(2-fzm(k-1))+g_rv(i,k-1,jts)*rdy*w(i,k,jts)*(2.-fzm(k-1))+g_tendency(i,k,jts)-g_vb*rdy*(w_old(i,k,jts+1)-w_old(i,k,&
&jts))-g_w(i,k,jts)*rdy*((2.-fzm(k-1))*(rv(i,k-1,jts+1)-rv(i,k-1,jts))-fzp(k-1)*(rv(i,k-2,jts+1)-rv(i,k-2,jts)))-g_w_old(i,k,&
&jts+1)*rdy*vb+g_w_old(i,k,jts)*rdy*vb
    tendency(i,k,jts) = tendency(i,k,jts)-rdy*(vb*(w_old(i,k,jts+1)-w_old(i,k,jts))+w(i,k,jts)*((2.-fzm(k-1))*(rv(i,k-1,jts+1)-&
&rv(i,k-1,jts))-fzp(k-1)*(rv(i,k-2,jts+1)-rv(i,k-2,jts))))
  end do
endif
if (config_flags%open_ye .and. jte .eq. jde) then
  do i = i_start, i_end
    do k = kts+1, ktf
      g_vw = 0.5*g_rv(i,k-1,jte-1)*fzp(k)+0.5*g_rv(i,k-1,jte)*fzp(k)+0.5*g_rv(i,k,jte-1)*fzm(k)+0.5*g_rv(i,k,jte)*fzm(k)
      vw = 0.5*(fzm(k)*(rv(i,k,jte-1)+rv(i,k,jte))+fzp(k)*(rv(i,k-1,jte-1)+rv(i,k-1,jte)))
      g_vb = g_vw*(0.5+sign(0.5,vw-0.))
      vb = max(vw,0.)
      g_tendency(i,k,j_end) = g_rv(i,k-1,jte-1)*rdy*w(i,k,j_end)*fzp(k)-g_rv(i,k-1,jte)*rdy*w(i,k,j_end)*fzp(k)+g_rv(i,k,jte-1)*&
&rdy*w(i,k,j_end)*fzm(k)-g_rv(i,k,jte)*rdy*w(i,k,j_end)*fzm(k)+g_tendency(i,k,j_end)-g_vb*rdy*(w_old(i,k,j_end)-w_old(i,k,&
&j_end-1))-g_w(i,k,j_end)*rdy*(fzm(k)*(rv(i,k,jte)-rv(i,k,jte-1))+fzp(k)*(rv(i,k-1,jte)-rv(i,k-1,jte-1)))+g_w_old(i,k,j_end-&
&1)*rdy*vb-g_w_old(i,k,j_end)*rdy*vb
      tendency(i,k,j_end) = tendency(i,k,j_end)-rdy*(vb*(w_old(i,k,j_end)-w_old(i,k,j_end-1))+w(i,k,j_end)*(fzm(k)*(rv(i,k,jte)-&
&rv(i,k,jte-1))+fzp(k)*(rv(i,k-1,jte)-rv(i,k-1,jte-1))))
    end do
  end do
  k = ktf+1
  do i = i_start, i_end
    g_vw = (-(0.5*g_rv(i,k-2,jte-1)*fzp(k-1)))-0.5*g_rv(i,k-2,jte)*fzp(k-1)+0.5*g_rv(i,k-1,jte-1)*(2-fzm(k-1))+0.5*g_rv(i,k-1,jte)*&
&(2-fzm(k-1))
    vw = 0.5*((2.-fzm(k-1))*(rv(i,k-1,jte-1)+rv(i,k-1,jte))-fzp(k-1)*(rv(i,k-2,jte-1)+rv(i,k-2,jte)))
    g_vb = g_vw*(0.5+sign(0.5,vw-0.))
    vb = max(vw,0.)
    g_tendency(i,k,j_end) = (-(g_rv(i,k-2,jte-1)*rdy*w(i,k,j_end)*fzp(k-1)))+g_rv(i,k-2,jte)*rdy*w(i,k,j_end)*fzp(k-1)+g_rv(i,k-1,&
&jte-1)*rdy*w(i,k,j_end)*(2.-fzm(k-1))-g_rv(i,k-1,jte)*rdy*w(i,k,j_end)*(2-fzm(k-1))+g_tendency(i,k,j_end)-g_vb*rdy*(w_old(i,k,&
&j_end)-w_old(i,k,j_end-1))-g_w(i,k,j_end)*rdy*((2.-fzm(k-1))*(rv(i,k-1,jte)-rv(i,k-1,jte-1))-fzp(k-1)*(rv(i,k-2,jte)-rv(i,k-2,&
&jte-1)))+g_w_old(i,k,j_end-1)*rdy*vb-g_w_old(i,k,j_end)*rdy*vb
    tendency(i,k,j_end) = tendency(i,k,j_end)-rdy*(vb*(w_old(i,k,j_end)-w_old(i,k,j_end-1))+w(i,k,j_end)*((2.-fzm(k-1))*(rv(i,k-1,&
&jte)-rv(i,k-1,jte-1))-fzp(k-1)*(rv(i,k-2,jte)-rv(i,k-2,jte-1))))
  end do
endif
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
do i = i_start, i_end
  g_vflux(i,kts) = 0.
  vflux(i,kts) = 0.
  g_vflux(i,kte) = 0.
  vflux(i,kte) = 0.
end do
vert_order_tesu: if (vert_order .eq. 6) then
  do j = j_start, j_end
    do k = kts+3, ktf-1
      do i = i_start, i_end
        g_vel = 0.5*g_rom(i,k-1,j)+0.5*g_rom(i,k,j)
        vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
        g_vflux(i,k) = g_vel*(0.61666667*(w(i,k,j)+w(i,k-1,j))-0.13333333*(w(i,k+1,j)+w(i,k-2,j))+0.016666667*(w(i,k+2,j)+w(i,k-3,&
&j)))+0.016666667*g_w(i,k-3,j)*vel-0.13333333*g_w(i,k-2,j)*vel+0.61666667*g_w(i,k-1,j)*vel+0.016666667*g_w(i,k+2,j)*vel-&
&0.13333333*g_w(i,k+1,j)*vel+0.61666667*g_w(i,k,j)*vel
        vflux(i,k) = vel*(37./60.*(w(i,k,j)+w(i,k-1,j))-2./15.*(w(i,k+1,j)+w(i,k-2,j))+1./60.*(w(i,k+2,j)+w(i,k-3,j)))
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = 0.25*g_rom(i,k-1,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_rom(i,k,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_w(i,k-1,j)*(rom(i,k,&
&j)+rom(i,k-1,j))+0.25*g_w(i,k,j)*(rom(i,k,j)+rom(i,k-1,j))
      vflux(i,k) = 0.25*(rom(i,k,j)+rom(i,k-1,j))*(w(i,k,j)+w(i,k-1,j))
      k = kts+2
      g_vel = 0.5*g_rom(i,k-1,j)+0.5*g_rom(i,k,j)
      vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
      g_vflux(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i,k-1,j))-0.083333333*(w(i,k+1,j)+w(i,k-2,j)))-0.083333333*g_w(i,k-2,j)*vel+&
&0.58333333*g_w(i,k-1,j)*vel-0.083333333*g_w(i,k+1,j)*vel+0.58333333*g_w(i,k,j)*vel
      vflux(i,k) = vel*(7./12.*(w(i,k,j)+w(i,k-1,j))-1./12.*(w(i,k+1,j)+w(i,k-2,j)))
      k = ktf
      g_vel = 0.5*g_rom(i,k-1,j)+0.5*g_rom(i,k,j)
      vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
      g_vflux(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i,k-1,j))-0.083333333*(w(i,k+1,j)+w(i,k-2,j)))-0.083333333*g_w(i,k-2,j)*vel+&
&0.58333333*g_w(i,k-1,j)*vel-0.083333333*g_w(i,k+1,j)*vel+0.58333333*g_w(i,k,j)*vel
      vflux(i,k) = vel*(7./12.*(w(i,k,j)+w(i,k-1,j))-1./12.*(w(i,k+1,j)+w(i,k-2,j)))
      k = ktf+1
      g_vflux(i,k) = 0.25*g_rom(i,k-1,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_rom(i,k,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_w(i,k-1,j)*(rom(i,k,&
&j)+rom(i,k-1,j))+0.25*g_w(i,k,j)*(rom(i,k,j)+rom(i,k-1,j))
      vflux(i,k) = 0.25*(rom(i,k,j)+rom(i,k-1,j))*(w(i,k,j)+w(i,k-1,j))
    end do
    do k = kts+1, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzu(k)+g_vflux(i,k)*rdzu(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzu(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
    k = ktf+1
    do i = i_start, i_end
      g_tendency(i,k,j) = g_tendency(i,k,j)+2*g_vflux(i,k)*rdzu(k-1)
      tendency(i,k,j) = tendency(i,k,j)+2.*rdzu(k-1)*vflux(i,k)
    end do
  end do
else if (vert_order .eq. 5) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+3, ktf-1
      do i = i_start, i_end
        g_vel = 0.5*g_rom(i,k-1,j)+0.5*g_rom(i,k,j)
        vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
        g_vflux(i,k) = g_vel*(0.61666667*(w(i,k,j)+w(i,k-1,j))-0.13333333*(w(i,k+1,j)+w(i,k-2,j))+0.016666667*(w(i,k+2,j)+w(i,k-3,&
&j))-0.016666667*(w(i,k+2,j)-w(i,k-3,j)-5.*(w(i,k+1,j)-w(i,k-2,j))+10.*(w(i,k,j)-w(i,k-1,j)))*sign(1.,-vel))+g_w(i,k-3,j)*&
&vel*(0.016666667-(-0.016666667)*sign(1.,-vel))+g_w(i,k-2,j)*vel*((-0.13333333)-0.083333333*sign(1.,-vel))+g_w(i,k-1,j)*&
&vel*(0.61666667-(-0.16666667)*sign(1.,-vel))+g_w(i,k+2,j)*vel*(0.016666667-0.016666667*sign(1.,-vel))+g_w(i,k+1,j)*vel*((-&
&0.13333333)-(-0.083333333)*sign(1.,-vel))+g_w(i,k,j)*vel*(0.61666667-0.16666667*sign(1.,-vel))
        vflux(i,k) = vel*(37./60.*(w(i,k,j)+w(i,k-1,j))-2./15.*(w(i,k+1,j)+w(i,k-2,j))+1./60.*(w(i,k+2,j)+w(i,k-3,j))-sign(1.,-vel)&
&*(1./60.)*(w(i,k+2,j)-w(i,k-3,j)-5.*(w(i,k+1,j)-w(i,k-2,j))+10.*(w(i,k,j)-w(i,k-1,j))))
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = 0.25*g_rom(i,k-1,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_rom(i,k,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_w(i,k-1,j)*(rom(i,k,&
&j)+rom(i,k-1,j))+0.25*g_w(i,k,j)*(rom(i,k,j)+rom(i,k-1,j))
      vflux(i,k) = 0.25*(rom(i,k,j)+rom(i,k-1,j))*(w(i,k,j)+w(i,k-1,j))
      k = kts+2
      g_vel = 0.5*g_rom(i,k-1,j)+0.5*g_rom(i,k,j)
      vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
      g_vflux(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i,k-1,j))-0.083333333*(w(i,k+1,j)+w(i,k-2,j))+0.083333333*(w(i,k+1,j)-w(i,k-2,j)&
&-3.*(w(i,k,j)-w(i,k-1,j)))*sign(1.,-vel))+g_w(i,k-2,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,-vel))+g_w(i,k-1,j)*vel*&
&(0.58333333+0.25*sign(1.,-vel))+g_w(i,k+1,j)*vel*((-0.083333333)+0.083333333*sign(1.,-vel))+g_w(i,k,j)*vel*(0.58333333+(-&
&0.25)*sign(1.,-vel))
      vflux(i,k) = vel*(7./12.*(w(i,k,j)+w(i,k-1,j))-1./12.*(w(i,k+1,j)+w(i,k-2,j))+sign(1.,-vel)*(1./12.)*(w(i,k+1,j)-w(i,k-2,j)-&
&3.*(w(i,k,j)-w(i,k-1,j))))
      k = ktf
      g_vel = 0.5*g_rom(i,k-1,j)+0.5*g_rom(i,k,j)
      vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
      g_vflux(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i,k-1,j))-0.083333333*(w(i,k+1,j)+w(i,k-2,j))+0.083333333*(w(i,k+1,j)-w(i,k-2,j)&
&-3.*(w(i,k,j)-w(i,k-1,j)))*sign(1.,-vel))+g_w(i,k-2,j)*vel*((-0.083333333)+(-0.083333333)*sign(1.,-vel))+g_w(i,k-1,j)*vel*&
&(0.58333333+0.25*sign(1.,-vel))+g_w(i,k+1,j)*vel*((-0.083333333)+0.083333333*sign(1.,-vel))+g_w(i,k,j)*vel*(0.58333333+(-&
&0.25)*sign(1.,-vel))
      vflux(i,k) = vel*(7./12.*(w(i,k,j)+w(i,k-1,j))-1./12.*(w(i,k+1,j)+w(i,k-2,j))+sign(1.,-vel)*(1./12.)*(w(i,k+1,j)-w(i,k-2,j)-&
&3.*(w(i,k,j)-w(i,k-1,j))))
      k = ktf+1
      g_vflux(i,k) = 0.25*g_rom(i,k-1,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_rom(i,k,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_w(i,k-1,j)*(rom(i,k,&
&j)+rom(i,k-1,j))+0.25*g_w(i,k,j)*(rom(i,k,j)+rom(i,k-1,j))
      vflux(i,k) = 0.25*(rom(i,k,j)+rom(i,k-1,j))*(w(i,k,j)+w(i,k-1,j))
    end do
    do k = kts+1, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzu(k)+g_vflux(i,k)*rdzu(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzu(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
    k = ktf+1
    do i = i_start, i_end
      g_tendency(i,k,j) = g_tendency(i,k,j)+2*g_vflux(i,k)*rdzu(k-1)
      tendency(i,k,j) = tendency(i,k,j)+2.*rdzu(k-1)*vflux(i,k)
    end do
  end do
else if (vert_order .eq. 4) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+2, ktf
      do i = i_start, i_end
        g_vel = 0.5*g_rom(i,k-1,j)+0.5*g_rom(i,k,j)
        vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
        g_vflux(i,k) = g_vel*(0.58333333*(w(i,k,j)+w(i,k-1,j))-0.083333333*(w(i,k+1,j)+w(i,k-2,j)))-0.083333333*g_w(i,k-2,j)*vel+&
&0.58333333*g_w(i,k-1,j)*vel-0.083333333*g_w(i,k+1,j)*vel+0.58333333*g_w(i,k,j)*vel
        vflux(i,k) = vel*(7./12.*(w(i,k,j)+w(i,k-1,j))-1./12.*(w(i,k+1,j)+w(i,k-2,j)))
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = 0.25*g_rom(i,k-1,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_rom(i,k,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_w(i,k-1,j)*(rom(i,k,&
&j)+rom(i,k-1,j))+0.25*g_w(i,k,j)*(rom(i,k,j)+rom(i,k-1,j))
      vflux(i,k) = 0.25*(rom(i,k,j)+rom(i,k-1,j))*(w(i,k,j)+w(i,k-1,j))
      k = ktf+1
      g_vflux(i,k) = 0.25*g_rom(i,k-1,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_rom(i,k,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_w(i,k-1,j)*(rom(i,k,&
&j)+rom(i,k-1,j))+0.25*g_w(i,k,j)*(rom(i,k,j)+rom(i,k-1,j))
      vflux(i,k) = 0.25*(rom(i,k,j)+rom(i,k-1,j))*(w(i,k,j)+w(i,k-1,j))
    end do
    do k = kts+1, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzu(k)+g_vflux(i,k)*rdzu(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzu(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
    k = ktf+1
    do i = i_start, i_end
      g_tendency(i,k,j) = g_tendency(i,k,j)+2*g_vflux(i,k)*rdzu(k-1)
      tendency(i,k,j) = tendency(i,k,j)+2.*rdzu(k-1)*vflux(i,k)
    end do
  end do
else if (vert_order .eq. 3) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+2, ktf
      do i = i_start, i_end
        vel = 0.5*(rom(i,k,j)+rom(i,k-1,j))
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
if(vel.ne.0.) then
        vflux(i,k) = vel*(7./12.*(w(i,k,j)+w(i,k-1,j))-1./12.*(w(i,k+1,j)+w(i,k-2,j))+sign(1.,-vel)*(1./12.)*(w(i,k+1,j)-w(i,k-2,j)&
&-3.*(w(i,k,j)-w(i,k-1,j))))
        g_vflux(i,k) = 0.5*(g_rom(i,k-1,j)+g_rom(i,k,j))*vflux(i,k)/vel&
&+vel*(g_w(i,k-2,j)*((-0.083333333)+(-0.083333333)*sign(1.,-vel))+g_w(i,k-1,j)*&
&(0.58333333+0.25*sign(1.,-vel))+g_w(i,k+1,j)*((-0.083333333)+0.083333333*sign(1.,-vel))+g_w(i,k,j)*&
&(0.58333333+(-0.25)*sign(1.,-vel)))
else
        vflux(i,k)=0.
        g_vflux(i,k) =0.5*(g_rom(i,k-1,j)+g_rom(i,k,j))*(7./12.*(w(i,k,j)+w(i,k-1,j))-1./12.*(w(i,k+1,j)&
&+w(i,k-2,j))+sign(1.,-vel)*(1./12.)*(w(i,k+1,j)-w(i,k-2,j)-3.*(w(i,k,j)-w(i,k-1,j))))
endif
      end do
    end do
    do i = i_start, i_end
      k = kts+1
      g_vflux(i,k) = 0.25*g_rom(i,k-1,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_rom(i,k,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_w(i,k-1,j)*(rom(i,k,&
&j)+rom(i,k-1,j))+0.25*g_w(i,k,j)*(rom(i,k,j)+rom(i,k-1,j))
      vflux(i,k) = 0.25*(rom(i,k,j)+rom(i,k-1,j))*(w(i,k,j)+w(i,k-1,j))
      k = ktf+1
      g_vflux(i,k) = 0.25*g_rom(i,k-1,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_rom(i,k,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_w(i,k-1,j)*(rom(i,k,&
&j)+rom(i,k-1,j))+0.25*g_w(i,k,j)*(rom(i,k,j)+rom(i,k-1,j))
      vflux(i,k) = 0.25*(rom(i,k,j)+rom(i,k-1,j))*(w(i,k,j)+w(i,k-1,j))
    end do
    do k = kts+1, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzu(k)+g_vflux(i,k)*rdzu(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzu(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
    k = ktf+1
    do i = i_start, i_end
      g_tendency(i,k,j) = g_tendency(i,k,j)+2*g_vflux(i,k)*rdzu(k-1)
      tendency(i,k,j) = tendency(i,k,j)+2.*rdzu(k-1)*vflux(i,k)
    end do
  end do
else if (vert_order .eq. 2) then vert_order_tesu
  do j = j_start, j_end
    do k = kts+1, ktf+1
      do i = i_start, i_end
        g_vflux(i,k) = 0.25*g_rom(i,k-1,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_rom(i,k,j)*(w(i,k,j)+w(i,k-1,j))+0.25*g_w(i,k-1,j)*(rom(i,&
&k,j)+rom(i,k-1,j))+0.25*g_w(i,k,j)*(rom(i,k,j)+rom(i,k-1,j))
        vflux(i,k) = 0.25*(rom(i,k,j)+rom(i,k-1,j))*(w(i,k,j)+w(i,k-1,j))
      end do
    end do
    do k = kts+1, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = g_tendency(i,k,j)-g_vflux(i,k+1)*rdzu(k)+g_vflux(i,k)*rdzu(k)
        tendency(i,k,j) = tendency(i,k,j)-rdzu(k)*(vflux(i,k+1)-vflux(i,k))
      end do
    end do
    k = ktf+1
    do i = i_start, i_end
      g_tendency(i,k,j) = g_tendency(i,k,j)+2*g_vflux(i,k)*rdzu(k-1)
      tendency(i,k,j) = tendency(i,k,j)+2.*rdzu(k-1)*vflux(i,k)
    end do
  end do
endif vert_order_tesu

   call trace_exit("g_advect_w")

end subroutine g_advect_w


end module     g_module_advect_em


