!                           DISCLAIMER
!
!   This file was generated by TAF version 1.7.18
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     a_module_big_step_utilities_em
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use module_domain
use module_model_constants
use module_state_description
use module_configure
use module_big_step_utilities_em

USE module_trace, only : trace_entry, trace_exit
#ifdef DM_PARALLEL
USE module_dm
#endif

!==============================================
! all entries are defined explicitly
!==============================================
implicit none


contains

subroutine a_calc_alt( a_alt, a_al, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_al(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_alt(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts

!==============================================
! declare local variables
!==============================================
integer i
integer itf
integer j
integer jtf
integer k
integer ktf

   call trace_entry("a_calc_alt")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
itf = min(ite,ide-1)
! recompute : itf
jtf = min(jte,jde-1)
! recompute : jtf
ktf = min(kte,kde-1)
! recompute : ktf

!do j = jts, jtf
!  do k = kts, ktf
!    do i = its, itf
!      a_al(i,k,j) = a_al(i,k,j)+a_alt(i,k,j)
!      a_alt(i,k,j) = 0.
!    end do
!  end do
!end do

a_al(its:itf,kts:ktf,jts:jtf) = a_al(its:itf,kts:ktf,jts:jtf)+a_alt(its:itf,kts:ktf,jts:jtf)
a_alt(its:itf,kts:ktf,jts:jtf)  = 0.

call trace_exit("a_calc_alt")

end subroutine a_calc_alt


subroutine a_calc_cq( moist, a_moist, a_cqu, a_cqv, a_cqw, n_moist, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, &
&jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_cqu(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqw(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: n_moist
real, intent(inout) :: a_moist(ims:ime,kms:kme,jms:jme,n_moist)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: moist(ims:ime,kms:kme,jms:jme,n_moist)

!==============================================
! declare local variables
!==============================================
real a_qtot
integer i
integer ispe
integer itf
integer j
integer jtf
integer k
integer ktf
real qtot

   call trace_entry("a_calc_cq")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_qtot = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
ktf = min(kte,kde-1)
! recompute : ktf
if (n_moist .ge. param_first_scalar) then
  itf = min(ite,ide-1)
! recompute : itf
  jtf = min(jte,jde-1)
! recompute : jtf
  do j = jts, jtf
    a_qtot = 0.
    do k = kts+1, ktf
      a_qtot = 0.
      do i = its, itf
        a_qtot = 0.
        a_qtot = a_qtot+0.5*a_cqw(i,k,j)
        a_cqw(i,k,j) = 0.
        do ispe = param_first_scalar, n_moist
          a_moist(i,k-1,j,ispe) = a_moist(i,k-1,j,ispe)+a_qtot
          a_moist(i,k,j,ispe) = a_moist(i,k,j,ispe)+a_qtot
        end do
        a_qtot = 0.
      end do
    end do
  end do
! recdepend vars : ide,ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:860
! recompute vars : itf
  itf = min(ite,ide-1)
! recompute vars : itf
! recdepend vars : itf,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:861
! recompute vars : jtf
  jtf = jte
! recompute vars : jtf
  do j = jts, jtf
    a_qtot = 0.
    do k = kts, ktf
      a_qtot = 0.
      do i = its, itf
        a_qtot = 0.
        qtot = 0.
! recompute : qtot
        do ispe = param_first_scalar, n_moist
          qtot = qtot+moist(i,k,j,ispe)+moist(i,k,j-1,ispe)
        end do
! recompute : qtot
        a_qtot = a_qtot-a_cqv(i,k,j)*(0.5/((1.+0.5*qtot)*(1.+0.5*qtot)))
        a_cqv(i,k,j) = 0.
        do ispe = param_first_scalar, n_moist
          a_moist(i,k,j-1,ispe) = a_moist(i,k,j-1,ispe)+a_qtot
          a_moist(i,k,j,ispe) = a_moist(i,k,j,ispe)+a_qtot
        end do
        a_qtot = 0.
      end do
    end do
  end do
! recdepend vars : ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:839
! recompute vars : itf
  itf = ite
! recompute vars : itf
! recdepend vars : itf,jde,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:840
! recompute vars : jtf
  jtf = min(jte,jde-1)
! recompute vars : jtf
  do j = jts, jtf
    a_qtot = 0.
    do k = kts, ktf
      a_qtot = 0.
      do i = its, itf
        a_qtot = 0.
        qtot = 0.
! recompute : qtot
        do ispe = param_first_scalar, n_moist
          qtot = qtot+moist(i,k,j,ispe)+moist(i-1,k,j,ispe)
        end do
! recompute : qtot
        a_qtot = a_qtot-a_cqu(i,k,j)*(0.5/((1.+0.5*qtot)*(1.+0.5*qtot)))
        a_cqu(i,k,j) = 0.
        do ispe = param_first_scalar, n_moist
          a_moist(i-1,k,j,ispe) = a_moist(i-1,k,j,ispe)+a_qtot
          a_moist(i,k,j,ispe) = a_moist(i,k,j,ispe)+a_qtot
        end do
        a_qtot = 0.
      end do
    end do
  end do
else
  itf = min(ite,ide-1)
! recompute : itf
  jtf = min(jte,jde-1)
! recompute : jtf
  do j = jts, jtf
    do k = kts+1, ktf
      do i = its, itf
        a_cqw(i,k,j) = 0.
      end do
    end do
  end do
! recdepend vars : ide,ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:905
! recompute vars : itf
  itf = min(ite,ide-1)
! recompute vars : itf
! recdepend vars : itf,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:906
! recompute vars : jtf
  jtf = jte
! recompute vars : jtf
  do j = jts, jtf
    do k = kts, ktf
      do i = its, itf
        a_cqv(i,k,j) = 0.
      end do
    end do
  end do
! recdepend vars : ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:839
! recompute vars : itf
  itf = ite
! recompute vars : itf
! recdepend vars : itf,jde,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:840
! recompute vars : jtf
  jtf = min(jte,jde-1)
! recompute vars : jtf
  do j = jts, jtf
    do k = kts, ktf
      do i = its, itf
        a_cqu(i,k,j) = 0.
      end do
    end do
  end do
endif

   call trace_exit("a_calc_cq")

end subroutine a_calc_cq


subroutine a_calc_mu_uv( config_flags, a_mu, a_muu, a_muv, ids, ide, jds, jde, ims, ime, jms, jme, its, ite, jts, jte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: a_mu(ims:ime,jms:jme)
real, intent(inout) :: a_muu(ims:ime,jms:jme)
real, intent(inout) :: a_muv(ims:ime,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts

!==============================================
! declare local variables
!==============================================
integer i
integer im
integer itf
integer j
integer jm
integer jtf
#ifdef DM_PARALLEL
integer ips, ipe, jps, jpe, kps, kpe
#endif

call trace_entry("a_calc_mu_uv")

#ifdef DM_PARALLEL
ips = its
ipe = ite
jps = jts
jpe = jte
#endif
!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
itf = min(ite,ide-1)
! recompute : itf
jtf = jte
! recompute : jtf
#ifdef DM_PARALLEL
! xinzhang's tuning
!#include      "HALO_ADJ_RKPREP2.inc"
#endif

if (jts .ne. jds .and. jte .ne. jde) then
  do j = jts, jtf+1
    do i = its, itf
      a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_muv(i,j)
      a_mu(i,j)   = a_mu(i,j)+0.5*a_muv(i,j)
      a_muv(i,j)  = 0.
    end do
  end do

else if (jts .eq. jds .and. jte .ne. jde) then
  j = jts
! recompute : j
  jm = jts
! recompute : jm
  if (config_flags%periodic_y) then
    jm = jts-1
  endif
! recompute : jm
  do i = its, itf
    a_mu(i,j) = a_mu(i,j)+0.5*a_muv(i,j)
    a_mu(i,jm) = a_mu(i,jm)+0.5*a_muv(i,j)
    a_muv(i,j) = 0.
  end do

  do j = jts+1, jtf+1
    do i = its, itf
      a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_muv(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muv(i,j)
      a_muv(i,j) = 0.
    end do
  end do

else if (jts .ne. jds .and. jte .eq. jde) then
  j = jte
! recompute : j
  jm = jte-1
! recompute : jm
  if (config_flags%periodic_y) then
    jm = jte
  endif
! recompute : jm

  do i = its, itf
    a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_muv(i,j)
    a_mu(i,jm) = a_mu(i,jm)+0.5*a_muv(i,j)
!   a_muv(i,j) = 0.
!   a_mu(i,j-1) = a_mu(i,j-1)+a_muv(i,j)
    a_muv(i,j) = 0.
  end do

  do j = jts, jtf-1
    do i = its, itf
      a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_muv(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muv(i,j)
      a_muv(i,j) = 0.
    end do
  end do

else if (jts .eq. jds .and. jte .eq. jde) then
  j = jte
! recompute : j
  jm = jte-1
! recompute : jm

  if (config_flags%periodic_y) then
    jm = jte
  endif

! recompute : jm
  do i = its, itf
    a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_muv(i,j)
    a_mu(i,jm) = a_mu(i,jm)+0.5*a_muv(i,j)
    a_muv(i,j) = 0.
  end do

! recdepend vars : jts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:150
! recompute vars : j
  j = jts
! recompute vars : j
! recdepend vars : j,jts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:151
! recompute vars : jm
  jm = jts
! recompute vars : jm
! recdepend vars : config_flags,j,jm,jts
! recompute pos : IF_STMT module_big_step_utilities_em.f90:152
! recompute vars : jm

  if (config_flags%periodic_y) then
    jm = jts-1
  endif

! recompute vars : jm
  do i = its, itf
    a_mu(i,j)  = a_mu(i,j) +0.5*a_muv(i,j)
    a_mu(i,jm) = a_mu(i,jm)+0.5*a_muv(i,j)
    a_muv(i,j) = 0.
  end do

  do j = jts+1, jtf-1
    do i = its, itf
      a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_muv(i,j)
      a_mu(i,j)   = a_mu(i,j)+0.5*a_muv(i,j)
      a_muv(i,j)  = 0.
    end do
  end do
endif

! recdepend vars : ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:46
! recompute vars : itf
itf = ite
! recompute vars : itf
! recdepend vars : itf,jde,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:47
! recompute vars : jtf
jtf = min(jte,jde-1)
! recompute vars : jtf
if (its .ne. ids .and. ite .ne. ide) then
  do j = jts, jtf
    do i = its, itf+1
      a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_muu(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muu(i,j)
      a_muu(i,j) = 0.
    end do
  end do
else if (its .eq. ids .and. ite .ne. ide) then
  i = its
! recompute : i
  im = its
! recompute : im
  if (config_flags%periodic_x) then
    im = its-1
  endif
! recompute : im
  do j = jts, jtf
    a_mu(i,j)  = a_mu(i,j)+0.5*a_muu(i,j)
    a_mu(im,j) = a_mu(im,j)+0.5*a_muu(i,j)
    a_muu(i,j) = 0.
  end do

  do j = jts, jtf
    do i = its+1, itf+1
      a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_muu(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muu(i,j)
      a_muu(i,j) = 0.
    end do
  end do
else if (its .ne. ids .and. ite .eq. ide) then
  i = ite
! recompute : i
  im = ite-1
! recompute : im
  if (config_flags%periodic_x) then
    im = ite
  endif
! recompute : im
  do j = jts, jtf
    a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_muu(i,j)
    a_mu(im,j) = a_mu(im,j)+0.5*a_muu(i,j)
    a_muu(i,j) = 0.
  end do

  do j = jts, jtf
    do i = its, itf-1
      a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_muu(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muu(i,j)
      a_muu(i,j) = 0.
    end do
  end do
else if (its .eq. ids .and. ite .eq. ide) then
  i = ite
! recompute : i
  im = ite-1
! recompute : im
  if (config_flags%periodic_x) then
    im = ite
  endif

! recompute : im
  do j = jts, jtf
    a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_muu(i,j)
    a_mu(im,j) = a_mu(im,j)+0.5*a_muu(i,j)
    a_muu(i,j) = 0.
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:89
! recompute vars : i
  i = its
! recompute vars : i
! recdepend vars : i,its
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:90
! recompute vars : im
  im = its
! recompute vars : im
! recdepend vars : config_flags,i,im,its
! recompute pos : IF_STMT module_big_step_utilities_em.f90:91
! recompute vars : im

  if (config_flags%periodic_x) then
    im = its-1
  endif

! recompute vars : im
  do j = jts, jtf
    a_mu(i,j) = a_mu(i,j)+0.5*a_muu(i,j)
    a_mu(im,j) = a_mu(im,j)+0.5*a_muu(i,j)
    a_muu(i,j) = 0.
  end do

  do j = jts, jtf
    do i = its+1, itf-1
      a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_muu(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muu(i,j)
      a_muu(i,j) = 0.
    end do
  end do
endif

call trace_exit("a_calc_mu_uv")

end subroutine a_calc_mu_uv


subroutine a_calc_mu_uv_1( config_flags, a_mu, a_muu, a_muv, ids, ide, jds, jde, ims, ime, jms, jme, its, ite, jts, jte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: a_mu(ims:ime,jms:jme)
real, intent(inout) :: a_muu(ims:ime,jms:jme)
real, intent(inout) :: a_muv(ims:ime,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts

!==============================================
! declare local variables
!==============================================
integer i
integer im
integer itf
integer j
integer jm
integer jtf
#ifdef DM_PARALLEL
integer ips, ipe, jps, jpe, kps, kpe
#endif

   call trace_entry("a_calc_mu_uv_1")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
itf = min(ite,ide-1)
! recompute : itf
jtf = jte
! recompute : jtf
#ifdef DM_PARALLEL
! xinzhang's tuning 
!#include      "HALO_ADJ_RKPREP2.inc"
#endif
if (jts .ne. jds .and. jte .ne. jde) then
  do j = jts, jtf
    do i = its, itf
      a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_muv(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muv(i,j)
      a_muv(i,j) = 0.
    end do
  end do
else if (jts .eq. jds .and. jte .ne. jde) then
  j = jts
! recompute : j
  jm = jts
! recompute : jm
  if (config_flags%periodic_y) then
    jm = jts-1
  endif
! recompute : jm
  do i = its, itf
    a_mu(i,j) = a_mu(i,j)+0.5*a_muv(i,j)
    a_mu(i,jm) = a_mu(i,jm)+0.5*a_muv(i,j)
    a_muv(i,j) = 0.
  end do
  do j = jts+1, jtf
    do i = its, itf
      a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_muv(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muv(i,j)
      a_muv(i,j) = 0.
    end do
  end do
else if (jts .ne. jds .and. jte .eq. jde) then
  j = jte
! recompute : j
  jm = jte-1
! recompute : jm
  if (config_flags%periodic_y) then
    jm = jte
  endif
! recompute : jm
  do i = its, itf
    a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_muv(i,j)
    a_mu(i,jm) = a_mu(i,jm)+0.5*a_muv(i,j)
    a_muv(i,j) = 0.
  end do
  do j = jts, jtf-1
    do i = its, itf
      a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_muv(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muv(i,j)
      a_muv(i,j) = 0.
    end do
  end do
else if (jts .eq. jds .and. jte .eq. jde) then
  j = jte
! recompute : j
  jm = jte-1
! recompute : jm
  if (config_flags%periodic_y) then
    jm = jte
  endif
! recompute : jm
  do i = its, itf
    a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_muv(i,j)
    a_mu(i,jm) = a_mu(i,jm)+0.5*a_muv(i,j)
    a_muv(i,j) = 0.
  end do
! recdepend vars : jts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:295
! recompute vars : j
  j = jts
! recompute vars : j
! recdepend vars : j,jts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:296
! recompute vars : jm
  jm = jts
! recompute vars : jm
! recdepend vars : config_flags,j,jm,jts
! recompute pos : IF_STMT module_big_step_utilities_em.f90:297
! recompute vars : jm
  if (config_flags%periodic_y) then
    jm = jts-1
  endif
! recompute vars : jm
  do i = its, itf
    a_mu(i,j) = a_mu(i,j)+0.5*a_muv(i,j)
    a_mu(i,jm) = a_mu(i,jm)+0.5*a_muv(i,j)
    a_muv(i,j) = 0.
  end do
  do j = jts+1, jtf-1
    do i = its, itf
      a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_muv(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muv(i,j)
      a_muv(i,j) = 0.
    end do
  end do
endif
! recdepend vars : ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:203
! recompute vars : itf
itf = ite
! recompute vars : itf
! recdepend vars : itf,jde,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:204
! recompute vars : jtf
jtf = min(jte,jde-1)
! recompute vars : jtf
if (its .ne. ids .and. ite .ne. ide) then
  do j = jts, jtf
    do i = its, itf
      a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_muu(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muu(i,j)
      a_muu(i,j) = 0.
    end do
  end do
else if (its .eq. ids .and. ite .ne. ide) then
  i = its
! recompute : i
  im = its
! recompute : im
  if (config_flags%periodic_x) then
    im = its-1
  endif
! recompute : im
  do j = jts, jtf
    a_mu(i,j) = a_mu(i,j)+0.5*a_muu(i,j)
    a_mu(im,j) = a_mu(im,j)+0.5*a_muu(i,j)
    a_muu(i,j) = 0.
  end do
  do j = jts, jtf
    do i = its+1, itf
      a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_muu(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muu(i,j)
      a_muu(i,j) = 0.
    end do
  end do
else if (its .ne. ids .and. ite .eq. ide) then
  i = ite
! recompute : i
  im = ite-1
! recompute : im
  if (config_flags%periodic_x) then
    im = ite
  endif
! recompute : im
  do j = jts, jtf
    a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_muu(i,j)
    a_mu(im,j) = a_mu(im,j)+0.5*a_muu(i,j)
    a_muu(i,j) = 0.
  end do
  do j = jts, jtf
    do i = its, itf-1
      a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_muu(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muu(i,j)
      a_muu(i,j) = 0.
    end do
  end do
else if (its .eq. ids .and. ite .eq. ide) then
  i = ite
! recompute : i
  im = ite-1
! recompute : im
  if (config_flags%periodic_x) then
    im = ite
  endif
! recompute : im
  do j = jts, jtf
    a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_muu(i,j)
    a_mu(im,j) = a_mu(im,j)+0.5*a_muu(i,j)
    a_muu(i,j) = 0.
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:242
! recompute vars : i
  i = its
! recompute vars : i
! recdepend vars : i,its
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:243
! recompute vars : im
  im = its
! recompute vars : im
! recdepend vars : config_flags,i,im,its
! recompute pos : IF_STMT module_big_step_utilities_em.f90:244
! recompute vars : im
  if (config_flags%periodic_x) then
    im = its-1
  endif
! recompute vars : im
  do j = jts, jtf
    a_mu(i,j) = a_mu(i,j)+0.5*a_muu(i,j)
    a_mu(im,j) = a_mu(im,j)+0.5*a_muu(i,j)
    a_muu(i,j) = 0.
  end do
  do j = jts, jtf
    do i = its+1, itf-1
      a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_muu(i,j)
      a_mu(i,j) = a_mu(i,j)+0.5*a_muu(i,j)
      a_muu(i,j) = 0.
    end do
  end do
endif

   call trace_exit("a_calc_mu_uv_1")

end subroutine a_calc_mu_uv_1


subroutine a_calc_p_rho_phi( moist, a_moist, n_moist, al, a_al, alb, mu, a_mu, muts, a_muts, ph, a_ph, p, a_p, pb, t, a_t, p0, t0, &
&dnw, rdnw, rdn, non_hydrostatic, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_al(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: n_moist
real, intent(inout) :: a_moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(inout) :: a_mu(ims:ime,jms:jme)
real, intent(inout) :: a_muts(ims:ime,jms:jme)
real, intent(inout) :: a_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t(ims:ime,kms:kme,jms:jme)
real, intent(out) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dnw(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: muts(ims:ime,jms:jme)
logical, intent(in) :: non_hydrostatic
real, intent(out) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: p0
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t0

!==============================================
! declare local variables
!==============================================
real a_qf1
real a_qf2
real a_qtot
real a_qvf
integer i
integer ispe
integer itf
integer j
integer jtf
integer k
integer k1
integer k2
integer ka1
integer ka2
integer ktf
real qf1
real qf2
real qtot
real qvf
real walls(5)

   call trace_entry("a_calc_p_rho_phi")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
itf = min(ite,ide-1)
jtf = min(jte,jde-1)
ktf = min(kte,kde-1)
if (non_hydrostatic) then
  if (n_moist .ge. param_first_scalar) then
    do j = jts, jtf
      do k = kts, ktf
        walls(1)=rdnw(k)
        do i = its, itf
          qvf = 1.+rvovrd*moist(i,k,j,p_qv)
          walls(2)=alb(i,k,j)*mu(i,j)+walls(1)*(ph(i,k+1,j)-ph(i,k,j))
          walls(3)=p0*(al(i,k,j)+alb(i,k,j))
          walls(4)=(r_d*(t0+t(i,k,j))*qvf/walls(3))**(cpovcv-1)
!         al(i,k,j) = -walls(2)/muts(i,j)
          a_al(i,k,j) = a_al(i,k,j)-a_p(i,k,j)*r_d*(t0+t(i,k,j))*qvf*p0/(walls(3)*walls(3))*cpovcv*walls(4)*p0
          walls(5)=a_al(i,k,j)/muts(i,j)
          a_muts(i,j) = a_muts(i,j)+walls(5)/muts(i,j)*walls(2)
          a_t(i,k,j) = a_t(i,k,j)+a_p(i,k,j)*r_d*qvf/walls(3)*cpovcv*walls(4)*p0
          a_mu(i,j) = a_mu(i,j)-walls(5)*alb(i,k,j)
          a_ph(i,k+1,j) = a_ph(i,k+1,j)-walls(5)*walls(1)
          a_ph(i,k,j) = a_ph(i,k,j)+walls(5)*walls(1)
          a_moist(i,k,j,p_qv) = a_moist(i,k,j,p_qv)+(a_p(i,k,j)*r_d*(t0+t(i,k,j))/walls(3)*cpovcv*walls(4)*p0)*rvovrd
        end do
      end do
    end do
    a_p(its:itf,kts:ktf,jts:jtf)  = 0.
    a_al(its:itf,kts:ktf,jts:jtf) = 0.
  else
    do j = jts, jtf
      do k = kts, ktf
        walls(1)=rdnw(k)
        do i = its, itf
          walls(2)=alb(i,k,j)*mu(i,j)+walls(1)*(ph(i,k+1,j)-ph(i,k,j))
          walls(3)=p0*(al(i,k,j)+alb(i,k,j))
          walls(4)=a_p(i,k,j)*p0*r_d*cpovcv/walls(3)*(r_d*(t0+t(i,k,j))/walls(3))**(cpovcv-1)
!         al(i,k,j) = -walls(2)/muts(i,j)
! recompute : al
          a_al(i,k,j) = a_al(i,k,j)-(t0+t(i,k,j))*p0/walls(3)*walls(4)
          walls(5)=a_al(i,k,j)/muts(i,j)
          a_muts(i,j) = a_muts(i,j)+walls(5)/muts(i,j)*walls(2)
          a_t(i,k,j) = a_t(i,k,j)+walls(4)
          a_mu(i,j) = a_mu(i,j)-walls(5)*alb(i,k,j)
          a_ph(i,k+1,j) = a_ph(i,k+1,j)-walls(5)*walls(1)
          a_ph(i,k,j) = a_ph(i,k,j)+walls(5)*walls(1)
        end do
      end do
    end do
    a_p(its:itf,kts:ktf,jts:jtf)  = 0.
    a_al(its:itf,kts:ktf,jts:jtf) = 0.
  endif
else
  if (n_moist .ge. param_first_scalar) then
    do j = jts, jtf
      k = ktf
! recompute : k
      walls(1)=rdnw(k)
      do i = its, itf
        qtot = 0.
        do ispe = param_first_scalar, n_moist
          qtot = qtot+moist(i,k,j,ispe)
        end do
        p(i,k,j) = -0.5*(mu(i,j)*(1.+qtot)+qtot*muts(i,j))/walls(1)
!       al(i,k,j) = r_d/p1000mb*(t(i,k,j)+t0)*(1.+rvovrd*moist(i,k,j,p_qv))*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm-alb(i,k,j)
      end do
! recompute : p
      do k = ktf-1, kts, -1
        walls(1)=rdn(k+1)
        do i = its, itf
          qtot = 0.
          do ispe = param_first_scalar, n_moist
            qtot = qtot+0.5*(moist(i,k,j,ispe)+moist(i,k+1,j,ispe))
          end do
          p(i,k,j) = p(i,k+1,j)-(mu(i,j)*(1.+qtot)+qtot*muts(i,j))/walls(1)
          al(i,k,j) = r_d/p1000mb*(t(i,k,j)+t0)*(1.+rvovrd*moist(i,k,j,p_qv))*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm-alb(i,k,j)
        end do
      end do
! recompute : al
      do k = ktf+1, 2, -1
        walls(1)=dnw(k-1) 
        do i = its, itf
          a_al(i,k-1,j) = a_al(i,k-1,j)-a_ph(i,k,j)*walls(1)*muts(i,j)
          a_mu(i,j) = a_mu(i,j)-a_ph(i,k,j)*walls(1)*alb(i,k-1,j)
          a_muts(i,j) = a_muts(i,j)-a_ph(i,k,j)*walls(1)*al(i,k-1,j)
          a_ph(i,k-1,j) = a_ph(i,k-1,j)+a_ph(i,k,j)
          a_ph(i,k,j) = 0.
        end do
      end do
      do k = kts, ktf-1
!  recdepend vars : alb,cvpm,itf,its,j,k,moist,mu,muts,n_moist,p1000mb,p
! _qv,param_first_scalar,pb,r_d,rdnw,rvovrd,t,t0
! recompute pos : DOLOOP_STMT module_big_step_utilities_em.f90:1077
        walls(1)=rdnw(k)
        walls(2)=rdn(k+1)
        do i = its, itf
          qtot = 0.
          do ispe = param_first_scalar, n_moist
            qtot = qtot+moist(i,k,j,ispe)
          end do
          p(i,k,j) = -0.5*(mu(i,j)*(1.+qtot)+qtot*muts(i,j))/walls(1)
!         al(i,k,j) = r_d/p1000mb*(t(i,k,j)+t0)*(1.+rvovrd*moist(i,k,j,p_qv))*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm-alb(i,k,j)
        end do
        do k1 = ktf-1, k-(-1), -1
          do i = its, itf
            qtot = 0.
            do ispe = param_first_scalar, n_moist
              qtot = qtot+0.5*(moist(i,k1,j,ispe)+moist(i,k1+1,j,ispe))
            end do
            p(i,k1,j) = p(i,k1+1,j)-(mu(i,j)+qtot*muts(i,j))/rdn(k1+1)
          end do
        end do
        do i = its, itf
          qtot = 0.
          do ispe = param_first_scalar, n_moist
            qtot = qtot+0.5*(moist(i,k,j,ispe)+moist(i,k+1,j,ispe))
          end do
          walls(2)=((p(i,k,j)+pb(i,k,j))/p1000mb)
          walls(3)=walls(2)**(cvpm-1)
          p(i,k,j) = p(i,k+1,j)-(mu(i,j)+qtot*muts(i,j))/walls(2)
          qvf = (1.+rvovrd*moist(i,k,j,p_qv))/p1000mb
          a_t(i,k,j) = a_t(i,k,j)+a_al(i,k,j)*r_d*qvf*walls(3)*walls(2)
          walls(4)=a_al(i,k,j)*r_d/p1000mb*(t(i,k,j)+t0)*walls(3)
          a_p(i,k,j) = a_p(i,k,j)+walls(4)*qvf*cvpm
          a_moist(i,k,j,p_qv) = a_moist(i,k,j,p_qv)+walls(4)*walls(2)*rvovrd
          a_mu(i,j) = a_mu(i,j)-a_p(i,k,j)*walls(2)*(1.+qtot)
          a_muts(i,j) = a_muts(i,j)-a_p(i,k,j)*qtot/walls(2)
          a_p(i,k+1,j) = a_p(i,k+1,j)+a_p(i,k,j)
          a_qf1 = -a_p(i,k,j)*muts(i,j)/walls(2)
          a_qtot = 0.5*(a_qf1-(a_p(i,k,j)*((mu(i,j)*(1.+qtot)+qtot*muts(i,j))/walls(2))+a_qf1*qtot)/(1.+qtot))
!         do ispe = param_first_scalar, n_moist
!           a_moist(i,k+1,j,ispe) = a_moist(i,k+1,j,ispe)+a_qtot
!           a_moist(i,k,j,ispe) = a_moist(i,k,j,ispe)+a_qtot
!         end do
          a_moist(i,k+1,j,param_first_scalar:n_moist) = a_moist(i,k+1,j,param_first_scalar:n_moist)+a_qtot
          a_moist(i,k,j,param_first_scalar:n_moist) = a_moist(i,k,j,param_first_scalar:n_moist)+a_qtot
        end do
        a_al(its:itf,k,j) = 0.
        a_p(its:itf,k,j) = 0.
      end do
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1076
! recompute vars : k
      k = ktf
      walls(1)=rdnw(k)
      do i = its, itf
        qtot = 0.
        do ispe = param_first_scalar, n_moist
          qtot = qtot+moist(i,k,j,ispe)
        end do
        walls(2)=(p(i,k,j)+pb(i,k,j))/p1000mb
        walls(3)=walls(2)**(cvpm-1)
        p(i,k,j) = -0.5*(mu(i,j)*(1.+qtot)+qtot*muts(i,j))/walls(1)
        qvf = (1.+rvovrd*moist(i,k,j,p_qv))/p1000mb
        a_t(i,k,j) = a_t(i,k,j)+a_al(i,k,j)*r_d*qvf*walls(3)*walls(2)
        walls(4)=a_al(i,k,j)*r_d/p1000mb*(t(i,k,j)+t0)*walls(3)
        a_p(i,k,j) = a_p(i,k,j)+walls(4)*qvf*cvpm
        a_moist(i,k,j,p_qv) = a_moist(i,k,j,p_qv)+walls(4)*walls(2)*rvovrd
        a_mu(i,j) = a_mu(i,j)-a_p(i,k,j)*(0.5/walls(1)*(1.+qtot))
        a_muts(i,j) = a_muts(i,j)-a_p(i,k,j)*0.5*qtot/walls(1)
        a_qf1 = -a_p(i,k,j)*0.5*muts(i,j)/walls(1)
        a_qtot = a_qf1-(a_p(i,k,j)*0.5*(mu(i,j)*(1.+qtot)+qtot*muts(i,j))/walls(1)+a_qf1*qtot)/(1.+qtot)
        a_moist(i,k,j,param_first_scalar:n_moist) = a_moist(i,k,j,param_first_scalar:n_moist)+a_qtot
      end do
      a_al(its:itf,k,j) = 0.
      a_p(its:itf,k,j) = 0.
    end do
  else
    do j = jts, jtf
      k = ktf
      walls(1)=rdnw(k)
! recompute : k
      do i = its, itf
        p(i,k,j) = -0.5*mu(i,j)/walls(1)
!       al(i,k,j) = r_d/p1000mb*(t(i,k,j)+t0)*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm-alb(i,k,j)
      end do
! recompute : p
      do k = ktf-1, kts, -1
        walls(1)=rdn(k+1)
        do i = its, itf
          p(i,k,j) = p(i,k+1,j)-mu(i,j)/walls(1)
          al(i,k,j) = r_d/p1000mb*(t(i,k,j)+t0)*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm-alb(i,k,j)
        end do
      end do
! recompute : al
      do k = ktf+1, 2, -1
        walls(1)=dnw(k-1)
        do i = its, itf
          a_al(i,k-1,j) = a_al(i,k-1,j)-a_ph(i,k,j)*walls(1)*muts(i,j)
          a_mu(i,j) = a_mu(i,j)-a_ph(i,k,j)*walls(1)*alb(i,k-1,j)
          a_muts(i,j) = a_muts(i,j)-a_ph(i,k,j)*walls(1)*al(i,k-1,j)
          a_ph(i,k-1,j) = a_ph(i,k-1,j)+a_ph(i,k,j)
          a_ph(i,k,j) = 0.
        end do
      end do
      do k = kts, ktf-1
!  recdepend vars : alb,cvpm,itf,its,j,k,mu,muts,p1000mb,pb,r_d,rdnw,t,t
! 0
! recompute pos : DOLOOP_STMT module_big_step_utilities_em.f90:1131
! recompute vars : p
        walls(1)=rdnw(k)
        walls(4)=rdn(k+1)
        do i = its, itf
          p(i,k,j) = -0.5*mu(i,j)/walls(1)
!         al(i,k,j) = r_d/p1000mb*(t(i,k,j)+t0)*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm-alb(i,k,j)
        end do
! recompute vars : p
        do k2 = ktf-1, k-(-1), -1
          do i = its, itf
            p(i,k2,j) = p(i,k2+1,j)-mu(i,j)/rdn(k2+1)
          end do
        end do
        do i = its, itf
          walls(2)=((p(i,k,j)+pb(i,k,j))/p1000mb)
          walls(3)=walls(2)**(cvpm-1)
          p(i,k,j) = p(i,k+1,j)-mu(i,j)/walls(4)
          a_p(i,k,j) = a_p(i,k,j)+a_al(i,k,j)*r_d/p1000mb*(t(i,k,j)+t0)/p1000mb*cvpm*walls(3)
!         a_qvf = a_al(i,k,j)*r_d/p1000mb*(t(i,k,j)+t0)*walls(3)*walls(2)
          a_t(i,k,j) = a_t(i,k,j)+a_al(i,k,j)*r_d/p1000mb*walls(3)*walls(2)
          a_mu(i,j) = a_mu(i,j)-a_p(i,k,j)/walls(4)
          a_p(i,k+1,j) = a_p(i,k+1,j)+a_p(i,k,j)
!         a_qf1 = -a_p(i,k,j)*muts(i,j)/walls(4)
!         a_qf2 = a_p(i,k,j)*mu(i,j)/walls(4)
        end do
        a_p(its:itf,k,j) = 0.
        a_al(its:itf,k,j) = 0.
      end do
! recdepend vars : ktf
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1130
! recompute vars : k
      k = ktf
! recompute vars : k
      walls(1)=rdnw(k)
      do i = its, itf
        walls(2)=((p(i,k,j)+pb(i,k,j))/p1000mb)
        walls(3)=walls(2)**(cvpm-1)
        p(i,k,j) = -0.5*mu(i,j)/walls(1)
        a_p(i,k,j) = a_p(i,k,j)+a_al(i,k,j)*r_d/p1000mb*(t(i,k,j)+t0)/p1000mb*cvpm*walls(3)
!       a_qvf = a_al(i,k,j)*r_d/p1000mb*(t(i,k,j)+t0)*walls(3)*walls(2)
        a_t(i,k,j) = a_t(i,k,j)+a_al(i,k,j)*r_d/p1000mb*walls(3)*walls(2)
        a_mu(i,j) = a_mu(i,j)-a_p(i,k,j)*0.5/walls(1)
!       a_qf1 = -a_p(i,k,j)*0.5*muts(i,j)/walls(1)
!       a_qf2 = a_p(i,k,j)*0.5*mu(i,j)/walls(1)
      end do
      a_p(its:itf,k,j) = 0.
      a_al(its:itf,k,j) = 0.
    end do
  endif
endif

   call trace_exit("a_calc_p_rho_phi")

end subroutine a_calc_p_rho_phi


subroutine a_calc_php( a_php, a_ph, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_ph(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_php(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts

!==============================================
! declare local variables
!==============================================
integer i
integer itf
integer j
integer jtf
integer k
integer ktf

   call trace_entry("a_calc_php")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
itf = min(ite,ide-1)
! recompute : itf
jtf = min(jte,jde-1)
! recompute : jtf
ktf = min(kte,kde-1)
! recompute : ktf

!do j = jts, jtf
!  do k = kts, ktf
!    do i = its, itf
!      a_ph(i,k+1,j) = a_ph(i,k+1,j)+0.5*a_php(i,k,j)
!      a_ph(i,k,j) = a_ph(i,k,j)+0.5*a_php(i,k,j)
!      a_php(i,k,j) = 0.
!    end do
!  end do
!end do

a_ph(its:itf,kts+1:ktf+1,jts:jtf) = a_ph(its:itf,kts+1:ktf+1,jts:jtf)+0.5*a_php(its:itf,kts:ktf,jts:jtf)
a_ph(its:itf,kts:ktf,jts:jtf)     = a_ph(its:itf,kts:ktf,jts:jtf)+0.5*a_php(its:itf,kts:ktf,jts:jtf)
a_php(its:itf,kts:ktf,jts:jtf)    = 0.

call trace_exit("a_calc_php")

end subroutine a_calc_php


subroutine a_calc_ww_cp( u, a_u, v, a_v, mup, a_mup, mub, a_ww, rdx, rdy, msft, msfu, msfv, dnw, ids, ide, jds, jde, kds, kde, ims, ime, jms, jme,&
& kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: a_mup(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_u(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dnw(kms:kme)
integer, intent(in) :: ids
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jds
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kds
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mub(ims:ime,jms:jme)
real, intent(in) :: mup(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
!print*,'XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS'
!print*,'XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS'
!print*,'XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS'
real a_divv(its-1:ite+1,kts-1:kte+1) !REVISED BY WALLS
real a_dmdt(its-1:ite+1)  !REVISED BY WALLS
real a_muu(its-1:ite+2,jts-1:jte+2)  !REVISED BY WALLS
real a_muv(its-1:ite+2,jts-1:jte+2)  !REVISED BY WALLS
integer i
integer itl,itf
integer j
integer jtl,jtf
integer k
integer ktf
!print*,'XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS'
!print*,'XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS'
!print*,'XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS'
real muu(its-1:ite+2,jts-1:jte+2) !REVISED BY WALLS
real muv(its-1:ite+2,jts-1:jte+2) !REVISED BY WALLS
real gwalls(ims-1:ime+1),walls(2)  !REVISED BY WALLS
#ifdef DM_PARALLEL
integer ips, ipe, jps, jpe, kps, kpe
#endif

   call trace_entry("a_calc_ww_cp")

#ifdef DM_PARALLEL
ips = its
ipe = ite
jps = jts
jpe = jte
kps = kts
kpe = kte
#endif
!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_divv(:,:) = 0.
a_dmdt(:) = 0.
a_muu(:,:) = 0.
a_muv(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
jtf = min(jte,jde-1)
! recompute : jtf
ktf = min(kte,kde-1)
! recompute : ktf
itf = min(ite,ide-1)
! recompute : itf
#ifdef DM_PARALLEL
itl = max(its-1,ids)
jtl = max(jts-1,jds)
#else
itl = its
jtl = jts
#endif
do j = jtl, jtf
  do i = itl, min(ite+1,ide)
!print*,'XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS'
!print*,'XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS'
!print*,'XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS'
    muu(i,j) = 0.5*(mup(i,j)+mub(i,j)+mup(i-1,j)+mub(i-1,j))/msfu(i,j)
  end do
end do
! recompute : muu
do j = jtl, min(jte+1,jde)
  do i = itl, itf
    muv(i,j) = 0.5*(mup(i,j)+mub(i,j)+mup(i,j-1)+mub(i,j-1))/msfv(i,j)
  end do
end do
! recompute : muv
#ifdef DM_PARALLEL
! xinzhang's tuning
!#include      "HALO_ADJ_RKPREP.inc"
#endif
do j = jtl, jtf
  do k = ktf, 2, -1
    walls(1)=dnw(k-1)
    do i = itl, itf
      a_divv(i,k-1) = a_divv(i,k-1)-a_ww(i,k,j)
      a_dmdt(i) = a_dmdt(i)-a_ww(i,k,j)*walls(1)
      a_ww(i,k-1,j) = a_ww(i,k-1,j)+a_ww(i,k,j)
      a_ww(i,k,j) = 0.
    end do
  end do

  do k = ktf, kts, -1
    walls(1)=dnw(k)*rdx
    walls(2)=dnw(k)*rdy
    a_divv(itl:itf,k) = a_divv(itl:itf,k)+a_dmdt(itl:itf)
    do i = itl, itf
      gwalls(i)=a_divv(i,k)*msft(i,j)
    end do
    do i = itl, itf
      a_muu(i+1,j) = a_muu(i+1,j)+gwalls(i)*walls(1)*u(i+1,k,j)
      a_muu(i,j) = a_muu(i,j)-gwalls(i)*walls(1)*u(i,k,j)
      a_muv(i,j+1) = a_muv(i,j+1)+gwalls(i)*walls(2)*v(i,k,j+1)
      a_muv(i,j) = a_muv(i,j)-gwalls(i)*walls(2)*v(i,k,j)
      a_u(i+1,k,j) = a_u(i+1,k,j)+gwalls(i)*walls(1)*muu(i+1,j)
      a_u(i,k,j) = a_u(i,k,j)-gwalls(i)*walls(1)*muu(i,j)
      a_v(i,k,j+1) = a_v(i,k,j+1)+gwalls(i)*walls(2)*muv(i,j+1)
      a_v(i,k,j) = a_v(i,k,j)-gwalls(i)*walls(2)*muv(i,j)
    end do
  end do
  a_divv(itl:itf,kts:ktf) = 0.

  do i = itl, ite
    a_ww(i,kte,j) = 0.
    a_ww(i,1,j) = 0.
    a_dmdt(i) = 0.
  end do
end do
do j = jts, min(jte+1,jde)
  do i = its, itf
    walls(1)=a_muv(i,j)*(0.5/msfv(i,j))
    a_mup(i,j-1) = a_mup(i,j-1)+walls(1)
    a_mup(i,j) = a_mup(i,j)+walls(1)
    a_muv(i,j) = 0.
  end do
end do
do j = jts, jtf
  do i = its, min(ite+1,ide)
    walls(1)=a_muu(i,j)*(0.5/msfu(i,j))
    a_mup(i-1,j) = a_mup(i-1,j)+walls(1)
    a_mup(i,j) = a_mup(i,j)+walls(1)
    a_muu(i,j) = 0.
  end do
end do

   call trace_exit("a_calc_ww_cp")

end subroutine a_calc_ww_cp


subroutine a_calculate_full( a_rfield, a_rfieldp, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_rfield(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rfieldp(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts

!==============================================
! declare local variables
!==============================================
integer i
integer itf
integer j
integer jtf
integer k
integer ktf

   call trace_entry("a_calculate_full")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
itf = min(ite,ide-1)
! recompute : itf
jtf = min(jte,jde-1)
! recompute : jtf
ktf = min(kte,kde-1)
! recompute : ktf

!do j = jts, jtf
!  do k = kts, ktf
!    do i = its, itf
!      a_rfieldp(i,k,j) = a_rfieldp(i,k,j)+a_rfield(i,k,j)
!      a_rfield(i,k,j) = 0.
!    end do
!  end do
!end do

a_rfieldp(its:itf,kts:ktf,jts:jtf) = a_rfieldp(its:itf,kts:ktf,jts:jtf)+a_rfield(its:itf,kts:ktf,jts:jtf)
a_rfield(its:itf,kts:ktf,jts:jtf)  = 0.

call trace_exit("a_calculate_full")

end subroutine a_calculate_full


subroutine a_coriolis( a_ru, a_rv, a_rw, a_ru_tend, a_rv_tend, a_rw_tend, config_flags, f, e, sina, cosa, fzm, fzp, ids, ide, jds, &
&jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw_tend(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: cosa(ims:ime,jms:jme)
real, intent(in) :: e(ims:ime,jms:jme)
real, intent(in) :: f(ims:ime,jms:jme)
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: sina(ims:ime,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
logical specified

   call trace_entry("a_coriolis")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its
! recompute : i_start
i_end = ite
! recompute : i_end
if (config_flags%open_xs .or. specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
! recompute : i_start
if (config_flags%open_xe .or. specified .or. config_flags%nested) then
  i_end = min(ide-1,ite)
endif
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = jte
! recompute : j_end
if (config_flags%open_ys .or. specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
! recompute : j_start
if (config_flags%open_ye .or. specified .or. config_flags%nested) then
  j_end = min(jde-1,jte)
endif
! recompute : j_end
do j = jts, min(jte,jde-1)
  do k = kts+1, ktf
    do i = its, min(ite,ide-1)
      a_ru(i+1,k-1,j) = a_ru(i+1,k-1,j)+0.5*a_rw_tend(i,k,j)*e(i,j)*cosa(i,j)*fzp(k)
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+0.5*a_rw_tend(i,k,j)*e(i,j)*cosa(i,j)*fzp(k)
      a_ru(i+1,k,j) = a_ru(i+1,k,j)+0.5*a_rw_tend(i,k,j)*e(i,j)*cosa(i,j)*fzm(k)
      a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_rw_tend(i,k,j)*e(i,j)*cosa(i,j)*fzm(k)
      a_rv(i,k-1,j+1) = a_rv(i,k-1,j+1)-0.5*a_rw_tend(i,k,j)*e(i,j)*sina(i,j)*fzp(k)
      a_rv(i,k-1,j) = a_rv(i,k-1,j)-0.5*a_rw_tend(i,k,j)*e(i,j)*sina(i,j)*fzp(k)
      a_rv(i,k,j+1) = a_rv(i,k,j+1)-0.5*a_rw_tend(i,k,j)*e(i,j)*sina(i,j)*fzm(k)
      a_rv(i,k,j) = a_rv(i,k,j)-0.5*a_rw_tend(i,k,j)*e(i,j)*sina(i,j)*fzm(k)
    end do
  end do
end do
if (config_flags%open_ye .and. jte .eq. jde) then
  do k = kts, ktf
    do i = its, min(ide-1,ite)
      a_ru(i+1,k,jte-1) = a_ru(i+1,k,jte-1)-0.5*a_rv_tend(i,k,jte)*f(i,jte-1)
      a_ru(i,k,jte-1) = a_ru(i,k,jte-1)-0.5*a_rv_tend(i,k,jte)*f(i,jte-1)
      a_rw(i,k+1,jte-1) = a_rw(i,k+1,jte-1)+0.5*a_rv_tend(i,k,jte)*e(i,jte-1)*sina(i,jte-1)
      a_rw(i,k,jte-1) = a_rw(i,k,jte-1)+0.5*a_rv_tend(i,k,jte)*e(i,jte-1)*sina(i,jte-1)
    end do
  end do
endif
do j = j_start, j_end
  do k = kts, ktf
    do i = its, min(ide-1,ite)
      a_ru(i+1,k,j-1) = a_ru(i+1,k,j-1)-0.125*a_rv_tend(i,k,j)*(f(i,j)+f(i,j-1))
      a_ru(i,k,j-1) = a_ru(i,k,j-1)-0.125*a_rv_tend(i,k,j)*(f(i,j)+f(i,j-1))
      a_ru(i+1,k,j) = a_ru(i+1,k,j)-0.125*a_rv_tend(i,k,j)*(f(i,j)+f(i,j-1))
      a_ru(i,k,j) = a_ru(i,k,j)-0.125*a_rv_tend(i,k,j)*(f(i,j)+f(i,j-1))
      a_rw(i,k+1,j-1) = a_rw(i,k+1,j-1)+0.0625*a_rv_tend(i,k,j)*(e(i,j)+e(i,j-1))*(sina(i,j)+sina(i,j-1))
      a_rw(i,k+1,j) = a_rw(i,k+1,j)+0.0625*a_rv_tend(i,k,j)*(e(i,j)+e(i,j-1))*(sina(i,j)+sina(i,j-1))
      a_rw(i,k,j-1) = a_rw(i,k,j-1)+0.0625*a_rv_tend(i,k,j)*(e(i,j)+e(i,j-1))*(sina(i,j)+sina(i,j-1))
      a_rw(i,k,j) = a_rw(i,k,j)+0.0625*a_rv_tend(i,k,j)*(e(i,j)+e(i,j-1))*(sina(i,j)+sina(i,j-1))
    end do
  end do
end do
if (config_flags%open_ys .and. jts .eq. jds) then
  do k = kts, ktf
    do i = its, min(ide-1,ite)
      a_ru(i+1,k,jts) = a_ru(i+1,k,jts)-0.5*a_rv_tend(i,k,jts)*f(i,jts)
      a_ru(i,k,jts) = a_ru(i,k,jts)-0.5*a_rv_tend(i,k,jts)*f(i,jts)
      a_rw(i,k+1,jts) = a_rw(i,k+1,jts)+0.5*a_rv_tend(i,k,jts)*e(i,jts)*sina(i,jts)
      a_rw(i,k,jts) = a_rw(i,k,jts)+0.5*a_rv_tend(i,k,jts)*e(i,jts)*sina(i,jts)
    end do
  end do
endif
do j = jts, min(jte,jde-1)
  if (config_flags%open_xe .and. ite .eq. ide) then
    do k = kts, ktf
      a_rv(ite-1,k,j+1) = a_rv(ite-1,k,j+1)+0.5*a_ru_tend(ite,k,j)*f(ite-1,j)
      a_rv(ite-1,k,j) = a_rv(ite-1,k,j)+0.5*a_ru_tend(ite,k,j)*f(ite-1,j)
      a_rw(ite-1,k+1,j) = a_rw(ite-1,k+1,j)-0.5*a_ru_tend(ite,k,j)*e(ite-1,j)*cosa(ite-1,j)
      a_rw(ite-1,k,j) = a_rw(ite-1,k,j)-0.5*a_ru_tend(ite,k,j)*e(ite-1,j)*cosa(ite-1,j)
    end do
  endif
  if (config_flags%open_xs .and. its .eq. ids) then
    do k = kts, ktf
      a_rv(its,k,j+1) = a_rv(its,k,j+1)+0.5*a_ru_tend(its,k,j)*f(its,j)
      a_rv(its,k,j) = a_rv(its,k,j)+0.5*a_ru_tend(its,k,j)*f(its,j)
      a_rw(its,k+1,j) = a_rw(its,k+1,j)-0.5*a_ru_tend(its,k,j)*e(its,j)*cosa(its,j)
      a_rw(its,k,j) = a_rw(its,k,j)-0.5*a_ru_tend(its,k,j)*e(its,j)*cosa(its,j)
    end do
  endif
  do k = kts, ktf
    do i = i_start, i_end
      a_rv(i-1,k,j+1) = a_rv(i-1,k,j+1)+0.125*a_ru_tend(i,k,j)*(f(i,j)+f(i-1,j))
      a_rv(i,k,j+1) = a_rv(i,k,j+1)+0.125*a_ru_tend(i,k,j)*(f(i,j)+f(i-1,j))
      a_rv(i-1,k,j) = a_rv(i-1,k,j)+0.125*a_ru_tend(i,k,j)*(f(i,j)+f(i-1,j))
      a_rv(i,k,j) = a_rv(i,k,j)+0.125*a_ru_tend(i,k,j)*(f(i,j)+f(i-1,j))
      a_rw(i-1,k+1,j) = a_rw(i-1,k+1,j)-0.0625*a_ru_tend(i,k,j)*(e(i,j)+e(i-1,j))*(cosa(i,j)+cosa(i-1,j))
      a_rw(i,k+1,j) = a_rw(i,k+1,j)-0.0625*a_ru_tend(i,k,j)*(e(i,j)+e(i-1,j))*(cosa(i,j)+cosa(i-1,j))
      a_rw(i-1,k,j) = a_rw(i-1,k,j)-0.0625*a_ru_tend(i,k,j)*(e(i,j)+e(i-1,j))*(cosa(i,j)+cosa(i-1,j))
      a_rw(i,k,j) = a_rw(i,k,j)-0.0625*a_ru_tend(i,k,j)*(e(i,j)+e(i-1,j))*(cosa(i,j)+cosa(i-1,j))
    end do
  end do
end do

   call trace_exit("a_coriolis")

end subroutine a_coriolis


subroutine a_couple_momentum( muu, a_muu, a_ru, u, a_u, msfu, muv, a_muv, a_rv, v, a_v, msfv, mut, a_mut, a_rw, w, a_w, msft, ide, &
&jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: a_mut(ims:ime,jms:jme)
real, intent(inout) :: a_muu(ims:ime,jms:jme)
real, intent(inout) :: a_muv(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer itf
integer j
integer jtf
integer k
integer ktf

   call trace_entry("a_couple_momentum")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
ktf = min(kte,kde-1)
! recompute : ktf
itf = min(ite,ide-1)
! recompute : itf
jtf = min(jte,jde-1)
! recompute : jtf
do j = jts, jtf
  do k = kts, kte
    do i = its, itf
      a_mut(i,j) = a_mut(i,j)+a_rw(i,k,j)*(w(i,k,j)/msft(i,j))
      a_w(i,k,j) = a_w(i,k,j)+a_rw(i,k,j)*(mut(i,j)/msft(i,j))
      a_rw(i,k,j) = 0.
    end do
  end do
end do
! recdepend vars : ide,ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:359
! recompute vars : itf
itf = min(ite,ide-1)
! recompute vars : itf
! recdepend vars : itf,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:360
! recompute vars : jtf
jtf = jte
! recompute vars : jtf
do j = jts, jtf
  do k = kts, ktf
    do i = its, itf
      a_muv(i,j) = a_muv(i,j)+a_rv(i,k,j)*(v(i,k,j)/msfv(i,j))
      a_v(i,k,j) = a_v(i,k,j)+a_rv(i,k,j)*(muv(i,j)/msfv(i,j))
      a_rv(i,k,j) = 0.
    end do
  end do
end do
! recdepend vars : ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:348
! recompute vars : itf
itf = ite
! recompute vars : itf
! recdepend vars : itf,jde,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:349
! recompute vars : jtf
jtf = min(jte,jde-1)
! recompute vars : jtf
do j = jts, jtf
  do k = kts, ktf
    do i = its, itf
      a_muu(i,j) = a_muu(i,j)+a_ru(i,k,j)*(u(i,k,j)/msfu(i,j))
      a_u(i,k,j) = a_u(i,k,j)+a_ru(i,k,j)*(muu(i,j)/msfu(i,j))
      a_ru(i,k,j) = 0.
    end do
  end do
end do

   call trace_exit("a_couple_momentum")

end subroutine a_couple_momentum


subroutine a_curvature( ru, a_ru, rv, a_rv, rw, a_rw, u, a_u, v, a_v, a_ru_tend, a_rv_tend, a_rw_tend, config_flags, msfu, msfv, &
&fzm, fzp, rdx, rdy, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_vxgm(its-1:ite,kts:kte,jts-1:jte)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
logical specified
real vxgm(its-1:ite,kts:kte,jts-1:jte)
real walls(4)

   call trace_entry("a_curvature")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_vxgm(:,:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its-1
! recompute : i_start
i_end = ite
! recompute : i_end
j_start = jts-1
! recompute : j_start
j_end = jte
! recompute : j_end
if ((config_flags%open_xs .or. specified .or. config_flags%nested) .and. its .eq. ids) then
  i_start = its
endif
! recompute : i_start
if ((config_flags%open_xe .or. specified .or. config_flags%nested) .and. ite .eq. ide) then
  i_end = ite-1
endif
! recompute : i_end
if ((config_flags%open_ys .or. specified .or. config_flags%nested) .and. jts .eq. jds) then
  j_start = jts
endif
! recompute : j_start
if ((config_flags%open_ye .or. specified .or. config_flags%nested) .and. jte .eq. jde) then
  j_end = jte-1
endif
! recompute : j_end
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      vxgm(i,k,j) = 0.5*(u(i,k,j)+u(i+1,k,j))*(msfv(i,j+1)-msfv(i,j))*rdy-0.5*(v(i,k,j)+v(i,k,j+1))*(msfu(i+1,j)-msfu(i,j))*rdx
    end do
  end do
end do
! recompute : vxgm
if ((config_flags%open_xs .or. specified .or. config_flags%nested) .and. its .eq. ids) then
  do j = jts-1, jte
    do k = kts, ktf
      vxgm(its-1,k,j) = vxgm(its,k,j)
    end do
  end do
endif
! recompute : vxgm
if ((config_flags%open_xe .or. specified .or. config_flags%nested) .and. ite .eq. ide) then
  do j = jts-1, jte
    do k = kts, ktf
      vxgm(ite,k,j) = vxgm(ite-1,k,j)
    end do
  end do
endif
! recompute : vxgm
if ((config_flags%open_ys .or. specified .or. config_flags%nested) .and. jts .eq. jds) then
  do k = kts, ktf
    do i = its-1, ite
      vxgm(i,k,jts-1) = vxgm(i,k,jts)
    end do
  end do
endif
! recompute : vxgm
if ((config_flags%open_ye .or. specified .or. config_flags%nested) .and. jte .eq. jde) then
  do k = kts, ktf
    do i = its-1, ite
      vxgm(i,k,jte) = vxgm(i,k,jte-1)
    end do
  end do
endif
! recompute : vxgm
i_start = its
! recompute : i_start
if (config_flags%open_xs .or. specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
! recompute : i_start
if (config_flags%open_xe .or. specified .or. config_flags%nested) then
  i_end = min(ide-1,ite)
endif
! recompute : i_end
j_start = jts
! recompute : j_start
if (config_flags%open_ys .or. specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
! recompute : j_start
if (config_flags%open_ye .or. specified .or. config_flags%nested) then
  j_end = min(jde-1,jte)
endif
! recompute : j_end
do j = jts, min(jte,jde-1)
  do k = max(2,kts), ktf
    walls(3)=fzp(k)
    walls(4)=fzm(k)
    do i = its, min(ite,ide-1)
      walls(1)=0.25*a_rw_tend(i,k,j)*reradius
      walls(2)=walls(1)*(walls(4)*(u(i,k,j)+u(i+1,k,j))+walls(3)*(u(i,k-1,j)+u(i+1,k-1,j)))
      a_ru(i+1,k-1,j) = a_ru(i+1,k-1,j)+walls(3)*walls(2)
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+walls(3)*walls(2)
      a_ru(i+1,k,j) = a_ru(i+1,k,j)+walls(4)*walls(2)
      a_ru(i,k,j) = a_ru(i,k,j)+walls(4)*walls(2)
      walls(2)=walls(1)*(walls(4)*(v(i,k,j)+v(i,k,j+1))+walls(3)*(v(i,k-1,j)+v(i,k-1,j+1)))
      a_rv(i,k-1,j+1) = a_rv(i,k-1,j+1)+walls(3)*walls(2)
      a_rv(i,k-1,j) = a_rv(i,k-1,j)+walls(3)*walls(2)
      a_rv(i,k,j+1) = a_rv(i,k,j+1)+walls(4)*walls(2)
      a_rv(i,k,j) = a_rv(i,k,j)+walls(4)*walls(2)
      walls(2)=walls(1)*(walls(4)*(ru(i,k,j)+ru(i+1,k,j))+walls(3)*(ru(i,k-1,j)+ru(i+1,k-1,j)))
      a_u(i+1,k-1,j) = a_u(i+1,k-1,j)+walls(2)*walls(3)
      a_u(i,k-1,j) = a_u(i,k-1,j)+walls(2)*walls(3)
      a_u(i+1,k,j) = a_u(i+1,k,j)+walls(2)*walls(4)
      a_u(i,k,j) = a_u(i,k,j)+walls(2)*walls(4)
      walls(2)=walls(1)*(walls(4)*(rv(i,k,j)+rv(i,k,j+1))+walls(3)*(rv(i,k-1,j)+rv(i,k-1,j+1)))
      a_v(i,k-1,j+1) = a_v(i,k-1,j+1)+walls(2)*walls(3)
      a_v(i,k-1,j) = a_v(i,k-1,j)+walls(2)*walls(3)
      a_v(i,k,j+1) = a_v(i,k,j+1)+walls(2)*walls(4)
      a_v(i,k,j) = a_v(i,k,j)+walls(2)*walls(4)
    end do
  end do
end do
do j = j_start, j_end
  do k = kts, ktf
    do i = its, min(ite,ide-1)
      walls(2)=a_rv_tend(i,k,j)
      walls(1)=0.125*a_rv_tend(i,k,j)*(vxgm(i,k,j)+vxgm(i,k,j-1))
      a_ru(i+1,k,j-1) = a_ru(i+1,k,j-1)-walls(1)
      a_ru(i,k,j-1) = a_ru(i,k,j-1)-walls(1)
      a_ru(i+1,k,j) = a_ru(i+1,k,j)-walls(1)
      a_ru(i,k,j) = a_ru(i,k,j)-walls(1)
      walls(1)=0.25*walls(2)*v(i,k,j)*reradius
      a_rw(i,k+1,j-1) = a_rw(i,k+1,j-1)+walls(1)
      a_rw(i,k+1,j) = a_rw(i,k+1,j)+walls(1)
      a_rw(i,k,j-1) = a_rw(i,k,j-1)+walls(1)
      a_rw(i,k,j) = a_rw(i,k,j)+walls(1)
      a_v(i,k,j) = a_v(i,k,j)+0.25*walls(2)*reradius*(rw(i,k+1,j-1)+rw(i,k,j-1)+rw(i,k+1,j)+rw(i,k,j))
      walls(1)=0.125*walls(2)*(ru(i,k,j)+ru(i+1,k,j)+ru(i,k,j-1)+ru(i+1,k,j-1))
      a_vxgm(i,k,j-1) = a_vxgm(i,k,j-1)-walls(1)
      a_vxgm(i,k,j) = a_vxgm(i,k,j)-walls(1)
    end do
  end do
end do
do j = jts, min(jde-1,jte)
  do k = kts, ktf
    do i = i_start, i_end
      walls(2)=a_ru_tend(i,k,j)
      walls(1)=0.125*a_ru_tend(i,k,j)*(vxgm(i,k,j)+vxgm(i-1,k,j))
      a_rv(i-1,k,j+1) = a_rv(i-1,k,j+1)+walls(1)
      a_rv(i,k,j+1) = a_rv(i,k,j+1)+walls(1)
      a_rv(i-1,k,j) = a_rv(i-1,k,j)+walls(1)
      a_rv(i,k,j) = a_rv(i,k,j)+walls(1)
      walls(1)=0.25*walls(2)*u(i,k,j)*reradius
      a_rw(i-1,k+1,j) = a_rw(i-1,k+1,j)-walls(1)
      a_rw(i,k+1,j) = a_rw(i,k+1,j)-walls(1)
      a_rw(i-1,k,j) = a_rw(i-1,k,j)-walls(1)
      a_rw(i,k,j) = a_rw(i,k,j)-walls(1)
      a_u(i,k,j) = a_u(i,k,j)-0.25*walls(2)*reradius*(rw(i-1,k+1,j)+rw(i-1,k,j)+rw(i,k+1,j)+rw(i,k,j))
      walls(1)=0.125*walls(2)*(rv(i-1,k,j+1)+rv(i,k,j+1)+rv(i-1,k,j)+rv(i,k,j))
      a_vxgm(i-1,k,j) = a_vxgm(i-1,k,j)+walls(1)
      a_vxgm(i,k,j) = a_vxgm(i,k,j)+walls(1)
    end do
  end do
end do
if ((config_flags%open_ye .or. specified .or. config_flags%nested) .and. jte .eq. jde) then
  do k = kts, ktf
    do i = its-1, ite
      a_vxgm(i,k,jte-1) = a_vxgm(i,k,jte-1)+a_vxgm(i,k,jte)
      a_vxgm(i,k,jte) = 0.
    end do
  end do
endif
if ((config_flags%open_ys .or. specified .or. config_flags%nested) .and. jts .eq. jds) then
  do k = kts, ktf
    do i = its-1, ite
      a_vxgm(i,k,jts) = a_vxgm(i,k,jts)+a_vxgm(i,k,jts-1)
      a_vxgm(i,k,jts-1) = 0.
    end do
  end do
endif
if ((config_flags%open_xe .or. specified .or. config_flags%nested) .and. ite .eq. ide) then
  do j = jts-1, jte
    do k = kts, ktf
      a_vxgm(ite-1,k,j) = a_vxgm(ite-1,k,j)+a_vxgm(ite,k,j)
      a_vxgm(ite,k,j) = 0.
    end do
  end do
endif
if ((config_flags%open_xs .or. specified .or. config_flags%nested) .and. its .eq. ids) then
  do j = jts-1, jte
    do k = kts, ktf
      a_vxgm(its,k,j) = a_vxgm(its,k,j)+a_vxgm(its-1,k,j)
      a_vxgm(its-1,k,j) = 0.
    end do
  end do
endif
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3594
! recompute vars : i_start
i_start = its-1
! recompute vars : i_start
! recdepend vars : i_start,ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3595
! recompute vars : i_end
i_end = ite
! recompute vars : i_end
! recdepend vars : i_end,i_start,jts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3596
! recompute vars : j_start
j_start = jts-1
! recompute vars : j_start
! recdepend vars : i_end,i_start,j_start,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3597
! recompute vars : j_end
j_end = jte
! recompute vars : j_end
!  recdepend vars : config_flags,i_end,i_start,ids,its,j_end,j_start,spe
! cified
! recompute pos : IF_STMT module_big_step_utilities_em.f90:3599
! recompute vars : i_start
if ((config_flags%open_xs .or. specified .or. config_flags%nested) .and. its .eq. ids) then
  i_start = its
endif
! recompute vars : i_start
!  recdepend vars : config_flags,i_end,i_start,ide,ite,j_end,j_start,spe
! cified
! recompute pos : IF_STMT module_big_step_utilities_em.f90:3601
! recompute vars : i_end
if ((config_flags%open_xe .or. specified .or. config_flags%nested) .and. ite .eq. ide) then
  i_end = ite-1
endif
! recompute vars : i_end
!  recdepend vars : config_flags,i_end,i_start,j_end,j_start,jds,jts,spe
! cified
! recompute pos : IF_STMT module_big_step_utilities_em.f90:3603
! recompute vars : j_start
if ((config_flags%open_ys .or. specified .or. config_flags%nested) .and. jts .eq. jds) then
  j_start = jts
endif
! recompute vars : j_start
!  recdepend vars : config_flags,i_end,i_start,j_end,j_start,jde,jte,spe
! cified
! recompute pos : IF_STMT module_big_step_utilities_em.f90:3605
! recompute vars : j_end
if ((config_flags%open_ye .or. specified .or. config_flags%nested) .and. jte .eq. jde) then
  j_end = jte-1
endif
! recompute vars : j_end
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      walls(1)=0.5*a_vxgm(i,k,j)*(msfv(i,j+1)-msfv(i,j))*rdy
      a_u(i+1,k,j) = a_u(i+1,k,j)+walls(1)
      a_u(i,k,j) = a_u(i,k,j)+walls(1)
      walls(1)=0.5*a_vxgm(i,k,j)*(msfu(i+1,j)-msfu(i,j))*rdx
      a_v(i,k,j+1) = a_v(i,k,j+1)-walls(1)
      a_v(i,k,j) = a_v(i,k,j)-walls(1)
    end do
  end do
end do
a_vxgm(i_start:i_end,kts:ktf,j_start:j_end) = 0.

   call trace_exit("a_curvature")

end subroutine a_curvature


subroutine a_diagnose_w( ph_tend, a_ph_tend, a_ph_new, a_ph_old, a_w, mu, a_mu, dt, a_u, a_v, ht, cf1, cf2, cf3, rdx, rdy, msft, &
&ide, jde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: a_mu(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_ph_new(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cf1
real, intent(in) :: cf2
real, intent(in) :: cf3
real, intent(in) :: dt
real, intent(in) :: ht(ims:ime,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy

!==============================================
! declare local variables
!==============================================
integer i
integer itf
integer j
integer jtf
integer k

   call trace_entry("a_diagnose_w")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
itf = min(ite,ide-1)
! recompute : itf
jtf = min(jte,jde-1)
! recompute : jtf
do j = jts, jtf
  do k = 2, kte
    do i = its, itf
      a_mu(i,j) = a_mu(i,j)+a_w(i,k,j)*(msft(i,j)*(ph_tend(i,k,j)/(mu(i,j)*mu(i,j)))/g)
      a_ph_new(i,k,j) = a_ph_new(i,k,j)+a_w(i,k,j)*(msft(i,j)/dt/g)
      a_ph_old(i,k,j) = a_ph_old(i,k,j)-a_w(i,k,j)*(msft(i,j)/dt/g)
      a_ph_tend(i,k,j) = a_ph_tend(i,k,j)-a_w(i,k,j)*(msft(i,j)/mu(i,j)/g)
      a_w(i,k,j) = 0.
    end do
  end do
  do i = its, itf
    a_u(i+1,3,j) = a_u(i+1,3,j)+0.5*a_w(i,1,j)*msft(i,j)*rdx*(ht(i+1,j)-ht(i,j))*cf3
    a_u(i,3,j) = a_u(i,3,j)+0.5*a_w(i,1,j)*msft(i,j)*rdx*(ht(i,j)-ht(i,j-1))*cf3
    a_u(i+1,2,j) = a_u(i+1,2,j)+0.5*a_w(i,1,j)*msft(i,j)*rdx*(ht(i+1,j)-ht(i,j))*cf2
    a_u(i,2,j) = a_u(i,2,j)+0.5*a_w(i,1,j)*msft(i,j)*rdx*(ht(i,j)-ht(i,j-1))*cf2
    a_u(i+1,1,j) = a_u(i+1,1,j)+0.5*a_w(i,1,j)*msft(i,j)*rdx*(ht(i+1,j)-ht(i,j))*cf1
    a_u(i,1,j) = a_u(i,1,j)+0.5*a_w(i,1,j)*msft(i,j)*rdx*(ht(i,j)-ht(i,j-1))*cf1
    a_v(i,3,j+1) = a_v(i,3,j+1)+0.5*a_w(i,1,j)*msft(i,j)*rdy*(ht(i,j+1)-ht(i,j))*cf3
    a_v(i,3,j) = a_v(i,3,j)+0.5*a_w(i,1,j)*msft(i,j)*rdy*(ht(i,j)-ht(i,j-1))*cf3
    a_v(i,2,j+1) = a_v(i,2,j+1)+0.5*a_w(i,1,j)*msft(i,j)*rdy*(ht(i,j+1)-ht(i,j))*cf2
    a_v(i,2,j) = a_v(i,2,j)+0.5*a_w(i,1,j)*msft(i,j)*rdy*(ht(i,j)-ht(i,j-1))*cf2
    a_v(i,1,j+1) = a_v(i,1,j+1)+0.5*a_w(i,1,j)*msft(i,j)*rdy*(ht(i,j+1)-ht(i,j))*cf1
    a_v(i,1,j) = a_v(i,1,j)+0.5*a_w(i,1,j)*msft(i,j)*rdy*(ht(i,j)-ht(i,j-1))*cf1
    a_w(i,1,j) = 0.
  end do
end do

   call trace_exit("a_diagnose_w")

end subroutine a_diagnose_w


subroutine a_horizontal_diffusion( name, field, a_field, a_tendency, mu, a_mu, config_flags, msfu, msfv, msft, xkmhd, a_xkmhd, rdx,&
& rdy, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_field(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_mu(ims:ime,jms:jme)
real, intent(inout) :: a_tendency(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_xkmhd(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mu(ims:ime,jms:jme)
character*(1), intent(in) :: name
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: xkmhd(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_mkrdxm
real a_mkrdxp
real a_mkrdym
real a_mkrdyp
real a_rcoup
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real mkrdxm
real mkrdxp
real mkrdym
real mkrdyp
real mrdx
real mrdy
real :: pr = 3.
real rcoup
real walls(7)
logical specified

   call trace_entry("a_horizontal_diffusion")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
ktf = min(kte,kde-1)
! recompute : ktf
if (name .eq. 'u') then
  i_start = its
! recompute : i_start
  i_end = ite
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
! recompute : i_start
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-1,ite)
  endif
! recompute : i_end
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
! recompute : j_start
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-2,jte)
  endif
! recompute : j_end
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        walls(5)=0.125*(msfu(i,j)+msfu(i,j+1))*rdy
        walls(6)=0.125*(msfu(i,j)+msfu(i,j-1))*rdy
        mkrdxm = msft(i-1,j)*xkmhd(i-1,k,j)*rdx
! recompute : mkrdxm
        mkrdxp = msft(i,j)*xkmhd(i,k,j)*rdx
! recompute : mkrdxp
        mrdx = msfu(i,j)*rdx
! recompute : mrdx
        mkrdym = walls(6)*(xkmhd(i,k,j)+xkmhd(i,k,j-1)+xkmhd(i-1,k,j-1)+xkmhd(i-1,k,j))
! recompute : mkrdym
        mkrdyp = walls(5)*(xkmhd(i,k,j)+xkmhd(i,k,j+1)+xkmhd(i-1,k,j+1)+xkmhd(i-1,k,j))
! recompute : mkrdyp
        mrdy = msfu(i,j)*rdy
! recompute : mrdy
        rcoup = 0.5*(mu(i,j)+mu(i-1,j))
! recompute : rcoup
        walls(1)=field(i+1,k,j)-field(i,k,j)
        walls(2)=field(i,k,j)-field(i-1,k,j)
        walls(3)=field(i,k,j)-field(i,k,j-1)
        walls(4)=field(i,k,j+1)-field(i,k,j)
        walls(7)=a_tendency(i,k,j)*rcoup
        a_field(i,k,j-1) = a_field(i,k,j-1)+walls(7)*mrdy*mkrdym
        a_field(i,k,j+1) = a_field(i,k,j+1)+walls(7)*mrdy*mkrdyp
        a_field(i-1,k,j) = a_field(i-1,k,j)+walls(7)*mrdx*mkrdxm
        a_field(i+1,k,j) = a_field(i+1,k,j)+walls(7)*mrdx*mkrdxp
        a_field(i,k,j) = a_field(i,k,j)+walls(7)*((-(mrdx*(mkrdxp+mkrdxm)))-mrdy*(mkrdyp+mkrdym))
        a_mkrdxm = -walls(7)*mrdx*walls(2)
        a_mkrdxp = walls(7)*mrdx*walls(1)
        a_mkrdym = -walls(7)*mrdy*walls(3)
        a_mkrdyp = walls(7)*mrdy*walls(4)
        a_rcoup = a_tendency(i,k,j)*(mrdx*(mkrdxp*walls(1)-mkrdxm*walls(2))+mrdy*(mkrdyp*walls(4)-mkrdym*walls(3)))
        a_mu(i-1,j) = a_mu(i-1,j)+0.5*a_rcoup
        a_mu(i,j) = a_mu(i,j)+0.5*a_rcoup
        a_xkmhd(i-1,k,j+1) = a_xkmhd(i-1,k,j+1)+a_mkrdyp*walls(5)
        a_xkmhd(i,k,j+1) = a_xkmhd(i,k,j+1)+a_mkrdyp*walls(5)
        a_xkmhd(i-1,k,j) = a_xkmhd(i-1,k,j)+a_mkrdyp*walls(5)
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+a_mkrdyp*walls(5)
        a_xkmhd(i-1,k,j-1) = a_xkmhd(i-1,k,j-1)+a_mkrdym*walls(6)
        a_xkmhd(i,k,j-1) = a_xkmhd(i,k,j-1)+a_mkrdym*walls(6)
        a_xkmhd(i-1,k,j) = a_xkmhd(i-1,k,j)+a_mkrdym*walls(6)
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+a_mkrdym*walls(6)
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+a_mkrdxp*msft(i,j)*rdx
        a_xkmhd(i-1,k,j) = a_xkmhd(i-1,k,j)+a_mkrdxm*msft(i-1,j)*rdx
      end do
    end do
  end do
else if (name .eq. 'v') then
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = jte
! recompute : j_end
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
! recompute : i_start
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-2,ite)
  endif
! recompute : i_end
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
! recompute : j_start
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-1,jte)
  endif
! recompute : j_end
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        walls(5)=0.125*(msfv(i,j)+msfv(i+1,j))*rdx
        walls(6)=0.125*(msfv(i,j)+msfv(i-1,j))*rdx
        mkrdxm = walls(6)*(xkmhd(i,k,j)+xkmhd(i,k,j-1)+xkmhd(i-1,k,j-1)+xkmhd(i-1,k,j))
! recompute : mkrdxm
        mkrdxp = walls(5)*(xkmhd(i,k,j)+xkmhd(i,k,j-1)+xkmhd(i+1,k,j-1)+xkmhd(i+1,k,j))
! recompute : mkrdxp
        mrdx = msfv(i,j)*rdx
! recompute : mrdx
        mkrdym = msft(i,j-1)*xkmhd(i,k,j-1)*rdy
! recompute : mkrdym
        mkrdyp = msft(i,j)*xkmhd(i,k,j)*rdy
! recompute : mkrdyp
        mrdy = msfv(i,j)*rdy
! recompute : mrdy
        rcoup = 0.5*(mu(i,j)+mu(i,j-1))
! recompute : rcoup
        walls(1)=field(i+1,k,j)-field(i,k,j)
        walls(2)=field(i,k,j)-field(i-1,k,j)
        walls(3)=field(i,k,j)-field(i,k,j-1)
        walls(4)=field(i,k,j+1)-field(i,k,j)
        walls(7)=a_tendency(i,k,j)*rcoup
        a_field(i,k,j-1) = a_field(i,k,j-1)+walls(7)*mrdy*mkrdym
        a_field(i,k,j+1) = a_field(i,k,j+1)+walls(7)*mrdy*mkrdyp
        a_field(i-1,k,j) = a_field(i-1,k,j)+walls(7)*mrdx*mkrdxm
        a_field(i+1,k,j) = a_field(i+1,k,j)+walls(7)*mrdx*mkrdxp
        a_field(i,k,j) = a_field(i,k,j)+walls(7)*((-(mrdx*(mkrdxp+mkrdxm)))-mrdy*(mkrdyp+mkrdym))
        a_mkrdxm = -walls(7)*mrdx*walls(2)
        a_mkrdxp = walls(7)*mrdx*walls(1)
        a_mkrdym = -walls(7)*mrdy*walls(3)
        a_mkrdyp = walls(7)*mrdy*walls(4)
        a_rcoup = a_tendency(i,k,j)*(mrdx*(mkrdxp*walls(1)-mkrdxm*walls(2))+mrdy*(mkrdyp*walls(4)-mkrdym*walls(3)))
        a_mu(i,j-1) = a_mu(i,j-1)+0.5*a_rcoup
        a_mu(i,j) = a_mu(i,j)+0.5*a_rcoup
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+a_mkrdyp*msft(i,j)*rdy
        a_xkmhd(i,k,j-1) = a_xkmhd(i,k,j-1)+a_mkrdym*msft(i,j-1)*rdy
        a_xkmhd(i+1,k,j-1) = a_xkmhd(i+1,k,j-1)+a_mkrdxp*walls(5)
        a_xkmhd(i,k,j-1) = a_xkmhd(i,k,j-1)+a_mkrdxp*walls(5)
        a_xkmhd(i+1,k,j) = a_xkmhd(i+1,k,j)+a_mkrdxp*walls(5)
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+a_mkrdxp*walls(5)
        a_xkmhd(i-1,k,j-1) = a_xkmhd(i-1,k,j-1)+a_mkrdxm*walls(6)
        a_xkmhd(i,k,j-1) = a_xkmhd(i,k,j-1)+a_mkrdxm*walls(6)
        a_xkmhd(i-1,k,j) = a_xkmhd(i-1,k,j)+a_mkrdxm*walls(6)
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+a_mkrdxm*walls(6)
      end do
    end do
  end do
else if (name .eq. 'w') then
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
! recompute : i_start
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-2,ite)
  endif
! recompute : i_end
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
! recompute : j_start
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-2,jte)
  endif
! recompute : j_end
  do j = j_start, j_end
    do k = kts+1, ktf
      do i = i_start, i_end
        mkrdxm = msfu(i,j)*0.25*(xkmhd(i,k,j)+xkmhd(i-1,k,j)+xkmhd(i,k-1,j)+xkmhd(i-1,k-1,j))*rdx
! recompute : mkrdxm
        mkrdxp = msfu(i+1,j)*0.25*(xkmhd(i+1,k,j)+xkmhd(i,k,j)+xkmhd(i+1,k-1,j)+xkmhd(i,k-1,j))*rdx
! recompute : mkrdxp
        mrdx = msft(i,j)*rdx
! recompute : mrdx
        mkrdym = msfv(i,j)*0.25*(xkmhd(i,k,j)+xkmhd(i,k,j-1)+xkmhd(i,k-1,j)+xkmhd(i,k-1,j-1))*rdy
! recompute : mkrdym
        mkrdyp = msfv(i,j+1)*0.25*(xkmhd(i,k,j+1)+xkmhd(i,k,j)+xkmhd(i,k-1,j+1)+xkmhd(i,k-1,j))*rdy
! recompute : mkrdyp
        mrdy = msft(i,j)*rdy
! recompute : mrdy
        rcoup = 0.5*(mu(i,j)+mu(i,j))
! recompute : rcoup
        walls(1)=field(i+1,k,j)-field(i,k,j)
        walls(2)=field(i,k,j)-field(i-1,k,j)
        walls(3)=field(i,k,j)-field(i,k,j-1)
        walls(4)=field(i,k,j+1)-field(i,k,j)
        walls(6)=a_tendency(i,k,j)*rcoup
        a_field(i,k,j-1) = a_field(i,k,j-1)+walls(6)*mrdy*mkrdym
        a_field(i,k,j+1) = a_field(i,k,j+1)+walls(6)*mrdy*mkrdyp
        a_field(i-1,k,j) = a_field(i-1,k,j)+walls(6)*mrdx*mkrdxm
        a_field(i+1,k,j) = a_field(i+1,k,j)+walls(6)*mrdx*mkrdxp
        a_field(i,k,j) = a_field(i,k,j)+walls(6)*((-(mrdx*(mkrdxp+mkrdxm)))-mrdy*(mkrdyp+mkrdym))
        a_mkrdxm = -walls(6)*mrdx*walls(2)
        a_mkrdxp = walls(6)*mrdx*walls(1)
        a_mkrdym = -walls(6)*mrdy*walls(3)
        a_mkrdyp = walls(6)*mrdy*walls(4)
        a_rcoup = a_tendency(i,k,j)*(mrdx*(mkrdxp*walls(1)-mkrdxm*walls(2))+mrdy*(mkrdyp*walls(4)-mkrdym*walls(3)))
        a_mu(i,j) = a_mu(i,j)+a_rcoup
        walls(5)=0.25*a_mkrdyp*msfv(i,j+1)*rdy
        a_xkmhd(i,k-1,j+1) = a_xkmhd(i,k-1,j+1)+walls(5)
        a_xkmhd(i,k-1,j) = a_xkmhd(i,k-1,j)+walls(5)
        a_xkmhd(i,k,j+1) = a_xkmhd(i,k,j+1)+walls(5)
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+walls(5)
        walls(5)=0.25*a_mkrdym*msfv(i,j)*rdy
        a_xkmhd(i,k-1,j-1) = a_xkmhd(i,k-1,j-1)+walls(5)
        a_xkmhd(i,k-1,j) = a_xkmhd(i,k-1,j)+walls(5)
        a_xkmhd(i,k,j-1) = a_xkmhd(i,k,j-1)+walls(5)
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+walls(5)
        walls(5)=0.25*a_mkrdxp*msfu(i+1,j)*rdx
        a_xkmhd(i+1,k-1,j) = a_xkmhd(i+1,k-1,j)+walls(5)
        a_xkmhd(i,k-1,j) = a_xkmhd(i,k-1,j)+walls(5)
        a_xkmhd(i+1,k,j) = a_xkmhd(i+1,k,j)+walls(5)
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+walls(5)
        walls(5)=0.25*a_mkrdxm*msfu(i,j)*rdx
        a_xkmhd(i-1,k-1,j) = a_xkmhd(i-1,k-1,j)+walls(5)
        a_xkmhd(i,k-1,j) = a_xkmhd(i,k-1,j)+walls(5)
        a_xkmhd(i-1,k,j) = a_xkmhd(i-1,k,j)+walls(5)
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+walls(5)
      end do
    end do
  end do
else
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
! recompute : i_start
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-2,ite)
  endif
! recompute : i_end
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
! recompute : j_start
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-2,jte)
  endif
! recompute : j_end
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        mkrdxm = msfu(i,j)*0.5*(xkmhd(i,k,j)+xkmhd(i-1,k,j))*rdx*pr
! recompute : mkrdxm
        mkrdxp = msfu(i+1,j)*0.5*(xkmhd(i+1,k,j)+xkmhd(i,k,j))*rdx*pr
! recompute : mkrdxp
        mrdx = msft(i,j)*rdx
! recompute : mrdx
        mkrdym = msfv(i,j)*0.5*(xkmhd(i,k,j)+xkmhd(i,k,j-1))*rdy*pr
! recompute : mkrdym
        mkrdyp = msfv(i,j+1)*0.5*(xkmhd(i,k,j+1)+xkmhd(i,k,j))*rdy*pr
! recompute : mkrdyp
        mrdy = msft(i,j)*rdy
! recompute : mrdy
        rcoup = mu(i,j)
! recompute : rcoup
        walls(1)=field(i+1,k,j)-field(i,k,j)
        walls(2)=field(i,k,j)-field(i-1,k,j)
        walls(3)=field(i,k,j)-field(i,k,j-1)
        walls(4)=field(i,k,j+1)-field(i,k,j)
        walls(5)=a_tendency(i,k,j)*rcoup
        a_field(i,k,j-1) = a_field(i,k,j-1)+walls(5)*mrdy*mkrdym
        a_field(i,k,j+1) = a_field(i,k,j+1)+walls(5)*mrdy*mkrdyp
        a_field(i-1,k,j) = a_field(i-1,k,j)+walls(5)*mrdx*mkrdxm
        a_field(i+1,k,j) = a_field(i+1,k,j)+walls(5)*mrdx*mkrdxp
        a_field(i,k,j) = a_field(i,k,j)+walls(5)*((-(mrdx*(mkrdxp+mkrdxm)))-mrdy*(mkrdyp+mkrdym))
        a_mkrdxm = -walls(5)*mrdx*walls(2)
        a_mkrdxp = walls(5)*mrdx*walls(1)
        a_mkrdym = -walls(5)*mrdy*walls(3)
        a_mkrdyp = walls(5)*mrdy*walls(4)
        a_rcoup = a_tendency(i,k,j)*(mrdx*(mkrdxp*walls(1)-mkrdxm*walls(2))+mrdy*(mkrdyp*walls(4)-mkrdym*walls(3)))
        a_mu(i,j) = a_mu(i,j)+a_rcoup
        a_xkmhd(i,k,j+1) = a_xkmhd(i,k,j+1)+0.5*a_mkrdyp*msfv(i,j+1)*rdy*pr
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+0.5*a_mkrdyp*msfv(i,j+1)*rdy*pr
        a_xkmhd(i,k,j-1) = a_xkmhd(i,k,j-1)+0.5*a_mkrdym*msfv(i,j)*rdy*pr
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+0.5*a_mkrdym*msfv(i,j)*rdy*pr
        a_xkmhd(i+1,k,j) = a_xkmhd(i+1,k,j)+0.5*a_mkrdxp*msfu(i+1,j)*rdx*pr
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+0.5*a_mkrdxp*msfu(i+1,j)*rdx*pr
        a_xkmhd(i-1,k,j) = a_xkmhd(i-1,k,j)+0.5*a_mkrdxm*msfu(i,j)*rdx*pr
        a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+0.5*a_mkrdxm*msfu(i,j)*rdx*pr
      end do
    end do
  end do
endif

   call trace_exit("a_horizontal_diffusion")

end subroutine a_horizontal_diffusion


subroutine a_horizontal_diffusion_3dmp( field, a_field, a_tendency, mu, a_mu, config_flags, base_3d, msfu, msfv, msft, xkmhd, &
&a_xkmhd, rdx, rdy, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_field(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_mu(ims:ime,jms:jme)
real, intent(inout) :: a_tendency(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(in) :: base_3d(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: xkmhd(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_mkrdxm
real a_mkrdxp
real a_mkrdym
real a_mkrdyp
real a_rcoup
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real mkrdxm
real mkrdxp
real mkrdym
real mkrdyp
real mrdx
real mrdy
real :: pr = 3.
real rcoup
real walls(5)
logical specified

   call trace_entry("a_horizontal_diffusion_3dmp")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
if (config_flags%open_xs .or. specified) then
  i_start = max(ids+1,its)
endif
! recompute : i_start
if (config_flags%open_xe .or. specified) then
  i_end = min(ide-2,ite)
endif
! recompute : i_end
if (config_flags%open_ys .or. specified) then
  j_start = max(jds+1,jts)
endif
! recompute : j_start
if (config_flags%open_ye .or. specified) then
  j_end = min(jde-2,jte)
endif
! recompute : j_end
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      mkrdxm = msfu(i,j)*0.5*(xkmhd(i,k,j)+xkmhd(i-1,k,j))*rdx*pr
! recompute : mkrdxm
      mkrdxp = msfu(i+1,j)*0.5*(xkmhd(i+1,k,j)+xkmhd(i,k,j))*rdx*pr
! recompute : mkrdxp
      mrdx = msft(i,j)*rdx
! recompute : mrdx
      mkrdym = msfv(i,j)*0.5*(xkmhd(i,k,j)+xkmhd(i,k,j-1))*rdy*pr
! recompute : mkrdym
      mkrdyp = msfv(i,j+1)*0.5*(xkmhd(i,k,j+1)+xkmhd(i,k,j))*rdy*pr
! recompute : mkrdyp
      mrdy = msft(i,j)*rdy
! recompute : mrdy
      rcoup = mu(i,j)
! recompute : rcoup
      walls(1)=field(i+1,k,j)-field(i,k,j)-base_3d(i+1,k,j)+base_3d(i,k,j)
      walls(2)=field(i,k,j)-field(i-1,k,j)-base_3d(i,k,j)+base_3d(i-1,k,j)
      walls(3)=field(i,k,j)-field(i,k,j-1)-base_3d(i,k,j)+base_3d(i,k,j-1)
      walls(4)=field(i,k,j+1)-field(i,k,j)-base_3d(i,k,j+1)+base_3d(i,k,j)
      walls(5)=a_tendency(i,k,j)*rcoup
      a_field(i,k,j-1) = a_field(i,k,j-1)+walls(5)*mrdy*mkrdym
      a_field(i,k,j+1) = a_field(i,k,j+1)+walls(5)*mrdy*mkrdyp
      a_field(i-1,k,j) = a_field(i-1,k,j)+walls(5)*mrdx*mkrdxm
      a_field(i+1,k,j) = a_field(i+1,k,j)+walls(5)*mrdx*mkrdxp
      a_field(i,k,j) = a_field(i,k,j)+walls(5)*((-(mrdx*(mkrdxp+mkrdxm)))-mrdy*(mkrdyp+mkrdym))
      a_mkrdxm = -walls(5)*mrdx*walls(2)
      a_mkrdxp = walls(5)*mrdx*walls(1)
      a_mkrdym = -walls(5)*mrdy*walls(3)
      a_mkrdyp = walls(5)*mrdy*walls(4)
      a_rcoup = a_tendency(i,k,j)*(mrdx*(mkrdxp*walls(1)-mkrdxm*walls(2))+mrdy*(mkrdyp*walls(4)-mkrdym*walls(3)))
      a_mu(i,j) = a_mu(i,j)+a_rcoup
      a_xkmhd(i,k,j+1) = a_xkmhd(i,k,j+1)+0.5*a_mkrdyp*msfv(i,j+1)*rdy*pr
      a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+0.5*a_mkrdyp*msfv(i,j+1)*rdy*pr
      a_xkmhd(i,k,j-1) = a_xkmhd(i,k,j-1)+0.5*a_mkrdym*msfv(i,j)*rdy*pr
      a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+0.5*a_mkrdym*msfv(i,j)*rdy*pr
      a_xkmhd(i+1,k,j) = a_xkmhd(i+1,k,j)+0.5*a_mkrdxp*msfu(i+1,j)*rdx*pr
      a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+0.5*a_mkrdxp*msfu(i+1,j)*rdx*pr
      a_xkmhd(i-1,k,j) = a_xkmhd(i-1,k,j)+0.5*a_mkrdxm*msfu(i,j)*rdx*pr
      a_xkmhd(i,k,j) = a_xkmhd(i,k,j)+0.5*a_mkrdxm*msfu(i,j)*rdx*pr
    end do
  end do
end do

   call trace_exit("a_horizontal_diffusion_3dmp")

end subroutine a_horizontal_diffusion_3dmp


subroutine a_horizontal_pressure_gradient( a_ru_tend, a_rv_tend, ph, a_ph, alt, a_alt, p, a_p, pb, al, a_al, php, a_php, cqu, &
&a_cqu, cqv, a_cqv, muu, a_muu, muv, a_muv, mu, a_mu, fnm, fnp, rdnw, cf1, cf2, cf3, rdx, rdy, config_flags, non_hydrostatic, ids, &
&ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_al(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_alt(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqu(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_mu(ims:ime,jms:jme)
real, intent(inout) :: a_muu(ims:ime,jms:jme)
real, intent(inout) :: a_muv(ims:ime,jms:jme)
real, intent(inout) :: a_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_php(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cf1
real, intent(in) :: cf2
real, intent(in) :: cf3
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: cqu(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cqv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: fnm(kms:kme)
real, intent(in) :: fnp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
logical, intent(in) :: non_hydrostatic
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: php(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: rdx
real, intent(in) :: rdy

real  :: keep_ph(ims:ime,kms:kme)

!==============================================
! declare local variables
!==============================================
real walls(7)
real a_dpn(ims:ime,kms:kme)
real a_dpx
real a_dpy
real dpn(ims:ime,kms:kme)
real dpx
real dpy
integer i
integer i_start
integer itf
integer j
integer j_start
integer jtf
integer k
integer ktf
logical specified

   call trace_entry("a_horizontal_pressure_gradient")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_dpn(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
itf = ite
! recompute : itf
jtf = min(jte,jde-1)
! recompute : jtf
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its
! recompute : i_start
j_start = jts
! recompute : j_start
if ((config_flags%open_xs .or. specified .or. config_flags%nested) .and. its .eq. ids) then
  i_start = its+1
endif
! recompute : i_start
if ((config_flags%open_xe .or. specified .or. config_flags%nested) .and. ite .eq. ide) then
  itf = itf-1
endif
! recompute : itf
do j = j_start, jtf
  keep_ph(i_start:itf,1:ktf)=ph(i_start:itf,2:ktf+1,j)-ph(i_start-1:itf-1,2:ktf+1,j)+ph(i_start:itf,1:ktf,j)-ph(i_start-1:itf-1,1:ktf,j)
  if (non_hydrostatic) then
    k = 1
! recompute : k
!   do i = i_start, itf
!     dpn(i,k) = 0.5*(cf1*(p(i-1,k,j)+p(i,k,j))+cf2*(p(i-1,k+1,j)+p(i,k+1,j))+cf3*(p(i-1,k+2,j)+p(i,k+2,j)))
!   end do
    dpn(i_start:itf,k) = 0.5*(cf1*(p(i_start-1:itf-1,k,j)+p(i_start:itf,k,j))+cf2*(p(i_start-1:itf-1,k+1,j)+p(i_start:itf,k+1,j))&
&+cf3*(p(i_start-1:itf-1,k+2,j)+p(i_start:itf,k+2,j)))
    dpn(i_start:itf,kde) = 0.
    do k = 2, ktf
!     do i = i_start, itf
!       dpn(i,k) = 0.5*(fnm(k)*(p(i-1,k,j)+p(i,k,j))+fnp(k)*(p(i-1,k-1,j)+p(i,k-1,j)))
!     end do
      dpn(i_start:itf,k) = 0.5*(fnm(k)*(p(i_start-1:itf-1,k,j)+p(i_start:itf,k,j))+fnp(k)*(p(i_start-1:itf-1,k-1,j)+p(i_start:itf,k-1,j)))
    end do

! recompute : dpn
    do k = 1, ktf
      walls(1)=rdnw(k)
      do i = i_start, itf
        walls(2)=php(i,k,j)-php(i-1,k,j)
        walls(3)=pb(i,k,j)-pb(i-1,k,j)
        walls(4)=alt(i,k,j)+alt(i-1,k,j)
        walls(5)=rdx*(walls(1)*(dpn(i,k+1)-dpn(i,k))-0.5*(mu(i-1,j)+mu(i,j)))
        walls(6)=keep_ph(i,k)+walls(4)*(p(i,k,j)-p(i-1,k,j))+(al(i,k,j)+al(i-1,k,j))*walls(3)
        dpx = 0.5*rdx*muu(i,j)*walls(6)
! recompute : dpx
        dpx = dpx+walls(2)*walls(5)
! recompute : dpx
        a_cqu(i,k,j) = a_cqu(i,k,j)-a_ru_tend(i,k,j)*dpx
        a_dpx = -a_ru_tend(i,k,j)*cqu(i,k,j)
        a_dpn(i,k+1) = a_dpn(i,k+1)+a_dpx*rdx*walls(2)*walls(1)
        a_dpn(i,k) = a_dpn(i,k)-a_dpx*rdx*walls(2)*walls(1)
        a_mu(i-1,j) = a_mu(i-1,j)-0.5*a_dpx*rdx*walls(2)
        a_mu(i,j) = a_mu(i,j)-0.5*a_dpx*rdx*walls(2)
        walls(2)=a_dpx*walls(5)
        walls(5)=0.5*a_dpx*rdx*muu(i,j)
        a_php(i-1,k,j) = a_php(i-1,k,j)-walls(2)
        a_php(i,k,j)   = a_php(i,k,j)  +walls(2)
        a_al(i-1,k,j) = a_al(i-1,k,j)+walls(5)*walls(3)
        a_al(i,k,j) = a_al(i,k,j)+walls(5)*walls(3)
        walls(2)=walls(5)*(p(i,k,j)-p(i-1,k,j))
        a_alt(i-1,k,j) = a_alt(i-1,k,j)+walls(2)
        a_alt(i,k,j)   = a_alt(i,k,j)  +walls(2)
        a_muu(i,j) = a_muu(i,j)+0.5*a_dpx*rdx*walls(6)
        a_p(i-1,k,j) = a_p(i-1,k,j)-walls(5)*walls(4)
        a_p(i,k,j) = a_p(i,k,j)+walls(5)*walls(4)
        a_ph(i-1,k+1,j) = a_ph(i-1,k+1,j)-walls(5)
        a_ph(i,k+1,j) = a_ph(i,k+1,j)+walls(5)
        a_ph(i-1,k,j) = a_ph(i-1,k,j)-walls(5)
        a_ph(i,k,j) = a_ph(i,k,j)+walls(5)
      end do
    end do
    do k = 2, ktf
!     do i = i_start, itf
!       a_p(i-1,k-1,j) = a_p(i-1,k-1,j)+0.5*a_dpn(i,k)*fnp(k)
!       a_p(i,k-1,j) = a_p(i,k-1,j)+0.5*a_dpn(i,k)*fnp(k)
!       a_p(i-1,k,j) = a_p(i-1,k,j)+0.5*a_dpn(i,k)*fnm(k)
!       a_p(i,k,j) = a_p(i,k,j)+0.5*a_dpn(i,k)*fnm(k)
!     end do
      a_p(i_start-1:itf-1,k-1,j) = a_p(i_start-1:itf-1,k-1,j)+0.5*a_dpn(i_start:itf,k)*fnp(k)
      a_p(i_start:itf,k-1,j) = a_p(i_start:itf,k-1,j)+0.5*a_dpn(i_start:itf,k)*fnp(k)
      a_p(i_start-1:itf-1,k,j) = a_p(i_start-1:itf-1,k,j)+0.5*a_dpn(i_start:itf,k)*fnm(k)
      a_p(i_start:itf,k,j) = a_p(i_start:itf,k,j)+0.5*a_dpn(i_start:itf,k)*fnm(k)
    end do
    a_dpn(i_start:itf,2:ktf) = 0.
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:2001
! recompute vars : k
    k = 1
! recompute vars : k
    a_dpn(i_start:itf,kde) = 0.
!   do i = i_start, itf
!     a_p(i-1,k+2,j) = a_p(i-1,k+2,j)+0.5*a_dpn(i,k)*cf3
!     a_p(i,k+2,j) = a_p(i,k+2,j)+0.5*a_dpn(i,k)*cf3
!     a_p(i-1,k+1,j) = a_p(i-1,k+1,j)+0.5*a_dpn(i,k)*cf2
!     a_p(i,k+1,j) = a_p(i,k+1,j)+0.5*a_dpn(i,k)*cf2
!     a_p(i-1,k,j) = a_p(i-1,k,j)+0.5*a_dpn(i,k)*cf1
!     a_p(i,k,j) = a_p(i,k,j)+0.5*a_dpn(i,k)*cf1
!   end do
    a_p(i_start-1:itf-1,k+2,j) = a_p(i_start-1:itf-1,k+2,j)+0.5*a_dpn(i_start:itf,k)*cf3
    a_p(i_start:itf,k+2,j) = a_p(i_start:itf,k+2,j)+0.5*a_dpn(i_start:itf,k)*cf3
    a_p(i_start-1:itf-1,k+1,j) = a_p(i_start-1:itf-1,k+1,j)+0.5*a_dpn(i_start:itf,k)*cf2
    a_p(i_start:itf,k+1,j) = a_p(i_start:itf,k+1,j)+0.5*a_dpn(i_start:itf,k)*cf2
    a_p(i_start-1:itf-1,k,j) = a_p(i_start-1:itf-1,k,j)+0.5*a_dpn(i_start:itf,k)*cf1
    a_p(i_start:itf,k,j) = a_p(i_start:itf,k,j)+0.5*a_dpn(i_start:itf,k)*cf1
    a_dpn(i_start:itf,k) = 0.

  else

    do k = 1, ktf
      do i = i_start, itf
        walls(3)=pb(i,k,j)-pb(i-1,k,j)
        walls(4)=alt(i,k,j)+alt(i-1,k,j)
        walls(2)=rdx*(keep_ph(i,k)+walls(4)*(p(i,k,j)-p(i-1,k,j))+(al(i,k,j)+al(i-1,k,j))*walls(3))
        dpx = 0.5*muu(i,j)*walls(2)
! recompute : dpx
        a_cqu(i,k,j) = a_cqu(i,k,j)-a_ru_tend(i,k,j)*dpx
        a_dpx = -a_ru_tend(i,k,j)*cqu(i,k,j)
        walls(5)=0.5*a_dpx*rdx*muu(i,j)
        a_al(i-1,k,j) = a_al(i-1,k,j)+walls(5)*walls(3)
        a_al(i,k,j) = a_al(i,k,j)+walls(5)*walls(3)
        a_alt(i-1,k,j) = a_alt(i-1,k,j)+walls(5)*(p(i,k,j)-p(i-1,k,j))
        a_alt(i,k,j) = a_alt(i,k,j)+walls(5)*(p(i,k,j)-p(i-1,k,j))
        a_muu(i,j) = a_muu(i,j)+0.5*a_dpx*walls(2)
        a_p(i-1,k,j) = a_p(i-1,k,j)-walls(5)*walls(4)
        a_p(i,k,j) = a_p(i,k,j)+walls(5)*walls(4)
        a_ph(i-1,k+1,j) = a_ph(i-1,k+1,j)-walls(5)
        a_ph(i,k+1,j) = a_ph(i,k+1,j)+walls(5)
        a_ph(i-1,k,j) = a_ph(i-1,k,j)-walls(5)
        a_ph(i,k,j) = a_ph(i,k,j)+walls(5)
      end do
    end do
  endif
end do

! recdepend vars : ide,ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1927
! recompute vars : itf
itf = min(ite,ide-1)
! recompute vars : itf
! recdepend vars : itf,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1928
! recompute vars : jtf
jtf = jte
! recompute vars : jtf
! recdepend vars : itf,jtf,kde,kte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1929
! recompute vars : ktf
ktf = min(kte,kde-1)
! recompute vars : ktf
! recdepend vars : itf,its,jtf,ktf
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1930
! recompute vars : i_start
i_start = its
! recompute vars : i_start
! recdepend vars : i_start,itf,jtf,jts,ktf
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1931
! recompute vars : j_start
j_start = jts
! recompute vars : j_start
!  recdepend vars : config_flags,i_start,itf,j_start,jds,jtf,jts,ktf,spe
! cified
! recompute pos : IF_STMT module_big_step_utilities_em.f90:1932
! recompute vars : j_start
if ((config_flags%open_ys .or. specified .or. config_flags%nested) .and. jts .eq. jds) then
  j_start = jts+1
endif
! recompute vars : j_start
!  recdepend vars : config_flags,i_start,itf,j_start,jde,jte,jtf,ktf,spe
! cified
! recompute pos : IF_STMT module_big_step_utilities_em.f90:1934
! recompute vars : jtf
if ((config_flags%open_ye .or. specified .or. config_flags%nested) .and. jte .eq. jde) then
  jtf = jtf-1
endif
! recompute vars : jtf

do j = j_start, jtf
  keep_ph(i_start:itf,1:ktf)=ph(i_start:itf,2:ktf+1,j)-ph(i_start:itf,2:ktf+1,j-1)+ph(i_start:itf,1:ktf,j)-ph(i_start:itf,1:ktf,j-1)
  if (non_hydrostatic) then
    k = 1
! recompute : k
!   do i = i_start, itf
!     dpn(i,k) = 0.5*(cf1*(p(i,k,j-1)+p(i,k,j))+cf2*(p(i,k+1,j-1)+p(i,k+1,j))+cf3*(p(i,k+2,j-1)+p(i,k+2,j)))
!   end do
    dpn(i_start:itf,k) = 0.5*(cf1*(p(i_start:itf,k,j-1)+p(i_start:itf,k,j))+cf2*(p(i_start:itf,k+1,j-1)+p(i_start:itf,k+1,j))&
&+cf3*(p(i_start:itf,k+2,j-1)+p(i_start:itf,k+2,j)))
    dpn(i_start:itf,kde) = 0.
    do k = 2, ktf
!     do i = i_start, itf
!       dpn(i,k) = 0.5*(fnm(k)*(p(i,k,j-1)+p(i,k,j))+fnp(k)*(p(i,k-1,j-1)+p(i,k-1,j)))
!     end do
      dpn(i_start:itf,k) = 0.5*(fnm(k)*(p(i_start:itf,k,j-1)+p(i_start:itf,k,j))+fnp(k)*(p(i_start:itf,k-1,j-1)+p(i_start:itf,k-1,j)))
    end do
! recompute : dpn
    do k = 1, ktf
      walls(1)=rdnw(k)
      do i = i_start, itf
        walls(2)=php(i,k,j)-php(i,k,j-1)
        walls(3)=pb(i,k,j)-pb(i,k,j-1)
        walls(4)=p(i,k,j)-p(i,k,j-1)
        walls(5)=alt(i,k,j)+alt(i,k,j-1)
        walls(6)=keep_ph(i,k)+walls(5)*walls(4)+(al(i,k,j)+al(i,k,j-1))*walls(3)
        dpy = 0.5*rdy*muv(i,j)*walls(6)
! recompute : dpy
        dpy = dpy+rdy*walls(2)*(walls(1)*(dpn(i,k+1)-dpn(i,k))-0.5*(mu(i,j-1)+mu(i,j)))
! recompute : dpy
        a_cqv(i,k,j) = a_cqv(i,k,j)-a_rv_tend(i,k,j)*dpy
        a_dpy = -a_rv_tend(i,k,j)*cqv(i,k,j)
        walls(7)=0.5*a_dpy*rdy*muv(i,j)
        a_dpn(i,k+1) = a_dpn(i,k+1)+a_dpy*rdy*walls(2)*walls(1)
        a_dpn(i,k) = a_dpn(i,k)-a_dpy*rdy*walls(2)*walls(1)
        a_mu(i,j-1) = a_mu(i,j-1)-0.5*a_dpy*rdy*walls(2)
        a_mu(i,j) = a_mu(i,j)-0.5*a_dpy*rdy*walls(2)
        walls(2)=a_dpy*rdy*(walls(1)*(dpn(i,k+1)-dpn(i,k))-0.5*(mu(i,j-1)+mu(i,j)))
        a_php(i,k,j-1) = a_php(i,k,j-1)-walls(2)
        a_php(i,k,j) = a_php(i,k,j)+walls(2)
        a_al(i,k,j-1) = a_al(i,k,j-1)+walls(7)*walls(3)
        a_al(i,k,j) = a_al(i,k,j)+walls(7)*walls(3)
        a_alt(i,k,j-1) = a_alt(i,k,j-1)+walls(7)*walls(4)
        a_alt(i,k,j) = a_alt(i,k,j)+walls(7)*walls(4)
        a_muv(i,j) = a_muv(i,j)+0.5*a_dpy*rdy*walls(6)
        a_p(i,k,j-1) = a_p(i,k,j-1)-walls(7)*walls(5)
        a_p(i,k,j) = a_p(i,k,j)+walls(7)*walls(5)
        a_ph(i,k+1,j-1) = a_ph(i,k+1,j-1)-walls(7)
        a_ph(i,k+1,j) = a_ph(i,k+1,j)+walls(7)
        a_ph(i,k,j-1) = a_ph(i,k,j-1)-walls(7)
        a_ph(i,k,j) = a_ph(i,k,j)+walls(7)
      end do
    end do
    do k = 2, ktf
!     do i = i_start, itf
!       a_p(i,k-1,j-1) = a_p(i,k-1,j-1)+0.5*a_dpn(i,k)*fnp(k)
!       a_p(i,k-1,j) = a_p(i,k-1,j)+0.5*a_dpn(i,k)*fnp(k)
!       a_p(i,k,j-1) = a_p(i,k,j-1)+0.5*a_dpn(i,k)*fnm(k)
!       a_p(i,k,j) = a_p(i,k,j)+0.5*a_dpn(i,k)*fnm(k)
!     end do
      a_p(i_start:itf,k-1,j-1) = a_p(i_start:itf,k-1,j-1)+0.5*a_dpn(i_start:itf,k)*fnp(k)
      a_p(i_start:itf,k-1,j) = a_p(i_start:itf,k-1,j)+0.5*a_dpn(i_start:itf,k)*fnp(k)
      a_p(i_start:itf,k,j-1) = a_p(i_start:itf,k,j-1)+0.5*a_dpn(i_start:itf,k)*fnm(k)
      a_p(i_start:itf,k,j) = a_p(i_start:itf,k,j)+0.5*a_dpn(i_start:itf,k)*fnm(k)
      a_dpn(i_start:itf,k) = 0.
    end do
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1941
! recompute vars : k
    k = 1
! recompute vars : k
    a_dpn(i_start:itf,kde) = 0.
!   do i = i_start, itf
!     a_p(i,k+2,j-1) = a_p(i,k+2,j-1)+0.5*a_dpn(i,k)*cf3
!     a_p(i,k+2,j) = a_p(i,k+2,j)+0.5*a_dpn(i,k)*cf3
!     a_p(i,k+1,j-1) = a_p(i,k+1,j-1)+0.5*a_dpn(i,k)*cf2
!     a_p(i,k+1,j) = a_p(i,k+1,j)+0.5*a_dpn(i,k)*cf2
!     a_p(i,k,j-1) = a_p(i,k,j-1)+0.5*a_dpn(i,k)*cf1
!     a_p(i,k,j) = a_p(i,k,j)+0.5*a_dpn(i,k)*cf1
!   end do
    a_p(i_start:itf,k+2,j-1) = a_p(i_start:itf,k+2,j-1)+0.5*a_dpn(i_start:itf,k)*cf3
    a_p(i_start:itf,k+2,j) = a_p(i_start:itf,k+2,j)+0.5*a_dpn(i_start:itf,k)*cf3
    a_p(i_start:itf,k+1,j-1) = a_p(i_start:itf,k+1,j-1)+0.5*a_dpn(i_start:itf,k)*cf2
    a_p(i_start:itf,k+1,j) = a_p(i_start:itf,k+1,j)+0.5*a_dpn(i_start:itf,k)*cf2
    a_p(i_start:itf,k,j-1) = a_p(i_start:itf,k,j-1)+0.5*a_dpn(i_start:itf,k)*cf1
    a_p(i_start:itf,k,j) = a_p(i_start:itf,k,j)+0.5*a_dpn(i_start:itf,k)*cf1
    a_dpn(i_start:itf,k) = 0.

  else

    do k = 1, ktf
      do i = i_start, itf
        walls(3)=pb(i,k,j)-pb(i,k,j-1)
        walls(4)=p(i,k,j)-p(i,k,j-1)
        walls(5)=alt(i,k,j)+alt(i,k,j-1)
        walls(6)=keep_ph(i,k)+walls(5)*walls(4)+(al(i,k,j)+al(i,k,j-1))*walls(3)
        dpy = 0.5*rdy*muv(i,j)*walls(6)
! recompute : dpy
        a_cqv(i,k,j) = a_cqv(i,k,j)-a_rv_tend(i,k,j)*dpy
        a_dpy = -a_rv_tend(i,k,j)*cqv(i,k,j)
        walls(7)=0.5*a_dpy*rdy*muv(i,j)
        a_al(i,k,j-1) = a_al(i,k,j-1)+walls(7)*walls(3)
        a_al(i,k,j) = a_al(i,k,j)+walls(7)*walls(3)
        a_alt(i,k,j-1) = a_alt(i,k,j-1)+walls(7)*walls(4)
        a_alt(i,k,j) = a_alt(i,k,j)+walls(7)*walls(4)
        a_muv(i,j) = a_muv(i,j)+0.5*a_dpy*rdy*walls(6)
        a_p(i,k,j-1) = a_p(i,k,j-1)-walls(7)*walls(5)
        a_p(i,k,j) = a_p(i,k,j)+walls(7)*walls(5)
        a_ph(i,k+1,j-1) = a_ph(i,k+1,j-1)-walls(7)
        a_ph(i,k+1,j) = a_ph(i,k+1,j)+walls(7)
        a_ph(i,k,j-1) = a_ph(i,k,j-1)-walls(7)
        a_ph(i,k,j) = a_ph(i,k,j)+walls(7)
      end do
    end do
  endif
end do

   call trace_exit("a_horizontal_pressure_gradient")

end subroutine a_horizontal_pressure_gradient


subroutine a_perturbation_coriolis( a_ru_in, a_rv_in, a_rw, a_ru_tend, a_rv_tend, a_rw_tend, config_flags, u_base, v_base, z_base, &
&muu, a_muu, muv, a_muv, phb, ph, a_ph, f, e, sina, cosa, fzm, fzp, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, &
&ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: a_muu(ims:ime,jms:jme)
real, intent(inout) :: a_muv(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_ph(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru_in(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_in(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw_tend(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: cosa(ims:ime,jms:jme)
real, intent(in) :: e(ims:ime,jms:jme)
real, intent(in) :: f(ims:ime,jms:jme)
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: sina(ims:ime,jms:jme)
real, intent(in) :: u_base(kms:kme)
real, intent(in) :: v_base(kms:kme)
real, intent(in) :: z_base(kms:kme)

!==============================================
! declare local variables
!==============================================
real a_ru(ims:ime,kms:kme,jms:jme)
real a_rv(ims:ime,kms:kme,jms:jme)
real a_wk
real a_wkm1
real a_wkp1
real a_z_at_u
real a_z_at_v
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
logical specified
real wk
real wkm1
real wkp1
real z_at_u
real z_at_v

   call trace_entry("a_perturbation_coriolis")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_ru(:,:,:) = 0.
a_rv(:,:,:) = 0.
a_wk = 0.
a_wkm1 = 0.
a_wkp1 = 0.
a_z_at_u = 0.
a_z_at_v = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its
! recompute : i_start
i_end = ite
! recompute : i_end
if (config_flags%open_xs .or. specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
! recompute : i_start
if (config_flags%open_xe .or. specified .or. config_flags%nested) then
  i_end = min(ide-1,ite)
endif
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = jte
! recompute : j_end
if (config_flags%open_ys .or. specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
! recompute : j_start
if (config_flags%open_ye .or. specified .or. config_flags%nested) then
  j_end = min(jde-1,jte)
endif
! recompute : j_end
do j = jts, min(jte,jde-1)
  do k = kts+1, ktf
    do i = its, min(ite,ide-1)
      a_ru(i+1,k-1,j) = a_ru(i+1,k-1,j)+0.5*a_rw_tend(i,k,j)*e(i,j)*cosa(i,j)*fzp(k)
      a_ru(i,k-1,j) = a_ru(i,k-1,j)+0.5*a_rw_tend(i,k,j)*e(i,j)*cosa(i,j)*fzp(k)
      a_ru(i+1,k,j) = a_ru(i+1,k,j)+0.5*a_rw_tend(i,k,j)*e(i,j)*cosa(i,j)*fzm(k)
      a_ru(i,k,j) = a_ru(i,k,j)+0.5*a_rw_tend(i,k,j)*e(i,j)*cosa(i,j)*fzm(k)
      a_rv(i,k-1,j+1) = a_rv(i,k-1,j+1)-0.5*a_rw_tend(i,k,j)*e(i,j)*sina(i,j)*fzp(k)
      a_rv(i,k-1,j) = a_rv(i,k-1,j)-0.5*a_rw_tend(i,k,j)*e(i,j)*sina(i,j)*fzp(k)
      a_rv(i,k,j+1) = a_rv(i,k,j+1)-0.5*a_rw_tend(i,k,j)*e(i,j)*sina(i,j)*fzm(k)
      a_rv(i,k,j) = a_rv(i,k,j)-0.5*a_rw_tend(i,k,j)*e(i,j)*sina(i,j)*fzm(k)
    end do
  end do
end do
if (config_flags%open_ye .and. jte .eq. jde) then
  do k = kts, ktf
    do i = its, min(ide-1,ite)
      a_ru(i+1,k,jte-1) = a_ru(i+1,k,jte-1)-0.5*a_rv_tend(i,k,jte)*f(i,jte-1)
      a_ru(i,k,jte-1) = a_ru(i,k,jte-1)-0.5*a_rv_tend(i,k,jte)*f(i,jte-1)
      a_rw(i,k+1,jte-1) = a_rw(i,k+1,jte-1)+0.5*a_rv_tend(i,k,jte)*e(i,jte-1)*sina(i,jte-1)
      a_rw(i,k,jte-1) = a_rw(i,k,jte-1)+0.5*a_rv_tend(i,k,jte)*e(i,jte-1)*sina(i,jte-1)
    end do
  end do
endif
do j = j_start, j_end
  do k = kts, ktf
    do i = its, min(ide-1,ite)
      a_ru(i+1,k,j-1) = a_ru(i+1,k,j-1)-0.125*a_rv_tend(i,k,j)*(f(i,j)+f(i,j-1))
      a_ru(i,k,j-1) = a_ru(i,k,j-1)-0.125*a_rv_tend(i,k,j)*(f(i,j)+f(i,j-1))
      a_ru(i+1,k,j) = a_ru(i+1,k,j)-0.125*a_rv_tend(i,k,j)*(f(i,j)+f(i,j-1))
      a_ru(i,k,j) = a_ru(i,k,j)-0.125*a_rv_tend(i,k,j)*(f(i,j)+f(i,j-1))
      a_rw(i,k+1,j-1) = a_rw(i,k+1,j-1)+0.0625*a_rv_tend(i,k,j)*(e(i,j)+e(i,j-1))*(sina(i,j)+sina(i,j-1))
      a_rw(i,k+1,j) = a_rw(i,k+1,j)+0.0625*a_rv_tend(i,k,j)*(e(i,j)+e(i,j-1))*(sina(i,j)+sina(i,j-1))
      a_rw(i,k,j-1) = a_rw(i,k,j-1)+0.0625*a_rv_tend(i,k,j)*(e(i,j)+e(i,j-1))*(sina(i,j)+sina(i,j-1))
      a_rw(i,k,j) = a_rw(i,k,j)+0.0625*a_rv_tend(i,k,j)*(e(i,j)+e(i,j-1))*(sina(i,j)+sina(i,j-1))
    end do
  end do
end do
if (config_flags%open_ys .and. jts .eq. jds) then
  do k = kts, ktf
    do i = its, min(ide-1,ite)
      a_ru(i+1,k,jts) = a_ru(i+1,k,jts)-0.5*a_rv_tend(i,k,jts)*f(i,jts)
      a_ru(i,k,jts) = a_ru(i,k,jts)-0.5*a_rv_tend(i,k,jts)*f(i,jts)
      a_rw(i,k+1,jts) = a_rw(i,k+1,jts)+0.5*a_rv_tend(i,k,jts)*e(i,jts)*sina(i,jts)
      a_rw(i,k,jts) = a_rw(i,k,jts)+0.5*a_rv_tend(i,k,jts)*e(i,jts)*sina(i,jts)
    end do
  end do
endif
do j = j_start-1, j_end
  a_wk = 0.
  a_wkm1 = 0.
  a_wkp1 = 0.
  a_z_at_u = 0.
  do i = its, min(ite,ide-1)+1
    a_wk = 0.
    a_wkm1 = 0.
    a_wkp1 = 0.
    a_z_at_u = 0.
    k = kts
! recompute : k
    z_at_u = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i-1,k,j)+phb(i-1,k+1,j)+ph(i,k,j)+ph(i,k+1,j)+ph(i-1,k,j)+ph(i-1,k+1,j))/g
! recompute : z_at_u
    wkp1 = min(1.,max(0.,z_at_u-z_base(k))/(z_base(k+1)-z_base(k)))
! recompute : wkp1
    k = ktf
! recompute : k
    z_at_u = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i-1,k,j)+phb(i-1,k+1,j)+ph(i,k,j)+ph(i,k+1,j)+ph(i-1,k,j)+ph(i-1,k+1,j))/g
! recompute : z_at_u
    wkm1 = min(1.,max(0.,z_base(k)-z_at_u)/(z_base(k)-z_base(k-1)))
! recompute : wkm1
    wk = 1.-wkm1
! recompute : wk
    a_muu(i,j) = a_muu(i,j)-a_ru(i,k,j)*(wkm1*u_base(k-1)+wk*u_base(k))
    a_ru_in(i,k,j) = a_ru_in(i,k,j)+a_ru(i,k,j)
    a_wk = a_wk-a_ru(i,k,j)*muu(i,j)*u_base(k)
    a_wkm1 = a_wkm1-a_ru(i,k,j)*muu(i,j)*u_base(k-1)
    a_ru(i,k,j) = 0.
    a_wkm1 = a_wkm1-a_wk
    a_wk = 0.
    a_z_at_u = a_z_at_u-a_wkm1*(0.5-sign(0.5,max(0.,z_base(k)-z_at_u)/(z_base(k)-z_base(k-1))-1.))*((0.5-sign(0.5,0.-(z_base(k)-&
&z_at_u)))/(z_base(k)-z_base(k-1)))
    a_wkm1 = 0.
    a_ph(i-1,k+1,j) = a_ph(i-1,k+1,j)+a_z_at_u*(0.25/g)
    a_ph(i,k+1,j) = a_ph(i,k+1,j)+a_z_at_u*(0.25/g)
    a_ph(i-1,k,j) = a_ph(i-1,k,j)+a_z_at_u*(0.25/g)
    a_ph(i,k,j) = a_ph(i,k,j)+a_z_at_u*(0.25/g)
    a_z_at_u = 0.
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3426
! recompute vars : k
    k = kts
! recompute vars : k
! recdepend vars : k,wkp1
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3432
! recompute vars : wk
    wk = 1.-wkp1
! recompute vars : wk
    a_muu(i,j) = a_muu(i,j)-a_ru(i,k,j)*(wk*u_base(k)+wkp1*u_base(k+1))
    a_ru_in(i,k,j) = a_ru_in(i,k,j)+a_ru(i,k,j)
    a_wk = a_wk-a_ru(i,k,j)*muu(i,j)*u_base(k)
    a_wkp1 = a_wkp1-a_ru(i,k,j)*muu(i,j)*u_base(k+1)
    a_ru(i,k,j) = 0.
    a_wkp1 = a_wkp1-a_wk
    a_wk = 0.
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3426
! recompute vars : k
    k = kts
! recompute vars : k
! recdepend vars : g,i,j,k,ph,phb
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3427
! recompute vars : z_at_u
    z_at_u = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i-1,k,j)+phb(i-1,k+1,j)+ph(i,k,j)+ph(i,k+1,j)+ph(i-1,k,j)+ph(i-1,k+1,j))/g
! recompute vars : z_at_u
    a_z_at_u = a_z_at_u+a_wkp1*(0.5-sign(0.5,max(0.,z_at_u-z_base(k))/(z_base(k+1)-z_base(k))-1.))*((0.5-sign(0.5,0.-(z_at_u-&
&z_base(k))))/(z_base(k+1)-z_base(k)))
    a_wkp1 = 0.
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3426
! recompute vars : k
    k = kts
! recompute vars : k
    a_ph(i-1,k+1,j) = a_ph(i-1,k+1,j)+a_z_at_u*(0.25/g)
    a_ph(i,k+1,j) = a_ph(i,k+1,j)+a_z_at_u*(0.25/g)
    a_ph(i-1,k,j) = a_ph(i-1,k,j)+a_z_at_u*(0.25/g)
    a_ph(i,k,j) = a_ph(i,k,j)+a_z_at_u*(0.25/g)
    a_z_at_u = 0.
  end do
end do
do j = j_start-1, j_end
  a_wk = 0.
  a_wkm1 = 0.
  a_wkp1 = 0.
  a_z_at_u = 0.
  do k = kts+1, ktf-1
    a_wk = 0.
    a_wkm1 = 0.
    a_wkp1 = 0.
    a_z_at_u = 0.
    do i = its, min(ite,ide-1)+1
      a_wk = 0.
      a_wkm1 = 0.
      a_wkp1 = 0.
      a_z_at_u = 0.
      z_at_u = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i-1,k,j)+phb(i-1,k+1,j)+ph(i,k,j)+ph(i,k+1,j)+ph(i-1,k,j)+ph(i-1,k+1,j))/g
! recompute : z_at_u
      wkp1 = min(1.,max(0.,z_at_u-z_base(k))/(z_base(k+1)-z_base(k)))
! recompute : wkp1
      wkm1 = min(1.,max(0.,z_base(k)-z_at_u)/(z_base(k)-z_base(k-1)))
! recompute : wkm1
      wk = 1.-wkp1-wkm1
! recompute : wk
      a_muu(i,j) = a_muu(i,j)-a_ru(i,k,j)*(wkm1*u_base(k-1)+wk*u_base(k)+wkp1*u_base(k+1))
      a_ru_in(i,k,j) = a_ru_in(i,k,j)+a_ru(i,k,j)
      a_wk = a_wk-a_ru(i,k,j)*muu(i,j)*u_base(k)
      a_wkm1 = a_wkm1-a_ru(i,k,j)*muu(i,j)*u_base(k-1)
      a_wkp1 = a_wkp1-a_ru(i,k,j)*muu(i,j)*u_base(k+1)
      a_ru(i,k,j) = 0.
      a_wkm1 = a_wkm1-a_wk
      a_wkp1 = a_wkp1-a_wk
      a_wk = 0.
      a_z_at_u = a_z_at_u-a_wkm1*(0.5-sign(0.5,max(0.,z_base(k)-z_at_u)/(z_base(k)-z_base(k-1))-1.))*((0.5-sign(0.5,0.-(z_base(k)-&
&z_at_u)))/(z_base(k)-z_base(k-1)))
      a_wkm1 = 0.
      a_z_at_u = a_z_at_u+a_wkp1*(0.5-sign(0.5,max(0.,z_at_u-z_base(k))/(z_base(k+1)-z_base(k))-1.))*((0.5-sign(0.5,0.-(z_at_u-&
&z_base(k))))/(z_base(k+1)-z_base(k)))
      a_wkp1 = 0.
      a_ph(i-1,k+1,j) = a_ph(i-1,k+1,j)+a_z_at_u*(0.25/g)
      a_ph(i,k+1,j) = a_ph(i,k+1,j)+a_z_at_u*(0.25/g)
      a_ph(i-1,k,j) = a_ph(i-1,k,j)+a_z_at_u*(0.25/g)
      a_ph(i,k,j) = a_ph(i,k,j)+a_z_at_u*(0.25/g)
      a_z_at_u = 0.
    end do
  end do
end do
do j = jts, min(jte,jde-1)
  if (config_flags%open_xe .and. ite .eq. ide) then
    do k = kts, ktf
      a_rv(ite-1,k,j+1) = a_rv(ite-1,k,j+1)+0.5*a_ru_tend(ite,k,j)*f(ite-1,j)
      a_rv(ite-1,k,j) = a_rv(ite-1,k,j)+0.5*a_ru_tend(ite,k,j)*f(ite-1,j)
      a_rw(ite-1,k+1,j) = a_rw(ite-1,k+1,j)-0.5*a_ru_tend(ite,k,j)*e(ite-1,j)*cosa(ite-1,j)
      a_rw(ite-1,k,j) = a_rw(ite-1,k,j)-0.5*a_ru_tend(ite,k,j)*e(ite-1,j)*cosa(ite-1,j)
    end do
  endif
  if (config_flags%open_xs .and. its .eq. ids) then
    do k = kts, ktf
      a_rv(its,k,j+1) = a_rv(its,k,j+1)+0.5*a_ru_tend(its,k,j)*f(its,j)
      a_rv(its,k,j) = a_rv(its,k,j)+0.5*a_ru_tend(its,k,j)*f(its,j)
      a_rw(its,k+1,j) = a_rw(its,k+1,j)-0.5*a_ru_tend(its,k,j)*e(its,j)*cosa(its,j)
      a_rw(its,k,j) = a_rw(its,k,j)-0.5*a_ru_tend(its,k,j)*e(its,j)*cosa(its,j)
    end do
  endif
  do k = kts, ktf
    do i = i_start, i_end
      a_rv(i-1,k,j+1) = a_rv(i-1,k,j+1)+0.125*a_ru_tend(i,k,j)*(f(i,j)+f(i-1,j))
      a_rv(i,k,j+1) = a_rv(i,k,j+1)+0.125*a_ru_tend(i,k,j)*(f(i,j)+f(i-1,j))
      a_rv(i-1,k,j) = a_rv(i-1,k,j)+0.125*a_ru_tend(i,k,j)*(f(i,j)+f(i-1,j))
      a_rv(i,k,j) = a_rv(i,k,j)+0.125*a_ru_tend(i,k,j)*(f(i,j)+f(i-1,j))
      a_rw(i-1,k+1,j) = a_rw(i-1,k+1,j)-0.0625*a_ru_tend(i,k,j)*(e(i,j)+e(i-1,j))*(cosa(i,j)+cosa(i-1,j))
      a_rw(i,k+1,j) = a_rw(i,k+1,j)-0.0625*a_ru_tend(i,k,j)*(e(i,j)+e(i-1,j))*(cosa(i,j)+cosa(i-1,j))
      a_rw(i-1,k,j) = a_rw(i-1,k,j)-0.0625*a_ru_tend(i,k,j)*(e(i,j)+e(i-1,j))*(cosa(i,j)+cosa(i-1,j))
      a_rw(i,k,j) = a_rw(i,k,j)-0.0625*a_ru_tend(i,k,j)*(e(i,j)+e(i-1,j))*(cosa(i,j)+cosa(i-1,j))
    end do
  end do
end do
do j = jts, min(jte,jde-1)+1
  a_wk = 0.
  a_wkm1 = 0.
  a_wkp1 = 0.
  a_z_at_v = 0.
  do i = i_start-1, i_end
    a_wk = 0.
    a_wkm1 = 0.
    a_wkp1 = 0.
    a_z_at_v = 0.
    k = kts
! recompute : k
    z_at_v = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i,k,j-1)+phb(i,k+1,j-1)+ph(i,k,j)+ph(i,k+1,j)+ph(i,k,j-1)+ph(i,k+1,j-1))/g
! recompute : z_at_v
    wkp1 = min(1.,max(0.,z_at_v-z_base(k))/(z_base(k+1)-z_base(k)))
! recompute : wkp1
    k = ktf
! recompute : k
    z_at_v = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i,k,j-1)+phb(i,k+1,j-1)+ph(i,k,j)+ph(i,k+1,j)+ph(i,k,j-1)+ph(i,k+1,j-1))/g
! recompute : z_at_v
    wkm1 = min(1.,max(0.,z_base(k)-z_at_v)/(z_base(k)-z_base(k-1)))
! recompute : wkm1
    wk = 1.-wkm1
! recompute : wk
    a_muv(i,j) = a_muv(i,j)-a_rv(i,k,j)*(wkm1*v_base(k-1)+wk*v_base(k))
    a_rv_in(i,k,j) = a_rv_in(i,k,j)+a_rv(i,k,j)
    a_wk = a_wk-a_rv(i,k,j)*muv(i,j)*v_base(k)
    a_wkm1 = a_wkm1-a_rv(i,k,j)*muv(i,j)*v_base(k-1)
    a_rv(i,k,j) = 0.
    a_wkm1 = a_wkm1-a_wk
    a_wk = 0.
    a_z_at_v = a_z_at_v-a_wkm1*(0.5-sign(0.5,max(0.,z_base(k)-z_at_v)/(z_base(k)-z_base(k-1))-1.))*((0.5-sign(0.5,0.-(z_base(k)-&
&z_at_v)))/(z_base(k)-z_base(k-1)))
    a_wkm1 = 0.
    a_ph(i,k+1,j-1) = a_ph(i,k+1,j-1)+a_z_at_v*(0.25/g)
    a_ph(i,k+1,j) = a_ph(i,k+1,j)+a_z_at_v*(0.25/g)
    a_ph(i,k,j-1) = a_ph(i,k,j-1)+a_z_at_v*(0.25/g)
    a_ph(i,k,j) = a_ph(i,k,j)+a_z_at_v*(0.25/g)
    a_z_at_v = 0.
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3325
! recompute vars : k
    k = kts
! recompute vars : k
! recdepend vars : k,wkp1
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3331
! recompute vars : wk
    wk = 1.-wkp1
! recompute vars : wk
    a_muv(i,j) = a_muv(i,j)-a_rv(i,k,j)*(wk*v_base(k)+wkp1*v_base(k+1))
    a_rv_in(i,k,j) = a_rv_in(i,k,j)+a_rv(i,k,j)
    a_wk = a_wk-a_rv(i,k,j)*muv(i,j)*v_base(k)
    a_wkp1 = a_wkp1-a_rv(i,k,j)*muv(i,j)*v_base(k+1)
    a_rv(i,k,j) = 0.
    a_wkp1 = a_wkp1-a_wk
    a_wk = 0.
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3325
! recompute vars : k
    k = kts
! recompute vars : k
! recdepend vars : g,i,j,k,ph,phb
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3326
! recompute vars : z_at_v
    z_at_v = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i,k,j-1)+phb(i,k+1,j-1)+ph(i,k,j)+ph(i,k+1,j)+ph(i,k,j-1)+ph(i,k+1,j-1))/g
! recompute vars : z_at_v
    a_z_at_v = a_z_at_v+a_wkp1*(0.5-sign(0.5,max(0.,z_at_v-z_base(k))/(z_base(k+1)-z_base(k))-1.))*((0.5-sign(0.5,0.-(z_at_v-&
&z_base(k))))/(z_base(k+1)-z_base(k)))
    a_wkp1 = 0.
! recdepend vars : kts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:3325
! recompute vars : k
    k = kts
! recompute vars : k
    a_ph(i,k+1,j-1) = a_ph(i,k+1,j-1)+a_z_at_v*(0.25/g)
    a_ph(i,k+1,j) = a_ph(i,k+1,j)+a_z_at_v*(0.25/g)
    a_ph(i,k,j-1) = a_ph(i,k,j-1)+a_z_at_v*(0.25/g)
    a_ph(i,k,j) = a_ph(i,k,j)+a_z_at_v*(0.25/g)
    a_z_at_v = 0.
  end do
end do
do j = jts, min(jte,jde-1)+1
  a_wk = 0.
  a_wkm1 = 0.
  a_wkp1 = 0.
  a_z_at_v = 0.
  do k = kts+1, ktf-1
    a_wk = 0.
    a_wkm1 = 0.
    a_wkp1 = 0.
    a_z_at_v = 0.
    do i = i_start-1, i_end
      a_wk = 0.
      a_wkm1 = 0.
      a_wkp1 = 0.
      a_z_at_v = 0.
      z_at_v = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i,k,j-1)+phb(i,k+1,j-1)+ph(i,k,j)+ph(i,k+1,j)+ph(i,k,j-1)+ph(i,k+1,j-1))/g
! recompute : z_at_v
      wkp1 = min(1.,max(0.,z_at_v-z_base(k))/(z_base(k+1)-z_base(k)))
! recompute : wkp1
      wkm1 = min(1.,max(0.,z_base(k)-z_at_v)/(z_base(k)-z_base(k-1)))
! recompute : wkm1
      wk = 1.-wkp1-wkm1
! recompute : wk
      a_muv(i,j) = a_muv(i,j)-a_rv(i,k,j)*(wkm1*v_base(k-1)+wk*v_base(k)+wkp1*v_base(k+1))
      a_rv_in(i,k,j) = a_rv_in(i,k,j)+a_rv(i,k,j)
      a_wk = a_wk-a_rv(i,k,j)*muv(i,j)*v_base(k)
      a_wkm1 = a_wkm1-a_rv(i,k,j)*muv(i,j)*v_base(k-1)
      a_wkp1 = a_wkp1-a_rv(i,k,j)*muv(i,j)*v_base(k+1)
      a_rv(i,k,j) = 0.
      a_wkm1 = a_wkm1-a_wk
      a_wkp1 = a_wkp1-a_wk
      a_wk = 0.
      a_z_at_v = a_z_at_v-a_wkm1*(0.5-sign(0.5,max(0.,z_base(k)-z_at_v)/(z_base(k)-z_base(k-1))-1.))*((0.5-sign(0.5,0.-(z_base(k)-&
&z_at_v)))/(z_base(k)-z_base(k-1)))
      a_wkm1 = 0.
      a_z_at_v = a_z_at_v+a_wkp1*(0.5-sign(0.5,max(0.,z_at_v-z_base(k))/(z_base(k+1)-z_base(k))-1.))*((0.5-sign(0.5,0.-(z_at_v-&
&z_base(k))))/(z_base(k+1)-z_base(k)))
      a_wkp1 = 0.
      a_ph(i,k+1,j-1) = a_ph(i,k+1,j-1)+a_z_at_v*(0.25/g)
      a_ph(i,k+1,j) = a_ph(i,k+1,j)+a_z_at_v*(0.25/g)
      a_ph(i,k,j-1) = a_ph(i,k,j-1)+a_z_at_v*(0.25/g)
      a_ph(i,k,j) = a_ph(i,k,j)+a_z_at_v*(0.25/g)
      a_z_at_v = 0.
    end do
  end do
end do

   call trace_exit("a_perturbation_coriolis")

end subroutine a_perturbation_coriolis


subroutine a_pg_buoy_w( a_rw_tend, p, a_p, cqw, a_cqw, a_mu, mub, rdnw, rdn, g, msft, ide, jde, kde, ims, ime, jms, jme, kms, kme, &
&its, ite, jts, jte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_cqw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_mu(ims:ime,jms:jme)
real, intent(inout) :: a_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: cqw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: mub(ims:ime,jms:jme)
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)

!==============================================
! declare local variables
!==============================================
real a_cq1
real a_cq2
real cq1
integer i
integer itf
integer j
integer jtf
integer k

   call trace_entry("a_pg_buoy_w")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_cq1 = 0.
a_cq2 = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
itf = min(ite,ide-1)
! recompute : itf
jtf = min(jte,jde-1)
! recompute : jtf
do j = jts, jtf
  a_cq1 = 0.
  a_cq2 = 0.
  do k = 2, kde-1
    a_cq1 = 0.
    a_cq2 = 0.
    do i = its, itf
      a_cq1 = 0.
      a_cq2 = 0.
      cq1 = 1./(1.+cqw(i,k,j))
! recompute : cq1
      a_cq1 = a_cq1+a_rw_tend(i,k,j)*1./msft(i,j)*g*rdn(k)*(p(i,k,j)-p(i,k-1,j))
      a_cq2 = a_cq2-a_rw_tend(i,k,j)*1./msft(i,j)*g*mub(i,j)
      a_mu(i,j) = a_mu(i,j)-a_rw_tend(i,k,j)*1./msft(i,j)*g
      a_p(i,k-1,j) = a_p(i,k-1,j)-a_rw_tend(i,k,j)*1./msft(i,j)*g*cq1*rdn(k)
      a_p(i,k,j) = a_p(i,k,j)+a_rw_tend(i,k,j)*1./msft(i,j)*g*cq1*rdn(k)
      a_cq1 = a_cq1+a_cqw(i,k,j)
      a_cqw(i,k,j) = 0.
      a_cq1 = a_cq1+a_cq2*cqw(i,k,j)
      a_cqw(i,k,j) = a_cqw(i,k,j)+a_cq2*cq1
      a_cq2 = 0.
      a_cqw(i,k,j) = a_cqw(i,k,j)-a_cq1/((1.+cqw(i,k,j))*(1.+cqw(i,k,j)))
      a_cq1 = 0.
    end do
  end do
! recdepend vars : kde
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:2094
! recompute vars : k
  k = kde
! recompute vars : k
  do i = its, itf
    a_cq1 = 0.
    a_cq2 = 0.
    cq1 = 1./(1.+cqw(i,k-1,j))
! recompute : cq1
    a_cq1 = a_cq1-2*a_rw_tend(i,k,j)*1./msft(i,j)*g*rdnw(k-1)*p(i,k-1,j)
    a_cq2 = a_cq2-a_rw_tend(i,k,j)*1./msft(i,j)*g*mub(i,j)
    a_mu(i,j) = a_mu(i,j)-a_rw_tend(i,k,j)*1./msft(i,j)*g
    a_p(i,k-1,j) = a_p(i,k-1,j)-2*a_rw_tend(i,k,j)*1./msft(i,j)*g*cq1*rdnw(k-1)
    a_cq1 = a_cq1+a_cq2*cqw(i,k-1,j)
    a_cqw(i,k-1,j) = a_cqw(i,k-1,j)+a_cq2*cq1
    a_cq2 = 0.
    a_cqw(i,k-1,j) = a_cqw(i,k-1,j)-a_cq1/((1.+cqw(i,k-1,j))*(1.+cqw(i,k-1,j)))
    a_cq1 = 0.
  end do
end do

   call trace_exit("a_pg_buoy_w")

end subroutine a_pg_buoy_w


subroutine a_phy_prep( p, a_p, pb, ph, a_ph, phb, t, a_t, th_phy, a_th_phy, p_phy, a_p_phy, pi_phy, a_pi_phy, a_p8w, t_phy, &
&a_t_phy, a_t8w, z, a_z, z_at_w, a_z_at_w, fzm, fzp, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_p8w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_p_phy(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_pi_phy(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t8w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_phy(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_th_phy(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_z(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_z_at_w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(out) :: p_phy(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: pi_phy(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t(ims:ime,kms:kme,jms:jme)
real, intent(out) :: t_phy(ims:ime,kms:kme,jms:jme)
real, intent(out) :: th_phy(ims:ime,kms:kme,jms:jme)
real, intent(out) :: z(ims:ime,kms:kme,jms:jme)
real, intent(out) :: z_at_w(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real walls(6)
real a_w1
real a_w2
real a_z0
real a_z1
real a_z2
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer k_end
integer k_start
real w1
real w2
real z0
real z1
real z2

   call trace_entry("a_phy_prep")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
k_start = kts
! recompute : k_start
k_end = min(kte,kde-1)
! recompute : k_end

th_phy(i_start:i_end,k_start:k_end,j_start:j_end) = t(i_start:i_end,k_start:k_end,j_start:j_end)+t0
p_phy(i_start:i_end,k_start:k_end,j_start:j_end) = p(i_start:i_end,k_start:k_end,j_start:j_end)+pb(i_start:i_end,k_start:k_end,j_start:j_end)
do j = j_start, j_end
  do k = k_start, k_end
    do i = i_start, i_end
      pi_phy(i,k,j) = (p_phy(i,k,j)/p1000mb)**rcp
      t_phy(i,k,j) = th_phy(i,k,j)*pi_phy(i,k,j)
    end do
  end do
end do
! recompute : p_phy,t_phy

z_at_w(i_start:i_end,k_start:kte,j_start:j_end)=(phb(i_start:i_end,k_start:kte,j_start:j_end)+ph(i_start:i_end,k_start:kte,j_start:j_end))/g
!do j = j_start, j_end
!  do k = k_start, kte
!    do i = i_start, i_end
!      z_at_w(i,k,j) = (phb(i,k,j)+ph(i,k,j))/g
!    end do
!  end do
!end do
! recompute : z_at_w

z(i_start:i_end,k_start:k_end,j_start:j_end) = 0.5*(z_at_w(i_start:i_end,k_start:k_end,j_start:j_end)&
&+z_at_w(i_start:i_end,k_start+1:k_end+1,j_start:j_end))
!do j = j_start, j_end
!  do k = k_start, k_end
!    do i = i_start, i_end
!      z(i,k,j) = 0.5*(z_at_w(i,k,j)+z_at_w(i,k+1,j))
!    end do
!  end do
!end do

! recompute : z
do j = j_start, j_end
  do i = i_start, i_end
    z0 = z_at_w(i,kte,j)
! recompute : z0
    z1 = z(i,k_end,j)
! recompute : z1
    z2 = z(i,k_end-1,j)
! recompute : z2
    walls(1)=z1-z2
    w1 = (z0-z2)/walls(1)
! recompute : w1
    w2 = 1.-w1
! recompute : w2
    walls(2)=log(p_phy(i,kde-1,j))
    walls(3)=log(p_phy(i,kde-2,j))
    walls(4)=exp(w1*walls(2)+w2*walls(3))*a_p8w(i,kde,j)

    a_t_phy(i,kde-2,j) = a_t_phy(i,kde-2,j)+a_t8w(i,kde,j)*w2
    a_t_phy(i,kde-1,j) = a_t_phy(i,kde-1,j)+a_t8w(i,kde,j)*w1
    a_w1 = a_t8w(i,kde,j)*t_phy(i,kde-1,j)
    a_w2 = a_t8w(i,kde,j)*t_phy(i,kde-2,j)
    a_t8w(i,kde,j) = 0.
    a_p_phy(i,kde-2,j) = a_p_phy(i,kde-2,j)+w2*(1./p_phy(i,kde-2,j))*walls(4)
    a_p_phy(i,kde-1,j) = a_p_phy(i,kde-1,j)+w1*(1./p_phy(i,kde-1,j))*walls(4)
    a_w1 = a_w1+walls(4)*walls(2)
    a_w2 = a_w2+walls(4)*walls(3)
    a_p8w(i,kde,j) = 0.
    a_w1 = a_w1-a_w2
    a_z0 = a_w1/walls(1)
    a_z1 = a_w1*((z0-z2)/(walls(1)*walls(1)))
    a_z2 = a_w1*((-1)/walls(1)+(z0-z2)/(walls(1)*walls(1)))
    a_z(i,k_end-1,j) = a_z(i,k_end-1,j)+a_z2
    a_z(i,k_end,j) = a_z(i,k_end,j)+a_z1
    a_z_at_w(i,kte,j) = a_z_at_w(i,kte,j)+a_z0
! recdepend vars : i,j,z_at_w
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4092
! recompute vars : z0
    z0 = z_at_w(i,1,j)
! recompute vars : z0
! recdepend vars : i,j,z,z0
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4093
! recompute vars : z1
    z1 = z(i,1,j)
! recompute vars : z1
! recdepend vars : i,j,z,z0,z1
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4094
! recompute vars : z2
    z2 = z(i,2,j)
! recompute vars : z2
! recdepend vars : z0,z1,z2
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4095
! recompute vars : w1
    w1 = (z0-z2)/(z1-z2)
! recompute vars : w1
! recdepend vars : w1
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4096
! recompute vars : w2
    w2 = 1.-w1
! recompute vars : w2
    a_t_phy(i,2,j) = a_t_phy(i,2,j)+a_t8w(i,1,j)*w2
    a_t_phy(i,1,j) = a_t_phy(i,1,j)+a_t8w(i,1,j)*w1
    a_w1 = a_t8w(i,1,j)*t_phy(i,1,j)
    a_w2 = a_t8w(i,1,j)*t_phy(i,2,j)
    a_t8w(i,1,j) = 0.
! recdepend vars : i,j,z_at_w
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4092
! recompute vars : z0
    z0 = z_at_w(i,1,j)
! recompute vars : z0
! recdepend vars : i,j,z,z0
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4093
! recompute vars : z1
    z1 = z(i,1,j)
! recompute vars : z1
! recdepend vars : i,j,z,z0,z1
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4094
! recompute vars : z2
    z2 = z(i,2,j)
! recompute vars : z2
! recdepend vars : z0,z1,z2
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4095
! recompute vars : w1
    w1 = (z0-z2)/(z1-z2)
! recompute vars : w1
! recdepend vars : w1
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4096
! recompute vars : w2
    w2 = 1.-w1
! recompute vars : w2
    a_p_phy(i,2,j) = a_p_phy(i,2,j)+a_p8w(i,1,j)*w2
    a_p_phy(i,1,j) = a_p_phy(i,1,j)+a_p8w(i,1,j)*w1
    a_w1 = a_w1+a_p8w(i,1,j)*p_phy(i,1,j)
    a_w2 = a_w2+a_p8w(i,1,j)*p_phy(i,2,j)
    a_p8w(i,1,j) = 0.
    a_w1 = a_w1-a_w2
! recdepend vars : i,j,z_at_w
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4092
! recompute vars : z0
    z0 = z_at_w(i,1,j)
! recompute vars : z0
! recdepend vars : i,j,z,z0
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4093
! recompute vars : z1
    z1 = z(i,1,j)
! recompute vars : z1
! recdepend vars : i,j,z,z0,z1
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:4094
! recompute vars : z2
    z2 = z(i,2,j)
! recompute vars : z2
    walls(1)=z1-z2
    a_z0 = a_w1/walls(1)
    a_z1 = -a_w1*((z0-z2)/(walls(1)*walls(1)))
    a_z2 = a_w1*((-1)/walls(1)+(z0-z2)/(walls(1)*walls(1)))
    a_z(i,2,j) = a_z(i,2,j)+a_z2
    a_z(i,1,j) = a_z(i,1,j)+a_z1
    a_z_at_w(i,1,j) = a_z_at_w(i,1,j)+a_z0
  end do
end do
do j = j_start, j_end
  do k = 2, k_end
    do i = i_start, i_end
      a_t_phy(i,k-1,j) = a_t_phy(i,k-1,j)+a_t8w(i,k,j)*fzp(k)
      a_t_phy(i,k,j) = a_t_phy(i,k,j)+a_t8w(i,k,j)*fzm(k)
      a_t8w(i,k,j) = 0.
      a_p_phy(i,k-1,j) = a_p_phy(i,k-1,j)+a_p8w(i,k,j)*fzp(k)
      a_p_phy(i,k,j) = a_p_phy(i,k,j)+a_p8w(i,k,j)*fzm(k)
      a_p8w(i,k,j) = 0.
    end do
  end do
end do
!do j = j_start, j_end
!  do k = k_start, k_end
!    do i = i_start, i_end
!      a_z_at_w(i,k+1,j) = a_z_at_w(i,k+1,j)+0.5*a_z(i,k,j)
!      a_z_at_w(i,k,j) = a_z_at_w(i,k,j)+0.5*a_z(i,k,j)
!      a_z(i,k,j) = 0.
!    end do
!  end do
!end do
a_z_at_w(i_start:i_end,k_start+1:k_end+1,j_start:j_end) = a_z_at_w(i_start:i_end,k_start+1:k_end+1,j_start:j_end)&
&+0.5*a_z(i_start:i_end,k_start:k_end,j_start:j_end)
a_z_at_w(i_start:i_end,k_start:k_end,j_start:j_end) = a_z_at_w(i_start:i_end,k_start:k_end,j_start:j_end)&
&+0.5*a_z(i_start:i_end,k_start:k_end,j_start:j_end)
a_z(i_start:i_end,k_start:k_end,j_start:j_end) = 0.

!do j = j_start, j_end
!  do k = k_start, kte
!    do i = i_start, i_end
!      a_ph(i,k,j) = a_ph(i,k,j)+a_z_at_w(i,k,j)/g
!      a_z_at_w(i,k,j) = 0.
!    end do
!  end do
!end do
a_ph(i_start:i_end,k_start:kte,j_start:j_end)=a_ph(i_start:i_end,k_start:kte,j_start:j_end)+a_z_at_w(i_start:i_end,k_start:kte,j_start:j_end)/g
a_z_at_w(i_start:i_end,k_start:kte,j_start:j_end) = 0.
do j = j_start, j_end
  do k = k_start, k_end
    do i = i_start, i_end
      th_phy(i,k,j) = t(i,k,j)+t0
! recompute : th_phy
      p_phy(i,k,j) = p(i,k,j)+pb(i,k,j)
! recompute : p_phy2
      walls(1)=p_phy(i,k,j)/p1000mb
      walls(2)=walls(1)**(rcp-1)
! recompute : pi_phy
      a_pi_phy(i,k,j) = a_pi_phy(i,k,j)+a_t_phy(i,k,j)*th_phy(i,k,j)
      a_th_phy(i,k,j) = a_th_phy(i,k,j)+a_t_phy(i,k,j)*walls(2)*walls(1)
      a_t_phy(i,k,j) = 0.
      a_p_phy(i,k,j) = a_p_phy(i,k,j)+a_pi_phy(i,k,j)/p1000mb*rcp*walls(2)
      a_pi_phy(i,k,j) = 0.
      a_p(i,k,j) = a_p(i,k,j)+a_p_phy(i,k,j)
      a_p_phy(i,k,j) = 0.
      a_t(i,k,j) = a_t(i,k,j)+a_th_phy(i,k,j)
      a_th_phy(i,k,j) = 0.
    end do
  end do
end do

   call trace_exit("a_phy_prep")

end subroutine a_phy_prep


subroutine a_rhs_ph( a_ph_tend, u, a_u, v, a_v, ww, a_ww, ph, a_ph, ph_old, a_ph_old, phb, w, a_w, mut, a_mut, muu, a_muu, muv, &
&a_muv, fnm, fnp, rdnw, cfn, cfn1, rdx, rdy, msft, non_hydrostatic, config_flags, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms,&
& kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: a_mut(ims:ime,jms:jme)
real, intent(inout) :: a_muu(ims:ime,jms:jme)
real, intent(inout) :: a_muv(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_ph(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cfn
real, intent(in) :: cfn1
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: fnm(kms:kme)
real, intent(in) :: fnp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
logical, intent(in) :: non_hydrostatic
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ww(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_ub
real a_vb
real a_wdwn(its:ite,kts:kte)
integer advective_order
integer i
integer i_start
integer itf
integer j
integer j_start
integer jtf
integer k
integer kz
logical specified
real ub
real ul
real ur
real vb
real vl
real vr
real walls(6)

   call trace_entry("a_rhs_ph")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_wdwn(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
advective_order = config_flags%h_sca_adv_order
! recompute : advective_order
itf = min(ite,ide-1)
! recompute : itf
jtf = min(jte,jde-1)
! recompute : jtf
if (config_flags%open_xe .and. ite .eq. ide) then
  i = ite-1
! recompute : i
  do j = jtf, jts, -1
    k = kde
! recompute : k
    kz = k-1
! recompute : kz
    ub = 0.5*(fnm(kz)*(u(i+1,kz,j)+u(i,kz,j))+fnp(kz)*(u(i+1,kz-1,j)+u(i,kz-1,j)))
! recompute : ub
    ur = amax1(ub,0.)
! recompute : ur
    a_mut(i,j) = a_mut(i,j)-a_ph_tend(i,k,j)*rdx*ur*(ph_old(i,k,j)-ph_old(i-1,k,j))
    a_ph_old(i-1,k,j) = a_ph_old(i-1,k,j)+a_ph_tend(i,k,j)*rdx*mut(i,j)*ur
    a_ph_old(i,k,j) = a_ph_old(i,k,j)-a_ph_tend(i,k,j)*rdx*mut(i,j)*ur
    a_ub = 0.5*(-a_ph_tend(i,k,j)*rdx*mut(i,j)*(ph_old(i,k,j)-ph_old(i-1,k,j)))*(0.5+sign(0.5,ub-0.))
    a_u(i+1,kz-1,j) = a_u(i+1,kz-1,j)+a_ub*fnp(kz)
    a_u(i,kz-1,j) = a_u(i,kz-1,j)+a_ub*fnp(kz)
    a_u(i+1,kz,j) = a_u(i+1,kz,j)+a_ub*fnm(kz)
    a_u(i,kz,j) = a_u(i,kz,j)+a_ub*fnm(kz)
    do k = 2, kde-1
      kz = k
! recompute : kz
      ub = 0.5*(fnm(kz)*(u(i+1,kz,j)+u(i,kz,j))+fnp(kz)*(u(i+1,kz-1,j)+u(i,kz-1,j)))
! recompute : ub
      ur = amax1(ub,0.)
! recompute : ur
      a_mut(i,j) = a_mut(i,j)-a_ph_tend(i,k,j)*rdx*ur*(ph_old(i,k,j)-ph_old(i-1,k,j))
      a_ph_old(i-1,k,j) = a_ph_old(i-1,k,j)+a_ph_tend(i,k,j)*rdx*mut(i,j)*ur
      a_ph_old(i,k,j) = a_ph_old(i,k,j)-a_ph_tend(i,k,j)*rdx*mut(i,j)*ur
      a_ub = 0.5*(-a_ph_tend(i,k,j)*rdx*mut(i,j)*(ph_old(i,k,j)-ph_old(i-1,k,j)))*(0.5+sign(0.5,ub-0.))
      a_u(i+1,kz-1,j) = a_u(i+1,kz-1,j)+a_ub*fnp(kz)
      a_u(i,kz-1,j) = a_u(i,kz-1,j)+a_ub*fnp(kz)
      a_u(i+1,kz,j) = a_u(i+1,kz,j)+a_ub*fnm(kz)
      a_u(i,kz,j) = a_u(i,kz,j)+a_ub*fnm(kz)
    end do
  end do
endif
if (config_flags%open_xs .and. its .eq. ids) then
  i = its
! recompute : i
  do j = jtf, jts, -1
    k = kde
! recompute : k
    kz = k
! recompute : kz
    ub = 0.5*(fnm(kz)*(u(i+1,kz,j)+u(i,kz,j))+fnp(kz)*(u(i+1,kz-1,j)+u(i,kz-1,j)))
! recompute : ub
    ul = amin1(ub,0.)
! recompute : ul
    a_mut(i,j) = a_mut(i,j)-a_ph_tend(i,k,j)*rdx*ul*(ph_old(i+1,k,j)-ph_old(i,k,j))
    a_ph_old(i+1,k,j) = a_ph_old(i+1,k,j)-a_ph_tend(i,k,j)*rdx*mut(i,j)*ul
    a_ph_old(i,k,j) = a_ph_old(i,k,j)+a_ph_tend(i,k,j)*rdx*mut(i,j)*ul
    a_ub = 0.5*(-a_ph_tend(i,k,j)*rdx*mut(i,j)*(ph_old(i+1,k,j)-ph_old(i,k,j)))*(0.5+sign(0.5,0.-ub))
    a_u(i+1,kz-1,j) = a_u(i+1,kz-1,j)+a_ub*fnp(kz)
    a_u(i,kz-1,j) = a_u(i,kz-1,j)+a_ub*fnp(kz)
    a_u(i+1,kz,j) = a_u(i+1,kz,j)+a_ub*fnm(kz)
    a_u(i,kz,j) = a_u(i,kz,j)+a_ub*fnm(kz)
    do k = 2, kde-1
      kz = k
! recompute : kz
      ub = 0.5*(fnm(kz)*(u(i+1,kz,j)+u(i,kz,j))+fnp(kz)*(u(i+1,kz-1,j)+u(i,kz-1,j)))
! recompute : ub
      ul = amin1(ub,0.)
! recompute : ul
      a_mut(i,j) = a_mut(i,j)-a_ph_tend(i,k,j)*rdx*ul*(ph_old(i+1,k,j)-ph_old(i,k,j))
      a_ph_old(i+1,k,j) = a_ph_old(i+1,k,j)-a_ph_tend(i,k,j)*rdx*mut(i,j)*ul
      a_ph_old(i,k,j) = a_ph_old(i,k,j)+a_ph_tend(i,k,j)*rdx*mut(i,j)*ul
      a_ub = 0.5*(-a_ph_tend(i,k,j)*rdx*mut(i,j)*(ph_old(i+1,k,j)-ph_old(i,k,j)))*(0.5+sign(0.5,0.-ub))
      a_u(i+1,kz-1,j) = a_u(i+1,kz-1,j)+a_ub*fnp(kz)
      a_u(i,kz-1,j) = a_u(i,kz-1,j)+a_ub*fnp(kz)
      a_u(i+1,kz,j) = a_u(i+1,kz,j)+a_ub*fnm(kz)
      a_u(i,kz,j) = a_u(i,kz,j)+a_ub*fnm(kz)
    end do
  end do
endif
if (config_flags%open_ye .and. jte .eq. jde) then
  j = jte-1
! recompute : j
  do k = 2, kde
    kz = min(k,kde-1)
! recompute : kz
    do i = its, itf
      vb = 0.5*(fnm(kz)*(v(i,kz,j+1)+v(i,kz,j))+fnp(kz)*(v(i,kz-1,j+1)+v(i,kz-1,j)))
! recompute : vb
      vr = amax1(vb,0.)
! recompute : vr
      a_mut(i,j) = a_mut(i,j)-a_ph_tend(i,k,j)*rdy*vr*(ph_old(i,k,j)-ph_old(i,k,j-1))
      a_ph_old(i,k,j-1) = a_ph_old(i,k,j-1)+a_ph_tend(i,k,j)*rdy*mut(i,j)*vr
      a_ph_old(i,k,j) = a_ph_old(i,k,j)-a_ph_tend(i,k,j)*rdy*mut(i,j)*vr
      a_vb = 0.5*(-a_ph_tend(i,k,j)*rdy*mut(i,j)*(ph_old(i,k,j)-ph_old(i,k,j-1)))*(0.5+sign(0.5,vb-0.))
      a_v(i,kz-1,j+1) = a_v(i,kz-1,j+1)+a_vb*fnp(kz)
      a_v(i,kz-1,j) = a_v(i,kz-1,j)+a_vb*fnp(kz)
      a_v(i,kz,j+1) = a_v(i,kz,j+1)+a_vb*fnm(kz)
      a_v(i,kz,j) = a_v(i,kz,j)+a_vb*fnm(kz)
    end do
  end do
endif
if (config_flags%open_ys .and. jts .eq. jds) then
  j = jts
! recompute : j
  do k = 2, kde
    kz = min(k,kde-1)
! recompute : kz
    do i = its, itf
      vb = 0.5*(fnm(kz)*(v(i,kz,j+1)+v(i,kz,j))+fnp(kz)*(v(i,kz-1,j+1)+v(i,kz-1,j)))
! recompute : vb
      vl = amin1(vb,0.)
! recompute : vl
      a_mut(i,j) = a_mut(i,j)-a_ph_tend(i,k,j)*rdy*vl*(ph_old(i,k,j+1)-ph_old(i,k,j))
      a_ph_old(i,k,j+1) = a_ph_old(i,k,j+1)-a_ph_tend(i,k,j)*rdy*mut(i,j)*vl
      a_ph_old(i,k,j) = a_ph_old(i,k,j)+a_ph_tend(i,k,j)*rdy*mut(i,j)*vl
      a_vb = 0.5*(-a_ph_tend(i,k,j)*rdy*mut(i,j)*(ph_old(i,k,j+1)-ph_old(i,k,j)))*(0.5+sign(0.5,0.-vb))
      a_v(i,kz-1,j+1) = a_v(i,kz-1,j+1)+a_vb*fnp(kz)
      a_v(i,kz-1,j) = a_v(i,kz-1,j)+a_vb*fnp(kz)
      a_v(i,kz,j+1) = a_v(i,kz,j+1)+a_vb*fnm(kz)
      a_v(i,kz,j) = a_v(i,kz,j)+a_vb*fnm(kz)
    end do
  end do
endif
if (advective_order .le. 2) then
  i_start = its
! recompute : i_start
  j_start = jts
! recompute : j_start
  itf = min(ite,ide-1)
! recompute : itf
  jtf = min(jte,jde-1)
! recompute : jtf
  if (config_flags%open_xs .and. its .eq. ids) then
    i_start = its+1
  endif
! recompute : i_start
  if (config_flags%open_xe .and. ite .eq. ide) then
    itf = itf-1
  endif
! recompute : itf
  do j = jtf, j_start, -1
    k = kte
! recompute : k
    do i = i_start, itf
      walls(1)=phb(i+1,k,j)-phb(i,k,j)+ph(i+1,k,j)-ph(i,k,j)
      walls(2)=0.5*a_ph_tend(i,k,j)*rdx
      walls(3)=phb(i,k,j)-phb(i-1,k,j)+ph(i,k,j)-ph(i-1,k,j)
      a_muu(i+1,j) = a_muu(i+1,j)-walls(2)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))*walls(1)
      a_muu(i,j) = a_muu(i,j)-walls(2)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j))*walls(3)
      a_ph(i-1,k,j) = a_ph(i-1,k,j)+walls(2)*muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j))
      a_ph(i+1,k,j) = a_ph(i+1,k,j)-walls(2)*muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))
      a_ph(i,k,j) = a_ph(i,k,j)-walls(2)*((-(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))))+muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))
      a_u(i+1,k-2,j) = a_u(i+1,k-2,j)-walls(2)*muu(i+1,j)*cfn1*walls(1)
      a_u(i,k-2,j) = a_u(i,k-2,j)-walls(2)*muu(i,j)*cfn1*walls(3)
      a_u(i+1,k-1,j) = a_u(i+1,k-1,j)-walls(2)*muu(i+1,j)*cfn*walls(1)
      a_u(i,k-1,j) = a_u(i,k-1,j)-walls(2)*muu(i,j)*cfn*walls(3)
    end do
    do k = 2, kte-1
      do i = i_start, itf
        walls(1)=(phb(i+1,k,j)-phb(i,k,j)+ph(i+1,k,j)-ph(i,k,j))
        walls(2)=0.25*a_ph_tend(i,k,j)*rdx
        walls(3)=phb(i,k,j)-phb(i-1,k,j)+ph(i,k,j)-ph(i-1,k,j)
        a_muu(i+1,j) = a_muu(i+1,j)-walls(2)*(u(i+1,k,j)+u(i+1,k-1,j))*walls(1)
        a_muu(i,j) = a_muu(i,j)-walls(2)*(u(i,k,j)+u(i,k-1,j))*walls(3)
        a_ph(i-1,k,j) = a_ph(i-1,k,j)+walls(2)*muu(i,j)*(u(i,k,j)+u(i,k-1,j))
        a_ph(i+1,k,j) = a_ph(i+1,k,j)-walls(2)*muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))
        a_ph(i,k,j) = a_ph(i,k,j)-walls(2)*((-(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))
        a_u(i+1,k-1,j) = a_u(i+1,k-1,j)-walls(2)*muu(i+1,j)*walls(1)
        a_u(i,k-1,j) = a_u(i,k-1,j)-walls(2)*muu(i,j)*walls(3)
        a_u(i+1,k,j) = a_u(i+1,k,j)-walls(2)*muu(i+1,j)*walls(1)
        a_u(i,k,j) = a_u(i,k,j)-walls(2)*muu(i,j)*walls(3)
      end do
    end do
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1407
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,jts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1408
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_start,ide,ite,j_start
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1409
! recompute vars : itf
  itf = min(ite,ide-1)
! recompute vars : itf
! recdepend vars : i_start,itf,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1410
! recompute vars : jtf
  jtf = min(jte,jde-1)
! recompute vars : jtf
! recdepend vars : config_flags,i_start,itf,j_start,jds,jtf,jts
! recompute pos : IF_STMT module_big_step_utilities_em.f90:1412
! recompute vars : j_start
  if (config_flags%open_ys .and. jts .eq. jds) then
    j_start = jts+1
  endif
! recompute vars : j_start
! recdepend vars : config_flags,i_start,itf,j_start,jde,jte,jtf
! recompute pos : IF_STMT module_big_step_utilities_em.f90:1413
! recompute vars : jtf
  if (config_flags%open_ye .and. jte .eq. jde) then
    jtf = jtf-1
  endif
! recompute vars : jtf
  do j = jtf, j_start, -1
    k = kte
! recompute : k
    do i = i_start, itf
      walls(1)=cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1)
      walls(2)=phb(i,k,j)-phb(i,k,j-1)+ph(i,k,j)-ph(i,k,j-1)
      walls(4)=0.5*a_ph_tend(i,k,j)*rdy
      walls(5)=phb(i,k,j+1)-phb(i,k,j)+ph(i,k,j+1)-ph(i,k,j)
      a_muv(i,j+1) = a_muv(i,j+1)-walls(4)*walls(1)*walls(5)
      a_muv(i,j) = a_muv(i,j)-walls(4)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j))*walls(2)
      a_ph(i,k,j-1) = a_ph(i,k,j-1)+walls(4)*muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j))
      a_ph(i,k,j+1) = a_ph(i,k,j+1)-walls(4)*muv(i,j+1)*walls(1)
      a_ph(i,k,j) = a_ph(i,k,j)-walls(4)*((-(muv(i,j+1)*walls(1)))+muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j)))
      a_v(i,k-2,j+1) = a_v(i,k-2,j+1)-walls(4)*muv(i,j+1)*cfn1*walls(5)
      a_v(i,k-2,j) = a_v(i,k-2,j)-walls(4)*muv(i,j)*cfn1*walls(2)
      a_v(i,k-1,j+1) = a_v(i,k-1,j+1)-walls(4)*muv(i,j+1)*cfn*walls(5)
      a_v(i,k-1,j) = a_v(i,k-1,j)-walls(4)*muv(i,j)*cfn*walls(2)
    end do
    do k = 2, kte-1
      do i = i_start, itf
        walls(2)=phb(i,k,j)-phb(i,k,j-1)+ph(i,k,j)-ph(i,k,j-1)
        walls(3) =0.25*a_ph_tend(i,k,j)*rdy
        walls(5)=phb(i,k,j+1)-phb(i,k,j)+ph(i,k,j+1)-ph(i,k,j)
        a_muv(i,j+1) = a_muv(i,j+1)-walls(3)*(v(i,k,j+1)+v(i,k-1,j+1))*walls(5)
        a_muv(i,j) = a_muv(i,j)-walls(3)*(v(i,k,j)+v(i,k-1,j))*walls(2)
        a_ph(i,k,j-1) = a_ph(i,k,j-1)+walls(3)*muv(i,j)*(v(i,k,j)+v(i,k-1,j))
        a_ph(i,k,j+1) = a_ph(i,k,j+1)-walls(3)*muv(i,j+1)*(v(i,k,j+1)+v(i,k-1,j+1))
        a_ph(i,k,j) = a_ph(i,k,j)-walls(3)*((-(muv(i,j+1)*(v(i,k,j+1)+v(i,k-1,j+1))))+muv(i,j)*(v(i,k,j)+v(i,k-1,j)))
        a_v(i,k-1,j+1) = a_v(i,k-1,j+1)-walls(3)*muv(i,j+1)*walls(5)
        a_v(i,k-1,j) = a_v(i,k-1,j)-walls(3)*muv(i,j)*walls(2)
        a_v(i,k,j+1) = a_v(i,k,j+1)-walls(3)*muv(i,j+1)*walls(5)
        a_v(i,k,j) = a_v(i,k,j)-walls(3)*muv(i,j)*walls(2)
      end do
    end do
  end do
else if (advective_order .le. 4) then
  i_start = its
! recompute : i_start
  j_start = jts
! recompute : j_start
  itf = min(ite,ide-1)
! recompute : itf
  jtf = min(jte,jde-1)
! recompute : jtf
  if (config_flags%open_xs .and. its .eq. ids) then
    i_start = its+1
  endif
! recompute : i_start
  if (config_flags%open_xe .and. ite .eq. ide) then
    itf = itf-1
  endif
! recompute : itf
  do j = jtf, j_start, -1
    k = kte
! recompute : k
    do i = i_start, itf
      walls(1)=8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j))
      walls(2)=0.5*a_ph_tend(i,k,j)*rdx
      walls(3)=walls(2)*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))
      a_muu(i+1,j) = a_muu(i+1,j)-0.083333333*walls(2)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))*walls(1)
      a_muu(i,j) = a_muu(i,j)-0.083333333*walls(2)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j))*walls(1)
      a_ph(i-2,k,j) = a_ph(i-2,k,j)-0.083333333*walls(3)
      a_ph(i-1,k,j) = a_ph(i-1,k,j)-(-0.66666667)*walls(3)
      a_ph(i+2,k,j) = a_ph(i+2,k,j)-(-0.083333333)*walls(3)
      a_ph(i+1,k,j) = a_ph(i+1,k,j)-0.66666667*walls(3)
      a_u(i+1,k-2,j) = a_u(i+1,k-2,j)-0.083333333*walls(2)*muu(i+1,j)*cfn1*walls(1)
      a_u(i,k-2,j) = a_u(i,k-2,j)-0.083333333*walls(2)*muu(i,j)*cfn1*walls(1)
      a_u(i+1,k-1,j) = a_u(i+1,k-1,j)-0.083333333*walls(2)*muu(i+1,j)*cfn*walls(1)
      a_u(i,k-1,j) = a_u(i,k-1,j)-0.083333333*walls(2)*muu(i,j)*cfn*walls(1)
    end do
    do k = 2, kte-1
      do i = i_start, itf
        walls(2)=0.25*a_ph_tend(i,k,j)*rdx
        walls(3)=walls(2)*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))
        a_muu(i+1,j) = a_muu(i+1,j)-0.083333333*walls(2)*(u(i+1,k,j)+u(i+1,k-1,j))*walls(1)
        a_muu(i,j) = a_muu(i,j)-0.083333333*walls(2)*(u(i,k,j)+u(i,k-1,j))*walls(1)
        a_ph(i-2,k,j) = a_ph(i-2,k,j)-0.083333333*walls(3)
        a_ph(i-1,k,j) = a_ph(i-1,k,j)-(-0.66666667)*walls(3)
        a_ph(i+2,k,j) = a_ph(i+2,k,j)-(-0.083333333)*walls(3)
        a_ph(i+1,k,j) = a_ph(i+1,k,j)-0.66666667*walls(3)
        a_u(i+1,k-1,j) = a_u(i+1,k-1,j)-0.083333333*walls(2)*muu(i+1,j)*walls(1)
        a_u(i,k-1,j) = a_u(i,k-1,j)-0.083333333*walls(2)*muu(i,j)*walls(1)
        a_u(i+1,k,j) = a_u(i+1,k,j)-0.083333333*walls(2)*muu(i+1,j)*walls(1)
        a_u(i,k,j) = a_u(i,k,j)-0.083333333*walls(2)*muu(i,j)*walls(1)
      end do
    end do
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1475
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,jts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1476
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_start,ide,ite,j_start
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1477
! recompute vars : itf
  itf = min(ite,ide-1)
! recompute vars : itf
! recdepend vars : i_start,itf,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1478
! recompute vars : jtf
  jtf = min(jte,jde-1)
! recompute vars : jtf
! recdepend vars : config_flags,i_start,itf,j_start,jds,jtf,jts
! recompute pos : IF_STMT module_big_step_utilities_em.f90:1480
! recompute vars : j_start
  if (config_flags%open_ys .and. jts .eq. jds) then
    j_start = jts+1
  endif
! recompute vars : j_start
! recdepend vars : config_flags,i_start,itf,j_start,jde,jte,jtf
! recompute pos : IF_STMT module_big_step_utilities_em.f90:1481
! recompute vars : jtf
  if (config_flags%open_ye .and. jte .eq. jde) then
    jtf = jtf-1
  endif
! recompute vars : jtf
  do j = jtf, j_start, -1
    k = kte
! recompute : k
    do i = i_start, itf
      walls(1)=cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1)
      walls(2)=8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2))
      walls(4)=0.5*a_ph_tend(i,k,j)*rdy
      walls(3)=walls(4)*(muv(i,j+1)*walls(1)+muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j)))
      a_muv(i,j+1) = a_muv(i,j+1)-0.083333333*walls(4)*walls(1)*walls(2)
      a_muv(i,j) = a_muv(i,j)-0.083333333*walls(4)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j))*walls(2)
      a_ph(i,k,j-2) = a_ph(i,k,j-2)-0.083333333*walls(3)
      a_ph(i,k,j-1) = a_ph(i,k,j-1)-(-0.66666667)*walls(3)
      a_ph(i,k,j+2) = a_ph(i,k,j+2)-(-0.083333333)*walls(3)
      a_ph(i,k,j+1) = a_ph(i,k,j+1)-0.66666667*walls(3)
      a_v(i,k-2,j+1) = a_v(i,k-2,j+1)-0.083333333*walls(4)*muv(i,j+1)*cfn1*walls(2)
      a_v(i,k-2,j) = a_v(i,k-2,j)-0.083333333*walls(4)*muv(i,j)*cfn1*walls(2)
      a_v(i,k-1,j+1) = a_v(i,k-1,j+1)-0.083333333*walls(4)*muv(i,j+1)*cfn*walls(2)
      a_v(i,k-1,j) = a_v(i,k-1,j)-0.083333333*walls(4)*muv(i,j)*cfn*walls(2)
    end do
    do k = 2, kte-1
      do i = i_start, itf
        walls(3) =0.25*a_ph_tend(i,k,j)*rdy
        walls(1)=walls(3)*(muv(i,j+1)*(v(i,k,j+1)+v(i,k-1,j+1))+muv(i,j)*(v(i,k,j)+v(i,k-1,j)))
        a_muv(i,j+1) = a_muv(i,j+1)-0.083333333*walls(3)*(v(i,k,j+1)+v(i,k-1,j+1))*walls(2)
        a_muv(i,j) = a_muv(i,j)-0.083333333*walls(3)*(v(i,k,j)+v(i,k-1,j))*walls(2)
        a_ph(i,k,j-2) = a_ph(i,k,j-2)-0.083333333*walls(1)
        a_ph(i,k,j-1) = a_ph(i,k,j-1)-(-0.66666667)*walls(1)
        a_ph(i,k,j+2) = a_ph(i,k,j+2)-(-0.083333333)*walls(1)
        a_ph(i,k,j+1) = a_ph(i,k,j+1)-0.66666667*walls(1)
        a_v(i,k-1,j+1) = a_v(i,k-1,j+1)-0.083333333*walls(3)*muv(i,j+1)*walls(2)
        a_v(i,k-1,j) = a_v(i,k-1,j)-0.083333333*walls(3)*muv(i,j)*walls(2)
        a_v(i,k,j+1) = a_v(i,k,j+1)-0.083333333*walls(3)*muv(i,j+1)*walls(2)
        a_v(i,k,j) = a_v(i,k,j)-0.083333333*walls(3)*muv(i,j)*walls(2)
      end do
    end do
  end do
else if (advective_order .le. 6) then
  i_start = its
! recompute : i_start
  j_start = jts
! recompute : j_start
  itf = min(ite,ide-1)
! recompute : itf
  jtf = min(jte,jde-1)
! recompute : jtf
  if (config_flags%open_xs .or. specified) then
    i_start = max(its,ids+2)
  endif
! recompute : i_start
  if (config_flags%open_xe .or. specified) then
    itf = min(itf,ide-3)
  endif
! recompute : itf
  if (config_flags%open_xe .and. ite .ge. ide-2) then
    i = ide-2
! recompute : i
    do j = jtf, j_start, -1
      k = kte
! recompute : k
      walls(1)=8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j))
      walls(2)=0.5*a_ph_tend(i,k,j)*rdx
      walls(3)=walls(2)*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))
      a_muu(i+1,j) = a_muu(i+1,j)-0.083333333*walls(2)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))*walls(1)
      a_muu(i,j) = a_muu(i,j)-0.083333333*walls(2)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j))*walls(1)
      a_ph(i-2,k,j) = a_ph(i-2,k,j)-0.083333333*walls(3)
      a_ph(i-1,k,j) = a_ph(i-1,k,j)-(-0.66666667)*walls(3)
      a_ph(i+2,k,j) = a_ph(i+2,k,j)-(-0.083333333)*walls(3)
      a_ph(i+1,k,j) = a_ph(i+1,k,j)-0.66666667*walls(3)
      a_u(i+1,k-2,j) = a_u(i+1,k-2,j)-0.083333333*walls(2)*muu(i+1,j)*cfn1*walls(1)
      a_u(i,k-2,j) = a_u(i,k-2,j)-0.083333333*walls(2)*muu(i,j)*cfn1*walls(1)
      a_u(i+1,k-1,j) = a_u(i+1,k-1,j)-0.083333333*walls(2)*muu(i+1,j)*cfn*walls(1)
      a_u(i,k-1,j) = a_u(i,k-1,j)-0.083333333*walls(2)*muu(i,j)*cfn*walls(1)
      do k = 2, kte-1
        walls(2)=0.25*a_ph_tend(i,k,j)*rdx
        walls(3)=walls(2)*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))
        a_muu(i+1,j) = a_muu(i+1,j)-0.083333333*walls(2)*(u(i+1,k,j)+u(i+1,k-1,j))*walls(1)
        a_muu(i,j) = a_muu(i,j)-0.083333333*walls(2)*(u(i,k,j)+u(i,k-1,j))*walls(1)
        a_ph(i-2,k,j) = a_ph(i-2,k,j)-0.083333333*walls(3)
        a_ph(i-1,k,j) = a_ph(i-1,k,j)-(-0.66666667)*walls(3)
        a_ph(i+2,k,j) = a_ph(i+2,k,j)-(-0.083333333)*walls(3)
        a_ph(i+1,k,j) = a_ph(i+1,k,j)-0.66666667*walls(3)
        a_u(i+1,k-1,j) = a_u(i+1,k-1,j)-0.083333333*walls(2)*muu(i+1,j)*walls(1)
        a_u(i,k-1,j) = a_u(i,k-1,j)-0.083333333*walls(2)*muu(i,j)*walls(1)
        a_u(i+1,k,j) = a_u(i+1,k,j)-0.083333333*walls(2)*muu(i+1,j)*walls(1)
        a_u(i,k,j) = a_u(i,k,j)-0.083333333*walls(2)*muu(i,j)*walls(1)
      end do
    end do
  endif
  if (config_flags%open_xs .and. its .le. ids+1) then
    i = ids+1
! recompute : i
    do j = jtf, j_start, -1
      k = kte
! recompute : k
      walls(1)=8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j))
      walls(2)=0.5*a_ph_tend(i,k,j)*rdx
      walls(3)=walls(2)*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))
      a_muu(i+1,j) = a_muu(i+1,j)-0.083333333*walls(2)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))*walls(1)
      a_muu(i,j) = a_muu(i,j)-0.083333333*walls(2)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j))*walls(1)
      a_ph(i-2,k,j) = a_ph(i-2,k,j)-0.083333333*walls(3)
      a_ph(i-1,k,j) = a_ph(i-1,k,j)-(-0.66666667)*walls(3)
      a_ph(i+2,k,j) = a_ph(i+2,k,j)-(-0.083333333)*walls(3)
      a_ph(i+1,k,j) = a_ph(i+1,k,j)-0.66666667*walls(3)
      a_u(i+1,k-2,j) = a_u(i+1,k-2,j)-0.083333333*walls(2)*muu(i+1,j)*cfn1*walls(1)
      a_u(i,k-2,j) = a_u(i,k-2,j)-0.083333333*walls(2)*muu(i,j)*cfn1*walls(1)
      a_u(i+1,k-1,j) = a_u(i+1,k-1,j)-0.083333333*walls(2)*muu(i+1,j)*cfn*walls(1)
      a_u(i,k-1,j) = a_u(i,k-1,j)-0.083333333*walls(2)*muu(i,j)*cfn*walls(1)
      do k = 2, kte-1
        walls(2)=0.25*a_ph_tend(i,k,j)*rdx
        walls(3)=walls(2)*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))
        a_muu(i+1,j) = a_muu(i+1,j)-0.083333333*walls(2)*(u(i+1,k,j)+u(i+1,k-1,j))*walls(1)
        a_muu(i,j) = a_muu(i,j)-0.083333333*walls(2)*(u(i,k,j)+u(i,k-1,j))*walls(1)
        a_ph(i-2,k,j) = a_ph(i-2,k,j)-0.083333333*walls(3)
        a_ph(i-1,k,j) = a_ph(i-1,k,j)-(-0.66666667)*walls(3)
        a_ph(i+2,k,j) = a_ph(i+2,k,j)-(-0.083333333)*walls(3)
        a_ph(i+1,k,j) = a_ph(i+1,k,j)-0.66666667*walls(3)
        a_u(i+1,k-1,j) = a_u(i+1,k-1,j)-0.083333333*walls(2)*muu(i+1,j)*walls(1)
        a_u(i,k-1,j) = a_u(i,k-1,j)-0.083333333*walls(2)*muu(i,j)*walls(1)
        a_u(i+1,k,j) = a_u(i+1,k,j)-0.083333333*walls(2)*muu(i+1,j)*walls(1)
        a_u(i,k,j) = a_u(i,k,j)-0.083333333*walls(2)*muu(i,j)*walls(1)
      end do
    end do
  endif
  do j = jtf, j_start, -1
    k = kte
! recompute : k
    do i = i_start, itf
      walls(1)=45.*(ph(i+1,k,j)-ph(i-1,k,j))-9.*(ph(i+2,k,j)-ph(i-2,k,j))+ph(i+3,k,j)-ph(i-3,k,j)+45.*(phb(i+1,k,j)-phb(i-1,k,j))-9.*(phb(i+2,k,j)-phb(i-2,k,j))+phb(i+3,k,j)-phb(i-3,k,j)
      walls(2)=0.5*a_ph_tend(i,k,j)*rdx
      walls(3)=walls(2)*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))
      a_muu(i+1,j) = a_muu(i+1,j)-0.016666667*walls(2)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))*walls(1)
      a_muu(i,j) = a_muu(i,j)-0.016666667*walls(2)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j))*walls(1)
      a_ph(i-3,k,j) = a_ph(i-3,k,j)-(-0.016666667)*walls(3)
      a_ph(i-2,k,j) = a_ph(i-2,k,j)-0.15*walls(3)
      a_ph(i-1,k,j) = a_ph(i-1,k,j)-(-0.75)*walls(3)
      a_ph(i+3,k,j) = a_ph(i+3,k,j)-0.016666667*walls(3)
      a_ph(i+2,k,j) = a_ph(i+2,k,j)-(-0.15)*walls(3)
      a_ph(i+1,k,j) = a_ph(i+1,k,j)-0.75*walls(3)
      a_u(i+1,k-2,j) = a_u(i+1,k-2,j)-0.016666667*walls(2)*muu(i+1,j)*cfn1*walls(1)
      a_u(i,k-2,j) = a_u(i,k-2,j)-0.016666667*walls(2)*muu(i,j)*cfn1*walls(1)
      a_u(i+1,k-1,j) = a_u(i+1,k-1,j)-0.016666667*walls(2)*muu(i+1,j)*cfn*walls(1)
      a_u(i,k-1,j) = a_u(i,k-1,j)-0.016666667*walls(2)*muu(i,j)*cfn*walls(1)
    end do
    do k = 2, kte-1
      do i = i_start, itf
      walls(1)=45.*(ph(i+1,k,j)-ph(i-1,k,j))-9.*(ph(i+2,k,j)-ph(i-2,k,j))+ph(i+3,k,j)-ph(i-3,k,j)+45.*(phb(i+1,k,j)-phb(i-1,k,j))-9.*(phb(i+2,k,j)-phb(i-2,k,j))+phb(i+3,k,j)-phb(i-3,k,j)
      walls(2)=0.25*a_ph_tend(i,k,j)*rdx
      walls(3)=walls(2)*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))
        a_muu(i+1,j) = a_muu(i+1,j)-0.016666667*walls(2)*(u(i+1,k,j)+u(i+1,k-1,j))*walls(1)
        a_muu(i,j) = a_muu(i,j)-0.016666667*walls(2)*(u(i,k,j)+u(i,k-1,j))*walls(1)
        a_ph(i-3,k,j) = a_ph(i-3,k,j)-(-0.016666667)*walls(3)
        a_ph(i-2,k,j) = a_ph(i-2,k,j)-0.15*walls(3)
        a_ph(i-1,k,j) = a_ph(i-1,k,j)-(-0.75)*walls(3)
        a_ph(i+3,k,j) = a_ph(i+3,k,j)-0.016666667*walls(3)
        a_ph(i+2,k,j) = a_ph(i+2,k,j)-(-0.15)*walls(3)
        a_ph(i+1,k,j) = a_ph(i+1,k,j)-0.75*walls(3)
        a_u(i+1,k-1,j) = a_u(i+1,k-1,j)-0.016666667*walls(2)*muu(i+1,j)*walls(1)
        a_u(i,k-1,j) = a_u(i,k-1,j)-0.016666667*walls(2)*muu(i,j)*walls(1)
        a_u(i+1,k,j) = a_u(i+1,k,j)-0.016666667*walls(2)*muu(i+1,j)*walls(1)
        a_u(i,k,j) = a_u(i,k,j)-0.016666667*walls(2)*muu(i,j)*walls(1)
      end do
    end do
  end do
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1555
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1557
! recompute vars : itf
  itf = min(ite,ide-1)
! recompute vars : itf
  if (config_flags%open_ye .and. jte .ge. jde-2) then
    j = jde-2
! recompute : j
    k = kte
! recompute : k
    do i = i_start, itf
      walls(1)=cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1)
      walls(2)=8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2))
      walls(4)=0.5*a_ph_tend(i,k,j)*rdy
      walls(3)=walls(4)*(muv(i,j+1)*walls(1)+muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j)))
      a_muv(i,j+1) = a_muv(i,j+1)-0.083333333*walls(4)*walls(1)*walls(2)
      a_muv(i,j) = a_muv(i,j)-0.083333333*walls(4)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j))*walls(2)
      a_ph(i,k,j-2) = a_ph(i,k,j-2)-0.083333333*walls(3)
      a_ph(i,k,j-1) = a_ph(i,k,j-1)-(-0.66666667)*walls(3)
      a_ph(i,k,j+2) = a_ph(i,k,j+2)-(-0.083333333)*walls(3)
      a_ph(i,k,j+1) = a_ph(i,k,j+1)-0.66666667*walls(3)
      a_v(i,k-2,j+1) = a_v(i,k-2,j+1)-0.083333333*walls(4)*muv(i,j+1)*cfn1*walls(2)
      a_v(i,k-2,j) = a_v(i,k-2,j)-0.083333333*walls(4)*muv(i,j)*cfn1*walls(2)
      a_v(i,k-1,j+1) = a_v(i,k-1,j+1)-0.083333333*walls(4)*muv(i,j+1)*cfn*walls(2)
      a_v(i,k-1,j) = a_v(i,k-1,j)-0.083333333*walls(4)*muv(i,j)*cfn*walls(2)
    end do
    do k = 2, kte-1
      do i = i_start, itf
        walls(3) =0.25*a_ph_tend(i,k,j)*rdy
        walls(1)=walls(3)*(muv(i,j+1)*(v(i,k,j+1)+v(i,k-1,j+1))+muv(i,j)*(v(i,k,j)+v(i,k-1,j)))
        a_muv(i,j+1) = a_muv(i,j+1)-0.083333333*walls(3)*(v(i,k,j+1)+v(i,k-1,j+1))*walls(2)
        a_muv(i,j) = a_muv(i,j)-0.083333333*walls(3)*(v(i,k,j)+v(i,k-1,j))*walls(2)
        a_ph(i,k,j-2) = a_ph(i,k,j-2)-0.083333333*walls(1)
        a_ph(i,k,j-1) = a_ph(i,k,j-1)-(-0.66666667)*walls(1)
        a_ph(i,k,j+2) = a_ph(i,k,j+2)-(-0.083333333)*walls(1)
        a_ph(i,k,j+1) = a_ph(i,k,j+1)-0.66666667*walls(1)
        a_v(i,k-1,j+1) = a_v(i,k-1,j+1)-0.083333333*walls(3)*muv(i,j+1)*walls(2)
        a_v(i,k-1,j) = a_v(i,k-1,j)-0.083333333*walls(3)*muv(i,j)*walls(2)
        a_v(i,k,j+1) = a_v(i,k,j+1)-0.083333333*walls(3)*muv(i,j+1)*walls(2)
        a_v(i,k,j) = a_v(i,k,j)-0.083333333*walls(3)*muv(i,j)*walls(2)
      end do
    end do
  endif
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1555
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,ide,ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1557
! recompute vars : itf
  itf = min(ite,ide-1)
! recompute vars : itf
  if (config_flags%open_ys .and. jts .le. jds+1) then
    j = jds+1
! recompute : j
    k = kte
! recompute : k
    do i = i_start, itf
      walls(1)=cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1)
      walls(2)=8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2))
      walls(4)=0.5*a_ph_tend(i,k,j)*rdy
      walls(3)=walls(4)*(muv(i,j+1)*walls(1)+muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j)))
      a_muv(i,j+1) = a_muv(i,j+1)-0.083333333*walls(4)*walls(1)*walls(2)
      a_muv(i,j) = a_muv(i,j)-0.083333333*walls(4)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j))*walls(2)
      a_ph(i,k,j-2) = a_ph(i,k,j-2)-0.083333333*walls(3)
      a_ph(i,k,j-1) = a_ph(i,k,j-1)-(-0.66666667)*walls(3)
      a_ph(i,k,j+2) = a_ph(i,k,j+2)-(-0.083333333)*walls(3)
      a_ph(i,k,j+1) = a_ph(i,k,j+1)-0.66666667*walls(3)
      a_v(i,k-2,j+1) = a_v(i,k-2,j+1)-0.083333333*walls(4)*muv(i,j+1)*cfn1*walls(2)
      a_v(i,k-2,j) = a_v(i,k-2,j)-0.083333333*walls(4)*muv(i,j)*cfn1*walls(2)
      a_v(i,k-1,j+1) = a_v(i,k-1,j+1)-0.083333333*walls(4)*muv(i,j+1)*cfn*walls(2)
      a_v(i,k-1,j) = a_v(i,k-1,j)-0.083333333*walls(4)*muv(i,j)*cfn*walls(2)
    end do
    do k = 2, kte-1
      do i = i_start, itf
        walls(3) =0.25*a_ph_tend(i,k,j)*rdy
        walls(1)=walls(3)*(muv(i,j+1)*(v(i,k,j+1)+v(i,k-1,j+1))+muv(i,j)*(v(i,k,j)+v(i,k-1,j)))
        a_muv(i,j+1) = a_muv(i,j+1)-0.083333333*walls(3)*(v(i,k,j+1)+v(i,k-1,j+1))*walls(2)
        a_muv(i,j) = a_muv(i,j)-0.083333333*walls(3)*(v(i,k,j)+v(i,k-1,j))*walls(2)
        a_ph(i,k,j-2) = a_ph(i,k,j-2)-0.083333333*walls(1)
        a_ph(i,k,j-1) = a_ph(i,k,j-1)-(-0.66666667)*walls(1)
        a_ph(i,k,j+2) = a_ph(i,k,j+2)-(-0.083333333)*walls(1)
        a_ph(i,k,j+1) = a_ph(i,k,j+1)-0.66666667*walls(1)
        a_v(i,k-1,j+1) = a_v(i,k-1,j+1)-0.083333333*walls(3)*muv(i,j+1)*walls(2)
        a_v(i,k-1,j) = a_v(i,k-1,j)-0.083333333*walls(3)*muv(i,j)*walls(2)
        a_v(i,k,j+1) = a_v(i,k,j+1)-0.083333333*walls(3)*muv(i,j+1)*walls(2)
        a_v(i,k,j) = a_v(i,k,j)-0.083333333*walls(3)*muv(i,j)*walls(2)
      end do
    end do
  endif
! recdepend vars : its
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1555
! recompute vars : i_start
  i_start = its
! recompute vars : i_start
! recdepend vars : i_start,jts
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1556
! recompute vars : j_start
  j_start = jts
! recompute vars : j_start
! recdepend vars : i_start,ide,ite,j_start
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1557
! recompute vars : itf
  itf = min(ite,ide-1)
! recompute vars : itf
! recdepend vars : i_start,itf,j_start,jde,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1558
! recompute vars : jtf
  jtf = min(jte,jde-1)
! recompute vars : jtf
!  recdepend vars : config_flags,i_start,itf,j_start,jds,jtf,jts,specifi
! ed
! recompute pos : IF_STMT module_big_step_utilities_em.f90:1563
! recompute vars : j_start
  if (config_flags%open_ys .or. specified) then
    j_start = max(jts,jds+2)
  endif
! recompute vars : j_start
! recdepend vars : config_flags,i_start,itf,j_start,jde,jtf,specified
! recompute pos : IF_STMT module_big_step_utilities_em.f90:1564
! recompute vars : jtf
  if (config_flags%open_ye .or. specified) then
    jtf = min(jtf,jde-3)
  endif

! recompute vars : jtf
  do j = jtf, j_start, -1

    k = kte
! recompute : k
    do i = i_start, itf
      walls(1)=cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1)
      walls(2)=45.*(ph(i,k,j+1)-ph(i,k,j-1))-9.*(ph(i,k,j+2)-ph(i,k,j-2))+ph(i,k,j+3)-ph(i,k,j-3)+45.*(phb(i,k,j+1)-phb(i,k,j-1))-9.*(phb(i,k,j+2)-phb(i,k,j-2))+phb(i,k,j+3)-phb(i,k,j-3)
      walls(4)=0.5*a_ph_tend(i,k,j)*rdy
      walls(3)=walls(4)*(muv(i,j+1)*walls(1)+muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j)))
      a_muv(i,j+1) = a_muv(i,j+1)-0.016666667*walls(4)*walls(1)*walls(2)
      a_muv(i,j) = a_muv(i,j)-0.016666667*walls(4)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j))*walls(2)
      a_ph(i,k,j-3) = a_ph(i,k,j-3)-(-0.016666667)*walls(3)
      a_ph(i,k,j-2) = a_ph(i,k,j-2)-0.15*walls(3)
      a_ph(i,k,j-1) = a_ph(i,k,j-1)-(-0.75)*walls(3)
      a_ph(i,k,j+3) = a_ph(i,k,j+3)-0.016666667*walls(3)
      a_ph(i,k,j+2) = a_ph(i,k,j+2)-(-0.15)*walls(3)
      a_ph(i,k,j+1) = a_ph(i,k,j+1)-0.75*walls(3)
      a_v(i,k-2,j+1) = a_v(i,k-2,j+1)-0.016666667*walls(4)*muv(i,j+1)*cfn1*walls(2)
      a_v(i,k-2,j) = a_v(i,k-2,j)-0.016666667*walls(4)*muv(i,j)*cfn1*walls(2)
      a_v(i,k-1,j+1) = a_v(i,k-1,j+1)-0.016666667*walls(4)*muv(i,j+1)*cfn*walls(2)
      a_v(i,k-1,j) = a_v(i,k-1,j)-0.016666667*walls(4)*muv(i,j)*cfn*walls(2)
    end do
    do k = 2, kte-1
      do i = i_start, itf
      walls(2)=45.*(ph(i,k,j+1)-ph(i,k,j-1))-9.*(ph(i,k,j+2)-ph(i,k,j-2))+ph(i,k,j+3)-ph(i,k,j-3)+45.*(phb(i,k,j+1)-phb(i,k,j-1))-9.*(phb(i,k,j+2)-phb(i,k,j-2))+phb(i,k,j+3)-phb(i,k,j-3)
        walls(3) =0.25*a_ph_tend(i,k,j)*rdy
        walls(1)=walls(3)*(muv(i,j+1)*(v(i,k,j+1)+v(i,k-1,j+1))+muv(i,j)*(v(i,k,j)+v(i,k-1,j)))
        a_muv(i,j+1) = a_muv(i,j+1)-0.016666667*walls(3)*(v(i,k,j+1)+v(i,k-1,j+1))*walls(2)
        a_muv(i,j) = a_muv(i,j)-0.016666667*walls(3)*(v(i,k,j)+v(i,k-1,j))*walls(2)
        a_ph(i,k,j-3) = a_ph(i,k,j-3)-(-0.016666667)*walls(1)
        a_ph(i,k,j-2) = a_ph(i,k,j-2)-0.15*walls(1)
        a_ph(i,k,j-1) = a_ph(i,k,j-1)-(-0.75)*walls(1)
        a_ph(i,k,j+3) = a_ph(i,k,j+3)-0.016666667*walls(1)
        a_ph(i,k,j+2) = a_ph(i,k,j+2)-(-0.15)*walls(1)
        a_ph(i,k,j+1) = a_ph(i,k,j+1)-0.75*walls(1)
        a_v(i,k-1,j+1) = a_v(i,k-1,j+1)-0.016666667*walls(3)*muv(i,j+1)*walls(2)
        a_v(i,k-1,j) = a_v(i,k-1,j)-0.016666667*walls(3)*muv(i,j)*walls(2)
        a_v(i,k,j+1) = a_v(i,k,j+1)-0.016666667*walls(3)*muv(i,j+1)*walls(2)
        a_v(i,k,j) = a_v(i,k,j)-0.016666667*walls(3)*muv(i,j)*walls(2)
      end do
    end do

  end do
endif
! recdepend vars : ide,ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1362
! recompute vars : itf
itf = min(ite,ide-1)
! recompute vars : itf
! recdepend vars : itf,jde,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1363
! recompute vars : jtf
jtf = min(jte,jde-1)
! recompute vars : jtf
if (non_hydrostatic) then
  do j = jts, jtf
    do k = 2, kte
      do i = its, itf
        a_mut(i,j) = a_mut(i,j)+a_ph_tend(i,k,j)*(g*w(i,k,j)/msft(i,j))
        a_w(i,k,j) = a_w(i,k,j)+a_ph_tend(i,k,j)*(mut(i,j)*g/msft(i,j))
      end do
    end do
    a_ph_tend(its:itf,kde,j) = 0.
  end do
endif
! recdepend vars : ide,ite
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1362
! recompute vars : itf
itf = min(ite,ide-1)
! recompute vars : itf
! recdepend vars : itf,jde,jte
! recompute pos : ASSIGN_STMT module_big_step_utilities_em.f90:1363
! recompute vars : jtf
jtf = min(jte,jde-1)
! recompute vars : jtf
do j = jts, jtf
  do k = 2, kte-1
!   do i = its, itf
!     a_wdwn(i,k+1) = a_wdwn(i,k+1)-a_ph_tend(i,k,j)*fnm(k)
!     a_wdwn(i,k) = a_wdwn(i,k)-a_ph_tend(i,k,j)*fnp(k)
!   end do
    a_wdwn(its:itf,k+1) = a_wdwn(its:itf,k+1)-a_ph_tend(its:itf,k,j)*fnm(k)
    a_wdwn(its:itf,k) = a_wdwn(its:itf,k)-a_ph_tend(its:itf,k,j)*fnp(k)
  end do
  do k = 2, kte
    do i = its, itf
      a_ph(i,k-1,j) = a_ph(i,k-1,j)-0.5*a_wdwn(i,k)*(ww(i,k,j)+ww(i,k-1,j))*rdnw(k-1)
      a_ph(i,k,j) = a_ph(i,k,j)+0.5*a_wdwn(i,k)*(ww(i,k,j)+ww(i,k-1,j))*rdnw(k-1)
      a_ww(i,k-1,j) = a_ww(i,k-1,j)+0.5*a_wdwn(i,k)*rdnw(k-1)*(ph(i,k,j)-ph(i,k-1,j)+phb(i,k,j)-phb(i,k-1,j))
      a_ww(i,k,j) = a_ww(i,k,j)+0.5*a_wdwn(i,k)*rdnw(k-1)*(ph(i,k,j)-ph(i,k-1,j)+phb(i,k,j)-phb(i,k-1,j))
    end do
  end do
  a_wdwn(its:itf,2:kte) = 0.
end do

   call trace_exit("a_rhs_ph")

end subroutine a_rhs_ph


subroutine a_vertical_diffusion( name, field, a_field, a_tendency, alt, a_alt, mut, a_mut, rdn, rdnw, kvdif, ide, jde, kde, ims, &
&ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_alt(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_field(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_mut(ims:ime,jms:jme)
real, intent(inout) :: a_tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
real, intent(in) :: mut(ims:ime,jms:jme)
character*(1), intent(in) :: name
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)

!==============================================
! declare local variables
!==============================================
real a_vflux(its:ite,0:kte+1)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real vflux(its:ite,0:kte+1)

   call trace_entry("a_vertical_diffusion")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_vflux(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
ktf = min(kte,kde-1)
! recompute : ktf
if (name .eq. 'w') then
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  do j = j_start, j_end
    do k = kts, ktf-1
      do i = i_start, i_end
        vflux(i,k) = kvdif/alt(i,k,j)*rdnw(k)*(field(i,k+1,j)-field(i,k,j))
      end do
    end do
    do i = i_start, i_end
      vflux(i,ktf) = 0.
    end do
! recompute : vflux
    do k = kts+1, ktf
      do i = i_start, i_end
        a_alt(i,k-1,j) = a_alt(i,k-1,j)-a_tendency(i,k,j)*0.5*(rdn(k)*g*g/mut(i,j))/(0.5*0.5*(alt(i,k,j)+alt(i,k-1,j))*(alt(i,k,j)+&
&alt(i,k-1,j)))*(vflux(i,k)-vflux(i,k-1))
        a_alt(i,k,j) = a_alt(i,k,j)-a_tendency(i,k,j)*0.5*(rdn(k)*g*g/mut(i,j))/(0.5*0.5*(alt(i,k,j)+alt(i,k-1,j))*(alt(i,k,j)+&
&alt(i,k-1,j)))*(vflux(i,k)-vflux(i,k-1))
        a_mut(i,j) = a_mut(i,j)-a_tendency(i,k,j)*rdn(k)*g*g/(mut(i,j)*mut(i,j))/(0.5*(alt(i,k,j)+alt(i,k-1,j)))*(vflux(i,k)-&
&vflux(i,k-1))
        a_vflux(i,k-1) = a_vflux(i,k-1)-a_tendency(i,k,j)*(rdn(k)*g*g/mut(i,j)/(0.5*(alt(i,k,j)+alt(i,k-1,j))))
        a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*(rdn(k)*g*g/mut(i,j)/(0.5*(alt(i,k,j)+alt(i,k-1,j))))
      end do
    end do
    do i = i_start, i_end
      a_vflux(i,ktf) = 0.
    end do
    do k = kts, ktf-1
      do i = i_start, i_end
        a_alt(i,k,j) = a_alt(i,k,j)-a_vflux(i,k)*kvdif/(alt(i,k,j)*alt(i,k,j))*rdnw(k)*(field(i,k+1,j)-field(i,k,j))
        a_field(i,k+1,j) = a_field(i,k+1,j)+a_vflux(i,k)*kvdif/alt(i,k,j)*rdnw(k)
        a_field(i,k,j) = a_field(i,k,j)-a_vflux(i,k)*kvdif/alt(i,k,j)*rdnw(k)
        a_vflux(i,k) = 0.
      end do
    end do
  end do
else if (name .eq. 'm') then
  i_start = its
! recompute : i_start
  i_end = min(ite,ide-1)
! recompute : i_end
  j_start = jts
! recompute : j_start
  j_end = min(jte,jde-1)
! recompute : j_end
  do j = j_start, j_end
    do k = kts, ktf-1
      do i = i_start, i_end
        vflux(i,k) = kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j)))*(field(i,k+1,j)-field(i,k,j))
      end do
    end do
! recompute : vflux
    do i = i_start, i_end
      vflux(i,0) = vflux(i,1)
    end do
    do i = i_start, i_end
      vflux(i,ktf) = 0.
    end do
! recompute : vflux
    do k = kts, ktf
      do i = i_start, i_end
        a_alt(i,k,j) = a_alt(i,k,j)-a_tendency(i,k,j)*g*g/mut(i,j)/(alt(i,k,j)*alt(i,k,j))*rdnw(k)*(vflux(i,k)-vflux(i,k-1))
        a_mut(i,j) = a_mut(i,j)-a_tendency(i,k,j)*g*g/(mut(i,j)*mut(i,j))/alt(i,k,j)*rdnw(k)*(vflux(i,k)-vflux(i,k-1))
        a_vflux(i,k-1) = a_vflux(i,k-1)-a_tendency(i,k,j)*g*g/mut(i,j)/alt(i,k,j)*rdnw(k)
        a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*g*g/mut(i,j)/alt(i,k,j)*rdnw(k)
      end do
    end do
    do i = i_start, i_end
      a_vflux(i,ktf) = 0.
    end do
    do i = i_start, i_end
      a_vflux(i,1) = a_vflux(i,1)+a_vflux(i,0)
      a_vflux(i,0) = 0.
    end do
    do k = kts, ktf-1
      do i = i_start, i_end
        a_alt(i,k+1,j) = a_alt(i,k+1,j)-a_vflux(i,k)*0.5*kvdif*rdn(k+1)/(0.5*0.5*(alt(i,k,j)+alt(i,k+1,j))*(alt(i,k,j)+alt(i,k+1,j)&
&))*(field(i,k+1,j)-field(i,k,j))
        a_alt(i,k,j) = a_alt(i,k,j)-a_vflux(i,k)*0.5*kvdif*rdn(k+1)/(0.5*0.5*(alt(i,k,j)+alt(i,k+1,j))*(alt(i,k,j)+alt(i,k+1,j)))*&
&(field(i,k+1,j)-field(i,k,j))
        a_field(i,k+1,j) = a_field(i,k+1,j)+a_vflux(i,k)*(kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j))))
        a_field(i,k,j) = a_field(i,k,j)-a_vflux(i,k)*(kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j))))
        a_vflux(i,k) = 0.
      end do
    end do
  end do
endif

   call trace_exit("a_vertical_diffusion")

end subroutine a_vertical_diffusion


subroutine a_vertical_diffusion_3dmp( field, a_field, a_tendency, base_3d, alt, a_alt, mut, a_mut, rdn, rdnw, kvdif, ide, jde, kde,&
& ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_alt(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_field(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_mut(ims:ime,jms:jme)
real, intent(inout) :: a_tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: base_3d(ims:ime,kms:kme,jms:jme)
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)

!==============================================
! declare local variables
!==============================================
real a_vflux(its:ite,0:kte+1)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real vflux(its:ite,0:kte+1)

   call trace_entry("a_vertical_diffusion_3dmp")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_vflux(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
do j = j_start, j_end
  do k = kts, ktf-1
    do i = i_start, i_end
      vflux(i,k) = kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-base_3d(i,k+1,j)+base_3d(i,k,j))
    end do
  end do
! recompute : vflux
  do i = i_start, i_end
    vflux(i,0) = vflux(i,1)
  end do
  do i = i_start, i_end
    vflux(i,ktf) = 0.
  end do
! recompute : vflux
  do k = kts, ktf
    do i = i_start, i_end
      a_alt(i,k,j) = a_alt(i,k,j)-a_tendency(i,k,j)*g*g/mut(i,j)/(alt(i,k,j)*alt(i,k,j))*rdnw(k)*(vflux(i,k)-vflux(i,k-1))
      a_mut(i,j) = a_mut(i,j)-a_tendency(i,k,j)*g*g/(mut(i,j)*mut(i,j))/alt(i,k,j)*rdnw(k)*(vflux(i,k)-vflux(i,k-1))
      a_vflux(i,k-1) = a_vflux(i,k-1)-a_tendency(i,k,j)*g*g/mut(i,j)/alt(i,k,j)*rdnw(k)
      a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*g*g/mut(i,j)/alt(i,k,j)*rdnw(k)
    end do
  end do
  do i = i_start, i_end
    a_vflux(i,ktf) = 0.
  end do
  do i = i_start, i_end
    a_vflux(i,1) = a_vflux(i,1)+a_vflux(i,0)
    a_vflux(i,0) = 0.
  end do
  do k = kts, ktf-1
    do i = i_start, i_end
      a_alt(i,k+1,j) = a_alt(i,k+1,j)-a_vflux(i,k)*0.5*kvdif*rdn(k+1)/(0.5*0.5*(alt(i,k,j)+alt(i,k+1,j))*(alt(i,k,j)+alt(i,k+1,j)))&
&*(field(i,k+1,j)-field(i,k,j)-base_3d(i,k+1,j)+base_3d(i,k,j))
      a_alt(i,k,j) = a_alt(i,k,j)-a_vflux(i,k)*0.5*kvdif*rdn(k+1)/(0.5*0.5*(alt(i,k,j)+alt(i,k+1,j))*(alt(i,k,j)+alt(i,k+1,j)))*&
&(field(i,k+1,j)-field(i,k,j)-base_3d(i,k+1,j)+base_3d(i,k,j))
      a_field(i,k+1,j) = a_field(i,k+1,j)+a_vflux(i,k)*(kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j))))
      a_field(i,k,j) = a_field(i,k,j)-a_vflux(i,k)*(kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j))))
      a_vflux(i,k) = 0.
    end do
  end do
end do

   call trace_exit("a_vertical_diffusion_3dmp")

end subroutine a_vertical_diffusion_3dmp


subroutine a_vertical_diffusion_mp( field, a_field, a_tendency, base, alt, a_alt, mut, a_mut, rdn, rdnw, kvdif, ide, jde, kde, ims,&
& ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_alt(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_field(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_mut(ims:ime,jms:jme)
real, intent(inout) :: a_tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: base(kms:kme)
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)

!==============================================
! declare local variables
!==============================================
real a_vflux(its:ite,0:kte+1)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real vflux(its:ite,0:kte+1)

   call trace_entry("a_vertical_diffusion_mp")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_vflux(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
do j = j_start, j_end
  do k = kts, ktf-1
    do i = i_start, i_end
      vflux(i,k) = kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-base(k+1)+base(k))
    end do
  end do
! recompute : vflux
  do i = i_start, i_end
    vflux(i,0) = vflux(i,1)
  end do
  do i = i_start, i_end
    vflux(i,ktf) = 0.
  end do
! recompute : vflux
  do k = kts, ktf
    do i = i_start, i_end
      a_alt(i,k,j) = a_alt(i,k,j)-a_tendency(i,k,j)*g*g/mut(i,j)/(alt(i,k,j)*alt(i,k,j))*rdnw(k)*(vflux(i,k)-vflux(i,k-1))
      a_mut(i,j) = a_mut(i,j)-a_tendency(i,k,j)*g*g/(mut(i,j)*mut(i,j))/alt(i,k,j)*rdnw(k)*(vflux(i,k)-vflux(i,k-1))
      a_vflux(i,k-1) = a_vflux(i,k-1)-a_tendency(i,k,j)*g*g/mut(i,j)/alt(i,k,j)*rdnw(k)
      a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*g*g/mut(i,j)/alt(i,k,j)*rdnw(k)
    end do
  end do
  do i = i_start, i_end
    a_vflux(i,ktf) = 0.
  end do
  do i = i_start, i_end
    a_vflux(i,1) = a_vflux(i,1)+a_vflux(i,0)
    a_vflux(i,0) = 0.
  end do
  do k = kts, ktf-1
    do i = i_start, i_end
      a_alt(i,k+1,j) = a_alt(i,k+1,j)-a_vflux(i,k)*0.5*kvdif*rdn(k+1)/(0.5*0.5*(alt(i,k,j)+alt(i,k+1,j))*(alt(i,k,j)+alt(i,k+1,j)))&
&*(field(i,k+1,j)-field(i,k,j)-base(k+1)+base(k))
      a_alt(i,k,j) = a_alt(i,k,j)-a_vflux(i,k)*0.5*kvdif*rdn(k+1)/(0.5*0.5*(alt(i,k,j)+alt(i,k+1,j))*(alt(i,k,j)+alt(i,k+1,j)))*&
&(field(i,k+1,j)-field(i,k,j)-base(k+1)+base(k))
      a_field(i,k+1,j) = a_field(i,k+1,j)+a_vflux(i,k)*(kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j))))
      a_field(i,k,j) = a_field(i,k,j)-a_vflux(i,k)*(kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j))))
      a_vflux(i,k) = 0.
    end do
  end do
end do

   call trace_exit("a_vertical_diffusion_mp")

end subroutine a_vertical_diffusion_mp


subroutine a_vertical_diffusion_u( field, a_field, a_tendency, config_flags, u_base, alt, a_alt, muu, a_muu, rdn, rdnw, kvdif, ids,&
& ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_alt(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_field(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_muu(ims:ime,jms:jme)
real, intent(inout) :: a_tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: u_base(kms:kme)

!==============================================
! declare local variables
!==============================================
real a_vflux(its:ite,0:kte+1)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
logical specified
real vflux(its:ite,0:kte+1)

   call trace_entry("a_vertical_diffusion_u")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_vflux(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its
! recompute : i_start
i_end = ite
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
if (config_flags%open_xs .or. specified) then
  i_start = max(ids+1,its)
endif
! recompute : i_start
if (config_flags%open_xe .or. specified) then
  i_end = min(ide-1,ite)
endif
! recompute : i_end
do j = j_start, j_end
  do k = kts, ktf-1
    do i = i_start, i_end
      vflux(i,k) = kvdif*rdn(k+1)/(0.25*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-&
&u_base(k+1)+u_base(k))
    end do
  end do
! recompute : vflux
  do i = i_start, i_end
    vflux(i,0) = vflux(i,1)
  end do
  do i = i_start, i_end
    vflux(i,ktf) = 0.
  end do
! recompute : vflux
  do k = kts, ktf-1
    do i = i_start, i_end
      a_alt(i-1,k,j) = a_alt(i-1,k,j)-a_tendency(i,k,j)*0.5*(g*g*rdnw(k)/muu(i,j))/(0.5*0.5*(alt(i-1,k,j)+alt(i,k,j))*(alt(i-1,k,j)&
&+alt(i,k,j)))*(vflux(i,k)-vflux(i,k-1))
      a_alt(i,k,j) = a_alt(i,k,j)-a_tendency(i,k,j)*0.5*(g*g*rdnw(k)/muu(i,j))/(0.5*0.5*(alt(i-1,k,j)+alt(i,k,j))*(alt(i-1,k,j)+&
&alt(i,k,j)))*(vflux(i,k)-vflux(i,k-1))
      a_muu(i,j) = a_muu(i,j)-a_tendency(i,k,j)*g*g*rdnw(k)/(muu(i,j)*muu(i,j))/(0.5*(alt(i-1,k,j)+alt(i,k,j)))*(vflux(i,k)-&
&vflux(i,k-1))
      a_vflux(i,k-1) = a_vflux(i,k-1)-a_tendency(i,k,j)*(g*g*rdnw(k)/muu(i,j)/(0.5*(alt(i-1,k,j)+alt(i,k,j))))
      a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*(g*g*rdnw(k)/muu(i,j)/(0.5*(alt(i-1,k,j)+alt(i,k,j))))
    end do
  end do
  do i = i_start, i_end
    a_vflux(i,ktf) = 0.
  end do
  do i = i_start, i_end
    a_vflux(i,1) = a_vflux(i,1)+a_vflux(i,0)
    a_vflux(i,0) = 0.
  end do
  do k = kts, ktf-1
    do i = i_start, i_end
      a_alt(i-1,k+1,j) = a_alt(i-1,k+1,j)-a_vflux(i,k)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-&
&1,k+1,j))*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-u_base(k+1)+u_base(k))
      a_alt(i,k+1,j) = a_alt(i,k+1,j)-a_vflux(i,k)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+&
&1,j))*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-u_base(k+1)+u_base(k))
      a_alt(i-1,k,j) = a_alt(i-1,k,j)-a_vflux(i,k)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+&
&1,j))*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-u_base(k+1)+u_base(k))
      a_alt(i,k,j) = a_alt(i,k,j)-a_vflux(i,k)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j))&
&*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-u_base(k+1)+u_base(k))
      a_field(i,k+1,j) = a_field(i,k+1,j)+a_vflux(i,k)*(kvdif*rdn(k+1)/(0.25*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j))))
      a_field(i,k,j) = a_field(i,k,j)-a_vflux(i,k)*(kvdif*rdn(k+1)/(0.25*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j))))
      a_vflux(i,k) = 0.
    end do
  end do
end do

   call trace_exit("a_vertical_diffusion_u")

end subroutine a_vertical_diffusion_u


subroutine a_vertical_diffusion_v( field, a_field, a_tendency, config_flags, v_base, alt, a_alt, muv, a_muv, rdn, rdnw, kvdif, ide,&
& jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_alt(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_field(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_muv(ims:ime,jms:jme)
real, intent(inout) :: a_tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
real, intent(in) :: muv(ims:ime,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: v_base(kms:kme)

!==============================================
! declare local variables
!==============================================
real a_vflux(its:ite,0:kte+1)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer jm1
integer k
integer ktf
logical specified
real vflux(its:ite,0:kte+1)

   call trace_entry("a_vertical_diffusion_v")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_vflux(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
specified =  .false. 
! recompute : specified
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
! recompute : specified
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
if (config_flags%open_ys .or. specified) then
  j_start = max(jds+1,jts)
endif
! recompute : j_start
if (config_flags%open_ye .or. specified) then
  j_end = min(jde-1,jte)
endif
! recompute : j_end
do j = j_start, j_end
  jm1 = j-1
! recompute : jm1
  do k = kts, ktf-1
    do i = i_start, i_end
      vflux(i,k) = kvdif*rdn(k+1)/(0.25*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1)))*(field(i,k+1,j)-field(i,k,j)-&
&v_base(k+1)+v_base(k))
    end do
  end do
! recompute : vflux
  do i = i_start, i_end
    vflux(i,0) = vflux(i,1)
  end do
  do i = i_start, i_end
    vflux(i,ktf) = 0.
  end do
! recompute : vflux
  do k = kts, ktf-1
    do i = i_start, i_end
      a_alt(i,k,j) = a_alt(i,k,j)-a_tendency(i,k,j)*0.5*(g*g*rdnw(k)/muv(i,j))/(0.5*0.5*(alt(i,k,jm1)+alt(i,k,j))*(alt(i,k,jm1)+&
&alt(i,k,j)))*(vflux(i,k)-vflux(i,k-1))
      a_alt(i,k,jm1) = a_alt(i,k,jm1)-a_tendency(i,k,j)*0.5*(g*g*rdnw(k)/muv(i,j))/(0.5*0.5*(alt(i,k,jm1)+alt(i,k,j))*(alt(i,k,jm1)&
&+alt(i,k,j)))*(vflux(i,k)-vflux(i,k-1))
      a_muv(i,j) = a_muv(i,j)-a_tendency(i,k,j)*g*g*rdnw(k)/(muv(i,j)*muv(i,j))/(0.5*(alt(i,k,jm1)+alt(i,k,j)))*(vflux(i,k)-&
&vflux(i,k-1))
      a_vflux(i,k-1) = a_vflux(i,k-1)-a_tendency(i,k,j)*(g*g*rdnw(k)/muv(i,j)/(0.5*(alt(i,k,jm1)+alt(i,k,j))))
      a_vflux(i,k) = a_vflux(i,k)+a_tendency(i,k,j)*(g*g*rdnw(k)/muv(i,j)/(0.5*(alt(i,k,jm1)+alt(i,k,j))))
    end do
  end do
  do i = i_start, i_end
    a_vflux(i,ktf) = 0.
  end do
  do i = i_start, i_end
    a_vflux(i,1) = a_vflux(i,1)+a_vflux(i,0)
    a_vflux(i,0) = 0.
  end do
  do k = kts, ktf-1
    do i = i_start, i_end
      a_alt(i,k+1,j) = a_alt(i,k+1,j)-a_vflux(i,k)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,&
&jm1))*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1)))*(field(i,k+1,j)-field(i,k,j)-v_base(k+1)+v_base(k))
      a_alt(i,k+1,jm1) = a_alt(i,k+1,jm1)-a_vflux(i,k)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,&
&k+1,jm1))*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1)))*(field(i,k+1,j)-field(i,k,j)-v_base(k+1)+v_base(k))
      a_alt(i,k,j) = a_alt(i,k,j)-a_vflux(i,k)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1))&
&*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1)))*(field(i,k+1,j)-field(i,k,j)-v_base(k+1)+v_base(k))
      a_alt(i,k,jm1) = a_alt(i,k,jm1)-a_vflux(i,k)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,&
&jm1))*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1)))*(field(i,k+1,j)-field(i,k,j)-v_base(k+1)+v_base(k))
      a_field(i,k+1,j) = a_field(i,k+1,j)+a_vflux(i,k)*(kvdif*rdn(k+1)/(0.25*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1))))
      a_field(i,k,j) = a_field(i,k,j)-a_vflux(i,k)*(kvdif*rdn(k+1)/(0.25*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1))))
      a_vflux(i,k) = 0.
    end do
  end do
end do

   call trace_exit("a_vertical_diffusion_v")

end subroutine a_vertical_diffusion_v


subroutine a_w_damp( a_rw_tend, ww, a_ww, w, a_w, mut, a_mut, rdnw, dt, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts,&
& jte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: a_mut(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dt
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ww(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_cf_d
real a_cf_n
real cf_d
real cf_n
real cfl
integer i
integer itf
integer j
integer jtf
integer k

   call trace_entry("a_w_damp")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_cf_d = 0.
a_cf_n = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
itf = min(ite,ide-1)
! recompute : itf
jtf = min(jte,jde-1)
! recompute : jtf
do j = jts, jtf
  a_cf_d = 0.
  a_cf_n = 0.
  do k = 2, kde-1
    a_cf_d = 0.
    a_cf_n = 0.
    do i = its, itf
      a_cf_d = 0.
      a_cf_n = 0.
      cf_n = abs(ww(i,k,j))
! recompute : cf_n
      cf_d = abs(mut(i,j)*rdnw(k)*dt)
! recompute : cf_d
      if (cf_n .gt. cf_d*w_beta) then
        a_mut(i,j) = a_mut(i,j)-a_rw_tend(i,k,j)*w_alpha*(cfl-w_beta)*sign(1.,w(i,k,j))
      endif
      a_mut(i,j) = a_mut(i,j)+a_cf_d*rdnw(k)*dt*sign(1.,mut(i,j)*rdnw(k)*dt)
      a_cf_d = 0.
      a_ww(i,k,j) = a_ww(i,k,j)+a_cf_n*sign(1.,ww(i,k,j))
      a_cf_n = 0.
    end do
  end do
end do

   call trace_exit("a_w_damp")

end subroutine a_w_damp


subroutine a_zero_tend( a_tendency, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_tendency(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
integer, intent(in) :: kts

!==============================================
! declare local variables
!==============================================
integer i
integer j
integer k

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
! TBH:  Fill in halos since we know what they must be to avoid 
! TBH:  halo updates.  

!do j = jms, jme
!  do k = kms, kme
!    do i = ims, ime
!      a_tendency(i,k,j) = 0.
!    end do
!  end do
!end do

a_tendency(ims:ime,kms:kme,jms:jme) = 0.

end subroutine a_zero_tend

!Zhang Xiaoyan 11/02/2006

!*************************************************************
subroutine a_surface_drag(ru_tendf, a_ru_tendf, rv_tendf, a_rv_tendf, u, a_u, v, a_v, xland, muu, a_muu, muv, a_muv, z, &
&a_z, z_at_w, a_z_at_w, &
             ids, ide, jds, jde, kds, kde, &
             ims, ime, jms, jme, kms, kme, &
             its, ite, jts, jte, kts, kte )

!USE module_big_step_utilities_em
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: a_muu(ims:ime,jms:jme)
real, intent(inout) :: a_muv(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_z(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_z_at_w(ims:ime,kms:kme,jms:jme)
!real epsilon
integer, intent(in) :: ids
integer, intent(in) :: ide
integer, intent(in) :: ite 
integer, intent(in) :: its
integer, intent(in) :: jds
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kds
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
real, intent(inout) :: ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: xland(ims:ime,jms:jme)
real, intent(in) :: z(ims:ime,kms:kme,jms:jme)
real, intent(in) :: z_at_w(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_cd
real a_tao_xz
real a_tao_yz
real a_v0_u
real a_v0_ui
real a_v0_v
real a_v0_vi
real a_zu
real a_zv
real a_zwt
real cd 
integer i
integer i_end
integer i_endu
integer i_start
integer j
integer j_end
integer j_endv
integer j_start
integer k
real tao_xz
real tao_yz
real v0_u
real v0_v
real zu
real zv
real zwt

REAL, PARAMETER :: epsilon = 1.e-10

   call trace_entry("a_surface_drag")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_cd = 0.
a_tao_xz = 0.
a_tao_yz = 0.
a_v0_u = 0.
a_v0_v = 0.
a_zu = 0.
a_zv = 0.
a_zwt = 0.

!----------------------------------------------
! ROUTINE BODY
! ROUTINE BODY
!----------------------------------------------
!----------------------------------------------
! FUNCTION AND TAPE COMPUTATIONS
!----------------------------------------------
i_start = its
i_end = min(ite,ide-1)
i_endu = ite
j_start = jts
j_end = min(jte,jde-1)
j_endv = jte
#if 0
do j = j_start, j_end
  do i = i_start, i_endu
    v0_u = sqrt(u(i,kts,j)**2+((v(i,kts,j)+v(i,kts,j+1)+v(i-1,kts,j)+v(i-1,kts,j+1))/4)**2)+epsilon
    if (xland(i,j) .eq. xland(i-1,j)) then
      if (xland(i,j) .lt. 1.5) then
        cd = 0.01
      else 
        cd = 0.001
        cd = max(cd,0.0001*v0_u)
        cd = min(cd,0.003)
      endif
    else 
      cd = 0.003
    endif
    tao_xz = cd*v0_u*u(i,kts,j)
    do k = kts, kte
      zu = 0.5*(z(i,k,j)+z(i-1,k,j)-z_at_w(i,kts,j)-z_at_w(i-1,kts,j))
      if (zu .lt. 1000.) then
        zwt = 2.*(1000.-zu)/1000.
!X        ru_tendf(i,k,j) = ru_tendf(i,k,j)-zwt*0.5*muu(i,j)*tao_xz/1000.
      endif
    end do
  end do
end do
do j = j_start, j_endv
  do i = i_start, i_end
    v0_v = sqrt(v(i,kts,j)**2+((u(i,kts,j)+u(i,kts,j-1)+u(i+1,kts,j)+u(i+1,kts,j-1))/4)**2)+epsilon
    if (xland(i,j) .eq. xland(i,j-1)) then
      if (xland(i,j) .lt. 1.5) then
        cd = 0.01
      else
        cd = 0.001
        cd = max(cd,0.0001*v0_v)
        cd = min(cd,0.003)
      endif
    else
      cd = 0.003
    endif
    tao_yz = cd*v0_v*v(i,kts,j)
    do k = kts, kte
      zv = 0.5*(z(i,k,j)+z(i,k,j-1)-z_at_w(i,kts,j)-z_at_w(i,kts,j-1))
      if (zv .lt. 1000.) then
        zwt = 2.*(1000.-zv)/1000.
!X        rv_tendf(i,k,j) = rv_tendf(i,k,j)-zwt*0.5*muv(i,j)*tao_yz/1000.
      endif
    end do
  end do
end do
#endif

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
! recompute : i_start
! recompute : i_end
! recompute : i_endu
! recompute : j_start
! recompute : j_end
! recompute : j_endv
! TBH:  Redundant computation into halo region for X(i,j-1) = X(i,j-1) + ...
do j = min(j_endv+1,jde), j_start, -1
  ! TBH:  Redundant computation into halo region for X(i+1,j) = X(i+1,j) + ...
  do i = i_end, max(i_start-1,ids), -1
    v0_v = sqrt(v(i,kts,j)**2+((u(i,kts,j)+u(i,kts,j-1)+u(i+1,kts,j)+u(i+1,kts,j-1))/4)**2)+epsilon
! recompute : v0_v
! recompute : v0_v
    if (xland(i,j) .eq. xland(i,j-1)) then
      if (xland(i,j) .lt. 1.5) then
        cd = 0.01
      else
        cd = 0.001
        cd = max(cd,0.0001*v0_v)
        cd = min(cd,0.003)
      endif
    else
      cd = 0.003
    endif
! recompute : cd
! recompute : cd
    tao_yz = cd*v0_v*v(i,kts,j)
! recompute : tao_yz
! recompute : tao_yz
    do k = kts, kte
      a_zv = 0.
      a_zwt = 0.
      zv = 0.5*(z(i,k,j)+z(i,k,j-1)-z_at_w(i,kts,j)-z_at_w(i,kts,j-1))
! recompute : zv
! recompute : zv
      if (zv .lt. 1000.) then
        zwt = 2.*(1000.-zv)/1000.
! recompute : zwt
! recompute : zwt
        a_muv(i,j) = a_muv(i,j)-a_rv_tendf(i,k,j)*(0.5*zwt*tao_yz/1000.)
        a_tao_yz = a_tao_yz-a_rv_tendf(i,k,j)*(0.5*zwt*muv(i,j)/1000.)
        a_zwt = a_zwt-a_rv_tendf(i,k,j)*(0.5*muv(i,j)*tao_yz/1000.)
        a_zv = a_zv-0.002*a_zwt
        a_zwt = 0.
      endif
      a_z(i,k,j-1) = a_z(i,k,j-1)+0.5*a_zv
      a_z(i,k,j) = a_z(i,k,j)+0.5*a_zv
      a_z_at_w(i,kts,j-1) = a_z_at_w(i,kts,j-1)-0.5*a_zv
      a_z_at_w(i,kts,j) = a_z_at_w(i,kts,j)-0.5*a_zv
      a_zv = 0.
    end do
    a_cd = a_cd+a_tao_yz*v0_v*v(i,kts,j)
    a_v(i,kts,j) = a_v(i,kts,j)+a_tao_yz*cd*v0_v
    a_v0_v = a_v0_v+a_tao_yz*cd*v(i,kts,j)
    a_tao_yz = 0.
    if (xland(i,j) .eq. xland(i,j-1)) then
      if (xland(i,j) .lt. 1.5) then
        a_cd = 0.
      else
        cd = 0.001
! recompute : cd
! recompute : cd
        cd = max(cd,0.0001*v0_v)
! recompute : cd
! recompute : cd
        a_cd = a_cd*(0.5+sign(0.5,0.003-cd))
! recompute pos : ASSIGN_STMT surface_drag.f90:90
! recompute vars : cd
        cd = 0.001
! recompute : cd
! recompute vars : cd
        a_v0_v = a_v0_v+0.0001*a_cd*(0.5-sign(0.5,cd-0.0001*v0_v))
        a_cd = a_cd*(0.5+sign(0.5,cd-0.0001*v0_v))
        a_cd = 0.
      endif
    else
      a_cd = 0.
    endif
    a_v0_vi = a_v0_v*(1./(2.*sqrt(v(i,kts,j)**2+((u(i,kts,j)+u(i,kts,j-1)+u(i+1,kts,j)+u(i+1,kts,j-1))/4)**2)))
    a_u(i+1,kts,j-1) = a_u(i+1,kts,j-1)+2*a_v0_vi/float(4)*((u(i,kts,j)+u(i,kts,j-1)+u(i+1,kts,j)+u(i+1,kts,j-1))/float(4))
    a_u(i,kts,j-1) = a_u(i,kts,j-1)+2*a_v0_vi/float(4)*((u(i,kts,j)+u(i,kts,j-1)+u(i+1,kts,j)+u(i+1,kts,j-1))/float(4))
    a_u(i+1,kts,j) = a_u(i+1,kts,j)+2*a_v0_vi/float(4)*((u(i,kts,j)+u(i,kts,j-1)+u(i+1,kts,j)+u(i+1,kts,j-1))/float(4))
    a_u(i,kts,j) = a_u(i,kts,j)+2*a_v0_vi/float(4)*((u(i,kts,j)+u(i,kts,j-1)+u(i+1,kts,j)+u(i+1,kts,j-1))/float(4))
    a_v(i,kts,j) = a_v(i,kts,j)+2*a_v0_vi*v(i,kts,j)
    a_v0_v = 0.
  end do
end do
! TBH:  Redundant computation into halo region for X(i,j+1) = X(i,j+1) + ...
do j = j_end, max(j_start-1,jds), -1
  ! TBH:  Redundant computation into halo region for X(i-1,j) = X(i-1,j) + ...
  do i = min(i_endu+1,ide), i_start, -1
    v0_u = sqrt(u(i,kts,j)**2+((v(i,kts,j)+v(i,kts,j+1)+v(i-1,kts,j)+v(i-1,kts,j+1))/4)**2)+epsilon
! recompute : v0_u
! recompute : v0_u
    if (xland(i,j) .eq. xland(i-1,j)) then
      if (xland(i,j) .lt. 1.5) then
        cd = 0.01
      else
        cd = 0.001
        cd = max(cd,0.0001*v0_u)
        cd = min(cd,0.003)
      endif
    else
      cd = 0.003
    endif
! recompute : cd
! recompute : cd
    tao_xz = cd*v0_u*u(i,kts,j)
! recompute : tao_xz
! recompute : tao_xz
    do k = kts, kte
      a_zu = 0.
      a_zwt = 0.
      zu = 0.5*(z(i,k,j)+z(i-1,k,j)-z_at_w(i,kts,j)-z_at_w(i-1,kts,j))
! recompute : zu
! recompute : zu
      if (zu .lt. 1000.) then
        zwt = 2.*(1000.-zu)/1000.
! recompute : zwt
! recompute : zwt
        a_muu(i,j) = a_muu(i,j)-a_ru_tendf(i,k,j)*(0.5*zwt*tao_xz/1000.)
        a_tao_xz = a_tao_xz-a_ru_tendf(i,k,j)*(0.5*zwt*muu(i,j)/1000.)
        a_zwt = a_zwt-a_ru_tendf(i,k,j)*(0.5*muu(i,j)*tao_xz/1000.)
        a_zu = a_zu-0.002*a_zwt
        a_zwt = 0.
      endif
      a_z(i-1,k,j) = a_z(i-1,k,j)+0.5*a_zu
      a_z(i,k,j) = a_z(i,k,j)+0.5*a_zu
      a_z_at_w(i-1,kts,j) = a_z_at_w(i-1,kts,j)-0.5*a_zu
      a_z_at_w(i,kts,j) = a_z_at_w(i,kts,j)-0.5*a_zu
      a_zu = 0.
    end do
    a_cd = a_cd+a_tao_xz*v0_u*u(i,kts,j)
    a_u(i,kts,j) = a_u(i,kts,j)+a_tao_xz*cd*v0_u
    a_v0_u = a_v0_u+a_tao_xz*cd*u(i,kts,j)
    a_tao_xz = 0.
    if (xland(i,j) .eq. xland(i-1,j)) then
      if (xland(i,j) .lt. 1.5) then
        a_cd = 0.
      else
        cd = 0.001
! recompute : cd
! recompute : cd
        cd = max(cd,0.0001*v0_u)
! recompute : cd
! recompute : cd
        a_cd = a_cd*(0.5+sign(0.5,0.003-cd))
! recompute pos : ASSIGN_STMT surface_drag.f90:54
! recompute vars : cd
        cd = 0.001
! recompute : cd
! recompute vars : cd
        a_v0_u = a_v0_u+0.0001*a_cd*(0.5-sign(0.5,cd-0.0001*v0_u))
        a_cd = a_cd*(0.5+sign(0.5,cd-0.0001*v0_u))
        a_cd = 0.
      endif
    else
      a_cd = 0.
    endif
    a_v0_ui = a_v0_u*(1./(2.*sqrt(u(i,kts,j)**2+((v(i,kts,j)+v(i,kts,j+1)+v(i-1,kts,j)+v(i-1,kts,j+1))/4)**2)))
    a_u(i,kts,j) = a_u(i,kts,j)+2*a_v0_ui*u(i,kts,j)
    a_v(i-1,kts,j+1) = a_v(i-1,kts,j+1)+2*a_v0_ui/float(4)*((v(i,kts,j)+v(i,kts,j+1)+v(i-1,kts,j)+v(i-1,kts,j+1))/float(4))
    a_v(i,kts,j+1) = a_v(i,kts,j+1)+2*a_v0_ui/float(4)*((v(i,kts,j)+v(i,kts,j+1)+v(i-1,kts,j)+v(i-1,kts,j+1))/float(4))
    a_v(i-1,kts,j) = a_v(i-1,kts,j)+2*a_v0_ui/float(4)*((v(i,kts,j)+v(i,kts,j+1)+v(i-1,kts,j)+v(i-1,kts,j+1))/float(4))
    a_v(i,kts,j) = a_v(i,kts,j)+2*a_v0_ui/float(4)*((v(i,kts,j)+v(i,kts,j+1)+v(i-1,kts,j)+v(i-1,kts,j+1))/float(4))
    a_v0_u = 0.
  end do
end do

   call trace_exit("a_surface_drag")

end subroutine a_surface_drag







!                           DISCLAIMER
!
!   This file was generated by TAF version 1.8.81
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine a_moist_physics_prep_em( t_new, a_t_new, t_old, a_t_old, t0, rho, a_rho, al, a_al, alb, p, a_p, p8w, a_p8w, p0, &
&pb, ph, a_ph, phb, pii, a_pii, pf, a_pf, z, a_z, z_at_w, a_z_at_w, dz8w, a_dz8w, h_diabatic, a_h_diabatic, fzm, fzp, &
&ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.8.81  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_al(ims:ime,kms:kme,jms:jme)
real, intent(out)   :: a_dz8w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_h_diabatic(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_p8w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_pf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph(ims:ime,kms:kme,jms:jme)
real, intent(out)   :: a_pii(ims:ime,kms:kme,jms:jme)
real, intent(out)   :: a_rho(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_new(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_z(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_z_at_w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: dz8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
real, intent(inout) :: h_diabatic(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: p0
real, intent(out) :: p8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: pf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: pii(ims:ime,kms:kme,jms:jme)
real, intent(out) :: rho(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t0
real, intent(inout) :: t_new(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: t_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: z(ims:ime,kms:kme,jms:jme)
real, intent(out) :: z_at_w(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_w1
real a_w2
real a_z0
real a_z1
real a_z2
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer k_end
integer k_start
real w1
real w2
real z0
real z1
real z2

   call trace_entry("a_moist_physics_prep_em")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_w1 = 0.
a_w2 = 0.
a_z0 = 0.
a_z1 = 0.
a_z2 = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
!----------------------------------------------
! FUNCTION AND TAPE COMPUTATIONS
!----------------------------------------------
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
k_start = kts
k_end = min(kte,kde-1)

do j = j_start, j_end
  do k = k_start, kte
    do i = i_start, i_end
      z_at_w(i,k,j) = (ph(i,k,j)+phb(i,k,j))/g
    end do
  end do
end do
do j = j_start, j_end
  do k = k_start, kte-1
    do i = i_start, i_end
      dz8w(i,k,j) = z_at_w(i,k+1,j)-z_at_w(i,k,j)
    end do
  end do
end do
do j = j_start, j_end
  do i = i_start, i_end
    dz8w(i,kte,j) = 0.
  end do
end do
do j = j_start, j_end
  do k = k_start, k_end
    do i = i_start, i_end
!      h_diabatic(i,k,j) = t_new(i,k,j)   !This is the key, comment this line make it right.
      t_new(i,k,j) = t_new(i,k,j)+t0
      t_old(i,k,j) = t_old(i,k,j)+t0
      rho(i,k,j) = 1./(al(i,k,j)+alb(i,k,j))
      pii(i,k,j) = ((p(i,k,j)+pb(i,k,j))/p0)**rcp
      z(i,k,j) = 0.5*(z_at_w(i,k,j)+z_at_w(i,k+1,j))
      pf(i,k,j) = p(i,k,j)+pb(i,k,j)
    end do
  end do
end do

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
do j = j_start, j_end
  do k = k_start, k_end
    do i = i_start, i_end
      a_p(i,k,j) = a_p(i,k,j)+a_pf(i,k,j)
      a_pf(i,k,j) = 0.
      a_z_at_w(i,k+1,j) = a_z_at_w(i,k+1,j)+0.5*a_z(i,k,j)
      a_z_at_w(i,k,j) = a_z_at_w(i,k,j)+0.5*a_z(i,k,j)
      a_z(i,k,j) = 0.
      a_p(i,k,j) = a_p(i,k,j)+a_pii(i,k,j)/p0*rcp*((p(i,k,j)+pb(i,k,j))/p0)**(rcp-1)
      a_pii(i,k,j) = 0.
      a_al(i,k,j) = a_al(i,k,j)-a_rho(i,k,j)/((al(i,k,j)+alb(i,k,j))*(al(i,k,j)+alb(i,k,j)))
      a_rho(i,k,j) = 0.
    end do
  end do
end do
do j = j_start, j_end
  do i = i_start, i_end
    a_dz8w(i,kte,j) = 0.
  end do
end do
do j = j_start, j_end
  do k = k_start, kte-1
    do i = i_start, i_end
      a_z_at_w(i,k+1,j) = a_z_at_w(i,k+1,j)+a_dz8w(i,k,j)
      a_z_at_w(i,k,j) = a_z_at_w(i,k,j)-a_dz8w(i,k,j)
      a_dz8w(i,k,j) = 0.
    end do
  end do
end do
do j = j_start, j_end
  do k = k_start, kte
    do i = i_start, i_end
      a_ph(i,k,j) = a_ph(i,k,j)+a_z_at_w(i,k,j)/g
      a_z_at_w(i,k,j) = 0.
    end do
  end do
end do

   call trace_exit("a_moist_physics_prep_em")

end subroutine a_moist_physics_prep_em


!                           DISCLAIMER
!
!   This file was generated by TAF version 1.8.81
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
!!subroutine a_moist_physics_finish_em( t_new, a_t_new, t_old, a_t_old, t0, h_diabatic, a_h_diabatic, dt, ide, jde, kde, &
!!&ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )

subroutine a_moist_physics_finish_em( a_t_new, a_t_old, t0, a_h_diabatic, dt, ide, jde, kde, &
&ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.8.81  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_h_diabatic(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_new(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dt
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: t0
real                :: t_new(ims:ime,kms:kme,jms:jme)
real                :: t_old(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer k_end
integer k_start

   call trace_entry("a_moist_physics_finish_em")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
!----------------------------------------------
! FUNCTION AND TAPE COMPUTATIONS
!----------------------------------------------
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
k_start = kts
k_end = min(kte,kde-1)

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
do j = j_start, j_end
  do k = k_start, k_end
    do i = i_start, i_end
      a_t_old(i,k,j) = a_t_old(i,k,j)
      a_t_new(i,k,j) = a_t_new(i,k,j)
    end do
  end do
end do

   call trace_exit("a_moist_physics_finish_em")

end subroutine a_moist_physics_finish_em


end module     a_module_big_step_utilities_em
