!                           DISCLAIMER
!
!   This file was generated by TAF version 1.7.18
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module g_module_big_step_utilities_em
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use module_domain
use module_model_constants
use module_state_description
use module_configure
use module_big_step_utilities_em

USE module_trace, only : trace_entry, trace_exit

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains

subroutine g_calc_alt( alt, g_alt, al, g_al, alb, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_al(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_alt(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts

!==============================================
! declare local variables
!==============================================
integer i
integer itf
integer j
integer jtf
integer k
integer ktf

   call trace_entry("g_calc_alt")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
itf = min(ite,ide-1)
jtf = min(jte,jde-1)
ktf = min(kte,kde-1)

!do j = jts, jtf
!  do k = kts, ktf
!    do i = its, itf
!      g_alt(i,k,j) = g_al(i,k,j)
!      alt(i,k,j) = al(i,k,j)+alb(i,k,j)
!    end do
!  end do
!end do
g_alt(its:itf,kts:ktf,jts:jtf) = g_al(its:itf,kts:ktf,jts:jtf)
alt(its:itf,kts:ktf,jts:jtf) = al(its:itf,kts:ktf,jts:jtf)+alb(its:itf,kts:ktf,jts:jtf)

   call trace_exit("g_calc_alt")

end subroutine g_calc_alt


subroutine g_calc_cq( moist, g_moist, cqu, g_cqu, cqv, g_cqv, cqw, g_cqw, n_moist, ide, jde, kde, ims, ime, jms, jme, kms, kme, &
&its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(out) :: cqu(ims:ime,kms:kme,jms:jme)
real, intent(out) :: cqv(ims:ime,kms:kme,jms:jme)
real, intent(out) :: cqw(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_cqu(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_cqv(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_cqw(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: n_moist
real, intent(in) :: g_moist(ims:ime,kms:kme,jms:jme,n_moist)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: moist(ims:ime,kms:kme,jms:jme,n_moist)

!==============================================
! declare local variables
!==============================================
real g_qtot
integer i
integer ispe
integer itf
integer j
integer jtf
integer k
integer ktf
real qtot

   call trace_entry("g_calc_cq")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
itf = ite
jtf = min(jte,jde-1)
ktf = min(kte,kde-1)
if (n_moist .ge. param_first_scalar) then
  do j = jts, jtf
    do k = kts, ktf
      do i = its, itf
        g_qtot = 0.
        qtot = 0.
        do ispe = param_first_scalar, n_moist
          g_qtot = g_moist(i-1,k,j,ispe)+g_moist(i,k,j,ispe)+g_qtot
          qtot = qtot+moist(i,k,j,ispe)+moist(i-1,k,j,ispe)
        end do
        g_cqu(i,k,j) = -(g_qtot*(0.5/((1.+0.5*qtot)*(1.+0.5*qtot))))
        cqu(i,k,j) = 1./(1.+0.5*qtot)
      end do
    end do
  end do
  itf = min(ite,ide-1)
  jtf = jte
  do j = jts, jtf
    do k = kts, ktf
      do i = its, itf
        g_qtot = 0.
        qtot = 0.
        do ispe = param_first_scalar, n_moist
          g_qtot = g_moist(i,k,j-1,ispe)+g_moist(i,k,j,ispe)+g_qtot
          qtot = qtot+moist(i,k,j,ispe)+moist(i,k,j-1,ispe)
        end do
        g_cqv(i,k,j) = -(g_qtot*(0.5/((1.+0.5*qtot)*(1.+0.5*qtot))))
        cqv(i,k,j) = 1./(1.+0.5*qtot)
      end do
    end do
  end do
  itf = min(ite,ide-1)
  jtf = min(jte,jde-1)
  do j = jts, jtf
    do k = kts+1, ktf
      do i = its, itf
        g_qtot = 0.
        qtot = 0.
        do ispe = param_first_scalar, n_moist
          g_qtot = g_moist(i,k-1,j,ispe)+g_moist(i,k,j,ispe)+g_qtot
          qtot = qtot+moist(i,k,j,ispe)+moist(i,k-1,j,ispe)
        end do
        g_cqw(i,k,j) = 0.5*g_qtot
        cqw(i,k,j) = 0.5*qtot
      end do
    end do
  end do
else
  do j = jts, jtf
    do k = kts, ktf
      do i = its, itf
        g_cqu(i,k,j) = 0.
        cqu(i,k,j) = 1.
      end do
    end do
  end do
  itf = min(ite,ide-1)
  jtf = jte
  do j = jts, jtf
    do k = kts, ktf
      do i = its, itf
        g_cqv(i,k,j) = 0.
        cqv(i,k,j) = 1.
      end do
    end do
  end do
  itf = min(ite,ide-1)
  jtf = min(jte,jde-1)
  do j = jts, jtf
    do k = kts+1, ktf
      do i = its, itf
        g_cqw(i,k,j) = 0.
        cqw(i,k,j) = 0.
      end do
    end do
  end do
endif

   call trace_exit("g_calc_cq")

end subroutine g_calc_cq


subroutine g_calc_mu_uv( config_flags, mu, g_mu, mub, muu, g_muu, muv, g_muv, ids, ide, jds, jde, ims, ime, jms, jme, its, ite, &
&jts, jte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_mu(ims:ime,jms:jme)
real, intent(out) :: g_muu(ims:ime,jms:jme)
real, intent(out) :: g_muv(ims:ime,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: mub(ims:ime,jms:jme)
real, intent(out) :: muu(ims:ime,jms:jme)
real, intent(out) :: muv(ims:ime,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer im
integer itf
integer j
integer jm
integer jtf

   call trace_entry("g_calc_mu_uv")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
itf = ite
jtf = min(jte,jde-1)
if (its .ne. ids .and. ite .ne. ide) then
  do j = jts, jtf
    do i = its, itf
      g_muu(i,j) = 0.5*g_mu(i-1,j)+0.5*g_mu(i,j)
      muu(i,j) = 0.5*(mu(i,j)+mu(i-1,j)+mub(i,j)+mub(i-1,j))
    end do
  end do
else if (its .eq. ids .and. ite .ne. ide) then
  do j = jts, jtf
    do i = its+1, itf
      g_muu(i,j) = 0.5*g_mu(i-1,j)+0.5*g_mu(i,j)
      muu(i,j) = 0.5*(mu(i,j)+mu(i-1,j)+mub(i,j)+mub(i-1,j))
    end do
  end do
  i = its
  im = its
  if (config_flags%periodic_x) then
    im = its-1
  endif
  do j = jts, jtf
    g_muu(i,j) = 0.5*g_mu(i,j)+0.5*g_mu(im,j)
    muu(i,j) = 0.5*(mu(i,j)+mu(im,j)+mub(i,j)+mub(im,j))
  end do
else if (its .ne. ids .and. ite .eq. ide) then
  do j = jts, jtf
    do i = its, itf-1
      g_muu(i,j) = 0.5*g_mu(i-1,j)+0.5*g_mu(i,j)
      muu(i,j) = 0.5*(mu(i,j)+mu(i-1,j)+mub(i,j)+mub(i-1,j))
    end do
  end do
  i = ite
  im = ite-1
  if (config_flags%periodic_x) then
    im = ite
  endif
  do j = jts, jtf
    g_muu(i,j) = 0.5*g_mu(i-1,j)+0.5*g_mu(im,j)
    muu(i,j) = 0.5*(mu(i-1,j)+mu(im,j)+mub(i-1,j)+mub(im,j))
  end do
else if (its .eq. ids .and. ite .eq. ide) then
  do j = jts, jtf
    do i = its+1, itf-1
      g_muu(i,j) = 0.5*g_mu(i-1,j)+0.5*g_mu(i,j)
      muu(i,j) = 0.5*(mu(i,j)+mu(i-1,j)+mub(i,j)+mub(i-1,j))
    end do
  end do
  i = its
  im = its
  if (config_flags%periodic_x) then
    im = its-1
  endif
  do j = jts, jtf
    g_muu(i,j) = 0.5*g_mu(i,j)+0.5*g_mu(im,j)
    muu(i,j) = 0.5*(mu(i,j)+mu(im,j)+mub(i,j)+mub(im,j))
  end do
  i = ite
  im = ite-1
  if (config_flags%periodic_x) then
    im = ite
  endif
  do j = jts, jtf
    g_muu(i,j) = 0.5*g_mu(i-1,j)+0.5*g_mu(im,j)
    muu(i,j) = 0.5*(mu(i-1,j)+mu(im,j)+mub(i-1,j)+mub(im,j))
  end do
endif
itf = min(ite,ide-1)
jtf = jte
if (jts .ne. jds .and. jte .ne. jde) then
  do j = jts, jtf
    do i = its, itf
      g_muv(i,j) = 0.5*g_mu(i,j-1)+0.5*g_mu(i,j)
      muv(i,j) = 0.5*(mu(i,j)+mu(i,j-1)+mub(i,j)+mub(i,j-1))
    end do
  end do
else if (jts .eq. jds .and. jte .ne. jde) then
  do j = jts+1, jtf
    do i = its, itf
      g_muv(i,j) = 0.5*g_mu(i,j-1)+0.5*g_mu(i,j)
      muv(i,j) = 0.5*(mu(i,j)+mu(i,j-1)+mub(i,j)+mub(i,j-1))
    end do
  end do
  j = jts
  jm = jts
  if (config_flags%periodic_y) then
    jm = jts-1
  endif
  do i = its, itf
    g_muv(i,j) = 0.5*g_mu(i,j)+0.5*g_mu(i,jm)
    muv(i,j) = 0.5*(mu(i,j)+mu(i,jm)+mub(i,j)+mub(i,jm))
  end do
else if (jts .ne. jds .and. jte .eq. jde) then
  do j = jts, jtf-1
    do i = its, itf
      g_muv(i,j) = 0.5*g_mu(i,j-1)+0.5*g_mu(i,j)
      muv(i,j) = 0.5*(mu(i,j)+mu(i,j-1)+mub(i,j)+mub(i,j-1))
    end do
  end do
  j = jte
  jm = jte-1
  if (config_flags%periodic_y) then
    jm = jte
  endif
  do i = its, itf
    g_muv(i,j) = g_mu(i,j-1)
    muv(i,j) = mu(i,j-1)+mub(i,j-1)
    g_muv(i,j) = 0.5*g_mu(i,j-1)+0.5*g_mu(i,jm)
    muv(i,j) = 0.5*(mu(i,j-1)+mu(i,jm)+mub(i,j-1)+mub(i,jm))
  end do
else if (jts .eq. jds .and. jte .eq. jde) then
  do j = jts+1, jtf-1
    do i = its, itf
      g_muv(i,j) = 0.5*g_mu(i,j-1)+0.5*g_mu(i,j)
      muv(i,j) = 0.5*(mu(i,j)+mu(i,j-1)+mub(i,j)+mub(i,j-1))
    end do
  end do
  j = jts
  jm = jts
  if (config_flags%periodic_y) then
    jm = jts-1
  endif
  do i = its, itf
    g_muv(i,j) = 0.5*g_mu(i,j)+0.5*g_mu(i,jm)
    muv(i,j) = 0.5*(mu(i,j)+mu(i,jm)+mub(i,j)+mub(i,jm))
  end do
  j = jte
  jm = jte-1
  if (config_flags%periodic_y) then
    jm = jte
  endif
  do i = its, itf
    g_muv(i,j) = 0.5*g_mu(i,j-1)+0.5*g_mu(i,jm)
    muv(i,j) = 0.5*(mu(i,j-1)+mu(i,jm)+mub(i,j-1)+mub(i,jm))
  end do
endif

   call trace_exit("g_calc_mu_uv")

end subroutine g_calc_mu_uv


subroutine g_calc_mu_uv_1( config_flags, mu, g_mu, muu, g_muu, muv, g_muv, ids, ide, jds, jde, ims, ime, jms, jme, its, ite, jts, &
&jte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_mu(ims:ime,jms:jme)
real, intent(out) :: g_muu(ims:ime,jms:jme)
real, intent(out) :: g_muv(ims:ime,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(out) :: muu(ims:ime,jms:jme)
real, intent(out) :: muv(ims:ime,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer im
integer itf
integer j
integer jm
integer jtf

   call trace_entry("g_calc_mu_uv_1")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
itf = ite
jtf = min(jte,jde-1)
if (its .ne. ids .and. ite .ne. ide) then
  do j = jts, jtf
    do i = its, itf
      g_muu(i,j) = 0.5*g_mu(i-1,j)+0.5*g_mu(i,j)
      muu(i,j) = 0.5*(mu(i,j)+mu(i-1,j))
    end do
  end do
else if (its .eq. ids .and. ite .ne. ide) then
  do j = jts, jtf
    do i = its+1, itf
      g_muu(i,j) = 0.5*g_mu(i-1,j)+0.5*g_mu(i,j)
      muu(i,j) = 0.5*(mu(i,j)+mu(i-1,j))
    end do
  end do
  i = its
  im = its
  if (config_flags%periodic_x) then
    im = its-1
  endif
  do j = jts, jtf
    g_muu(i,j) = 0.5*g_mu(i,j)+0.5*g_mu(im,j)
    muu(i,j) = 0.5*(mu(i,j)+mu(im,j))
  end do
else if (its .ne. ids .and. ite .eq. ide) then
  do j = jts, jtf
    do i = its, itf-1
      g_muu(i,j) = 0.5*g_mu(i-1,j)+0.5*g_mu(i,j)
      muu(i,j) = 0.5*(mu(i,j)+mu(i-1,j))
    end do
  end do
  i = ite
  im = ite-1
  if (config_flags%periodic_x) then
    im = ite
  endif
  do j = jts, jtf
    g_muu(i,j) = 0.5*g_mu(i-1,j)+0.5*g_mu(im,j)
    muu(i,j) = 0.5*(mu(i-1,j)+mu(im,j))
  end do
else if (its .eq. ids .and. ite .eq. ide) then
  do j = jts, jtf
    do i = its+1, itf-1
      g_muu(i,j) = 0.5*g_mu(i-1,j)+0.5*g_mu(i,j)
      muu(i,j) = 0.5*(mu(i,j)+mu(i-1,j))
    end do
  end do
  i = its
  im = its
  if (config_flags%periodic_x) then
    im = its-1
  endif
  do j = jts, jtf
    g_muu(i,j) = 0.5*g_mu(i,j)+0.5*g_mu(im,j)
    muu(i,j) = 0.5*(mu(i,j)+mu(im,j))
  end do
  i = ite
  im = ite-1
  if (config_flags%periodic_x) then
    im = ite
  endif
  do j = jts, jtf
    g_muu(i,j) = 0.5*g_mu(i-1,j)+0.5*g_mu(im,j)
    muu(i,j) = 0.5*(mu(i-1,j)+mu(im,j))
  end do
endif
itf = min(ite,ide-1)
jtf = jte
if (jts .ne. jds .and. jte .ne. jde) then
  do j = jts, jtf
    do i = its, itf
      g_muv(i,j) = 0.5*g_mu(i,j-1)+0.5*g_mu(i,j)
      muv(i,j) = 0.5*(mu(i,j)+mu(i,j-1))
    end do
  end do
else if (jts .eq. jds .and. jte .ne. jde) then
  do j = jts+1, jtf
    do i = its, itf
      g_muv(i,j) = 0.5*g_mu(i,j-1)+0.5*g_mu(i,j)
      muv(i,j) = 0.5*(mu(i,j)+mu(i,j-1))
    end do
  end do
  j = jts
  jm = jts
  if (config_flags%periodic_y) then
    jm = jts-1
  endif
  do i = its, itf
    g_muv(i,j) = 0.5*g_mu(i,j)+0.5*g_mu(i,jm)
    muv(i,j) = 0.5*(mu(i,j)+mu(i,jm))
  end do
else if (jts .ne. jds .and. jte .eq. jde) then
  do j = jts, jtf-1
    do i = its, itf
      g_muv(i,j) = 0.5*g_mu(i,j-1)+0.5*g_mu(i,j)
      muv(i,j) = 0.5*(mu(i,j)+mu(i,j-1))
    end do
  end do
  j = jte
  jm = jte-1
  if (config_flags%periodic_y) then
    jm = jte
  endif
  do i = its, itf
    g_muv(i,j) = 0.5*g_mu(i,j-1)+0.5*g_mu(i,jm)
    muv(i,j) = 0.5*(mu(i,j-1)+mu(i,jm))
  end do
else if (jts .eq. jds .and. jte .eq. jde) then
  do j = jts+1, jtf-1
    do i = its, itf
      g_muv(i,j) = 0.5*g_mu(i,j-1)+0.5*g_mu(i,j)
      muv(i,j) = 0.5*(mu(i,j)+mu(i,j-1))
    end do
  end do
  j = jts
  jm = jts
  if (config_flags%periodic_y) then
    jm = jts-1
  endif
  do i = its, itf
    g_muv(i,j) = 0.5*g_mu(i,j)+0.5*g_mu(i,jm)
    muv(i,j) = 0.5*(mu(i,j)+mu(i,jm))
  end do
  j = jte
  jm = jte-1
  if (config_flags%periodic_y) then
    jm = jte
  endif
  do i = its, itf
    g_muv(i,j) = 0.5*g_mu(i,j-1)+0.5*g_mu(i,jm)
    muv(i,j) = 0.5*(mu(i,j-1)+mu(i,jm))
  end do
endif

   call trace_exit("g_calc_mu_uv_1")

end subroutine g_calc_mu_uv_1


subroutine g_calc_p_rho_phi( moist, g_moist, n_moist, al, g_al, alb, mu, g_mu, muts, g_muts, ph, g_ph, p, g_p, pb, t, g_t, p0, t0, &
&dnw, rdnw, rdn, non_hydrostatic, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(out) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dnw(kms:kme)
real, intent(out) :: g_al(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: n_moist
real, intent(in) :: g_moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(in) :: g_mu(ims:ime,jms:jme)
real, intent(in) :: g_muts(ims:ime,jms:jme)
real, intent(out) :: g_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: muts(ims:ime,jms:jme)
logical, intent(in) :: non_hydrostatic
real, intent(out) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: p0
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t0

!==============================================
! declare local variables
!==============================================
real g_qf1
real g_qf2
real g_qtot
real g_qvf
integer i
integer ispe
integer itf
integer j
integer jtf
integer k
integer ktf
real qf1
real qf2
real qtot
real qvf
real walls(4),gwalls(ims:ime)

   call trace_entry("g_calc_p_rho_phi")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
itf = min(ite,ide-1)
jtf = min(jte,jde-1)
ktf = min(kte,kde-1)
if (non_hydrostatic) then
  if (n_moist .ge. param_first_scalar) then
    do j = jts, jtf
      do k = kts, ktf
        walls(4)=rdnw(k)
        gwalls(its:itf)=walls(4)*(ph(its:itf,k+1,j)-ph(its:itf,k,j))
        do i = its, itf
          g_qvf = g_moist(i,k,j,p_qv)*rvovrd
          qvf = 1.+rvovrd*moist(i,k,j,p_qv)

          al(i,k,j) = -(alb(i,k,j)*mu(i,j)+gwalls(i))/muts(i,j)
          g_al(i,k,j) = (-g_mu(i,j)*alb(i,k,j)-g_muts(i,j)*al(i,k,j)-(g_ph(i,k+1,j)-g_ph(i,k,j))*walls(4))/muts(i,j)

          walls(1)=p0*(al(i,k,j)+alb(i,k,j))
          walls(2)=r_d*(t0+t(i,k,j))*qvf/walls(1)
          walls(3)=walls(2)**(cpovcv-1)*p0

          g_p(i,k,j) = (-g_al(i,k,j)*p0*walls(2)+g_qvf*r_d*(t0+t(i,k,j))+g_t(i,k,j)*r_d*qvf)/walls(1)*cpovcv*walls(3)
          p(i,k,j) = walls(2)*walls(3)-pb(i,k,j)
        end do
      end do
    end do
  else
    do j = jts, jtf
      do k = kts, ktf
        walls(4)=rdnw(k)
        gwalls(its:itf)=walls(4)*(ph(its:itf,k+1,j)-ph(its:itf,k,j))
        do i = its, itf
          al(i,k,j) = -(alb(i,k,j)*mu(i,j)+gwalls(i))/muts(i,j)
          g_al(i,k,j) = (-g_mu(i,j)*alb(i,k,j)-g_muts(i,j)*al(i,k,j)-(g_ph(i,k+1,j)-g_ph(i,k,j))*walls(4))/muts(i,j)

          walls(1)=p0*(al(i,k,j)+alb(i,k,j))
          walls(2)=(r_d*(t0+t(i,k,j))/walls(1))
          walls(3)=walls(2)**(cpovcv-1)

          g_p(i,k,j) = (-(g_al(i,k,j)*p0*r_d*(t0+t(i,k,j))*p0/(walls(1)*walls(1))*cpovcv*walls(3)))&
&+g_t(i,k,j)*p0*r_d/walls(1)*cpovcv*walls(3)
          p(i,k,j) = p0*walls(2)*walls(3)-pb(i,k,j)
        end do
      end do
    end do
  endif
else
  if (n_moist .ge. param_first_scalar) then
    do j = jts, jtf
      k = ktf
      do i = its, itf
        g_qtot = 0.
        qtot = 0.
        do ispe = param_first_scalar, n_moist
          g_qtot = g_moist(i,k,j,ispe)+g_qtot
          qtot = qtot+moist(i,k,j,ispe)
        end do
        g_qf2 = -(g_qtot/((1.+qtot)*(1.+qtot)))
        qf2 = 1./(1.+qtot)
        g_qf1 = g_qf2*qtot+g_qtot*qf2
        qf1 = qtot*qf2
        g_p(i,k,j) = (-(g_mu(i,j)*(0.5/rdnw(k)/qf2)))-g_muts(i,j)*(0.5*qf1/rdnw(k)/qf2)-g_qf1*(0.5*muts(i,j)/rdnw(k)/qf2)+g_qf2*&
&(0.5*(mu(i,j)+qf1*muts(i,j))/rdnw(k)/(qf2*qf2))
        p(i,k,j) = -(0.5*(mu(i,j)+qf1*muts(i,j))/rdnw(k)/qf2)
        g_qvf = g_moist(i,k,j,p_qv)*rvovrd
        qvf = 1.+rvovrd*moist(i,k,j,p_qv)
        g_al(i,k,j) = g_p(i,k,j)*r_d/p1000mb*(t(i,k,j)+t0)*qvf/p1000mb*cvpm*((p(i,k,j)+pb(i,k,j))/p1000mb)**(cvpm-1)+g_qvf*r_d/&
&p1000mb*(t(i,k,j)+t0)*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm+g_t(i,k,j)*r_d/p1000mb*qvf*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm
        al(i,k,j) = r_d/p1000mb*(t(i,k,j)+t0)*qvf*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm-alb(i,k,j)
      end do
      do k = ktf-1, kts, -1
        do i = its, itf
          g_qtot = 0.
          qtot = 0.
          do ispe = param_first_scalar, n_moist
            g_qtot = 0.5*g_moist(i,k+1,j,ispe)+0.5*g_moist(i,k,j,ispe)+g_qtot
            qtot = qtot+0.5*(moist(i,k,j,ispe)+moist(i,k+1,j,ispe))
          end do
          g_qf2 = -(g_qtot/((1.+qtot)*(1.+qtot)))
          qf2 = 1./(1.+qtot)
          g_qf1 = g_qf2*qtot+g_qtot*qf2
          qf1 = qtot*qf2
          g_p(i,k,j) = (-(g_mu(i,j)*(1/qf2/rdn(k+1))))-g_muts(i,j)*(qf1/qf2/rdn(k+1))+g_p(i,k+1,j)-g_qf1*(muts(i,j)/qf2/rdn(k+1))+&
&g_qf2*((mu(i,j)+qf1*muts(i,j))/(qf2*qf2)/rdn(k+1))
          p(i,k,j) = p(i,k+1,j)-(mu(i,j)+qf1*muts(i,j))/qf2/rdn(k+1)
          g_qvf = g_moist(i,k,j,p_qv)*rvovrd
          qvf = 1.+rvovrd*moist(i,k,j,p_qv)
          g_al(i,k,j) = g_p(i,k,j)*r_d/p1000mb*(t(i,k,j)+t0)*qvf/p1000mb*cvpm*((p(i,k,j)+pb(i,k,j))/p1000mb)**(cvpm-1)+g_qvf*r_d/&
&p1000mb*(t(i,k,j)+t0)*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm+g_t(i,k,j)*r_d/p1000mb*qvf*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm
          al(i,k,j) = r_d/p1000mb*(t(i,k,j)+t0)*qvf*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm-alb(i,k,j)
        end do
      end do
      do k = 2, ktf+1
        do i = its, itf
          g_ph(i,k,j) = (-(g_al(i,k-1,j)*dnw(k-1)*muts(i,j)))-g_mu(i,j)*dnw(k-1)*alb(i,k-1,j)-g_muts(i,j)*dnw(k-1)*al(i,k-1,j)+&
&g_ph(i,k-1,j)
          ph(i,k,j) = ph(i,k-1,j)-dnw(k-1)*(muts(i,j)*al(i,k-1,j)+mu(i,j)*alb(i,k-1,j))
        end do
      end do
    end do
  else
    do j = jts, jtf
      k = ktf
      do i = its, itf
        g_qtot = 0.
        qtot = 0.
        g_qf2 = -(g_qtot/((1.+qtot)*(1.+qtot)))
        qf2 = 1./(1.+qtot)
        g_qf1 = g_qf2*qtot+g_qtot*qf2
        qf1 = qtot*qf2
        g_p(i,k,j) = (-(g_mu(i,j)*(0.5/rdnw(k)/qf2)))-g_muts(i,j)*(0.5*qf1/rdnw(k)/qf2)-g_qf1*(0.5*muts(i,j)/rdnw(k)/qf2)+g_qf2*&
&(0.5*(mu(i,j)+qf1*muts(i,j))/rdnw(k)/(qf2*qf2))
        p(i,k,j) = -(0.5*(mu(i,j)+qf1*muts(i,j))/rdnw(k)/qf2)
        g_qvf = 0.
        qvf = 1.
        g_al(i,k,j) = g_p(i,k,j)*r_d/p1000mb*(t(i,k,j)+t0)*qvf/p1000mb*cvpm*((p(i,k,j)+pb(i,k,j))/p1000mb)**(cvpm-1)+g_qvf*r_d/&
&p1000mb*(t(i,k,j)+t0)*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm+g_t(i,k,j)*r_d/p1000mb*qvf*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm
        al(i,k,j) = r_d/p1000mb*(t(i,k,j)+t0)*qvf*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm-alb(i,k,j)
      end do
      do k = ktf-1, kts, -1
        do i = its, itf
          g_qtot = 0.
          qtot = 0.
          g_qf2 = -(g_qtot/((1.+qtot)*(1.+qtot)))
          qf2 = 1./(1.+qtot)
          g_qf1 = g_qf2*qtot+g_qtot*qf2
          qf1 = qtot*qf2
          g_p(i,k,j) = (-(g_mu(i,j)*(1/qf2/rdn(k+1))))-g_muts(i,j)*(qf1/qf2/rdn(k+1))+g_p(i,k+1,j)-g_qf1*(muts(i,j)/qf2/rdn(k+1))+&
&g_qf2*((mu(i,j)+qf1*muts(i,j))/(qf2*qf2)/rdn(k+1))
          p(i,k,j) = p(i,k+1,j)-(mu(i,j)+qf1*muts(i,j))/qf2/rdn(k+1)
          g_qvf = 0.
          qvf = 1.
          g_al(i,k,j) = g_p(i,k,j)*r_d/p1000mb*(t(i,k,j)+t0)*qvf/p1000mb*cvpm*((p(i,k,j)+pb(i,k,j))/p1000mb)**(cvpm-1)+g_qvf*r_d/&
&p1000mb*(t(i,k,j)+t0)*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm+g_t(i,k,j)*r_d/p1000mb*qvf*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm
          al(i,k,j) = r_d/p1000mb*(t(i,k,j)+t0)*qvf*((p(i,k,j)+pb(i,k,j))/p1000mb)**cvpm-alb(i,k,j)
        end do
      end do
      do k = 2, ktf+1
        do i = its, itf
          g_ph(i,k,j) = (-(g_al(i,k-1,j)*dnw(k-1)*muts(i,j)))-g_mu(i,j)*dnw(k-1)*alb(i,k-1,j)-g_muts(i,j)*dnw(k-1)*al(i,k-1,j)+&
&g_ph(i,k-1,j)
          ph(i,k,j) = ph(i,k-1,j)-dnw(k-1)*(muts(i,j)*al(i,k-1,j)+mu(i,j)*alb(i,k-1,j))
        end do
      end do
    end do
  endif
endif

   call trace_exit("g_calc_p_rho_phi")

end subroutine g_calc_p_rho_phi


subroutine g_calc_php( php, g_php, ph, g_ph, phb, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: g_ph(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_php(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: php(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer itf
integer j
integer jtf
integer k
integer ktf

   call trace_entry("g_calc_php")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------

itf = min(ite,ide-1)
jtf = min(jte,jde-1)
ktf = min(kte,kde-1)

!do j = jts, jtf
!  do k = kts, ktf
!    do i = its, itf
!      g_php(i,k,j) = 0.5*(g_ph(i,k+1,j)+g_ph(i,k,j))
!      php(i,k,j) = 0.5*(phb(i,k,j)+phb(i,k+1,j)+ph(i,k,j)+ph(i,k+1,j))
!    end do
!  end do
!end do
g_php(its:itf,kts:ktf,jts:jtf) = 0.5*g_ph(its:itf,kts+1:ktf+1,jts:jtf)+0.5*g_ph(its:itf,kts:ktf,jts:jtf)
php(its:itf,kts:ktf,jts:jtf) = 0.5*(phb(its:itf,kts:ktf,jts:jtf)+phb(its:itf,kts+1:ktf+1,jts:jtf)&
&+ph(its:itf,kts:ktf,jts:jtf)+ph(its:itf,kts+1:ktf+1,jts:jtf))

   call trace_exit("g_calc_php")

end subroutine g_calc_php


subroutine g_calc_ww_cp( u, g_u, v, g_v, mup, g_mup, mub, ww, g_ww, rdx, rdy, msft, msfu, msfv, dnw, ide, jde, kde, ims, ime, jms, &
&jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: dnw(kms:kme)
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_mup(ims:ime,jms:jme)
real, intent(in) :: g_u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_ww(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mub(ims:ime,jms:jme)
real, intent(in) :: mup(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(out) :: ww(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real divv(its:ite,kts:kte)
real dmdt(its:ite)
real g_divv(its:ite,kts:kte)
real g_dmdt(its:ite)
real g_muu(its:ite+1,jts:jte+1)
real g_muv(its:ite+1,jts:jte+1)
integer i
integer itf
integer j
integer jtf
integer k
integer ktf
real muu(its:ite+1,jts:jte+1)
real muv(its:ite+1,jts:jte+1)
real walls

   call trace_entry("g_calc_ww_cp")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
jtf = min(jte,jde-1)
ktf = min(kte,kde-1)
itf = min(ite,ide-1)
do j = jts, jtf
  do i = its, min(ite+1,ide)
    g_muu(i,j) = (g_mup(i-1,j)+g_mup(i,j))*(0.5/msfu(i,j))
    muu(i,j) = 0.5*(mup(i,j)+mub(i,j)+mup(i-1,j)+mub(i-1,j))/msfu(i,j)
  end do
end do
do j = jts, min(jte+1,jde)
  do i = its, itf
    g_muv(i,j) = (g_mup(i,j-1)+g_mup(i,j))*(0.5/msfv(i,j))
    muv(i,j) = 0.5*(mup(i,j)+mub(i,j)+mup(i,j-1)+mub(i,j-1))/msfv(i,j)
  end do
end do
do j = jts, jtf
  do i = its, ite
    g_dmdt(i) = 0.
    dmdt(i) = 0.
    g_ww(i,1,j) = 0.
    ww(i,1,j) = 0.
    g_ww(i,kte,j) = 0.
    ww(i,kte,j) = 0.
  end do
  do k = kts, ktf
    do i = its, itf
      walls=msft(i,j)*dnw(k)
      g_divv(i,k) = walls*(g_muu(i+1,j)*rdx*u(i+1,k,j)-g_muu(i,j)*rdx*u(i,k,j)+g_muv(i,j+1)*rdy*v(i,k,j+1)&
&-g_muv(i,j)*rdy*v(i,k,j)+g_u(i+1,k,j)*rdx*muu(i+1,j)-g_u(i,k,j)*&
&rdx*muu(i,j)+g_v(i,k,j+1)*rdy*muv(i,j+1)-g_v(i,k,j)*rdy*muv(i,j))

      divv(i,k) = walls*(rdx*(muu(i+1,j)*u(i+1,k,j)-muu(i,j)*u(i,k,j))+rdy*(muv(i,j+1)*v(i,k,j+1)-muv(i,j)*v(i,k,j)))
    end do
    g_dmdt(its:itf) = g_divv(its:itf,k)+g_dmdt(its:itf)
    dmdt(its:itf) = dmdt(its:itf)+divv(its:itf,k)
  end do
  do k = 2, ktf
    do i = its, itf
      g_ww(i,k,j) = (-g_divv(i,k-1))-g_dmdt(i)*dnw(k-1)+g_ww(i,k-1,j)
      ww(i,k,j) = ww(i,k-1,j)-dnw(k-1)*dmdt(i)-divv(i,k-1)
    end do
  end do
end do

   call trace_exit("g_calc_ww_cp")

end subroutine g_calc_ww_cp


subroutine g_calculate_full( rfield, g_rfield, rfieldb, rfieldp, g_rfieldp, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, &
&jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(out) :: g_rfield(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rfieldp(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(out) :: rfield(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rfieldb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rfieldp(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer itf
integer j
integer jtf
integer k
integer ktf

   call trace_entry("g_calculate_full")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
itf = min(ite,ide-1)
jtf = min(jte,jde-1)
ktf = min(kte,kde-1)

!do j = jts, jtf
!  do k = kts, ktf
!    do i = its, itf
!      g_rfield(i,k,j) = g_rfieldp(i,k,j)
!      rfield(i,k,j) = rfieldb(i,k,j)+rfieldp(i,k,j)
!    end do
!  end do
!end do

g_rfield(its:itf,kts:ktf,jts:jtf) = g_rfieldp(its:itf,kts:ktf,jts:jtf)
rfield(its:itf,kts:ktf,jts:jtf) = rfieldb(its:itf,kts:ktf,jts:jtf)+rfieldp(its:itf,kts:ktf,jts:jtf)

   call trace_exit("g_calculate_full")

end subroutine g_calculate_full


subroutine g_coriolis( ru, g_ru, rv, g_rv, rw, g_rw, ru_tend, g_ru_tend, rv_tend, g_rv_tend, rw_tend, g_rw_tend, config_flags, f, &
&e, sina, cosa, fzm, fzp, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: cosa(ims:ime,jms:jme)
real, intent(in) :: e(ims:ime,jms:jme)
real, intent(in) :: f(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
real, intent(in) :: g_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rw_tend(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: sina(ims:ime,jms:jme)
real walls(4),gwalls(ims:ime),kwalls(ims:ime)

!==============================================
! declare local variables
!==============================================
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
logical specified

   call trace_entry("g_coriolis")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
ktf = min(kte,kde-1)
i_start = its
i_end = ite
if (config_flags%open_xs .or. specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
if (config_flags%open_xe .or. specified .or. config_flags%nested) then
  i_end = min(ide-1,ite)
endif

do j = jts, min(jte,jde-1)
  do k = kts, ktf
    gwalls(i_start:i_end)=rw(i_start-1:i_end-1,k+1,j)+rw(i_start-1:i_end-1,k,j)+rw(i_start:i_end,k+1,j)+rw(i_start:i_end,k,j)
    kwalls(i_start:i_end)=rv(i_start-1:i_end-1,k,j+1)+rv(i_start:i_end,k,j+1)+rv(i_start-1:i_end-1,k,j)+rv(i_start:i_end,k,j)
    do i = i_start, i_end
      walls(1)=0.0625*(e(i,j)+e(i-1,j))*(cosa(i,j)+cosa(i-1,j))
      walls(2)=0.125*(f(i,j)+f(i-1,j))
      g_ru_tend(i,k,j) = g_ru_tend(i,k,j)&
&+(g_rv(i-1,k,j+1)+g_rv(i,k,j+1)+g_rv(i-1,k,j)+g_rv(i,k,j))*walls(2)&
&-(g_rw(i-1,k+1,j)+g_rw(i,k+1,j)+g_rw(i-1,k,j)+g_rw(i,k,j))*walls(1)
      ru_tend(i,k,j) = ru_tend(i,k,j)+walls(2)*kwalls(i)-walls(1)*gwalls(i)
    end do
  end do

  if (config_flags%open_xs .and. its .eq. ids) then
    do k = kts, ktf
      g_ru_tend(its,k,j) = g_ru_tend(its,k,j)+0.5*g_rv(its,k,j+1)*f(its,j)+0.5*g_rv(its,k,j)*f(its,j)-0.5*g_rw(its,k+1,j)*e(its,j)*&
&cosa(its,j)-0.5*g_rw(its,k,j)*e(its,j)*cosa(its,j)
      ru_tend(its,k,j) = ru_tend(its,k,j)+0.5*(f(its,j)+f(its,j))*0.25*(rv(its,k,j+1)+rv(its,k,j+1)+rv(its,k,j)+rv(its,k,j))-0.5*&
&(e(its,j)+e(its,j))*0.5*(cosa(its,j)+cosa(its,j))*0.25*(rw(its,k+1,j)+rw(its,k,j)+rw(its,k+1,j)+rw(its,k,j))
    end do
  endif

  if (config_flags%open_xe .and. ite .eq. ide) then
    do k = kts, ktf
      g_ru_tend(ite,k,j) = g_ru_tend(ite,k,j)+0.5*g_rv(ite-1,k,j+1)*f(ite-1,j)+0.5*g_rv(ite-1,k,j)*f(ite-1,j)-0.5*g_rw(ite-1,k+1,j)&
&*e(ite-1,j)*cosa(ite-1,j)-0.5*g_rw(ite-1,k,j)*e(ite-1,j)*cosa(ite-1,j)
      ru_tend(ite,k,j) = ru_tend(ite,k,j)+0.5*(f(ite-1,j)+f(ite-1,j))*0.25*(rv(ite-1,k,j+1)+rv(ite-1,k,j+1)+rv(ite-1,k,j)+rv(ite-1,&
&k,j))-0.5*(e(ite-1,j)+e(ite-1,j))*0.5*(cosa(ite-1,j)+cosa(ite-1,j))*0.25*(rw(ite-1,k+1,j)+rw(ite-1,k,j)+rw(ite-1,k+1,j)+&
&rw(ite-1,k,j))
    end do
  endif

end do

j_start = jts
j_end = jte
if (config_flags%open_ys .or. specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
if (config_flags%open_ye .or. specified .or. config_flags%nested) then
  j_end = min(jde-1,jte)
endif

if (config_flags%open_ys .and. jts .eq. jds) then
  do k = kts, ktf
    do i = its, min(ide-1,ite)
      g_rv_tend(i,k,jts) = (-(0.5*g_ru(i+1,k,jts)*f(i,jts)))-0.5*g_ru(i,k,jts)*f(i,jts)+g_rv_tend(i,k,jts)+0.5*g_rw(i,k+1,jts)*e(i,&
&jts)*sina(i,jts)+0.5*g_rw(i,k,jts)*e(i,jts)*sina(i,jts)
      rv_tend(i,k,jts) = rv_tend(i,k,jts)-0.5*(f(i,jts)+f(i,jts))*0.25*(ru(i,k,jts)+ru(i+1,k,jts)+ru(i,k,jts)+ru(i+1,k,jts))+0.5*&
&(e(i,jts)+e(i,jts))*0.5*(sina(i,jts)+sina(i,jts))*0.25*(rw(i,k+1,jts)+rw(i,k,jts)+rw(i,k+1,jts)+rw(i,k,jts))
    end do
  end do
endif

do j = j_start, j_end
  do k = kts, ktf
    gwalls(its:min(ide-1,ite))=rw(its:min(ide-1,ite),k+1,j-1)+rw(its:min(ide-1,ite),k,j-1)&
&+rw(its:min(ide-1,ite),k+1,j)+rw(its:min(ide-1,ite),k,j)
    kwalls(its:min(ide-1,ite))=ru(its:min(ide-1,ite),k,j)+ru(its+1:min(ide-1,ite)+1,k,j)&
&+ru(its:min(ide-1,ite),k,j-1)+ru(its+1:min(ide-1,ite)+1,k,j-1)
    do i = its, min(ide-1,ite)
      walls(1)=(e(i,j)+e(i,j-1))*(sina(i,j)+sina(i,j-1))
      walls(2)=0.125*(f(i,j)+f(i,j-1))
      g_rv_tend(i,k,j) = walls(2)*(-g_ru(i+1,k,j-1)-g_ru(i,k,j-1)-g_ru(i+1,k,j)-g_ru(i,k,j))+g_rv_tend(i,k,j)&
&+0.0625*walls(1)*(g_rw(i,k+1,j-1)+g_rw(i,k+1,j)+g_rw(i,k,j-1)+g_rw(i,k,j))
      rv_tend(i,k,j) = rv_tend(i,k,j)-walls(2)*kwalls(i)+0.25*walls(1)*0.25*gwalls(i)
    end do
  end do
end do

if (config_flags%open_ye .and. jte .eq. jde) then
  do k = kts, ktf
    do i = its, min(ide-1,ite)
      g_rv_tend(i,k,jte) = (-(0.5*g_ru(i+1,k,jte-1)*f(i,jte-1)))-0.5*g_ru(i,k,jte-1)*f(i,jte-1)+g_rv_tend(i,k,jte)+0.5*g_rw(i,k+1,&
&jte-1)*e(i,jte-1)*sina(i,jte-1)+0.5*g_rw(i,k,jte-1)*e(i,jte-1)*sina(i,jte-1)
      rv_tend(i,k,jte) = rv_tend(i,k,jte)-0.5*(f(i,jte-1)+f(i,jte-1))*0.25*(ru(i,k,jte-1)+ru(i+1,k,jte-1)+ru(i,k,jte-1)+ru(i+1,k,&
&jte-1))+0.5*(e(i,jte-1)+e(i,jte-1))*0.5*(sina(i,jte-1)+sina(i,jte-1))*0.25*(rw(i,k+1,jte-1)+rw(i,k,jte-1)+rw(i,k+1,jte-1)+&
&rw(i,k,jte-1))
    end do
  end do
endif

do j = jts, min(jte,jde-1)
  do k = kts+1, ktf
    walls(1)=fzp(k)
    walls(2)=fzm(k)
    do i = its, min(ite,ide-1)
      g_rw_tend(i,k,j) = 0.5*e(i,j)*(cosa(i,j)*((g_ru(i+1,k-1,j)+g_ru(i,k-1,j))*walls(1)+(g_ru(i+1,k,j)&
&+g_ru(i,k,j))*walls(2))-sina(i,j)*((g_rv(i,k-1,j+1)+g_rv(i,k-1,j))*walls(1)+(g_rv(i,k,j+1)&
&+g_rv(i,k,j))*walls(2)))+g_rw_tend(i,k,j)
    end do

    do i = its, min(ite,ide-1)
      rw_tend(i,k,j) = rw_tend(i,k,j)+e(i,j)*(cosa(i,j)*0.5*(walls(2)*(ru(i,k,j)+ru(i+1,k,j))+walls(1)*(ru(i,k-1,j)+ru(i+1,k-1,j)))-&
&sina(i,j)*0.5*(walls(2)*(rv(i,k,j)+rv(i,k,j+1))+walls(1)*(rv(i,k-1,j)+rv(i,k-1,j+1))))
    end do
  end do
end do

   call trace_exit("g_coriolis")

end subroutine g_coriolis


subroutine g_couple_momentum( muu, g_muu, ru, g_ru, u, g_u, msfu, muv, g_muv, rv, g_rv, v, g_v, msfv, mut, g_mut, rw, g_rw, w, g_w,&
& msft, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_mut(ims:ime,jms:jme)
real, intent(in) :: g_muu(ims:ime,jms:jme)
real, intent(in) :: g_muv(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(out) :: g_ru(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_rv(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_rw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_w(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
real, intent(out) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(out) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(out) :: rw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer itf
integer j
integer jtf
integer k
integer ktf

   call trace_entry("g_couple_momentum")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
ktf = min(kte,kde-1)
itf = ite
jtf = min(jte,jde-1)
do j = jts, jtf
  do k = kts, ktf
    do i = its, itf
      g_ru(i,k,j) = g_muu(i,j)*(u(i,k,j)/msfu(i,j))+g_u(i,k,j)*(muu(i,j)/msfu(i,j))
      ru(i,k,j) = u(i,k,j)*muu(i,j)/msfu(i,j)
    end do
  end do
end do
itf = min(ite,ide-1)
jtf = jte
do j = jts, jtf
  do k = kts, ktf
    do i = its, itf
      g_rv(i,k,j) = g_muv(i,j)*(v(i,k,j)/msfv(i,j))+g_v(i,k,j)*(muv(i,j)/msfv(i,j))
      rv(i,k,j) = v(i,k,j)*muv(i,j)/msfv(i,j)
    end do
  end do
end do
itf = min(ite,ide-1)
jtf = min(jte,jde-1)
do j = jts, jtf
  do k = kts, kte
    do i = its, itf
      g_rw(i,k,j) = (g_mut(i,j)*w(i,k,j)+g_w(i,k,j)*mut(i,j))/msft(i,j)
      rw(i,k,j) = w(i,k,j)*mut(i,j)/msft(i,j)
    end do
  end do
end do

   call trace_exit("g_couple_momentum")

end subroutine g_couple_momentum


subroutine g_curvature( ru, g_ru, rv, g_rv, rw, g_rw, u, g_u, v, g_v, ru_tend, g_ru_tend, rv_tend, g_rv_tend, rw_tend, g_rw_tend, &
&config_flags, msfu, msfv, fzm, fzp, rdx, rdy, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real g_vxgm(its-1:ite,kts:kte,jts-1:jte)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
logical specified
real vxgm(its-1:ite,kts:kte,jts-1:jte)
real walls(4),gwalls(ims:ime),kwalls(ims:ime),lwalls(ims:ime),pwalls(ims:ime)

   call trace_entry("g_curvature")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
ktf = min(kte,kde-1)
i_start = its-1
i_end = ite
j_start = jts-1
j_end = jte
if ((config_flags%open_xs .or. specified .or. config_flags%nested) .and. its .eq. ids) then
  i_start = its
endif
if ((config_flags%open_xe .or. specified .or. config_flags%nested) .and. ite .eq. ide) then
  i_end = ite-1
endif
if ((config_flags%open_ys .or. specified .or. config_flags%nested) .and. jts .eq. jds) then
  j_start = jts
endif
if ((config_flags%open_ye .or. specified .or. config_flags%nested) .and. jte .eq. jde) then
  j_end = jte-1
endif
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      walls(1)=0.5*(msfv(i,j+1)-msfv(i,j))*rdy
      walls(2)=0.5*(msfu(i+1,j)-msfu(i,j))*rdx
      g_vxgm(i,k,j) = (g_u(i+1,k,j)+g_u(i,k,j))*walls(1)-(g_v(i,k,j+1)+g_v(i,k,j))*walls(2)
      vxgm(i,k,j) = (u(i,k,j)+u(i+1,k,j))*walls(1)-(v(i,k,j)+v(i,k,j+1))*walls(2)
    end do
  end do
end do
if ((config_flags%open_xs .or. specified .or. config_flags%nested) .and. its .eq. ids) then
  do j = jts-1, jte
    do k = kts, ktf
      g_vxgm(its-1,k,j) = g_vxgm(its,k,j)
      vxgm(its-1,k,j) = vxgm(its,k,j)
    end do
  end do
endif
if ((config_flags%open_xe .or. specified .or. config_flags%nested) .and. ite .eq. ide) then
  do j = jts-1, jte
    do k = kts, ktf
      g_vxgm(ite,k,j) = g_vxgm(ite-1,k,j)
      vxgm(ite,k,j) = vxgm(ite-1,k,j)
    end do
  end do
endif
if ((config_flags%open_ys .or. specified .or. config_flags%nested) .and. jts .eq. jds) then
  do k = kts, ktf
    do i = its-1, ite
      g_vxgm(i,k,jts-1) = g_vxgm(i,k,jts)
      vxgm(i,k,jts-1) = vxgm(i,k,jts)
    end do
  end do
endif
if ((config_flags%open_ye .or. specified .or. config_flags%nested) .and. jte .eq. jde) then
  do k = kts, ktf
    do i = its-1, ite
      g_vxgm(i,k,jte) = g_vxgm(i,k,jte-1)
      vxgm(i,k,jte) = vxgm(i,k,jte-1)
    end do
  end do
endif
i_start = its
if (config_flags%open_xs .or. specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
if (config_flags%open_xe .or. specified .or. config_flags%nested) then
  i_end = min(ide-1,ite)
endif

do j = jts, min(jde-1,jte)
  do k = kts, ktf
    gwalls(i_start:i_end)=rw(i_start-1:i_end-1,k+1,j)+rw(i_start-1:i_end-1,k,j)+rw(i_start:i_end,k+1,j)+rw(i_start:i_end,k,j)
    kwalls(i_start:i_end)=rv(i_start-1:i_end-1,k,j+1)+rv(i_start:i_end,k,j+1)+rv(i_start-1:i_end-1,k,j)+rv(i_start:i_end,k,j)
    pwalls(i_start:i_end)=vxgm(i_start:i_end,k,j)+vxgm(i_start-1:i_end-1,k,j)
    do i = i_start, i_end
      g_ru_tend(i,k,j) = g_ru_tend(i,k,j)+(g_rv(i-1,k,j+1)+g_rv(i,k,j+1)+g_rv(i-1,k,j)+g_rv(i,k,j))*0.125*pwalls(i)&
&-(g_rw(i-1,k+1,j)+g_rw(i,k+1,j)+g_rw(i-1,k,j)+g_rw(i,k,j))*0.25*u(i,k,j)*reradius-0.25*g_u(i,k,j)*reradius*gwalls(i)&
&+(g_vxgm(i-1,k,j)+g_vxgm(i,k,j))*0.125*kwalls(i)
      ru_tend(i,k,j) = ru_tend(i,k,j)+0.5*pwalls(i)*0.25*kwalls(i)-u(i,k,j)*reradius*0.25*gwalls(i)
    end do
  end do
end do

j_start = jts
if (config_flags%open_ys .or. specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
if (config_flags%open_ye .or. specified .or. config_flags%nested) then
  j_end = min(jde-1,jte)
endif

do j = j_start, j_end
  do k = kts, ktf
    gwalls(its:min(ite,ide-1))=rw(its:min(ite,ide-1),k+1,j-1)+rw(its:min(ite,ide-1),k,j-1)&
&+rw(its:min(ite,ide-1),k+1,j)+rw(its:min(ite,ide-1),k,j)
    kwalls(its:min(ite,ide-1))=ru(its:min(ite,ide-1),k,j)+ru(its+1:min(ite,ide-1)+1,k,j)&
&+ru(its:min(ite,ide-1),k,j-1)+ru(its+1:min(ite,ide-1)+1,k,j-1)
    lwalls(its:min(ite,ide-1))=ru(its:min(ite,ide-1),k,j)+ru(its+1:min(ite,ide-1)+1,k,j)&
&+ru(its:min(ite,ide-1),k,j-1)+ru(its+1:min(ite,ide-1)+1,k,j-1)
    pwalls(its:min(ite,ide-1))=vxgm(its:min(ite,ide-1),k,j)+vxgm(its:min(ite,ide-1),k,j-1)
    do i = its, min(ite,ide-1)
      g_rv_tend(i,k,j) = (-g_ru(i+1,k,j-1)-g_ru(i,k,j-1)-g_ru(i+1,k,j)-g_ru(i,k,j))*0.125*pwalls(i)&
&+g_rv_tend(i,k,j)&
&+(g_rw(i,k+1,j-1)+g_rw(i,k+1,j)+g_rw(i,k,j-1)+g_rw(i,k,j))*0.25*v(i,k,j)*reradius+0.25*g_v(i,k,j)*reradius*gwalls(i)&
&-(g_vxgm(i,k,j-1)+g_vxgm(i,k,j))*0.125*lwalls(i)
      rv_tend(i,k,j) = rv_tend(i,k,j)-0.125*pwalls(i)*lwalls(i)+v(i,k,j)*reradius*0.25*gwalls(i)
    end do
  end do
end do

do j = jts, min(jte,jde-1)
  do k = max(2,kts), ktf
    walls(1)=fzp(k)
    walls(2)=fzm(k)
    gwalls(its:min(ite,ide-1))=walls(2)*(v(its:min(ite,ide-1),k,j)+v(its:min(ite,ide-1),k,j+1))&
&+ walls(1)*(v(its:min(ite,ide-1),k-1,j)+v(its:min(ite,ide-1),k-1,j+1))
    kwalls(its:min(ite,ide-1))=walls(2)*(ru(its:min(ite,ide-1),k,j)+ru(its+1:min(ite,ide-1)+1,k,j))&
&+ walls(1)*(ru(its:min(ite,ide-1),k-1,j)+ru(its+1:min(ite,ide-1)+1,k-1,j))
    lwalls(its:min(ite,ide-1))=walls(2)*(u(its:min(ite,ide-1),k,j)+u(its+1:min(ite,ide-1)+1,k,j))&
&+ walls(1)*(u(its:min(ite,ide-1),k-1,j)+u(its+1:min(ite,ide-1)+1,k-1,j))
    pwalls(its:min(ite,ide-1))=walls(2)*(rv(its:min(ite,ide-1),k,j)+rv(its:min(ite,ide-1),k,j+1))&
&+ walls(1)*(rv(its:min(ite,ide-1),k-1,j)+rv(its:min(ite,ide-1),k-1,j+1))
    do i = its, min(ite,ide-1)
      g_rw_tend(i,k,j) = g_rw_tend(i,k,j) +0.25*reradius*((g_ru(i+1,k-1,j)*walls(1)&
&+g_ru(i,k-1,j)*walls(1)+g_ru(i+1,k,j)*walls(2)+g_ru(i,k,j)*walls(2))*lwalls(i)&
&+(g_rv(i,k-1,j+1)*walls(1)+g_rv(i,k-1,j)*walls(1)+g_rv(i,k,j+1)*walls(2)+g_rv(i,k,j)*walls(2))*gwalls(i)&
&+(g_u(i+1,k-1,j)*walls(1)+g_u(i,k-1,j)*walls(1)+g_u(i+1,k,j)*walls(2)+g_u(i,k,j)*walls(2))*kwalls(i)&
&+(g_v(i,k-1,j+1)*walls(1)+g_v(i,k-1,j)*walls(1)+g_v(i,k,j+1)*walls(2)+g_v(i,k,j)*walls(2))*pwalls(i))

      rw_tend(i,k,j) = rw_tend(i,k,j)+0.25*reradius*(kwalls(i)*lwalls(i)+pwalls(i)*gwalls(i))
    end do
  end do
end do

   call trace_exit("g_curvature")

end subroutine g_curvature


subroutine g_diagnose_w( ph_tend, g_ph_tend, ph_new, g_ph_new, ph_old, g_ph_old, w, g_w, mu, g_mu, dt, u, g_u, v, g_v, ht, cf1, &
&cf2, cf3, rdx, rdy, msft, ide, jde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real, intent(in) :: cf1
real, intent(in) :: cf2
real, intent(in) :: cf3
real, intent(in) :: dt
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_mu(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: g_ph_new(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ph_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ht(ims:ime,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: ph_new(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(out) :: w(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer itf
integer j
integer jtf
integer k

   call trace_entry("g_diagnose_w")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
itf = min(ite,ide-1)
jtf = min(jte,jde-1)
do j = jts, jtf
  do i = its, itf
    g_w(i,1,j) = 0.5*g_u(i+1,3,j)*msft(i,j)*rdx*(ht(i+1,j)-ht(i,j))*cf3+0.5*g_u(i,3,j)*msft(i,j)*rdx*(ht(i,j)-ht(i,j-1))*cf3+0.5*&
&g_u(i+1,2,j)*msft(i,j)*rdx*(ht(i+1,j)-ht(i,j))*cf2+0.5*g_u(i,2,j)*msft(i,j)*rdx*(ht(i,j)-ht(i,j-1))*cf2+0.5*g_u(i+1,1,j)*&
&msft(i,j)*rdx*(ht(i+1,j)-ht(i,j))*cf1+0.5*g_u(i,1,j)*msft(i,j)*rdx*(ht(i,j)-ht(i,j-1))*cf1+0.5*g_v(i,3,j+1)*msft(i,j)*rdy*&
&(ht(i,j+1)-ht(i,j))*cf3+0.5*g_v(i,3,j)*msft(i,j)*rdy*(ht(i,j)-ht(i,j-1))*cf3+0.5*g_v(i,2,j+1)*msft(i,j)*rdy*(ht(i,j+1)-ht(i,j)&
&)*cf2+0.5*g_v(i,2,j)*msft(i,j)*rdy*(ht(i,j)-ht(i,j-1))*cf2+0.5*g_v(i,1,j+1)*msft(i,j)*rdy*(ht(i,j+1)-ht(i,j))*cf1+0.5*g_v(i,1,&
&j)*msft(i,j)*rdy*(ht(i,j)-ht(i,j-1))*cf1
    w(i,1,j) = msft(i,j)*(0.5*rdy*((ht(i,j+1)-ht(i,j))*(cf1*v(i,1,j+1)+cf2*v(i,2,j+1)+cf3*v(i,3,j+1))+(ht(i,j)-ht(i,j-1))*(cf1*v(i,&
&1,j)+cf2*v(i,2,j)+cf3*v(i,3,j)))+0.5*rdx*((ht(i+1,j)-ht(i,j))*(cf1*u(i+1,1,j)+cf2*u(i+1,2,j)+cf3*u(i+1,3,j))+(ht(i,j)-ht(i,j-&
&1))*(cf1*u(i,1,j)+cf2*u(i,2,j)+cf3*u(i,3,j))))
  end do
  do k = 2, kte
    do i = its, itf
      g_w(i,k,j) = g_mu(i,j)*(msft(i,j)*(ph_tend(i,k,j)/(mu(i,j)*mu(i,j)))/g)+g_ph_new(i,k,j)*(msft(i,j)/dt/g)-g_ph_old(i,k,j)*&
&(msft(i,j)/dt/g)-g_ph_tend(i,k,j)*(msft(i,j)/mu(i,j)/g)
      w(i,k,j) = msft(i,j)*((ph_new(i,k,j)-ph_old(i,k,j))/dt-ph_tend(i,k,j)/mu(i,j))/g
    end do
  end do
end do

   call trace_exit("g_diagnose_w")

end subroutine g_diagnose_w


subroutine g_horizontal_diffusion( name, field, g_field, tendency, g_tendency, mu, g_mu, config_flags, msfu, msfv, msft, xkmhd, &
&g_xkmhd, rdx, rdy, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mu(ims:ime,jms:jme)
real, intent(inout) :: g_tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_xkmhd(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mu(ims:ime,jms:jme)
character*(1), intent(in) :: name
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(inout) :: tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: xkmhd(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real g_mkrdxm
real g_mkrdxp
real g_mkrdym
real g_mkrdyp
real g_rcoup
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real mkrdxm
real mkrdxp
real mkrdym
real mkrdyp
real mrdx
real mrdy
real :: pr = 3.
real rcoup
logical specified
real walls(4),gwalls(ims:ime),kwalls(ims:ime)

   call trace_entry("g_horizontal_diffusion")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
ktf = min(kte,kde-1)
if (name .eq. 'u') then
  i_start = its
  i_end = ite
  j_start = jts
  j_end = min(jte,jde-1)
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-1,ite)
  endif
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-2,jte)
  endif
  do j = j_start, j_end
    do k = kts, ktf
      gwalls(i_start:i_end)=xkmhd(i_start:i_end,k,j)+xkmhd(i_start:i_end,k,j-1)&
&+xkmhd(i_start-1:i_end-1,k,j-1)+xkmhd(i_start-1:i_end-1,k,j)
      kwalls(i_start:i_end)=xkmhd(i_start:i_end,k,j)+xkmhd(i_start:i_end,k,j+1)&
&+xkmhd(i_start-1:i_end-1,k,j+1)+xkmhd(i_start-1:i_end-1,k,j)
      do i = i_start, i_end
        g_mkrdxm = g_xkmhd(i-1,k,j)*msft(i-1,j)*rdx
        mkrdxm = msft(i-1,j)*xkmhd(i-1,k,j)*rdx
        g_mkrdxp = g_xkmhd(i,k,j)*msft(i,j)*rdx
        mkrdxp = msft(i,j)*xkmhd(i,k,j)*rdx
        mrdx = msfu(i,j)*rdx

        walls(1)=0.125*(msfu(i,j)+msfu(i,j-1))*rdy
        g_mkrdym = walls(1)*(g_xkmhd(i-1,k,j-1)+g_xkmhd(i,k,j-1)+g_xkmhd(i-1,k,j)+g_xkmhd(i,k,j))
        mkrdym =   walls(1)*gwalls(i)

        g_mkrdyp = 0.125*g_xkmhd(i-1,k,j+1)*(msfu(i,j)+msfu(i,j+1))*rdy+0.125*g_xkmhd(i,k,j+1)*(msfu(i,j)+msfu(i,j+1))*rdy+0.125*&
&g_xkmhd(i-1,k,j)*(msfu(i,j)+msfu(i,j+1))*rdy+0.125*g_xkmhd(i,k,j)*(msfu(i,j)+msfu(i,j+1))*rdy
        mkrdyp = 0.5*(msfu(i,j)+msfu(i,j+1))*0.25*kwalls(i)*rdy

        mrdy = msfu(i,j)*rdy

        g_rcoup = 0.5*g_mu(i-1,j)+0.5*g_mu(i,j)
        rcoup = 0.5*(mu(i,j)+mu(i-1,j))

        walls(4) = mrdx*(mkrdxp*(field(i+1,k,j)-field(i,k,j))-mkrdxm*(field(i,k,j)-field(i-1,k,j)))&
&+mrdy*(mkrdyp*(field(i,k,j+1)-field(i,k,j))-mkrdym*(field(i,k,j)-field(i,k,j-1)))

        g_tendency(i,k,j) = g_field(i,k,j-1)*rcoup*mrdy*mkrdym+g_field(i,k,j+1)*rcoup*mrdy*mkrdyp+g_field(i-1,k,j)*rcoup*mrdx*&
&mkrdxm+g_field(i+1,k,j)*rcoup*mrdx*mkrdxp+g_field(i,k,j)*rcoup*((-(mrdx*(mkrdxp+mkrdxm)))-mrdy*(mkrdyp+mkrdym))-g_mkrdxm*&
&rcoup*mrdx*(field(i,k,j)-field(i-1,k,j))+g_mkrdxp*rcoup*mrdx*(field(i+1,k,j)-field(i,k,j))-g_mkrdym*rcoup*mrdy*(field(i,k,&
&j)-field(i,k,j-1))+g_mkrdyp*rcoup*mrdy*(field(i,k,j+1)-field(i,k,j))&
&+g_rcoup*walls(4)+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)+rcoup*walls(4)
      end do
    end do
  end do
else if (name .eq. 'v') then
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = jte
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-2,ite)
  endif
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-1,jte)
  endif

  do j = j_start, j_end
    do k = kts, ktf
      gwalls(i_start:i_end)=xkmhd(i_start:i_end,k,j)+xkmhd(i_start:i_end,k,j-1)&
&+xkmhd(i_start-1:i_end-1,k,j-1)+xkmhd(i_start-1:i_end-1,k,j)
      kwalls(i_start:i_end)=xkmhd(i_start:i_end,k,j)+xkmhd(i_start:i_end,k,j-1)&
&+xkmhd(i_start+1:i_end+1,k,j-1)+xkmhd(i_start+1:i_end+1,k,j)
      do i = i_start, i_end
        g_mkrdxm = 0.125*g_xkmhd(i-1,k,j-1)*(msfv(i,j)+msfv(i-1,j))*rdx+0.125*g_xkmhd(i,k,j-1)*(msfv(i,j)+msfv(i-1,j))*rdx+0.125*&
&g_xkmhd(i-1,k,j)*(msfv(i,j)+msfv(i-1,j))*rdx+0.125*g_xkmhd(i,k,j)*(msfv(i,j)+msfv(i-1,j))*rdx
        mkrdxm = 0.5*(msfv(i,j)+msfv(i-1,j))*0.25*gwalls(i)*rdx

        g_mkrdxp = 0.125*g_xkmhd(i+1,k,j-1)*(msfv(i,j)+msfv(i+1,j))*rdx+0.125*g_xkmhd(i,k,j-1)*(msfv(i,j)+msfv(i+1,j))*rdx+0.125*&
&g_xkmhd(i+1,k,j)*(msfv(i,j)+msfv(i+1,j))*rdx+0.125*g_xkmhd(i,k,j)*(msfv(i,j)+msfv(i+1,j))*rdx
        mkrdxp = 0.5*(msfv(i,j)+msfv(i+1,j))*0.25*kwalls(i)*rdx

        mrdx = msfv(i,j)*rdx
        g_mkrdym = g_xkmhd(i,k,j-1)*msft(i,j-1)*rdy
        mkrdym = msft(i,j-1)*xkmhd(i,k,j-1)*rdy
        g_mkrdyp = g_xkmhd(i,k,j)*msft(i,j)*rdy
        mkrdyp = msft(i,j)*xkmhd(i,k,j)*rdy
        mrdy = msfv(i,j)*rdy
        g_rcoup = 0.5*g_mu(i,j-1)+0.5*g_mu(i,j)
        rcoup = 0.5*(mu(i,j)+mu(i,j-1))
  
        walls(4)=mrdx*(mkrdxp*(field(i+1,k,j)-field(i,k,j))-mkrdxm*(field(i,k,j)-field(i-1,k,j)))+&
&mrdy*(mkrdyp*(field(i,k,j+1)-field(i,k,j))-mkrdym*(field(i,k,j)-field(i,k,j-1)))

        g_tendency(i,k,j) = g_field(i,k,j-1)*rcoup*mrdy*mkrdym+g_field(i,k,j+1)*rcoup*mrdy*mkrdyp+g_field(i-1,k,j)*rcoup*mrdx*&
&mkrdxm+g_field(i+1,k,j)*rcoup*mrdx*mkrdxp+g_field(i,k,j)*rcoup*((-(mrdx*(mkrdxp+mkrdxm)))-mrdy*(mkrdyp+mkrdym))-g_mkrdxm*&
&rcoup*mrdx*(field(i,k,j)-field(i-1,k,j))+g_mkrdxp*rcoup*mrdx*(field(i+1,k,j)-field(i,k,j))-g_mkrdym*rcoup*mrdy*(field(i,k,&
&j)-field(i,k,j-1))+g_mkrdyp*rcoup*mrdy*(field(i,k,j+1)-field(i,k,j))+g_rcoup*walls(4)+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)+rcoup*walls(4)
      end do
    end do
  end do
else if (name .eq. 'w') then
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-2,ite)
  endif
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-2,jte)
  endif
  do j = j_start, j_end
    do k = kts+1, ktf
      gwalls(i_start:i_end)=xkmhd(i_start:i_end,k,j)+xkmhd(i_start-1:i_end-1,k,j)&
&+xkmhd(i_start:i_end,k-1,j)+xkmhd(i_start-1:i_end-1,k-1,j)
      kwalls(i_start:i_end)=xkmhd(i_start+1:i_end+1,k,j)+xkmhd(i_start:i_end,k,j)&
&+xkmhd(i_start+1:i_end+1,k-1,j)+xkmhd(i_start:i_end,k-1,j)
      do i = i_start, i_end
        g_mkrdxm = 0.25*g_xkmhd(i-1,k-1,j)*msfu(i,j)*rdx+0.25*g_xkmhd(i,k-1,j)*msfu(i,j)*rdx+0.25*g_xkmhd(i-1,k,j)*msfu(i,j)*rdx+&
&0.25*g_xkmhd(i,k,j)*msfu(i,j)*rdx
        mkrdxm = msfu(i,j)*0.25*gwalls(i)*rdx

        g_mkrdxp = 0.25*g_xkmhd(i+1,k-1,j)*msfu(i+1,j)*rdx+0.25*g_xkmhd(i,k-1,j)*msfu(i+1,j)*rdx+0.25*g_xkmhd(i+1,k,j)*msfu(i+1,j)*&
&rdx+0.25*g_xkmhd(i,k,j)*msfu(i+1,j)*rdx
        mkrdxp = msfu(i+1,j)*0.25*kwalls(i)*rdx

        mrdx = msft(i,j)*rdx
        g_mkrdym = 0.25*g_xkmhd(i,k-1,j-1)*msfv(i,j)*rdy+0.25*g_xkmhd(i,k-1,j)*msfv(i,j)*rdy+0.25*g_xkmhd(i,k,j-1)*msfv(i,j)*rdy+&
&0.25*g_xkmhd(i,k,j)*msfv(i,j)*rdy
        mkrdym = msfv(i,j)*0.25*(xkmhd(i,k,j)+xkmhd(i,k,j-1)+xkmhd(i,k-1,j)+xkmhd(i,k-1,j-1))*rdy
        g_mkrdyp = 0.25*g_xkmhd(i,k-1,j+1)*msfv(i,j+1)*rdy+0.25*g_xkmhd(i,k-1,j)*msfv(i,j+1)*rdy+0.25*g_xkmhd(i,k,j+1)*msfv(i,j+1)*&
&rdy+0.25*g_xkmhd(i,k,j)*msfv(i,j+1)*rdy
        mkrdyp = msfv(i,j+1)*0.25*(xkmhd(i,k,j+1)+xkmhd(i,k,j)+xkmhd(i,k-1,j+1)+xkmhd(i,k-1,j))*rdy
        mrdy = msft(i,j)*rdy
        g_rcoup = g_mu(i,j)
        rcoup = 0.5*(mu(i,j)+mu(i,j))

        walls(4)=mrdx*(mkrdxp*(field(i+1,k,j)-field(i,k,j))-mkrdxm*(field(i,k,j)-field(i-1,k,j)))+&
&mrdy*(mkrdyp*(field(i,k,j+1)-field(i,k,j))-mkrdym*(field(i,k,j)-field(i,k,j-1)))

        g_tendency(i,k,j) = g_field(i,k,j-1)*rcoup*mrdy*mkrdym+g_field(i,k,j+1)*rcoup*mrdy*mkrdyp+g_field(i-1,k,j)*rcoup*mrdx*&
&mkrdxm+g_field(i+1,k,j)*rcoup*mrdx*mkrdxp+g_field(i,k,j)*rcoup*((-(mrdx*(mkrdxp+mkrdxm)))-mrdy*(mkrdyp+mkrdym))-g_mkrdxm*&
&rcoup*mrdx*(field(i,k,j)-field(i-1,k,j))+g_mkrdxp*rcoup*mrdx*(field(i+1,k,j)-field(i,k,j))-g_mkrdym*rcoup*mrdy*(field(i,k,&
&j)-field(i,k,j-1))+g_mkrdyp*rcoup*mrdy*(field(i,k,j+1)-field(i,k,j))+g_rcoup*walls(4)+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)+rcoup*walls(4)
      end do
    end do
  end do
else
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  if (config_flags%open_xs .or. specified) then
    i_start = max(ids+1,its)
  endif
  if (config_flags%open_xe .or. specified) then
    i_end = min(ide-2,ite)
  endif
  if (config_flags%open_ys .or. specified) then
    j_start = max(jds+1,jts)
  endif
  if (config_flags%open_ye .or. specified) then
    j_end = min(jde-2,jte)
  endif
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        g_mkrdxm = 0.5*g_xkmhd(i-1,k,j)*msfu(i,j)*rdx*pr+0.5*g_xkmhd(i,k,j)*msfu(i,j)*rdx*pr
        mkrdxm = msfu(i,j)*0.5*(xkmhd(i,k,j)+xkmhd(i-1,k,j))*rdx*pr

        g_mkrdxp = 0.5*g_xkmhd(i+1,k,j)*msfu(i+1,j)*rdx*pr+0.5*g_xkmhd(i,k,j)*msfu(i+1,j)*rdx*pr
        mkrdxp = msfu(i+1,j)*0.5*(xkmhd(i+1,k,j)+xkmhd(i,k,j))*rdx*pr

        mrdx = msft(i,j)*rdx
        g_mkrdym = 0.5*g_xkmhd(i,k,j-1)*msfv(i,j)*rdy*pr+0.5*g_xkmhd(i,k,j)*msfv(i,j)*rdy*pr

        mkrdym = msfv(i,j)*0.5*(xkmhd(i,k,j)+xkmhd(i,k,j-1))*rdy*pr
        g_mkrdyp = 0.5*g_xkmhd(i,k,j+1)*msfv(i,j+1)*rdy*pr+0.5*g_xkmhd(i,k,j)*msfv(i,j+1)*rdy*pr

        mkrdyp = msfv(i,j+1)*0.5*(xkmhd(i,k,j+1)+xkmhd(i,k,j))*rdy*pr
        mrdy = msft(i,j)*rdy
        g_rcoup = g_mu(i,j)
        rcoup = mu(i,j)

        walls(4)=mrdx*(mkrdxp*(field(i+1,k,j)-field(i,k,j))-mkrdxm*(field(i,k,j)-field(i-1,k,j)))+&
&mrdy*(mkrdyp*(field(i,k,j+1)-field(i,k,j))-mkrdym*(field(i,k,j)-field(i,k,j-1)))

        g_tendency(i,k,j) = g_field(i,k,j-1)*rcoup*mrdy*mkrdym+g_field(i,k,j+1)*rcoup*mrdy*mkrdyp+g_field(i-1,k,j)*rcoup*mrdx*&
&mkrdxm+g_field(i+1,k,j)*rcoup*mrdx*mkrdxp+g_field(i,k,j)*rcoup*((-(mrdx*(mkrdxp+mkrdxm)))-mrdy*(mkrdyp+mkrdym))-g_mkrdxm*&
&rcoup*mrdx*(field(i,k,j)-field(i-1,k,j))+g_mkrdxp*rcoup*mrdx*(field(i+1,k,j)-field(i,k,j))-g_mkrdym*rcoup*mrdy*(field(i,k,&
&j)-field(i,k,j-1))+g_mkrdyp*rcoup*mrdy*(field(i,k,j+1)-field(i,k,j))+g_rcoup*walls(4)+g_tendency(i,k,j)
        tendency(i,k,j) = tendency(i,k,j)+rcoup*walls(4)
      end do
    end do
  end do
endif

   call trace_exit("g_horizontal_diffusion")

end subroutine g_horizontal_diffusion


subroutine g_horizontal_diffusion_3dmp( field, g_field, tendency, g_tendency, mu, g_mu, config_flags, base_3d, msfu, msfv, msft, &
&xkmhd, g_xkmhd, rdx, rdy, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: base_3d(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mu(ims:ime,jms:jme)
real, intent(inout) :: g_tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_xkmhd(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(inout) :: tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: xkmhd(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real walls(4),gwalls(4,ims:ime)
real g_mkrdxm
real g_mkrdxp
real g_mkrdym
real g_mkrdyp
real g_rcoup
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real mkrdxm
real mkrdxp
real mkrdym
real mkrdyp
real mrdx
real mrdy
real :: pr = 3.
real rcoup
logical specified

   call trace_entry("g_horizontal_diffusion_3dmp")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
ktf = min(kte,kde-1)
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
if (config_flags%open_xs .or. specified) then
  i_start = max(ids+1,its)
endif
if (config_flags%open_xe .or. specified) then
  i_end = min(ide-2,ite)
endif
if (config_flags%open_ys .or. specified) then
  j_start = max(jds+1,jts)
endif
if (config_flags%open_ye .or. specified) then
  j_end = min(jde-2,jte)
endif
do j = j_start, j_end
  do k = kts, ktf
    gwalls(1,i_start:i_end)=field(i_start:i_end,k,j)-field(i_start-1:i_end-1,k,j)&
&-base_3d(i_start:i_end,k,j)+base_3d(i_start-1:i_end-1,k,j)
    gwalls(2,i_start:i_end)=field(i_start+1:i_end+1,k,j)-field(i_start:i_end,k,j)&
&-base_3d(i_start+1:i_end+1,k,j)+base_3d(i_start:i_end,k,j)
    gwalls(3,i_start:i_end)=field(i_start:i_end,k,j)-field(i_start:i_end,k,j-1)&
&-base_3d(i_start:i_end,k,j)+base_3d(i_start:i_end,k,j-1)
    gwalls(4,i_start:i_end)=field(i_start:i_end,k,j+1)-field(i_start:i_end,k,j)&
&-base_3d(i_start:i_end,k,j+1)+base_3d(i_start:i_end,k,j)

    do i = i_start, i_end
      walls(1)=0.5*msfu(i,j)*pr
      walls(2)=0.5*msfu(i+1,j)*pr

      g_mkrdxm = (g_xkmhd(i-1,k,j)+g_xkmhd(i,k,j))*walls(1)*rdx
      mkrdxm =   (xkmhd(i,k,j)+xkmhd(i-1,k,j))*walls(1)*rdx

      g_mkrdxp = (g_xkmhd(i+1,k,j)+g_xkmhd(i,k,j))*walls(2)*rdx
      mkrdxp = (xkmhd(i+1,k,j)+xkmhd(i,k,j))*walls(2)*rdx

      walls(1)=msft(i,j)*rdx

      g_mkrdym = (g_xkmhd(i,k,j-1)+g_xkmhd(i,k,j))*walls(1)*rdy
      mkrdym = (xkmhd(i,k,j)+xkmhd(i,k,j-1))*walls(1)*rdy

      g_mkrdyp = (g_xkmhd(i,k,j+1)+g_xkmhd(i,k,j))*walls(2)*rdy
      mkrdyp = (xkmhd(i,k,j+1)+xkmhd(i,k,j))*walls(2)*rdy

      walls(2)=msft(i,j)*rdy

!     g_rcoup = g_mu(i,j)
!     rcoup = mu(i,j)

      walls(3)=walls(1)*(mkrdxp*gwalls(2,i)-mkrdxm*gwalls(1,i))+walls(2)*(mkrdyp*gwalls(4,i)-mkrdym*gwalls(3,i))

      g_tendency(i,k,j) = mu(i,j)*(g_field(i,k,j-1)*walls(2)*mkrdym&
&+g_field(i,k,j+1)*walls(2)*mkrdyp&
&+g_field(i-1,k,j)*walls(1)*mkrdxm&
&+g_field(i+1,k,j)*walls(1)*mkrdxp&
&+g_field(i,k,j)*((-(walls(1)*(mkrdxp+mkrdxm)))-walls(2)*(mkrdyp+mkrdym))&
&-g_mkrdxm*walls(1)*gwalls(1,i)&
&+g_mkrdxp*walls(1)*gwalls(2,i)&
&-g_mkrdym*walls(2)*gwalls(3,i)&
&+g_mkrdyp*walls(2)*gwalls(4,i))&
&+g_mu(i,j)*walls(3)&
&+g_tendency(i,k,j)

      tendency(i,k,j) = tendency(i,k,j)+mu(i,j)*walls(3)
    end do
  end do
end do

   call trace_exit("g_horizontal_diffusion_3dmp")

end subroutine g_horizontal_diffusion_3dmp


subroutine g_horizontal_pressure_gradient( ru_tend, g_ru_tend, rv_tend, g_rv_tend, ph, g_ph, alt, g_alt, p, g_p, pb, al, g_al, php,&
& g_php, cqu, g_cqu, cqv, g_cqv, muu, g_muu, muv, g_muv, mu, g_mu, fnm, fnp, rdnw, cf1, cf2, cf3, rdx, rdy, config_flags, &
&non_hydrostatic, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cf1
real, intent(in) :: cf2
real, intent(in) :: cf3
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: cqu(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cqv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: fnm(kms:kme)
real, intent(in) :: fnp(kms:kme)
real, intent(in) :: g_al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_cqu(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_cqv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mu(ims:ime,jms:jme)
real, intent(in) :: g_muu(ims:ime,jms:jme)
real, intent(in) :: g_muv(ims:ime,jms:jme)
real, intent(in) :: g_p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_php(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rv_tend(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
logical, intent(in) :: non_hydrostatic
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: php(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(inout) :: ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rv_tend(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real dpn(ims:ime,kms:kme)
real dpx
real dpy
real g_dpn(ims:ime,kms:kme)
real g_dpx
real g_dpy
integer i
integer i_start
integer itf
integer j
integer j_start
integer jtf
integer k
integer ktf
logical specified
real walls(4), gwalls(ims:ime)

   call trace_entry("g_horizontal_pressure_gradient")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
itf = min(ite,ide-1)
jtf = jte
ktf = min(kte,kde-1)
i_start = its
j_start = jts
if ((config_flags%open_ys .or. specified .or. config_flags%nested) .and. jts .eq. jds) then
  j_start = jts+1
endif
if ((config_flags%open_ye .or. specified .or. config_flags%nested) .and. jte .eq. jde) then
  jtf = jtf-1
endif
do j = j_start, jtf
  if (non_hydrostatic) then
    k = 1
    do i = i_start, itf
      g_dpn(i,k) = 0.5*g_p(i,k+2,j-1)*cf3+0.5*g_p(i,k+2,j)*cf3+0.5*g_p(i,k+1,j-1)*cf2+0.5*g_p(i,k+1,j)*cf2+0.5*g_p(i,k,j-1)*cf1+&
&0.5*g_p(i,k,j)*cf1
    end do
    do i = i_start, itf
      dpn(i,k) = 0.5*(cf1*(p(i,k,j-1)+p(i,k,j))+cf2*(p(i,k+1,j-1)+p(i,k+1,j))+cf3*(p(i,k+2,j-1)+p(i,k+2,j)))
    end do
    do i = i_start, itf
      g_dpn(i,kde) = 0.
      dpn(i,kde) = 0.
    end do
    do k = 2, ktf
!     do i = i_start, itf
!       g_dpn(i,k) = 0.5*g_p(i,k-1,j-1)*fnp(k)+0.5*g_p(i,k-1,j)*fnp(k)+0.5*g_p(i,k,j-1)*fnm(k)+0.5*g_p(i,k,j)*fnm(k)
!       dpn(i,k) = 0.5*(fnm(k)*(p(i,k,j-1)+p(i,k,j))+fnp(k)*(p(i,k-1,j-1)+p(i,k-1,j)))
!     end do
      g_dpn(i_start:itf,k) = 0.5*g_p(i_start:itf,k-1,j-1)*fnp(k)+0.5*g_p(i_start:itf,k-1,j)*fnp(k)&
&+0.5*g_p(i_start:itf,k,j-1)*fnm(k)+0.5*g_p(i_start:itf,k,j)*fnm(k)
      dpn(i_start:itf,k) = 0.5*(fnm(k)*(p(i_start:itf,k,j-1)+p(i_start:itf,k,j))+fnp(k)*(p(i_start:itf,k-1,j-1)+p(i_start:itf,k-1,j)))
    end do
    do k = 1, ktf
      gwalls(i_start:itf)=ph(i_start:itf,k+1,j)-ph(i_start:itf,k+1,j-1)+ph(i_start:itf,k,j)-ph(i_start:itf,k,j-1)
      do i = i_start, itf
        walls(1)=alt(i,k,j)+alt(i,k,j-1)
        walls(2)=p(i,k,j)-p(i,k,j-1)
        walls(3)=pb(i,k,j)-pb(i,k,j-1)
        walls(4)=al(i,k,j)+al(i,k,j-1)
        dpy = 0.5*rdy*muv(i,j)*(gwalls(i)+walls(1)*walls(2)+walls(4)*walls(3))
        g_dpy = 0.5*rdy*muv(i,j)*(g_al(i,k,j-1)*walls(3)&
&+g_al(i,k,j)*walls(3)&
&+g_alt(i,k,j-1)*walls(2)&
&+g_alt(i,k,j)*walls(2)&
&-g_p(i,k,j-1)*walls(1)&
&+g_p(i,k,j)*walls(1)&
&-g_ph(i,k+1,j-1)&
&+g_ph(i,k+1,j)&
&-g_ph(i,k,j-1)&
&+g_ph(i,k,j))&
&+g_muv(i,j)*dpy/muv(i,j)

        walls(1)=php(i,k,j)-php(i,k,j-1)
        walls(2)=rdnw(k)*(dpn(i,k+1)-dpn(i,k))-0.5*(mu(i,j-1)+mu(i,j))

        g_dpy = g_dpn(i,k+1)*rdy*(php(i,k,j)-php(i,k,j-1))*rdnw(k)&
&-g_dpn(i,k)*rdy*(php(i,k,j)-php(i,k,j-1))*rdnw(k)&
&+g_dpy-0.5*g_mu(i,j-1)*rdy*(php(i,k,j)-php(i,k,j-1))&
&-0.5*g_mu(i,j)*rdy*(php(i,k,j)-php(i,k,j-1))&
&-(g_php(i,k,j-1)-g_php(i,k,j))*rdy*walls(2)

        dpy = dpy+rdy*(php(i,k,j)-php(i,k,j-1))*walls(2)

        g_rv_tend(i,k,j) = -g_cqv(i,k,j)*dpy-g_dpy*cqv(i,k,j)+g_rv_tend(i,k,j)
        rv_tend(i,k,j) = rv_tend(i,k,j)-cqv(i,k,j)*dpy
      end do
    end do

  else

    do k = 1, ktf
      gwalls(i_start:itf)=ph(i_start:itf,k+1,j)-ph(i_start:itf,k+1,j-1)+ph(i_start:itf,k,j)-ph(i_start:itf,k,j-1)
      do i = i_start, itf
        walls(1)=alt(i,k,j)+alt(i,k,j-1)
        walls(2)=p(i,k,j)-p(i,k,j-1)
        walls(3)=pb(i,k,j)-pb(i,k,j-1)
        walls(4)=al(i,k,j)+al(i,k,j-1)
        g_dpy = 0.5*g_al(i,k,j-1)*rdy*muv(i,j)*walls(3)+0.5*g_al(i,k,j)*rdy*muv(i,j)*walls(3)+0.5*&
&g_alt(i,k,j-1)*rdy*muv(i,j)*walls(2)+0.5*g_alt(i,k,j)*rdy*muv(i,j)*walls(2)+0.5*g_muv(i,j)*rdy*&
&(gwalls(i)+walls(1)*walls(2)+walls(4)*walls(3))&
&-0.5*g_p(i,k,j-1)*rdy*muv(i,j)*walls(1)+0.5*g_p(i,k,j)*rdy*muv(i,j)*walls(1)&
&-0.5*g_ph(i,k+1,j-1)*rdy*muv(i,j)+0.5*g_ph(i,k+1,j)*rdy*muv(i,j)-0.5*g_ph(i,k,j-1)*rdy*muv(i,j)+0.5*g_ph(i,k,&
&j)*rdy*muv(i,j)
        dpy = 0.5*rdy*muv(i,j)*(gwalls(i)+walls(1)*walls(2)+walls(4)*walls(3))
        g_rv_tend(i,k,j) = (-(g_cqv(i,k,j)*dpy))-g_dpy*cqv(i,k,j)+g_rv_tend(i,k,j)
        rv_tend(i,k,j) = rv_tend(i,k,j)-cqv(i,k,j)*dpy
      end do
    end do
  endif
end do
itf = ite
jtf = min(jte,jde-1)
ktf = min(kte,kde-1)
i_start = its
j_start = jts
if ((config_flags%open_xs .or. specified .or. config_flags%nested) .and. its .eq. ids) then
  i_start = its+1
endif
if ((config_flags%open_xe .or. specified .or. config_flags%nested) .and. ite .eq. ide) then
  itf = itf-1
endif
do j = j_start, jtf
  if (non_hydrostatic) then
    k = 1
    do i = i_start, itf
      g_dpn(i,k) = 0.5*g_p(i-1,k+2,j)*cf3+0.5*g_p(i,k+2,j)*cf3+0.5*g_p(i-1,k+1,j)*cf2+0.5*g_p(i,k+1,j)*cf2+0.5*g_p(i-1,k,j)*cf1+&
&0.5*g_p(i,k,j)*cf1
      dpn(i,k) = 0.5*(cf1*(p(i-1,k,j)+p(i,k,j))+cf2*(p(i-1,k+1,j)+p(i,k+1,j))+cf3*(p(i-1,k+2,j)+p(i,k+2,j)))
      g_dpn(i,kde) = 0.
      dpn(i,kde) = 0.
    end do
    do k = 2, ktf
!     do i = i_start, itf
!       g_dpn(i,k) = 0.5*g_p(i-1,k-1,j)*fnp(k)+0.5*g_p(i,k-1,j)*fnp(k)+0.5*g_p(i-1,k,j)*fnm(k)+0.5*g_p(i,k,j)*fnm(k)
!       dpn(i,k) = 0.5*(fnm(k)*(p(i-1,k,j)+p(i,k,j))+fnp(k)*(p(i-1,k-1,j)+p(i,k-1,j)))
!     end do
      g_dpn(i_start:itf,k) = 0.5*g_p(i_start-1:itf-1,k-1,j)*fnp(k)+0.5*g_p(i_start:itf,k-1,j)*fnp(k)&
&+0.5*g_p(i_start-1:itf-1,k,j)*fnm(k)+0.5*g_p(i_start:itf,k,j)*fnm(k)
      dpn(i_start:itf,k) = 0.5*(fnm(k)*(p(i_start-1:itf-1,k,j)+p(i_start:itf,k,j))&
&+fnp(k)*(p(i_start-1:itf-1,k-1,j)+p(i_start:itf,k-1,j)))
    end do
    do k = 1, ktf
      gwalls(i_start:itf)=ph(i_start:itf,k+1,j)-ph(i_start-1:itf-1,k+1,j)+ph(i_start:itf,k,j)-ph(i_start-1:itf-1,k,j)
      do i = i_start, itf
        dpx = 0.5*rdx*muu(i,j)*(gwalls(i)+(alt(i,k,j)+alt(i-1,k,j))*(p(i,k,j)-p(i-1,k,j))&
&+(al(i,k,j)+al(i-1,k,j))*(pb(i,k,j)-pb(i-1,k,j)))
        g_dpx = 0.5*rdx*muu(i,j)*((g_al(i-1,k,j)+g_al(i,k,j))*(pb(i,k,j)-pb(i-1,k,j))&
&+(g_alt(i-1,k,j)+g_alt(i,k,j))*(p(i,k,j)-p(i-1,k,j))&
&-(g_p(i-1,k,j)-g_p(i,k,j))*(alt(i,k,j)+alt(i-1,k,j))&
&-g_ph(i-1,k+1,j)+g_ph(i,k+1,j)-g_ph(i-1,k,j)+g_ph(i,k,j))&
&+g_muu(i,j)*dpx/muu(i,j)

        walls(1)=php(i,k,j)-php(i-1,k,j)
        walls(2)=rdnw(k)*(dpn(i,k+1)-dpn(i,k))
        walls(3)=rdx*(walls(2)-0.5*(mu(i-1,j)+mu(i,j)))

        g_dpx = (g_dpn(i,k+1)-g_dpn(i,k))*rdx*walls(1)*rdnw(k)&
&+g_dpx&
&-0.5*(g_mu(i-1,j)+g_mu(i,j))*rdx*walls(1)&
&-(g_php(i-1,k,j)-g_php(i,k,j))*walls(3)
        dpx = dpx+walls(1)*walls(3)

        g_ru_tend(i,k,j) = -g_cqu(i,k,j)*dpx-g_dpx*cqu(i,k,j)+g_ru_tend(i,k,j)
        ru_tend(i,k,j) = ru_tend(i,k,j)-cqu(i,k,j)*dpx
      end do
    end do

  else

    do k = 1, ktf
      gwalls(i_start:itf)=ph(i_start:itf,k+1,j)-ph(i_start-1:itf-1,k+1,j)+ph(i_start:itf,k,j)-ph(i_start-1:itf-1,k,j)
      do i = i_start, itf
        g_dpx = 0.5*g_al(i-1,k,j)*rdx*muu(i,j)*(pb(i,k,j)-pb(i-1,k,j))+0.5*g_al(i,k,j)*rdx*muu(i,j)*(pb(i,k,j)-pb(i-1,k,j))+0.5*&
&g_alt(i-1,k,j)*rdx*muu(i,j)*(p(i,k,j)-p(i-1,k,j))+0.5*g_alt(i,k,j)*rdx*muu(i,j)*(p(i,k,j)-p(i-1,k,j))+0.5*g_muu(i,j)*rdx*&
&(gwalls(i)+(alt(i,k,j)+alt(i-1,k,j))*(p(i,k,j)-p(i-1,k,j))+(al(i,k,j)+al(i-1,k,j))*&
&(pb(i,k,j)-pb(i-1,k,j)))-0.5*g_p(i-1,k,j)*rdx*muu(i,j)*(alt(i,k,j)+alt(i-1,k,j))+0.5*g_p(i,k,j)*rdx*muu(i,j)*(alt(i,k,j)+alt(i-1,k,j))-0.5*g_ph(i-1,k+1,j)*rdx*muu(i,j)+0.5*g_ph(i,k+1,j)*rdx*muu(i,j)-0.5*g_ph(i-1,k,j)*rdx*muu(i,j)+0.5*g_ph(i,k,&
&j)*rdx*muu(i,j)
        dpx = 0.5*rdx*muu(i,j)*(gwalls(i)+(alt(i,k,j)+alt(i-1,k,j))*(p(i,k,j)-p(i-1,k,j))+&
&(al(i,k,j)+al(i-1,k,j))*(pb(i,k,j)-pb(i-1,k,j)))

        g_ru_tend(i,k,j) = (-(g_cqu(i,k,j)*dpx))-g_dpx*cqu(i,k,j)+g_ru_tend(i,k,j)
        ru_tend(i,k,j) = ru_tend(i,k,j)-cqu(i,k,j)*dpx
      end do
    end do
  endif
end do

   call trace_exit("g_horizontal_pressure_gradient")

end subroutine g_horizontal_pressure_gradient


subroutine g_perturbation_coriolis( ru_in, g_ru_in, rv_in, g_rv_in, rw, g_rw, ru_tend, g_ru_tend, rv_tend, g_rv_tend, rw_tend, &
&g_rw_tend, config_flags, u_base, v_base, z_base, muu, g_muu, muv, g_muv, phb, ph, g_ph, f, e, sina, cosa, fzm, fzp, ids, ide, jds,&
& jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: cosa(ims:ime,jms:jme)
real, intent(in) :: e(ims:ime,jms:jme)
real, intent(in) :: f(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
real, intent(in) :: g_muu(ims:ime,jms:jme)
real, intent(in) :: g_muv(ims:ime,jms:jme)
real, intent(in) :: g_ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ru_in(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rv_in(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rw_tend(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ru_in(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv_in(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: sina(ims:ime,jms:jme)
real, intent(in) :: u_base(kms:kme)
real, intent(in) :: v_base(kms:kme)
real, intent(in) :: z_base(kms:kme)

!==============================================
! declare local variables
!==============================================
real g_ru(ims:ime,kms:kme,jms:jme)
real g_rv(ims:ime,kms:kme,jms:jme)
real g_wk
real g_wkm1
real g_wkp1
real g_z_at_u
real g_z_at_v
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real ru(ims:ime,kms:kme,jms:jme)
real rv(ims:ime,kms:kme,jms:jme)
logical specified
real wk
real wkm1
real wkp1
real z_at_u
real z_at_v
real walls(4),gwalls(ims:ime),kwalls(ims:ime)

   call trace_entry("g_perturbation_coriolis")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
ktf = min(kte,kde-1)
i_start = its
i_end = ite
if (config_flags%open_xs .or. specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
if (config_flags%open_xe .or. specified .or. config_flags%nested) then
  i_end = min(ide-1,ite)
endif

do j = jts, min(jte,jde-1)+1
  do k = kts+1, ktf-1
    do i = i_start-1, i_end
      g_z_at_v = (g_ph(i,k+1,j-1)+g_ph(i,k+1,j)+g_ph(i,k,j-1)+g_ph(i,k,j))*(0.25/g)
      z_at_v = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i,k,j-1)+phb(i,k+1,j-1)+ph(i,k,j)+ph(i,k+1,j)+ph(i,k,j-1)+ph(i,k+1,j-1))/g
      g_wkp1 = g_z_at_v*(0.5-sign(0.5,max(0.,z_at_v-z_base(k))/(z_base(k+1)-z_base(k))-1.))*((0.5-sign(0.5,0.-(z_at_v-z_base(k))))/&
&(z_base(k+1)-z_base(k)))
      wkp1 = min(1.,max(0.,z_at_v-z_base(k))/(z_base(k+1)-z_base(k)))
      g_wkm1 = -(g_z_at_v*(0.5-sign(0.5,max(0.,z_base(k)-z_at_v)/(z_base(k)-z_base(k-1))-1.))*((0.5-sign(0.5,0.-(z_base(k)-z_at_v))&
&)/(z_base(k)-z_base(k-1))))
      wkm1 = min(1.,max(0.,z_base(k)-z_at_v)/(z_base(k)-z_base(k-1)))
      g_wk = (-g_wkm1)-g_wkp1
      wk = 1.-wkp1-wkm1
      g_rv(i,k,j) = (-(g_muv(i,j)*(wkm1*v_base(k-1)+wk*v_base(k)+wkp1*v_base(k+1))))+g_rv_in(i,k,j)-g_wk*muv(i,j)*v_base(k)-g_wkm1*&
&muv(i,j)*v_base(k-1)-g_wkp1*muv(i,j)*v_base(k+1)
      rv(i,k,j) = rv_in(i,k,j)-muv(i,j)*(wkm1*v_base(k-1)+wk*v_base(k)+wkp1*v_base(k+1))
    end do
  end do
end do
do j = jts, min(jte,jde-1)+1
  do i = i_start-1, i_end
    k = kts
    g_z_at_v = (g_ph(i,k+1,j-1)+g_ph(i,k+1,j)+g_ph(i,k,j-1)+g_ph(i,k,j))*(0.25/g)
    z_at_v = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i,k,j-1)+phb(i,k+1,j-1)+ph(i,k,j)+ph(i,k+1,j)+ph(i,k,j-1)+ph(i,k+1,j-1))/g
    g_wkp1 = g_z_at_v*(0.5-sign(0.5,max(0.,z_at_v-z_base(k))/(z_base(k+1)-z_base(k))-1.))*((0.5-sign(0.5,0.-(z_at_v-z_base(k))))/&
&(z_base(k+1)-z_base(k)))
    wkp1 = min(1.,max(0.,z_at_v-z_base(k))/(z_base(k+1)-z_base(k)))
    g_wk = -g_wkp1
    wk = 1.-wkp1
    g_rv(i,k,j) = (-(g_muv(i,j)*(wk*v_base(k)+wkp1*v_base(k+1))))+g_rv_in(i,k,j)-g_wk*muv(i,j)*v_base(k)-g_wkp1*muv(i,j)*v_base(k+1)
    rv(i,k,j) = rv_in(i,k,j)-muv(i,j)*(wk*v_base(k)+wkp1*v_base(k+1))
    k = ktf
    g_z_at_v = (g_ph(i,k+1,j-1)+g_ph(i,k+1,j)+g_ph(i,k,j-1)+g_ph(i,k,j))*(0.25/g)
    z_at_v = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i,k,j-1)+phb(i,k+1,j-1)+ph(i,k,j)+ph(i,k+1,j)+ph(i,k,j-1)+ph(i,k+1,j-1))/g
    g_wkm1 = -(g_z_at_v*(0.5-sign(0.5,max(0.,z_base(k)-z_at_v)/(z_base(k)-z_base(k-1))-1.))*((0.5-sign(0.5,0.-(z_base(k)-z_at_v)))/&
&(z_base(k)-z_base(k-1))))
    wkm1 = min(1.,max(0.,z_base(k)-z_at_v)/(z_base(k)-z_base(k-1)))
    g_wk = -g_wkm1
    wk = 1.-wkm1
    g_rv(i,k,j) = (-(g_muv(i,j)*(wkm1*v_base(k-1)+wk*v_base(k))))+g_rv_in(i,k,j)-g_wk*muv(i,j)*v_base(k)-g_wkm1*muv(i,j)*v_base(k-1)
    rv(i,k,j) = rv_in(i,k,j)-muv(i,j)*(wkm1*v_base(k-1)+wk*v_base(k))
  end do
end do
do j = jts, min(jte,jde-1)
  do k = kts, ktf
    gwalls(i_start:i_end)=rw(i_start-1:i_end-1,k+1,j)+rw(i_start-1:i_end-1,k,j)+rw(i_start:i_end,k+1,j)+rw(i_start:i_end,k,j)
    kwalls(i_start:i_end)=rv(i_start-1:i_end-1,k,j+1)+rv(i_start:i_end,k,j+1)+rv(i_start-1:i_end-1,k,j)+rv(i_start:i_end,k,j)
    do i = i_start, i_end
      walls(1)=(e(i,j)+e(i-1,j))*(cosa(i,j)+cosa(i-1,j))
      walls(2)=f(i,j)+f(i-1,j)
      g_ru_tend(i,k,j) = g_ru_tend(i,k,j)+0.125*g_rv(i-1,k,j+1)*walls(2)+0.125*g_rv(i,k,j+1)*walls(2)+0.125*&
&g_rv(i-1,k,j)*walls(2)+0.125*g_rv(i,k,j)*walls(2)-0.0625*g_rw(i-1,k+1,j)*walls(1)&
&-0.0625*g_rw(i,k+1,j)*walls(1)-0.0625*g_rw(i-1,k,j)*walls(1)-0.0625*g_rw(i,k,j)*walls(1)
      ru_tend(i,k,j) = ru_tend(i,k,j)+0.5*walls(2)*0.25*kwalls(i)-0.25*walls(1)*0.25*gwalls(i)
    end do
  end do
  if (config_flags%open_xs .and. its .eq. ids) then
    do k = kts, ktf
      g_ru_tend(its,k,j) = g_ru_tend(its,k,j)+0.5*g_rv(its,k,j+1)*f(its,j)+0.5*g_rv(its,k,j)*f(its,j)-0.5*g_rw(its,k+1,j)*e(its,j)*&
&cosa(its,j)-0.5*g_rw(its,k,j)*e(its,j)*cosa(its,j)
      ru_tend(its,k,j) = ru_tend(its,k,j)+0.5*(f(its,j)+f(its,j))*0.25*(rv(its,k,j+1)+rv(its,k,j+1)+rv(its,k,j)+rv(its,k,j))-0.5*&
&(e(its,j)+e(its,j))*0.5*(cosa(its,j)+cosa(its,j))*0.25*(rw(its,k+1,j)+rw(its,k,j)+rw(its,k+1,j)+rw(its,k,j))
    end do
  endif
  if (config_flags%open_xe .and. ite .eq. ide) then
    do k = kts, ktf
      g_ru_tend(ite,k,j) = g_ru_tend(ite,k,j)+0.5*g_rv(ite-1,k,j+1)*f(ite-1,j)+0.5*g_rv(ite-1,k,j)*f(ite-1,j)-0.5*g_rw(ite-1,k+1,j)&
&*e(ite-1,j)*cosa(ite-1,j)-0.5*g_rw(ite-1,k,j)*e(ite-1,j)*cosa(ite-1,j)
      ru_tend(ite,k,j) = ru_tend(ite,k,j)+0.5*(f(ite-1,j)+f(ite-1,j))*0.25*(rv(ite-1,k,j+1)+rv(ite-1,k,j+1)+rv(ite-1,k,j)+rv(ite-1,&
&k,j))-0.5*(e(ite-1,j)+e(ite-1,j))*0.5*(cosa(ite-1,j)+cosa(ite-1,j))*0.25*(rw(ite-1,k+1,j)+rw(ite-1,k,j)+rw(ite-1,k+1,j)+&
&rw(ite-1,k,j))
    end do
  endif
end do
j_start = jts
j_end = jte
if (config_flags%open_ys .or. specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
if (config_flags%open_ye .or. specified .or. config_flags%nested) then
  j_end = min(jde-1,jte)
endif
do j = j_start-1, j_end
  do k = kts+1, ktf-1
    do i = its, min(ite,ide-1)+1
      g_z_at_u = (g_ph(i-1,k+1,j)+g_ph(i,k+1,j)+g_ph(i-1,k,j)+g_ph(i,k,j))*(0.25/g)
      z_at_u = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i-1,k,j)+phb(i-1,k+1,j)+ph(i,k,j)+ph(i,k+1,j)+ph(i-1,k,j)+ph(i-1,k+1,j))/g
      g_wkp1 = g_z_at_u*(0.5-sign(0.5,max(0.,z_at_u-z_base(k))/(z_base(k+1)-z_base(k))-1.))*((0.5-sign(0.5,0.-(z_at_u-z_base(k))))/&
&(z_base(k+1)-z_base(k)))
      wkp1 = min(1.,max(0.,z_at_u-z_base(k))/(z_base(k+1)-z_base(k)))
      g_wkm1 = -(g_z_at_u*(0.5-sign(0.5,max(0.,z_base(k)-z_at_u)/(z_base(k)-z_base(k-1))-1.))*((0.5-sign(0.5,0.-(z_base(k)-z_at_u))&
&)/(z_base(k)-z_base(k-1))))
      wkm1 = min(1.,max(0.,z_base(k)-z_at_u)/(z_base(k)-z_base(k-1)))
      g_wk = (-g_wkm1)-g_wkp1
      wk = 1.-wkp1-wkm1
      g_ru(i,k,j) = (-(g_muu(i,j)*(wkm1*u_base(k-1)+wk*u_base(k)+wkp1*u_base(k+1))))+g_ru_in(i,k,j)-g_wk*muu(i,j)*u_base(k)-g_wkm1*&
&muu(i,j)*u_base(k-1)-g_wkp1*muu(i,j)*u_base(k+1)
      ru(i,k,j) = ru_in(i,k,j)-muu(i,j)*(wkm1*u_base(k-1)+wk*u_base(k)+wkp1*u_base(k+1))
    end do
  end do
end do
do j = j_start-1, j_end
  do i = its, min(ite,ide-1)+1
    k = kts
    g_z_at_u = (g_ph(i-1,k+1,j)+g_ph(i,k+1,j)+g_ph(i-1,k,j)+g_ph(i,k,j))*(0.25/g)
    z_at_u = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i-1,k,j)+phb(i-1,k+1,j)+ph(i,k,j)+ph(i,k+1,j)+ph(i-1,k,j)+ph(i-1,k+1,j))/g
    g_wkp1 = g_z_at_u*(0.5-sign(0.5,max(0.,z_at_u-z_base(k))/(z_base(k+1)-z_base(k))-1.))*((0.5-sign(0.5,0.-(z_at_u-z_base(k))))/&
&(z_base(k+1)-z_base(k)))
    wkp1 = min(1.,max(0.,z_at_u-z_base(k))/(z_base(k+1)-z_base(k)))
    g_wk = -g_wkp1
    wk = 1.-wkp1
    g_ru(i,k,j) = (-(g_muu(i,j)*(wk*u_base(k)+wkp1*u_base(k+1))))+g_ru_in(i,k,j)-g_wk*muu(i,j)*u_base(k)-g_wkp1*muu(i,j)*u_base(k+1)
    ru(i,k,j) = ru_in(i,k,j)-muu(i,j)*(wk*u_base(k)+wkp1*u_base(k+1))
    k = ktf
    g_z_at_u = (g_ph(i-1,k+1,j)+g_ph(i,k+1,j)+g_ph(i-1,k,j)+g_ph(i,k,j))*(0.25/g)
    z_at_u = 0.25*(phb(i,k,j)+phb(i,k+1,j)+phb(i-1,k,j)+phb(i-1,k+1,j)+ph(i,k,j)+ph(i,k+1,j)+ph(i-1,k,j)+ph(i-1,k+1,j))/g
    g_wkm1 = -(g_z_at_u*(0.5-sign(0.5,max(0.,z_base(k)-z_at_u)/(z_base(k)-z_base(k-1))-1.))*((0.5-sign(0.5,0.-(z_base(k)-z_at_u)))/&
&(z_base(k)-z_base(k-1))))
    wkm1 = min(1.,max(0.,z_base(k)-z_at_u)/(z_base(k)-z_base(k-1)))
    g_wk = -g_wkm1
    wk = 1.-wkm1
    g_ru(i,k,j) = (-(g_muu(i,j)*(wkm1*u_base(k-1)+wk*u_base(k))))+g_ru_in(i,k,j)-g_wk*muu(i,j)*u_base(k)-g_wkm1*muu(i,j)*u_base(k-1)
    ru(i,k,j) = ru_in(i,k,j)-muu(i,j)*(wkm1*u_base(k-1)+wk*u_base(k))
  end do
end do
if (config_flags%open_ys .and. jts .eq. jds) then
  do k = kts, ktf
    do i = its, min(ide-1,ite)
      g_rv_tend(i,k,jts) = (-(0.5*g_ru(i+1,k,jts)*f(i,jts)))-0.5*g_ru(i,k,jts)*f(i,jts)+g_rv_tend(i,k,jts)+0.5*g_rw(i,k+1,jts)*e(i,&
&jts)*sina(i,jts)+0.5*g_rw(i,k,jts)*e(i,jts)*sina(i,jts)
      rv_tend(i,k,jts) = rv_tend(i,k,jts)-0.5*(f(i,jts)+f(i,jts))*0.25*(ru(i,k,jts)+ru(i+1,k,jts)+ru(i,k,jts)+ru(i+1,k,jts))+0.5*&
&(e(i,jts)+e(i,jts))*0.5*(sina(i,jts)+sina(i,jts))*0.25*(rw(i,k+1,jts)+rw(i,k,jts)+rw(i,k+1,jts)+rw(i,k,jts))
    end do
  end do
endif
do j = j_start, j_end
  do k = kts, ktf
    gwalls(its:min(ite,ide-1))=rw(its:min(ite,ide-1),k+1,j-1)+rw(its:min(ite,ide-1),k,j-1)&
&+rw(its:min(ite,ide-1),k+1,j)+rw(its:min(ite,ide-1),k,j)
    kwalls(its:min(ite,ide-1))=ru(its:min(ite,ide-1),k,j)+ru(its+1:min(ite,ide-1)+1,k,j)&
&+ru(its:min(ite,ide-1),k,j-1)+ru(its+1:min(ite,ide-1)+1,k,j-1)
    do i = its, min(ide-1,ite)
      walls(1)=(e(i,j)+e(i,j-1))*(sina(i,j)+sina(i,j-1))
      g_rv_tend(i,k,j) = (-(0.125*g_ru(i+1,k,j-1)*(f(i,j)+f(i,j-1))))-0.125*g_ru(i,k,j-1)*(f(i,j)+f(i,j-1))-0.125*g_ru(i+1,k,j)*&
&(f(i,j)+f(i,j-1))-0.125*g_ru(i,k,j)*(f(i,j)+f(i,j-1))+g_rv_tend(i,k,j)+0.0625*g_rw(i,k+1,j-1)*walls(1)&
&+0.0625*g_rw(i,k+1,j)*walls(1)+0.0625*g_rw(i,k,j-1)*walls(1)+0.0625*g_rw(i,k,j)*walls(1)
      rv_tend(i,k,j) = rv_tend(i,k,j)-0.5*(f(i,j)+f(i,j-1))*0.25*kwalls(i)+0.25*walls(1)*0.25*gwalls(i)
    end do
  end do
end do
if (config_flags%open_ye .and. jte .eq. jde) then
  do k = kts, ktf
    do i = its, min(ide-1,ite)
      g_rv_tend(i,k,jte) = (-(0.5*g_ru(i+1,k,jte-1)*f(i,jte-1)))-0.5*g_ru(i,k,jte-1)*f(i,jte-1)+g_rv_tend(i,k,jte)+0.5*g_rw(i,k+1,&
&jte-1)*e(i,jte-1)*sina(i,jte-1)+0.5*g_rw(i,k,jte-1)*e(i,jte-1)*sina(i,jte-1)
      rv_tend(i,k,jte) = rv_tend(i,k,jte)-0.5*(f(i,jte-1)+f(i,jte-1))*0.25*(ru(i,k,jte-1)+ru(i+1,k,jte-1)+ru(i,k,jte-1)+ru(i+1,k,&
&jte-1))+0.5*(e(i,jte-1)+e(i,jte-1))*0.5*(sina(i,jte-1)+sina(i,jte-1))*0.25*(rw(i,k+1,jte-1)+rw(i,k,jte-1)+rw(i,k+1,jte-1)+&
&rw(i,k,jte-1))
    end do
  end do
endif
do j = jts, min(jte,jde-1)
  do k = kts+1, ktf
    do i = its, min(ite,ide-1)
      g_rw_tend(i,k,j) = 0.5*g_ru(i+1,k-1,j)*e(i,j)*cosa(i,j)*fzp(k)+0.5*g_ru(i,k-1,j)*e(i,j)*cosa(i,j)*fzp(k)+0.5*g_ru(i+1,k,j)*&
&e(i,j)*cosa(i,j)*fzm(k)+0.5*g_ru(i,k,j)*e(i,j)*cosa(i,j)*fzm(k)-0.5*g_rv(i,k-1,j+1)*e(i,j)*sina(i,j)*fzp(k)-0.5*g_rv(i,k-1,&
&j)*e(i,j)*sina(i,j)*fzp(k)-0.5*g_rv(i,k,j+1)*e(i,j)*sina(i,j)*fzm(k)-0.5*g_rv(i,k,j)*e(i,j)*sina(i,j)*fzm(k)+g_rw_tend(i,k,j)
      rw_tend(i,k,j) = rw_tend(i,k,j)+e(i,j)*(cosa(i,j)*0.5*(fzm(k)*(ru(i,k,j)+ru(i+1,k,j))+fzp(k)*(ru(i,k-1,j)+ru(i+1,k-1,j)))-&
&sina(i,j)*0.5*(fzm(k)*(rv(i,k,j)+rv(i,k,j+1))+fzp(k)*(rv(i,k-1,j)+rv(i,k-1,j+1))))
    end do
  end do
end do

   call trace_exit("g_perturbation_coriolis")

end subroutine g_perturbation_coriolis


subroutine g_pg_buoy_w( rw_tend, g_rw_tend, p, g_p, cqw, g_cqw, mu, g_mu, mub, rdnw, rdn, g, msft, ide, jde, kde, ims, ime, jms, &
&jme, kms, kme, its, ite, jts, jte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: cqw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g
real, intent(inout) :: g_cqw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mu(ims:ime,jms:jme)
real, intent(in) :: g_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rw_tend(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: mub(ims:ime,jms:jme)
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(inout) :: rw_tend(ims:ime,kms:kme,jms:jme)
real walls(4),gwalls(ims:ime)

!==============================================
! declare local variables
!==============================================
real cq1
real cq2
real g_cq1
real g_cq2
integer i
integer itf
integer j
integer jtf
integer k

   call trace_entry("g_pg_buoy_w")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
itf = min(ite,ide-1)
jtf = min(jte,jde-1)

do j = jts, jtf
  k = kde
  walls(2)=rdnw(k-1)
  do i = its, itf
    walls(1)=g/msft(i,j)
    g_cq1 = -(g_cqw(i,k-1,j)/((1.+cqw(i,k-1,j))*(1.+cqw(i,k-1,j))))
    cq1 = 1./(1.+cqw(i,k-1,j))
    g_cq2 = g_cq1*cqw(i,k-1,j)+g_cqw(i,k-1,j)*cq1
    cq2 = cqw(i,k-1,j)*cq1
    g_rw_tend(i,k,j) = (-(2*g_cq1*walls(1)*walls(2)*p(i,k-1,j)))-g_cq2*walls(1)*mub(i,j)-g_mu(i,j)*walls(1)-2*&
&g_p(i,k-1,j)*walls(1)*cq1*walls(2)+g_rw_tend(i,k,j)
    rw_tend(i,k,j) = rw_tend(i,k,j)+walls(1)*(cq1*2.*walls(2)*(-p(i,k-1,j))-mu(i,j)-cq2*mub(i,j))
  end do
  do k = 2, kde-1
    walls(2)=rdn(k)
    gwalls(its:itf)=rdn(k)*(p(its:itf,k,j)-p(its:itf,k-1,j))
    do i = its, itf
      walls(1)=g/msft(i,j)
      g_cq1 = -(g_cqw(i,k,j)/((1.+cqw(i,k,j))*(1.+cqw(i,k,j))))
      cq1 = 1./(1.+cqw(i,k,j))
      g_cq2 = g_cq1*cqw(i,k,j)+g_cqw(i,k,j)*cq1
      cq2 = cqw(i,k,j)*cq1
      g_cqw(i,k,j) = g_cq1
      cqw(i,k,j) = cq1
      g_rw_tend(i,k,j) = walls(1)*(g_cq1*gwalls(i)-g_cq2*mub(i,j)-g_mu(i,j)-&
&(g_p(i,k-1,j)-g_p(i,k,j))*cq1*walls(2))+g_rw_tend(i,k,j)
      rw_tend(i,k,j) = rw_tend(i,k,j)+walls(1)*(cq1*gwalls(i)-mu(i,j)-cq2*mub(i,j))
    end do
  end do
end do

   call trace_exit("g_pg_buoy_w")

end subroutine g_pg_buoy_w


subroutine g_phy_prep( p, g_p, pb, ph, g_ph, phb, t, g_t, mu_3d, rho, th_phy, g_th_phy, p_phy, g_p_phy, pi_phy, g_pi_phy, u_phy, &
&v_phy, p8w, g_p8w, t_phy, g_t_phy, t8w, g_t8w, z, g_z, z_at_w, g_z_at_w, dz8w, fzm, fzp, rthraten, rthblten, rublten, rvblten, &
&rqvblten, rqcblten, rqiblten, rthcuten, rqvcuten, rqccuten, rqrcuten, rqicuten, rqscuten, rthften, rqvften, ide, jde, kde, ims, &
&ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(out) :: dz8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
real, intent(in) :: g_p(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_p8w(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_p_phy(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ph(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_pi_phy(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_t8w(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_t_phy(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_th_phy(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_z(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_z_at_w(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(out) :: mu_3d(ims:ime,kms:kme,jms:jme)
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(out) :: p8w(ims:ime,kms:kme,jms:jme)
real, intent(out) :: p_phy(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: pi_phy(ims:ime,kms:kme,jms:jme)
real, intent(out) :: rho(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rqcblten(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rqccuten(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rqiblten(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rqicuten(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rqrcuten(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rqscuten(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rqvblten(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rqvcuten(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rqvften(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rthblten(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rthcuten(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rthften(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rthraten(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rublten(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rvblten(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t(ims:ime,kms:kme,jms:jme)
real, intent(out) :: t8w(ims:ime,kms:kme,jms:jme)
real, intent(out) :: t_phy(ims:ime,kms:kme,jms:jme)
real, intent(out) :: th_phy(ims:ime,kms:kme,jms:jme)
real, intent(out) :: u_phy(ims:ime,kms:kme,jms:jme)
real, intent(out) :: v_phy(ims:ime,kms:kme,jms:jme)
real, intent(out) :: z(ims:ime,kms:kme,jms:jme)
real, intent(out) :: z_at_w(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real g_w1
real g_w2
real g_z0
real g_z1
real g_z2
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer k_end
integer k_start
real w1
real w2
real z0
real z1
real z2
real walls(4)

   call trace_entry("g_phy_prep")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
k_start = kts
k_end = min(kte,kde-1)

g_th_phy(i_start:i_end,k_start:k_end,j_start:j_end) = g_t(i_start:i_end,k_start:k_end,j_start:j_end)
th_phy(i_start:i_end,k_start:k_end,j_start:j_end) = t(i_start:i_end,k_start:k_end,j_start:j_end)+t0
g_p_phy(i_start:i_end,k_start:k_end,j_start:j_end) = g_p(i_start:i_end,k_start:k_end,j_start:j_end)
p_phy(i_start:i_end,k_start:k_end,j_start:j_end) = p(i_start:i_end,k_start:k_end,j_start:j_end)&
&+pb(i_start:i_end,k_start:k_end,j_start:j_end)
do j = j_start, j_end
  do k = k_start, k_end
    do i = i_start, i_end
      walls(1)=p_phy(i,k,j)/p1000mb
      walls(2)=walls(1)**(rcp-1)

      g_pi_phy(i,k,j) = g_p_phy(i,k,j)/p1000mb*rcp*walls(2)
      pi_phy(i,k,j) = walls(1)*walls(2)

      g_t_phy(i,k,j) = g_pi_phy(i,k,j)*th_phy(i,k,j)+g_th_phy(i,k,j)*pi_phy(i,k,j)
      t_phy(i,k,j) = th_phy(i,k,j)*pi_phy(i,k,j)
    end do
  end do
end do
do j = j_start, j_end
  do k = k_start, kte
    do i = i_start, i_end
      g_z_at_w(i,k,j) = g_ph(i,k,j)/g
      z_at_w(i,k,j) = (phb(i,k,j)+ph(i,k,j))/g
    end do
  end do
end do
do j = j_start, j_end
  do k = k_start, k_end
    do i = i_start, i_end
      g_z(i,k,j) = 0.5*(g_z_at_w(i,k+1,j)+g_z_at_w(i,k,j))
      z(i,k,j) = 0.5*(z_at_w(i,k,j)+z_at_w(i,k+1,j))
    end do
  end do
end do
do j = j_start, j_end
  do k = 2, k_end
    walls(1)=fzp(k)
    walls(2)=fzm(k)
    do i = i_start, i_end
      g_p8w(i,k,j) = g_p_phy(i,k-1,j)*walls(1)+g_p_phy(i,k,j)*walls(2)
      p8w(i,k,j)   = walls(2)*p_phy(i,k,j)+walls(1)*p_phy(i,k-1,j)

      g_t8w(i,k,j) = g_t_phy(i,k-1,j)*walls(1)+g_t_phy(i,k,j)*walls(2)
      t8w(i,k,j)   = walls(2)*t_phy(i,k,j)+walls(1)*t_phy(i,k-1,j)
    end do
  end do
end do
do j = j_start, j_end
  do i = i_start, i_end
    g_z0 = g_z_at_w(i,1,j)
    z0 = z_at_w(i,1,j)
    g_z1 = g_z(i,1,j)
    z1 = z(i,1,j)
    g_z2 = g_z(i,2,j)
    z2 = z(i,2,j)

    walls(1)=z0-z2
    walls(2)=z1-z2

    w1 = walls(1)/walls(2)
    g_w1 = (g_z0-g_z1*w1 +g_z2*(-1.+w1))/walls(2)

    g_w2 = -g_w1
    w2 = 1.-w1

    g_p8w(i,1,j) = g_p_phy(i,2,j)*w2+g_p_phy(i,1,j)*w1+g_w1*p_phy(i,1,j)+g_w2*p_phy(i,2,j)
    p8w(i,1,j) = w1*p_phy(i,1,j)+w2*p_phy(i,2,j)
    g_t8w(i,1,j) = g_t_phy(i,2,j)*w2+g_t_phy(i,1,j)*w1+g_w1*t_phy(i,1,j)+g_w2*t_phy(i,2,j)
    t8w(i,1,j) = w1*t_phy(i,1,j)+w2*t_phy(i,2,j)

    g_z0 = g_z_at_w(i,kte,j)
    z0 = z_at_w(i,kte,j)
    g_z1 = g_z(i,k_end,j)
    z1 = z(i,k_end,j)
    g_z2 = g_z(i,k_end-1,j)
    z2 = z(i,k_end-1,j)

    walls(1)=z0-z2
    walls(2)=z1-z2

    w1 = walls(1)/walls(2)
    g_w1 = (g_z0-g_z1*w1 +g_z2*(-1.+w1))/walls(2)

    g_w2 = -g_w1
    w2 = 1.-w1

    walls(1)=log(p_phy(i,kde-1,j))
    walls(2)=log(p_phy(i,kde-2,j))
    p8w(i,kde,j) = exp(w1*walls(1)+w2*walls(2))

    g_p8w(i,kde,j) = (g_p_phy(i,kde-2,j)*w2/p_phy(i,kde-2,j)+g_p_phy(i,kde-1,j)*w1/p_phy(i,kde-1,j)&
&+g_w1*walls(1)+g_w2*walls(2))*p8w(i,kde,j)

    g_t8w(i,kde,j) = g_t_phy(i,kde-2,j)*w2+g_t_phy(i,kde-1,j)*w1+g_w1*t_phy(i,kde-1,j)+g_w2*t_phy(i,kde-2,j)
    t8w(i,kde,j) = w1*t_phy(i,kde-1,j)+w2*t_phy(i,kde-2,j)
  end do
end do

   call trace_exit("g_phy_prep")

end subroutine g_phy_prep


subroutine g_rhs_ph( ph_tend, g_ph_tend, u, g_u, v, g_v, ww, g_ww, ph, g_ph, ph_old, g_ph_old, phb, w, g_w, mut, g_mut, muu, g_muu,&
& muv, g_muv, fnm, fnp, rdnw, cfn, cfn1, rdx, rdy, msft, non_hydrostatic, config_flags, ids, ide, jds, jde, kde, ims, ime, jms, &
&jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real, intent(in) :: cfn
real, intent(in) :: cfn1
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: fnm(kms:kme)
real, intent(in) :: fnp(kms:kme)
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_mut(ims:ime,jms:jme)
real, intent(in) :: g_muu(ims:ime,jms:jme)
real, intent(in) :: g_muv(ims:ime,jms:jme)
real, intent(in) :: g_ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ph_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ww(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
logical, intent(in) :: non_hydrostatic
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ww(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer advective_order
real g_ub
real g_ul
real g_ur
real g_vb
real g_vl
real g_vr
real g_wdwn(its:ite,kts:kte)
integer i
integer i_start
integer itf
integer j
integer j_start
integer jtf
integer k
integer kz
logical specified
real ub
real ul
real ur
real vb
real vl
real vr
real wdwn(its:ite,kts:kte)
real walls(4),gwalls(its:ite),kwalls(its:ite)

   call trace_entry("g_rhs_ph")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
advective_order = config_flags%h_sca_adv_order
itf = min(ite,ide-1)
jtf = min(jte,jde-1)

do j = jts, jtf
  do k = 2, kte
    walls(1)=0.5*rdnw(k-1)
    gwalls(its:itf)=ph(its:itf,k,j)-ph(its:itf,k-1,j)+phb(its:itf,k,j)-phb(its:itf,k-1,j)
    kwalls(its:itf)=ww(its:itf,k,j)+ww(its:itf,k-1,j)
    do i = its, itf
      g_wdwn(i,k) = walls(1)*((-g_ph(i,k-1,j)+g_ph(i,k,j))*kwalls(i)+(g_ww(i,k-1,j)+g_ww(i,k,j))*gwalls(i))
      wdwn(i,k) = kwalls(i)*walls(1)*gwalls(i)
    end do
  end do
  do k = 2, kte-1
!   do i = its, itf
!     g_ph_tend(i,k,j) = g_ph_tend(i,k,j)-g_wdwn(i,k+1)*fnm(k)-g_wdwn(i,k)*fnp(k)
!     ph_tend(i,k,j) = ph_tend(i,k,j)-(fnm(k)*wdwn(i,k+1)+fnp(k)*wdwn(i,k))
!   end do
    g_ph_tend(its:itf,k,j) = g_ph_tend(its:itf,k,j)-g_wdwn(its:itf,k+1)*fnm(k)-g_wdwn(its:itf,k)*fnp(k)
    ph_tend(its:itf,k,j) = ph_tend(its:itf,k,j)-fnm(k)*wdwn(its:itf,k+1)-fnp(k)*wdwn(its:itf,k)
  end do
end do
if (non_hydrostatic) then
  do j = jts, jtf
    do i = its, itf
      g_ph_tend(i,kde,j) = 0.
      ph_tend(i,kde,j) = 0.
    end do
    do k = 2, kte
      do i = its, itf
        walls(1)=g/msft(i,j)
        g_ph_tend(i,k,j) = g_ph_tend(i,k,j) +(g_mut(i,j)*w(i,k,j)+g_w(i,k,j)*mut(i,j))*walls(1)
        ph_tend(i,k,j) = ph_tend(i,k,j)+mut(i,j)*w(i,k,j)*walls(1)
      end do
    end do
  end do
endif

if (advective_order .le. 2) then
  i_start = its
  j_start = jts
  itf = min(ite,ide-1)
  jtf = min(jte,jde-1)
  if (config_flags%open_ys .and. jts .eq. jds) then
    j_start = jts+1
  endif
  if (config_flags%open_ye .and. jte .eq. jde) then
    jtf = jtf-1
  endif

  do j = j_start, jtf
    do k = 2, kte-1
      do i = i_start, itf
        walls(1)=muv(i,j+1)*(v(i,k,j+1)+v(i,k-1,j+1))
        walls(2)=muv(i,j)*(v(i,k,j)+v(i,k-1,j))
        g_ph_tend(i,k,j) = (-(0.25*g_muv(i,j+1)*rdy*(v(i,k,j+1)+v(i,k-1,j+1))*(phb(i,k,j+1)-phb(i,k,j)+ph(i,k,j+1)-ph(i,k,j))))-&
&0.25*g_muv(i,j)*rdy*(v(i,k,j)+v(i,k-1,j))*(phb(i,k,j)-phb(i,k,j-1)+ph(i,k,j)-ph(i,k,j-1))+0.25*g_ph(i,k,j-1)*rdy*muv(i,j)*&
&(v(i,k,j)+v(i,k-1,j))-0.25*g_ph(i,k,j+1)*rdy*walls(1)-0.25*g_ph(i,k,j)*rdy*((-(muv(i,j+1)*&
&(v(i,k,j+1)+v(i,k-1,j+1))))+walls(2))+g_ph_tend(i,k,j)-0.25*g_v(i,k-1,j+1)*rdy*muv(i,j+1)*(phb(i,k,&
&j+1)-phb(i,k,j)+ph(i,k,j+1)-ph(i,k,j))-0.25*g_v(i,k-1,j)*rdy*muv(i,j)*(phb(i,k,j)-phb(i,k,j-1)+ph(i,k,j)-ph(i,k,j-1))-&
&0.25*g_v(i,k,j+1)*rdy*muv(i,j+1)*(phb(i,k,j+1)-phb(i,k,j)+ph(i,k,j+1)-ph(i,k,j))-0.25*g_v(i,k,j)*rdy*muv(i,j)*(phb(i,k,j)-&
&phb(i,k,j-1)+ph(i,k,j)-ph(i,k,j-1))
        ph_tend(i,k,j) = ph_tend(i,k,j)-0.25*rdy*(walls(1)*(phb(i,k,j+1)-phb(i,k,j)+ph(i,k,j+1)-ph(i,k,&
&j))+walls(2)*(phb(i,k,j)-phb(i,k,j-1)+ph(i,k,j)-ph(i,k,j-1)))
      end do
    end do
    k = kte
    do i = i_start, itf
      g_ph_tend(i,k,j) = (-(0.5*g_muv(i,j+1)*rdy*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))*(phb(i,k,j+1)-phb(i,k,j)+ph(i,k,j+1)-ph(i,k,&
&j))))-0.5*g_muv(i,j)*rdy*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j))*(phb(i,k,j)-phb(i,k,j-1)+ph(i,k,j)-ph(i,k,j-1))+0.5*g_ph(i,k,j-1)*&
&rdy*muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j))-0.5*g_ph(i,k,j+1)*rdy*muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))-0.5*&
&g_ph(i,k,j)*rdy*((-(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))))+muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j)))+&
&g_ph_tend(i,k,j)-0.5*g_v(i,k-2,j+1)*rdy*muv(i,j+1)*cfn1*(phb(i,k,j+1)-phb(i,k,j)+ph(i,k,j+1)-ph(i,k,j))-0.5*g_v(i,k-2,j)*&
&rdy*muv(i,j)*cfn1*(phb(i,k,j)-phb(i,k,j-1)+ph(i,k,j)-ph(i,k,j-1))-0.5*g_v(i,k-1,j+1)*rdy*muv(i,j+1)*cfn*(phb(i,k,j+1)-phb(i,&
&k,j)+ph(i,k,j+1)-ph(i,k,j))-0.5*g_v(i,k-1,j)*rdy*muv(i,j)*cfn*(phb(i,k,j)-phb(i,k,j-1)+ph(i,k,j)-ph(i,k,j-1))
      ph_tend(i,k,j) = ph_tend(i,k,j)-0.5*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))*(phb(i,k,j+1)-phb(i,k,j)+ph(i,k,j+1)&
&-ph(i,k,j))+muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j))*(phb(i,k,j)-phb(i,k,j-1)+ph(i,k,j)-ph(i,k,j-1)))
    end do
  end do
  i_start = its
  j_start = jts
  itf = min(ite,ide-1)
  jtf = min(jte,jde-1)
  if (config_flags%open_xs .and. its .eq. ids) then
    i_start = its+1
  endif
  if (config_flags%open_xe .and. ite .eq. ide) then
    itf = itf-1
  endif

  do j = j_start, jtf
    do k = 2, kte-1
      do i = i_start, itf
        g_ph_tend(i,k,j) = (-(0.25*g_muu(i+1,j)*rdx*(u(i+1,k,j)+u(i+1,k-1,j))*(phb(i+1,k,j)-phb(i,k,j)+ph(i+1,k,j)-ph(i,k,j))))-&
&0.25*g_muu(i,j)*rdx*(u(i,k,j)+u(i,k-1,j))*(phb(i,k,j)-phb(i-1,k,j)+ph(i,k,j)-ph(i-1,k,j))+0.25*g_ph(i-1,k,j)*rdx*muu(i,j)*&
&(u(i,k,j)+u(i,k-1,j))-0.25*g_ph(i+1,k,j)*rdx*muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))-0.25*g_ph(i,k,j)*rdx*((-(muu(i+1,j)*&
&(u(i+1,k,j)+u(i+1,k-1,j))))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))+g_ph_tend(i,k,j)-0.25*g_u(i+1,k-1,j)*rdx*muu(i+1,j)*(phb(i+1,&
&k,j)-phb(i,k,j)+ph(i+1,k,j)-ph(i,k,j))-0.25*g_u(i,k-1,j)*rdx*muu(i,j)*(phb(i,k,j)-phb(i-1,k,j)+ph(i,k,j)-ph(i-1,k,j))-&
&0.25*g_u(i+1,k,j)*rdx*muu(i+1,j)*(phb(i+1,k,j)-phb(i,k,j)+ph(i+1,k,j)-ph(i,k,j))-0.25*g_u(i,k,j)*rdx*muu(i,j)*(phb(i,k,j)-&
&phb(i-1,k,j)+ph(i,k,j)-ph(i-1,k,j))
        ph_tend(i,k,j) = ph_tend(i,k,j)-0.25*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))*(phb(i+1,k,j)-phb(i,k,j)+ph(i+1,k,j)-ph(i,k,&
&j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j))*(phb(i,k,j)-phb(i-1,k,j)+ph(i,k,j)-ph(i-1,k,j)))
      end do
    end do
    k = kte
    do i = i_start, itf
      g_ph_tend(i,k,j) = (-(0.5*g_muu(i+1,j)*rdx*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))*(phb(i+1,k,j)-phb(i,k,j)+ph(i+1,k,j)-ph(i,k,&
&j))))-0.5*g_muu(i,j)*rdx*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j))*(phb(i,k,j)-phb(i-1,k,j)+ph(i,k,j)-ph(i-1,k,j))+0.5*g_ph(i-1,k,j)*&
&rdx*muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j))-0.5*g_ph(i+1,k,j)*rdx*muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))-0.5*&
&g_ph(i,k,j)*rdx*((-(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))))+muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))+&
&g_ph_tend(i,k,j)-0.5*g_u(i+1,k-2,j)*rdx*muu(i+1,j)*cfn1*(phb(i+1,k,j)-phb(i,k,j)+ph(i+1,k,j)-ph(i,k,j))-0.5*g_u(i,k-2,j)*&
&rdx*muu(i,j)*cfn1*(phb(i,k,j)-phb(i-1,k,j)+ph(i,k,j)-ph(i-1,k,j))-0.5*g_u(i+1,k-1,j)*rdx*muu(i+1,j)*cfn*(phb(i+1,k,j)-phb(i,&
&k,j)+ph(i+1,k,j)-ph(i,k,j))-0.5*g_u(i,k-1,j)*rdx*muu(i,j)*cfn*(phb(i,k,j)-phb(i-1,k,j)+ph(i,k,j)-ph(i-1,k,j))
      ph_tend(i,k,j) = ph_tend(i,k,j)-0.5*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))*(phb(i+1,k,j)-phb(i,k,j)+ph(i+1,k,j)&
&-ph(i,k,j))+muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j))*(phb(i,k,j)-phb(i-1,k,j)+ph(i,k,j)-ph(i-1,k,j)))
    end do
  end do
else if (advective_order .le. 4) then
  i_start = its
  j_start = jts
  itf = min(ite,ide-1)
  jtf = min(jte,jde-1)
  if (config_flags%open_ys .and. jts .eq. jds) then
    j_start = jts+1
  endif
  if (config_flags%open_ye .and. jte .eq. jde) then
    jtf = jtf-1
  endif

  do j = j_start, jtf
    do k = 2, kte-1
      do i = i_start, itf
        walls(1)=muv(i,j+1)*(v(i,k,j+1)+v(i,k-1,j+1))
        walls(2)=muv(i,j)*(v(i,k,j)+v(i,k-1,j))
        g_ph_tend(i,k,j) = (-(0.083333333*0.25*g_muv(i,j+1)*rdy*(v(i,k,j+1)+v(i,k-1,j+1))*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+&
&2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))))-0.083333333*0.25*g_muv(i,j)*rdy*(v(i,k,j)+&
&v(i,k-1,j))*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,&
&j-2)))-0.083333333*0.25*g_ph(i,k,j-2)*rdy*(walls(1)+walls(2))-(-&
&0.66666667)*0.25*g_ph(i,k,j-1)*rdy*(walls(1)+walls(2))-(-0.083333333)*&
&0.25*g_ph(i,k,j+2)*rdy*(walls(1)+walls(2))-0.66666667*0.25*g_ph(i,k,j+1)&
&*rdy*(walls(1)+walls(2))+g_ph_tend(i,k,j)-0.083333333*0.25*g_v(i,k-1,j+&
&1)*rdy*muv(i,j+1)*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-&
&phb(i,k,j-2)))-0.083333333*0.25*g_v(i,k-1,j)*rdy*muv(i,j)*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*&
&(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))-0.083333333*0.25*g_v(i,k,j+1)*rdy*muv(i,j+1)*(8.*(ph(i,k,j+1)-&
&ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))-0.083333333*0.25*g_v(i,&
&k,j)*rdy*muv(i,j)*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-&
&phb(i,k,j-2)))
        ph_tend(i,k,j) = ph_tend(i,k,j)-0.25*rdy*(walls(1)+walls(2))*(1./12.)*&
&(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))
      end do
    end do
    k = kte
    do i = i_start, itf
      g_ph_tend(i,k,j) = (-(0.083333333*0.5*g_muv(i,j+1)*rdy*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-&
&(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))))-0.083333333*0.5*g_muv(i,j)*rdy*(cfn*&
&v(i,k-1,j)+cfn1*v(i,k-2,j))*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,&
&j+2)-phb(i,k,j-2)))-0.083333333*0.5*g_ph(i,k,j-2)*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*(cfn*v(i,k-&
&1,j)+cfn1*v(i,k-2,j)))-(-0.66666667)*0.5*g_ph(i,k,j-1)*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*(cfn*&
&v(i,k-1,j)+cfn1*v(i,k-2,j)))-(-0.083333333)*0.5*g_ph(i,k,j+2)*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*&
&(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j)))-0.66666667*0.5*g_ph(i,k,j+1)*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)&
&*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j)))+g_ph_tend(i,k,j)-0.083333333*0.5*g_v(i,k-2,j+1)*rdy*muv(i,j+1)*cfn1*(8.*(ph(i,k,j+1)-&
&ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))-0.083333333*0.5*g_v(i,k-&
&2,j)*rdy*muv(i,j)*cfn1*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-&
&phb(i,k,j-2)))-0.083333333*0.5*g_v(i,k-1,j+1)*rdy*muv(i,j+1)*cfn*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*&
&(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))-0.083333333*0.5*g_v(i,k-1,j)*rdy*muv(i,j)*cfn*(8.*(ph(i,k,j+1)-&
&ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))
      ph_tend(i,k,j) = ph_tend(i,k,j)-0.5*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-&
&2,j)))*(1./12.)*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))
    end do
  end do
  i_start = its
  j_start = jts
  itf = min(ite,ide-1)
  jtf = min(jte,jde-1)
  if (config_flags%open_xs .and. its .eq. ids) then
    i_start = its+1
  endif
  if (config_flags%open_xe .and. ite .eq. ide) then
    itf = itf-1
  endif


  do j = j_start, jtf
    do k = 2, kte-1
      do i = i_start, itf
        g_ph_tend(i,k,j) = (-(0.083333333*0.25*g_muu(i+1,j)*rdx*(u(i+1,k,j)+u(i+1,k-1,j))*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,&
&j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))))-0.083333333*0.25*g_muu(i,j)*rdx*(u(i,k,j)+&
&u(i,k-1,j))*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,&
&k,j)))-0.083333333*0.25*g_ph(i-2,k,j)*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))-(-&
&0.66666667)*0.25*g_ph(i-1,k,j)*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))-(-0.083333333)*&
&0.25*g_ph(i+2,k,j)*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))-0.66666667*0.25*g_ph(i+1,k,j)&
&*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))+g_ph_tend(i,k,j)-0.083333333*0.25*g_u(i+1,k-1,&
&j)*rdx*muu(i+1,j)*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-&
&phb(i-2,k,j)))-0.083333333*0.25*g_u(i,k-1,j)*rdx*muu(i,j)*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*&
&(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))-0.083333333*0.25*g_u(i+1,k,j)*rdx*muu(i+1,j)*(8.*(ph(i+1,k,j)-&
&ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))-0.083333333*0.25*g_u(i,&
&k,j)*rdx*muu(i,j)*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-&
&phb(i-2,k,j)))
        ph_tend(i,k,j) = ph_tend(i,k,j)-0.25*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))*(1./12.)*&
&(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))
      end do
    end do
    k = kte
    do i = i_start, itf
      g_ph_tend(i,k,j) = (-(0.083333333*0.5*g_muu(i+1,j)*rdx*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-&
&(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))))-0.083333333*0.5*g_muu(i,j)*rdx*(cfn*&
&u(i,k-1,j)+cfn1*u(i,k-2,j))*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,&
&k,j)-phb(i-2,k,j)))-0.083333333*0.5*g_ph(i-2,k,j)*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*u(i,k-&
&1,j)+cfn1*u(i,k-2,j)))-(-0.66666667)*0.5*g_ph(i-1,k,j)*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*&
&u(i,k-1,j)+cfn1*u(i,k-2,j)))-(-0.083333333)*0.5*g_ph(i+2,k,j)*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*&
&(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))-0.66666667*0.5*g_ph(i+1,k,j)*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)&
&*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))+g_ph_tend(i,k,j)-0.083333333*0.5*g_u(i+1,k-2,j)*rdx*muu(i+1,j)*cfn1*(8.*(ph(i+1,k,j)-&
&ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))-0.083333333*0.5*g_u(i,k-&
&2,j)*rdx*muu(i,j)*cfn1*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-&
&phb(i-2,k,j)))-0.083333333*0.5*g_u(i+1,k-1,j)*rdx*muu(i+1,j)*cfn*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*&
&(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))-0.083333333*0.5*g_u(i,k-1,j)*rdx*muu(i,j)*cfn*(8.*(ph(i+1,k,j)-&
&ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))
      ph_tend(i,k,j) = ph_tend(i,k,j)-0.5*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-&
&2,j)))*(1./12.)*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))
    end do
  end do
else if (advective_order .le. 6) then
  i_start = its
  j_start = jts
  itf = min(ite,ide-1)
  jtf = min(jte,jde-1)
  if (config_flags%open_ys .or. specified) then
    j_start = max(jts,jds+2)
  endif
  if (config_flags%open_ye .or. specified) then
    jtf = min(jtf,jde-3)
  endif

  walls(3)=0.25*rdy
  walls(4)=0.016666667*0.25*rdy
  do j = j_start, jtf
    do k = 2, kte-1
      gwalls(i_start:itf)=45.*(ph(i_start:itf,k,j+1)-ph(i_start:itf,k,j-1))&
&-9.*(ph(i_start:itf,k,j+2)-ph(i_start:itf,k,j-2))+ph(i_start:itf,k,j+3)&
&-ph(i_start:itf,k,j-3)+45.*(phb(i_start:itf,k,j+1)-phb(i_start:itf,k,j-1))&
&-9.*(phb(i_start:itf,k,j+2)-phb(i_start:itf,k,j-2))+phb(i_start:itf,k,j+3)-phb(i_start:itf,k,j-3)
      do i = i_start, itf
        walls(1)=walls(3)*(muv(i,j+1)*(v(i,k,j+1)+v(i,k-1,j+1))+muv(i,j)*(v(i,k,j)+v(i,k-1,j)))

        g_ph_tend(i,k,j) = walls(4)*(-g_muv(i,j+1)*(v(i,k,j+1)+v(i,k-1,j+1))&
&-g_muv(i,j)*(v(i,k,j)+v(i,k-1,j))&
&-g_v(i,k-1,j+1)*muv(i,j+1)&
&-g_v(i,k-1,j)*muv(i,j)&
&-g_v(i,k,j+1)*muv(i,j+1)&
&-g_v(i,k,j)*muv(i,j))*gwalls(i)&
&+(0.016666667*g_ph(i,k,j-3)&
&-0.15*g_ph(i,k,j-2)&
&+0.75*g_ph(i,k,j-1)&
&-0.016666667*g_ph(i,k,j+3)&
&+0.15*g_ph(i,k,j+2)&
&-0.75*g_ph(i,k,j+1))*walls(1)&
&+g_ph_tend(i,k,j)

        ph_tend(i,k,j) = ph_tend(i,k,j)  -walls(1)*gwalls(i)/60.
      end do
    end do

    k = kte
      gwalls(i_start:itf)=45.*(ph(i_start:itf,k,j+1)-ph(i_start:itf,k,j-1))&
&-9.*(ph(i_start:itf,k,j+2)-ph(i_start:itf,k,j-2))+ph(i_start:itf,k,j+3)&
&-ph(i_start:itf,k,j-3)+45.*(phb(i_start:itf,k,j+1)-phb(i_start:itf,k,j-1))&
&-9.*(phb(i_start:itf,k,j+2)-phb(i_start:itf,k,j-2))+phb(i_start:itf,k,j+3)-phb(i_start:itf,k,j-3)
    do i = i_start, itf
      walls(1)=muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j))
      g_ph_tend(i,k,j) = -0.016666667*0.5*g_muv(i,j+1)*rdy*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))*gwalls(i)&
&-0.016666667*0.5*g_muv(i,j)*rdy*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j))*gwalls(i)&
&+0.016666667*0.5*g_ph(i,k,j-3)*rdy*walls(1)&
&-0.15*0.5*g_ph(i,k,j-2)*rdy*walls(1)&
&+0.75*0.5*g_ph(i,k,j-1)*rdy*walls(1)&
&-0.016666667*0.5*g_ph(i,k,j+3)*rdy*walls(1)&
&+0.15*0.5*g_ph(i,k,j+2)*rdy*walls(1)&
&-0.75*0.5*g_ph(i,k,j+1)*rdy*walls(1)&
&+g_ph_tend(i,k,j)&
&-0.016666667*0.5*g_v(i,k-2,j+1)*rdy*muv(i,j+1)*cfn1*gwalls(i)&
&-0.016666667*0.5*g_v(i,k-2,j)*rdy*muv(i,j)*cfn1*gwalls(i)&
&-0.016666667*0.5*g_v(i,k-1,j+1)*rdy*muv(i,j+1)*cfn*gwalls(i)&
&-0.016666667*0.5*g_v(i,k-1,j)*rdy*muv(i,j)*cfn*gwalls(i)
      ph_tend(i,k,j) = ph_tend(i,k,j)-0.5*rdy*walls(1)*(1./60.)*gwalls(i)
    end do
  end do

  if (config_flags%open_ys .and. jts .le. jds+1) then
    j = jds+1
    do k = 2, kte-1
      do i = i_start, itf
        walls(1)=muv(i,j+1)*(v(i,k,j+1)+v(i,k-1,j+1))
        walls(2)=muv(i,j)*(v(i,k,j)+v(i,k-1,j))
        g_ph_tend(i,k,j) = (-(0.083333333*0.25*g_muv(i,j+1)*rdy*(v(i,k,j+1)+v(i,k-1,j+1))*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+&
&2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))))-0.083333333*0.25*g_muv(i,j)*rdy*(v(i,k,j)+&
&v(i,k-1,j))*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,&
&j-2)))-0.083333333*0.25*g_ph(i,k,j-2)*rdy*(walls(1)+walls(2))-(-&
&0.66666667)*0.25*g_ph(i,k,j-1)*rdy*(walls(1)+walls(2))-(-0.083333333)*&
&0.25*g_ph(i,k,j+2)*rdy*(walls(1)+walls(2))-0.66666667*0.25*g_ph(i,k,j+1)&
&*rdy*(walls(1)+walls(2))+g_ph_tend(i,k,j)-0.083333333*0.25*g_v(i,k-1,j+&
&1)*rdy*muv(i,j+1)*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-&
&phb(i,k,j-2)))-0.083333333*0.25*g_v(i,k-1,j)*rdy*muv(i,j)*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*&
&(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))-0.083333333*0.25*g_v(i,k,j+1)*rdy*muv(i,j+1)*(8.*(ph(i,k,j+1)-&
&ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))-0.083333333*0.25*g_v(i,&
&k,j)*rdy*muv(i,j)*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-&
&phb(i,k,j-2)))
        ph_tend(i,k,j) = ph_tend(i,k,j)-0.25*rdy*(walls(1)+walls(2))*(1./12.)*&
&(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))
      end do
    end do
    k = kte
    do i = i_start, itf
      g_ph_tend(i,k,j) = (-(0.083333333*0.5*g_muv(i,j+1)*rdy*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-&
&(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))))-0.083333333*0.5*g_muv(i,j)*rdy*(cfn*&
&v(i,k-1,j)+cfn1*v(i,k-2,j))*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,&
&j+2)-phb(i,k,j-2)))-0.083333333*0.5*g_ph(i,k,j-2)*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*(cfn*v(i,k-&
&1,j)+cfn1*v(i,k-2,j)))-(-0.66666667)*0.5*g_ph(i,k,j-1)*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*(cfn*&
&v(i,k-1,j)+cfn1*v(i,k-2,j)))-(-0.083333333)*0.5*g_ph(i,k,j+2)*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*&
&(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j)))-0.66666667*0.5*g_ph(i,k,j+1)*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)&
&*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j)))+g_ph_tend(i,k,j)-0.083333333*0.5*g_v(i,k-2,j+1)*rdy*muv(i,j+1)*cfn1*(8.*(ph(i,k,j+1)-&
&ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))-0.083333333*0.5*g_v(i,k-&
&2,j)*rdy*muv(i,j)*cfn1*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-&
&phb(i,k,j-2)))-0.083333333*0.5*g_v(i,k-1,j+1)*rdy*muv(i,j+1)*cfn*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*&
&(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))-0.083333333*0.5*g_v(i,k-1,j)*rdy*muv(i,j)*cfn*(8.*(ph(i,k,j+1)-&
&ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))
      ph_tend(i,k,j) = ph_tend(i,k,j)-0.5*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-&
&2,j)))*(1./12.)*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))
    end do
  endif
  if (config_flags%open_ye .and. jte .ge. jde-2) then
    j = jde-2
    do k = 2, kte-1
      do i = i_start, itf
        walls(1)=muv(i,j+1)*(v(i,k,j+1)+v(i,k-1,j+1))
        walls(2)=muv(i,j)*(v(i,k,j)+v(i,k-1,j))
        g_ph_tend(i,k,j) = (-(0.083333333*0.25*g_muv(i,j+1)*rdy*(v(i,k,j+1)+v(i,k-1,j+1))*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+&
&2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))))-0.083333333*0.25*g_muv(i,j)*rdy*(v(i,k,j)+&
&v(i,k-1,j))*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,&
&j-2)))-0.083333333*0.25*g_ph(i,k,j-2)*rdy*(walls(1)+walls(2))-(-&
&0.66666667)*0.25*g_ph(i,k,j-1)*rdy*(walls(1)+walls(2))-(-0.083333333)*&
&0.25*g_ph(i,k,j+2)*rdy*(walls(1)+walls(2))-0.66666667*0.25*g_ph(i,k,j+1)&
&*rdy*(walls(1)+walls(2))+g_ph_tend(i,k,j)-0.083333333*0.25*g_v(i,k-1,j+&
&1)*rdy*muv(i,j+1)*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-&
&phb(i,k,j-2)))-0.083333333*0.25*g_v(i,k-1,j)*rdy*muv(i,j)*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*&
&(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))-0.083333333*0.25*g_v(i,k,j+1)*rdy*muv(i,j+1)*(8.*(ph(i,k,j+1)-&
&ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))-0.083333333*0.25*g_v(i,&
&k,j)*rdy*muv(i,j)*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-&
&phb(i,k,j-2)))
        ph_tend(i,k,j) = ph_tend(i,k,j)-0.25*rdy*(walls(1)+walls(2))*(1./12.)*&
&(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))
      end do
    end do
    k = kte
    do i = i_start, itf
      g_ph_tend(i,k,j) = (-(0.083333333*0.5*g_muv(i,j+1)*rdy*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-&
&(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))))-0.083333333*0.5*g_muv(i,j)*rdy*(cfn*&
&v(i,k-1,j)+cfn1*v(i,k-2,j))*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,&
&j+2)-phb(i,k,j-2)))-0.083333333*0.5*g_ph(i,k,j-2)*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*(cfn*v(i,k-&
&1,j)+cfn1*v(i,k-2,j)))-(-0.66666667)*0.5*g_ph(i,k,j-1)*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*(cfn*&
&v(i,k-1,j)+cfn1*v(i,k-2,j)))-(-0.083333333)*0.5*g_ph(i,k,j+2)*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*&
&(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j)))-0.66666667*0.5*g_ph(i,k,j+1)*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)&
&*(cfn*v(i,k-1,j)+cfn1*v(i,k-2,j)))+g_ph_tend(i,k,j)-0.083333333*0.5*g_v(i,k-2,j+1)*rdy*muv(i,j+1)*cfn1*(8.*(ph(i,k,j+1)-&
&ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))-0.083333333*0.5*g_v(i,k-&
&2,j)*rdy*muv(i,j)*cfn1*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-&
&phb(i,k,j-2)))-0.083333333*0.5*g_v(i,k-1,j+1)*rdy*muv(i,j+1)*cfn*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*&
&(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))-0.083333333*0.5*g_v(i,k-1,j)*rdy*muv(i,j)*cfn*(8.*(ph(i,k,j+1)-&
&ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))
      ph_tend(i,k,j) = ph_tend(i,k,j)-0.5*rdy*(muv(i,j+1)*(cfn*v(i,k-1,j+1)+cfn1*v(i,k-2,j+1))+muv(i,j)*(cfn*v(i,k-1,j)+cfn1*v(i,k-&
&2,j)))*(1./12.)*(8.*(ph(i,k,j+1)-ph(i,k,j-1))-(ph(i,k,j+2)-ph(i,k,j-2))+8.*(phb(i,k,j+1)-phb(i,k,j-1))-(phb(i,k,j+2)-phb(i,k,j-2)))
    end do
  endif
  i_start = its
  j_start = jts
  itf = min(ite,ide-1)
  jtf = min(jte,jde-1)
  if (config_flags%open_xs .or. specified) then
    i_start = max(its,ids+2)
  endif
  if (config_flags%open_xe .or. specified) then
    itf = min(itf,ide-3)
  endif

  walls(2)=0.25*rdx
  walls(3)=0.016666667*0.25*rdx
  do j = j_start, jtf
    do k = 2, kte-1
      gwalls(i_start:itf)=45.*(ph(i_start+1:itf+1,k,j)-ph(i_start-1:itf-1,k,j))-9.*(ph(i_start+2:itf+2,k,j)&
&-ph(i_start-2:itf-2,k,j))+ph(i_start+3:itf+3,k,j)-ph(i_start-3:itf-3,k,j)+45.*(phb(i_start+1:itf+1,k,j)&
&-phb(i_start-1:itf-1,k,j))-9.*(phb(i_start+2:itf+2,k,j)-phb(i_start-2:itf-2,k,j))&
&+phb(i_start+3:itf+3,k,j)-phb(i_start-3:itf-3,k,j)
      do i = i_start, itf
        walls(1)=walls(2)*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))
        g_ph_tend(i,k,j) = walls(3)*(-g_muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))&
&-g_muu(i,j)*(u(i,k,j)+u(i,k-1,j)) -g_u(i+1,k-1,j)*muu(i+1,j) -g_u(i,k-1,j)*muu(i,j) -g_u(i+1,k,j)*muu(i+1,j)&
&-g_u(i,k,j)*muu(i,j))*gwalls(i)&
&+(0.016666667*g_ph(i-3,k,j)-0.15*g_ph(i-2,k,j)+0.75*g_ph(i-1,k,j)-0.016666667*g_ph(i+3,k,j)&
&+0.15*g_ph(i+2,k,j)-0.75*g_ph(i+1,k,j))*walls(1)&
&+g_ph_tend(i,k,j)
        ph_tend(i,k,j) = ph_tend(i,k,j)-walls(1)*(1./60.)*gwalls(i)
      end do
    end do

    k = kte
    gwalls(i_start:itf)=45.*(ph(i_start+1:itf+1,k,j)-ph(i_start-1:itf-1,k,j))-9.*(ph(i_start+2:itf+2,k,j)&
&-ph(i_start-2:itf-2,k,j))+ph(i_start+3:itf+3,k,j)-ph(i_start-3:itf-3,k,j)+45.*(phb(i_start+1:itf+1,k,j)&
&-phb(i_start-1:itf-1,k,j))-9.*(phb(i_start+2:itf+2,k,j)-phb(i_start-2:itf-2,k,j))&
&+phb(i_start+3:itf+3,k,j)-phb(i_start-3:itf-3,k,j)
    do i = i_start, itf
      walls(1)=0.5*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))
      g_ph_tend(i,k,j) = 0.016666667*0.5*rdx*(-g_muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))&
&-g_muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j))&
&-g_u(i+1,k-2,j)*muu(i+1,j)*cfn1&
&-g_u(i,k-2,j)*muu(i,j)*cfn1-&
&g_u(i+1,k-1,j)*muu(i+1,j)*cfn&
&-g_u(i,k-1,j)*muu(i,j)*cfn)*gwalls(i)&
&+(0.016666667*g_ph(i-3,k,j)&
&-0.15*g_ph(i-2,k,j)&
&-(-0.75)*g_ph(i-1,k,j)&
&-0.016666667*g_ph(i+3,k,j)&
&-(-0.15)*g_ph(i+2,k,j)&
&-0.75*g_ph(i+1,k,j))*walls(1)&
&+g_ph_tend(i,k,j)
      ph_tend(i,k,j) = ph_tend(i,k,j)-walls(1)*(1./60.)*gwalls(i)
    end do
  end do
  if (config_flags%open_xs .and. its .le. ids+1) then
    i = ids+1
    do j = j_start, jtf
      do k = 2, kte-1
        g_ph_tend(i,k,j) = (-(0.083333333*0.25*g_muu(i+1,j)*rdx*(u(i+1,k,j)+u(i+1,k-1,j))*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,&
&j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))))-0.083333333*0.25*g_muu(i,j)*rdx*(u(i,k,j)+&
&u(i,k-1,j))*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,&
&k,j)))-0.083333333*0.25*g_ph(i-2,k,j)*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))-(-&
&0.66666667)*0.25*g_ph(i-1,k,j)*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))-(-0.083333333)*&
&0.25*g_ph(i+2,k,j)*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))-0.66666667*0.25*g_ph(i+1,k,j)&
&*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))+g_ph_tend(i,k,j)-0.083333333*0.25*g_u(i+1,k-1,&
&j)*rdx*muu(i+1,j)*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-&
&phb(i-2,k,j)))-0.083333333*0.25*g_u(i,k-1,j)*rdx*muu(i,j)*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*&
&(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))-0.083333333*0.25*g_u(i+1,k,j)*rdx*muu(i+1,j)*(8.*(ph(i+1,k,j)-&
&ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))-0.083333333*0.25*g_u(i,&
&k,j)*rdx*muu(i,j)*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-&
&phb(i-2,k,j)))
        ph_tend(i,k,j) = ph_tend(i,k,j)-0.25*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))*(1./12.)*&
&(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))
      end do
      k = kte
      g_ph_tend(i,k,j) = (-(0.083333333*0.5*g_muu(i+1,j)*rdx*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-&
&(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))))-0.083333333*0.5*g_muu(i,j)*rdx*(cfn*&
&u(i,k-1,j)+cfn1*u(i,k-2,j))*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,&
&k,j)-phb(i-2,k,j)))-0.083333333*0.5*g_ph(i-2,k,j)*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*u(i,k-&
&1,j)+cfn1*u(i,k-2,j)))-(-0.66666667)*0.5*g_ph(i-1,k,j)*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*&
&u(i,k-1,j)+cfn1*u(i,k-2,j)))-(-0.083333333)*0.5*g_ph(i+2,k,j)*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*&
&(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))-0.66666667*0.5*g_ph(i+1,k,j)*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)&
&*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))+g_ph_tend(i,k,j)-0.083333333*0.5*g_u(i+1,k-2,j)*rdx*muu(i+1,j)*cfn1*(8.*(ph(i+1,k,j)-&
&ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))-0.083333333*0.5*g_u(i,k-&
&2,j)*rdx*muu(i,j)*cfn1*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-&
&phb(i-2,k,j)))-0.083333333*0.5*g_u(i+1,k-1,j)*rdx*muu(i+1,j)*cfn*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*&
&(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))-0.083333333*0.5*g_u(i,k-1,j)*rdx*muu(i,j)*cfn*(8.*(ph(i+1,k,j)-&
&ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))
      ph_tend(i,k,j) = ph_tend(i,k,j)-0.5*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-&
&2,j)))*(1./12.)*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))
    end do
  endif
  if (config_flags%open_xe .and. ite .ge. ide-2) then
    i = ide-2
    do j = j_start, jtf
      do k = 2, kte-1
        g_ph_tend(i,k,j) = (-(0.083333333*0.25*g_muu(i+1,j)*rdx*(u(i+1,k,j)+u(i+1,k-1,j))*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,&
&j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))))-0.083333333*0.25*g_muu(i,j)*rdx*(u(i,k,j)+&
&u(i,k-1,j))*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,&
&k,j)))-0.083333333*0.25*g_ph(i-2,k,j)*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))-(-&
&0.66666667)*0.25*g_ph(i-1,k,j)*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))-(-0.083333333)*&
&0.25*g_ph(i+2,k,j)*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))-0.66666667*0.25*g_ph(i+1,k,j)&
&*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))+g_ph_tend(i,k,j)-0.083333333*0.25*g_u(i+1,k-1,&
&j)*rdx*muu(i+1,j)*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-&
&phb(i-2,k,j)))-0.083333333*0.25*g_u(i,k-1,j)*rdx*muu(i,j)*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*&
&(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))-0.083333333*0.25*g_u(i+1,k,j)*rdx*muu(i+1,j)*(8.*(ph(i+1,k,j)-&
&ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))-0.083333333*0.25*g_u(i,&
&k,j)*rdx*muu(i,j)*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-&
&phb(i-2,k,j)))
        ph_tend(i,k,j) = ph_tend(i,k,j)-0.25*rdx*(muu(i+1,j)*(u(i+1,k,j)+u(i+1,k-1,j))+muu(i,j)*(u(i,k,j)+u(i,k-1,j)))*(1./12.)*&
&(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))
      end do
      k = kte
      g_ph_tend(i,k,j) = (-(0.083333333*0.5*g_muu(i+1,j)*rdx*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-&
&(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))))-0.083333333*0.5*g_muu(i,j)*rdx*(cfn*&
&u(i,k-1,j)+cfn1*u(i,k-2,j))*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,&
&k,j)-phb(i-2,k,j)))-0.083333333*0.5*g_ph(i-2,k,j)*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*u(i,k-&
&1,j)+cfn1*u(i,k-2,j)))-(-0.66666667)*0.5*g_ph(i-1,k,j)*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*&
&u(i,k-1,j)+cfn1*u(i,k-2,j)))-(-0.083333333)*0.5*g_ph(i+2,k,j)*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*&
&(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))-0.66666667*0.5*g_ph(i+1,k,j)*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)&
&*(cfn*u(i,k-1,j)+cfn1*u(i,k-2,j)))+g_ph_tend(i,k,j)-0.083333333*0.5*g_u(i+1,k-2,j)*rdx*muu(i+1,j)*cfn1*(8.*(ph(i+1,k,j)-&
&ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))-0.083333333*0.5*g_u(i,k-&
&2,j)*rdx*muu(i,j)*cfn1*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-&
&phb(i-2,k,j)))-0.083333333*0.5*g_u(i+1,k-1,j)*rdx*muu(i+1,j)*cfn*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*&
&(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))-0.083333333*0.5*g_u(i,k-1,j)*rdx*muu(i,j)*cfn*(8.*(ph(i+1,k,j)-&
&ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))
      ph_tend(i,k,j) = ph_tend(i,k,j)-0.5*rdx*(muu(i+1,j)*(cfn*u(i+1,k-1,j)+cfn1*u(i+1,k-2,j))+muu(i,j)*(cfn*u(i,k-1,j)+cfn1*u(i,k-&
&2,j)))*(1./12.)*(8.*(ph(i+1,k,j)-ph(i-1,k,j))-(ph(i+2,k,j)-ph(i-2,k,j))+8.*(phb(i+1,k,j)-phb(i-1,k,j))-(phb(i+2,k,j)-phb(i-2,k,j)))
    end do
  endif
endif
itf = min(ite,ide-1)
if (config_flags%open_ys .and. jts .eq. jds) then
  j = jts
  do k = 2, kde
    kz = min(k,kde-1)
    do i = its, itf
      g_vb = 0.5*g_v(i,kz-1,j+1)*fnp(kz)+0.5*g_v(i,kz-1,j)*fnp(kz)+0.5*g_v(i,kz,j+1)*fnm(kz)+0.5*g_v(i,kz,j)*fnm(kz)
      vb = 0.5*(fnm(kz)*(v(i,kz,j+1)+v(i,kz,j))+fnp(kz)*(v(i,kz-1,j+1)+v(i,kz-1,j)))
      g_vl = g_vb*(0.5+sign(0.5,0.-vb))
      vl = amin1(vb,0.)
      g_ph_tend(i,k,j) = (-(g_mut(i,j)*rdy*vl*(ph_old(i,k,j+1)-ph_old(i,k,j))))-g_ph_old(i,k,j+1)*rdy*mut(i,j)*vl+g_ph_old(i,k,j)*&
&rdy*mut(i,j)*vl+g_ph_tend(i,k,j)-g_vl*rdy*mut(i,j)*(ph_old(i,k,j+1)-ph_old(i,k,j))
      ph_tend(i,k,j) = ph_tend(i,k,j)-rdy*mut(i,j)*vl*(ph_old(i,k,j+1)-ph_old(i,k,j))
    end do
  end do
endif
if (config_flags%open_ye .and. jte .eq. jde) then
  j = jte-1
  do k = 2, kde
    kz = min(k,kde-1)
    do i = its, itf
      g_vb = 0.5*g_v(i,kz-1,j+1)*fnp(kz)+0.5*g_v(i,kz-1,j)*fnp(kz)+0.5*g_v(i,kz,j+1)*fnm(kz)+0.5*g_v(i,kz,j)*fnm(kz)
      vb = 0.5*(fnm(kz)*(v(i,kz,j+1)+v(i,kz,j))+fnp(kz)*(v(i,kz-1,j+1)+v(i,kz-1,j)))
      g_vr = g_vb*(0.5+sign(0.5,vb-0.))
      vr = amax1(vb,0.)
      g_ph_tend(i,k,j) = (-(g_mut(i,j)*rdy*vr*(ph_old(i,k,j)-ph_old(i,k,j-1))))+g_ph_old(i,k,j-1)*rdy*mut(i,j)*vr-g_ph_old(i,k,j)*&
&rdy*mut(i,j)*vr+g_ph_tend(i,k,j)-g_vr*rdy*mut(i,j)*(ph_old(i,k,j)-ph_old(i,k,j-1))
      ph_tend(i,k,j) = ph_tend(i,k,j)-rdy*mut(i,j)*vr*(ph_old(i,k,j)-ph_old(i,k,j-1))
    end do
  end do
endif
jtf = min(jte,jde-1)
if (config_flags%open_xs .and. its .eq. ids) then
  i = its
  do j = jts, jtf
    do k = 2, kde-1
      kz = k
      g_ub = 0.5*g_u(i+1,kz-1,j)*fnp(kz)+0.5*g_u(i,kz-1,j)*fnp(kz)+0.5*g_u(i+1,kz,j)*fnm(kz)+0.5*g_u(i,kz,j)*fnm(kz)
      ub = 0.5*(fnm(kz)*(u(i+1,kz,j)+u(i,kz,j))+fnp(kz)*(u(i+1,kz-1,j)+u(i,kz-1,j)))
      g_ul = g_ub*(0.5+sign(0.5,0.-ub))
      ul = amin1(ub,0.)
      g_ph_tend(i,k,j) = (-(g_mut(i,j)*rdx*ul*(ph_old(i+1,k,j)-ph_old(i,k,j))))-g_ph_old(i+1,k,j)*rdx*mut(i,j)*ul+g_ph_old(i,k,j)*&
&rdx*mut(i,j)*ul+g_ph_tend(i,k,j)-g_ul*rdx*mut(i,j)*(ph_old(i+1,k,j)-ph_old(i,k,j))
      ph_tend(i,k,j) = ph_tend(i,k,j)-rdx*mut(i,j)*ul*(ph_old(i+1,k,j)-ph_old(i,k,j))
    end do
    k = kde
    kz = k
    g_ub = 0.5*g_u(i+1,kz-1,j)*fnp(kz)+0.5*g_u(i,kz-1,j)*fnp(kz)+0.5*g_u(i+1,kz,j)*fnm(kz)+0.5*g_u(i,kz,j)*fnm(kz)
    ub = 0.5*(fnm(kz)*(u(i+1,kz,j)+u(i,kz,j))+fnp(kz)*(u(i+1,kz-1,j)+u(i,kz-1,j)))
    g_ul = g_ub*(0.5+sign(0.5,0.-ub))
    ul = amin1(ub,0.)
    g_ph_tend(i,k,j) = (-(g_mut(i,j)*rdx*ul*(ph_old(i+1,k,j)-ph_old(i,k,j))))-g_ph_old(i+1,k,j)*rdx*mut(i,j)*ul+g_ph_old(i,k,j)*&
&rdx*mut(i,j)*ul+g_ph_tend(i,k,j)-g_ul*rdx*mut(i,j)*(ph_old(i+1,k,j)-ph_old(i,k,j))
    ph_tend(i,k,j) = ph_tend(i,k,j)-rdx*mut(i,j)*ul*(ph_old(i+1,k,j)-ph_old(i,k,j))
  end do
endif
if (config_flags%open_xe .and. ite .eq. ide) then
  i = ite-1
  do j = jts, jtf
    do k = 2, kde-1
      kz = k
      g_ub = 0.5*g_u(i+1,kz-1,j)*fnp(kz)+0.5*g_u(i,kz-1,j)*fnp(kz)+0.5*g_u(i+1,kz,j)*fnm(kz)+0.5*g_u(i,kz,j)*fnm(kz)
      ub = 0.5*(fnm(kz)*(u(i+1,kz,j)+u(i,kz,j))+fnp(kz)*(u(i+1,kz-1,j)+u(i,kz-1,j)))
      g_ur = g_ub*(0.5+sign(0.5,ub-0.))
      ur = amax1(ub,0.)
      g_ph_tend(i,k,j) = (-(g_mut(i,j)*rdx*ur*(ph_old(i,k,j)-ph_old(i-1,k,j))))+g_ph_old(i-1,k,j)*rdx*mut(i,j)*ur-g_ph_old(i,k,j)*&
&rdx*mut(i,j)*ur+g_ph_tend(i,k,j)-g_ur*rdx*mut(i,j)*(ph_old(i,k,j)-ph_old(i-1,k,j))
      ph_tend(i,k,j) = ph_tend(i,k,j)-rdx*mut(i,j)*ur*(ph_old(i,k,j)-ph_old(i-1,k,j))
    end do
    k = kde
    kz = k-1
    g_ub = 0.5*g_u(i+1,kz-1,j)*fnp(kz)+0.5*g_u(i,kz-1,j)*fnp(kz)+0.5*g_u(i+1,kz,j)*fnm(kz)+0.5*g_u(i,kz,j)*fnm(kz)
    ub = 0.5*(fnm(kz)*(u(i+1,kz,j)+u(i,kz,j))+fnp(kz)*(u(i+1,kz-1,j)+u(i,kz-1,j)))
    g_ur = g_ub*(0.5+sign(0.5,ub-0.))
    ur = amax1(ub,0.)
    g_ph_tend(i,k,j) = (-(g_mut(i,j)*rdx*ur*(ph_old(i,k,j)-ph_old(i-1,k,j))))+g_ph_old(i-1,k,j)*rdx*mut(i,j)*ur-g_ph_old(i,k,j)*&
&rdx*mut(i,j)*ur+g_ph_tend(i,k,j)-g_ur*rdx*mut(i,j)*(ph_old(i,k,j)-ph_old(i-1,k,j))
    ph_tend(i,k,j) = ph_tend(i,k,j)-rdx*mut(i,j)*ur*(ph_old(i,k,j)-ph_old(i-1,k,j))
  end do
endif

   call trace_exit("g_rhs_ph")

end subroutine g_rhs_ph


subroutine g_vertical_diffusion( name, field, g_field, tendency, g_tendency, alt, g_alt, mut, g_mut, rdn, rdnw, kvdif, ide, jde, &
&kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mut(ims:ime,jms:jme)
real, intent(inout) :: g_tendency(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
real, intent(in) :: mut(ims:ime,jms:jme)
character*(1), intent(in) :: name
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(inout) :: tendency(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real g_vflux(its:ite,0:kte+1)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real vflux(its:ite,0:kte+1)

   call trace_entry("g_vertical_diffusion")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
ktf = min(kte,kde-1)
if (name .eq. 'w') then
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  j_loop_w: do j = j_start, j_end
    do k = kts, ktf-1
      do i = i_start, i_end
        g_vflux(i,k) = (-(g_alt(i,k,j)*kvdif/(alt(i,k,j)*alt(i,k,j))*rdnw(k)*(field(i,k+1,j)-field(i,k,j))))+g_field(i,k+1,j)*&
&kvdif/alt(i,k,j)*rdnw(k)-g_field(i,k,j)*kvdif/alt(i,k,j)*rdnw(k)
        vflux(i,k) = kvdif/alt(i,k,j)*rdnw(k)*(field(i,k+1,j)-field(i,k,j))
      end do
    end do
    do i = i_start, i_end
      g_vflux(i,ktf) = 0.
      vflux(i,ktf) = 0.
    end do
    do k = kts+1, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = (-(g_alt(i,k-1,j)*0.5*(rdn(k)*g*g/mut(i,j))/(0.5*0.5*(alt(i,k,j)+alt(i,k-1,j))*(alt(i,k,j)+alt(i,k-1,j)&
&))*(vflux(i,k)-vflux(i,k-1))))-g_alt(i,k,j)*0.5*(rdn(k)*g*g/mut(i,j))/(0.5*0.5*(alt(i,k,j)+alt(i,k-1,j))*(alt(i,k,j)+&
&alt(i,k-1,j)))*(vflux(i,k)-vflux(i,k-1))-g_mut(i,j)*rdn(k)*g*g/(mut(i,j)*mut(i,j))/(0.5*(alt(i,k,j)+alt(i,k-1,j)))*&
&(vflux(i,k)-vflux(i,k-1))+g_tendency(i,k,j)-g_vflux(i,k-1)*(rdn(k)*g*g/mut(i,j)/(0.5*(alt(i,k,j)+alt(i,k-1,j))))+&
&g_vflux(i,k)*(rdn(k)*g*g/mut(i,j)/(0.5*(alt(i,k,j)+alt(i,k-1,j))))
        tendency(i,k,j) = tendency(i,k,j)+rdn(k)*g*g/mut(i,j)/(0.5*(alt(i,k,j)+alt(i,k-1,j)))*(vflux(i,k)-vflux(i,k-1))
      end do
    end do
  end do j_loop_w
else if (name .eq. 'm') then
  i_start = its
  i_end = min(ite,ide-1)
  j_start = jts
  j_end = min(jte,jde-1)
  j_loop_s: do j = j_start, j_end
    do k = kts, ktf-1
      do i = i_start, i_end
        g_vflux(i,k) = (-(g_alt(i,k+1,j)*0.5*kvdif*rdn(k+1)/(0.5*0.5*(alt(i,k,j)+alt(i,k+1,j))*(alt(i,k,j)+alt(i,k+1,j)))*(field(i,&
&k+1,j)-field(i,k,j))))-g_alt(i,k,j)*0.5*kvdif*rdn(k+1)/(0.5*0.5*(alt(i,k,j)+alt(i,k+1,j))*(alt(i,k,j)+alt(i,k+1,j)))*&
&(field(i,k+1,j)-field(i,k,j))+g_field(i,k+1,j)*(kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j))))-g_field(i,k,j)*(kvdif*&
&rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j))))
        vflux(i,k) = kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j)))*(field(i,k+1,j)-field(i,k,j))
      end do
    end do
    do i = i_start, i_end
      g_vflux(i,0) = g_vflux(i,1)
      vflux(i,0) = vflux(i,1)
    end do
    do i = i_start, i_end
      g_vflux(i,ktf) = 0.
      vflux(i,ktf) = 0.
    end do
    do k = kts, ktf
      do i = i_start, i_end
        g_tendency(i,k,j) = (-(g_alt(i,k,j)*g*g/mut(i,j)/(alt(i,k,j)*alt(i,k,j))*rdnw(k)*(vflux(i,k)-vflux(i,k-1))))-g_mut(i,j)*g*&
&g/(mut(i,j)*mut(i,j))/alt(i,k,j)*rdnw(k)*(vflux(i,k)-vflux(i,k-1))+g_tendency(i,k,j)-g_vflux(i,k-1)*g*g/mut(i,j)/alt(i,k,&
&j)*rdnw(k)+g_vflux(i,k)*g*g/mut(i,j)/alt(i,k,j)*rdnw(k)
        tendency(i,k,j) = tendency(i,k,j)+g*g/mut(i,j)/alt(i,k,j)*rdnw(k)*(vflux(i,k)-vflux(i,k-1))
      end do
    end do
  end do j_loop_s
endif

   call trace_exit("g_vertical_diffusion")

end subroutine g_vertical_diffusion


subroutine g_vertical_diffusion_3dmp( field, g_field, tendency, g_tendency, base_3d, alt, g_alt, mut, g_mut, rdn, rdnw, kvdif, ide,&
& jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: base_3d(ims:ime,kms:kme,jms:jme)
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mut(ims:ime,jms:jme)
real, intent(inout) :: g_tendency(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(inout) :: tendency(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real g_vflux(its:ite,0:kte+1)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real vflux(its:ite,0:kte+1)

   call trace_entry("g_vertical_diffusion_3dmp")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
ktf = min(kte,kde-1)
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
j_loop_s: do j = j_start, j_end
  do k = kts, ktf-1
    do i = i_start, i_end
      g_vflux(i,k) = (-(g_alt(i,k+1,j)*0.5*kvdif*rdn(k+1)/(0.5*0.5*(alt(i,k,j)+alt(i,k+1,j))*(alt(i,k,j)+alt(i,k+1,j)))*(field(i,k+&
&1,j)-field(i,k,j)-base_3d(i,k+1,j)+base_3d(i,k,j))))-g_alt(i,k,j)*0.5*kvdif*rdn(k+1)/(0.5*0.5*(alt(i,k,j)+alt(i,k+1,j))*&
&(alt(i,k,j)+alt(i,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-base_3d(i,k+1,j)+base_3d(i,k,j))+g_field(i,k+1,j)*(kvdif*rdn(k+1)/&
&(0.5*(alt(i,k,j)+alt(i,k+1,j))))-g_field(i,k,j)*(kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j))))
      vflux(i,k) = kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-base_3d(i,k+1,j)+base_3d(i,k,j))
    end do
  end do
  do i = i_start, i_end
    g_vflux(i,0) = g_vflux(i,1)
    vflux(i,0) = vflux(i,1)
  end do
  do i = i_start, i_end
    g_vflux(i,ktf) = 0.
    vflux(i,ktf) = 0.
  end do
  do k = kts, ktf
    do i = i_start, i_end
      g_tendency(i,k,j) = (-(g_alt(i,k,j)*g*g/mut(i,j)/(alt(i,k,j)*alt(i,k,j))*rdnw(k)*(vflux(i,k)-vflux(i,k-1))))-g_mut(i,j)*g*g/&
&(mut(i,j)*mut(i,j))/alt(i,k,j)*rdnw(k)*(vflux(i,k)-vflux(i,k-1))+g_tendency(i,k,j)-g_vflux(i,k-1)*g*g/mut(i,j)/alt(i,k,j)*&
&rdnw(k)+g_vflux(i,k)*g*g/mut(i,j)/alt(i,k,j)*rdnw(k)
      tendency(i,k,j) = tendency(i,k,j)+g*g/mut(i,j)/alt(i,k,j)*rdnw(k)*(vflux(i,k)-vflux(i,k-1))
    end do
  end do
end do j_loop_s

   call trace_exit("g_vertical_diffusion_3dmp")

end subroutine g_vertical_diffusion_3dmp


subroutine g_vertical_diffusion_mp( field, g_field, tendency, g_tendency, base, alt, g_alt, mut, g_mut, rdn, rdnw, kvdif, ide, jde,&
& kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: base(kms:kme)
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mut(ims:ime,jms:jme)
real, intent(inout) :: g_tendency(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(inout) :: tendency(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real g_vflux(its:ite,0:kte+1)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real vflux(its:ite,0:kte+1)

   call trace_entry("g_vertical_diffusion_mp")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
ktf = min(kte,kde-1)
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
j_loop_s: do j = j_start, j_end
  do k = kts, ktf-1
    do i = i_start, i_end
      g_vflux(i,k) = (-(g_alt(i,k+1,j)*0.5*kvdif*rdn(k+1)/(0.5*0.5*(alt(i,k,j)+alt(i,k+1,j))*(alt(i,k,j)+alt(i,k+1,j)))*(field(i,k+&
&1,j)-field(i,k,j)-base(k+1)+base(k))))-g_alt(i,k,j)*0.5*kvdif*rdn(k+1)/(0.5*0.5*(alt(i,k,j)+alt(i,k+1,j))*(alt(i,k,j)+alt(i,&
&k+1,j)))*(field(i,k+1,j)-field(i,k,j)-base(k+1)+base(k))+g_field(i,k+1,j)*(kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j))))-&
&g_field(i,k,j)*(kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j))))
      vflux(i,k) = kvdif*rdn(k+1)/(0.5*(alt(i,k,j)+alt(i,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-base(k+1)+base(k))
    end do
  end do
  do i = i_start, i_end
    g_vflux(i,0) = g_vflux(i,1)
    vflux(i,0) = vflux(i,1)
  end do
  do i = i_start, i_end
    g_vflux(i,ktf) = 0.
    vflux(i,ktf) = 0.
  end do
  do k = kts, ktf
    do i = i_start, i_end
      g_tendency(i,k,j) = (-(g_alt(i,k,j)*g*g/mut(i,j)/(alt(i,k,j)*alt(i,k,j))*rdnw(k)*(vflux(i,k)-vflux(i,k-1))))-g_mut(i,j)*g*g/&
&(mut(i,j)*mut(i,j))/alt(i,k,j)*rdnw(k)*(vflux(i,k)-vflux(i,k-1))+g_tendency(i,k,j)-g_vflux(i,k-1)*g*g/mut(i,j)/alt(i,k,j)*&
&rdnw(k)+g_vflux(i,k)*g*g/mut(i,j)/alt(i,k,j)*rdnw(k)
      tendency(i,k,j) = tendency(i,k,j)+g*g/mut(i,j)/alt(i,k,j)*rdnw(k)*(vflux(i,k)-vflux(i,k-1))
    end do
  end do
end do j_loop_s

   call trace_exit("g_vertical_diffusion_mp")

end subroutine g_vertical_diffusion_mp


subroutine g_vertical_diffusion_u( field, g_field, tendency, g_tendency, config_flags, u_base, alt, g_alt, muu, g_muu, rdn, rdnw, &
&kvdif, ids, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_muu(ims:ime,jms:jme)
real, intent(inout) :: g_tendency(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(inout) :: tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u_base(kms:kme)

!==============================================
! declare local variables
!==============================================
real g_vflux(its:ite,0:kte+1)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
logical specified
real vflux(its:ite,0:kte+1)

   call trace_entry("g_vertical_diffusion_u")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
ktf = min(kte,kde-1)
i_start = its
i_end = ite
j_start = jts
j_end = min(jte,jde-1)
if (config_flags%open_xs .or. specified) then
  i_start = max(ids+1,its)
endif
if (config_flags%open_xe .or. specified) then
  i_end = min(ide-1,ite)
endif
j_loop_u: do j = j_start, j_end
  do k = kts, ktf-1
    do i = i_start, i_end
      g_vflux(i,k) = (-(g_alt(i-1,k+1,j)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j))*&
&(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-u_base(k+1)+u_base(k))))-g_alt(i,k+1,j)*&
&0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j))*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+&
&alt(i-1,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-u_base(k+1)+u_base(k))-g_alt(i-1,k,j)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,&
&j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j))*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j)))*(field(i,k+1,j)-field(i,&
&k,j)-u_base(k+1)+u_base(k))-g_alt(i,k,j)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j)&
&)*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-u_base(k+1)+u_base(k))+g_field(i,k+1,&
&j)*(kvdif*rdn(k+1)/(0.25*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j))))-g_field(i,k,j)*(kvdif*rdn(k+1)/(0.25*&
&(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j))))
      vflux(i,k) = kvdif*rdn(k+1)/(0.25*(alt(i,k,j)+alt(i-1,k,j)+alt(i,k+1,j)+alt(i-1,k+1,j)))*(field(i,k+1,j)-field(i,k,j)-&
&u_base(k+1)+u_base(k))
    end do
  end do
  do i = i_start, i_end
    g_vflux(i,0) = g_vflux(i,1)
    vflux(i,0) = vflux(i,1)
  end do
  do i = i_start, i_end
    g_vflux(i,ktf) = 0.
    vflux(i,ktf) = 0.
  end do
  do k = kts, ktf-1
    do i = i_start, i_end
      g_tendency(i,k,j) = (-(g_alt(i-1,k,j)*0.5*(g*g*rdnw(k)/muu(i,j))/(0.5*0.5*(alt(i-1,k,j)+alt(i,k,j))*(alt(i-1,k,j)+alt(i,k,j))&
&)*(vflux(i,k)-vflux(i,k-1))))-g_alt(i,k,j)*0.5*(g*g*rdnw(k)/muu(i,j))/(0.5*0.5*(alt(i-1,k,j)+alt(i,k,j))*(alt(i-1,k,j)+&
&alt(i,k,j)))*(vflux(i,k)-vflux(i,k-1))-g_muu(i,j)*g*g*rdnw(k)/(muu(i,j)*muu(i,j))/(0.5*(alt(i-1,k,j)+alt(i,k,j)))*(vflux(i,&
&k)-vflux(i,k-1))+g_tendency(i,k,j)-g_vflux(i,k-1)*(g*g*rdnw(k)/muu(i,j)/(0.5*(alt(i-1,k,j)+alt(i,k,j))))+g_vflux(i,k)*(g*g*&
&rdnw(k)/muu(i,j)/(0.5*(alt(i-1,k,j)+alt(i,k,j))))
      tendency(i,k,j) = tendency(i,k,j)+g*g*rdnw(k)/muu(i,j)/(0.5*(alt(i-1,k,j)+alt(i,k,j)))*(vflux(i,k)-vflux(i,k-1))
    end do
  end do
end do j_loop_u

   call trace_exit("g_vertical_diffusion_u")

end subroutine g_vertical_diffusion_u


subroutine g_vertical_diffusion_v( field, g_field, tendency, g_tendency, config_flags, v_base, alt, g_alt, muv, g_muv, rdn, rdnw, &
&kvdif, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_field(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_muv(ims:ime,jms:jme)
real, intent(inout) :: g_tendency(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
real, intent(in) :: muv(ims:ime,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(inout) :: tendency(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v_base(kms:kme)

!==============================================
! declare local variables
!==============================================
real g_vflux(its:ite,0:kte+1)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer jm1
integer k
integer ktf
logical specified
real vflux(its:ite,0:kte+1)

   call trace_entry("g_vertical_diffusion_v")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
specified =  .false. 
if (config_flags%specified .or. config_flags%nested) then
  specified =  .true. 
endif
ktf = min(kte,kde-1)
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
if (config_flags%open_ys .or. specified) then
  j_start = max(jds+1,jts)
endif
if (config_flags%open_ye .or. specified) then
  j_end = min(jde-1,jte)
endif
j_loop_v: do j = j_start, j_end
  jm1 = j-1
  do k = kts, ktf-1
    do i = i_start, i_end
      g_vflux(i,k) = (-(g_alt(i,k+1,j)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1))*(alt(i,&
&k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1)))*(field(i,k+1,j)-field(i,k,j)-v_base(k+1)+v_base(k))))-g_alt(i,k+1,jm1)*0.25*&
&kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1))*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,&
&k+1,jm1)))*(field(i,k+1,j)-field(i,k,j)-v_base(k+1)+v_base(k))-g_alt(i,k,j)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+&
&alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1))*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1)))*(field(i,k+1,j)-field(i,k,&
&j)-v_base(k+1)+v_base(k))-g_alt(i,k,jm1)*0.25*kvdif*rdn(k+1)/(0.25*0.25*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1)&
&)*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1)))*(field(i,k+1,j)-field(i,k,j)-v_base(k+1)+v_base(k))+g_field(i,k+1,&
&j)*(kvdif*rdn(k+1)/(0.25*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1))))-g_field(i,k,j)*(kvdif*rdn(k+1)/(0.25*&
&(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1))))
      vflux(i,k) = kvdif*rdn(k+1)/(0.25*(alt(i,k,j)+alt(i,k,jm1)+alt(i,k+1,j)+alt(i,k+1,jm1)))*(field(i,k+1,j)-field(i,k,j)-&
&v_base(k+1)+v_base(k))
    end do
  end do
  do i = i_start, i_end
    g_vflux(i,0) = g_vflux(i,1)
    vflux(i,0) = vflux(i,1)
  end do
  do i = i_start, i_end
    g_vflux(i,ktf) = 0.
    vflux(i,ktf) = 0.
  end do
  do k = kts, ktf-1
    do i = i_start, i_end
      g_tendency(i,k,j) = (-(g_alt(i,k,j)*0.5*(g*g*rdnw(k)/muv(i,j))/(0.5*0.5*(alt(i,k,jm1)+alt(i,k,j))*(alt(i,k,jm1)+alt(i,k,j)))*&
&(vflux(i,k)-vflux(i,k-1))))-g_alt(i,k,jm1)*0.5*(g*g*rdnw(k)/muv(i,j))/(0.5*0.5*(alt(i,k,jm1)+alt(i,k,j))*(alt(i,k,jm1)+&
&alt(i,k,j)))*(vflux(i,k)-vflux(i,k-1))-g_muv(i,j)*g*g*rdnw(k)/(muv(i,j)*muv(i,j))/(0.5*(alt(i,k,jm1)+alt(i,k,j)))*(vflux(i,&
&k)-vflux(i,k-1))+g_tendency(i,k,j)-g_vflux(i,k-1)*(g*g*rdnw(k)/muv(i,j)/(0.5*(alt(i,k,jm1)+alt(i,k,j))))+g_vflux(i,k)*(g*g*&
&rdnw(k)/muv(i,j)/(0.5*(alt(i,k,jm1)+alt(i,k,j))))
      tendency(i,k,j) = tendency(i,k,j)+g*g*rdnw(k)/muv(i,j)/(0.5*(alt(i,k,jm1)+alt(i,k,j)))*(vflux(i,k)-vflux(i,k-1))
    end do
  end do
end do j_loop_v

   call trace_exit("g_vertical_diffusion_v")

end subroutine g_vertical_diffusion_v


subroutine g_w_damp( rw_tend, g_rw_tend, ww, g_ww, w, g_w, mut, g_mut, rdnw, dt, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, &
&ite, jts, jte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real, intent(in) :: dt
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_mut(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: g_rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ww(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdnw(kms:kme)
real, intent(inout) :: rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ww(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real cf_d
real cf_n
real cfl
real g_cf_d
real g_cf_n
integer i
integer itf
integer j
integer jtf
integer k

   call trace_entry("g_w_damp")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
itf = min(ite,ide-1)
jtf = min(jte,jde-1)
do j = jts, jtf
  do k = 2, kde-1
    do i = its, itf
      g_cf_n = g_ww(i,k,j)*sign(1.,ww(i,k,j))
      cf_n = abs(ww(i,k,j))
      g_cf_d = g_mut(i,j)*rdnw(k)*dt*sign(1.,mut(i,j)*rdnw(k)*dt)
      cf_d = abs(mut(i,j)*rdnw(k)*dt)
      if (cf_n .gt. cf_d*w_beta) then
        g_rw_tend(i,k,j) = (-(g_mut(i,j)*w_alpha*(cfl-w_beta)*sign(1.,w(i,k,j))))+g_rw_tend(i,k,j)
        rw_tend(i,k,j) = rw_tend(i,k,j)-sign(1.,w(i,k,j))*w_alpha*(cfl-w_beta)*mut(i,j)
      endif
    end do
  end do
end do

   call trace_exit("g_w_damp")

end subroutine g_w_damp


subroutine g_zero_tend( tendency, g_tendency, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: g_tendency(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(inout) :: tendency(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer j
integer k

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
!do j = jts, jte
!  do k = kts, kte
!    do i = its, ite
!      g_tendency(i,k,j) = 0.
!      tendency(i,k,j) = 0.
!    end do
!  end do
!end do
g_tendency(its:ite,kts:kte,jts:jte) = 0.
tendency(its:ite,kts:kte,jts:jte) = 0.

end subroutine g_zero_tend
!Zhang Xiaoyan 11/02/2006 

!=======================================================================================================
subroutine g_surface_drag( ru_tendf, g_ru_tendf, rv_tendf, g_rv_tendf, u, g_u, v, g_v, xland, muu, g_muu, muv, &
&g_muv, z, g_z, z_at_w, g_z_at_w, ids, ide, jds, jde, kds, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.8.71  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_muu(ims:ime,jms:jme)
real, intent(in) :: g_muv(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: g_ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_z(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_z_at_w(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kds
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
!integer, intent(in) :: rk_step
real, intent(inout) :: ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: xland(ims:ime,jms:jme)
real, intent(in) :: z(ims:ime,kms:kme,jms:jme)
real, intent(in) :: z_at_w(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real cd
real g_cd
real g_tao_xz
real g_tao_yz
real g_v0_u
real g_v0_v
real g_zu
real g_zv
real g_zwt
integer i
integer i_end
integer i_endu
integer i_start
integer j
integer j_end
integer j_endv
integer j_start
integer k
real tao_xz
real tao_yz
real v0_u
real v0_uh
real v0_v
real v0_vh
real zu
real zv
real zwt

REAL, PARAMETER :: epsilon = 1.e-10

   call trace_entry("g_surface_drag")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
i_start = its
i_end = min(ite,ide-1)
i_endu = ite
j_start = jts
j_end = min(jte,jde-1)
j_endv = jte
do j = j_start, j_end
  do i = i_start, i_endu
    v0_uh = u(i,kts,j)**2+((v(i,kts,j)+v(i,kts,j+1)+v(i-1,kts,j)+v(i-1,kts,j+1))/4)**2
    g_v0_u = (2*g_u(i,kts,j)*u(i,kts,j)+2*g_v(i-1,kts,j+1)/float(4)*((v(i,kts,j)+v(i,kts,j+1)+v(i-1,kts,j)+v(i-1,kts,j+1))/float(4)&
&)+2*g_v(i,kts,j+1)/float(4)*((v(i,kts,j)+v(i,kts,j+1)+v(i-1,kts,j)+v(i-1,kts,j+1))/float(4))+2*g_v(i-1,kts,j)/float(4)*((v(i,&
&kts,j)+v(i,kts,j+1)+v(i-1,kts,j)+v(i-1,kts,j+1))/float(4))+2*g_v(i,kts,j)/float(4)*((v(i,kts,j)+v(i,kts,j+1)+v(i-1,kts,j)+v(i-&
&1,kts,j+1))/float(4)))*(1./(2.*sqrt(v0_uh)))
    v0_u = sqrt(v0_uh)+epsilon
    if (xland(i,j) .eq. xland(i-1,j)) then
      if (xland(i,j) .lt. 1.5) then
        g_cd = 0.
        cd = 0.01
      else
        g_cd = 0.
        cd = 0.001
        g_cd = g_cd*(0.5+sign(0.5,cd-0.0001*v0_u))+0.0001*g_v0_u*(0.5-sign(0.5,cd-0.0001*v0_u))
        cd = max(cd,0.0001*v0_u)
        g_cd = g_cd*(0.5+sign(0.5,0.003-cd))
        cd = min(cd,0.003)
      endif
    else
      g_cd = 0.
      cd = 0.003
    endif
    g_tao_xz = g_cd*v0_u*u(i,kts,j)+g_u(i,kts,j)*cd*v0_u+g_v0_u*cd*u(i,kts,j)
    tao_xz = cd*v0_u*u(i,kts,j)
    do k = kts, kte
      g_zu = 0.5*g_z(i-1,k,j)+0.5*g_z(i,k,j)-0.5*g_z_at_w(i-1,kts,j)-0.5*g_z_at_w(i,kts,j)
      zu = 0.5*(z(i,k,j)+z(i-1,k,j)-z_at_w(i,kts,j)-z_at_w(i-1,kts,j))
      if (zu .lt. 1000.) then
        g_zwt = (-0.002)*g_zu
        zwt = 2.*(1000.-zu)/1000.
        g_ru_tendf(i,k,j) = (-(g_muu(i,j)*(0.5*zwt*tao_xz/1000.)))+g_ru_tendf(i,k,j)-g_tao_xz*(0.5*zwt*muu(i,j)/1000.)-g_zwt*(0.5*&
&muu(i,j)*tao_xz/1000.)
!X        ru_tendf(i,k,j) = ru_tendf(i,k,j)-zwt*0.5*muu(i,j)*tao_xz/1000.
      endif
    end do
  end do
end do
do j = j_start, j_endv
  do i = i_start, i_end
    v0_vh = v(i,kts,j)**2+((u(i,kts,j)+u(i,kts,j-1)+u(i+1,kts,j)+u(i+1,kts,j-1))/4)**2
    g_v0_v = (2*g_u(i+1,kts,j-1)/float(4)*((u(i,kts,j)+u(i,kts,j-1)+u(i+1,kts,j)+u(i+1,kts,j-1))/float(4))+2*g_u(i,kts,j-1)/&
&float(4)*((u(i,kts,j)+u(i,kts,j-1)+u(i+1,kts,j)+u(i+1,kts,j-1))/float(4))+2*g_u(i+1,kts,j)/float(4)*((u(i,kts,j)+u(i,kts,j-1)+& 
&u(i+1,kts,j)+u(i+1,kts,j-1))/float(4))+2*g_u(i,kts,j)/float(4)*((u(i,kts,j)+u(i,kts,j-1)+u(i+1,kts,j)+u(i+1,kts,j-1))/float(4)& 
&)+2*g_v(i,kts,j)*v(i,kts,j))*(1./(2.*sqrt(v0_vh)))
    v0_v = sqrt(v0_vh)+epsilon
    if (xland(i,j) .eq. xland(i,j-1)) then
      if (xland(i,j) .lt. 1.5) then
        g_cd = 0.
        cd = 0.01
      else
        g_cd = 0.
        cd = 0.001
        g_cd = g_cd*(0.5+sign(0.5,cd-0.0001*v0_v))+0.0001*g_v0_v*(0.5-sign(0.5,cd-0.0001*v0_v))
        cd = max(cd,0.0001*v0_v)
        g_cd = g_cd*(0.5+sign(0.5,0.003-cd))
        cd = min(cd,0.003)
      endif 
    else
      g_cd = 0.
      cd = 0.003
    endif
    g_tao_yz = g_cd*v0_v*v(i,kts,j)+g_v(i,kts,j)*cd*v0_v+g_v0_v*cd*v(i,kts,j)
    tao_yz = cd*v0_v*v(i,kts,j)
    do k = kts, kte
      g_zv = 0.5*g_z(i,k,j-1)+0.5*g_z(i,k,j)-0.5*g_z_at_w(i,kts,j-1)-0.5*g_z_at_w(i,kts,j)
      zv = 0.5*(z(i,k,j)+z(i,k,j-1)-z_at_w(i,kts,j)-z_at_w(i,kts,j-1))
      if (zv .lt. 1000.) then
     g_zwt = (-0.002)*g_zv
        zwt = 2.*(1000.-zv)/1000.
        g_rv_tendf(i,k,j) = (-(g_muv(i,j)*(0.5*zwt*tao_yz/1000.)))+g_rv_tendf(i,k,j)-g_tao_yz*(0.5*zwt*muv(i,j)/1000.)-g_zwt*(0.5*&
&muv(i,j)*tao_yz/1000.)
!X        rv_tendf(i,k,j) = rv_tendf(i,k,j)-zwt*0.5*muv(i,j)*tao_yz/1000.
      endif
    end do
  end do
end do

   call trace_exit("g_surface_drag")

end subroutine g_surface_drag



!                           DISCLAIMER
!
!   This file was generated by TAF version 1.8.81
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine g_moist_physics_prep_em( t_new, g_t_new, t_old, g_t_old, t0, rho, g_rho, al, g_al, alb, p, g_p, p8w, g_p8w, p0, &
&pb, ph, g_ph, phb, pii, g_pii, pf, g_pf, z, g_z, z_at_w, g_z_at_w, dz8w, g_dz8w, dt, h_diabatic, g_h_diabatic, &
&config_flags, fzm, fzp, ids, ide, jds, jde, kds, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.8.81  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alb(ims:ime,kms:kme,jms:jme)
type(grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: dt
real, intent(out) :: dz8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: fzm(kms:kme)
real, intent(in) :: fzp(kms:kme)
real, intent(in) :: g_al(ims:ime,kms:kme,jms:jme)
real             :: g_alb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_dz8w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_h_diabatic(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_p(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_p8w(ims:ime,kms:kme,jms:jme)
real             :: g_pb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_pf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ph(ims:ime,kms:kme,jms:jme)
real             :: g_phb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_pii(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_rho(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_t_new(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_t_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_z(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_z_at_w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: h_diabatic(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kds
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: p0
real, intent(out) :: p8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: pf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: pii(ims:ime,kms:kme,jms:jme)
real, intent(out) :: rho(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t0
real, intent(inout) :: t_new(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: t_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: z(ims:ime,kms:kme,jms:jme)
real, intent(out) :: z_at_w(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real g_w1
real g_w2
real g_z0
real g_z1
real g_z2
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer k_end
integer k_start
real w1
real w2
real z0
real z1
real z2
real walls(4)

   call trace_entry("g_moist_physics_prep_em")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
g_pb(:,:,:)=0.
g_phb(:,:,:)=0.
g_alb(:,:,:)=0.

i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
k_start = kts
k_end = min(kte,kde-1)

do j = j_start, j_end
  do k = k_start, kte
    do i = i_start, i_end
      g_z_at_w(i,k,j) = (g_ph(i,k,j)+g_phb(i,k,j))/g
      z_at_w(i,k,j) = (ph(i,k,j)+phb(i,k,j))/g
    end do
  end do
end do

!do j = j_start, j_end
!  do k = k_start, kte-1
!    do i = i_start, i_end
!      g_dz8w(i,k,j) = g_z_at_w(i,k+1,j)-g_z_at_w(i,k,j)
!      dz8w(i,k,j) = z_at_w(i,k+1,j)-z_at_w(i,k,j)
!    end do
!  end do
!end do

g_dz8w(i_start:i_end,k_start:kte-1,j_start:j_end) = g_z_at_w(i_start:i_end,k_start+1:kte,j_start:j_end)&
&-g_z_at_w(i_start:i_end,k_start:kte-1,j_start:j_end)
dz8w(i_start:i_end,k_start:kte-1,j_start:j_end) = z_at_w(i_start:i_end,k_start+1:kte,j_start:j_end)&
&-z_at_w(i_start:i_end,k_start:kte-1,j_start:j_end)

do j = j_start, j_end
  do i = i_start, i_end
    g_dz8w(i,kte,j) = 0.
    dz8w(i,kte,j) = 0.
  end do
end do

t_new(i_start:i_end,k_start:k_end,j_start:j_end) = t_new(i_start:i_end,k_start:k_end,j_start:j_end)+t0
t_old(i_start:i_end,k_start:k_end,j_start:j_end) = t_old(i_start:i_end,k_start:k_end,j_start:j_end)+t0

do j = j_start, j_end
  do k = k_start, k_end
    do i = i_start, i_end
      rho(i,k,j) = 1./(al(i,k,j)+alb(i,k,j))
      g_rho(i,k,j) = (-g_al(i,k,j)+g_alb(i,k,j))*rho(i,k,j)

      walls(1)=(p(i,k,j)+pb(i,k,j))/p0
      walls(2)=walls(1)**(rcp-1)

      g_pii(i,k,j) = (g_p(i,k,j)+g_pb(i,k,j))*rcp/p0*walls(2)
      pii(i,k,j) = walls(1)*walls(2)
    end do
  end do
end do

g_z(i_start:i_end,k_start:k_end,j_start:j_end) = 0.5*g_z_at_w(i_start:i_end,k_start+1:k_end+1,j_start:j_end)&
&+0.5*g_z_at_w(i_start:i_end,k_start:k_end,j_start:j_end)
z(i_start:i_end,k_start:k_end,j_start:j_end) = 0.5*z_at_w(i_start:i_end,k_start:k_end,j_start:j_end)&
&+0.5*z_at_w(i_start:i_end,k_start+1:k_end+1,j_start:j_end)
g_pf(i_start:i_end,k_start:k_end,j_start:j_end) = g_p(i_start:i_end,k_start:k_end,j_start:j_end)&
&+g_pb(i_start:i_end,k_start:k_end,j_start:j_end)
pf(i_start:i_end,k_start:k_end,j_start:j_end) = p(i_start:i_end,k_start:k_end,j_start:j_end)&
&+pb(i_start:i_end,k_start:k_end,j_start:j_end)

   call trace_exit("g_moist_physics_prep_em")

end subroutine g_moist_physics_prep_em


!                           DISCLAIMER
!
!   This file was generated by TAF version 1.8.81
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine g_moist_physics_finish_em( t_new, g_t_new, t_old, g_t_old, t0, mut, g_mut, h_diabatic, g_h_diabatic, dt, config_flags, &
&ids, ide, jds, jde, kds, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.8.81  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type(grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: dt
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: g_h_diabatic(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_mut(ims:ime,jms:jme)
real, intent(inout) :: g_t_new(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_t_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: h_diabatic(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kds
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(inout) :: mut(ims:ime,jms:jme)
real, intent(in) :: t0
real, intent(inout) :: t_new(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: t_old(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer k_end
integer k_start

   call trace_entry("g_moist_physics_finish_em")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
k_start = kts
k_end = min(kte,kde-1)

!do j = j_start, j_end
!  do k = k_start, k_end
!    do i = i_start, i_end
!      g_t_new(i,k,j) = g_t_new(i,k,j)
!      t_new(i,k,j) = t_new(i,k,j)-t0
!      g_t_old(i,k,j) = g_t_old(i,k,j)
!      t_old(i,k,j) = t_old(i,k,j)-t0
!    end do
!  end do
!end do

!g_t_new(i_start:i_end,k_start:k_end,j_start:j_end) = g_t_new(i_start:i_end,k_start:k_end,j_start:j_end)
t_new(i_start:i_end,k_start:k_end,j_start:j_end) = t_new(i_start:i_end,k_start:k_end,j_start:j_end)-t0
!g_t_old(i_start:i_end,k_start:k_end,j_start:j_end) = g_t_old(i_start:i_end,k_start:k_end,j_start:j_end)
t_old(i_start:i_end,k_start:k_end,j_start:j_end) = t_old(i_start:i_end,k_start:k_end,j_start:j_end)-t0

   call trace_exit("g_moist_physics_finish_em")

end subroutine g_moist_physics_finish_em


end module g_module_big_step_utilities_em
