!                           DISCLAIMER
!
!   This file was generated by TAF version 1.7.18
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     a_module_diffusion_em
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use module_configure
use module_bc
use a_module_bc
use module_state_description
use module_big_step_utilities_em
use a_module_big_step_utilities_em
use module_model_constants
use module_wrf_error
use module_diffusion_em

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine a_cal_dampkm( xkmhd, a_xkmhd, dx, dt, dampcoef, rdz, rdzw, zdamp, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite,&
& jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dampcoef
real, intent(in) :: dt
real, intent(in) :: dx
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: rdz(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdzw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(in) :: zdamp

!==============================================
! declare local variables
!==============================================
real dampk(its:ite,kts:kte,jts:jte)
real degrad90
real deltaz(its:ite)
real dz
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
real kmmax
integer ktf
integer ktfm1
real tmp

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
ktf = min(kte,kde-1)
! recompute : ktf
ktfm1 = ktf-1
! recompute : ktfm1
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
kmmax = dx*dx/dt
! recompute : kmmax
degrad90 = degrad*90.
! recompute : degrad90
do j = j_start, j_end
  k = ktf
  do i = i_start, i_end
    dz = 1./rdzw(i,k,j)
    deltaz(i) = 0.5*dz
    tmp = min(deltaz(i)/zdamp,1.)
    dampk(i,k,j) = cos(degrad90*tmp)*kmmax*dampcoef
  end do
  do k = ktfm1, kts, -1
    do i = i_start, i_end
      dz = 1./rdz(i,k,j)
      deltaz(i) = deltaz(i)+dz
      tmp = min(deltaz(i)/zdamp,1.)
      dampk(i,k,j) = cos(degrad90*tmp)*kmmax*dampcoef
    end do
  end do
end do
! recompute : dampk
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      a_xkmhd(i,k,j) = a_xkmhd(i,k,j)*(0.5+sign(0.5,xkmhd(i,k,j)-dampk(i,k,j)))
    end do
  end do
end do

end subroutine a_cal_dampkm


subroutine a_calc_l_scale( tke, bn2, a_bn2, l_scale, a_l_scale, i_start, i_end, ktf, j_start, j_end, dx, dy, rdzw, ims, ime, jms, &
&jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_bn2(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(inout) :: a_l_scale(its:ite,kts:kte,jts:jte)
real, intent(in) :: bn2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dx
real, intent(in) :: dy
integer, intent(in) :: i_end
integer, intent(in) :: i_start
integer, intent(in) :: j_end
integer, intent(in) :: j_start
integer, intent(in) :: ktf
real, intent(out) :: l_scale(its:ite,kts:kte,jts:jte)
real, intent(in) :: rdzw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: tke(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real deltas
integer i
integer j
integer k
real tmp

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      deltas = (dx*dy/rdzw(i,k,j))**0.33333333
! recompute : deltas
      l_scale(i,k,j) = deltas
      if (bn2(i,k,j) .gt. 1.e-6) then
        tmp = sqrt(max(tke(i,k,j),1.e-6))
! recompute : tmp
        l_scale(i,k,j) = 0.76*tmp/sqrt(bn2(i,k,j))
! recompute : l_scale
        l_scale(i,k,j) = min(l_scale(i,k,j),deltas)
! recompute : l_scale
        a_l_scale(i,k,j) = a_l_scale(i,k,j)*(0.5+sign(0.5,l_scale(i,k,j)-0.001*deltas))
! recdepend vars : bn2,i,j,k,tmp
! recompute pos : ASSIGN_STMT module_diffusion_em.f90:1870
! recompute vars : l_scale
        l_scale(i,k,j) = 0.76*tmp/sqrt(bn2(i,k,j))
! recompute vars : l_scale
        a_l_scale(i,k,j) = a_l_scale(i,k,j)*(0.5+sign(0.5,deltas-l_scale(i,k,j)))
        a_bn2(i,k,j) = a_bn2(i,k,j)-a_l_scale(i,k,j)*(0.76*tmp*(1./(2.*sqrt(bn2(i,k,j))))/(sqrt(bn2(i,k,j))*sqrt(bn2(i,k,j))))
        a_l_scale(i,k,j) = 0.
      endif
      a_l_scale(i,k,j) = 0.
    end do
  end do
end do

end subroutine a_calc_l_scale


subroutine a_calculate_km_kh( config_flags, dt, dampcoef, zdamp, damp_opt, xkmh, xkmhd, a_xkmhd, xkmv, xkhh, xkhv, bn2, a_bn2, &
&khdif, div, defor11, defor22, defor33, defor12, defor13, defor23, tke, p8w, a_p8w, t8w, a_t8w, theta, a_theta, t, a_t, p, a_p, &
&moist, a_moist, dn, dnw, dx, dy, rdz, rdzw, n_moist, cf1, cf2, cf3, kh_tke_upper_bound, ids, ide, jds, jde, kde, ims, ime, jms, &
&jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_bn2(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: n_moist
real, intent(inout) :: a_moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(inout) :: a_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_p8w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t8w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_theta(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: bn2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cf1
real, intent(in) :: cf2
real, intent(in) :: cf3
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: damp_opt
real, intent(in) :: dampcoef
real, intent(in) :: defor11(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor12(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor13(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor22(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor23(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor33(ims:ime,kms:kme,jms:jme)
real, intent(in) :: div(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dn(kms:kme)
real, intent(in) :: dnw(kms:kme)
real, intent(in) :: dt
real, intent(in) :: dx
real, intent(in) :: dy
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
real, intent(in) :: kh_tke_upper_bound
real, intent(in) :: khdif
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(inout) :: moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: p8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdz(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdzw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: theta(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: tke(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkhh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkhv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: zdamp

!==============================================
! declare local variables
!==============================================
real a_xkmhh(1+ime-ims,1+kme-kms,1+jme-jms)
real a_xkmhi(1+ime-ims,1+kme-kms,1+jme-jms)
real a_xkmhj(1+ime-ims,1+kme-kms,1+jme-jms)
real cr_len
integer kds
real kv_tke_upper_bound
real kvdif
logical warm_rain

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
kvdif = 0.0
a_xkmhh(:,:,:) = 0.
a_xkmhi(:,:,:) = 0.
a_xkmhj(:,:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
call calculate_n2( config_flags,bn2,moist,theta,t,p,p8w,t8w,dnw,dn,rdz,rdzw,n_moist,cf1,cf2,cf3,warm_rain,ids,ide,jds,jde,kds,kde,&
&ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
! recompute : bn2
km_coeg: select case ( config_flags%km_opt )
case (1) km_coeg
  call isotropic_km( config_flags,xkmh,xkmhd,xkmv,xkhh,xkhv,khdif,kvdif,ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme,its,ite,&
&jts,jte,kts,kte )
case (2) km_coeg
  call tke_km( config_flags,xkmh,xkmhd,xkmv,xkhh,xkhv,bn2,tke,p8w,t8w,theta,rdz,rdzw,dx,dy,cr_len,kh_tke_upper_bound,&
&kv_tke_upper_bound,ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
case (3) km_coeg
  call smag_km( config_flags,xkmh,xkmhd,xkmv,xkhh,xkhv,bn2,div,defor11,defor22,defor33,defor12,defor13,defor23,rdzw,dx,dy,cr_len,&
&ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
case (4) km_coeg
  call smag2d_km( config_flags,xkmh,xkmhd,xkmv,xkhh,xkhv,defor11,defor22,defor12,rdzw,dx,dy,ids,ide,jds,jde,kds,kde,ims,ime,jms,&
&jme,kms,kme,its,ite,jts,jte,kts,kte )
end select km_coeg
! recompute : xkmhd
if (damp_opt .eq. 1) then
  call a_cal_dampkm( xkmhd,a_xkmhd,dx,dt,dampcoef,rdz,rdzw,zdamp,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
endif
a_km_coef: select case ( config_flags%km_opt )
case (1) a_km_coef
  call a_isotropic_km( a_xkmhd,ide,jde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
case (2) a_km_coef
  call a_tke_km( config_flags,xkmh,a_xkmhh,a_xkmhd,bn2,a_bn2,tke,rdzw,dx,dy,kh_tke_upper_bound,ids,ide,jds,jde,kde,ims,ime,jms,jme,&
&kms,kme,its,ite,jts,jte,kts,kte )
case (3) a_km_coef
  call a_smag_km( config_flags,xkmh,a_xkmhi,a_xkmhd,bn2,a_bn2,defor11,defor22,defor33,defor12,defor13,defor23,rdzw,dx,dy,ids,ide,&
&jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
case (4) a_km_coef
  call a_smag2d_km( config_flags,xkmh,a_xkmhj,a_xkmhd,defor11,defor22,defor12,dx,dy,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,&
&its,ite,jts,jte,kts,kte )
end select a_km_coef
call a_calculate_n2( config_flags,a_bn2,moist,a_moist,theta,a_theta,t,a_t,p,a_p,p8w,a_p8w,t8w,a_t8w,rdz,rdzw,n_moist,cf1,cf2,cf3,&
&ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )

end subroutine a_calculate_km_kh


subroutine a_calculate_n2( config_flags, a_bn2, moist, a_moist, theta, a_theta, t, a_t, p, a_p, p8w, a_p8w, t8w, a_t8w, rdz, rdzw, &
&n_moist, cf1, cf2, cf3, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_bn2(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: n_moist
real, intent(inout) :: a_moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(inout) :: a_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_p8w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t8w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_theta(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cf1
real, intent(in) :: cf2
real, intent(in) :: cf3
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(inout) :: moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: p8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdz(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdzw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: theta(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_coefa
real a_es
real a_qctmp(its:ite,kts:kte,jts:jte)
real a_qvs(its:ite,kts:kte,jts:jte)
real a_qvsfc
real a_thetaem1
real a_thetaep1
real a_thetaesfc
real a_thetasfc
real a_tmp1(its:ite,kts:kte,jts:jte)
real a_tmp1sfc(its:ite,jts:jte)
real a_xlvqv
real coefa
real es
integer i
integer i_end
integer i_start
integer ispe
integer j
integer j_end
integer j_start
integer k
integer ktf
real qc_cr
real qctmp(its:ite,kts:kte,jts:jte)
real qvs(its:ite,kts:kte,jts:jte)
real qvsfc
real tc
real thetaem1
real thetaep1
real thetaesfc
real thetasfc
real tmpdz
real xlvqv
real walls(7)

!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
a_thetasfc=0.  !ADDED BY WALLS

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_qctmp(:,:,:) = 0.
a_qvs(:,:,:) = 0.
a_thetaesfc = 0.
a_tmp1(:,:,:) = 0.
a_tmp1sfc(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
qc_cr = 0.00001
! recompute : qc_cr
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
if (config_flags%open_xs .or. config_flags%specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
! recompute : i_start
if (config_flags%open_xe .or. config_flags%specified .or. config_flags%nested) then
  i_end = min(ide-2,ite)
endif
! recompute : i_end
if (config_flags%open_ys .or. config_flags%specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
! recompute : j_start
if (config_flags%open_ye .or. config_flags%specified .or. config_flags%nested) then
  j_end = min(jde-2,jte)
endif
! recompute : j_end
if (p_qc .gt. param_first_scalar) then
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        qctmp(i,k,j) = moist(i,k,j,p_qc)
      end do
    end do
  end do
else
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        qctmp(i,k,j) = 0.
      end do
    end do
  end do
endif
! recompute : qctmp
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      es = 1000.*svp1*exp(svp2*(t(i,k,j)-svpt0)/(t(i,k,j)-svp3))
      qvs(i,k,j) = ep_2*es/(p(i,k,j)-es)
    end do
  end do
end do
! recompute : qvs
k = kts
! recompute : k
do j = j_start, j_end
  do i = i_start, i_end
    a_bn2(i,ktf-1,j) = a_bn2(i,ktf-1,j)+a_bn2(i,ktf,j)
    a_bn2(i,ktf,j) = 0.
  end do
end do
do j = j_start, j_end
  do i = i_start, i_end
    tmpdz = 1./rdz(i,k+1,j)+0.5/rdzw(i,k,j)
! recompute : tmpdz
    walls(3)= p8w(i,k,j)/p1000mb
    walls(2)= walls(3)**(r_d/cp)
    walls(5)=t(i,k,j)
    walls(6)=t8w(i,kts,j)
    walls(7)=theta(i,k,j)
    thetasfc = walls(6)/walls(2)
! recompute : thetasfc
    if (moist(i,k,j,p_qv) .ge. qvs(i,k,j) .or. qctmp(i,k,j) .ge. qc_cr) then
      qvsfc = cf1*qvs(i,1,j)+cf2*qvs(i,2,j)+cf3*qvs(i,3,j)
! recompute : qvsfc
      xlvqv = xlv*moist(i,k,j,p_qv)
! recompute : xlvqv
      walls(1)=1.+xlvqv/r_d/walls(5)
      walls(4)=1.+xlv*xlvqv/cp/r_v/walls(5)/walls(5)
      coefa = a_bn2(i,k,j)*walls(1)/walls(4)/walls(7)*g/tmpdz
! recompute : coefa
      thetaep1 = theta(i,k+1,j)*(1.+xlv*qvs(i,k+1,j)/cp/t(i,k+1,j))
! recompute : thetaep1
      thetaesfc = thetasfc*(1.+xlv*qvsfc/cp/walls(6))
! recompute : thetaesfc
      a_coefa = a_bn2(i,k,j)*((thetaep1-thetaesfc)*g/tmpdz)
      a_thetaep1 = coefa
      a_thetaesfc = -coefa
      a_tmp1(i,k+1,j) = a_tmp1(i,k+1,j)-a_bn2(i,k,j)*g/tmpdz
      a_tmp1sfc(i,j) = a_tmp1sfc(i,j)+a_bn2(i,k,j)*g/tmpdz
      a_bn2(i,k,j) = 0.
      a_qvsfc = a_thetaesfc*thetasfc*xlv/cp/walls(6)
      a_t8w(i,kts,j) = a_t8w(i,kts,j)-a_thetaesfc*thetasfc*xlv*qvsfc/cp/(walls(6)*walls(6))
      a_thetasfc = a_thetaesfc*(1+xlv*qvsfc/cp/walls(6))
      a_qvs(i,k+1,j) = a_qvs(i,k+1,j)+a_thetaep1*theta(i,k+1,j)*(xlv/cp/t(i,k+1,j))
      a_t(i,k+1,j) = a_t(i,k+1,j)-a_thetaep1*theta(i,k+1,j)*(xlv*qvs(i,k+1,j)/cp/(t(i,k+1,j)*t(i,k+1,j)))
      a_theta(i,k+1,j) = a_theta(i,k+1,j)+a_thetaep1*(1+xlv*qvs(i,k+1,j)/cp/t(i,k+1,j))
      a_t(i,k,j) = a_t(i,k,j)+a_coefa*(-xlvqv/r_d/walls(5)+2.*walls(1)*(walls(4)-1.)/walls(4))/walls(5)/walls(7)/walls(4)
      a_theta(i,k,j) = a_theta(i,k,j)-a_coefa*walls(1)/walls(4)/(walls(7)*walls(7))
      a_xlvqv = a_coefa*(1/r_d-walls(1)*xlv/cp/r_v/walls(5)/walls(4))/walls(5)/walls(4)/walls(7)
      a_moist(i,k,j,p_qv) = a_moist(i,k,j,p_qv)+a_xlvqv*xlv
      a_qvs(i,3,j) = a_qvs(i,3,j)+a_qvsfc*cf3
      a_qvs(i,2,j) = a_qvs(i,2,j)+a_qvsfc*cf2
      a_qvs(i,1,j) = a_qvs(i,1,j)+a_qvsfc*cf1
    else
      tmpdz = 1./rdzw(i,k,j)
! recompute : tmpdz
      a_moist(i,k+1,j,p_qv) = a_moist(i,k+1,j,p_qv)+a_bn2(i,k,j)*(1.61*g/tmpdz)
      a_qvsfc = a_bn2(i,k,j)*((-1.61)*g/tmpdz)
      a_theta(i,k+1,j) = a_theta(i,k+1,j)+a_bn2(i,k,j)*(1/walls(7)*g/tmpdz)
      a_theta(i,k,j) = a_theta(i,k,j)+a_bn2(i,k,j)*((-1)/walls(7)-(theta(i,k+1,j)-walls(7))/(walls(7)*walls(7)))*g/tmpdz
      a_tmp1(i,k+1,j) = a_tmp1(i,k+1,j)-a_bn2(i,k,j)*g/tmpdz
      a_tmp1sfc(i,j) = a_tmp1sfc(i,j)+a_bn2(i,k,j)*g/tmpdz
      a_bn2(i,k,j) = 0.
      a_moist(i,3,j,p_qv) = a_moist(i,3,j,p_qv)+a_qvsfc*cf3
      a_moist(i,2,j,p_qv) = a_moist(i,2,j,p_qv)+a_qvsfc*cf2
      a_moist(i,1,j,p_qv) = a_moist(i,1,j,p_qv)+a_qvsfc*cf1
    endif
    if(a_thetasfc.ne.0.) then  !ADDED BY WALLS
      a_p8w(i,k,j) = a_p8w(i,k,j)-a_thetasfc*(walls(6)/p1000mb*r_d/cp/walls(3)/walls(2))
      a_t8w(i,kts,j) = a_t8w(i,kts,j)+a_thetasfc/walls(2)
    end if  !ADDED BY WALLS
  end do
end do
do j = j_start, j_end
  do k = kts+1, ktf-1
    do i = i_start, i_end
      tmpdz = g/(1./rdz(i,k,j)+1./rdz(i,k+1,j))
      walls(2)=theta(i,k,j)
! recompute : tmpdz
      if (moist(i,k,j,p_qv) .ge. qvs(i,k,j) .or. qctmp(i,k,j) .ge. qc_cr) then
        xlvqv = xlv*moist(i,k,j,p_qv)
! recompute : xlvqv
        walls(3)=t(i,k,j)
        walls(1)=1.+xlvqv/r_d/walls(3)
        walls(4)=1.+xlv*xlvqv/cp/r_v/walls(3)/walls(3)
        walls(5)=t(i,k+1,j)
        coefa = walls(1)/walls(4)/walls(2)
! recompute : coefa
        thetaep1 = theta(i,k+1,j)*(1.+xlv*qvs(i,k+1,j)/cp/walls(5))
! recompute : thetaep1
        thetaem1 = theta(i,k-1,j)*(1.+xlv*qvs(i,k-1,j)/cp/t(i,k-1,j))
! recompute : thetaem1
        a_coefa = a_bn2(i,k,j)*(thetaep1-thetaem1)*tmpdz
        a_thetaem1 = -a_bn2(i,k,j)*coefa*tmpdz
        a_thetaep1 = a_bn2(i,k,j)*coefa*tmpdz
        a_tmp1(i,k-1,j) = a_tmp1(i,k-1,j)+a_bn2(i,k,j)*tmpdz
        a_tmp1(i,k+1,j) = a_tmp1(i,k+1,j)-a_bn2(i,k,j)*tmpdz
        a_bn2(i,k,j) = 0.
        a_qvs(i,k-1,j) = a_qvs(i,k-1,j)+a_thetaem1*theta(i,k-1,j)*(xlv/cp/t(i,k-1,j))
        a_t(i,k-1,j) = a_t(i,k-1,j)-a_thetaem1*theta(i,k-1,j)*(xlv*qvs(i,k-1,j)/cp/(t(i,k-1,j)*t(i,k-1,j)))
        a_theta(i,k-1,j) = a_theta(i,k-1,j)+a_thetaem1*(1+xlv*qvs(i,k-1,j)/cp/t(i,k-1,j))
        a_qvs(i,k+1,j) = a_qvs(i,k+1,j)+a_thetaep1*theta(i,k+1,j)*xlv/cp/walls(5)
        a_t(i,k+1,j) = a_t(i,k+1,j)-a_thetaep1*theta(i,k+1,j)*(xlv*qvs(i,k+1,j)/cp/(walls(5)*walls(5)))
        a_theta(i,k+1,j) = a_theta(i,k+1,j)+a_thetaep1*(1+xlv*qvs(i,k+1,j)/cp/walls(5))
        a_t(i,k,j) = a_t(i,k,j)+a_coefa*(-xlvqv/r_d/walls(3)+2.*walls(1)*(walls(4)-1.)/walls(4))/walls(3)/walls(4)/walls(2)
        a_theta(i,k,j) = a_theta(i,k,j)-a_coefa*(walls(1)/walls(4)/(walls(2)*walls(2)))
        a_xlvqv = a_coefa*((1./r_d-walls(1)*xlv/cp/r_v/walls(3)/walls(4))/walls(2))/walls(3)/walls(4)
        a_moist(i,k,j,p_qv) = a_moist(i,k,j,p_qv)+a_xlvqv*xlv
      else
        a_moist(i,k-1,j,p_qv) = a_moist(i,k-1,j,p_qv)+a_bn2(i,k,j)*(-1.61*tmpdz)
        a_moist(i,k+1,j,p_qv) = a_moist(i,k+1,j,p_qv)+a_bn2(i,k,j)*(1.61*tmpdz)
        a_theta(i,k-1,j) = a_theta(i,k-1,j)+a_bn2(i,k,j)*((-1)/walls(2)*tmpdz)
        a_theta(i,k+1,j) = a_theta(i,k+1,j)+a_bn2(i,k,j)*(1/walls(2)*tmpdz)
        a_theta(i,k,j) = a_theta(i,k,j)-a_bn2(i,k,j)*((theta(i,k+1,j)-theta(i,k-1,j))/(walls(2)*walls(2))*tmpdz)
        a_tmp1(i,k-1,j) = a_tmp1(i,k-1,j)+a_bn2(i,k,j)*tmpdz
        a_tmp1(i,k+1,j) = a_tmp1(i,k+1,j)-a_bn2(i,k,j)*tmpdz
        a_bn2(i,k,j) = 0.
      endif
    end do
  end do
end do
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      tc = svp2*(t(i,k,j)-svpt0)
! recompute : tc
      es = 1000.*svp1*exp(tc/(t(i,k,j)-svp3))
      walls(2)=t(i,k,j)-svp3
      walls(1)=p(i,k,j)-es
! recompute : es
      a_es = a_qvs(i,k,j)*(ep_2+ep_2*es/walls(1))/walls(1)
      a_p(i,k,j) = a_p(i,k,j)-a_qvs(i,k,j)*ep_2*es/(walls(1)*walls(1))
      a_t(i,k,j) = a_t(i,k,j)-a_es*tc/(walls(2)*walls(2))*es
      a_t(i,k,j) = a_t(i,k,j)+a_es*svp2/walls(2)*es
    end do
  end do
end do
a_qvs(i_start:i_end,kts:ktf,j_start:j_end) = 0.
do ispe = n_moist, param_first_scalar, -1
  if (ispe .eq. p_qv .or. ispe .eq. p_qc .or. ispe .eq. p_qi) then
    do j = j_start, j_end
      do i = i_start, i_end
        a_moist(i,3,j,ispe) = a_moist(i,3,j,ispe)+a_tmp1sfc(i,j)*cf3
        a_moist(i,2,j,ispe) = a_moist(i,2,j,ispe)+a_tmp1sfc(i,j)*cf2
        a_moist(i,1,j,ispe) = a_moist(i,1,j,ispe)+a_tmp1sfc(i,j)*cf1
      end do
    end do
    do j = j_start, j_end
      do k = kts, ktf
        do i = i_start, i_end
          a_moist(i,k,j,ispe) = a_moist(i,k,j,ispe)+a_tmp1(i,k,j)
        end do
      end do
    end do
  endif
end do
if (p_qc .gt. param_first_scalar) then
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        a_moist(i,k,j,p_qc) = a_moist(i,k,j,p_qc)+a_qctmp(i,k,j)
        a_qctmp(i,k,j) = 0.
      end do
    end do
  end do
endif

end subroutine a_calculate_n2


subroutine a_isotropic_km( a_xkmhd, ide, jde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_xkmhd(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
integer, intent(in) :: kts

!==============================================
! declare local variables
!==============================================
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
ktf = kte
! recompute : ktf
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      a_xkmhd(i,k,j) = 0.
    end do
  end do
end do

end subroutine a_isotropic_km


subroutine a_smag2d_km( config_flags, xkmh, a_xkmh, a_xkmhd, defor11, defor22, defor12, dx, dy, ids, ide, jds, jde, kde, ims, ime, &
&jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_xkmhd(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: defor11(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor12(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor22(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dx
real, intent(in) :: dy
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(inout) :: xkmh(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real def2(its:ite,kts:kte,jts:jte)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real mlen_h

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
!if (config_flags%open_xs .or. config_flags%specified .or. config_flags%nested) then
!  i_start = max(ids+1,its)
!endif
! recompute : i_start
!if (config_flags%open_xe .or. config_flags%specified .or. config_flags%nested) then
!  i_end = min(ide-2,ite)
!endif
! recompute : i_end
!if (config_flags%open_ys .or. config_flags%specified .or. config_flags%nested) then
!  j_start = max(jds+1,jts)
!endif
!! recompute : j_start
!if (config_flags%open_ye .or. config_flags%specified .or. config_flags%nested) then
!  j_end = min(jde-2,jte)
!endif
! recompute : j_end
!do j = j_start, j_end
!  do k = kts, ktf
!    do i = i_start, i_end
!      def2(i,k,j) = 0.25*(defor11(i,k,j)-defor22(i,k,j))**2+defor12(i,k,j)*defor12(i,k,j)
!    end do
!  end do
!end do
! recompute : def2
mlen_h = sqrt(dx*dy)
! recompute : mlen_h
!do j = j_start, j_end
!  do k = kts, ktf
!    do i = i_start, i_end
!      xkmh(i,k,j) = c_s*c_s*mlen_h*mlen_h*def2(i,k,j)**0.5
!      a_xkmh(i,k,j) = a_xkmh(i,k,j)+a_xkmhd(i,k,j)
!      a_xkmhd(i,k,j) = 0.
!      a_xkmh(i,k,j) = a_xkmh(i,k,j)*(0.5+sign(0.5,10.*mlen_h-xkmh(i,k,j)))
!      a_xkmh(i,k,j) = 0.
!    end do
!  end do
!end do

!TO BE CHECKED CAREFULLY, WALLS
a_xkmhd(i_start:i_end,kts:ktf,j_start:j_end) = 0.

end subroutine a_smag2d_km


subroutine a_smag_km( config_flags, xkmh, a_xkmh, a_xkmhd, bn2, a_bn2, defor11, defor22, defor33, defor12, defor13, defor23, rdzw, &
&dx, dy, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_bn2(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(in) :: bn2(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: defor11(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor12(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor13(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor22(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor23(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor33(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dx
real, intent(in) :: dy
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: rdzw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmh(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_tmp
real cr_len
real def2(its:ite,kts:kte,jts:jte)
real deltas
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real mlen_h
real pr
real tmp

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
if (config_flags%open_xs .or. config_flags%specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
! recompute : i_start
if (config_flags%open_xe .or. config_flags%specified .or. config_flags%nested) then
  i_end = min(ide-2,ite)
endif
! recompute : i_end
if (config_flags%open_ys .or. config_flags%specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
! recompute : j_start
if (config_flags%open_ye .or. config_flags%specified .or. config_flags%nested) then
  j_end = min(jde-2,jte)
endif
! recompute : j_end
pr = 1./3.
! recompute : pr
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      def2(i,k,j) = 0.5*(defor11(i,k,j)*defor11(i,k,j)+defor22(i,k,j)*defor22(i,k,j)+defor33(i,k,j)*defor33(i,k,j))
    end do
  end do
end do
! recompute : def2
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      tmp = 0.25*(defor12(i,k,j)+defor12(i,k,j+1)+defor12(i+1,k,j)+defor12(i+1,k,j+1))
      def2(i,k,j) = def2(i,k,j)+0.5*tmp*tmp
    end do
  end do
end do
! recompute : def2
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      tmp = 0.25*(defor13(i,k+1,j)+defor13(i,k,j)+defor13(i+1,k+1,j)+defor13(i+1,k,j))
      def2(i,k,j) = def2(i,k,j)+0.5*tmp*tmp
    end do
  end do
end do
! recompute : def2
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      tmp = 0.25*(defor23(i,k+1,j)+defor23(i,k,j)+defor23(i,k+1,j+1)+defor23(i,k,j+1))
      def2(i,k,j) = def2(i,k,j)+0.5*tmp*tmp
    end do
  end do
end do
! recompute : def2
cr_len = dx+1.
! recompute : cr_len
if (dx .gt. cr_len) then
  mlen_h = sqrt(dx*dy)
! recompute : mlen_h
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        tmp = (max(0.,def2(i,k,j)-bn2(i,k,j)/pr))**0.5
! recompute : tmp
        xkmh(i,k,j) = max(c_s*c_s*mlen_h*mlen_h*tmp,1.e-6*mlen_h*mlen_h)
! recompute : xkmh
        a_xkmh(i,k,j) = a_xkmh(i,k,j)+a_xkmhd(i,k,j)
        a_xkmhd(i,k,j) = 0.
        a_xkmh(i,k,j) = a_xkmh(i,k,j)*(0.5+sign(0.5,10.*mlen_h-xkmh(i,k,j)))
        a_tmp = a_xkmh(i,k,j)*(0.5+sign(0.5,c_s*c_s*mlen_h*mlen_h*tmp-1.e-6*mlen_h*mlen_h))*c_s*c_s*mlen_h*mlen_h
        a_xkmh(i,k,j) = 0.
! recdepend vars : bn2,def2,i,j,k,pr
! recompute pos : ASSIGN_STMT module_diffusion_em.f90:1516
        a_tmp = 0.5*a_tmp*(max(0.,def2(i,k,j)-bn2(i,k,j)/pr))**(-0.5)
        a_bn2(i,k,j) = a_bn2(i,k,j)-a_tmp*((0.5-sign(0.5,0.-(def2(i,k,j)-bn2(i,k,j)/pr)))/pr)
      end do
    end do
  end do
else
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        deltas = (dx*dy/rdzw(i,k,j))**0.33333333
! recompute : deltas
        tmp = max(0.,def2(i,k,j)-bn2(i,k,j)/pr)
! recompute : tmp
        tmp = tmp**0.5
! recompute : tmp
        xkmh(i,k,j) = max(c_s*c_s*deltas*deltas*tmp,1.e-6*deltas*deltas)
! recompute : xkmh
        a_xkmh(i,k,j) = a_xkmh(i,k,j)+a_xkmhd(i,k,j)
        a_xkmhd(i,k,j) = 0.
        a_xkmh(i,k,j) = a_xkmh(i,k,j)*(0.5+sign(0.5,10.*deltas-xkmh(i,k,j)))
        a_tmp = a_xkmh(i,k,j)*(0.5+sign(0.5,c_s*c_s*deltas*deltas*tmp-1.e-6*deltas*deltas))*c_s*c_s*deltas*deltas
        a_xkmh(i,k,j) = 0.
! recdepend vars : bn2,def2,i,j,k,pr
! recompute pos : ASSIGN_STMT module_diffusion_em.f90:1533
! recompute vars : tmp
        tmp = max(0.,def2(i,k,j)-bn2(i,k,j)/pr)
! recompute vars : tmp
        a_tmp = 0.5*a_tmp*tmp**(-0.5)
        a_bn2(i,k,j) = a_bn2(i,k,j)-a_tmp*((0.5-sign(0.5,0.-(def2(i,k,j)-bn2(i,k,j)/pr)))/pr)
      end do
    end do
  end do
endif

end subroutine a_smag_km


subroutine a_tke_km( config_flags, xkmh, a_xkmh, a_xkmhd, bn2, a_bn2, tke, rdzw, dx, dy, kh_tke_upper_bound, ids, ide, jds, jde, &
&kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real epsilon
parameter ( epsilon = 1.e-10 )
real tke_seed_value
parameter ( tke_seed_value = 1.e-6 )

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_bn2(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(in) :: bn2(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: dx
real, intent(in) :: dy
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
real, intent(in) :: kh_tke_upper_bound
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: rdzw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: tke(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmh(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real a_l_scale(its:ite,kts:kte,jts:jte)
real cr_len
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer kds
integer ktf
real l_scale(its:ite,kts:kte,jts:jte)
real mlen_h
real tke_seed
real tmp

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_l_scale(:,:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
ktf = min(kte,kde-1)
! recompute : ktf
i_start = its
! recompute : i_start
i_end = min(ite,ide-1)
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = min(jte,jde-1)
! recompute : j_end
if (config_flags%open_xs .or. config_flags%specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
! recompute : i_start
if (config_flags%open_xe .or. config_flags%specified .or. config_flags%nested) then
  i_end = min(ide-2,ite)
endif
! recompute : i_end
if (config_flags%open_ys .or. config_flags%specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
! recompute : j_start
if (config_flags%open_ye .or. config_flags%specified .or. config_flags%nested) then
  j_end = min(jde-2,jte)
endif
! recompute : j_end
tke_seed = tke_seed_value
! recompute : tke_seed
if (config_flags%tke_drag_coefficient .gt. epsilon .or. config_flags%tke_heat_flux .gt. epsilon) then
  tke_seed = 0.
endif
! recompute : tke_seed
cr_len = dx+1.
! recompute : cr_len
if (dx .gt. cr_len) then
  mlen_h = sqrt(dx*dy)
! recompute : mlen_h
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        tmp = sqrt(max(tke(i,k,j),tke_seed))
! recompute : tmp
        xkmh(i,k,j) = max(c_k*tmp*mlen_h,1.e-6*mlen_h*mlen_h)
! recompute : xkmh
        a_xkmh(i,k,j) = a_xkmh(i,k,j)+a_xkmhd(i,k,j)
        a_xkmhd(i,k,j) = 0.
        a_xkmh(i,k,j) = a_xkmh(i,k,j)*(0.5+sign(0.5,10.*mlen_h-xkmh(i,k,j)))
        a_xkmh(i,k,j) = 0.
      end do
    end do
  end do
else
  call calc_l_scale( config_flags,tke,bn2,l_scale,i_start,i_end,ktf,j_start,j_end,dx,dy,rdzw,ids,ide,jds,jde,kds,kde,ims,ime,jms,&
&jme,kms,kme,its,ite,jts,jte,kts,kte )
! recompute : l_scale
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        tmp = sqrt(max(tke(i,k,j),tke_seed))
! recompute : tmp
        xkmh(i,k,j) = c_k*tmp*l_scale(i,k,j)
! recompute : xkmh
        a_xkmh(i,k,j) = a_xkmh(i,k,j)+a_xkmhd(i,k,j)
        a_xkmhd(i,k,j) = 0.
        a_xkmh(i,k,j) = a_xkmh(i,k,j)*(0.5-sign(0.5,xkmh(i,k,j)-kh_tke_upper_bound))
        a_l_scale(i,k,j) = a_l_scale(i,k,j)+a_xkmh(i,k,j)*c_k*tmp
        a_xkmh(i,k,j) = 0.
      end do
    end do
  end do
  call a_calc_l_scale( tke,bn2,a_bn2,l_scale,a_l_scale,i_start,i_end,ktf,j_start,j_end,dx,dy,rdzw,ims,ime,jms,jme,kms,kme,its,ite,&
&jts,jte,kts,kte )
endif

end subroutine a_tke_km


end module     a_module_diffusion_em


