!                           DISCLAIMER
!
!   This file was generated by TAF version 1.7.18
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     g_module_diffusion_em
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use module_configure
use module_bc
use g_module_bc
use module_state_description
use module_big_step_utilities_em
use g_module_big_step_utilities_em
use module_model_constants
use module_wrf_error
use module_diffusion_em

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine g_cal_dampkm( xkmhd, g_xkmhd, xkmh, xkhh, xkmv, xkhv, dx, dt, dampcoef, rdz, rdzw, zdamp, ide, jde, kde, ims, ime, jms, &
&jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real, intent(in) :: dampcoef
real, intent(in) :: dt
real, intent(in) :: dx
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: g_xkmhd(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: rdz(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdzw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkhh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkhv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: zdamp

!==============================================
! declare local variables
!==============================================
real dampk(its:ite,kts:kte,jts:jte)
real degrad90
real deltaz(its:ite)
real dz
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
real kmmax
integer ktf
integer ktfm1
real tmp

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
ktf = min(kte,kde-1)
ktfm1 = ktf-1
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
kmmax = dx*dx/dt
degrad90 = degrad*90.
do j = j_start, j_end
  k = ktf
  do i = i_start, i_end
    dz = 1./rdzw(i,k,j)
    deltaz(i) = 0.5*dz
    tmp = min(deltaz(i)/zdamp,1.)
    dampk(i,k,j) = cos(degrad90*tmp)*kmmax*dampcoef
  end do
  do k = ktfm1, kts, -1
    do i = i_start, i_end
      dz = 1./rdz(i,k,j)
      deltaz(i) = deltaz(i)+dz
      tmp = min(deltaz(i)/zdamp,1.)
      dampk(i,k,j) = cos(degrad90*tmp)*kmmax*dampcoef
    end do
  end do
end do
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      g_xkmhd(i,k,j) = g_xkmhd(i,k,j)*(0.5+sign(0.5,xkmhd(i,k,j)-dampk(i,k,j)))
      xkmhd(i,k,j) = max(xkmhd(i,k,j),dampk(i,k,j))
    end do
  end do
end do

end subroutine g_cal_dampkm


subroutine g_calc_l_scale( tke, bn2, g_bn2, l_scale, g_l_scale, i_start, i_end, ktf, j_start, j_end, dx, dy, rdzw, ims, ime, jms, &
&jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: bn2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dx
real, intent(in) :: dy
real, intent(in) :: g_bn2(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(out) :: g_l_scale(its:ite,kts:kte,jts:jte)
integer, intent(in) :: i_end
integer, intent(in) :: i_start
integer, intent(in) :: j_end
integer, intent(in) :: j_start
integer, intent(in) :: ktf
real, intent(out) :: l_scale(its:ite,kts:kte,jts:jte)
real, intent(in) :: rdzw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: tke(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real deltas
integer i
integer j
integer k
real tmp

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      deltas = (dx*dy/rdzw(i,k,j))**0.33333333
      g_l_scale(i,k,j) = 0.
      l_scale(i,k,j) = deltas
      if (bn2(i,k,j) .gt. 1.e-6) then
        tmp = sqrt(max(tke(i,k,j),1.e-6))
        g_l_scale(i,k,j) = -(g_bn2(i,k,j)*(0.76*tmp*(1./(2.*sqrt(bn2(i,k,j))))/(sqrt(bn2(i,k,j))*sqrt(bn2(i,k,j)))))
        l_scale(i,k,j) = 0.76*tmp/sqrt(bn2(i,k,j))
        g_l_scale(i,k,j) = g_l_scale(i,k,j)*(0.5+sign(0.5,deltas-l_scale(i,k,j)))
        l_scale(i,k,j) = min(l_scale(i,k,j),deltas)
        g_l_scale(i,k,j) = g_l_scale(i,k,j)*(0.5+sign(0.5,l_scale(i,k,j)-0.001*deltas))
        l_scale(i,k,j) = max(l_scale(i,k,j),0.001*deltas)
      endif
    end do
  end do
end do

end subroutine g_calc_l_scale


subroutine g_calculate_km_kh( config_flags, dt, dampcoef, zdamp, damp_opt, xkmh, xkmhd, g_xkmhd, xkmv, xkhh, xkhv, bn2, g_bn2, &
&khdif, defor11, defor22, defor33, defor12, defor13, defor23, tke, p8w, g_p8w, t8w, g_t8w, theta, g_theta, t, g_t, p, g_p, moist, &
&g_moist, dx, dy, rdz, rdzw, n_moist, cf1, cf2, cf3, kh_tke_upper_bound, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, &
&its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: bn2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cf1
real, intent(in) :: cf2
real, intent(in) :: cf3
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: damp_opt
real, intent(in) :: dampcoef
real, intent(in) :: defor11(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor12(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor13(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor22(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor23(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor33(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dt
real, intent(in) :: dx
real, intent(in) :: dy
real, intent(inout) :: g_bn2(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: n_moist
real, intent(inout) :: g_moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(in) :: g_p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_p8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_theta(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_xkmhd(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
real, intent(in) :: kh_tke_upper_bound
real, intent(in) :: khdif
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(inout) :: moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: p8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdz(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdzw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: theta(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: tke(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkhh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkhv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: zdamp

!==============================================
! declare local variables
!==============================================
real g_xkmhh(ims:ime,kms:kme,jms:jme)
real g_xkmhi(ims:ime,kms:kme,jms:jme)
real g_xkmhj(ims:ime,kms:kme,jms:jme)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
call g_calculate_n2( config_flags,bn2,g_bn2,moist,g_moist,theta,g_theta,t,g_t,p,g_p,p8w,g_p8w,t8w,g_t8w,rdz,rdzw,n_moist,cf1,cf2,&
&cf3,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
km_coeg: select case ( config_flags%km_opt )
case (1) km_coeg
  call g_isotropic_km( xkmh,xkmhd,g_xkmhd,xkmv,xkhh,xkhv,khdif,ide,jde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
case (2) km_coeg
  call g_tke_km( config_flags,xkmh,g_xkmhh,xkmhd,g_xkmhd,xkmv,xkhh,xkhv,bn2,g_bn2,tke,rdzw,dx,dy,kh_tke_upper_bound,ids,ide,jds,&
&jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
case (3) km_coeg
  call g_smag_km( config_flags,xkmh,g_xkmhi,xkmhd,g_xkmhd,xkmv,xkhh,xkhv,bn2,g_bn2,defor11,defor22,defor33,defor12,defor13,defor23,&
&rdzw,dx,dy,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
case (4) km_coeg
  call g_smag2d_km( config_flags,xkmh,g_xkmhj,xkmhd,g_xkmhd,xkmv,xkhh,xkhv,defor11,defor22,defor12,dx,dy,ids,ide,jds,jde,kde,ims,&
&ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
end select km_coeg
if (damp_opt .eq. 1) then
  call g_cal_dampkm( xkmhd,g_xkmhd,xkmh,xkhh,xkmv,xkhv,dx,dt,dampcoef,rdz,rdzw,zdamp,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,&
&jts,jte,kts,kte )
endif

end subroutine g_calculate_km_kh


subroutine g_calculate_n2( config_flags, bn2, g_bn2, moist, g_moist, theta, g_theta, t, g_t, p, g_p, p8w, g_p8w, t8w, g_t8w, rdz, &
&rdzw, n_moist, cf1, cf2, cf3, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: bn2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cf1
real, intent(in) :: cf2
real, intent(in) :: cf3
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(inout) :: g_bn2(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: n_moist
real, intent(inout) :: g_moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(in) :: g_p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_p8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_theta(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(inout) :: moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: p8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdz(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdzw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: theta(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real coefa
real es
real g_coefa
real g_es
real g_qctmp(its:ite,kts:kte,jts:jte)
real g_qvs(its:ite,kts:kte,jts:jte)
real g_qvsfc
real g_tc
real g_thetaem1
real g_thetaep1
real g_thetaesfc
real g_thetasfc
real g_tmp1(its:ite,kts:kte,jts:jte)
real g_tmp1sfc(its:ite,jts:jte)
real g_xlvqv
integer i
integer i_end
integer i_start
integer ispe
integer j
integer j_end
integer j_start
integer k
integer ktf
real qc_cr
real qctmp(its:ite,kts:kte,jts:jte)
real qvs(its:ite,kts:kte,jts:jte)
real qvsfc
real tc
real thetaem1
real thetaep1
real thetaesfc
real thetasfc
real tmp1(its:ite,kts:kte,jts:jte)
real tmp1sfc(its:ite,jts:jte)
real tmpdz
real xlvqv

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
qc_cr = 0.00001
ktf = min(kte,kde-1)
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
if (config_flags%open_xs .or. config_flags%specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
if (config_flags%open_xe .or. config_flags%specified .or. config_flags%nested) then
  i_end = min(ide-2,ite)
endif
if (config_flags%open_ys .or. config_flags%specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
if (config_flags%open_ye .or. config_flags%specified .or. config_flags%nested) then
  j_end = min(jde-2,jte)
endif
if (p_qc .gt. param_first_scalar) then
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        g_qctmp(i,k,j) = g_moist(i,k,j,p_qc)
        qctmp(i,k,j) = moist(i,k,j,p_qc)
      end do
    end do
  end do
else
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        g_qctmp(i,k,j) = 0.
        qctmp(i,k,j) = 0.
      end do
    end do
  end do
endif
do j = jts, jte
  do k = kts, kte
    do i = its, ite
      g_tmp1(i,k,j) = 0.
      tmp1(i,k,j) = 0.
    end do
  end do
end do
do j = jts, jte
  do i = its, ite
    g_tmp1sfc(i,j) = 0.
    tmp1sfc(i,j) = 0.
  end do
end do
do ispe = param_first_scalar, n_moist
  if (ispe .eq. p_qv .or. ispe .eq. p_qc .or. ispe .eq. p_qi) then
    do j = j_start, j_end
      do k = kts, ktf
        do i = i_start, i_end
          g_tmp1(i,k,j) = g_moist(i,k,j,ispe)+g_tmp1(i,k,j)
          tmp1(i,k,j) = tmp1(i,k,j)+moist(i,k,j,ispe)
        end do
      end do
    end do
    do j = j_start, j_end
      do i = i_start, i_end
        g_tmp1sfc(i,j) = g_moist(i,3,j,ispe)*cf3+g_moist(i,2,j,ispe)*cf2+g_moist(i,1,j,ispe)*cf1+g_tmp1sfc(i,j)
        tmp1sfc(i,j) = tmp1sfc(i,j)+cf1*moist(i,1,j,ispe)+cf2*moist(i,2,j,ispe)+cf3*moist(i,3,j,ispe)
      end do
    end do
  endif
end do
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      g_tc = g_t(i,k,j)
      tc = t(i,k,j)-svpt0
      g_es = (-(1000.*g_t(i,k,j)*svp1*(svp2*tc/((t(i,k,j)-svp3)*(t(i,k,j)-svp3)))*exp(svp2*tc/(t(i,k,j)-svp3))))+1000.*g_tc*svp1*&
&(svp2/(t(i,k,j)-svp3))*exp(svp2*tc/(t(i,k,j)-svp3))
      es = 1000.*svp1*exp(svp2*tc/(t(i,k,j)-svp3))
      g_qvs(i,k,j) = g_es*(ep_2/(p(i,k,j)-es)+ep_2*es/((p(i,k,j)-es)*(p(i,k,j)-es)))-g_p(i,k,j)*(ep_2*es/((p(i,k,j)-es)*(p(i,k,j)-&
&es)))
      qvs(i,k,j) = ep_2*es/(p(i,k,j)-es)
    end do
  end do
end do
do j = j_start, j_end
  do k = kts+1, ktf-1
    do i = i_start, i_end
      if ( rdz(i,k,j) .lt. 1.0e-30 .or. rdz(i,k+1,j) .lt. 1.0E-30) then
          tmpdz = 0.0
      else
          tmpdz = 1./rdz(i,k,j)+1./rdz(i,k+1,j)
      end if
      if (moist(i,k,j,p_qv) .ge. qvs(i,k,j) .or. qctmp(i,k,j) .ge. qc_cr) then
        g_xlvqv = g_moist(i,k,j,p_qv)*xlv
        xlvqv = xlv*moist(i,k,j,p_qv)
        g_coefa = g_t(i,k,j)*(((-(xlvqv/r_d/(t(i,k,j)*t(i,k,j))/(1.+xlv*xlvqv/cp/r_v/t(i,k,j)/t(i,k,j))))+(1.+xlvqv/r_d/t(i,k,j))*&
&(xlv*xlvqv/cp/r_v/(t(i,k,j)*t(i,k,j))/t(i,k,j)+xlv*xlvqv/cp/r_v/t(i,k,j)/(t(i,k,j)*t(i,k,j)))/((1.+xlv*xlvqv/cp/r_v/t(i,k,&
&j)/t(i,k,j))*(1.+xlv*xlvqv/cp/r_v/t(i,k,j)/t(i,k,j))))/theta(i,k,j))-g_theta(i,k,j)*((1.+xlvqv/r_d/t(i,k,j))/(1.+xlv*&
&xlvqv/cp/r_v/t(i,k,j)/t(i,k,j))/(theta(i,k,j)*theta(i,k,j)))+g_xlvqv*((1/r_d/t(i,k,j)/(1.+xlv*xlvqv/cp/r_v/t(i,k,j)/t(i,k,&
&j))-(1.+xlvqv/r_d/t(i,k,j))*(xlv/cp/r_v/t(i,k,j)/t(i,k,j))/((1.+xlv*xlvqv/cp/r_v/t(i,k,j)/t(i,k,j))*(1.+xlv*xlvqv/cp/r_v/&
&t(i,k,j)/t(i,k,j))))/theta(i,k,j))
        coefa = (1.+xlvqv/r_d/t(i,k,j))/(1.+xlv*xlvqv/cp/r_v/t(i,k,j)/t(i,k,j))/theta(i,k,j)
        g_thetaep1 = g_qvs(i,k+1,j)*theta(i,k+1,j)*(xlv/cp/t(i,k+1,j))-g_t(i,k+1,j)*theta(i,k+1,j)*(xlv*qvs(i,k+1,j)/cp/(t(i,k+1,j)&
&*t(i,k+1,j)))+g_theta(i,k+1,j)*(1+xlv*qvs(i,k+1,j)/cp/t(i,k+1,j))
        thetaep1 = theta(i,k+1,j)*(1.+xlv*qvs(i,k+1,j)/cp/t(i,k+1,j))
        g_thetaem1 = g_qvs(i,k-1,j)*theta(i,k-1,j)*(xlv/cp/t(i,k-1,j))-g_t(i,k-1,j)*theta(i,k-1,j)*(xlv*qvs(i,k-1,j)/cp/(t(i,k-1,j)&
&*t(i,k-1,j)))+g_theta(i,k-1,j)*(1+xlv*qvs(i,k-1,j)/cp/t(i,k-1,j))
        thetaem1 = theta(i,k-1,j)*(1.+xlv*qvs(i,k-1,j)/cp/t(i,k-1,j))
        if (tmpdz .lt. 1.0E-30) then
           g_bn2(i,k,j) = 0.0
           bn2(i,k,j) = 0.0
        else
           g_bn2(i,k,j) = g_coefa*g*((thetaep1-thetaem1)/tmpdz)-g_thetaem1*g*(coefa/tmpdz)+g_thetaep1*g*(coefa/tmpdz)+g_tmp1(i,k-1,j)*&
&(g/tmpdz)-g_tmp1(i,k+1,j)*(g/tmpdz)
           bn2(i,k,j) = g*(coefa*(thetaep1-thetaem1)/tmpdz-(tmp1(i,k+1,j)-tmp1(i,k-1,j))/tmpdz)
        endif
      else
        if (tmpdz .lt. 1.0E-30) then
           g_bn2(i,k,j) = 0.0
           bn2(i,k,j) = 0.0
        else
           g_bn2(i,k,j) = g_moist(i,k-1,j,p_qv)*g*((-1.61)/tmpdz)+g_moist(i,k+1,j,p_qv)*g*(1.61/tmpdz)+g_theta(i,k-1,j)*g*((-1)/&
&theta(i,k,j)/tmpdz)+g_theta(i,k+1,j)*g*(1/theta(i,k,j)/tmpdz)-g_theta(i,k,j)*g*((theta(i,k+1,j)-theta(i,k-1,j))/(theta(i,&
&k,j)*theta(i,k,j))/tmpdz)+g_tmp1(i,k-1,j)*(g/tmpdz)-g_tmp1(i,k+1,j)*(g/tmpdz)
           bn2(i,k,j) = g*((theta(i,k+1,j)-theta(i,k-1,j))/theta(i,k,j)/tmpdz+1.61*(moist(i,k+1,j,p_qv)-moist(i,k-1,j,p_qv))/tmpdz-&
&(tmp1(i,k+1,j)-tmp1(i,k-1,j))/tmpdz)
        endif
      endif
    end do
  end do
end do
k = kts
do j = j_start, j_end
  do i = i_start, i_end
    tmpdz = 1./(rdz(i,k+1,j)+epsilon) + 0.5/(rdzw(i,k,j) + epsilon)
    g_thetasfc = (-(g_p8w(i,k,j)*(t8w(i,kts,j)/p1000mb*r_d/cp*(p8w(i,k,j)/p1000mb)**(r_d/cp-1)/((p8w(i,k,j)/p1000mb)**(r_d/cp)*&
&(p8w(i,k,j)/p1000mb)**(r_d/cp)))))+g_t8w(i,kts,j)/(p8w(i,k,j)/p1000mb)**(r_d/cp)
    thetasfc = t8w(i,kts,j)/(p8w(i,k,j)/p1000mb)**(r_d/cp)
    if (moist(i,k,j,p_qv) .ge. qvs(i,k,j) .or. qctmp(i,k,j) .ge. qc_cr) then
      g_qvsfc = g_qvs(i,3,j)*cf3+g_qvs(i,2,j)*cf2+g_qvs(i,1,j)*cf1
      qvsfc = cf1*qvs(i,1,j)+cf2*qvs(i,2,j)+cf3*qvs(i,3,j)
      g_xlvqv = g_moist(i,k,j,p_qv)*xlv
      xlvqv = xlv*moist(i,k,j,p_qv)
      g_coefa = g_t(i,k,j)*(((-(xlvqv/r_d/(t(i,k,j)*t(i,k,j))/(1.+xlv*xlvqv/cp/r_v/t(i,k,j)/t(i,k,j))))+(1.+xlvqv/r_d/t(i,k,j))*&
&(xlv*xlvqv/cp/r_v/(t(i,k,j)*t(i,k,j))/t(i,k,j)+xlv*xlvqv/cp/r_v/t(i,k,j)/(t(i,k,j)*t(i,k,j)))/((1.+xlv*xlvqv/cp/r_v/t(i,k,j)&
&/t(i,k,j))*(1.+xlv*xlvqv/cp/r_v/t(i,k,j)/t(i,k,j))))/theta(i,k,j))-g_theta(i,k,j)*((1.+xlvqv/r_d/t(i,k,j))/(1.+xlv*xlvqv/cp/&
&r_v/t(i,k,j)/t(i,k,j))/(theta(i,k,j)*theta(i,k,j)))+g_xlvqv*((1/r_d/t(i,k,j)/(1.+xlv*xlvqv/cp/r_v/t(i,k,j)/t(i,k,j))-(1.+&
&xlvqv/r_d/t(i,k,j))*(xlv/cp/r_v/t(i,k,j)/t(i,k,j))/((1.+xlv*xlvqv/cp/r_v/t(i,k,j)/t(i,k,j))*(1.+xlv*xlvqv/cp/r_v/t(i,k,j)/&
&t(i,k,j))))/theta(i,k,j))
      coefa = (1.+xlvqv/r_d/t(i,k,j))/(1.+xlv*xlvqv/cp/r_v/t(i,k,j)/t(i,k,j))/theta(i,k,j)
      g_thetaep1 = g_qvs(i,k+1,j)*theta(i,k+1,j)*(xlv/cp/t(i,k+1,j))-g_t(i,k+1,j)*theta(i,k+1,j)*(xlv*qvs(i,k+1,j)/cp/(t(i,k+1,j)*&
&t(i,k+1,j)))+g_theta(i,k+1,j)*(1+xlv*qvs(i,k+1,j)/cp/t(i,k+1,j))
      thetaep1 = theta(i,k+1,j)*(1.+xlv*qvs(i,k+1,j)/cp/t(i,k+1,j))
      g_thetaesfc = g_qvsfc*thetasfc*(xlv/cp/t8w(i,kts,j))-g_t8w(i,kts,j)*thetasfc*(xlv*qvsfc/cp/(t8w(i,kts,j)*t8w(i,kts,j)))+&
&g_thetasfc*(1+xlv*qvsfc/cp/t8w(i,kts,j))
      thetaesfc = thetasfc*(1.+xlv*qvsfc/cp/t8w(i,kts,j))
      g_bn2(i,k,j) = g_coefa*g*((thetaep1-thetaesfc)/tmpdz)+g_thetaep1*g*(coefa/tmpdz)-g_thetaesfc*g*(coefa/tmpdz)-g_tmp1(i,k+1,j)*&
&(g/tmpdz)+g_tmp1sfc(i,j)*(g/tmpdz)
      bn2(i,k,j) = g*(coefa*(thetaep1-thetaesfc)/tmpdz-(tmp1(i,k+1,j)-tmp1sfc(i,j))/tmpdz)
    else
      g_qvsfc = g_moist(i,3,j,p_qv)*cf3+g_moist(i,2,j,p_qv)*cf2+g_moist(i,1,j,p_qv)*cf1
      qvsfc = cf1*moist(i,1,j,p_qv)+cf2*moist(i,2,j,p_qv)+cf3*moist(i,3,j,p_qv)
      tmpdz = 1./(rdzw(i,k,j)+epsilon)
      g_bn2(i,k,j) = g_moist(i,k+1,j,p_qv)*g*(1.61/tmpdz)+g_qvsfc*g*((-1.61)/tmpdz)+g_theta(i,k+1,j)*g*(1/theta(i,k,j)/tmpdz)+&
&g_theta(i,k,j)*g*(((-1)/theta(i,k,j)-(theta(i,k+1,j)-theta(i,k,j))/(theta(i,k,j)*theta(i,k,j)))/tmpdz)-g_tmp1(i,k+1,j)*(g/&
&tmpdz)+g_tmp1sfc(i,j)*(g/tmpdz)
      bn2(i,k,j) = g*((theta(i,k+1,j)-theta(i,k,j))/theta(i,k,j)/tmpdz+1.61*(moist(i,k+1,j,p_qv)-qvsfc)/tmpdz-(tmp1(i,k+1,j)-&
&tmp1sfc(i,j))/tmpdz)
    endif
  end do
end do
do j = j_start, j_end
  do i = i_start, i_end
    g_bn2(i,ktf,j) = g_bn2(i,ktf-1,j)
    bn2(i,ktf,j) = bn2(i,ktf-1,j)
  end do
end do

end subroutine g_calculate_n2


subroutine g_isotropic_km( xkmh, xkmhd, g_xkmhd, xkmv, xkhh, xkhv, khdif, ide, jde, ims, ime, jms, jme, kms, kme, its, ite, jts, &
&jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: g_xkmhd(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
real, intent(in) :: khdif
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(inout) :: xkhh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkhv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmv(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
ktf = kte
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      g_xkmhd(i,k,j) = 0.
      xkmhd(i,k,j) = khdif
    end do
  end do
end do

end subroutine g_isotropic_km


subroutine g_smag2d_km( config_flags, xkmh, g_xkmh, xkmhd, g_xkmhd, xkmv, xkhh, xkhv, defor11, defor22, defor12, dx, dy, ids, ide, &
&jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: defor11(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor12(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor22(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dx
real, intent(in) :: dy
real, intent(inout) :: g_xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_xkmhd(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(inout) :: xkhh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkhv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmv(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real def2(its:ite,kts:kte,jts:jte)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real mlen_h
real tmp

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
ktf = min(kte,kde-1)
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
if (config_flags%open_xs .or. config_flags%specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
if (config_flags%open_xe .or. config_flags%specified .or. config_flags%nested) then
  i_end = min(ide-2,ite)
endif
if (config_flags%open_ys .or. config_flags%specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
if (config_flags%open_ye .or. config_flags%specified .or. config_flags%nested) then
  j_end = min(jde-2,jte)
endif
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      def2(i,k,j) = 0.25*(defor11(i,k,j)-defor22(i,k,j))**2+defor12(i,k,j)*defor12(i,k,j)
    end do
  end do
end do
mlen_h = sqrt(dx*dy)
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      tmp = def2(i,k,j)**0.5
      g_xkmh(i,k,j) = 0.
      xkmh(i,k,j) = c_s*c_s*mlen_h*mlen_h*tmp
      g_xkmh(i,k,j) = g_xkmh(i,k,j)*(0.5+sign(0.5,10.*mlen_h-xkmh(i,k,j)))
      xkmh(i,k,j) = min(xkmh(i,k,j),10.*mlen_h)
      g_xkmhd(i,k,j) = g_xkmh(i,k,j)
      xkmhd(i,k,j) = xkmh(i,k,j)
    end do
  end do
end do

end subroutine g_smag2d_km


subroutine g_smag_km( config_flags, xkmh, g_xkmh, xkmhd, g_xkmhd, xkmv, xkhh, xkhv, bn2, g_bn2, defor11, defor22, defor33, defor12,&
& defor13, defor23, rdzw, dx, dy, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: bn2(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: defor11(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor12(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor13(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor22(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor23(ims:ime,kms:kme,jms:jme)
real, intent(in) :: defor33(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dx
real, intent(in) :: dy
real, intent(in) :: g_bn2(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_xkmhd(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: rdzw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkhh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkhv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmv(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real cr_len
real def2(its:ite,kts:kte,jts:jte)
real deltas
real g_tmp
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real mlen_h
real pr
real tmp

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
ktf = min(kte,kde-1)
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
if (config_flags%open_xs .or. config_flags%specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
if (config_flags%open_xe .or. config_flags%specified .or. config_flags%nested) then
  i_end = min(ide-2,ite)
endif
if (config_flags%open_ys .or. config_flags%specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
if (config_flags%open_ye .or. config_flags%specified .or. config_flags%nested) then
  j_end = min(jde-2,jte)
endif
pr = 1./3.
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      def2(i,k,j) = 0.5*(defor11(i,k,j)*defor11(i,k,j)+defor22(i,k,j)*defor22(i,k,j)+defor33(i,k,j)*defor33(i,k,j))
    end do
  end do
end do
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      g_tmp = 0.
      tmp = 0.25*(defor12(i,k,j)+defor12(i,k,j+1)+defor12(i+1,k,j)+defor12(i+1,k,j+1))
      def2(i,k,j) = def2(i,k,j)+0.5*tmp*tmp
    end do
  end do
end do
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      g_tmp = 0.
      tmp = 0.25*(defor13(i,k+1,j)+defor13(i,k,j)+defor13(i+1,k+1,j)+defor13(i+1,k,j))
      def2(i,k,j) = def2(i,k,j)+0.5*tmp*tmp
    end do
  end do
end do
do j = j_start, j_end
  do k = kts, ktf
    do i = i_start, i_end
      g_tmp = 0.
      tmp = 0.25*(defor23(i,k+1,j)+defor23(i,k,j)+defor23(i,k+1,j+1)+defor23(i,k,j+1))
      def2(i,k,j) = def2(i,k,j)+0.5*tmp*tmp
    end do
  end do
end do
cr_len = dx+1.
if (dx .gt. cr_len) then
  mlen_h = sqrt(dx*dy)
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        g_tmp = -(g_bn2(i,k,j)*((0.5-sign(0.5,0.-(def2(i,k,j)-bn2(i,k,j)/pr)))/pr))
        tmp = max(0.,def2(i,k,j)-bn2(i,k,j)/pr)
        g_tmp = 0.5*g_tmp*tmp**(-0.5)
        tmp = tmp**0.5
        g_xkmh(i,k,j) = g_tmp*(0.5+sign(0.5,c_s*c_s*mlen_h*mlen_h*tmp-1.e-6*mlen_h*mlen_h))*c_s*c_s*mlen_h*mlen_h
        xkmh(i,k,j) = max(c_s*c_s*mlen_h*mlen_h*tmp,1.e-6*mlen_h*mlen_h)
        g_xkmh(i,k,j) = g_xkmh(i,k,j)*(0.5+sign(0.5,10.*mlen_h-xkmh(i,k,j)))
        xkmh(i,k,j) = min(xkmh(i,k,j),10.*mlen_h)
        g_xkmhd(i,k,j) = g_xkmh(i,k,j)
        xkmhd(i,k,j) = xkmh(i,k,j)
      end do
    end do
  end do
else
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        deltas = (dx*dy/rdzw(i,k,j))**0.33333333
        g_tmp = -(g_bn2(i,k,j)*((0.5-sign(0.5,0.-(def2(i,k,j)-bn2(i,k,j)/pr)))/pr))
        tmp = max(0.,def2(i,k,j)-bn2(i,k,j)/pr)
        g_tmp = 0.5*g_tmp*tmp**(-0.5)
        tmp = tmp**0.5
        g_xkmh(i,k,j) = g_tmp*(0.5+sign(0.5,c_s*c_s*deltas*deltas*tmp-1.e-6*deltas*deltas))*c_s*c_s*deltas*deltas
        xkmh(i,k,j) = max(c_s*c_s*deltas*deltas*tmp,1.e-6*deltas*deltas)
        g_xkmh(i,k,j) = g_xkmh(i,k,j)*(0.5+sign(0.5,10.*deltas-xkmh(i,k,j)))
        xkmh(i,k,j) = min(xkmh(i,k,j),10.*deltas)
        g_xkmhd(i,k,j) = g_xkmh(i,k,j)
        xkmhd(i,k,j) = xkmh(i,k,j)
      end do
    end do
  end do
endif

end subroutine g_smag_km


subroutine g_tke_km( config_flags, xkmh, g_xkmh, xkmhd, g_xkmhd, xkmv, xkhh, xkhv, bn2, g_bn2, tke, rdzw, dx, dy, &
&kh_tke_upper_bound, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real epsilon
parameter ( epsilon = 1.e-10 )
real tke_seed_value
parameter ( tke_seed_value = 1.e-6 )

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: bn2(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: dx
real, intent(in) :: dy
real, intent(in) :: g_bn2(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_xkmhd(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
real, intent(in) :: kh_tke_upper_bound
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: rdzw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: tke(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkhh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkhv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmh(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: xkmv(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real cr_len
real g_l_scale(its:ite,kts:kte,jts:jte)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer ktf
real l_scale(its:ite,kts:kte,jts:jte)
real mlen_h
real tke_seed
real tmp

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
ktf = min(kte,kde-1)
i_start = its
i_end = min(ite,ide-1)
j_start = jts
j_end = min(jte,jde-1)
if (config_flags%open_xs .or. config_flags%specified .or. config_flags%nested) then
  i_start = max(ids+1,its)
endif
if (config_flags%open_xe .or. config_flags%specified .or. config_flags%nested) then
  i_end = min(ide-2,ite)
endif
if (config_flags%open_ys .or. config_flags%specified .or. config_flags%nested) then
  j_start = max(jds+1,jts)
endif
if (config_flags%open_ye .or. config_flags%specified .or. config_flags%nested) then
  j_end = min(jde-2,jte)
endif
tke_seed = tke_seed_value
if (config_flags%tke_drag_coefficient .gt. epsilon .or. config_flags%tke_heat_flux .gt. epsilon) then
  tke_seed = 0.
endif
cr_len = dx+1.
if (dx .gt. cr_len) then
  mlen_h = sqrt(dx*dy)
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        tmp = sqrt(max(tke(i,k,j),tke_seed))
        g_xkmh(i,k,j) = 0.
        xkmh(i,k,j) = max(c_k*tmp*mlen_h,1.e-6*mlen_h*mlen_h)
        g_xkmh(i,k,j) = g_xkmh(i,k,j)*(0.5+sign(0.5,10.*mlen_h-xkmh(i,k,j)))
        xkmh(i,k,j) = min(xkmh(i,k,j),10.*mlen_h)
        g_xkmhd(i,k,j) = g_xkmh(i,k,j)
        xkmhd(i,k,j) = xkmh(i,k,j)
      end do
    end do
  end do
else
  call g_calc_l_scale( tke,bn2,g_bn2,l_scale,g_l_scale,i_start,i_end,ktf,j_start,j_end,dx,dy,rdzw,ims,ime,jms,jme,kms,kme,its,ite,&
&jts,jte,kts,kte )
  do j = j_start, j_end
    do k = kts, ktf
      do i = i_start, i_end
        tmp = sqrt(max(tke(i,k,j),tke_seed))
        g_xkmh(i,k,j) = g_l_scale(i,k,j)*c_k*tmp
        xkmh(i,k,j) = c_k*tmp*l_scale(i,k,j)
        g_xkmh(i,k,j) = g_xkmh(i,k,j)*(0.5-sign(0.5,xkmh(i,k,j)-kh_tke_upper_bound))
        xkmh(i,k,j) = min(kh_tke_upper_bound,xkmh(i,k,j))
        g_xkmhd(i,k,j) = g_xkmh(i,k,j)
        xkmhd(i,k,j) = xkmh(i,k,j)
      end do
    end do
  end do
endif

end subroutine g_tke_km


end module     g_module_diffusion_em


