!                           DISCLAIMER
!
!   This file was generated by TAF version 1.7.18
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     a_module_em
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use module_model_constants
use module_advect_em
use a_module_advect_em
use module_big_step_utilities_em
use a_module_big_step_utilities_em
use module_state_description
use module_em

USE module_trace, only : trace_entry, trace_exit

!==============================================
! all entries are defined explicitly
!==============================================
implicit none


contains

subroutine a_init_zero_tendency( a_ru_tendf, a_rv_tendf, a_rw_tendf, a_ph_tendf, a_t_tendf, a_moist_tendf, n_moist, ims, ime, jms, &
&jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
integer, intent(in) :: n_moist
real, intent(inout) :: a_moist_tendf(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(inout) :: a_ph_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_tendf(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
integer, intent(in) :: kts

!==============================================
! declare local variables
!==============================================
integer im

  call trace_entry("a_init_zero_tendency")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do im = n_moist, 1, -1
  call a_zero_tend( a_moist_tendf(ims,kms,jms,im),ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
end do
call a_zero_tend( a_t_tendf,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_ph_tendf,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_rw_tendf,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_rv_tendf,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_ru_tendf,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )

  call trace_exit("a_init_zero_tendency")

end subroutine a_init_zero_tendency


subroutine a_rk_addtend_dry( a_ru_tend, a_rv_tend, a_rw_tend, a_ph_tend, a_t_tend, a_ru_tendf, a_rv_tendf, a_rw_tendf, a_ph_tendf, &
&a_t_tendf, a_u_save, a_v_save, a_w_save, a_ph_save, a_t_save, rk_step, h_diabatic, a_mut, msft, msfu, msfv, ide, jde, ims, ime, &
&jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: a_mut(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_ph_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: h_diabatic(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
integer, intent(in) :: rk_step

!==============================================
! declare local variables
!==============================================
integer i
integer j
integer k

  call trace_entry("a_rk_addtend_dry")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do j = jts, min(jte,jde-1)
  do k = kts, kte-1
    do i = its, min(ite,ide-1)
      a_mut(i,j) = a_mut(i,j)+a_t_tend(i,k,j)*(h_diabatic(i,k,j)/msft(i,j))
      a_t_tendf(i,k,j) = a_t_tendf(i,k,j)+a_t_tend(i,k,j)/msft(i,j)
      if (rk_step .eq. 1) then
        a_t_save(i,k,j) = a_t_save(i,k,j)+a_t_tendf(i,k,j)
      endif
    end do
  end do
end do
do j = jts, min(jte,jde-1)
  do k = kts, kte
    do i = its, min(ite,ide-1)
      a_ph_tendf(i,k,j) = a_ph_tendf(i,k,j)+a_ph_tend(i,k,j)/msft(i,j)
      if (rk_step .eq. 1) then
        a_ph_save(i,k,j) = a_ph_save(i,k,j)+a_ph_tendf(i,k,j)
      endif
      a_rw_tendf(i,k,j) = a_rw_tendf(i,k,j)+a_rw_tend(i,k,j)/msft(i,j)
      if (rk_step .eq. 1) then
        a_w_save(i,k,j) = a_w_save(i,k,j)+a_rw_tendf(i,k,j)*msft(i,j)
      endif
    end do
  end do
end do
do j = jts, jte
  do k = kts, kte-1
    do i = its, min(ite,ide-1)
      a_rv_tendf(i,k,j) = a_rv_tendf(i,k,j)+a_rv_tend(i,k,j)/msfv(i,j)
      if (rk_step .eq. 1) then
        a_v_save(i,k,j) = a_v_save(i,k,j)+a_rv_tendf(i,k,j)*msfv(i,j)
      endif
    end do
  end do
end do
do j = jts, min(jte,jde-1)
  do k = kts, kte-1
    do i = its, ite
      a_ru_tendf(i,k,j) = a_ru_tendf(i,k,j)+a_ru_tend(i,k,j)/msfu(i,j)
      if (rk_step .eq. 1) then
        a_u_save(i,k,j) = a_u_save(i,k,j)+a_ru_tendf(i,k,j)*msfu(i,j)
      endif
    end do
  end do
end do

  call trace_exit("a_rk_addtend_dry")

end subroutine a_rk_addtend_dry


subroutine a_rk_scalar_tend( scs, sce, config_flags, rk_step, ru, a_ru, rv, a_rv, ww, a_ww, mut, a_mut, alt, a_alt, scalar_old, &
&a_scalar_old, scalar, a_scalar, a_scalar_tends, a_advect_tend, base, moist_step, fnm, fnp, msfu, msfv, msft, rdx, rdy, rdn, rdnw, &
&kvdif, xkmhd, a_xkmhd, leapfrog, ids, ide, jds, jde, kds, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real a_advect_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_alt(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_mut(ims:ime,jms:jme)
real, intent(inout) :: a_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: sce
integer, intent(in) :: scs
real, intent(inout) :: a_scalar(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: a_scalar_old(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: a_scalar_tends(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: a_ww(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: base(kms:kme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: fnm(kms:kme)
real, intent(in) :: fnp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kds
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
logical, intent(in) :: leapfrog
logical, intent(in) :: moist_step
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: rdx
real, intent(in) :: rdy
integer, intent(in) :: rk_step
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: scalar(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: scalar_old(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(in) :: ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: xkmhd(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer im
real kvdq

  call trace_entry("a_rk_scalar_tend")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
kvdq = kvdif/prandtl
! recompute : kvdq
a_scalar_loop: do im = sce, scs, -1
  a_diff_opt1: if (config_flags%diff_opt .eq. 1) then
    a_rk_step_1: if (rk_step .eq. 1) then
      if ( .not. leapfrog) then
        a_pbl_test: if (config_flags%bl_pbl_physics .eq. 0) then
          if (moist_step .and. im .eq. p_qv) then
            call a_vertical_diffusion_mp( scalar(ims,kms,jms,im),a_scalar(ims,kms,jms,im),a_scalar_tends(ims,kms,jms,im),base,alt,&
&a_alt,mut,a_mut,rdn,rdnw,kvdq,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
          else
            call a_vertical_diffusion( 'm',scalar(ims,kms,jms,im),a_scalar(ims,kms,jms,im),a_scalar_tends(ims,kms,jms,im),alt,&
&a_alt,mut,a_mut,rdn,rdnw,kvdq,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
          endif
        endif a_pbl_test
        call a_horizontal_diffusion( 'm',scalar(ims,kms,jms,im),a_scalar(ims,kms,jms,im),a_scalar_tends(ims,kms,jms,im),mut,a_mut,&
&config_flags,msfu,msfv,msft,xkmhd,a_xkmhd,rdx,rdy,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      else
        a_pbl_test_lf: if (config_flags%bl_pbl_physics .eq. 0) then
          if (moist_step .and. im .eq. p_qv) then
            call a_vertical_diffusion_mp( scalar_old(ims,kms,jms,im),a_scalar_old(ims,kms,jms,im),a_scalar_tends(ims,kms,jms,im),&
&base,alt,a_alt,mut,a_mut,rdn,rdnw,kvdq,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
          else
            call a_vertical_diffusion( 'm',scalar_old(ims,kms,jms,im),a_scalar_old(ims,kms,jms,im),a_scalar_tends(ims,kms,jms,im),&
&alt,a_alt,mut,a_mut,rdn,rdnw,kvdq,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
          endif
        endif a_pbl_test_lf
        call a_horizontal_diffusion( 'm',scalar_old(ims,kms,jms,im),a_scalar_old(ims,kms,jms,im),a_scalar_tends(ims,kms,jms,im),&
&mut,a_mut,config_flags,msfu,msfv,msft,xkmhd,a_xkmhd,rdx,rdy,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      endif
    endif a_rk_step_1
  endif a_diff_opt1
  if ( .not. leapfrog) then

    call a_advect_scalar( scalar(ims,kms,jms,im),a_scalar(ims,kms,jms,im),scalar(ims,kms,jms,im),a_scalar(ims,kms,jms,im),&
&a_advect_tend(ims,kms,jms),ru,a_ru,rv,a_rv,ww,a_ww,config_flags,msft,fnm,fnp,rdx,rdy,rdnw,ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,&
&kms,kme,its,ite,jts,jte,kts,kte )

  else
    call a_advect_scalar( scalar(ims,kms,jms,im),a_scalar(ims,kms,jms,im),scalar_old(ims,kms,jms,im),a_scalar_old(ims,kms,jms,im),&
&a_advect_tend(ims,kms,jms),ru,a_ru,rv,a_rv,ww,a_ww,config_flags,msft,fnm,fnp,rdx,rdy,rdnw,ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,&
&kms,kme,its,ite,jts,jte,kts,kte )
  endif
  call a_zero_tend( a_advect_tend(ims,kms,jms),ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
end do a_scalar_loop

  call trace_exit("a_rk_scalar_tend")

end subroutine a_rk_scalar_tend


subroutine a_rk_step_prep( config_flags, u, a_u, v, a_v, w, a_w, a_ph, mu, a_mu, moist, a_moist, a_ru, a_rv, a_rw, a_ww, a_php, &
&a_alt, muu, a_muu, muv, a_muv, mub, mut, a_mut, a_al, a_cqu, a_cqv, a_cqw, msfu, msfv, msft, dnw, rdx, rdy, n_moist, ids, ide, &
&jds, jde, kds, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_al(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_alt(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqu(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqw(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: n_moist
real, intent(inout) :: a_moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(inout) :: a_mu(ims:ime,jms:jme)
real, intent(inout) :: a_mut(ims:ime,jms:jme)
real, intent(inout) :: a_muu(ims:ime,jms:jme)
real, intent(inout) :: a_muv(ims:ime,jms:jme)
real, intent(inout) :: a_ph(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_php(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ww(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: dnw(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: mub(ims:ime,jms:jme)
real, intent(out) :: mut(ims:ime,jms:jme)
real, intent(out) :: muu(ims:ime,jms:jme)
real, intent(out) :: muv(ims:ime,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer kds

  call trace_entry("a_rk_step_prep")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
call calculate_full( mut,mub,mu,ids,ide,jds,jde,1,2,ims,ime,jms,jme,1,1,its,ite,jts,jte,1,1 )
! recompute : mut
call calc_mu_uv( config_flags,mu,mub,muu,muv,ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
! recompute : muu,muv
call a_calc_php( a_php,a_ph,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte ) !optimized
call a_calc_alt( a_alt,a_al,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte ) !optimized
call a_calc_cq( moist,a_moist,a_cqu,a_cqv,a_cqw,n_moist,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte ) !ok
call a_calc_ww_cp( u,a_u,v,a_v,mu,a_mu,mub,a_ww,rdx,rdy,msft,msfu,msfv,dnw,ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )  !ok
call a_couple_momentum( muu,a_muu,a_ru,u,a_u,msfu,muv,a_muv,a_rv,v,a_v,msfv,mut,a_mut,a_rw,w,a_w,msft,ide,jde,kde,ims,ime,jms,jme,&
&kms,kme,its,ite,jts,jte,kts,kte ) !ok
call a_calc_mu_uv( config_flags,a_mu,a_muu,a_muv,ids,ide,jds,jde,ims,ime,jms,jme,its,ite,jts,jte )  !ok
call a_calculate_full( a_mut,a_mu,ide,jde,2,ims,ime,jms,jme,1,1,its,ite,jts,jte,1,1 )  !optimized

  call trace_exit("a_rk_step_prep")

end subroutine a_rk_step_prep


subroutine a_rk_tendency1( config_flags, rk_step, a_ru_tend, a_rv_tend, a_rw_tend, a_ph_tend, a_t_tend, a_ru_tendf, a_rv_tendf, &
&a_rw_tendf, a_t_tendf, a_mu_tend, a_u_save, a_v_save, a_w_save, a_ph_save, a_t_save, ru, a_ru, rv, a_rv, rw, a_rw, ww, a_ww, u, &
&a_u, v, a_v, w, a_w, t, a_t, ph, a_ph, u_old, a_u_old, v_old, a_v_old, w_old, a_w_old, t_old, a_t_old, ph_old, a_ph_old, phb, &
&t_init, mu, a_mu, mut, a_mut, muu, a_muu, muv, a_muv, mub, al, a_al, alt, a_alt, p, a_p, pb, php, a_php, cqu, a_cqu, cqv, a_cqv, &
&cqw, a_cqw, u_base, v_base, z_base, msfu, msfv, msft, f, e, sina, cosa, fnm, fnp, rdn, rdnw, dt, rdx, rdy, kvdif, xkmhd, a_xkmhd, &
&cf1, cf2, cf3, cfn, cfn1, non_hydrostatic, leapfrog, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, &
&kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_al(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_alt(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqu(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_mu(ims:ime,jms:jme)
real, intent(inout) :: a_mu_tend(ims:ime,jms:jme)
real, intent(inout) :: a_mut(ims:ime,jms:jme)
real, intent(inout) :: a_muu(ims:ime,jms:jme)
real, intent(inout) :: a_muv(ims:ime,jms:jme)
real, intent(inout) :: a_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_php(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ww(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(in) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real cf1
real cf2
real cf3
real cfn
real cfn1
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: cosa(ims:ime,jms:jme)
real, intent(in) :: cqu(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cqv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: cqw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dt
real, intent(in) :: e(ims:ime,jms:jme)
real, intent(in) :: f(ims:ime,jms:jme)
real, intent(in) :: fnm(kms:kme)
real, intent(in) :: fnp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
logical, intent(in) :: leapfrog
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: mub(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
logical, intent(in) :: non_hydrostatic
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: php(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: rdx
real, intent(in) :: rdy
integer, intent(in) :: rk_step
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: sina(ims:ime,jms:jme)
real, intent(in) :: t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t_init(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u_base(kms:kme)
real, intent(in) :: u_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v_base(kms:kme)
real, intent(in) :: v_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(in) :: z_base(kms:kme)

!==============================================
! declare local variables
!==============================================
real kvdq
!!Real*4 :: Stime(2)
!!Double Precision, Save :: TimeStart(32)
!!Data TimeStart /32*0./
!!Double Precision :: TimeEnd(32), Etime

  call trace_entry("a_rk_tendency1")

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
a_forward_step: if (rk_step .eq. 1) then
  a_diff_opt1: if (config_flags%diff_opt .eq. 1) then
    a_leapfrog_test: if ( .not. leapfrog) then
      a_pbl_test: if (config_flags%bl_pbl_physics .eq. 0) then
        kvdq = 3.*kvdif
! recompute : kvdq

!!TimeStart(11)=Etime(Stime)-TimeStart(11)
        call a_vertical_diffusion_3dmp( t,a_t,a_t_tendf,t_init,alt,a_alt,mut,a_mut,rdn,rdnw,kvdq,ide,jde,kde,ims,ime,jms,jme,kms,&
&kme,its,ite,jts,jte,kts,kte )

!!TimeEnd(11)=Etime(Stime); TimeStart(11)=TimeEnd(11)-TimeStart(11)
!!Print*, '<<<<<<<Time cost of a_vertical_diffusion_3dmp(11)', TimeStart(11)

        if (non_hydrostatic) then
!!TimeStart(12)=Etime(Stime)-TimeStart(12)
          call a_vertical_diffusion( 'w',w,a_w,a_rw_tendf,alt,a_alt,mut,a_mut,rdn,rdnw,kvdif,ide,jde,kde,ims,ime,jms,jme,kms,kme,&
&its,ite,jts,jte,kts,kte )
        endif
        call a_vertical_diffusion_v( v,a_v,a_rv_tendf,config_flags,v_base,alt,a_alt,muv,a_muv,rdn,rdnw,kvdif,ide,jds,jde,kde,ims,&
&ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
        call a_vertical_diffusion_u( u,a_u,a_ru_tendf,config_flags,u_base,alt,a_alt,muu,a_muu,rdn,rdnw,kvdif,ids,ide,jde,kde,ims,&
&ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      endif a_pbl_test
      call a_horizontal_diffusion_3dmp( t,a_t,a_t_tendf,mut,a_mut,config_flags,t_init,msfu,msfv,msft,xkmhd,a_xkmhd,rdx,rdy,ids,ide,&
&jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      call a_horizontal_diffusion( 'w',w,a_w,a_rw_tendf,mut,a_mut,config_flags,msfu,msfv,msft,xkmhd,a_xkmhd,rdx,rdy,ids,ide,jds,&
&jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      call a_horizontal_diffusion( 'v',v,a_v,a_rv_tendf,mut,a_mut,config_flags,msfu,msfv,msft,xkmhd,a_xkmhd,rdx,rdy,ids,ide,jds,&
&jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      call a_horizontal_diffusion( 'u',u,a_u,a_ru_tendf,mut,a_mut,config_flags,msfu,msfv,msft,xkmhd,a_xkmhd,rdx,rdy,ids,ide,jds,&
&jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )

!!TimeEnd(12)=Etime(Stime); TimeStart(12)=TimeEnd(12)-TimeStart(12)
!!Print*, '<<<<<<<<<<Time cost of a_horizontal_diffusion(12)', TimeStart(12)

    else a_leapfrog_test
!!TimeStart(13)=Etime(Stime)-TimeStart(13)
      a_pbl_test_lf: if (config_flags%bl_pbl_physics .eq. 0) then
        kvdq = 3.*kvdif
! recompute : kvdq
        call a_vertical_diffusion_3dmp( t_old,a_t_old,a_t_tendf,t_init,alt,a_alt,mut,a_mut,rdn,rdnw,kvdq,ide,jde,kde,ims,ime,jms,&
&jme,kms,kme,its,ite,jts,jte,kts,kte )
        if (non_hydrostatic) then
          call a_vertical_diffusion( 'w',w_old,a_w_old,a_rw_tendf,alt,a_alt,mut,a_mut,rdn,rdnw,kvdif,ide,jde,kde,ims,ime,jms,jme,&
&kms,kme,its,ite,jts,jte,kts,kte )
        endif
        call a_vertical_diffusion_v( v_old,a_v_old,a_rv_tendf,config_flags,v_base,alt,a_alt,muv,a_muv,rdn,rdnw,kvdif,ide,jds,jde,&
&kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
        call a_vertical_diffusion_u( u_old,a_u_old,a_ru_tendf,config_flags,u_base,alt,a_alt,muu,a_muu,rdn,rdnw,kvdif,ids,ide,jde,&
&kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      endif a_pbl_test_lf

!!TimeEnd(13)=Etime(Stime); TimeStart(13)=TimeEnd(13)-TimeStart(13)
!!Print*, '<<<<<<<<<<<<Time cost of a_vertical_diffusion(13)', TimeStart(13)

!!TimeStart(14)=Etime(Stime)-TimeStart(14)
      call a_horizontal_diffusion_3dmp( t_old,a_t_old,a_t_tendf,mut,a_mut,config_flags,t_init,msfu,msfv,msft,xkmhd,a_xkmhd,rdx,rdy,&
&ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      if (non_hydrostatic) then
        call a_horizontal_diffusion( 'w',w_old,a_w_old,a_rw_tendf,mut,a_mut,config_flags,msfu,msfv,msft,xkmhd,a_xkmhd,rdx,rdy,ids,&
&ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      endif
      call a_horizontal_diffusion( 'v',v_old,a_v_old,a_rv_tendf,mut,a_mut,config_flags,msfu,msfv,msft,xkmhd,a_xkmhd,rdx,rdy,ids,&
&ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      call a_horizontal_diffusion( 'u',u_old,a_u_old,a_ru_tendf,mut,a_mut,config_flags,msfu,msfv,msft,xkmhd,a_xkmhd,rdx,rdy,ids,&
&ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )

!!TimeEnd(14)=Etime(Stime); TimeStart(14)=TimeEnd(14)-TimeStart(14)
!!Print*, '<<<<<<<<<<Time cost of a_horizontal_diffusion(14)', TimeStart(14)

    endif a_leapfrog_test
  endif a_diff_opt1
endif a_forward_step

!!TimeStart(15)=Etime(Stime)-TimeStart(15)
call a_curvature( ru,a_ru,rv,a_rv,rw,a_rw,u,a_u,v,a_v,a_ru_tend,a_rv_tend,a_rw_tend,config_flags,msfu,msfv,fnm,fnp,rdx,rdy,ids,ide,&
&jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )

!!TimeEnd(15)=Etime(Stime); TimeStart(15)=TimeEnd(15)-TimeStart(15)
!!Print*, '<<<<<<<<<<<<<<<<<<<<<Time cost of a_curvature(15)', TimeStart(15)


!!TimeStart(16)=Etime(Stime)-TimeStart(16)
if (config_flags%pert_coriolis) then
  call a_perturbation_coriolis( a_ru,a_rv,a_rw,a_ru_tend,a_rv_tend,a_rw_tend,config_flags,u_base,v_base,z_base,muu,a_muu,muv,a_muv,&
&phb,ph,a_ph,f,e,sina,cosa,fnm,fnp,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
else
  call a_coriolis( a_ru,a_rv,a_rw,a_ru_tend,a_rv_tend,a_rw_tend,config_flags,f,e,sina,cosa,fnm,fnp,ids,ide,jds,jde,kde,ims,ime,jms,&
&jme,kms,kme,its,ite,jts,jte,kts,kte )
endif
if (config_flags%w_damping .eq. 1) then
  call a_w_damp( a_rw_tend,ww,a_ww,w,a_w,mut,a_mut,rdnw,dt,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte )
endif
if (non_hydrostatic) then
  call a_pg_buoy_w( a_rw_tend,p,a_p,cqw,a_cqw,a_mu,mub,rdnw,rdn,g,msft,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte )
endif

!!TimeEnd(16)=Etime(Stime); TimeStart(16)=TimeEnd(16)-TimeStart(16)
!!Print*, '<<<<<<<<<<<<<<<<<<Time cost of a_rk_tendency1(16)', TimeStart(16)

!!TimeStart(17)=Etime(Stime)-TimeStart(17)
call a_horizontal_pressure_gradient( a_ru_tend,a_rv_tend,ph,a_ph,alt,a_alt,p,a_p,pb,al,a_al,php,a_php,cqu,a_cqu,cqv,a_cqv,muu,&
&a_muu,muv,a_muv,mu,a_mu,fnm,fnp,rdnw,cf1,cf2,cf3,rdx,rdy,config_flags,non_hydrostatic,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,&
&its,ite,jts,jte,kte )

!!TimeEnd(17)=Etime(Stime); TimeStart(17)=TimeEnd(17)-TimeStart(17)
!!Print*, '<<Time cost of a_horizontal_pressure_gradient(17)', TimeStart(17)

!!TimeStart(18)=Etime(Stime)-TimeStart(18)
  call a_rhs_ph( a_ph_tend,u,a_u,v,a_v,ww,a_ww,ph,a_ph,ph,a_ph,phb,w,a_w,mut,a_mut,muu,a_muu,muv,a_muv,fnm,fnp,rdnw,cfn,cfn1,rdx,&
&rdy,msft,non_hydrostatic,config_flags,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )


!!TimeEnd(18)=Etime(Stime); TimeStart(18)=TimeEnd(18)-TimeStart(18)
!!Print*, '<<<<<<<<<<<<<<<<<<<<<<<<Time cost of a_rhs_ph(18)', TimeStart(18)

  call trace_exit("a_rk_tendency1")

end subroutine a_rk_tendency1


subroutine a_rk_tendency2( config_flags, rk_step, a_ru_tend, a_rv_tend, a_rw_tend, a_ph_tend, a_t_tend, a_ru_tendf, a_rv_tendf, &
&a_rw_tendf, a_t_tendf, a_mu_tend, a_u_save, a_v_save, a_w_save, a_ph_save, a_t_save, ru, a_ru, rv, a_rv, rw, a_rw, ww, a_ww, u, &
&a_u, v, a_v, w, a_w, t, a_t, ph, a_ph, u_old, a_u_old, v_old, a_v_old, w_old, a_w_old, t_old, a_t_old, ph_old, a_ph_old, phb, &
&t_init, mu, a_mu, mut, a_mut, muu, a_muu, muv, a_muv, mub, al, a_al, alt, a_alt, p, a_p, pb, php, a_php, cqu, a_cqu, cqv, a_cqv, &
&cqw, a_cqw, u_base, v_base, z_base, msfu, msfv, msft, f, e, sina, cosa, fnm, fnp, rdn, rdnw, dt, rdx, rdy, kvdif, xkmhd, a_xkmhd, &
&cf1, cf2, cf3, cfn, cfn1, non_hydrostatic, leapfrog, ids, ide, jds, jde, kds, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, &
&kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_al(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_alt(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqu(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_cqw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_mu(ims:ime,jms:jme)
real, intent(inout) :: a_mu_tend(ims:ime,jms:jme)
real, intent(inout) :: a_mut(ims:ime,jms:jme)
real, intent(inout) :: a_muu(ims:ime,jms:jme)
real, intent(inout) :: a_muv(ims:ime,jms:jme)
real, intent(inout) :: a_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_php(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rw_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_t_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_u_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_v_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w_old(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_w_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_ww(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(in) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real cf1
real cf2
real cf3
real cfn
real cfn1
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: cosa(ims:ime,jms:jme)
real, intent(in) :: cqu(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cqv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: cqw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dt
real, intent(in) :: e(ims:ime,jms:jme)
real, intent(in) :: f(ims:ime,jms:jme)
real, intent(in) :: fnm(kms:kme)
real, intent(in) :: fnp(kms:kme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kds
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
logical, intent(in) :: leapfrog
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: mub(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
logical, intent(in) :: non_hydrostatic
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: php(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: rdx
real, intent(in) :: rdy
integer, intent(in) :: rk_step
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: sina(ims:ime,jms:jme)
real, intent(in) :: t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t_init(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u_base(kms:kme)
real, intent(in) :: u_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v_base(kms:kme)
real, intent(in) :: v_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w_old(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(in) :: z_base(kms:kme)

!==============================================
! declare local variables
!==============================================
real kvdq

!Real*4 :: Stime(2)
!Double Precision, Save :: TimeStart(32)
!Data TimeStart /32*0./
!Double Precision :: TimeEnd(32), Etime

call trace_entry("a_rk_tendency2")

!TimeStart(21)=Etime(Stime)-TimeStart(21)
call a_advect_scalar( t,a_t,t,a_t,a_t_tend,ru,a_ru,rv,a_rv,ww,a_ww,config_flags,msft,fnm,fnp,rdx,rdy,rdnw,ids,ide,jds,jde,kds,kde,&
&ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
!TimeEnd(21)=Etime(Stime); TimeStart(21)=TimeEnd(21)-TimeStart(21)
!Print*, '>>>>>>>>>>>>>>>>>>Time cost of a_advect_scalar(21)', TimeStart(21)

!TimeStart(22)=Etime(Stime)-TimeStart(22)
if (non_hydrostatic) then
call a_advect_w( w,a_w,w,a_w,a_rw_tend,ru,a_ru,rv,a_rv,ww,a_ww,config_flags,msft,fnm,fnp,rdx,rdy,rdn,ids,ide,jds,jde,kde,ims,&
&ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
endif
!TimeEnd(22)=Etime(Stime); TimeStart(22)=TimeEnd(22)-TimeStart(22)
!Print*, '>>>>>>>>>>>>>>>>>>>>>>>Time cost of a_advect_w(22)', TimeStart(22)

!TimeStart(23)=Etime(Stime)-TimeStart(23)
call a_advect_v( v,a_v,v,a_v,a_rv_tend,ru,a_ru,rv,a_rv,ww,a_ww,mut,a_mut,config_flags,msfv,fnm,fnp,rdx,rdy,rdnw,ids,ide,jds,jde,&
&kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )

!TimeEnd(23)=Etime(Stime); TimeStart(23)=TimeEnd(23)-TimeStart(23)
!Print*, '>>>>>>>>>>>>>>>>>>>>>>>Time cost of a_advect_v(23)', TimeStart(23)

!TimeStart(24)=Etime(Stime)-TimeStart(24)
call a_advect_u( u,a_u,u,a_u,a_ru_tend,ru,a_ru,rv,a_rv,ww,a_ww,mut,a_mut,config_flags,msfu,fnm,fnp,rdx,rdy,rdnw,ids,ide,jds,jde,&
&kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )

!TimeEnd(24)=Etime(Stime); TimeStart(24)=TimeEnd(24)-TimeStart(24)
!Print*, '>>>>>>>>>>>>>>>>>>>>>>>Time cost of a_advect_u(24)', TimeStart(24)

!TimeStart(25)=Etime(Stime)-TimeStart(25)
call a_zero_tend( a_mu_tend,ims,ime,jms,jme,1,1,its,ite,jts,jte,1,1 )
call a_zero_tend( a_t_save,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_ph_save,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_w_save,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_v_save,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_u_save,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_ph_tend,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_t_tend,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_rw_tend,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_rv_tend,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call a_zero_tend( a_ru_tend,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )

call trace_exit("a_rk_tendency2")

!TimeEnd(25)=Etime(Stime); TimeStart(25)=TimeEnd(25)-TimeStart(25)
!Print*, '>>>>>>>>>>>>>>>>>>>>>>Time cost of a_zero_tend(25)', TimeStart(25)

end subroutine a_rk_tendency2


subroutine a_rk_update_scalar( scs, sce, scalar_1, a_scalar_1, scalar_2, a_scalar_2, sc_tend, a_sc_tend, advect_tend, &
&a_advect_tend, msft, mu_old, a_mu_old, mu_new, a_mu_new, mu_base, rk_step, dt, spec_zone, epsts, leapfrog, config_flags, ids, ide,&
& jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_advect_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_mu_new(ims:ime,jms:jme)
real, intent(inout) :: a_mu_old(ims:ime,jms:jme)
integer, intent(in) :: sce
integer, intent(in) :: scs
real, intent(inout) :: a_sc_tend(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: a_scalar_1(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: a_scalar_2(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(in) :: advect_tend(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: dt
real, intent(in) :: epsts
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
logical, intent(in) :: leapfrog
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: mu_base(ims:ime,jms:jme)
real, intent(in) :: mu_new(ims:ime,jms:jme)
real, intent(in) :: mu_old(ims:ime,jms:jme)
integer, intent(in) :: rk_step
real, intent(inout) :: sc_tend(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: scalar_1(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: scalar_2(ims:ime,kms:kme,jms:jme,scs:sce)
integer, intent(in) :: spec_zone

!==============================================
! declare local variables
!==============================================
real a_muold(its:ite)
real a_r_munew(its:ite)
real a_sc_middle
real a_tendency(its:ite,kts:kte,jts:jte)
integer i
integer i_end
integer i_end_spc
integer i_start
integer i_start_spc
integer im
integer j
integer j_end
integer j_end_spc
integer j_start
integer j_start_spc
integer k
integer k_end
integer k_end_spc
integer k_start
integer k_start_spc
real muold(its:ite)
real r_munew(its:ite)
real tendency(its:ite,kts:kte,jts:jte)

  call trace_entry("a_rk_update_scalar")

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_muold(:) = 0.
a_r_munew(:) = 0.
a_sc_middle = 0.
a_tendency(:,:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
i_start = its
! recompute : i_start
i_end = ite
! recompute : i_end
j_start = jts
! recompute : j_start
j_end = jte
! recompute : j_end
k_start = kts
! recompute : k_start
k_end = kte-1
! recompute : k_end
if (j_end .eq. jde) then
  j_end = j_end-1
endif
! recompute : j_end
if (i_end .eq. ide) then
  i_end = i_end-1
endif
! recompute : i_end
i_start_spc = i_start
! recompute : i_start_spc
i_end_spc = i_end
! recompute : i_end_spc
j_start_spc = j_start
! recompute : j_start_spc
j_end_spc = j_end
! recompute : j_end_spc
k_start_spc = k_start
! recompute : k_start_spc
k_end_spc = k_end
! recompute : k_end_spc
if (config_flags%nested .or. config_flags%specified) then
  i_start = max(its,ids+spec_zone)
  i_end = min(ite,ide-spec_zone-1)
  j_start = max(jts,jds+spec_zone)
  j_end = min(jte,jde-spec_zone-1)
  k_start = kts
  k_end = min(kte,kde-1)
endif
! recompute : i_end,i_start,j_end,j_start,k_end,k_start
if ( .not. leapfrog) then
  if (rk_step .eq. 1) then
    do im = scs, sce
      do j = jts, min(jte,jde-1)
        do k = kts, min(kte,kde-1)
          do i = its, min(ite,ide-1)
            tendency(i,k,j) = 0.
          end do
        end do
      end do
      do j = j_start, j_end
        do k = k_start, k_end
          do i = i_start, i_end
            tendency(i,k,j) = advect_tend(i,k,j)*msft(i,j)
          end do
        end do
      end do
! recompute : tendency
      do j = j_start_spc, j_end_spc
        do k = k_start_spc, k_end_spc
          do i = i_start_spc, i_end_spc
            tendency(i,k,j) = tendency(i,k,j)+sc_tend(i,k,j,im)
          end do
        end do
      end do
! recompute : tendency
      do j = jts, min(jte,jde-1)
        do i = its, min(ite,ide-1)
          muold(i) = mu_old(i,j)+mu_base(i,j)
          r_munew(i) = 1./(mu_new(i,j)+mu_base(i,j))
        end do
! recompute : muold,r_munew
        do k = kts, min(kte,kde-1)
          do i = its, min(ite,ide-1)
            scalar_1(i,k,j,im) = scalar_2(i,k,j,im)
! recompute : scalar_1
            a_muold(i) = a_muold(i)+a_scalar_2(i,k,j,im)*scalar_1(i,k,j,im)*r_munew(i)
            a_r_munew(i) = a_r_munew(i)+a_scalar_2(i,k,j,im)*(muold(i)*scalar_1(i,k,j,im)+dt*tendency(i,k,j))
            a_scalar_1(i,k,j,im) = a_scalar_1(i,k,j,im)+a_scalar_2(i,k,j,im)*muold(i)*r_munew(i)
            a_tendency(i,k,j) = a_tendency(i,k,j)+a_scalar_2(i,k,j,im)*dt*r_munew(i)
            a_scalar_2(i,k,j,im) = 0.
            a_scalar_2(i,k,j,im) = a_scalar_2(i,k,j,im)+a_scalar_1(i,k,j,im)
            a_scalar_1(i,k,j,im) = 0.
          end do
        end do
        do i = its, min(ite,ide-1)
          a_mu_new(i,j) = a_mu_new(i,j)-a_r_munew(i)/((mu_new(i,j)+mu_base(i,j))*(mu_new(i,j)+mu_base(i,j)))
          a_r_munew(i) = 0.
          a_mu_old(i,j) = a_mu_old(i,j)+a_muold(i)
          a_muold(i) = 0.
        end do
      end do
      do j = j_start_spc, j_end_spc
        do k = k_start_spc, k_end_spc
          do i = i_start_spc, i_end_spc
            a_sc_tend(i,k,j,im) = a_sc_tend(i,k,j,im)+a_tendency(i,k,j)
          end do
        end do
      end do
      do j = j_start, j_end
        do k = k_start, k_end
          do i = i_start, i_end
            a_advect_tend(i,k,j) = a_advect_tend(i,k,j)+a_tendency(i,k,j)*msft(i,j)
            a_tendency(i,k,j) = 0.
          end do
        end do
      end do
      do j = jts, min(jte,jde-1)
        do k = kts, min(kte,kde-1)
          do i = its, min(ite,ide-1)
            a_tendency(i,k,j) = 0.
          end do
        end do
      end do
    end do
  else
    do im = scs, sce
      do j = jts, min(jte,jde-1)
        do k = kts, min(kte,kde-1)
          do i = its, min(ite,ide-1)
            tendency(i,k,j) = 0.
          end do
        end do
      end do
      do j = j_start, j_end
        do k = k_start, k_end
          do i = i_start, i_end
            tendency(i,k,j) = advect_tend(i,k,j)*msft(i,j)
          end do
        end do
      end do
! recompute : tendency
      do j = j_start_spc, j_end_spc
        do k = k_start_spc, k_end_spc
          do i = i_start_spc, i_end_spc
            tendency(i,k,j) = tendency(i,k,j)+sc_tend(i,k,j,im)
          end do
        end do
      end do
! recompute : tendency
      do j = jts, min(jte,jde-1)
        do i = its, min(ite,ide-1)
          muold(i) = mu_old(i,j)+mu_base(i,j)
          r_munew(i) = 1./(mu_new(i,j)+mu_base(i,j))
        end do
! recompute : muold,r_munew
        do k = kts, min(kte,kde-1)
          do i = its, min(ite,ide-1)
            a_muold(i) = a_muold(i)+a_scalar_2(i,k,j,im)*scalar_1(i,k,j,im)*r_munew(i)
            a_r_munew(i) = a_r_munew(i)+a_scalar_2(i,k,j,im)*(muold(i)*scalar_1(i,k,j,im)+dt*tendency(i,k,j))
            a_scalar_1(i,k,j,im) = a_scalar_1(i,k,j,im)+a_scalar_2(i,k,j,im)*muold(i)*r_munew(i)
            a_tendency(i,k,j) = a_tendency(i,k,j)+a_scalar_2(i,k,j,im)*dt*r_munew(i)
            a_scalar_2(i,k,j,im) = 0.
          end do
        end do
        do i = its, min(ite,ide-1)
          a_mu_new(i,j) = a_mu_new(i,j)-a_r_munew(i)/((mu_new(i,j)+mu_base(i,j))*(mu_new(i,j)+mu_base(i,j)))
          a_r_munew(i) = 0.
          a_mu_old(i,j) = a_mu_old(i,j)+a_muold(i)
          a_muold(i) = 0.
        end do
      end do
      do j = j_start_spc, j_end_spc
        do k = k_start_spc, k_end_spc
          do i = i_start_spc, i_end_spc
            a_sc_tend(i,k,j,im) = a_sc_tend(i,k,j,im)+a_tendency(i,k,j)
          end do
        end do
      end do
      do j = j_start, j_end
        do k = k_start, k_end
          do i = i_start, i_end
            a_advect_tend(i,k,j) = a_advect_tend(i,k,j)+a_tendency(i,k,j)*msft(i,j)
            a_tendency(i,k,j) = 0.
          end do
        end do
      end do
      do j = jts, min(jte,jde-1)
        do k = kts, min(kte,kde-1)
          do i = its, min(ite,ide-1)
            a_tendency(i,k,j) = 0.
          end do
        end do
      end do
    end do
  endif
else
  do im = scs, sce
    a_sc_middle = 0.
    do j = jts, min(jte,jde-1)
      do k = kts, min(kte,kde-1)
        do i = its, min(ite,ide-1)
          tendency(i,k,j) = 0.
        end do
      end do
    end do
    do j = j_start, j_end
      do k = k_start, k_end
        do i = i_start, i_end
          tendency(i,k,j) = advect_tend(i,k,j)
        end do
      end do
    end do
! recompute : tendency
    do j = j_start_spc, j_end_spc
      do k = k_start_spc, k_end_spc
        do i = i_start_spc, i_end_spc
          tendency(i,k,j) = tendency(i,k,j)+sc_tend(i,k,j,im)
        end do
      end do
    end do
! recompute : tendency
    do j = jts, min(jte,jde-1)
      a_sc_middle = 0.
      do i = its, min(ite,ide-1)
        muold(i) = mu_old(i,j)+mu_base(i,j)
        r_munew(i) = 1./(mu_new(i,j)+mu_base(i,j))
      end do
! recompute : muold,r_munew
      do k = kts, min(kte,kde-1)
        a_sc_middle = 0.
        do i = its, min(ite,ide-1)
          a_sc_middle = 0.
          a_sc_middle = a_sc_middle+a_scalar_1(i,k,j,im)*(1+(-2)*epsts)
          a_scalar_2(i,k,j,im) = a_scalar_2(i,k,j,im)+a_scalar_1(i,k,j,im)*epsts
          a_scalar_1(i,k,j,im) = a_scalar_1(i,k,j,im)*epsts
          a_muold(i) = a_muold(i)+a_scalar_2(i,k,j,im)*scalar_1(i,k,j,im)*r_munew(i)
          a_r_munew(i) = a_r_munew(i)+a_scalar_2(i,k,j,im)*(muold(i)*scalar_1(i,k,j,im)+2*msft(i,j)**2*dt*tendency(i,k,j))
          a_scalar_1(i,k,j,im) = a_scalar_1(i,k,j,im)+a_scalar_2(i,k,j,im)*muold(i)*r_munew(i)
          a_tendency(i,k,j) = a_tendency(i,k,j)+2*a_scalar_2(i,k,j,im)*msft(i,j)**2*dt*r_munew(i)
          a_scalar_2(i,k,j,im) = 0.
          a_scalar_2(i,k,j,im) = a_scalar_2(i,k,j,im)+a_sc_middle
          a_sc_middle = 0.
        end do
      end do
      do i = its, min(ite,ide-1)
        a_mu_new(i,j) = a_mu_new(i,j)-a_r_munew(i)/((mu_new(i,j)+mu_base(i,j))*(mu_new(i,j)+mu_base(i,j)))
        a_r_munew(i) = 0.
        a_mu_old(i,j) = a_mu_old(i,j)+a_muold(i)
        a_muold(i) = 0.
      end do
    end do
    do j = j_start_spc, j_end_spc
      do k = k_start_spc, k_end_spc
        do i = i_start_spc, i_end_spc
          a_sc_tend(i,k,j,im) = a_sc_tend(i,k,j,im)+a_tendency(i,k,j)
        end do
      end do
    end do
    do j = j_start, j_end
      do k = k_start, k_end
        do i = i_start, i_end
          a_advect_tend(i,k,j) = a_advect_tend(i,k,j)+a_tendency(i,k,j)
          a_tendency(i,k,j) = 0.
        end do
      end do
    end do
    do j = jts, min(jte,jde-1)
      do k = kts, min(kte,kde-1)
        do i = its, min(ite,ide-1)
          a_tendency(i,k,j) = 0.
        end do
      end do
    end do
  end do
endif

  call trace_exit("a_rk_update_scalar")

end subroutine a_rk_update_scalar


end module     a_module_em


