!                           DISCLAIMER
!
!   This file was generated by TAF version 1.7.18
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module g_module_em
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use module_model_constants
use module_advect_em
use module_big_step_utilities_em
use module_state_description
use module_em

use g_module_advect_em
use g_module_big_step_utilities_em

USE module_trace, only : trace_entry, trace_exit

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine g_init_zero_tendency( ru_tendf, g_ru_tendf, rv_tendf, g_rv_tendf, rw_tendf, g_rw_tendf, ph_tendf, g_ph_tendf, t_tendf, &
&g_t_tendf, moist_tendf, g_moist_tendf, n_moist, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
integer, intent(in) :: n_moist
real, intent(inout) :: g_moist_tendf(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(inout) :: g_ph_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rw_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_t_tendf(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(inout) :: moist_tendf(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(inout) :: ph_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rw_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: t_tendf(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer im

  call trace_entry("g_init_zero_tendency")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
call g_zero_tend( ru_tendf,g_ru_tendf,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( rv_tendf,g_rv_tendf,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( rw_tendf,g_rw_tendf,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( ph_tendf,g_ph_tendf,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( t_tendf,g_t_tendf,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
do im = 1, n_moist
  call g_zero_tend( moist_tendf(ims,kms,jms,im),g_moist_tendf(ims,kms,jms,im),ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
end do

  call trace_exit("g_init_zero_tendency")

end subroutine g_init_zero_tendency


subroutine g_rk_addtend_dry( ru_tend, g_ru_tend, rv_tend, g_rv_tend, rw_tend, g_rw_tend, ph_tend, g_ph_tend, t_tend, g_t_tend, &
&ru_tendf, g_ru_tendf, rv_tendf, g_rv_tendf, rw_tendf, g_rw_tendf, ph_tendf, g_ph_tendf, t_tendf, g_t_tendf, u_save, g_u_save, &
&v_save, g_v_save, w_save, g_w_save, ph_save, g_ph_save, t_save, g_t_save, rk_step, h_diabatic, mut, g_mut, msft, msfu, msfv, ide, &
&jde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_mut(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: g_ph_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ph_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rw_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_t_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_t_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_w_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: h_diabatic(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: ph_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ph_tendf(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: rk_step
real, intent(inout) :: ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rw_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: t_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: t_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w_save(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer j
integer k

  call trace_entry("g_rk_addtend_dry")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do j = jts, min(jte,jde-1)
  do k = kts, kte-1
    do i = its, ite
      if (rk_step .eq. 1) then
        g_ru_tendf(i,k,j) = g_ru_tendf(i,k,j)+g_u_save(i,k,j)*msfu(i,j)
        ru_tendf(i,k,j) = ru_tendf(i,k,j)+u_save(i,k,j)*msfu(i,j)
      endif
      g_ru_tend(i,k,j) = g_ru_tend(i,k,j)+g_ru_tendf(i,k,j)/msfu(i,j)
      ru_tend(i,k,j) = ru_tend(i,k,j)+ru_tendf(i,k,j)/msfu(i,j)
    end do
  end do
end do
do j = jts, jte
  do k = kts, kte-1
    do i = its, min(ite,ide-1)
      if (rk_step .eq. 1) then
        g_rv_tendf(i,k,j) = g_rv_tendf(i,k,j)+g_v_save(i,k,j)*msfv(i,j)
        rv_tendf(i,k,j) = rv_tendf(i,k,j)+v_save(i,k,j)*msfv(i,j)
      endif
      g_rv_tend(i,k,j) = g_rv_tend(i,k,j)+g_rv_tendf(i,k,j)/msfv(i,j)
      rv_tend(i,k,j) = rv_tend(i,k,j)+rv_tendf(i,k,j)/msfv(i,j)
    end do
  end do
end do
do j = jts, min(jte,jde-1)
  do k = kts, kte
    do i = its, min(ite,ide-1)
      if (rk_step .eq. 1) then
        g_rw_tendf(i,k,j) = g_rw_tendf(i,k,j)+g_w_save(i,k,j)*msft(i,j)
        rw_tendf(i,k,j) = rw_tendf(i,k,j)+w_save(i,k,j)*msft(i,j)
      endif
      g_rw_tend(i,k,j) = g_rw_tend(i,k,j)+g_rw_tendf(i,k,j)/msft(i,j)
      rw_tend(i,k,j) = rw_tend(i,k,j)+rw_tendf(i,k,j)/msft(i,j)
      if (rk_step .eq. 1) then
        g_ph_tendf(i,k,j) = g_ph_save(i,k,j)+g_ph_tendf(i,k,j)
        ph_tendf(i,k,j) = ph_tendf(i,k,j)+ph_save(i,k,j)
      endif
      g_ph_tend(i,k,j) = g_ph_tend(i,k,j)+g_ph_tendf(i,k,j)/msft(i,j)
      ph_tend(i,k,j) = ph_tend(i,k,j)+ph_tendf(i,k,j)/msft(i,j)
    end do
  end do
end do
do j = jts, min(jte,jde-1)
  do k = kts, kte-1
    do i = its, min(ite,ide-1)
      if (rk_step .eq. 1) then
        g_t_tendf(i,k,j) = g_t_save(i,k,j)+g_t_tendf(i,k,j)
        t_tendf(i,k,j) = t_tendf(i,k,j)+t_save(i,k,j)
      endif
      g_t_tend(i,k,j) = g_mut(i,j)*(h_diabatic(i,k,j)/msft(i,j))+g_t_tend(i,k,j)+g_t_tendf(i,k,j)/msft(i,j)
      t_tend(i,k,j) = t_tend(i,k,j)+t_tendf(i,k,j)/msft(i,j)+mut(i,j)*h_diabatic(i,k,j)/msft(i,j)
    end do
  end do
end do

  call trace_exit("g_rk_addtend_dry")

end subroutine g_rk_addtend_dry


subroutine g_rk_scalar_tend( scs, sce, config_flags, rk_step, ru, g_ru, rv, g_rv, ww, g_ww, mut, g_mut, alt, g_alt, scalar_old, &
&g_scalar_old, scalar, g_scalar, scalar_tends, g_scalar_tends, advect_tend, g_advect_tend, base, moist_step, fnm, fnp, msfu, msfv, &
&msft, rdx, rdy, rdn, rdnw, kvdif, xkmhd, g_xkmhd, leapfrog, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, &
&jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real advect_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: base(kms:kme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: fnm(kms:kme)
real, intent(in) :: fnp(kms:kme)
real g_advect_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mut(ims:ime,jms:jme)
real, intent(in) :: g_ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rv(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: sce
integer, intent(in) :: scs
real, intent(inout) :: g_scalar(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: g_scalar_old(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(out) :: g_scalar_tends(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(in) :: g_ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_xkmhd(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
logical, intent(in) :: leapfrog
logical, intent(in) :: moist_step
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: rdx
real, intent(in) :: rdy
integer, intent(in) :: rk_step
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: scalar(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: scalar_old(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(out) :: scalar_tends(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(in) :: ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: xkmhd(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer im
real kvdq

  call trace_entry("g_rk_scalar_tend")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
kvdq = kvdif/prandtl
scalar_loop: do im = scs, sce
  call g_zero_tend( advect_tend(ims,kms,jms),g_advect_tend(ims,kms,jms),ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
  if ( .not. leapfrog) then
    call g_advect_scalar( scalar(ims,kms,jms,im),g_scalar(ims,kms,jms,im),scalar(ims,kms,jms,im),g_scalar(ims,kms,jms,im),&
&advect_tend(ims,kms,jms),g_advect_tend(ims,kms,jms),ru,g_ru,rv,g_rv,ww,g_ww,config_flags,msft,fnm,fnp,rdx,rdy,rdnw,ids,ide,&
&jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
  else
    call g_advect_scalar( scalar(ims,kms,jms,im),g_scalar(ims,kms,jms,im),scalar_old(ims,kms,jms,im),g_scalar_old(ims,kms,jms,im),&
&advect_tend(ims,kms,jms),g_advect_tend(ims,kms,jms),ru,g_ru,rv,g_rv,ww,g_ww,config_flags,msft,fnm,fnp,rdx,rdy,rdnw,ids,ide,&
&jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
  endif
  diff_opt2: if (config_flags%diff_opt .eq. 1) then
    rk_step_2: if (rk_step .eq. 1) then
      if ( .not. leapfrog) then
        call g_horizontal_diffusion( 'm',scalar(ims,kms,jms,im),g_scalar(ims,kms,jms,im),scalar_tends(ims,kms,jms,im),&
&g_scalar_tends(ims,kms,jms,im),mut,g_mut,config_flags,msfu,msfv,msft,xkmhd,g_xkmhd,rdx,rdy,ids,ide,jds,jde,kde,ims,ime,&
&jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
        pbl_tesu: if (config_flags%bl_pbl_physics .eq. 0) then
          if (moist_step .and. im .eq. p_qv) then
            call g_vertical_diffusion_mp( scalar(ims,kms,jms,im),g_scalar(ims,kms,jms,im),scalar_tends(ims,kms,jms,im),&
&g_scalar_tends(ims,kms,jms,im),base,alt,g_alt,mut,g_mut,rdn,rdnw,kvdq,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
          else
            call g_vertical_diffusion( 'm',scalar(ims,kms,jms,im),g_scalar(ims,kms,jms,im),scalar_tends(ims,kms,jms,im),&
&g_scalar_tends(ims,kms,jms,im),alt,g_alt,mut,g_mut,rdn,rdnw,kvdq,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
          endif
        endif pbl_tesu
      else
        call g_horizontal_diffusion( 'm',scalar_old(ims,kms,jms,im),g_scalar_old(ims,kms,jms,im),scalar_tends(ims,kms,jms,im),&
&g_scalar_tends(ims,kms,jms,im),mut,g_mut,config_flags,msfu,msfv,msft,xkmhd,g_xkmhd,rdx,rdy,ids,ide,jds,jde,kde,ims,ime,&
&jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
        pbl_test_lg: if (config_flags%bl_pbl_physics .eq. 0) then
          if (moist_step .and. im .eq. p_qv) then
            call g_vertical_diffusion_mp( scalar_old(ims,kms,jms,im),g_scalar_old(ims,kms,jms,im),scalar_tends(ims,kms,jms,im),&
&g_scalar_tends(ims,kms,jms,im),base,alt,g_alt,mut,g_mut,rdn,rdnw,kvdq,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
          else
            call g_vertical_diffusion( 'm',scalar_old(ims,kms,jms,im),g_scalar_old(ims,kms,jms,im),scalar_tends(ims,kms,jms,im),&
&g_scalar_tends(ims,kms,jms,im),alt,g_alt,mut,g_mut,rdn,rdnw,kvdq,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
          endif
        endif pbl_test_lg
      endif
    endif rk_step_2
  endif diff_opt2
end do scalar_loop

  call trace_exit("g_rk_scalar_tend")

end subroutine g_rk_scalar_tend


subroutine g_rk_step_prep( config_flags, u, g_u, v, g_v, w, g_w, ph, g_ph, mu, g_mu, moist, g_moist, ru, g_ru, rv, g_rv, rw, g_rw, &
&ww, g_ww, php, g_php, alt, g_alt, muu, g_muu, muv, g_muv, mub, mut, g_mut, phb, al, g_al, alb, cqu, g_cqu, cqv, g_cqv, cqw, g_cqw,&
& msfu, msfv, msft, dnw, rdx, rdy, n_moist, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: alt(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(out) :: cqu(ims:ime,kms:kme,jms:jme)
real, intent(out) :: cqv(ims:ime,kms:kme,jms:jme)
real, intent(out) :: cqw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dnw(kms:kme)
real, intent(in) :: g_al(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_cqu(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_cqv(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_cqw(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: n_moist
real, intent(in) :: g_moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(in) :: g_mu(ims:ime,jms:jme)
real, intent(out) :: g_mut(ims:ime,jms:jme)
real, intent(out) :: g_muu(ims:ime,jms:jme)
real, intent(out) :: g_muv(ims:ime,jms:jme)
real, intent(in) :: g_ph(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_php(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_ru(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_rv(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_rw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_w(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_ww(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: moist(ims:ime,kms:kme,jms:jme,n_moist)
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: mub(ims:ime,jms:jme)
real, intent(out) :: mut(ims:ime,jms:jme)
real, intent(out) :: muu(ims:ime,jms:jme)
real, intent(out) :: muv(ims:ime,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(out) :: php(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(out) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(out) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(out) :: rw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)
real, intent(out) :: ww(ims:ime,kms:kme,jms:jme)

  call trace_entry("g_rk_step_prep")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
call g_calculate_full( mut,g_mut,mub,mu,g_mu,ide,jde,2,ims,ime,jms,jme,1,1,its,ite,jts,jte,1,1 )
call g_calc_mu_uv( config_flags,mu,g_mu,mub,muu,g_muu,muv,g_muv,ids,ide,jds,jde,ims,ime,jms,jme,its,ite,jts,jte )
call g_couple_momentum( muu,g_muu,ru,g_ru,u,g_u,msfu,muv,g_muv,rv,g_rv,v,g_v,msfv,mut,g_mut,rw,g_rw,w,g_w,msft,ide,jde,kde,ims,ime,&
&jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_calc_ww_cp( u,g_u,v,g_v,mu,g_mu,mub,ww,g_ww,rdx,rdy,msft,msfu,msfv,dnw,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,&
&kts,kte )
call g_calc_cq( moist,g_moist,cqu,g_cqu,cqv,g_cqv,cqw,g_cqw,n_moist,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_calc_alt( alt,g_alt,al,g_al,alb,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_calc_php( php,g_php,ph,g_ph,phb,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )

  call trace_exit("g_rk_step_prep")

end subroutine g_rk_step_prep


subroutine g_rk_tendency( config_flags, rk_step, ru_tend, g_ru_tend, rv_tend, g_rv_tend, rw_tend, g_rw_tend, ph_tend, g_ph_tend, &
&t_tend, g_t_tend, ru_tendf, g_ru_tendf, rv_tendf, g_rv_tendf, rw_tendf, g_rw_tendf, t_tendf, g_t_tendf, mu_tend, g_mu_tend, &
&u_save, g_u_save, v_save, g_v_save, w_save, g_w_save, ph_save, g_ph_save, t_save, g_t_save, ru, g_ru, rv, g_rv, rw, g_rw, ww, &
&g_ww, u, g_u, v, g_v, w, g_w, t, g_t, ph, g_ph, u_old, g_u_old, v_old, g_v_old, w_old, g_w_old, t_old, g_t_old, ph_old, g_ph_old, &
&phb, t_init, mu, g_mu, mut, g_mut, muu, g_muu, muv, g_muv, mub, al, g_al, alt, g_alt, p, g_p, pb, php, g_php, cqu, g_cqu, cqv, &
&g_cqv, cqw, g_cqw, u_base, v_base, z_base, msfu, msfv, msft, f, e, sina, cosa, fnm, fnp, rdn, rdnw, dt, rdx, rdy, kvdif, xkmhd, &
&g_xkmhd, cf1, cf2, cf3, cfn, cfn1, non_hydrostatic, leapfrog, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, &
&jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real cf1
real cf2
real cf3
real cfn
real cfn1
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: cosa(ims:ime,jms:jme)
real, intent(in) :: cqu(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cqv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: cqw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dt
real, intent(in) :: e(ims:ime,jms:jme)
real, intent(in) :: f(ims:ime,jms:jme)
real, intent(in) :: fnm(kms:kme)
real, intent(in) :: fnp(kms:kme)
real, intent(in) :: g_al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_cqu(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_cqv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_cqw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mu(ims:ime,jms:jme)
real, intent(out) :: g_mu_tend(ims:ime,jms:jme)
real, intent(in) :: g_mut(ims:ime,jms:jme)
real, intent(in) :: g_muu(ims:ime,jms:jme)
real, intent(in) :: g_muv(ims:ime,jms:jme)
real, intent(in) :: g_p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ph_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_ph_save(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_php(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ru(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rv(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rw(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rw_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_t_save(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_t_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_t_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_u_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_v_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_w_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_w_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_xkmhd(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: kvdif
logical, intent(in) :: leapfrog
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(out) :: mu_tend(ims:ime,jms:jme)
real, intent(in) :: mub(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
logical, intent(in) :: non_hydrostatic
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: ph_save(ims:ime,kms:kme,jms:jme)
real, intent(out) :: ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: php(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: rdx
real, intent(in) :: rdy
integer, intent(in) :: rk_step
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(out) :: ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ru_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(out) :: rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rv_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rw(ims:ime,kms:kme,jms:jme)
real, intent(out) :: rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rw_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: sina(ims:ime,jms:jme)
real, intent(in) :: t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t_init(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: t_save(ims:ime,kms:kme,jms:jme)
real, intent(out) :: t_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: t_tendf(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u_base(kms:kme)
real, intent(in) :: u_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: u_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v_base(kms:kme)
real, intent(in) :: v_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: v_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w_old(ims:ime,kms:kme,jms:jme)
real, intent(out) :: w_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: xkmhd(ims:ime,kms:kme,jms:jme)
real, intent(in) :: z_base(kms:kme)

!==============================================
! declare local variables
!==============================================
real kvdq

  call trace_entry("g_rk_tendency")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
call g_zero_tend( ru_tend,g_ru_tend,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( rv_tend,g_rv_tend,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( rw_tend,g_rw_tend,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( t_tend,g_t_tend,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( ph_tend,g_ph_tend,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( u_save,g_u_save,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( v_save,g_v_save,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( w_save,g_w_save,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( ph_save,g_ph_save,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( t_save,g_t_save,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
call g_zero_tend( mu_tend,g_mu_tend,ims,ime,jms,jme,1,1,its,ite,jts,jte,1,1 )
if ( .not. leapfrog) then
  call g_advect_u( u,g_u,u,g_u,ru_tend,g_ru_tend,ru,g_ru,rv,g_rv,ww,g_ww,mut,g_mut,config_flags,msfu,fnm,fnp,rdx,rdy,rdnw,ids,ide,&
&jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
  call g_advect_v( v,g_v,v,g_v,rv_tend,g_rv_tend,ru,g_ru,rv,g_rv,ww,g_ww,mut,g_mut,config_flags,msfv,fnm,fnp,rdx,rdy,rdnw,ids,ide,&
&jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
  if (non_hydrostatic) then
    call g_advect_w( w,g_w,w,g_w,rw_tend,g_rw_tend,ru,g_ru,rv,g_rv,ww,g_ww,config_flags,msft,fnm,fnp,rdx,rdy,rdn,ids,ide,jds,jde,&
&kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
  endif
  call g_advect_scalar( t,g_t,t,g_t,t_tend,g_t_tend,ru,g_ru,rv,g_rv,ww,g_ww,config_flags,msft,fnm,fnp,rdx,rdy,rdnw,ids,ide,jds,jde,&
&kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
  call g_rhs_ph( ph_tend,g_ph_tend,u,g_u,v,g_v,ww,g_ww,ph,g_ph,ph,g_ph,phb,w,g_w,mut,g_mut,muu,g_muu,muv,g_muv,fnm,fnp,rdnw,cfn,&
&cfn1,rdx,rdy,msft,non_hydrostatic,config_flags,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
else
  call g_advect_u( u,g_u,u_old,g_u_old,ru_tend,g_ru_tend,ru,g_ru,rv,g_rv,ww,g_ww,mut,g_mut,config_flags,msfu,fnm,fnp,rdx,rdy,rdnw,&
&ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
  call g_advect_v( v,g_v,v_old,g_v_old,rv_tend,g_rv_tend,ru,g_ru,rv,g_rv,ww,g_ww,mut,g_mut,config_flags,msfv,fnm,fnp,rdx,rdy,rdnw,&
&ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
  if (non_hydrostatic) then
    call g_advect_w( w,g_w,w_old,g_w_old,rw_tend,g_rw_tend,ru,g_ru,rv,g_rv,ww,g_ww,config_flags,msft,fnm,fnp,rdx,rdy,rdn,ids,ide,&
&jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
  endif
  call g_advect_scalar( t,g_t,t_old,g_t_old,t_tend,g_t_tend,ru,g_ru,rv,g_rv,ww,g_ww,config_flags,msft,fnm,fnp,rdx,rdy,rdnw,ids,ide,&
&jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
  call g_rhs_ph( ph_tend,g_ph_tend,u,g_u,v,g_v,ww,g_ww,ph,g_ph,ph_old,g_ph_old,phb,w,g_w,mut,g_mut,muu,g_muu,muv,g_muv,fnm,fnp,&
&rdnw,cfn,cfn1,rdx,rdy,msft,non_hydrostatic,config_flags,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
endif
call g_horizontal_pressure_gradient( ru_tend,g_ru_tend,rv_tend,g_rv_tend,ph,g_ph,alt,g_alt,p,g_p,pb,al,g_al,php,g_php,cqu,g_cqu,&
&cqv,g_cqv,muu,g_muu,muv,g_muv,mu,g_mu,fnm,fnp,rdnw,cf1,cf2,cf3,rdx,rdy,config_flags,non_hydrostatic,ids,ide,jds,jde,kde,ims,ime,&
&jms,jme,kms,kme,its,ite,jts,jte,kte )
if (non_hydrostatic) then
  call g_pg_buoy_w( rw_tend,g_rw_tend,p,g_p,cqw,g_cqw,mu,g_mu,mub,rdnw,rdn,g,msft,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,&
&jte )
endif
if (config_flags%w_damping .eq. 1) then
  call g_w_damp( rw_tend,g_rw_tend,ww,g_ww,w,g_w,mut,g_mut,rdnw,dt,ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte )
endif
if (config_flags%pert_coriolis) then
  call g_perturbation_coriolis( ru,g_ru,rv,g_rv,rw,g_rw,ru_tend,g_ru_tend,rv_tend,g_rv_tend,rw_tend,g_rw_tend,config_flags,u_base,&
&v_base,z_base,muu,g_muu,muv,g_muv,phb,ph,g_ph,f,e,sina,cosa,fnm,fnp,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,&
&kts,kte )
else
  call g_coriolis( ru,g_ru,rv,g_rv,rw,g_rw,ru_tend,g_ru_tend,rv_tend,g_rv_tend,rw_tend,g_rw_tend,config_flags,f,e,sina,cosa,fnm,&
&fnp,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
endif
call g_curvature( ru,g_ru,rv,g_rv,rw,g_rw,u,g_u,v,g_v,ru_tend,g_ru_tend,rv_tend,g_rv_tend,rw_tend,g_rw_tend,config_flags,msfu,msfv,&
&fnm,fnp,rdx,rdy,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
forward_steq: if (rk_step .eq. 1) then
  diff_opt2: if (config_flags%diff_opt .eq. 1) then
    leapfrog_tesu: if ( .not. leapfrog) then
      call g_horizontal_diffusion( 'u',u,g_u,ru_tendf,g_ru_tendf,mut,g_mut,config_flags,msfu,msfv,msft,xkmhd,g_xkmhd,rdx,rdy,ids,&
&ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      call g_horizontal_diffusion( 'v',v,g_v,rv_tendf,g_rv_tendf,mut,g_mut,config_flags,msfu,msfv,msft,xkmhd,g_xkmhd,rdx,rdy,ids,&
&ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      call g_horizontal_diffusion( 'w',w,g_w,rw_tendf,g_rw_tendf,mut,g_mut,config_flags,msfu,msfv,msft,xkmhd,g_xkmhd,rdx,rdy,ids,&
&ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      call g_horizontal_diffusion_3dmp( t,g_t,t_tendf,g_t_tendf,mut,g_mut,config_flags,t_init,msfu,msfv,msft,xkmhd,g_xkmhd,rdx,rdy,&
&ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      pbl_tesu: if (config_flags%bl_pbl_physics .eq. 0) then
        call g_vertical_diffusion_u( u,g_u,ru_tendf,g_ru_tendf,config_flags,u_base,alt,g_alt,muu,g_muu,rdn,rdnw,kvdif,ids,ide,jde,&
&kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
        call g_vertical_diffusion_v( v,g_v,rv_tendf,g_rv_tendf,config_flags,v_base,alt,g_alt,muv,g_muv,rdn,rdnw,kvdif,ide,jds,jde,&
&kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
        if (non_hydrostatic) then
          call g_vertical_diffusion( 'w',w,g_w,rw_tendf,g_rw_tendf,alt,g_alt,mut,g_mut,rdn,rdnw,kvdif,ide,jde,kde,ims,ime,jms,jme,&
&kms,kme,its,ite,jts,jte,kts,kte )
        endif
        kvdq = 3.*kvdif
        call g_vertical_diffusion_3dmp( t,g_t,t_tendf,g_t_tendf,t_init,alt,g_alt,mut,g_mut,rdn,rdnw,kvdq,ide,jde,kde,ims,ime,jms,&
&jme,kms,kme,its,ite,jts,jte,kts,kte )
      endif pbl_tesu
    else leapfrog_tesu
      call g_horizontal_diffusion( 'u',u_old,g_u_old,ru_tendf,g_ru_tendf,mut,g_mut,config_flags,msfu,msfv,msft,xkmhd,g_xkmhd,rdx,&
&rdy,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      call g_horizontal_diffusion( 'v',v_old,g_v_old,rv_tendf,g_rv_tendf,mut,g_mut,config_flags,msfu,msfv,msft,xkmhd,g_xkmhd,rdx,&
&rdy,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      if (non_hydrostatic) then
        call g_horizontal_diffusion( 'w',w_old,g_w_old,rw_tendf,g_rw_tendf,mut,g_mut,config_flags,msfu,msfv,msft,xkmhd,g_xkmhd,rdx,&
&rdy,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      endif
      call g_horizontal_diffusion_3dmp( t_old,g_t_old,t_tendf,g_t_tendf,mut,g_mut,config_flags,t_init,msfu,msfv,msft,xkmhd,g_xkmhd,&
&rdx,rdy,ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      pbl_test_lg: if (config_flags%bl_pbl_physics .eq. 0) then
        call g_vertical_diffusion_u( u_old,g_u_old,ru_tendf,g_ru_tendf,config_flags,u_base,alt,g_alt,muu,g_muu,rdn,rdnw,kvdif,ids,&
&ide,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
        call g_vertical_diffusion_v( v_old,g_v_old,rv_tendf,g_rv_tendf,config_flags,v_base,alt,g_alt,muv,g_muv,rdn,rdnw,kvdif,ide,&
&jds,jde,kde,ims,ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
        if (non_hydrostatic) then
          call g_vertical_diffusion( 'w',w_old,g_w_old,rw_tendf,g_rw_tendf,alt,g_alt,mut,g_mut,rdn,rdnw,kvdif,ide,jde,kde,ims,ime,&
&jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
        endif
        kvdq = 3.*kvdif
        call g_vertical_diffusion_3dmp( t_old,g_t_old,t_tendf,g_t_tendf,t_init,alt,g_alt,mut,g_mut,rdn,rdnw,kvdq,ide,jde,kde,ims,&
&ime,jms,jme,kms,kme,its,ite,jts,jte,kts,kte )
      endif pbl_test_lg
    endif leapfrog_tesu
  endif diff_opt2
endif forward_steq

  call trace_exit("g_rk_tendency")

end subroutine g_rk_tendency


subroutine g_rk_update_scalar( scs, sce, scalar_1, g_scalar_1, scalar_2, g_scalar_2, sc_tend, g_sc_tend, advect_tend, &
&g_advect_tend, msft, mu_old, g_mu_old, mu_new, g_mu_new, mu_base, rk_step, dt, spec_zone, epsts, leapfrog, config_flags, ids, ide,&
& jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: advect_tend(ims:ime,kms:kme,jms:jme)
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: dt
real, intent(in) :: epsts
real, intent(in) :: g_advect_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mu_new(ims:ime,jms:jme)
real, intent(in) :: g_mu_old(ims:ime,jms:jme)
integer, intent(in) :: sce
integer, intent(in) :: scs
real, intent(inout) :: g_sc_tend(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: g_scalar_1(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: g_scalar_2(ims:ime,kms:kme,jms:jme,scs:sce)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
logical, intent(in) :: leapfrog
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: mu_base(ims:ime,jms:jme)
real, intent(in) :: mu_new(ims:ime,jms:jme)
real, intent(in) :: mu_old(ims:ime,jms:jme)
integer, intent(in) :: rk_step
real, intent(inout) :: sc_tend(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: scalar_1(ims:ime,kms:kme,jms:jme,scs:sce)
real, intent(inout) :: scalar_2(ims:ime,kms:kme,jms:jme,scs:sce)
integer, intent(in) :: spec_zone

!==============================================
! declare local variables
!==============================================
real g_muold(its:ite)
real g_r_munew(its:ite)
real g_sc_middle
real g_tendency(its:ite,kts:kte,jts:jte)
integer i
integer i_end
integer i_end_spc
integer i_start
integer i_start_spc
integer im
integer j
integer j_end
integer j_end_spc
integer j_start
integer j_start_spc
integer k
integer k_end
integer k_end_spc
integer k_start
integer k_start_spc
real muold(its:ite)
real r_munew(its:ite)
real sc_middle
real tendency(its:ite,kts:kte,jts:jte)

  call trace_entry("g_rk_update_scalar")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
i_start = its
i_end = ite
j_start = jts
j_end = jte
k_start = kts
k_end = kte-1
if (j_end .eq. jde) then
  j_end = j_end-1
endif
if (i_end .eq. ide) then
  i_end = i_end-1
endif
i_start_spc = i_start
i_end_spc = i_end
j_start_spc = j_start
j_end_spc = j_end
k_start_spc = k_start
k_end_spc = k_end
if (config_flags%nested .or. config_flags%specified) then
  i_start = max(its,ids+spec_zone)
  i_end = min(ite,ide-spec_zone-1)
  j_start = max(jts,jds+spec_zone)
  j_end = min(jte,jde-spec_zone-1)
  k_start = kts
  k_end = min(kte,kde-1)
endif
if ( .not. leapfrog) then
  if (rk_step .eq. 1) then
    do im = scs, sce
      do j = jts, min(jte,jde-1)
        do k = kts, min(kte,kde-1)
          do i = its, min(ite,ide-1)
            g_tendency(i,k,j) = 0.
            tendency(i,k,j) = 0.
          end do
        end do
      end do
      do j = j_start, j_end
        do k = k_start, k_end
          do i = i_start, i_end
            g_tendency(i,k,j) = g_advect_tend(i,k,j)*msft(i,j)
            tendency(i,k,j) = advect_tend(i,k,j)*msft(i,j)
          end do
        end do
      end do
      do j = j_start_spc, j_end_spc
        do k = k_start_spc, k_end_spc
          do i = i_start_spc, i_end_spc
            g_tendency(i,k,j) = g_sc_tend(i,k,j,im)+g_tendency(i,k,j)
            tendency(i,k,j) = tendency(i,k,j)+sc_tend(i,k,j,im)
          end do
        end do
      end do
      do j = jts, min(jte,jde-1)
        do i = its, min(ite,ide-1)
          g_muold(i) = g_mu_old(i,j)
          muold(i) = mu_old(i,j)+mu_base(i,j)
          g_r_munew(i) = -(g_mu_new(i,j)/((mu_new(i,j)+mu_base(i,j))*(mu_new(i,j)+mu_base(i,j))))
          r_munew(i) = 1./(mu_new(i,j)+mu_base(i,j))
        end do
        do k = kts, min(kte,kde-1)
          do i = its, min(ite,ide-1)
            g_scalar_1(i,k,j,im) = g_scalar_2(i,k,j,im)
            scalar_1(i,k,j,im) = scalar_2(i,k,j,im)
            g_scalar_2(i,k,j,im) = g_muold(i)*scalar_1(i,k,j,im)*r_munew(i)+g_r_munew(i)*(muold(i)*scalar_1(i,k,j,im)+dt*&
&tendency(i,k,j))+g_scalar_1(i,k,j,im)*muold(i)*r_munew(i)+g_tendency(i,k,j)*dt*r_munew(i)
            scalar_2(i,k,j,im) = (muold(i)*scalar_1(i,k,j,im)+dt*tendency(i,k,j))*r_munew(i)
          end do
        end do
      end do
    end do
  else
    do im = scs, sce
      do j = jts, min(jte,jde-1)
        do k = kts, min(kte,kde-1)
          do i = its, min(ite,ide-1)
            g_tendency(i,k,j) = 0.
            tendency(i,k,j) = 0.
          end do
        end do
      end do
      do j = j_start, j_end
        do k = k_start, k_end
          do i = i_start, i_end
            g_tendency(i,k,j) = g_advect_tend(i,k,j)*msft(i,j)
            tendency(i,k,j) = advect_tend(i,k,j)*msft(i,j)
          end do
        end do
      end do
      do j = j_start_spc, j_end_spc
        do k = k_start_spc, k_end_spc
          do i = i_start_spc, i_end_spc
            g_tendency(i,k,j) = g_sc_tend(i,k,j,im)+g_tendency(i,k,j)
            tendency(i,k,j) = tendency(i,k,j)+sc_tend(i,k,j,im)
          end do
        end do
      end do
      do j = jts, min(jte,jde-1)
        do i = its, min(ite,ide-1)
          g_muold(i) = g_mu_old(i,j)
          muold(i) = mu_old(i,j)+mu_base(i,j)
          g_r_munew(i) = -(g_mu_new(i,j)/((mu_new(i,j)+mu_base(i,j))*(mu_new(i,j)+mu_base(i,j))))
          r_munew(i) = 1./(mu_new(i,j)+mu_base(i,j))
        end do
        do k = kts, min(kte,kde-1)
          do i = its, min(ite,ide-1)
            g_scalar_2(i,k,j,im) = g_muold(i)*scalar_1(i,k,j,im)*r_munew(i)+g_r_munew(i)*(muold(i)*scalar_1(i,k,j,im)+dt*&
&tendency(i,k,j))+g_scalar_1(i,k,j,im)*muold(i)*r_munew(i)+g_tendency(i,k,j)*dt*r_munew(i)
            scalar_2(i,k,j,im) = (muold(i)*scalar_1(i,k,j,im)+dt*tendency(i,k,j))*r_munew(i)
          end do
        end do
      end do
    end do
  endif
else
  do im = scs, sce
    do j = jts, min(jte,jde-1)
      do k = kts, min(kte,kde-1)
        do i = its, min(ite,ide-1)
          g_tendency(i,k,j) = 0.
          tendency(i,k,j) = 0.
        end do
      end do
    end do
    do j = j_start, j_end
      do k = k_start, k_end
        do i = i_start, i_end
          g_tendency(i,k,j) = g_advect_tend(i,k,j)
          tendency(i,k,j) = advect_tend(i,k,j)
        end do
      end do
    end do
    do j = j_start_spc, j_end_spc
      do k = k_start_spc, k_end_spc
        do i = i_start_spc, i_end_spc
          g_tendency(i,k,j) = g_sc_tend(i,k,j,im)+g_tendency(i,k,j)
          tendency(i,k,j) = tendency(i,k,j)+sc_tend(i,k,j,im)
        end do
      end do
    end do
    do j = jts, min(jte,jde-1)
      do i = its, min(ite,ide-1)
        g_muold(i) = g_mu_old(i,j)
        muold(i) = mu_old(i,j)+mu_base(i,j)
        g_r_munew(i) = -(g_mu_new(i,j)/((mu_new(i,j)+mu_base(i,j))*(mu_new(i,j)+mu_base(i,j))))
        r_munew(i) = 1./(mu_new(i,j)+mu_base(i,j))
      end do
      do k = kts, min(kte,kde-1)
        do i = its, min(ite,ide-1)
          g_sc_middle = g_scalar_2(i,k,j,im)
          sc_middle = scalar_2(i,k,j,im)
          g_scalar_2(i,k,j,im) = g_muold(i)*scalar_1(i,k,j,im)*r_munew(i)+g_r_munew(i)*(muold(i)*scalar_1(i,k,j,im)+2*msft(i,j)**2*&
&dt*tendency(i,k,j))+g_scalar_1(i,k,j,im)*muold(i)*r_munew(i)+2*g_tendency(i,k,j)*msft(i,j)**2*dt*r_munew(i)
          scalar_2(i,k,j,im) = (muold(i)*scalar_1(i,k,j,im)+msft(i,j)**2*2*dt*tendency(i,k,j))*r_munew(i)
          g_scalar_1(i,k,j,im) = g_sc_middle*(1+(-2)*epsts)+(g_scalar_1(i,k,j,im)+g_scalar_2(i,k,j,im))*epsts
          scalar_1(i,k,j,im) = sc_middle+epsts*(scalar_1(i,k,j,im)-2*sc_middle+scalar_2(i,k,j,im))
        end do
      end do
    end do
  end do
endif

  call trace_exit("g_rk_update_scalar")

end subroutine g_rk_update_scalar

end module g_module_em

