!                           DISCLAIMER
!
!   This file was generated by TAF version 1.7.18
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     g_module_small_step_em
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use module_configure
use module_model_constants
use module_small_step_em

USE module_trace, only : trace_entry, trace_exit

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains

subroutine g_advance_mu_t( ww, g_ww, ww_1, g_ww_1, u, g_u, u_1, g_u_1, v, g_v, v_1, g_v_1, mu, g_mu, mut, g_mut, muave, g_muave, &
&muts, g_muts, muu, g_muu, muv, g_muv, mudf, g_mudf, t, g_t, t_1, g_t_1, t_ave, g_t_ave, ft, g_ft, mu_tend, g_mu_tend, rdx, rdy, &
&dts, epssm, dnw, fnm, fnp, rdnw, msfu, msfv, msft, config_flags, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, &
&jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
type (grid_config_rec_type), intent(in) :: config_flags
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: dnw(kms:kme)
real, intent(in) :: dts
real, intent(in) :: epssm
real, intent(in) :: fnm(kms:kme)
real, intent(in) :: fnp(kms:kme)
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: ft(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ft(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_mu(ims:ime,jms:jme)
real, intent(in) :: g_mu_tend(ims:ime,jms:jme)
real, intent(inout) :: g_muave(ims:ime,jms:jme)
real, intent(inout) :: g_mudf(ims:ime,jms:jme)
real, intent(in) :: g_mut(ims:ime,jms:jme)
real, intent(inout) :: g_muts(ims:ime,jms:jme)
real, intent(in) :: g_muu(ims:ime,jms:jme)
real, intent(in) :: g_muv(ims:ime,jms:jme)
real, intent(inout) :: g_t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_t_ave(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u_1(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ww(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ww_1(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(inout) :: mu(ims:ime,jms:jme)
real, intent(in) :: mu_tend(ims:ime,jms:jme)
real, intent(out) :: muave(ims:ime,jms:jme)
real, intent(out) :: mudf(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(out) :: muts(ims:ime,jms:jme)
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(inout) :: t(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: t_ave(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u_1(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ww(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ww_1(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real dmdt(its:ite)
real dvdxi(its:ite,kts:kte)
real g_dmdt(its:ite)
real g_dvdxi(its:ite,kts:kte)
real g_wdtn(its:ite,kts:kte)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer k_end
integer k_start
real wdtn(its:ite,kts:kte)
real walls(6)

   call trace_entry("g_advance_mu_t")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
i_start = its
i_end = ite
j_start = jts
j_end = jte
k_start = kts
k_end = kte-1
if (j_end .eq. jde) then
  j_end = j_end-1
endif
if (i_end .eq. ide) then
  i_end = i_end-1
endif
if ((config_flags%specified .or. config_flags%nested) .and. its .eq. ids) then
  i_start = i_start+1
endif
if ((config_flags%specified .or. config_flags%nested) .and. ite .eq. ide) then
  i_end = i_end-1
endif
if ((config_flags%specified .or. config_flags%nested) .and. jts .eq. jds) then
  j_start = j_start+1
endif
if ((config_flags%specified .or. config_flags%nested) .and. jte .eq. jde) then
  j_end = j_end-1
endif
do j = j_start, j_end
  do i = i_start, i_end
    g_dmdt(i) = 0.
    dmdt(i) = 0.
  end do
  do k = k_start, k_end
    do i = i_start, i_end
      walls(1)=msft(i,j)*msft(i,j)

      g_dvdxi(i,k) = walls(1)*((g_muu(i+1,j)*u_1(i+1,k,j)+g_u_1(i+1,k,j)*muu(i+1,j))*rdx/msfu(i+1,j)&
&+(g_muv(i,j+1)*v_1(i,k,j+1)+g_v_1(i,k,j+1)*muv(i,j+1))*rdy/msfv(i,j+1)&
&-(g_muv(i,j)*v_1(i,k,j)+g_v_1(i,k,j)*muv(i,j))*rdy/msfv(i,j)&
&+(g_u(i+1,k,j)-g_u(i,k,j))*rdx&
&-(g_u_1(i,k,j)*muu(i,j)+g_muu(i,j)*u_1(i,k,j))*rdx/msfu(i,j)&
&+(g_v(i,k,j+1)-g_v(i,k,j))*rdy)

      dvdxi(i,k) = walls(1)*(&
& rdy*(v(i,k,j+1) +muv(i,j+1)*v_1(i,k,j+1)/msfv(i,j+1)  -(v(i,k,j)+muv(i,j)*v_1(i,k,j)/msfv(i,j)) ) &
&+rdx*(u(i+1,k,j) +muu(i+1,j)*u_1(i+1,k,j)/msfu(i+1,j)  -(u(i,k,j)+muu(i,j)*u_1(i,k,j)/msfu(i,j)))&
&)
    end do
    g_dmdt(i_start:i_end) = g_dmdt(i_start:i_end)+g_dvdxi(i_start:i_end,k)*dnw(k)
    dmdt(i_start:i_end) = dmdt(i_start:i_end)+dnw(k)*dvdxi(i_start:i_end,k)
  end do

  do i = i_start, i_end
    walls(1) = g_mu(i,j)
    walls(2) = mu(i,j)
    g_mu(i,j) = g_dmdt(i)*dts+g_mu(i,j)+g_mu_tend(i,j)*dts
    mu(i,j) = mu(i,j)+dts*(dmdt(i)+mu_tend(i,j))
    g_mudf(i,j) = g_dmdt(i)+g_mu_tend(i,j)
    mudf(i,j) = dmdt(i)+mu_tend(i,j)
    g_muts(i,j) = g_mu(i,j)+g_mut(i,j)
    muts(i,j) = mut(i,j)+mu(i,j)
    g_muave(i,j) = 0.5*g_mu(i,j)*(1+epssm)+0.5*walls(1)*(1.-epssm)
    muave(i,j) = 0.5*((1.+epssm)*mu(i,j)+(1.-epssm)*walls(2))
  end do

  do k = 2, k_end
    walls(1)=dnw(k-1)
    do i = i_start, i_end
      walls(2)=walls(1)/msft(i,j)
      g_ww(i,k,j) = -(g_dmdt(i)+g_dvdxi(i,k-1)+g_mu_tend(i,j))*walls(2)+g_ww(i,k-1,j)
      ww(i,k,j) = ww(i,k-1,j)-walls(2)*(dmdt(i)+dvdxi(i,k-1)+mu_tend(i,j))
    end do
  end do
  do k = 1, k_end
    do i = i_start, i_end
      g_ww(i,k,j) = g_ww(i,k,j)-g_ww_1(i,k,j)
      ww(i,k,j) = ww(i,k,j)-ww_1(i,k,j)
    end do
  end do
end do
do j = j_start, j_end
  do k = 1, k_end
    do i = i_start, i_end
      g_t_ave(i,k,j) = g_t(i,k,j)
      t_ave(i,k,j) = t(i,k,j)
      g_t(i,k,j) = g_ft(i,k,j)*msft(i,j)*dts+g_t(i,k,j)
      t(i,k,j) = t(i,k,j)+msft(i,j)*dts*ft(i,k,j)
    end do
  end do
end do
do j = j_start, j_end
  do i = i_start, i_end
    g_wdtn(i,1) = 0.
    wdtn(i,1) = 0.
    g_wdtn(i,kde) = 0.
    wdtn(i,kde) = 0.
  end do

  do k = 2, k_end
    walls(1)=fnp(k)
    walls(2)=fnm(k)
    do i = i_start, i_end
      walls(3)=walls(2)*t_1(i,k,j)+walls(1)*t_1(i,k-1,j)
      g_wdtn(i,k) = (g_t_1(i,k-1,j)*walls(1)+g_t_1(i,k,j)*walls(2))*ww(i,k,j)+g_ww(i,k,j)*walls(3)
      wdtn(i,k) = ww(i,k,j)*walls(3)
    end do
  end do

  do k = 1, k_end
    walls(2)=rdnw(k)
    do i = i_start, i_end
      walls(1)=msft(i,j)
      walls(3)=t_1(i+1,k,j)+t_1(i,k,j)
      walls(4)=t_1(i,k,j)+t_1(i-1,k,j)
      walls(5)=t_1(i,k,j+1)+t_1(i,k,j)
      walls(6)=t_1(i,k,j)+t_1(i,k,j-1)
      g_t(i,k,j) = g_t(i,k,j)&
&+0.5*dts*walls(1)*walls(1)*(g_t_1(i,k,j-1)*rdy*v(i,k,j)&
&-g_t_1(i,k,j+1)*rdy*v(i,k,j+1)&
&+g_t_1(i-1,k,j)*rdx*u(i,k,j)&
&-g_t_1(i+1,k,j)*rdx*u(i+1,k,j)&
&-g_t_1(i,k,j)*(rdy*(v(i,k,j+1)-v(i,k,j))+rdx*(u(i+1,k,j)-u(i,k,j)))&
&-g_u(i+1,k,j)*rdx*walls(3)&
&+g_u(i,k,j)*rdx*walls(4)-&
& g_v(i,k,j+1)*rdy*walls(5)&
&+g_v(i,k,j)*rdy*walls(6))&
&-(g_wdtn(i,k+1)-g_wdtn(i,k))*dts*walls(1)*walls(2)

      t(i,k,j) = t(i,k,j)-dts*walls(1)*(walls(1)*(0.5*rdy*(v(i,k,j+1)*walls(5)-v(i,k,j)*walls(6))&
&+0.5*rdx*(u(i+1,k,j)*walls(3)-u(i,k,j)*walls(4)))+walls(2)*(wdtn(i,k+1)-wdtn(i,k)))
    end do
  end do
end do

   call trace_exit("g_advance_mu_t")

end subroutine g_advance_mu_t


subroutine g_advance_uv( u, g_u, ru_tend, g_ru_tend, v, g_v, rv_tend, g_rv_tend, p, g_p, pb, ph, g_ph, php, g_php, alt, g_alt, al, &
&g_al, mu, g_mu, muu, g_muu, cqu, g_cqu, muv, g_muv, cqv, g_cqv, mudf, g_mudf, rdx, rdy, dts, cf1, cf2, cf3, fnm, fnp, emdiv, rdnw,&
& config_flags, spec_zone, non_hydrostatic, ids, ide, jds, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cf1
real, intent(in) :: cf2
real, intent(in) :: cf3
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: cqu(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cqv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dts
real, intent(in) :: emdiv
real, intent(in) :: fnm(kms:kme)
real, intent(in) :: fnp(kms:kme)
real, intent(in) :: g_al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_cqu(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_cqv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mu(ims:ime,jms:jme)
real, intent(in) :: g_mudf(ims:ime,jms:jme)
real, intent(in) :: g_muu(ims:ime,jms:jme)
real, intent(in) :: g_muv(ims:ime,jms:jme)
real, intent(in) :: g_p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_php(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rv_tend(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_u(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_v(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: mudf(ims:ime,jms:jme)
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
logical, intent(in) :: non_hydrostatic
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: php(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: ru_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv_tend(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: spec_zone
real, intent(inout) :: u(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: v(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real dpn(its:ite,kts:kte)
real dpxy(its:ite,kts:kte)
real dx
real dy
real g_dpn(its:ite,kts:kte)
real g_dpxy(its:ite,kts:kte)
real g_mudf_xy(its:ite)
integer i
integer i_end
integer i_end_up
integer i_endu
integer i_start
integer i_start_up
integer j
integer j_end
integer j_end_vp
integer j_endv
integer j_start
integer j_start_vp
integer k
integer k_end
integer k_start
real mudf_xy(its:ite)
real walls(4),gwalls(ims:ime),kwalls(ims:ime)

   call trace_entry("g_advance_uv")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (config_flags%nested .or. config_flags%specified) then
  i_start = max(its,ids+spec_zone)
  i_end = min(ite,ide-spec_zone-1)
  j_start = max(jts,jds+spec_zone)
  j_end = min(jte,jde-spec_zone-1)
  k_start = kts
  k_end = min(kte,kde-1)
  i_endu = min(ite,ide-spec_zone)
  j_endv = min(jte,jde-spec_zone)
else
  i_start = its
  i_end = ite
  j_start = jts
  j_end = jte
  k_start = kts
  k_end = kte-1
  i_endu = i_end
  j_endv = j_end
  if (j_end .eq. jde) then
    j_end = j_end-1
  endif
  if (i_end .eq. ide) then
    i_end = i_end-1
  endif
endif
i_start_up = i_start
i_end_up = i_endu
j_start_vp = j_start
j_end_vp = j_endv
if ((config_flags%open_xs .or. config_flags%symmetric_xs) .and. its .eq. ids) then
  i_start_up = i_start_up+1
endif
if ((config_flags%open_xe .or. config_flags%symmetric_xe) .and. ite .eq. ide) then
  i_end_up = i_end_up-1
endif
if ((config_flags%open_ys .or. config_flags%symmetric_ys) .and. jts .eq. jds) then
  j_start_vp = j_start_vp+1
endif
if ((config_flags%open_ye .or. config_flags%symmetric_ye) .and. jte .eq. jde) then
  j_end_vp = j_end_vp-1
endif
dx = 1./rdx
dy = 1./rdy
u_outer_j_loop: do j = j_start, j_end
  do k = k_start, k_end
    do i = i_start, i_endu
      g_u(i,k,j) = g_ru_tend(i,k,j)*dts+g_u(i,k,j)
      u(i,k,j) = u(i,k,j)+dts*ru_tend(i,k,j)
    end do
  end do
  do i = i_start_up, i_end_up
    g_mudf_xy(i) = g_mudf(i-1,j)*emdiv*dx-g_mudf(i,j)*emdiv*dx
    mudf_xy(i) = -(emdiv*dx*(mudf(i,j)-mudf(i-1,j)))
  end do
  do k = k_start, k_end
    gwalls(i_start_up:i_end_up)=ph(i_start_up:i_end_up,k+1,j)-ph(i_start_up-1:i_end_up-1,k+1,j)&
&+ph(i_start_up:i_end_up,k,j)-ph(i_start_up-1:i_end_up-1,k,j)
    kwalls(i_start_up:i_end_up)=-g_ph(i_start_up-1:i_end_up-1,k+1,j)+g_ph(i_start_up:i_end_up,k+1,j)&
&-g_ph(i_start_up-1:i_end_up-1,k,j)+g_ph(i_start_up:i_end_up,k,j)

    do i = i_start_up, i_end_up
      walls(1)=alt(i,k,j)+alt(i-1,k,j)
      walls(2)=p(i,k,j)-p(i-1,k,j)
      walls(3)=pb(i,k,j)-pb(i-1,k,j)
      walls(4) = gwalls(i)+walls(1)*walls(2)+(al(i,k,j)+al(i-1,k,j))*walls(3)
      g_dpxy(i,k) = 0.5*rdx*muu(i,j)*(g_al(i-1,k,j)*walls(3)&
&+g_al(i,k,j)*walls(3)&
&+g_alt(i-1,k,j)*walls(2)&
&+g_alt(i,k,j)*walls(2)&
&+g_muu(i,j)/muu(i,j)*walls(4)&
&-g_p(i-1,k,j)*walls(1)&
&+g_p(i,k,j)*walls(1)+kwalls(i))
      dpxy(i,k) = 0.5*rdx*muu(i,j)*walls(4)
    end do
  end do
  if (non_hydrostatic) then
    g_dpn(i_start_up:i_end_up,1) = 0.5*(g_p(i_start_up-1:i_end_up-1,3,j)*cf3&
&+g_p(i_start_up:i_end_up,3,j)*cf3+g_p(i_start_up-1:i_end_up-1,2,j)*cf2&
&+g_p(i_start_up:i_end_up,2,j)*cf2+g_p(i_start_up-1:i_end_up-1,1,j)*cf1+g_p(i_start_up:i_end_up,1,j)*cf1)
    dpn(i_start_up:i_end_up,1) = 0.5*(cf1*(p(i_start_up:i_end_up,1,j)+p(i_start_up-1:i_end_up-1,1,j))&
&+cf2*(p(i_start_up:i_end_up,2,j)+p(i_start_up-1:i_end_up-1,2,j))&
&+cf3*(p(i_start_up:i_end_up,3,j)+p(i_start_up-1:i_end_up-1,3,j)))
    do i = i_start_up, i_end_up
      g_dpn(i,kde) = 0.
      dpn(i,kde) = 0.
    end do
    do k = k_start+1, k_end
      walls(1)=fnp(k)
      walls(2)=fnm(k)
      do i = i_start_up, i_end_up
        g_dpn(i,k) = 0.5*((g_p(i-1,k-1,j)+g_p(i,k-1,j))*walls(1)+(g_p(i-1,k,j)+g_p(i,k,j))*walls(2))
        dpn(i,k) = 0.5*(walls(2)*(p(i,k,j)+p(i-1,k,j))+walls(1)*(p(i,k-1,j)+p(i-1,k-1,j)))
      end do
    end do
    do k = k_start, k_end
      walls(1)=rdnw(k)
      do i = i_start_up, i_end_up
        walls(3)=rdx*(php(i,k,j)-php(i-1,k,j))
        walls(4)=walls(1)*(dpn(i,k+1)-dpn(i,k))-0.5*(mu(i-1,j)+mu(i,j))

        g_dpxy(i,k) = (g_dpn(i,k+1)-g_dpn(i,k))*walls(3)*walls(1)+g_dpxy(i,k)&
&-0.5*walls(3)*(g_mu(i-1,j)+g_mu(i,j))-(g_php(i-1,k,j)-g_php(i,k,j))*rdx*walls(4)
        dpxy(i,k) = dpxy(i,k)+walls(3)*walls(4)
      end do
    end do
  endif
  do k = k_start, k_end
    do i = i_start_up, i_end_up
      g_u(i,k,j) = (-(g_cqu(i,k,j)*dts*dpxy(i,k)))-g_dpxy(i,k)*dts*cqu(i,k,j)+g_mudf_xy(i)+g_u(i,k,j)
      u(i,k,j) = u(i,k,j)-dts*cqu(i,k,j)*dpxy(i,k)+mudf_xy(i)
    end do
  end do
end do u_outer_j_loop
v_outer_j_loop: do j = j_start, j_endv
  do k = k_start, k_end
    do i = i_start, i_end
      g_v(i,k,j) = g_rv_tend(i,k,j)*dts+g_v(i,k,j)
      v(i,k,j) = v(i,k,j)+dts*rv_tend(i,k,j)
    end do
  end do
  do i = i_start, i_end
    g_mudf_xy(i) = g_mudf(i,j-1)*emdiv*dy-g_mudf(i,j)*emdiv*dy
    mudf_xy(i) = -(emdiv*dy*(mudf(i,j)-mudf(i,j-1)))
  end do
  if (j .ge. j_start_vp .and. j .le. j_end_vp) then
    do k = k_start, k_end
      gwalls(i_start:i_end)=ph(i_start:i_end,k+1,j)-ph(i_start:i_end,k+1,j-1)+ph(i_start:i_end,k,j)-ph(i_start:i_end,k,j-1)
      kwalls(i_start:i_end)=-g_ph(i_start:i_end,k+1,j-1)+g_ph(i_start:i_end,k+1,j)&
&-g_ph(i_start:i_end,k,j-1)+g_ph(i_start:i_end,k,j)
      do i = i_start, i_end
        walls(1)=pb(i,k,j)-pb(i,k,j-1)
        walls(2)=p(i,k,j)-p(i,k,j-1)
        walls(3)=alt(i,k,j)+alt(i,k,j-1)
        walls(4)=(gwalls(i)+walls(3)*walls(2)+(al(i,k,j)+al(i,k,j-1))*walls(1))
        g_dpxy(i,k) = 0.5*rdy*muv(i,j)*((g_al(i,k,j-1)+g_al(i,k,j))*walls(1)+&
&(g_alt(i,k,j-1)+g_alt(i,k,j))*walls(2)&
&+g_muv(i,j)/muv(i,j)*walls(4)&
&-g_p(i,k,j-1)*walls(3)+g_p(i,k,j)*walls(3)+kwalls(i))
        dpxy(i,k) = 0.5*rdy*muv(i,j)*walls(4)
      end do
    end do
    if (non_hydrostatic) then
      do i = i_start, i_end
        g_dpn(i,1) = 0.5*(g_p(i,3,j-1)*cf3+g_p(i,3,j)*cf3+g_p(i,2,j-1)*cf2+g_p(i,2,j)*cf2+g_p(i,1,j-1)*cf1+g_p(i,1,j)*cf1)
      end do
      do i = i_start, i_end
        dpn(i,1) = 0.5*(cf1*(p(i,1,j)+p(i,1,j-1))+cf2*(p(i,2,j)+p(i,2,j-1))+cf3*(p(i,3,j)+p(i,3,j-1)))
      end do
      g_dpn(i_start:i_end,kde) = 0.
      dpn(i_start:i_end,kde) = 0.
      do k = k_start+1, k_end
        walls(1)=fnp(k)
        walls(2)=fnm(k)
        do i = i_start, i_end
          g_dpn(i,k) = 0.5*(g_p(i,k-1,j-1)*walls(1)+g_p(i,k-1,j)*walls(1)+g_p(i,k,j-1)*walls(2)+g_p(i,k,j)*walls(2))
        end do
        do i = i_start, i_end
          dpn(i,k) = 0.5*(walls(2)*(p(i,k,j)+p(i,k,j-1))+walls(1)*(p(i,k-1,j)+p(i,k-1,j-1)))
        end do
      end do

      do k = k_start, k_end
        walls(1)=rdnw(k)
        gwalls(i_start:i_end)=walls(1)*(dpn(i_start:i_end,k+1)-dpn(i_start:i_end,k))-0.5*(mu(i_start:i_end,j-1)+mu(i_start:i_end,j))
        kwalls(i_start:i_end)=rdy*php(i_start:i_end,k,j)-rdy*php(i_start:i_end,k,j-1)
        do i = i_start, i_end
          g_dpxy(i,k) = (g_dpn(i,k+1)-g_dpn(i,k))*kwalls(i)*walls(1)+&
&g_dpxy(i,k)-0.5*kwalls(i)*(g_mu(i,j-1)+g_mu(i,j))&
&-(g_php(i,k,j-1)-g_php(i,k,j))*rdy*gwalls(i)
          dpxy(i,k) = dpxy(i,k)+kwalls(i)*gwalls(i)
        end do
      end do
    endif

    do k = k_start, k_end
      do i = i_start, i_end
        g_v(i,k,j) = -g_cqv(i,k,j)*dts*dpxy(i,k)-g_dpxy(i,k)*dts*cqv(i,k,j)+g_mudf_xy(i)+g_v(i,k,j)
        v(i,k,j) = v(i,k,j)-dts*cqv(i,k,j)*dpxy(i,k)+mudf_xy(i)
      end do
    end do
  endif
end do v_outer_j_loop

   call trace_exit("g_advance_uv")

end subroutine g_advance_uv


subroutine g_advance_w( w, g_w, rw_tend, g_rw_tend, ww, g_ww, u, g_u, v, g_v, mu1, g_mu1, mut, g_mut, muave, g_muave, muts, g_muts,&
& t_2ave, g_t_2ave, t_2, g_t_2, t_1, g_t_1, ph, g_ph, ph_1, g_ph_1, phb, ph_tend, g_ph_tend, ht, c2a, g_c2a, cqw, g_cqw, alt, &
&g_alt, alb, a, g_a, alpha, g_alpha, gamma, g_gamma, rdx, rdy, dts, t0, epssm, fnm, fnp, rdnw, rdn, cf1, cf2, cf3, msft, &
&config_flags, ids, ide, jds, jde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: a(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alpha(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: c2a(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cf1
real, intent(in) :: cf2
real, intent(in) :: cf3
type (grid_config_rec_type), intent(in) :: config_flags
real, intent(in) :: cqw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dts
real, intent(in) :: epssm
real, intent(in) :: fnm(kms:kme)
real, intent(in) :: fnp(kms:kme)
real, intent(in) :: g_a(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alpha(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_c2a(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_cqw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_gamma(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mu1(ims:ime,jms:jme)
real, intent(in) :: g_muave(ims:ime,jms:jme)
real, intent(in) :: g_mut(ims:ime,jms:jme)
real, intent(in) :: g_muts(ims:ime,jms:jme)
real, intent(inout) :: g_ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ph_1(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t_1(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t_2(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_t_2ave(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: gamma(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ht(ims:ime,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: mu1(ims:ime,jms:jme)
real, intent(in) :: muave(ims:ime,jms:jme)
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: muts(ims:ime,jms:jme)
real, intent(inout) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph_1(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: phb(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: rdx
real, intent(in) :: rdy
real, intent(in) :: rw_tend(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t0
real, intent(in) :: t_1(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t_2(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: t_2ave(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ww(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
real g_mut_inv(its:ite)
real g_rhs(its:ite,kts:kte)
real g_wdwn(its:ite,kts:kte)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer k_end
real msft_inv(its:ite)
real mut_inv(its:ite)
real rhs(its:ite,kts:kte)
real wdwn(its:ite,kts:kte)
real walls(9),gwalls(its:ite),kwalls(its:ite),xwalls(its:ite),ywalls(its:ite)

   call trace_entry("g_advance_w")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
i_start = its
i_end = ite
j_start = jts
j_end = jte
k_end = kte-1
if (j_end .eq. jde) then
  j_end = j_end-1
endif
if (i_end .eq. ide) then
  i_end = i_end-1
endif
if ((config_flags%specified .or. config_flags%nested) .and. its .eq. ids) then
  i_start = i_start+1
endif
if ((config_flags%specified .or. config_flags%nested) .and. ite .eq. ide) then
  i_end = i_end-1
endif
if ((config_flags%specified .or. config_flags%nested) .and. jts .eq. jds) then
  j_start = j_start+1
endif
if ((config_flags%specified .or. config_flags%nested) .and. jte .eq. jde) then
  j_end = j_end-1
endif
do i = i_start, i_end
  g_rhs(i,1) = 0.
  rhs(i,1) = 0.
end do
j_loop_w: do j = j_start, j_end
  do i = i_start, i_end
    g_mut_inv(i) = -(g_mut(i,j)/(mut(i,j)*mut(i,j)))
    mut_inv(i) = 1./mut(i,j)
    msft_inv(i) = 1./msft(i,j)
  end do

  do k = 1, k_end
    do i = i_start, i_end
      walls(2)=t_1(i,k,j)
      walls(1)=muts(i,j)*(t0+walls(2))
      walls(3)=(0.5*((1.+epssm)*t_2(i,k,j)+(1.-epssm)*t_2ave(i,k,j))-mu1(i,j)*walls(2))/walls(1)

      t_2ave(i,k,j) = walls(3)

      g_t_2ave(i,k,j) = (-g_mu1(i,j)*walls(2) -g_muts(i,j)*walls(3)*(t0+walls(2))-&
&g_t_1(i,k,j)*(mu1(i,j)+walls(3)*muts(i,j))+0.5*(g_t_2(i,k,j)*(1+epssm)+g_t_2ave(i,k,j)*(1.-epssm)))/walls(1)
    end do
  end do

  do k = 2, k_end+1
    gwalls(i_start:i_end)=ph_1(i_start:i_end,k,j)-ph_1(i_start:i_end,k-1,j)+phb(i_start:i_end,k,j)-phb(i_start:i_end,k-1,j)
    walls(1)=rdnw(k-1)
    walls(3)=0.5*dts*g*(1.-epssm)
    do i = i_start, i_end
      walls(2)=0.5*(ww(i,k,j)+ww(i,k-1,j))*walls(1)
      g_wdwn(i,k) = (-g_ph_1(i,k-1,j)+g_ph_1(i,k,j))*walls(2)+0.5*walls(1)*(g_ww(i,k-1,j)+g_ww(i,k,j))*gwalls(i)
      wdwn(i,k) = walls(2)*gwalls(i)
      g_rhs(i,k) = g_ph_tend(i,k,j)*dts+walls(3)*g_w(i,k,j)
      rhs(i,k)   = ph_tend(i,k,j)*dts+walls(3)*w(i,k,j)
    end do
  end do

  do k = 2, k_end
    walls(1)=dts*fnm(k)
    walls(2)=dts*fnp(k)
    do i = i_start, i_end
      g_rhs(i,k) = g_rhs(i,k)-g_wdwn(i,k+1)*walls(1)-g_wdwn(i,k)*walls(2)
      rhs(i,k)   = rhs(i,k)-walls(1)*wdwn(i,k+1)-walls(2)*wdwn(i,k)
    end do
  end do

  do k = 2, k_end+1
    do i = i_start, i_end
      g_rhs(i,k) = msft(i,j)*(g_mut_inv(i)*rhs(i,k)+g_rhs(i,k)*mut_inv(i))+g_ph(i,k,j)
      rhs(i,k) = ph(i,k,j)+msft(i,j)*rhs(i,k)*mut_inv(i)
    end do
  end do

  gwalls(i_start:i_end)=cf1*v(i_start:i_end,1,j+1)+cf2*v(i_start:i_end,2,j+1)+cf3*v(i_start:i_end,3,j+1)
  kwalls(i_start:i_end)=cf1*v(i_start:i_end,1,j)+cf2*v(i_start:i_end,2,j)+cf3*v(i_start:i_end,3,j)
  xwalls(i_start:i_end)=cf1*u(i_start+1:i_end+1,1,j)+cf2*u(i_start+1:i_end+1,2,j)+cf3*u(i_start+1:i_end+1,3,j)
  ywalls(i_start:i_end)=cf1*u(i_start:i_end,1,j)+cf2*u(i_start:i_end,2,j)+cf3*u(i_start:i_end,3,j)

  do i = i_start, i_end
    walls(1)=ht(i+1,j)-ht(i,j)
    walls(2)=ht(i,j)-ht(i-1,j)
    walls(3)=ht(i,j+1)-ht(i,j)
    walls(4)=ht(i,j)-ht(i,j-1)
    g_w(i,1,j) = 0.5*(rdx*(g_u(i+1,3,j)*walls(1)*cf3&
&+g_u(i,3,j)*walls(2)*cf3&
&+g_u(i+1,2,j)*walls(1)*cf2&
&+g_u(i,2,j)*walls(2)*cf2&
&+g_u(i+1,1,j)*walls(1)*cf1&
&+g_u(i,1,j)*walls(2)*cf1)&
&+rdy*(g_v(i,3,j+1)*walls(3)*cf3&
&+g_v(i,3,j)*walls(4)*cf3&
&+g_v(i,2,j+1)*walls(3)*cf2&
&+g_v(i,2,j)*walls(4)*cf2&
&+g_v(i,1,j+1)*walls(3)*cf1&
&+g_v(i,1,j)*walls(4)*cf1))

    w(i,1,j) = 0.5*rdy*(walls(3)*gwalls(i)+walls(4)*kwalls(i))+0.5*rdx*(walls(1)*xwalls(i)+walls(2)*ywalls(i))
  end do

! to be optimiized
  do k = 2, k_end
    walls(1)=rdnw(k-1)
    walls(2)=rdnw(k)
    walls(4)=dts*g*rdn(k)
    gwalls(i_start:i_end)=walls(2)*(1.+epssm)*(rhs(i_start:i_end,k+1)-rhs(i_start:i_end,k))&
&+walls(2)*(1.-epssm)*(ph(i_start:i_end,k+1,j)-ph(i_start:i_end,k,j))
    kwalls(i_start:i_end)=walls(1)*(1.+epssm)*(rhs(i_start:i_end,k)-rhs(i_start:i_end,k-1))&
&+walls(1)*(1.-epssm)*(ph(i_start:i_end,k,j)-ph(i_start:i_end,k-1,j))
    do i = i_start, i_end
      walls(3)=c2a(i,k-1,j)
      walls(6)=c2a(i,k,j)
      walls(5)=walls(6)*alb(i,k,j)-walls(3)*alb(i,k-1,j)
      walls(7)=0.5*msft_inv(i)*cqw(i,k,j)*mut_inv(i)*walls(4)
      walls(8)=msft_inv(i)*walls(4)
      walls(9)=0.5*walls(8)*(walls(6)*gwalls(i)-walls(3)*kwalls(i))
      g_wdwn(i,k) = (-(g_alt(i,k-1,j)*walls(8)*walls(3)*t_2ave(i,k-1,j)))&
&+g_alt(i,k,j)*walls(8)*walls(6)*t_2ave(i,k,j)&
&+g_c2a(i,k-1,j)*(-walls(7)*kwalls(i)+walls(8)*(-alt(i,k-1,j)*t_2ave(i,k-1,j)-alb(i,k-1,j)*mut_inv(i)*muave(i,j)))&
&+g_c2a(i,k,j)*(walls(7)*gwalls(i)&
&+walls(8)*(alt(i,k,j)*t_2ave(i,k,j)+alb(i,k,j)*mut_inv(i)*muave(i,j)))&
&+g_cqw(i,k,j)*mut_inv(i)*walls(9)&
&+g_muave(i,j)*msft_inv(i)*(-dts*g+walls(4)*walls(5)*mut_inv(i))+&
&g_mut_inv(i)*(cqw(i,k,j)*walls(9)+dts*&
&g*walls(8)/dts/g*walls(5)*muave(i,j))&
&+walls(7)*((1.-epssm)*(g_ph(i,k-1,j)*walls(3)*walls(1)&
&+g_ph(i,k+1,j)*walls(6)*walls(2)&
&-g_ph(i,k,j)*(walls(6)*walls(2)+walls(3)*walls(1)))&
&+(1.+epssm)*(g_rhs(i,k-1)*walls(3)*walls(1)&
&+g_rhs(i,k+1)*walls(6)*walls(2)&
&-g_rhs(i,k)*(walls(6)*walls(2)+walls(3)*walls(1))))&
&+walls(8)*(-g_t_2ave(i,k-1,j)*walls(3)*alt(i,k-1,j)&
&+g_t_2ave(i,k,j)*walls(6)*alt(i,k,j))
      wdwn(i,k) = cqw(i,k,j)*mut_inv(i)*walls(9)+msft_inv(i)*(walls(4)*(walls(6)*alt(i,k,j)*t_2ave(i,k,j)&
&-walls(3)*alt(i,k-1,j)*t_2ave(i,k-1,j))+(walls(4)*walls(5)*mut_inv(i)-dts*g)*muave(i,j))
    end do
  end do

  g_w(i_start:i_end,2:k_end,j) = g_w(i_start:i_end,2:k_end,j)+dts*g_rw_tend(i_start:i_end,2:k_end,j)+g_wdwn(i_start:i_end,2:k_end)
  w(i_start:i_end,2:k_end,j)   = w(i_start:i_end,2:k_end,j)+dts*rw_tend(i_start:i_end,2:k_end,j)+wdwn(i_start:i_end,2:k_end)

  k = k_end+1
  kwalls(i_start:i_end)=(1.+epssm)*(rhs(i_start:i_end,k)-rhs(i_start:i_end,k-1))&
&+(1.-epssm)*(ph(i_start:i_end,k,j)-ph(i_start:i_end,k-1,j))

  walls(1)=rdnw(k-1)
  walls(2)=dts*g*walls(1)

  do i = i_start, i_end
    walls(3)=2.*c2a(i,k-1,j)*alb(i,k-1,j)
    walls(4)=walls(2)*c2a(i,k-1,j)
    walls(5)=alt(i,k-1,j)*t_2ave(i,k-1,j)
    walls(6)=msft_inv(i)
    walls(7)=mut_inv(i)
    walls(8)=dts*g*(1.+walls(1)*walls(3)*walls(7))*walls(6)
    walls(9)=walls(4)*walls(6)*walls(7)*walls(1)

    g_w(i,k,j) = (-(g_alt(i,k-1,j)*walls(6)*2.0*walls(4)*t_2ave(i,k-1,j)))&
&-g_c2a(i,k-1,j)*walls(6)*2.0*walls(2)*(0.5*walls(7)*walls(1)*kwalls(i)+walls(5)+alb(i,k-1,j)*walls(7)*muave(i,j))&
&-g_muave(i,j)*walls(8)&
&-g_mut_inv(i)*walls(6)*(walls(1)*walls(4)*kwalls(i)+walls(2)*walls(3)*muave(i,j)) &
&+(g_ph(i,k-1,j)*(1.-epssm)-g_ph(i,k,j)*(1.-epssm)+g_rhs(i,k-1)*(1.+epssm)&
& -g_rhs(i,k)*(1+epssm))*walls(9)&
&+g_rw_tend(i,k,j)*dts&
&-g_t_2ave(i,k-1,j)*walls(6)*2.0*walls(4)*alt(i,k-1,j)&
&+g_w(i,k,j)

    w(i,k,j) = w(i,k,j)+dts*rw_tend(i,k,j)-walls(9)*kwalls(i)-2.*walls(4)*walls(5)*walls(6)-walls(8)*muave(i,j)
  end do

  do k = 2, k_end+1
    do i = i_start, i_end
      walls(1)=w(i,k,j)-a(i,k,j)*w(i,k-1,j)
      g_w(i,k,j) = (-(g_a(i,k,j)*w(i,k-1,j)*alpha(i,k,j)))+g_alpha(i,k,j)*walls(1)&
&-g_w(i,k-1,j)*a(i,k,j)*alpha(i,k,j)+g_w(i,k,j)*alpha(i,k,j)
      w(i,k,j) = walls(1)*alpha(i,k,j)
    end do
  end do

  do k = k_end, 2, -1
    do i = i_start, i_end
      g_w(i,k,j) = -g_gamma(i,k,j)*w(i,k+1,j) -g_w(i,k+1,j)*gamma(i,k,j)+g_w(i,k,j)
      w(i,k,j) = w(i,k,j)-gamma(i,k,j)*w(i,k+1,j)
    end do
  end do

  walls(1)=0.5*dts*g*(1.+epssm)
  do k = 2, k_end+1
    do i = i_start, i_end
      walls(2)=msft(i,j)*walls(1)/muts(i,j)
      g_ph(i,k,j) = (-g_muts(i,j)*w(i,k,j)/muts(i,j)+g_w(i,k,j))*walls(2) +g_rhs(i,k)
      ph(i,k,j) = rhs(i,k)+walls(2)*w(i,k,j)
    end do
  end do
end do j_loop_w

   call trace_exit("g_advance_w")

end subroutine g_advance_w


subroutine g_calc_coef_w( a, g_a, alpha, g_alpha, gamma, g_gamma, mut, g_mut, cqw, g_cqw, rdn, rdnw, c2a, g_c2a, dts, g, epssm, &
&ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: alpha(ims:ime,kms:kme,jms:jme)
real, intent(in) :: c2a(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cqw(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dts
real, intent(in) :: epssm
real, intent(in) :: g
real, intent(inout) :: g_a(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_alpha(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_c2a(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_cqw(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_gamma(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mut(ims:ime,jms:jme)
real, intent(inout) :: gamma(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
real, intent(in) :: mut(ims:ime,jms:jme)
real, intent(in) :: rdn(kms:kme)
real, intent(in) :: rdnw(kms:kme)

!==============================================
! declare local variables
!==============================================
real walls(4)
real b
real c
real cof(ims:ime)
real g_b
real g_c
real g_cof(ims:ime)
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k

   call trace_entry("g_calc_coef_w")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
i_start = its
i_end = ite
j_start = jts
j_end = jte
if (j_end .eq. jde) then
  j_end = j_end-1
endif
if (i_end .eq. ide) then
  i_end = i_end-1
endif
outer_j_loop: do j = j_start, j_end
  walls(1)=rdnw(kde-1)*rdnw(kde-1)
  walls(2)=0.5*dts*g*(1.+epssm)
  walls(2)=walls(2)*walls(2)
  do i = i_start, i_end
    cof(i) = walls(2)/(mut(i,j)*mut(i,j))
    g_cof(i) = -2*g_mut(i,j)*cof(i)/mut(i,j)

    g_a(i,2,j) = 0.
    a(i,2,j) = 0.
    g_a(i,kde,j) = -2.*walls(1)*(g_c2a(i,kde-1,j)*cof(i)+g_cof(i)*c2a(i,kde-1,j))
    a(i,kde,j) = -2.*walls(1)*cof(i)*c2a(i,kde-1,j)
    g_gamma(i,1,j) = 0.
    gamma(i,1,j) = 0.
  end do
  do k = 3, kde-1
    walls(1)=rdnw(k-1)*rdn(k)
    do i = i_start, i_end
      g_a(i,k,j) = (-g_c2a(i,k-1,j)*cqw(i,k,j)*cof(i)-g_cof(i)*cqw(i,k,j)*c2a(i,k-1,j)-g_cqw(i,k,j)*cof(i)*c2a(i,k-1,j))*walls(1)
      a(i,k,j) = -cqw(i,k,j)*cof(i)*walls(1)*c2a(i,k-1,j)
    end do
  end do
  do k = 2, kde-1
    walls(1)=rdnw(k-1)
    walls(3)=rdnw(k)
    walls(4)=rdn(k)
    do i = i_start, i_end
      walls(2)=walls(3)*c2a(i,k,j)+walls(1)*c2a(i,k-1,j)

      g_b = (g_c2a(i,k-1,j)*cqw(i,k,j)*cof(i)*walls(1)+g_c2a(i,k,j)*cqw(i,k,j)*cof(i)*walls(3)+g_cof(i)*cqw(i,k,j)*&
&walls(2)+g_cqw(i,k,j)*cof(i)*walls(2))*walls(4)
      b = 1.+cqw(i,k,j)*cof(i)*walls(4)*walls(2)

      g_c = (-g_c2a(i,k,j)*cqw(i,k,j)*cof(i)-g_cof(i)*cqw(i,k,j)*c2a(i,k,j)-g_cqw(i,k,j)*cof(i)*c2a(i,k,j))*walls(4)*walls(3)
      c = -(cqw(i,k,j)*cof(i)*walls(4)*walls(3)*c2a(i,k,j))

      walls(2)=b-a(i,k,j)*gamma(i,k-1,j)

      g_alpha(i,k,j) = (g_a(i,k,j)*gamma(i,k-1,j)-g_b+g_gamma(i,k-1,j)*a(i,k,j))/(walls(2)*walls(2))
      alpha(i,k,j) = 1./walls(2)

      g_gamma(i,k,j) = g_alpha(i,k,j)*c+g_c*alpha(i,k,j)
      gamma(i,k,j) = c*alpha(i,k,j)
    end do
  end do
  walls(1)=rdnw(kde-1)*rdnw(kde-1)
  do i = i_start, i_end
    g_b = 2.*walls(1)*(g_c2a(i,kde-1,j)*cof(i)+g_cof(i)*c2a(i,kde-1,j))
    b = 1.+2.*cof(i)*walls(1)*c2a(i,kde-1,j)

!   g_c = 0.
!   c = 0.

    walls(2)=b-a(i,kde,j)*gamma(i,kde-1,j)

    g_alpha(i,kde,j) = (g_a(i,kde,j)*gamma(i,kde-1,j)-g_b +g_gamma(i,kde-1,j)*a(i,kde,j))/(walls(2)*walls(2))
    alpha(i,kde,j) = 1./walls(2)

!   g_gamma(i,kde,j) = g_alpha(i,kde,j)*c+g_c*alpha(i,kde,j)
!   gamma(i,kde,j) = c*alpha(i,kde,j)

    g_gamma(i,kde,j) = 0.
    gamma(i,kde,j) = 0.
  end do
end do outer_j_loop

   call trace_exit("g_calc_coef_w")

end subroutine g_calc_coef_w


subroutine g_calc_p_rho( al, g_al, p, g_p, ph, g_ph, alt, g_alt, t_2, g_t_2, t_1, g_t_1, c2a, g_c2a, pm1, g_pm1, mu, g_mu, muts, &
&g_muts, znu, t0, rdnw, dnw, smdiv, non_hydrostatic, step, ide, jde, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, &
&kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(out) :: al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: c2a(ims:ime,kms:kme,jms:jme)
real, intent(in) :: dnw(kms:kme)
real, intent(out) :: g_al(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_c2a(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_mu(ims:ime,jms:jme)
real, intent(in) :: g_muts(ims:ime,jms:jme)
real, intent(out) :: g_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ph(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_pm1(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t_1(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t_2(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: mu(ims:ime,jms:jme)
real, intent(in) :: muts(ims:ime,jms:jme)
logical, intent(in) :: non_hydrostatic
real, intent(out) :: p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ph(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: pm1(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rdnw(kms:kme)
real, intent(in) :: smdiv
integer, intent(in) :: step
real, intent(in) :: t0
real, intent(in) :: t_1(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t_2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: znu(kms:kme)

!==============================================
! declare local variables
!==============================================
real g_ptmp
integer i
integer i_end
integer i_start
integer j
integer j_end
integer j_start
integer k
integer k_end
integer k_start
real ptmp
real walls(4),gwalls(ims:ime)

   call trace_entry("g_calc_p_rho")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
i_start = its
i_end = ite
j_start = jts
j_end = jte
k_start = kts
k_end = min(kte,kde-1)
if (i_end .eq. ide) then
  i_end = i_end-1
endif
if (j_end .eq. jde) then
  j_end = j_end-1
endif
if (non_hydrostatic) then
  do j = j_start, j_end
    do k = k_start, k_end
      do i = i_start, i_end
        walls(4)=alt(i,k,j)
        al(i,k,j) = -(walls(4)*mu(i,j)+rdnw(k)*(ph(i,k+1,j)-ph(i,k,j)))/muts(i,j)
        g_al(i,k,j) = (-g_alt(i,k,j)*mu(i,j)-g_mu(i,j)*walls(4)-g_muts(i,j)*al(i,k,j)&
&-(g_ph(i,k+1,j)-g_ph(i,k,j))*rdnw(k))/muts(i,j)

        walls(1)=muts(i,j)*(t0+t_1(i,k,j))
        walls(2)=c2a(i,k,j)
        walls(3)=t_2(i,k,j)-mu(i,j)*t_1(i,k,j)
        walls(4)=walls(4)/walls(1)

        p(i,k,j) = walls(2)*(walls(4)*walls(3)-al(i,k,j))
        g_p(i,k,j) = -g_al(i,k,j)*walls(2)&
&+g_alt(i,k,j)*walls(2)*(walls(3)/walls(1))&
&+g_c2a(i,k,j)*p(i,k,j)/walls(2)&
&+walls(2)*walls(4)*(-g_mu(i,j)*t_1(i,k,j)&
&-g_muts(i,j)*walls(3)*(t0+t_1(i,k,j))/walls(1)&
&-g_t_1(i,k,j)*(mu(i,j)+walls(3)*muts(i,j)/walls(1))&
&+g_t_2(i,k,j))
      end do
    end do
  end do
else
  do j = j_start, j_end
    do k = k_start, k_end
      do i = i_start, i_end
! To be optimized
        g_p(i,k,j) = g_mu(i,j)*znu(k)
        p(i,k,j) = mu(i,j)*znu(k)
        walls(1)=muts(i,j)*(t0+t_1(i,k,j))
        walls(2)=c2a(i,k,j)
        walls(3)=t_2(i,k,j)-mu(i,j)*t_1(i,k,j)
        walls(4)=alt(i,k,j)

        g_al(i,k,j) = g_alt(i,k,j)*(walls(3)/walls(1))+g_c2a(i,k,j)*(p(i,k,j)/(walls(2)&
&*walls(2)))-g_mu(i,j)*(walls(4)*t_1(i,k,j)/walls(1))-g_muts(i,j)*(walls(4)*(t_2(i,k,j)-mu(i,j)*&
&t_1(i,k,j))*(t0+t_1(i,k,j))/(walls(1)*walls(1)))-g_p(i,k,j)/walls(2)-g_t_1(i,k,j)*&
&(walls(4)*mu(i,j)/walls(1)+walls(4)*walls(3)*muts(i,j)/(walls(1)*walls(1)))&
&+g_t_2(i,k,j)*(walls(4)/walls(1))
        al(i,k,j) = walls(4)*walls(3)/walls(1)-p(i,k,j)/walls(2)

        g_ph(i,k+1,j) = (-(g_al(i,k,j)*dnw(k)*muts(i,j)))-g_alt(i,k,j)*dnw(k)*mu(i,j)-g_mu(i,j)*dnw(k)*walls(4)-g_muts(i,j)*&
&dnw(k)*al(i,k,j)+g_ph(i,k,j)
        ph(i,k+1,j) = ph(i,k,j)-dnw(k)*(muts(i,j)*al(i,k,j)+mu(i,j)*walls(4))
      end do
    end do
  end do
endif
if (step .eq. 0) then
  do j = j_start, j_end
    do k = k_start, k_end
      do i = i_start, i_end
        g_pm1(i,k,j) = g_p(i,k,j)
        pm1(i,k,j) = p(i,k,j)
      end do
    end do
  end do
else
  do j = j_start, j_end
    do k = k_start, k_end
      do i = i_start, i_end
        g_ptmp = g_p(i,k,j)
        ptmp = p(i,k,j)
        g_p(i,k,j) = g_p(i,k,j)*(1+smdiv)-g_pm1(i,k,j)*smdiv
        p(i,k,j) = p(i,k,j)+smdiv*(p(i,k,j)-pm1(i,k,j))
        g_pm1(i,k,j) = g_ptmp
        pm1(i,k,j) = ptmp
      end do
    end do
  end do
endif

   call trace_exit("g_calc_p_rho")

end subroutine g_calc_p_rho

subroutine g_small_step_finish( u_2, g_u_2, v_2, g_v_2, w_2, g_w_2, t_2, g_t_2, ph_2, g_ph_2, ww, mu_2, g_mu_2, mut, g_mut, muts, &
&g_muts, muu, g_muu, muus, g_muus, muv, g_muv, muvs, g_muvs, u_save, g_u_save, v_save, g_v_save, w_save, g_w_save, t_save, &
&g_t_save, ph_save, g_ph_save, mu_save, g_mu_save, msfu, msfv, msft, number_of_small_timesteps, dts, ide, jde, kds, kde, ims, ime, jms, jme, kms, kme, its, ite, &
&jts, jte )

!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(inout) :: g_mu_2(ims:ime,jms:jme)
real, intent(inout) :: g_mu_save(ims:ime,jms:jme)
real, intent(inout) :: g_mut(ims:ime,jms:jme)
real, intent(inout) :: g_muts(ims:ime,jms:jme)
real, intent(inout) :: g_muu(ims:ime,jms:jme)
real, intent(inout) :: g_muus(ims:ime,jms:jme)
real, intent(inout) :: g_muv(ims:ime,jms:jme)
real, intent(inout) :: g_muvs(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: g_ph_2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ph_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_t_2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_t_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_u_2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_v_2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_w_2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_w_save(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kds
real, intent(in) :: msft(ims:ime,jms:jme)
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(inout) :: mu_2(ims:ime,jms:jme)
real, intent(inout) :: mu_save(ims:ime,jms:jme)
real, intent(inout) :: mut(ims:ime,jms:jme)
real, intent(inout) :: muts(ims:ime,jms:jme)
real, intent(inout) :: muu(ims:ime,jms:jme)
real, intent(inout) :: muus(ims:ime,jms:jme)
real, intent(inout) :: muv(ims:ime,jms:jme)
real, intent(inout) :: muvs(ims:ime,jms:jme)
real, intent(inout) :: ph_2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ph_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: t_2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: t_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: u_2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: v_2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: w_2(ims:ime,kms:kme,jms:jme)
real, intent(in) :: w_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ww(ims:ime,kms:kme,jms:jme)
real walls(4)


  REAL,   DIMENSION(ims:ime, kms:kme, jms:jme)  ::ww1,g_ww1,g_ww
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: h_diabatic
  INTEGER, INTENT(IN)                 :: number_of_small_timesteps
  REAL, INTENT(IN)                    :: dts



!==============================================
! declare local variables
!==============================================
integer i
integer i_end
integer i_endu
integer i_start
integer j
integer j_end
integer j_endv
integer j_start
integer k

   call trace_entry("g_small_step_finish")

ww1 = 0.0; g_ww1=0.0; g_ww =0.0
h_diabatic = 0.0
!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
i_start = its
i_end = ite
j_start = jts
j_end = jte
i_endu = i_end
j_endv = j_end
if (i_end .eq. ide) then
  i_end = i_end-1
endif
if (j_end .eq. jde) then
  j_end = j_end-1
endif
do j = j_start, j_endv
  do k = kds, kde-1
    do i = i_start, i_end
      v_2(i,k,j) =(msfv(i,j)*v_2(i,k,j)+v_save(i,k,j)*muv(i,j))/muvs(i,j)
      g_v_2(i,k,j) = (g_muv(i,j)*v_save(i,k,j)-g_muvs(i,j)*v_2(i,k,j)+g_v_2(i,k,j)*msfv(i,j)+g_v_save(i,k,j)*muv(i,j))/muvs(i,j)
    end do
  end do
end do
do j = j_start, j_end
  do k = kds, kde-1
    do i = i_start, i_endu
      u_2(i,k,j) = (msfu(i,j)*u_2(i,k,j)+u_save(i,k,j)*muu(i,j))/muus(i,j)
      g_u_2(i,k,j) = (g_muu(i,j)*u_save(i,k,j)-g_muus(i,j)*u_2(i,k,j)+g_u_2(i,k,j)*msfu(i,j)+g_u_save(i,k,j)*muu(i,j))/muus(i,j)
    end do
  end do
end do
do j = j_start, j_end
  do k = kds, kde
    do i = i_start, i_end
      w_2(i,k,j) = (msft(i,j)*w_2(i,k,j)+w_save(i,k,j)*mut(i,j))/muts(i,j)
      g_w_2(i,k,j) =( g_mut(i,j)*w_save(i,k,j)-g_muts(i,j)*w_2(i,k,j)+g_w_2(i,k,j)*msft(i,j)+g_w_save(i,k,j)*mut(i,j))/muts(i,j)
    end do
  end do
end do

g_ph_2(i_start:i_end,kds:kde,j_start:j_end) = g_ph_2(i_start:i_end,kds:kde,j_start:j_end)&
&+g_ph_save(i_start:i_end,kds:kde,j_start:j_end)
ph_2(i_start:i_end,kds:kde,j_start:j_end) = ph_2(i_start:i_end,kds:kde,j_start:j_end)&
&+ph_save(i_start:i_end,kds:kde,j_start:j_end)
g_ww(i_start:i_end,kds:kde,j_start:j_end) = g_ww(i_start:i_end,kds:kde,j_start:j_end) &
&+ g_ww1(i_start:i_end,kds:kde,j_start:j_end)
ww(i_start:i_end,kds:kde,j_start:j_end) = ww(i_start:i_end,kds:kde,j_start:j_end) &
&+ ww1(i_start:i_end,kds:kde,j_start:j_end)

 
walls(1)=dts*number_of_small_timesteps
do j = j_start, j_end
  do k = kds, kde-1
    do i = i_start, i_end

      t_2(i,k,j) = (t_2(i,k,j) - walls(1)*mut(i,j)*h_diabatic(i,k,j) + t_save(i,k,j)*mut(i,j))/muts(i,j)

      g_t_2(i,k,j) = (g_t_2(i,k,j) - walls(1)*g_mut(i,j)*h_diabatic(i,k,j) &
                    + g_t_save(i,k,j)*mut(i,j) + t_save(i,k,j)*g_mut(i,j) -t_2(i,k,j)*g_muts(i,j))/muts(i,j)

    end do
  end do
end do

do j = j_start, j_end
  do i = i_start, i_end
    g_mu_2(i,j) = g_mu_2(i,j)+g_mu_save(i,j)
    mu_2(i,j) = mu_2(i,j)+mu_save(i,j)
  end do
end do

   call trace_exit("g_small_step_finish")

end subroutine g_small_step_finish


subroutine g_small_step_prep( u_1, g_u_1, u_2, g_u_2, v_1, g_v_1, v_2, g_v_2, w_1, g_w_1, w_2, g_w_2, t_1, g_t_1, t_2, g_t_2, ph_1,&
& g_ph_1, ph_2, g_ph_2, mub, mu_1, g_mu_1, mu_2, g_mu_2, muu, g_muu, muus, g_muus, muv, g_muv, muvs, g_muvs, mut, g_mut, muts, &
&g_muts, mudf, g_mudf, u_save, g_u_save, v_save, g_v_save, w_save, g_w_save, t_save, g_t_save, ph_save, g_ph_save, mu_save, &
&g_mu_save, ww, g_ww, ww_save, g_ww_save, c2a, g_c2a, pb, p, g_p, alt, g_alt, msfu, msfv, msft, rk_step, leapfrog, ide, jde, kde, &
&ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: alt(ims:ime,kms:kme,jms:jme)
real, intent(out) :: c2a(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_alt(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_c2a(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_mu_1(ims:ime,jms:jme)
real, intent(inout) :: g_mu_2(ims:ime,jms:jme)
real, intent(out) :: g_mu_save(ims:ime,jms:jme)
real, intent(out) :: g_mudf(ims:ime,jms:jme)
real, intent(inout) :: g_mut(ims:ime,jms:jme)
real, intent(out) :: g_muts(ims:ime,jms:jme)
real, intent(inout) :: g_muu(ims:ime,jms:jme)
real, intent(out) :: g_muus(ims:ime,jms:jme)
real, intent(inout) :: g_muv(ims:ime,jms:jme)
real, intent(out) :: g_muvs(ims:ime,jms:jme)
real, intent(in) :: g_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ph_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ph_2(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_ph_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_t_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_t_2(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_t_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_u_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_u_2(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_u_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_v_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_v_2(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_v_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_w_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_w_2(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_w_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ww(ims:ime,kms:kme,jms:jme)
real, intent(out) :: g_ww_save(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
logical, intent(in) :: leapfrog
real, intent(inout) :: msft(ims:ime,jms:jme)
real, intent(inout) :: msfu(ims:ime,jms:jme)
real, intent(inout) :: msfv(ims:ime,jms:jme)
real, intent(inout) :: mu_1(ims:ime,jms:jme)
real, intent(inout) :: mu_2(ims:ime,jms:jme)
real, intent(out) :: mu_save(ims:ime,jms:jme)
real, intent(inout) :: mub(ims:ime,jms:jme)
real, intent(out) :: mudf(ims:ime,jms:jme)
real, intent(inout) :: mut(ims:ime,jms:jme)
real, intent(out) :: muts(ims:ime,jms:jme)
real, intent(inout) :: muu(ims:ime,jms:jme)
real, intent(out) :: muus(ims:ime,jms:jme)
real, intent(inout) :: muv(ims:ime,jms:jme)
real, intent(out) :: muvs(ims:ime,jms:jme)
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pb(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ph_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ph_2(ims:ime,kms:kme,jms:jme)
real, intent(out) :: ph_save(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: rk_step
real, intent(inout) :: t_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: t_2(ims:ime,kms:kme,jms:jme)
real, intent(out) :: t_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: u_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: u_2(ims:ime,kms:kme,jms:jme)
real, intent(out) :: u_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: v_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: v_2(ims:ime,kms:kme,jms:jme)
real, intent(out) :: v_save(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: w_1(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: w_2(ims:ime,kms:kme,jms:jme)
real, intent(out) :: w_save(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ww(ims:ime,kms:kme,jms:jme)
real, intent(out) :: ww_save(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer i_end
integer i_endu
integer i_start
integer j
integer j_end
integer j_endv
integer j_start
integer k
integer k_end
integer k_start

   call trace_entry("g_small_step_prep")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
i_start = its
i_end = ite
j_start = jts
j_end = jte
k_start = kts
k_end = min(kte,kde-1)
i_endu = i_end
j_endv = j_end
if (i_end .eq. ide) then
  i_end = i_end-1
endif
if (j_end .eq. jde) then
  j_end = j_end-1
endif


if (rk_step .eq. 1 .and. ( .not. leapfrog)) then
  do j = j_start, j_end
    do i = i_start, i_end
      g_mu_1(i,j) = g_mu_2(i,j)
      mu_1(i,j) = mu_2(i,j)
      g_ww_save(i,kde,j) = 0.
      ww_save(i,kde,j) = 0.
      g_ww_save(i,1,j) = 0.
      ww_save(i,1,j) = 0.
      g_mudf(i,j) = 0.
      mudf(i,j) = 0.
    end do
  end do
  do j = j_start, j_end
    do k = k_start, k_end
      do i = i_start, i_endu
        g_u_1(i,k,j) = g_u_2(i,k,j)
        u_1(i,k,j) = u_2(i,k,j)
      end do
    end do
  end do
  do j = j_start, j_endv
    do k = k_start, k_end
      do i = i_start, i_end
        g_v_1(i,k,j) = g_v_2(i,k,j)
        v_1(i,k,j) = v_2(i,k,j)
      end do
    end do
  end do
  do j = j_start, j_end
    do k = k_start, k_end
      do i = i_start, i_end
        g_t_1(i,k,j) = g_t_2(i,k,j)
        t_1(i,k,j) = t_2(i,k,j)
      end do
    end do
  end do
  do j = j_start, j_end
    do k = k_start, min(kde,kte)
      do i = i_start, i_end
        g_w_1(i,k,j) = g_w_2(i,k,j)
        w_1(i,k,j) = w_2(i,k,j)
        g_ph_1(i,k,j) = g_ph_2(i,k,j)
        ph_1(i,k,j) = ph_2(i,k,j)
      end do
    end do
  end do
  do j = j_start, j_end
    do i = i_start, i_end
      g_muts(i,j) = g_mu_2(i,j)
      muts(i,j) = mub(i,j)+mu_2(i,j)
    end do
    do i = i_start, i_endu
      g_muus(i,j) = g_muu(i,j)
      muus(i,j) = muu(i,j)
    end do
  end do
  do j = j_start, j_endv
    do i = i_start, i_end
      g_muvs(i,j) = g_muv(i,j)
      muvs(i,j) = muv(i,j)
    end do
  end do
  do j = j_start, j_end
    do i = i_start, i_end
      g_mu_save(i,j) = g_mu_2(i,j)
      mu_save(i,j) = mu_2(i,j)
      g_mu_2(i,j) = 0.
      mu_2(i,j) = mu_2(i,j)-mu_2(i,j)
    end do
  end do

else

  do j = j_start, j_end
    do i = i_start, i_end
      g_muts(i,j) = g_mu_1(i,j)
      muts(i,j) = mub(i,j)+mu_1(i,j)
    end do
    do i = i_start, i_endu
      g_muus(i,j) = 0.5*g_mu_1(i-1,j)+0.5*g_mu_1(i,j)
      muus(i,j) = 0.5*(mub(i,j)+mu_1(i,j)+mub(i-1,j)+mu_1(i-1,j))
    end do
  end do
  do j = j_start, j_endv
    do i = i_start, i_end
      g_muvs(i,j) = 0.5*(g_mu_1(i,j-1)+g_mu_1(i,j))
      muvs(i,j) = 0.5*(mub(i,j)+mu_1(i,j)+mub(i,j-1)+mu_1(i,j-1))
    end do
  end do
  do j = j_start, j_end
    do i = i_start, i_end
      g_mu_save(i,j) = g_mu_2(i,j)
      mu_save(i,j) = mu_2(i,j)
      g_mu_2(i,j) = g_mu_1(i,j)-g_mu_2(i,j)
      mu_2(i,j) = mu_1(i,j)-mu_2(i,j)
    end do
  end do
endif

g_ww_save(i_start:i_end,kde,j_start:j_end) = 0.
ww_save(i_start:i_end,kde,j_start:j_end) = 0.
g_ww_save(i_start:i_end,1,j_start:j_end) = 0.
ww_save(i_start:i_end,1,j_start:j_end) = 0.
!do j = j_start, j_end
!  do i = i_start, i_end
!    g_ww_save(i,kde,j) = 0.
!    ww_save(i,kde,j) = 0.
!    g_ww_save(i,1,j) = 0.
!    ww_save(i,1,j) = 0.
!  end do
!end do

do j = j_start, j_end
  do k = k_start, k_end
    do i = i_start, i_end
      c2a(i,k,j) = cpovcv*(pb(i,k,j)+p(i,k,j))/alt(i,k,j)
      g_c2a(i,k,j) = (-g_alt(i,k,j)*c2a(i,k,j)+cpovcv*g_p(i,k,j))/alt(i,k,j)
    end do
  end do
end do

g_u_save(i_start:i_endu,k_start:k_end,j_start:j_end) = g_u_2(i_start:i_endu,k_start:k_end,j_start:j_end)
u_save(i_start:i_endu,k_start:k_end,j_start:j_end) = u_2(i_start:i_endu,k_start:k_end,j_start:j_end)
do j = j_start, j_end
  do k = k_start, k_end
    do i = i_start, i_endu
      g_u_2(i,k,j) = (-g_muu(i,j)*u_2(i,k,j)+g_muus(i,j)*u_1(i,k,j)+g_u_1(i,k,j)*muus(i,j)-g_u_2(i,k,j)*muu(i,j))/msfu(i,j)
    end do
    do i = i_start, i_endu
      u_2(i,k,j) = (muus(i,j)*u_1(i,k,j)-muu(i,j)*u_2(i,k,j))/msfu(i,j)
    end do
  end do
end do

g_v_save(i_start:i_end,k_start:k_end,j_start:j_endv) = g_v_2(i_start:i_end,k_start:k_end,j_start:j_endv)
v_save(i_start:i_end,k_start:k_end,j_start:j_endv) = v_2(i_start:i_end,k_start:k_end,j_start:j_endv)
do j = j_start, j_endv
  do k = k_start, k_end
    do i = i_start, i_end
      g_v_2(i,k,j) = (-g_muv(i,j)*v_2(i,k,j)+g_muvs(i,j)*v_1(i,k,j)+g_v_1(i,k,j)*muvs(i,j)-g_v_2(i,k,j)*muv(i,j))/msfv(i,j)
    end do
    do i = i_start, i_end
      v_2(i,k,j) = (muvs(i,j)*v_1(i,k,j)-muv(i,j)*v_2(i,k,j))/msfv(i,j)
    end do
  end do
end do

g_t_save(i_start:i_end,k_start:k_end,j_start:j_end) = g_t_2(i_start:i_end,k_start:k_end,j_start:j_end)
t_save(i_start:i_end,k_start:k_end,j_start:j_end) = t_2(i_start:i_end,k_start:k_end,j_start:j_end)

do j = j_start, j_end
  do k = k_start, k_end
    do i = i_start, i_end
      g_t_2(i,k,j) = -g_mut(i,j)*t_2(i,k,j)+g_muts(i,j)*t_1(i,k,j)+g_t_1(i,k,j)*muts(i,j)-g_t_2(i,k,j)*mut(i,j)
      t_2(i,k,j) = muts(i,j)*t_1(i,k,j)-mut(i,j)*t_2(i,k,j)
    end do
  end do
end do

g_w_save(i_start:i_end,k_start:kde,j_start:j_end) = g_w_2(i_start:i_end,k_start:kde,j_start:j_end)
w_save(i_start:i_end,k_start:kde,j_start:j_end) = w_2(i_start:i_end,k_start:kde,j_start:j_end)
g_ph_save(i_start:i_end,k_start:kde,j_start:j_end) = g_ph_2(i_start:i_end,k_start:kde,j_start:j_end)
ph_save(i_start:i_end,k_start:kde,j_start:j_end) = ph_2(i_start:i_end,k_start:kde,j_start:j_end)
g_ph_2(i_start:i_end,k_start:kde,j_start:j_end) = g_ph_1(i_start:i_end,k_start:kde,j_start:j_end)&
&-g_ph_2(i_start:i_end,k_start:kde,j_start:j_end)
ph_2(i_start:i_end,k_start:kde,j_start:j_end) = ph_1(i_start:i_end,k_start:kde,j_start:j_end)&
&-ph_2(i_start:i_end,k_start:kde,j_start:j_end)

do j = j_start, j_end
  do k = k_start, kde
    do i = i_start, i_end
      g_w_2(i,k,j) = (-g_mut(i,j)*w_2(i,k,j)+g_muts(i,j)*w_1(i,k,j)+g_w_1(i,k,j)*muts(i,j)-g_w_2(i,k,j)*mut(i,j))/msft(i,j)
    end do
    do i = i_start, i_end
      w_2(i,k,j) = (muts(i,j)*w_1(i,k,j)-mut(i,j)*w_2(i,k,j))/msft(i,j)
    end do
  end do
end do

g_ww_save(i_start:i_end,k_start:kde,j_start:j_end) = g_ww(i_start:i_end,k_start:kde,j_start:j_end)
ww_save(i_start:i_end,k_start:kde,j_start:j_end) = ww(i_start:i_end,k_start:kde,j_start:j_end)
!do j = j_start, j_end
!  do k = k_start, kde
!    do i = i_start, i_end
!      g_ww_save(i,k,j) = g_ww(i,k,j)
!      ww_save(i,k,j) = ww(i,k,j)
!    end do
!  end do
!end do

   call trace_exit("g_small_step_prep")

end subroutine g_small_step_prep


subroutine g_sumflux( ru, g_ru, rv, g_rv, ww, g_ww, u_lin, g_u_lin, v_lin, g_v_lin, ww_lin, g_ww_lin, muu, g_muu, muv, g_muv, ru_m,&
& g_ru_m, rv_m, g_rv_m, ww_m, g_ww_m, msfu, msfv, iteration, number_of_small_timesteps, ide, jde, kde, ims, ime, jms, jme, kms, &
&kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
real, intent(in) :: g_muu(ims:ime,jms:jme)
real, intent(in) :: g_muv(ims:ime,jms:jme)
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: g_ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ru_m(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rv_m(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_u_lin(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_v_lin(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_ww_lin(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_ww_m(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ite
integer, intent(in) :: iteration
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: msfu(ims:ime,jms:jme)
real, intent(in) :: msfv(ims:ime,jms:jme)
real, intent(in) :: muu(ims:ime,jms:jme)
real, intent(in) :: muv(ims:ime,jms:jme)
integer, intent(in) :: number_of_small_timesteps
real, intent(in) :: ru(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ru_m(ims:ime,kms:kme,jms:jme)
real, intent(in) :: rv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: rv_m(ims:ime,kms:kme,jms:jme)
real, intent(in) :: u_lin(ims:ime,kms:kme,jms:jme)
real, intent(in) :: v_lin(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ww(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ww_lin(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: ww_m(ims:ime,kms:kme,jms:jme)

!==============================================
! declare local variables
!==============================================
integer i
integer j
integer k

   call trace_entry("g_sumflux")

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (iteration .eq. 1) then
  do j = jts, jte
    do k = kts, kte
      do i = its, ite
        g_ru_m(i,k,j) = 0.
        ru_m(i,k,j) = 0.
        g_rv_m(i,k,j) = 0.
        rv_m(i,k,j) = 0.
        g_ww_m(i,k,j) = 0.
        ww_m(i,k,j) = 0.
      end do
    end do
  end do
endif
do j = jts, min(jde-1,jte)
  do k = kts, min(kde-1,kte)
    do i = its, ite
      g_ru_m(i,k,j) = g_ru(i,k,j)+g_ru_m(i,k,j)
      ru_m(i,k,j) = ru_m(i,k,j)+ru(i,k,j)
    end do
  end do
end do
do j = jts, jte
  do k = kts, min(kde-1,kte)
    do i = its, min(ide-1,ite)
      g_rv_m(i,k,j) = g_rv(i,k,j)+g_rv_m(i,k,j)
      rv_m(i,k,j) = rv_m(i,k,j)+rv(i,k,j)
    end do
  end do
end do
do j = jts, min(jde-1,jte)
  do k = kts, kte
    do i = its, min(ide-1,ite)
      g_ww_m(i,k,j) = g_ww(i,k,j)+g_ww_m(i,k,j)
      ww_m(i,k,j) = ww_m(i,k,j)+ww(i,k,j)
    end do
  end do
end do
if (iteration .eq. number_of_small_timesteps) then
  do j = jts, min(jde-1,jte)
    do k = kts, min(kde-1,kte)
      do i = its, ite
        g_ru_m(i,k,j) = g_muu(i,j)*(u_lin(i,k,j)/msfu(i,j))+g_ru_m(i,k,j)/float(number_of_small_timesteps)+g_u_lin(i,k,j)*(muu(i,j)&
&/msfu(i,j))
        ru_m(i,k,j) = ru_m(i,k,j)/number_of_small_timesteps+muu(i,j)*u_lin(i,k,j)/msfu(i,j)
      end do
    end do
  end do
  do j = jts, jte
    do k = kts, min(kde-1,kte)
      do i = its, min(ide-1,ite)
        g_rv_m(i,k,j) = g_muv(i,j)*(v_lin(i,k,j)/msfv(i,j))+g_rv_m(i,k,j)/float(number_of_small_timesteps)+g_v_lin(i,k,j)*(muv(i,j)&
&/msfv(i,j))
        rv_m(i,k,j) = rv_m(i,k,j)/number_of_small_timesteps+muv(i,j)*v_lin(i,k,j)/msfv(i,j)
      end do
    end do
  end do
  do j = jts, min(jde-1,jte)
    do k = kts, kte
      do i = its, min(ide-1,ite)
        g_ww_m(i,k,j) = g_ww_lin(i,k,j)+g_ww_m(i,k,j)/float(number_of_small_timesteps)
        ww_m(i,k,j) = ww_m(i,k,j)/number_of_small_timesteps+ww_lin(i,k,j)
      end do
    end do
  end do
endif

   call trace_exit("g_sumflux")

end subroutine g_sumflux


end module     g_module_small_step_em


