!                           DISCLAIMER
!
!   This file was generated by TAF version 1.7.18
!***********************************************************
!***********************************************************

! program history log:
! 2005-xx-xx generated by TAF
! 2005-06-08 Qingnong Xiao and Zaizhong Ma  - revised and tested 
! 2008-05-xx Wei Huang   - change from static(stack) to dynamic
!                          in order to save compuational cost of the solve_em_ad.F
! 2008-08-18 Zaizhong Ma - finish adjoint check of simplified code
! 2008-08-19 Xin Zhang and Zaizhong Ma - make parallel 
! 2009-12-28 Hongli Wang - finish the Kessler warm rain scheme
!***********************************************************
!***********************************************************
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.7.18  **
!******************************************************************
!******************************************************************
!WRF:MEDIATION_LAYER:SOLVER

SUBROUTINE solve_em_ad ( grid , config_flags , &
!
#include "em_dummy_args.inc"
!
                 )

! Driver layer modules
   USE module_domain
   USE module_configure
   USE module_driver_constants
   USE module_machine
   USE module_tiles
   USE module_dm
! Mediation layer modules
! Model layer modules
   USE module_model_constants
   USE module_small_step_em
   USE module_em
   USE module_big_step_utilities_em
   USE module_bc_em
   USE module_solvedebug_em
   USE module_physics_addtendc
   USE module_diffusion_em
! Registry generated module
   USE module_state_description
   USE module_radiation_driver
   USE module_surface_driver
   USE module_cumulus_driver
   USE module_cu_du , only : DUCU_B, DUCU  !Xiaoyan Zhang 12 July, 2007
   USE module_microphysics_driver
   USE module_pbl_driver
   USE module_mp_nconvp   !Xiaoyan Zhang
   USE module_mp_kessler_db  
#ifdef WRF_CHEM
   USE module_input_chem_data
#endif

   USE a_module_small_step_em
   USE a_module_em
   USE a_module_big_step_utilities_em
   USE a_module_bc
   USE a_module_bc_em
   USE a_module_diffusion_em

   USE module_linked_list2

   USE module_trace, only : trace_entry, trace_exit

   IMPLICIT NONE

#ifdef DM_PARALLEL
   INCLUDE 'mpif.h'
#endif

   !  Input data.

   TYPE(domain) , TARGET          :: grid

   !  Definitions of dummy arguments to solve
#include <em_dummy_decl.inc>

   !  WRF state bcs
   TYPE (grid_config_rec_type) , INTENT(IN)          :: config_flags

   ! WRF state data

   ! Local data

   INTEGER                         :: k_start , k_end, its, ite, jts, jte
   INTEGER                         :: ids , ide , jds , jde , kds , kde , &
                                      ims , ime , jms , jme , kms , kme , &
                                      ips , ipe , jps , jpe , kps , kpe
   INTEGER                         :: i, j, k, ij , iteration
   INTEGER                         :: im , num_3d_m , ic , num_3d_c
   INTEGER                         :: ijds, ijde
   INTEGER                         :: itmpstep
   INTEGER                         :: sz

! storage for tendencies and decoupled state (generated from Registry)
#include <em_i1_decl.inc>

   INTEGER :: rc   !by walls
   INTEGER :: number_of_small_timesteps, rk_step  
   INTEGER :: klevel,ijm,ijp,size1,size2    !by walls
   INTEGER :: idum1, idum2, dynamics_option   !by walls

   INTEGER :: rk_order, iwmax, jwmax, kwmax  !by walls
   REAL    :: dt_rk, dts_rk, dtm, wmax   !by walls
   LOGICAL :: leapfrog
   LOGICAL ::  solverDisabled  ! 091012 bp; aix allowed declaration after statements; correcting for PGI
   INTEGER :: l,kte,kk  !by walls
   INTEGER :: kts   !by walls

   INTEGER :: walls_open  !by walls

real, DIMENSION(max(grid%ed31,grid%ed33),grid%sd32:grid%ed32,grid%spec_bdy_width,4) :: a_rqc_bth
real, DIMENSION(max(grid%ed31,grid%ed33),grid%sd32:grid%ed32,grid%spec_bdy_width,4) :: a_rqr_bth
real, DIMENSION(max(grid%ed31,grid%ed33),grid%sd32:grid%ed32,grid%spec_bdy_width,4) :: a_rqi_bth
real, DIMENSION(max(grid%ed31,grid%ed33),grid%sd32:grid%ed32,grid%spec_bdy_width,4) :: a_rqs_bth
real, DIMENSION(max(grid%ed31,grid%ed33),grid%sd32:grid%ed32,grid%spec_bdy_width,4) :: a_rqg_bth

!----------------------------------------------------------------------------------------

!Xiaoyan Zhang add
!  real, DIMENSION(grid%sm31:grid%em31,grid%sm32:grid%em32,grid%sm33:grid%em33) :: a_h_diabatic
!  real, DIMENSION(grid%sm31:grid%em31,grid%sm33:grid%em33)                     :: a_rainnc
!  real, DIMENSION(grid%sm31:grid%em31,grid%sm33:grid%em33)                     :: a_rainncv
!  real, DIMENSION(grid%sm31:grid%em31,grid%sm33:grid%em33)                     :: a_rainc
!  real, DIMENSION(grid%sm31:grid%em31,grid%sm33:grid%em33)                     :: a_raincv
   real, DIMENSION(grid%sm31:grid%em31,grid%sm32:grid%em32,grid%sm33:grid%em33) :: a_rqvcuten
   real, DIMENSION(grid%sm31:grid%em31,grid%sm32:grid%em32,grid%sm33:grid%em33) :: a_rthcuten

#ifdef DEREF_KLUDGE
   INTEGER     :: sm31 , em31 , sm32 , em32 , sm33 , em33
   INTEGER     :: sm31x, em31x, sm32x, em32x, sm33x, em33x
   INTEGER     :: sm31y, em31y, sm32y, em32y, sm33y, em33y
#endif

! Define benchmarking timers if -DBENCH is compiled   !by walls
!#include <bench_solve_em_def.h>  

#include "deref_kludge.h"

   
#define COPY_IN
#include <em_scalar_derefs.inc>
#ifdef DM_PARALLEL
#    define REGISTER_I1
#      include <em_data_calls.inc>
#endif

!<DESCRIPTION>
!<pre>
! solve_em is the main driver for advancing a grid a single timestep.
! It is a mediation-layer routine -> DM and SM calls are made where 
! needed for parallel processing.  
!
! solve_em can integrate the equations using 3 time-integration methods
!      
!    - 3rd order Runge-Kutta time integration (recommended)
!      
!    - 2nd order Runge-Kutta time integration
!      
!    - Leapfrog time integration
!      (note: the leapfrog scheme is not correctly implemented
!      for most of the physics)
!
! The main sections of solve_em are
!     
! (1) Runge-Kutta (RK) loop
!     
! (2) Non-timesplit physics (i.e., tendencies computed for updating
!     model state variables during the first RK sub-step (loop)
!     
! (3) Small (acoustic, sound) timestep loop - within the RK sub-steps
!     
! (4) Scalar advance for moist and chem scalar variables (and TKE)
!     within the RK sub-steps.
!     
! (5) time-split physics (after the RK step), currently this includes
!     only microphyics
!
! A more detailed description of these sections follows.
!</pre>
!</DESCRIPTION>

!#include <bench_solve_em_init.h>   
!#include <em_i1_init.inc>

   if(grid%trace_use) call trace_entry("solve_em_ad")

   ! 090921 bp; 
   solverDisabled = .false.
   call nl_get_disable_solver( 1, solverDisabled )
   if(solverDisabled) then
      return
   endif

   CALL wrf_debug ( 10 , 'DEBUG:  begin solve_em_ad()' )
   CALL linkedlist_initialize

!  call check_linkedlist

!  set leapfrog or runge-kutta solver (2nd or 3rd order)
   dynamics_option = config_flags%rk_ord   

   call get_ijk_from_grid( grid,ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme,ips,ipe,jps,jpe,kps,kpe )

   ij = 1

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
!print*, '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
!print*, '++++++++++++++++++++++++++++++++++++++++++++++001++++++++++++++++++++++++++++++++++++++++++++++++++'
    a_a = 0.0
    a_advect_tend = 0.0
    a_alpha = 0.0
    a_bn2 = 0.0
    a_c2a = 0.0
    a_cqu = 0.0
    a_cqv = 0.0
    a_cqw = 0.0
    a_gamma = 0.0
    a_moist_tend = 0.0
    a_mu_save = 0.0
    a_mu_tend = 0.0
    a_muave = 0.0
    a_mut = 0.0
    a_muts = 0.0
    a_muu = 0.0
    a_muus = 0.0
    a_muv = 0.0
    a_muvs = 0.0
    a_p8w = 0.0
    a_p_phy = 0.0
    a_ph_save = 0.0
    a_ph_tend = 0.0
    a_ph_tendf = 0.0
    a_pi_phy = 0.0
    a_pm1 = 0.0
    a_rqc_bth = 0.0
    a_rqg_bth = 0.0
    a_rqi_bth = 0.0
    a_rqr_bth = 0.0
    a_rqs_bth = 0.0
    a_ru_m = 0.0
    a_ru_tend = 0.0
    a_ru_tendf = 0.0
    a_rv_m = 0.0
    a_rv_tend = 0.0
    a_rv_tendf = 0.0
    a_rw_tend = 0.0
    a_rw_tendf = 0.0
    a_t8w = 0.0
    a_t_2save = 0.0
    a_t_phy = 0.0
    a_t_save = 0.0
    a_t_tend = 0.0
    a_t_tendf = 0.0
    a_th_phy = 0.0
    a_u_save = 0.0
    a_v_save = 0.0
    a_w_save = 0.0
    a_ww1 = 0.0
    a_ww_m = 0.0
    a_z_at_w = 0.0
    a_rqvcuten = 0.0
    a_rthcuten = 0.0
    a_php = 0.0
!print*, '++++++++++++++++++++++++++++++++++++++++++++++002++++++++++++++++++++++++++++++++++++++++++++++++++'
!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
cfn = grid%cfn
cfn1 = grid%cfn1
epsts = grid%epsts
step_number = grid%step_number
rdx = grid%rdx
rdy = grid%rdy
cf1 = grid%cf1
cf2 = grid%cf2
cf3 = grid%cf3
dtbc = grid%dtbc
dx = grid%dx
dy = grid%dy
dt = grid%dt
rk_ord = grid%rk_ord
diff_opt = grid%diff_opt
damp_opt = grid%damp_opt
zdamp = grid%zdamp
dampcoef = grid%dampcoef
khdif = grid%khdif
kvdif = grid%kvdif
smdiv = grid%smdiv
emdiv = grid%emdiv
epssm = grid%epssm

non_hydrostatic = grid%non_hydrostatic
time_step_sound = grid%time_step_sound
kh_tke_upper_bound = grid%kh_tke_upper_bound
spec_bdy_width = grid%spec_bdy_width
spec_zone = grid%spec_zone
relax_zone = grid%relax_zone

k_start = kps
k_end = kpe

ijds = min(ids,jds)
ijde = max(ide,jde)

num_3d_m = num_moist
num_3d_c        = num_chem    !by walls

!  Compute these starting and stopping locations for each tile and number of tiles.
!  See: http://www.mmm.ucar.edu/wrf/WG2/topics/settiles

  call set_tiles( grid,ids,ide,jds,jde,ips,ipe,jps,jpe )
  if ( grid%num_tiles > 1 ) call wrf_error_fatal( "Adjoint code is not thread safe" )

  itimestep = itimestep + 1  !by walls

#ifdef DM_PARALLEL
    if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#   include "HALO_EM_INIT_1.inc"
#   include "HALO_EM_INIT_2.inc"
#   include "HALO_EM_INIT_3.inc"
#   include "HALO_EM_INIT_4.inc"
#   include "HALO_EM_INIT_5.inc"
#   include "HALO_EM_AD_INIT_1.inc"
#   include "HALO_EM_AD_INIT_2.inc"
#   include "HALO_EM_AD_INIT_3.inc"
#   include "HALO_EM_AD_INIT_5.inc"
    if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

  rk_order = config_flags%rk_ord
  leapfrog =  .false. 

  dts = dt/float(time_step_sound)

  IF(rk_ord == 1) leapfrog = .true.

!-if(grid%trace_use) call trace_entry("solve_ad_runge_kutta_looq")
!------------------------------

!print*, '++++++++++++++++++++++++++++++++++++++++++++++003++++++++++++++++++++++++++++++++++++++++++++++++++'
 runge_kutta_looq: do rk_step = 1, rk_order
  dtm=dt
  if (rk_order .eq. 1) then
    if (step_number .ne. 1) then
      number_of_small_timesteps = 2*time_step_sound
      dt_rk = dt
      dtm=2*dt
    else
      number_of_small_timesteps = time_step_sound
      dt_rk = dt/2.
      dtm=dt
    endif
    dts_rk = dts
  else if (rk_order .eq. 2) then
    if (rk_step .eq. 1) then
      dt_rk = 0.5*dt
      dts_rk = dts
      number_of_small_timesteps = time_step_sound/2
    else
      dt_rk = dt
      dts_rk = dts
      number_of_small_timesteps = time_step_sound
    endif
  else if (rk_order .eq. 3) then
    if (rk_step .eq. 1) then
      dt_rk = dt/3.
      dts_rk = dt_rk
      number_of_small_timesteps = 1
    else if (rk_step .eq. 2) then
      dt_rk = 0.5*dt
      dts_rk = dts
      number_of_small_timesteps = time_step_sound/2
    else
      dt_rk = dt
      dts_rk = dts
      number_of_small_timesteps = time_step_sound
    endif
  else  !by walls
      write(wrf_err_message,*)' unknown solver, error exit for dynamics_option = ',dynamics_option  !by walls
      CALL wrf_error_fatal( wrf_err_message )  !by walls
  endif

!---Save for rk_step_prep
    if(grid%trace_use) call trace_entry("backup")
    call push4backup(muu,muv, "muu,muv")
    if(grid%trace_use) call trace_exit("backup")

!print*, '++++++++++++++++++++++++++++++++++++++++++++++004++++++++++++++++++++++++++++++++++++++++++++++++++'
!---From: module_em.F
    call rk_step_prep( config_flags,rk_step,u_2,v_2,w_2,t_2,ph_2,mu_2,moist_2, &
                       ru,rv,rw,ww,php,alt,muu,muv,mub,mut,phb,pb,p,al,alb,&
                       cqu,cqv,cqw,msfu,msfv,msft,fnm,fnp,dnw,rdx,rdy,num_3d_m, &
                       ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme, &
                       grid%i_start(ij),grid%i_end(ij), &
                       grid%j_start(ij),grid%j_end(ij), &
                       k_start,k_end )

!-----Output: ru,rv,rw,ww,php,cqu,cqv,cqw,alt,muu,muv,mut

#ifdef DM_PARALLEL
#    include "HALO_EM_A.inc"     
#  include "PERIOD_BDY_EM_A.inc" 
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_RK_STEP_PREP.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!by walls
   if(dyn_opt == DYN_EM) then
   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

!print*, '++++++++++++++++++++++++++++++++++++++++++++++005++++++++++++++++++++++++++++++++++++++++++++++++++'
!      CALL wrf_debug ( 200 , ' call rk_phys_bc_dry_1' )
       CALL rk_phys_bc_dry_1( config_flags, ru, rv, rw, ww,      &
                               muu, muv, mut, php, alt, p,        &
                               ids, ide, jds, jde, kds, kde,      &
                               ims, ime, jms, jme, kms, kme,      &
                               ips, ipe, jps, jpe, kps, kpe,      &
                               grid%i_start(ij), grid%i_end(ij),  &
                               grid%j_start(ij), grid%j_end(ij),  &
                               k_start, k_end                )

       CALL set_physical_bc3d( ph_2, 'w', config_flags,            &
                                 ids, ide, jds, jde, kds, kde, &
                                 ims, ime, jms, jme, kms, kme, &
                                 ips, ipe, jps, jpe, kps, kpe, &
                               grid%i_start(ij), grid%i_end(ij),        &
                               grid%j_start(ij), grid%j_end(ij),        &
                               k_start, k_end                )

   endif
!by walls

  rk_step_is_ong: if (rk_step .eq. 1) then

!print*, '++++++++++++++++++++++++++++++++++++++++++++++006++++++++++++++++++++++++++++++++++++++++++++++++++'
  call init_zero_tendency( ru_tendf,rv_tendf,rw_tendf,ph_tendf,t_tendf,tke_tend,moist_tend,chem_tend, &
                           num_3d_m,num_3d_c,rk_step,&
                           ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme, &
                           grid%i_start(ij),grid%i_end(ij), &
                           grid%j_start(ij),grid%j_end(ij), &
                           k_start,k_end )

!by walls
#ifdef DM_PARALLEL
      if(dyn_opt == DYN_EM) then
#     include "HALO_EM_PHYS_A.inc"
      endif
#endif
!by walls

!-Save for: phy_prep:
  if(grid%trace_use) call trace_entry("backup")
  call push4backup(z, "z")
  if(grid%trace_use) call trace_exit("backup")

!-From module_big_step_utilities_em.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++007++++++++++++++++++++++++++++++++++++++++++++++++++'
  call phy_prep( config_flags,mut,u_2,v_2,p,pb,alt,ph_2,phb,t_2,tsk,moist_2,num_3d_m,mu_3d,rho, &
                 th_phy,p_phy,pi_phy,u_phy,v_phy,p8w,t_phy,t8w,z,z_at_w,dz8w,fnm,fnp, &
                 rthraten,rthblten,rublten,rvblten,rqvblten,rqcblten,rqiblten,rthcuten, &
                 rqvcuten,rqccuten,rqrcuten,rqicuten,rqscuten,rthften,rqvften, &
                 ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme, &
                 grid%i_start(ij),grid%i_end(ij), &
                 grid%j_start(ij),grid%j_end(ij), &
                 k_start,k_end )

!-Output: th_phy,p_phy,pi_phy,u_phy,v_phy,p8w,t_phy,t8w,z,z_at_w,dz8w,mu_3d,rho
!         rthraten,rthblten,rublten,rvblten,rqvblten,rqcblten,rqiblten,rthcuten
!         rqvcuten,rqccuten,rqrcuten,rqicuten,rqscuten,rthften,rqvften

!by walls
         if(dyn_opt == DYN_EM) then
!print*, '++++++++++++++++++++++++++++++++++++++++++++++008++++++++++++++++++++++++++++++++++++++++++++++++++'
         CALL radiation_driver(itimestep,dt,AER_DRY,AER_WATER,       &
                    RTHRATENLW,RTHRATENSW,RTHRATEN,GLW,GSW,          &
                    SWDOWN,                                          &
                    XLAT,XLONG,ALBEDO,CLDFRA,EMISS,                  &
                    rho,moist_2,num_3d_m,                            &
                    p8w,p_phy,pb,pi_phy,dz8w,t_phy,t8w,              &
                    GMT,JULDAY,config_flags,RADT,STEPRA,ICLOUD,      &
                    taucldi,taucldc,warm_rain,                       &
                    XLAND,TSK,HTOP,HBOT,CUPPT,VEGFRA,SNOW,           &
                    julyr,                                           &
                    1   ,                                            &
                    TOTSWDN,TOTLWDN,RSWTOA,RLWTOA,CZMEAN,            &
                    CFRACL,CFRACM,CFRACH,                            &
                    ACFRST,NCFRST,ACFRCV,NCFRCV,                     &
                    ids,ide, jds,jde, kds,kde,                       &
                    ims,ime, jms,jme, kms,kme,                       &
                    grid%i_start, min(grid%i_end, ide-1),            &
                    grid%j_start, min(grid%j_end, jde-1),            &
                    k_start    , min(k_end,kde-1) , grid%num_tiles   )
         endif

!print*, '++++++++++++++++++++++++++++++++++++++++++++++009++++++++++++++++++++++++++++++++++++++++++++++++++'
      if(dyn_opt == DYN_EM) then
      CALL wrf_debug ( 200 , ' call surface_driver' )
      CALL surface_driver(                                          &
     &           ACSNOM,ACSNOW,AKHS,AKMS,ALBEDO,BR,CANWAT,CAPG        &
     &          ,CHKLOWQ,CONFIG_FLAGS,DT,DX,DZ8W,DZS,EMISS,GLW        &
     &          ,GRDFLX,GSW,GZ1OZ0,HFX,HOL,HT,IFSNOW,ISFFLX           &
     &          ,ISLTYP,ITIMESTEP,IVGTYP,LOWLYR,MAVAIL,MOIST_2,MOL,RMOL&
     &          ,NUM_SOIL_LAYERS,NUM_3D_M,P8W,PBLH,PI_PHY,PSHLTR,PSIH &
     &          ,PSIM,P_PHY,Q10,Q2,QFX,QSFC,QSHLTR,QZ0,RAINBL         &
     &          ,RAINCV,RAINNCV,REGIME,RHO,SFCEVP,SFCEXC,SFCRUNOFF    &
     &          ,SMOIS,SMSTAV,SMSTOT,SNOALB,SNOW,SNOWC,SNOWH,STEPBL   &
     &          ,T2,TH10,TH2,THC,THZ0,TH_PHY,TMN,TSHLTR,TSK,TSLB      &
     &          ,T_PHY,U10,UDRUNOFF,UST,UZ0,U_FRAME,U_PHY,V10,VEGFRA  &
     &          ,VZ0,V_FRAME,V_PHY,WARM_RAIN,WSPD,XICE,XLAND,Z,ZNT,ZS &
     &          ,CT,TKE_MYJ                                           &
     &          ,ALBBCK,LH,SH2O,SHDMAX,SHDMIN,Z0                      &
     &          ,flqc,flhc,qsg,qvg,qcg,soilt1,tsnav                   & ! for RUC LSM
     &          ,SMFR3D,KEEPFR3DFLAG                                  &
     &          ,PSFC                                                 &
     &          ,ids,ide, jds,jde, kds,kde                            &
     &          ,ims,ime, jms,jme, kms,kme                            &
     &          ,grid%i_start, min(grid%i_end, ide-1)                 &
     &          ,grid%j_start, min(grid%j_end, jde-1)                 &
     &          ,k_start    , min(k_end,kde-1) , grid%num_tiles       )
      endif

!print*, '++++++++++++++++++++++++++++++++++++++++++++++010++++++++++++++++++++++++++++++++++++++++++++++++++'
      if(dyn_opt == DYN_EM) then
      CALL wrf_debug ( 200 , ' call pbl_driver' )
      CALL pbl_driver(itimestep,dt,u_frame,v_frame                    &
     &           ,RUBLTEN,RVBLTEN,RTHBLTEN                            &
     &           ,RQVBLTEN,RQCBLTEN,RQIBLTEN                          &
     &           ,TSK,XLAND,ZNT,HT                                    &
     &           ,UST,HOL,MOL,PBLH                                    &
     &           ,HFX,QFX,REGIME,GRDFLX                               &
     &           ,u_phy,v_phy,th_phy,rho,moist_2                      &
     &           ,p_phy,pi_phy,p8w,t_phy,dz8w,z                       &
     &           ,TKE_MYJ,EXCH_H,AKHS,AKMS                            &
     &           ,THZ0,QZ0,UZ0,VZ0,QSFC,LOWLYR                        &
     &           ,PSIM, PSIH, GZ1OZ0, WSPD, BR, CHKLOWQ               &
     &           ,config_flags,DX,num_3d_m                            &
     &           ,STEPBL,warm_rain                                    &
     &           ,KPBL,CT,LH,SNOW,XICE                                &
     &           ,ids,ide, jds,jde, kds,kde                           &
     &           ,ims,ime, jms,jme, kms,kme                           &
     &           ,grid%i_start, min(grid%i_end,ide-1)                 &
     &           ,grid%j_start, min(grid%j_end,jde-1)                 &
     &           ,k_start    , min(k_end,kde-1) , grid%num_tiles  )
      endif

!print*, '++++++++++++++++++++++++++++++++++++++++++++++011++++++++++++++++++++++++++++++++++++++++++++++++++'
        if(dyn_opt == DYN_EM) then
         CALL wrf_debug ( 200 , ' call cumulus_driver' )
         CALL cumulus_driver(                                          &
                 ! Order dependent args: domain, mem, tile dims
                     ids,ide, jds,jde, kds,kde                         &
                   , ims,ime, jms,jme, kms,kme                         &
                   , grid%i_start, min(grid%i_end, ide-1)              &
                   , grid%j_start, min(grid%j_end, jde-1)              &
                   , k_start  , min(k_end,kde-1) , grid%num_tiles      &
                 ! Prognostic variables
                   , U=u_phy   ,V=v_phy   ,TH=th_phy  ,T=t_phy         &
                   , W=w_2     ,P=p_phy   ,PI=pi_phy  ,RHO=rho         &
                 ! Other arguments
                   , ITIMESTEP=itimestep ,DT=dt      ,DX=dx            &
                   , RAINC=rainc   ,RAINCV=raincv   ,NCA=nca           &
                   , HTOP=htop     ,HBOT=hbot       ,KPBL=kpbl         &
                   , DZ8W=dz8w     ,P8W=p8w                            &
                   , W0AVG=w0avg   ,STEPCU=stepcu                      &
                   , CLDEFI=cldefi ,LOWLYR=lowlyr ,XLAND=xland         &
                   , APR_GR=apr_gr ,APR_W=apr_w   ,APR_MC=apr_mc       &
                   , APR_ST=apr_st ,APR_AS=apr_as ,APR_CAPMA=apr_capma &
                   , APR_CAPME=apr_capme          ,APR_CAPMI=apr_capmi &
                   , MASS_FLUX=mass_flux          ,XF_ENS=xf_ens       &
                   , PR_ENS=pr_ens ,HT=ht                              &
                   , ENSDIM=ensdim ,MAXIENS=maxiens ,MAXENS=maxens     &
                   , MAXENS2=maxens2                ,MAXENS3=maxens3   &
                   , CU_ACT_FLAG=cu_act_flag   ,WARM_RAIN=warm_rain    &
                 ! Selection flag
                   , CU_PHYSICS=config_flags%cu_physics                &
                 ! Moisture tendency arguments
                   , RQVCUTEN=rqvcuten , RQCCUTEN=rqccuten             &
                   , RQRCUTEN=rqrcuten , RQVBLTEN=rqvblten             &
                   , RQVFTEN=rqvften                                   &
                 ! Other tendency arguments
                   , RTHRATEN=rthraten , RTHBLTEN=rthblten             &
                   , RTHCUTEN=rthcuten , RTHFTEN=rthften               &
                 ! Moisture tracer arguments
                   , QV_CURR=moist_2(ims,kms,jms,P_QV), F_QV=F_QV      &
                   , QC_CURR=moist_2(ims,kms,jms,P_QC), F_QC=F_QC      &
                   , QR_CURR=moist_2(ims,kms,jms,P_QR), F_QR=F_QR      &
                   , QI_CURR=moist_2(ims,kms,jms,P_QI), F_QI=F_QI      &
                   , QS_CURR=moist_2(ims,kms,jms,P_QS), F_QS=F_QS      &
                   , QG_CURR=moist_2(ims,kms,jms,P_QG), F_QG=F_QG      &
                                                                       )
         endif

!print*, '++++++++++++++++++++++++++++++++++++++++++++++012++++++++++++++++++++++++++++++++++++++++++++++++++'
         IF (cu_physics .eq. 5) then            !IF for CUDU
            CALL wrf_debug(100,'in du_cps')
               CALL DUCU(                                            &
               IDS=ids,IDE=ide,JDS=jds,JDE=jde,KDS=kds,KDE=kde &
               ,IMS=ims,IME=ime,JMS=jms,JME=jme,KMS=kms,KME=kme &
               ,ITS=grid%i_start(ij),ITE=min(grid%i_end(ij), ide-1)      &
               ,JTS=grid%j_start(ij),JTE= min(grid%j_end(ij), jde-1)    &
               ,KTS=k_start,KTE=min(k_end, kde-1) &
               ,DT=dt ,KTAU=itimestep ,DX=dx                    &
               ,RHO=rho,RAINCV=raincv, NCA=nca                  &
               ,U=u_phy ,V=v_phy ,TH=th_phy ,T=t_phy ,W=w_2    &
               ,DZ8W=dz8w               &
               ,Z=z, PCPS=p_phy, PI=pi_phy ,W0AVG=grid%W0AVG                 &
               ,XLV=XLV                                         &
               ,CP=CP ,RD=R_d ,RV=R_v ,G=G ,EP2=EP_2             &
               ,SVP1=SVP1 ,SVP2=SVP2 ,SVP3=SVP3 ,SVPT0=SVPT0    &
               ,STEPCU=stepcu                                   &
               ,CU_ACT_FLAG=cu_act_flag ,warm_rain=warm_rain    &
               ,CUTOP=HTOP,CUBOT=HBOT                           &
               ,QV=moist_2(ims,kms,jms,P_QV)                                                 &
              ! optionals
               ,RTHCUTEN=rthcuten                               &
               ,RQVCUTEN=rqvcuten                               &
                                                                )

               do j = grid%j_start(ij), min(grid%j_end(ij), jde-1)
               do i = grid%i_start(ij), min(grid%i_end(ij), ide-1)
                  do k = k_start, min(k_end, kde-1)
                     t_tendf(I,K,J) = t_tendf(I,K,J) + rthcuten(I,K,J) * mut(I,J)
                     moist_tend(I,K,J,P_QV) = moist_tend(I,K,J,P_QV) + rqvcuten(I,K,J) * mut(I,J)
                  end do
                  rainc(I,J) = rainc(I,J) + raincv(I,J)
               end do
               end do
         ENDIF

!print*, '++++++++++++++++++++++++++++++++++++++++++++++013++++++++++++++++++++++++++++++++++++++++++++++++++'
      if(dyn_opt == DYN_EM) then
          CALL wrf_debug ( 200 , ' call calculate_phy_tend' )
          CALL calculate_phy_tend (config_flags,mut,pi_phy,            &
                     RTHRATEN,                                         &
                     RUBLTEN,RVBLTEN,RTHBLTEN,                         &
                     RQVBLTEN,RQCBLTEN,RQIBLTEN,                       &
                     RTHCUTEN,RQVCUTEN,RQCCUTEN,RQRCUTEN,              &
                     RQICUTEN,RQSCUTEN,                                &
                     ids,ide, jds,jde, kds,kde,                        &
                     ims,ime, jms,jme, kms,kme,                        &
                     grid%i_start(ij), min(grid%i_end(ij),ide-1),      &
                     grid%j_start(ij), min(grid%j_end(ij),jde-1),      &
                     k_start    , min(k_end,kde-1)                     )
      endif

!print*, '++++++++++++++++++++++++++++++++++++++++++++++014++++++++++++++++++++++++++++++++++++++++++++++++++'
IF(diff_opt .eq. 2 .OR. diff_opt .eq. 1) THEN

          CALL wrf_debug ( 200 , ' call compute_diff_metrics ' )
          CALL compute_diff_metrics ( config_flags, ph_2, phb, z, rdz, rdzw, &
                                      zx, zy, rdx, rdy,                      &
                                      ids, ide, jds, jde, kds, kde,          &
                                      ims, ime, jms, jme, kms, kme,          &
                                      grid%i_start(ij), grid%i_end(ij),      &
                                      grid%j_start(ij), grid%j_end(ij),      &
                                      k_start    , k_end                    )
#ifdef DM_PARALLEL
       if(dyn_opt == DYN_EM) then
#  include "PERIOD_BDY_EM_A1.inc"
       endif
#endif

!print*, '++++++++++++++++++++++++++++++++++++++++++++++015++++++++++++++++++++++++++++++++++++++++++++++++++'
       if(dyn_opt == DYN_EM) then

          CALL wrf_debug ( 200 , ' call bc for diffusion_metrics ' )
          CALL set_physical_bc3d( rdzw , 'w', config_flags,           &
                                  ids, ide, jds, jde, kds, kde,       &
                                  ims, ime, jms, jme, kms, kme,       &
                                  ips, ipe, jps, jpe, kps, kpe,       &
                                  grid%i_start(ij), grid%i_end(ij),   &
                                  grid%j_start(ij), grid%j_end(ij),   &
                                  k_start    , k_end                 )
          CALL set_physical_bc3d( rdz , 'w', config_flags,           &
                                  ids, ide, jds, jde, kds, kde,       &
                                  ims, ime, jms, jme, kms, kme,       &
                                  ips, ipe, jps, jpe, kps, kpe,       &
                                  grid%i_start(ij), grid%i_end(ij),   &
                                  grid%j_start(ij), grid%j_end(ij),   &
                                  k_start    , k_end                 )
          CALL set_physical_bc3d( z , 'w', config_flags,           &
                                  ids, ide, jds, jde, kds, kde,       &
                                  ims, ime, jms, jme, kms, kme,       &
                                  ips, ipe, jps, jpe, kps, kpe,       &
                                  grid%i_start(ij), grid%i_end(ij),   &
                                  grid%j_start(ij), grid%j_end(ij),   &
                                  k_start    , k_end                 )
          CALL set_physical_bc3d( zx , 'w', config_flags,           &
                                  ids, ide, jds, jde, kds, kde,       &
                                  ims, ime, jms, jme, kms, kme,       &
                                  ips, ipe, jps, jpe, kps, kpe,       &
                                  grid%i_start(ij), grid%i_end(ij),   &
                                  grid%j_start(ij), grid%j_end(ij),   &
                                  k_start    , k_end                 )
          CALL set_physical_bc3d( zy , 'w', config_flags,           &
                                  ids, ide, jds, jde, kds, kde,       &
                                  ims, ime, jms, jme, kms, kme,       &
                                  ips, ipe, jps, jpe, kps, kpe,       &
                                  grid%i_start(ij), grid%i_end(ij),   &
                                  grid%j_start(ij), grid%j_end(ij),   &
                                  k_start    , k_end                 )
       endif

#ifdef DM_PARALLEL
       if(dyn_opt == DYN_EM) then
#     include "HALO_EM_TKE_C.inc"
       endif
#endif

!print*, '++++++++++++++++++++++++++++++++++++++++++++++016++++++++++++++++++++++++++++++++++++++++++++++++++'
       if(dyn_opt == DYN_EM) then

          CALL wrf_debug ( 200 , ' call cal_deform_and_div' )
          CALL cal_deform_and_div ( config_flags,u_2,v_2,w_2,div,        &
                                    defor11,defor22,defor33,defor12,     &
                                    defor13,defor23,                     &
                                    u_base, v_base,msfu,msfv,msft,       &
                                    rdx, rdy, dn, dnw, rdz, rdzw,        &
                                    fnm,fnp,cf1,cf2,cf3,zx,zy,           &
                                    ids, ide, jds, jde, kds, kde,        &
                                    ims, ime, jms, jme, kms, kme,        &
                                    grid%i_start(ij), grid%i_end(ij),    &
                                    grid%j_start(ij), grid%j_end(ij),    &
                                    k_start    , k_end                  )
       endif


#ifdef DM_PARALLEL
       if(dyn_opt == DYN_EM) then
#     include "HALO_EM_TKE_D.inc"
       endif
#endif

!by walls

#ifdef DM_PARALLEL
  if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_PHY_PREP.inc"
  if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!   if (diff_opt .eq. 2 .or. diff_opt .eq. 1) then  !by walls
!---Save for calculate_km_kh:

!print*, '++++++++++++++++++++++++++++++++++++++++++++++017++++++++++++++++++++++++++++++++++++++++++++++++++'
!---From: module_diffusion_em.F
    call calculate_km_kh( config_flags,dt,dampcoef,zdamp,damp_opt,xkmh,xkmhd,xkmv,xkhh,xkhv,bn2, &
                          khdif,kvdif,div,defor11,defor22,defor33,defor12,defor13,defor23, &
                          tke_2,p8w,t8w,th_phy,t_phy,p_phy,moist_2,dn,dnw,dx,dy,rdz,rdzw, &
                          mix_cr_len,num_3d_m,cf1,cf2,cf3,warm_rain,kh_tke_upper_bound,kv_tke_upper_bound, &
                          ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme, &
                          grid%i_start(ij),grid%i_end(ij), &
                          grid%j_start(ij),grid%j_end(ij), &
                          k_start,k_end )

!---Output: moist_2, xkmv, xkmh, xkmhd, xkhv, xkhh, bn2, tke_2

#ifdef DM_PARALLEL
    if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_CALCULATE_KM_KH.inc"
    if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!by walls
#ifdef DM_PARALLEL
       if(dyn_opt == DYN_EM) then
#     include "HALO_EM_TKE_E.inc"
       endif
#endif

     ENDIF

#ifdef DM_PARALLEL
       if(dyn_opt == DYN_EM) then
#      include "PERIOD_BDY_EM_PHY_BC.inc"
#      include "PERIOD_BDY_EM_CHEM.inc"
       endif
#endif
!by walls

! endif  !by walls


!print*, '++++++++++++++++++++++++++++++++++++++++++++++018++++++++++++++++++++++++++++++++++++++++++++++++++'
!by walls
     if(dyn_opt == DYN_EM) then

       CALL wrf_debug ( 200 , ' call phy_bc' )
       CALL phy_bc (config_flags,div,defor11,defor22,defor33,            &
                            defor12,defor13,defor23,                     &
                            xkmh,xkmhd,xkmv,xkhh,xkhv,                   &   
                            tke_2(ims,kms,jms),                          &
                            RUBLTEN, RVBLTEN,                            &
                            ids, ide, jds, jde, kds, kde,                &
                            ims, ime, jms, jme, kms, kme,                &
                            ips, ipe, jps, jpe, kps, kpe,                &
                            grid%i_start(ij), grid%i_end(ij),                      &
                            grid%j_start(ij), grid%j_end(ij),                      &
                            k_start    , k_end                           )
     endif


#ifdef DM_PARALLEL
!-----------------------------------------------------------------------
!
! MPP for some physics tendency, km, kh, deformation, and divergence
!
!               *                     *
!             * + *      * + *        +
!               *                     *
!
! (for PBL)
! RUBLTEN                  x
! RVBLTEN                             x
!
! (for diff_opt >= 1)
! defor11                  x
! defor22                             x
! defor12       x
! defor13                  x
! defor23                             x
! div           x
! xkmv          x
! xkmh          x
! xkmhd         x
! xkhv          x
! xkhh          x
! tke           x
!
!-----------------------------------------------------------------------
      IF ( bl_pbl_physics .ge. 1 ) THEN
#      include "HALO_EM_PHYS_PBL.inc"
      ENDIF
      IF ( diff_opt .ge. 1 ) THEN
#      include "HALO_EM_PHYS_DIFFUSION.inc"
      ENDIF

      IF      ( h_mom_adv_order <= 4 ) THEN
#       include "HALO_EM_TKE_3.inc"
      ELSE IF ( h_mom_adv_order <= 6 ) THEN
#       include "HALO_EM_TKE_5.inc"
      ELSE
        WRITE(wrf_err_message,*)'solve_em: invalid h_mom_adv_order = ',h_mom_adv_order
        CALL wrf_error_fatal(TRIM(wrf_err_message))
      ENDIF
#endif


!print*, '++++++++++++++++++++++++++++++++++++++++++++++019++++++++++++++++++++++++++++++++++++++++++++++++++'
      if(dyn_opt == DYN_EM) then

        CALL wrf_debug ( 200 , ' call update_phy_ten' )
        CALL update_phy_ten(t_tendf, ru_tendf, rv_tendf,moist_tend,        &
                          RTHRATEN,RTHBLTEN,RTHCUTEN,RUBLTEN,RVBLTEN,  &
                          RQVBLTEN,RQCBLTEN,RQIBLTEN,                  &
                          RQVCUTEN,RQCCUTEN,RQRCUTEN,RQICUTEN,RQSCUTEN,&
                          num_3d_m,config_flags,rk_step,              &
                          ids, ide, jds, jde, kds, kde,                &
                          ims, ime, jms, jme, kms, kme,                &
                          grid%i_start(ij), grid%i_end(ij),                      &
                          grid%j_start(ij), grid%j_end(ij),                      &
                          k_start, k_end                               )
      endif


     IF( diff_opt .eq. 2 .and. km_opt .eq. 2 ) THEN

       if(dyn_opt == DYN_EM) then

          CALL tke_rhs  ( tke_tend,BN2,                               &
                          config_flags,defor11,defor22,defor33,       &
                          defor12,defor13,defor23,u_2,v_2,w_2,div,    &
                          tke_2(ims,kms,jms),mut,                     &
                          th_phy,p_phy,p8w,t8w,z,fnm,fnp,             &
                          cf1,cf2,cf3,msft,xkmh,xkmv,xkhv,rdx,rdy,    &
                          dx,dy,dt,zx,zy,rdz,rdzw,dn,dnw,mix_cr_len,  &
                          ids, ide, jds, jde, kds, kde,               &
                          ims, ime, jms, jme, kms, kme,               &
                          grid%i_start(ij), grid%i_end(ij),           &
                          grid%j_start(ij), grid%j_end(ij),           &
                          k_start    , k_end                         )

       endif
     ENDIF




! calculate vertical diffusion first and then horizontal
! (keep this order)

     IF(diff_opt .eq. 2) THEN
       IF (bl_pbl_physics .eq. 0) THEN


         if(dyn_opt == DYN_EM) then

           CALL wrf_debug ( 200 , ' call vertical_diffusion_2 ' )
           CALL vertical_diffusion_2( ru_tendf, rv_tendf, rw_tendf,              &
                                      t_tendf, tke_tend,                         &
                                      moist_tend, num_3d_m,                      &
                                      chem_tend, num_3d_c,                       &
                                      u_2, v_2,                                  &
                                      t_2,u_base,v_base,t_base,qv_base,          &
                                      mut,tke_2,config_flags,                    &
                                      defor13,defor23,defor33,                   &
                                      div, moist_2, chem_2, xkmv, xkhv, km_opt,  &
                                      fnm, fnp, dn, dnw, rdz, rdzw,              &
                                      ids, ide, jds, jde, kds, kde,              &
                                      ims, ime, jms, jme, kms, kme,              &
                                      grid%i_start(ij), grid%i_end(ij),          &
                                      grid%j_start(ij), grid%j_end(ij),          &
                                      k_start    , k_end                        )

         endif

       ENDIF


!print*, '++++++++++++++++++++++++++++++++++++++++++++++020++++++++++++++++++++++++++++++++++++++++++++++++++'
       if(dyn_opt == DYN_EM) then
         CALL wrf_debug ( 200 , ' call horizontal_diffusion_2' )
         CALL horizontal_diffusion_2( t_tendf, ru_tendf, rv_tendf, rw_tendf, &
                                      tke_tend,                              &
                                      moist_tend, num_3d_m,                  &
                                      chem_tend, num_3d_c,                   &
                                      t_2, th_phy,                           &
                                      mut, tke_2, config_flags,              &
                                      defor11, defor22, defor12,             &
                                      defor13, defor23, div,                 &
                                      moist_2, chem_2,                       &
                                      msfu, msfv, msft, xkmhd, xkhh, km_opt, &
                                      rdx, rdy, rdz, rdzw,                   &
                                      fnm, fnp, cf1, cf2, cf3,               &
                                      zx, zy, dn, dnw,                       &
                                      ids, ide, jds, jde, kds, kde,          &
                                      ims, ime, jms, jme, kms, kme,          &
                                      grid%i_start(ij), grid%i_end(ij),      &
                                      grid%j_start(ij), grid%j_end(ij),      &
                                      k_start    , k_end                    )
       endif

     ENDIF

!by walls

  endif rk_step_is_ong


!---Save for rk_tendency
    if(grid%trace_use) call trace_entry("backup")
    call push4backup(ru,rv,rw,ww,al, "ru,rv,rw,ww,al")
    call push4backup(cqu,cqv,cqw, "cqu,cqv,cqw")
    call push4backup(mu_2, "mu_2")
    if(grid%trace_use) call trace_exit("backup")

!---From: module_em.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++021++++++++++++++++++++++++++++++++++++++++++++++++++'
    call rk_tendency( config_flags,rk_step,ru_tend,rv_tend,rw_tend,ph_tend,t_tend, &
                      ru_tendf,rv_tendf,rw_tendf,ph_tendf,t_tendf,mu_tend, &
                      u_save,v_save,w_save,ph_save,t_save,mu_save,rthften,ru,rv,rw,ww, &
                      u_2,v_2,w_2,t_2,ph_2,u_1,v_1,w_1,t_1,ph_1,h_diabatic,phb,t_init, &
                      mu_2,mut,muu,muv,mub,al,alt,p,pb,php,cqu,cqv,cqw, &
                      u_base,v_base,t_base,qv_base,z_base, &
                      msfu,msfv,msft,f,e,sina,cosa,fnm,fnp,rdn,rdnw,dt,rdx,rdy, &
                      khdif,kvdif,xkmhd,cf1,cf2,cf3,cfn,cfn1,num_3d_m,non_hydrostatic,leapfrog, &
                      ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme, &
                      grid%i_start(ij),grid%i_end(ij), &
                      grid%j_start(ij),grid%j_end(ij), &
                      k_start,k_end )

!-----Output: ru_tend,rv_tend,rw_tend,ph_tend,t_tend,rthften
!             u_save,v_save,w_save,ph_save,t_save,mu_save
!             ru_tendf,rv_tendf,rw_tendf,ph_tendf,t_tendf,mu_tend,cqw

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_RK_TENDENCY.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!  IF (rk_step == 1 ) then
!      CALL surface_drag (ru_tendf, rv_tendf, u_2, v_2, xland,             &    
!                         muu, muv,z,z_at_w,&
!                         ids, ide, jds, jde, kds, kde,                    &    
!                         ims, ime, jms, jme, kms, kme,                    &    
!                         grid%i_start(ij), grid%i_end(ij),                &    
!                         grid%j_start(ij), grid%j_end(ij),                &    
!                         k_start, k_end                                  )    
!
! ENDIF

  if( (config_flags%specified .or. config_flags%nested) .and. rk_step==1 ) then
!-----Save for relax_bdy_dry
!-----From: module_bc_em.F
      call relax_bdy_dry( config_flags,u_save,v_save,ph_save,t_save,w_save,mu_tend, &
                          ru,rv,ph_2,t_2,w_2,mu_2,mut,u_b,v_b,ph_b,t_b,w_b,mu_b, &
                          u_bt,v_bt,ph_bt,t_bt,w_bt,mu_bt, &
                          spec_bdy_width,spec_zone,relax_zone,dtbc,fcx,gcx,ijds,ijde, &
                          ids,ide, jds,jde, kds,kde,  &
                          ims,ime, jms,jme, kms,kme,  &
                          ips,ipe, jps,jpe, kps,kpe,  &
                          grid%i_start(ij),grid%i_end(ij), &
                          grid%j_start(ij),grid%j_end(ij), &
                          k_start,k_end )

!-----Output: u_save,v_save,ph_save,t_save,w_save,mu_tend

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_RELAX_BDY_DRY.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

  endif

!print*, '++++++++++++++++++++++++++++++++++++++++++++++022++++++++++++++++++++++++++++++++++++++++++++++++++'
!---Save for rk_addtend_dry:
!---From: module_em.F
    call rk_addtend_dry( ru_tend,rv_tend,rw_tend,ph_tend,t_tend, &
                         ru_tendf,rv_tendf,rw_tendf,ph_tendf,t_tendf, &
                         u_save,v_save,w_save,ph_save,t_save, &
                         rk_step,h_diabatic,mut,msft,msfu,msfv, &
                         ids,ide, jds,jde, kds,kde,  &
                         ims,ime, jms,jme, kms,kme,  &
                         ips,ipe, jps,jpe, kps,kpe,  &
                         grid%i_start(ij),grid%i_end(ij), &
                         grid%j_start(ij),grid%j_end(ij), &
                         k_start,k_end )

!-----Output: ru_tend,rv_tend,rw_tend,ph_tend,t_tend, ru_tendf,rv_tendf,rw_tendf,ph_tendf,t_tendf

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_RK_ADDTEND_DRY.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

    if (config_flags%specified .or. config_flags%nested) then
!-----From: module_bc_em.F
      call spec_bdy_dry( config_flags,ru_tend,rv_tend,ph_tend,t_tend,rw_tend,mu_tend, &
                         u_b,v_b,ph_b,t_b,w_b,mu_b,u_bt,v_bt,ph_bt,t_bt,w_bt,mu_bt, &
                         spec_bdy_width,spec_zone,ijds,ijde, &
                         ids,ide, jds,jde, kds,kde,  &
                         ims,ime, jms,jme, kms,kme,  &
                         ips,ipe, jps,jpe, kps,kpe,  &
                         grid%i_start(ij),grid%i_end(ij), &
                         grid%j_start(ij),grid%j_end(ij), &
                         k_start,k_end )

!-----Output: ru_tend,rv_tend,ph_tend,t_tend,rw_tend,mu_tend

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_SPEC_BDY_DRY.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
    endif

!---Save for small_step_prep
    if(grid%trace_use) call trace_entry("backup")
    call push4backup(u_1,u_2,v_1,v_2,w_1,w_2,t_1,t_2,ph_2, &
                    "u_1,u_2,v_1,v_2,w_1,w_2,t_1,t_2,ph_2")
    call push4backup(p, "p")
    call push4backup(mu_1,mu_2,muu,muv,mut, "mu_1,mu_2,muu,muv,mut")
    if(grid%trace_use) call trace_exit("backup")

!---From: module_small_step_em.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++023++++++++++++++++++++++++++++++++++++++++++++++++++'
    call small_step_prep( u_1,u_2,v_1,v_2,w_1,w_2,t_1,t_2,ph_1,ph_2, &
                          mub,mu_1,mu_2,muu,muus,muv,muvs,mut,muts,mudf, &
                          u_save,v_save,w_save,t_save,ph_save,mu_save,ww,ww1, &
                          dnw,c2a,pb,p,alt,msfu,msfv,msft,rk_step,leapfrog, &
                          ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme, &
                          grid%i_start(ij),grid%i_end(ij), &
                          grid%j_start(ij),grid%j_end(ij), &
                          k_start,k_end )

!-----Output: u_1,u_2,v_1,v_2,w_1,w_2,t_1,t_2,ph_1,ph_2,
!             mu_1,mu_2,muu,muus,muv,muvs,mut,muts,mudf,
!             u_save,v_save,w_save,t_save,ph_save,mu_save,ww

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_SMALL_STEP_PREP.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!---Save for calc_p_rho:
    if(grid%trace_use) call trace_entry("backup")
    call push4backup(ph_2,t_2, "ph_2,t_2")
    call push4backup(muts, "muts")
    if(grid%trace_use) call trace_exit("backup")

!---From: module_small_step_em.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++024++++++++++++++++++++++++++++++++++++++++++++++++++'
    call calc_p_rho( al,p,ph_2,alt,t_2,t_save,c2a,pm1,mu_2,muts, &
                     znu,t0,rdnw,dnw,smdiv,non_hydrostatic,0, &
                     ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme, &
                     grid%i_start(ij),grid%i_end(ij), &
                     grid%j_start(ij),grid%j_end(ij), &
                     k_start,k_end )

!-----Output: al,p,ph_2,pm1

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_CALC_P_RHO.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

    if (non_hydrostatic) then
!-----Save for calc_coef_w:
!-----From: module_small_step_em.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++025++++++++++++++++++++++++++++++++++++++++++++++++++'
      call calc_coef_w( a,alpha,gamma,mut,cqw,rdn,rdnw,c2a,dts,g,epssm, &
                        ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme, &
                        grid%i_start(ij),grid%i_end(ij), &
                        grid%j_start(ij),grid%j_end(ij), &
                        k_start,k_end )

!-----Output: a,alpha,gamma

#ifdef DM_PARALLEL
#      include "HALO_EM_B.inc"   
#      include "PERIOD_BDY_EM_B.inc"   
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_CALC_COEF_W.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
    endif

!by walls
   if(dyn_opt == DYN_EM) then

         CALL set_physical_bc3d( ru_tend, 'u', config_flags,          &
                                 ids, ide, jds, jde, kds, kde, &
                                 ims, ime, jms, jme, kms, kme, &
                                 ips, ipe, jps, jpe, kps, kpe, &
                           grid%i_start(ij), grid%i_end(ij),                 &
                           grid%j_start(ij), grid%j_end(ij),                 &
                           k_start    , k_end                     )

         CALL set_physical_bc3d( rv_tend, 'v', config_flags,            &
                                 ids, ide, jds, jde, kds, kde, &
                                 ims, ime, jms, jme, kms, kme, &
                                 ips, ipe, jps, jpe, kps, kpe, &
                           grid%i_start(ij), grid%i_end(ij),                 &
                           grid%j_start(ij), grid%j_end(ij),                 &
                           k_start    , k_end                     )

         CALL set_physical_bc3d( ph_2, 'w', config_flags,          &
                                 ids, ide, jds, jde, kds, kde, &
                                 ims, ime, jms, jme, kms, kme, &
                                 ips, ipe, jps, jpe, kps, kpe, &
                           grid%i_start(ij), grid%i_end(ij),                 &
                           grid%j_start(ij), grid%j_end(ij),                 &
                           k_start    , k_end                     )

         CALL set_physical_bc3d( al, 'p', config_flags,            &
                                 ids, ide, jds, jde, kds, kde, &
                                 ims, ime, jms, jme, kms, kme, &
                                 ips, ipe, jps, jpe, kps, kpe, &
                           grid%i_start(ij), grid%i_end(ij),                 &
                           grid%j_start(ij), grid%j_end(ij),                 &
                           k_start    , k_end                     )

         CALL set_physical_bc3d( p, 'p', config_flags,             &
                                 ids, ide, jds, jde, kds, kde, &
                                 ims, ime, jms, jme, kms, kme, &
                                 ips, ipe, jps, jpe, kps, kpe, &
                           grid%i_start(ij), grid%i_end(ij),                 &
                           grid%j_start(ij), grid%j_end(ij),                 &
                           k_start    , k_end                     )

         CALL set_physical_bc3d( t_1, 'p', config_flags,             &
                                 ids, ide, jds, jde, kds, kde, &
                                 ims, ime, jms, jme, kms, kme, &
                                 ips, ipe, jps, jpe, kps, kpe, &
                           grid%i_start(ij), grid%i_end(ij),                 &
                           grid%j_start(ij), grid%j_end(ij),                 &
                           k_start    , k_end                     )

         CALL set_physical_bc3d( t_save, 't', config_flags,             &
                                 ids, ide, jds, jde, kds, kde, &
                                 ims, ime, jms, jme, kms, kme, &
                                 ips, ipe, jps, jpe, kps, kpe, &
                           grid%i_start(ij), grid%i_end(ij),                 &
                           grid%j_start(ij), grid%j_end(ij),                 &
                           k_start    , k_end                     )

         CALL set_physical_bc2d( mu_1, 't', config_flags,          &
                                 ids, ide, jds, jde,               &
                                 ims, ime, jms, jme,               &
                                 ips, ipe, jps, jpe,               &
                                 grid%i_start(ij), grid%i_end(ij), &
                                 grid%j_start(ij), grid%j_end(ij) )

         CALL set_physical_bc2d( mu_2, 't', config_flags,          &
                                 ids, ide, jds, jde,               &
                                 ims, ime, jms, jme,               &
                                 ips, ipe, jps, jpe,               &
                                 grid%i_start(ij), grid%i_end(ij), &
                                 grid%j_start(ij), grid%j_end(ij) )

         CALL set_physical_bc2d( mudf, 't', config_flags,          &
                                 ids, ide, jds, jde,               &
                                 ims, ime, jms, jme,               &
                                 ips, ipe, jps, jpe,               &
                                 grid%i_start(ij), grid%i_end(ij), &
                                 grid%j_start(ij), grid%j_end(ij) )

    endif
!by walls


!-if(grid%trace_use) call trace_entry("solve_ad_small_stepu")

!print*, '++++++++++++++++++++++++++++++++++++++++++++++026++++++++++++++++++++++++++++++++++++++++++++++++++'
  small_stepu: do iteration = 1, number_of_small_timesteps

      WRITE(wrf_err_message,*) 'DEBUG:  begin small_stepu, iteration = ',iteration
      CALL wrf_debug( 10, TRIM(wrf_err_message) )

!by walls
#ifdef DM_PARALLEL
#      include "PERIOD_BDY_EM_B.inc"
#endif
!by walls

!-----Save for advance_uv
      if(grid%trace_use) call trace_entry("backup")
      call push4backup(p,al, "p,al")
      call push4backup(mu_2, "mu_2")
      if(grid%trace_use) call trace_exit("backup")

!-----From: module_small_step_em.F
      call advance_uv( u_2,ru_tend,v_2,rv_tend,p,pb,ph_2,php,alt,al, &
                       mu_2,muu,cqu,muv,cqv,mudf,rdx,rdy,dts,cf1,cf2,cf3, &
                       fnm,fnp,emdiv,rdnw,config_flags,spec_zone,non_hydrostatic, &
                       ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme, &
                       grid%i_start(ij),grid%i_end(ij), &
                       grid%j_start(ij),grid%j_end(ij), &
                       k_start,k_end )

!-----Output: u_2,v_2,

!-----Combine this with spec_bdyupdate.
!ifdef DM_PARALLEL
!     if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
!include "HALO_ADVANCE_UV.inc"
!     if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
!endif

      if (config_flags%specified .or. config_flags%nested) then
!-------Save for spec_bdyupdate:
!-------From: ../share/module_bc.F
        call spec_bdyupdate( u_2,ru_tend,dts_rk,'u',config_flags,spec_zone, &
                             ids,ide,jds,jde,kds,kde, &
                             ims,ime,jms,jme,kms,kme, &
                             ips,ipe,jps,jpe,kps,kpe, &
                             grid%i_start(ij),grid%i_end(ij), &
                             grid%j_start(ij),grid%j_end(ij), &
                             k_start,k_end )
        call spec_bdyupdate( v_2,rv_tend,dts_rk,'v',config_flags,spec_zone, &
                             ids,ide,jds,jde,kds,kde, &
                             ims,ime,jms,jme,kms,kme, &
                             ips,ipe,jps,jpe,kps,kpe, &
                             grid%i_start(ij),grid%i_end(ij), &
                             grid%j_start(ij),grid%j_end(ij), &
                             k_start,k_end )
!-----Output: u_2,v_2

!print*, '++++++++++++++++++++++++++++++++++++++++++++++027++++++++++++++++++++++++++++++++++++++++++++++++++'
!ifdef DM_PARALLEL
!     if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
!include "HALO_SPEC_BDYUPDATE_UV.inc"
!     if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
!endif
      endif

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_ADVANCE_UV.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif


!by walls
#ifdef DM_PARALLEL
!
!  Stencils for patch communications  (WCS, 29 June 2001)
!
!         *                     *
!       * + *      * + *        +
!         *                     *
!
!  u_2               x
!  v_2                          x
!
#     include "HALO_EM_C.inc"
#endif
!by walls


!-----Save for advance_mu_t
!-----From: module_small_step_em.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-01A++++++++++++++++++++++++++++++++++++++++++++++++++'
      call advance_mu_t( ww,ww1,u_2,u_save,v_2,v_save,mu_2,mut,muave,muts,muu,muv,mudf, &
                         ru_m,rv_m,ww_m,t_2,t_save,t_2save,t_tend,mu_tend, &
                         rdx,rdy,dts,epssm,dnw,fnm,fnp,rdnw, &
                         msfu,msfv,msft,iteration,config_flags, &
                         ids,ide,jds,jde,kds,kde, &
                         ims,ime,jms,jme,kms,kme, &
                         grid%i_start(ij),grid%i_end(ij), &
                         grid%j_start(ij),grid%j_end(ij), &
                         k_start,k_end )
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-01B++++++++++++++++++++++++++++++++++++++++++++++++++'

!-----Output: ww,ww1,ru_m,rv_m,ww_m,t_2,t_2save,mu_2,muave,muts,mudf

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_ADVANCE_MU_T.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

      if (config_flags%specified .or. config_flags%nested) then
!-------Save for spec_bdyupdate:
!-------From: ../share/module_bc.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-02A++++++++++++++++++++++++++++++++++++++++++++++++++'
        call spec_bdyupdate( t_2,t_tend,dts_rk,'t',config_flags,spec_zone, &
                             ids,ide,jds,jde,kds,kde, &
                             ims,ime,jms,jme,kms,kme, &
                             ips,ipe,jps,jpe,kps,kpe, &
                             grid%i_start(ij),grid%i_end(ij), &
                             grid%j_start(ij),grid%j_end(ij), &
                             k_start,k_end )
        call spec_bdyupdate( mu_2,mu_tend,dts_rk,'m',config_flags,spec_zone, &
                             ids,ide,jds,jde,1,1, &
                             ims,ime,jms,jme,1,1, &
                             ips,ipe,jps,jpe,1,1, &
                             grid%i_start(ij),grid%i_end(ij), &
                             grid%j_start(ij),grid%j_end(ij),1,1 )
        call spec_bdyupdate( muts,mu_tend,dts_rk,'m',config_flags,spec_zone, &
                             ids,ide,jds,jde,1,1, &
                             ims,ime,jms,jme,1,1, &
                             ips,ipe,jps,jpe,1,1, &
                             grid%i_start(ij),grid%i_end(ij), &
                             grid%j_start(ij),grid%j_end(ij),1,1 )
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-02B++++++++++++++++++++++++++++++++++++++++++++++++++'

!-------Output: t_2, mu_2, muts

#ifdef DM_PARALLEL
        if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_SPEC_BDYUPDATE_TMU.inc"
        if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
      endif

!-----Save for sumflux
!-----From: module_small_step_em.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-03A++++++++++++++++++++++++++++++++++++++++++++++++++'
      call sumflux( u_2,v_2,ww,u_save,v_save,ww1,muu,muv, &
                    ru_m,rv_m,ww_m,epssm,msfu,msfv,iteration, &
                    number_of_small_timesteps,ids,&
                    ide,jds,jde,kds,kde, &
                    ims,ime,jms,jme,kms,kme, &
                    grid%i_start(ij),grid%i_end(ij), &
                    grid%j_start(ij),grid%j_end(ij), &
                    k_start,k_end )
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-03B++++++++++++++++++++++++++++++++++++++++++++++++++'

!-----Output: ru_m,rv_m,ww_m

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_SUMFLUX.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

      if (non_hydrostatic) then
!-------Save for advance_w:
        if(grid%trace_use) call trace_entry("backup")
        call push4backup(w_2,ww,u_2,v_2,t_2save, "w_2,ww,u_2,v_2,t_2save")
        call push4backup(ph_2,"ph_2")
        call push4backup(muave, "muave")
        if(grid%trace_use) call trace_exit("backup")

!-------From: module_small_step_em.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-04A++++++++++++++++++++++++++++++++++++++++++++++++++'
        call advance_w( w_2,rw_tend,ww,u_2,v_2,mu_2,mut,muave,muts, &
                        t_2save,t_2,t_save,ph_2,ph_save, &
                        phb,ph_tend,ht,c2a,cqw,alt,alb,a,alpha,gamma, &
                        rdx,rdy,dts,t0,epssm,dnw,fnm,fnp,rdnw,rdn, &
                        cf1,cf2,cf3,msft,config_flags, &
                        ids,ide,jds,jde,kds,kde, &
                        ims,ime,jms,jme,kms,kme, &
                        grid%i_start(ij),grid%i_end(ij), &
                        grid%j_start(ij),grid%j_end(ij), &
                        k_start,k_end )
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-04B++++++++++++++++++++++++++++++++++++++++++++++++++'

!-----Output: w_2,t_2save,ph_2

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_ADVANCE_W.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
      endif

      if (config_flags%specified .or. config_flags%nested) then
        if (non_hydrostatic) then
!---------Save for spec_bdyupdate_ph
          if(grid%trace_use) call trace_entry("backup")
          call push4backup(ph_2, "ph_2")
          if(grid%trace_use) call trace_exit("backup")

!---------From: module_bc_em.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-05A++++++++++++++++++++++++++++++++++++++++++++++++++'
          call spec_bdyupdate_ph( ph_save,ph_2,ph_tend,mu_tend,muts,dts_rk, &
                                  'h',config_flags,spec_zone, &
                                  ids,ide,jds,jde,kds,kde, &
                                  ims,ime,jms,jme,kms,kme, &
                                  ips,ipe,jps,jpe,kps,kpe, &
                                  grid%i_start(ij),grid%i_end(ij), &
                                  grid%j_start(ij),grid%j_end(ij), &
                                  k_start,k_end )
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-05B++++++++++++++++++++++++++++++++++++++++++++++++++'

!---------Output: ph_2

#ifdef DM_PARALLEL
          if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_SPEC_BDYUPDATE_PH.inc"
          if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
          if (config_flags%specified) then
!-----------From: ../share/module_bc.F
            call zero_grad_bdy( w_2,'w',config_flags,spec_zone, &
                                ids,ide,jds,jde,kds,kde, &
                                ims,ime,jms,jme,kms,kme, &
                                ips,ipe,jps,jpe,kps,kpe, &
                                grid%i_start(ij),grid%i_end(ij), &
                                grid%j_start(ij),grid%j_end(ij), &
                                k_start,k_end )
!-----------Output: w_2
          else
!-----------Save for spec_bdyupdate:
!-----------From: ../share/module_bc.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-06A++++++++++++++++++++++++++++++++++++++++++++++++++'
            call spec_bdyupdate( w_2,rw_tend,dts_rk,'h',config_flags,spec_zone, &
                                 ids,ide,jds,jde,kds,kde, &
                                 ims,ime,jms,jme,kms,kme, &
                                 ips,ipe,jps,jpe,kps,kpe, &
                                 grid%i_start(ij),grid%i_end(ij), &
                                 grid%j_start(ij),grid%j_end(ij), &
                                 k_start,k_end )
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-06B++++++++++++++++++++++++++++++++++++++++++++++++++'
!-----------Output: w_2
          endif

#ifdef DM_PARALLEL
          if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_SPEC_BDYUPDATE_W.inc"
          if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
        endif
      endif

!-----Save for calc_p_rho:
      if(grid%trace_use) call trace_entry("backup")
      call push4backup(ph_2,t_2, "ph_2,t_2")
      call push4backup(mu_2,muts, "mu_2,muts")
      if(grid%trace_use) call trace_exit("backup")

!-----From: module_small_step_em.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-07A++++++++++++++++++++++++++++++++++++++++++++++++++'
      call calc_p_rho( al,p,ph_2,alt,t_2,t_save,c2a,pm1,mu_2,muts,znu, &
                       t0,rdnw,dnw,smdiv,non_hydrostatic,iteration, &
                       ids,ide,jds,jde,kds,kde, &
                       ims,ime,jms,jme,kms,kme, &
                       grid%i_start(ij),grid%i_end(ij), &
                       grid%j_start(ij),grid%j_end(ij), &
                       k_start,k_end )
!print*, '++++++++++++++++++++++++++++++++++++++++++++++027-07B++++++++++++++++++++++++++++++++++++++++++++++++++'

!-----Output: al,p,ph_2,pm1

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_CALC_P_RHO.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!by walls
#ifdef DM_PARALLEL
!
!  Stencils for patch communications  (WCS, 29 June 2001)
!
!         *                     *
!       * + *      * + *        +
!         *                     *
!
!  ph_2   x
!  al     x
!  p      x
!
!  2D variables (x,y)
!
!  mu_2   x
!  muts   x
!  mudf   x

!print*, '++++++++++++++++++++++++++++++++++++++++++++++028++++++++++++++++++++++++++++++++++++++++++++++++++'
#      include "HALO_EM_C2.inc"
#      include "PERIOD_BDY_EM_B3.inc"
#endif

      if(dyn_opt == DYN_EM) then

        ! boundary condition set for next small timestep

         CALL set_physical_bc3d( ph_2, 'w', config_flags,          &
                                 ids, ide, jds, jde, kds, kde,     &
                                 ims, ime, jms, jme, kms, kme,     &
                                 ips, ipe, jps, jpe, kps, kpe,     &
                                 grid%i_start(ij), grid%i_end(ij), &
                                 grid%j_start(ij), grid%j_end(ij), &
                                 k_start    , k_end               )

         CALL set_physical_bc3d( al, 'p', config_flags,            &
                                 ids, ide, jds, jde, kds, kde,     &
                                 ims, ime, jms, jme, kms, kme,     &
                                 ips, ipe, jps, jpe, kps, kpe,     &
                                 grid%i_start(ij), grid%i_end(ij), &
                                 grid%j_start(ij), grid%j_end(ij), &
                                 k_start    , k_end               )

         CALL set_physical_bc3d( p, 'p', config_flags,             &
                                 ids, ide, jds, jde, kds, kde,     &
                                 ims, ime, jms, jme, kms, kme,     &
                                 ips, ipe, jps, jpe, kps, kpe,     &
                                 grid%i_start(ij), grid%i_end(ij), &
                                 grid%j_start(ij), grid%j_end(ij), &
                                 k_start    , k_end               )

         CALL set_physical_bc2d( muts, 't', config_flags,          &
                                 ids, ide, jds, jde,               &
                                 ims, ime, jms, jme,               &
                                 ips, ipe, jps, jpe,               &
                                 grid%i_start(ij), grid%i_end(ij), &
                                 grid%j_start(ij), grid%j_end(ij) )

         CALL set_physical_bc2d( mu_2, 't', config_flags,          &
                                 ids, ide, jds, jde,               &
                                 ims, ime, jms, jme,               &
                                 ips, ipe, jps, jpe,               &
                                 grid%i_start(ij), grid%i_end(ij), &
                                 grid%j_start(ij), grid%j_end(ij) )

         CALL set_physical_bc2d( mudf, 't', config_flags,          &
                                 ids, ide, jds, jde,               &
                                 ims, ime, jms, jme,               &
                                 ips, ipe, jps, jpe,               &
                                 grid%i_start(ij), grid%i_end(ij), &
                                 grid%j_start(ij), grid%j_end(ij) )

      endif
!by walls

  end do small_stepu

!-if(grid%trace_use) call trace_exit("solve_ad_small_stepu")

!---Save for calc_mu_uv_1: (Will backup next)
!---From: module_big_step_utilities_em.F
    call calc_mu_uv_1( config_flags,muts,muus,muvs, &
                       ids,ide,jds,jde,kds,kde, &
                       ims,ime,jms,jme,kms,kme, &
                       grid%i_start(ij),grid%i_end(ij), &
                       grid%j_start(ij),grid%j_end(ij), &
                       k_start,k_end )

!-----Output: muus,muvs

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_CALC_MU_UV_1.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!-----Save for small_step_finish:
      if(grid%trace_use) call trace_entry("backup")
      call push4backup(u_2,v_2,w_2,t_2, "u_2,v_2,w_2,t_2")
      call push4backup(ww1,u_save,v_save,w_save,t_save,ph_save, &
                      "ww1,u_save,v_save,w_save,t_save,ph_save")
      call push4backup(mut,muu,muus,muv,muvs, "mut,muu,muus,muv,muvs")
      call push4backup(cqu,cqv,cqw,"cqu,cqv,cqw")  !ADDED BY WALLS
      call push4backup(php, "php")  !ADDED BY WALLS
      call push4backup(mu_tend, "mu_tend")  !ADDED BY WALLS
      call push4backup(gamma, "gamma")  !ADDED BY WALLS
      call push4backup(alpha, "alpha")  !ADDED BY WALLS
      call push4backup(a, "a")  !ADDED BY WALLS
      call push4backup(c2a, "c2a")  !ADDED BY WALLS
      call push4backup(ph_tend,rw_tend, "ph_tend,rw_tend")  !ADDED BY WALLS
      if(grid%trace_use) call trace_exit("backup")

!-----From: module_small_step_em.F
      CALL small_step_finish( u_2, u_1, v_2, v_1, w_2, w_1,     &
                              t_2, t_1, ph_2, ph_1, ww, ww1,    &
                              mu_2, mu_1,                       &
                              mut, muts, muu, muus, muv, muvs,  &
                              u_save, v_save, w_save,           &
                              t_save, ph_save, mu_save,         &
                              msfu, msfv, msft,                 &
                              h_diabatic,                       &
                              number_of_small_timesteps,dts_rk, &
                              ids, ide, jds, jde, kds, kde,     &
                              ims, ime, jms, jme, kms, kme,     &
                              grid%i_start(ij), grid%i_end(ij), &
                              grid%j_start(ij), grid%j_end(ij), &
                              k_start    , k_end               )

!-----Output: u_2,v_2,w_2,t_2,ph_2,ww,mu_2,mu_1,mut,muts,muu,muus,muv,muvs,mu_save

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_SMALL_STEP_FINISH.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!by walls
#ifdef DM_PARALLEL
!
!  Stencils for patch communications  (WCS, 29 June 2001)
!
!
! ru_m      x
! rv_m      x
!
!--------------------------------------------------------------

!print*, '++++++++++++++++++++++++++++++++++++++++++++++029++++++++++++++++++++++++++++++++++++++++++++++++++'
#  include "HALO_EM_D.inc"
#endif
!by walls

  moist_scalar_advancg: if (num_3d_m .ge. param_first_scalar) then

    moist_variable_loor1: do im = param_first_scalar, num_3d_m

!---Save for rk_scalar_tend:
    if(grid%trace_use) call trace_entry("backup")
    call push4backup(ru_m,rv_m,ww_m,alt, "ru_m,rv_m,ww_m,alt")
    if(grid%trace_use) call trace_exit("backup")

!-------From: module_em.F
        call rk_scalar_tend( im,im,config_flags,rk_step,dt_rk, &
                             ru_m,rv_m,ww_m,mut,alt, &
                             moist_1(ims,kms,jms,im),moist_2(ims,kms,jms,im), &
                             moist_tend(ims,kms,jms,im), &
                             advect_tend,rqvften,qv_base, .true. , &
                             fnm,fnp,msfu,msfv,msft,rdx,rdy,rdn,rdnw, &
                             khdif,kvdif,xkmhd,leapfrog, &
                             ids,ide,jds,jde,kds,kde, &
                             ims,ime,jms,jme,kms,kme, &
                             grid%i_start(ij),grid%i_end(ij), &
                             grid%j_start(ij),grid%j_end(ij), &
                             k_start,k_end )

!-------Output: moist_1,moist_2,moist_tend,rqvften

        if ((config_flags%specified .or. config_flags%nested) .and. rk_step .eq. 1) then
          if (im .eq. p_qv) then

!by walls

walls_open=0
if(walls_open.eq.1) then
         CALL relax_bdy_scalar ( moist_tend(ims,kms,jms,im),            &
                                 moist_2(ims,kms,jms,im),  mut,         &
                                 rqv_b, rqv_bt,                         &
                                 spec_bdy_width, spec_zone, relax_zone, &
                                 dtbc, fcx, gcx,             &
                                 ijds, ijde,                 & ! min/max(id,jd)
                                 ids,ide, jds,jde, kds,kde,  & ! domain dims
                                 ims,ime, jms,jme, kms,kme,  & ! memory dims
                                 ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                                 grid%i_start(ij), grid%i_end(ij),      &
                                 grid%j_start(ij), grid%j_end(ij),      &
                                 k_start, k_end                        )
end if
!by walls

!-----------From: module_bc_em.F
            call spec_bdy_scalar( moist_tend(ims,kms,jms,im),rqv_b,rqv_bt,spec_bdy_width,spec_zone, &
                                  ijds,ijde, &
                                  ids,ide,jds,jde,kds,kde, &
                                  ims,ime,jms,jme,kms,kme, &
                                  ips,ipe,jps,jpe,kps,kpe, &
                                  grid%i_start(ij),grid%i_end(ij), &
                                  grid%j_start(ij),grid%j_end(ij), &
                                  k_start,k_end )
!-----------Output: moist_tend
          endif
        endif
        if (config_flags%nested .and. rk_step .eq. 1) then
          if (im .eq. p_qc) then
!by walls
if(walls_open.eq.1) then
         CALL relax_bdy_scalar ( moist_tend(ims,kms,jms,im),            &
                                 moist_2(ims,kms,jms,im),  mut,         &
                                 rqc_b, rqc_bt,                         &
                                 spec_bdy_width, spec_zone, relax_zone, &
                                 dtbc, fcx, gcx,             &
                                 ijds, ijde,                 & ! min/max(id,jd)
                                 ids,ide, jds,jde, kds,kde,  & ! domain dims
                                 ims,ime, jms,jme, kms,kme,  & ! memory dims
                                 ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                                 grid%i_start(ij), grid%i_end(ij),      &
                                 grid%j_start(ij), grid%j_end(ij),      &
                                 k_start, k_end                        )
end if
!by walls
            call spec_bdy_scalar( moist_tend(ims,kms,jms,im),rqc_b,rqc_bt,spec_bdy_width,spec_zone, &
                                  ijds,ijde, &
                                  ids,ide,jds,jde,kds,kde, &
                                  ims,ime,jms,jme,kms,kme, &
                                  ips,ipe,jps,jpe,kps,kpe, &
                                  grid%i_start(ij),grid%i_end(ij), &
                                  grid%j_start(ij),grid%j_end(ij), &
                                  k_start,k_end )
          else if (im .eq. p_qr) then
!by walls
if(walls_open.eq.1) then
         CALL relax_bdy_scalar ( moist_tend(ims,kms,jms,im),            &
                                 moist_2(ims,kms,jms,im),  mut,         &
                                 rqr_b, rqr_bt,                         &
                                 spec_bdy_width, spec_zone, relax_zone, &
                                 dtbc, fcx, gcx,             &
                                 ijds, ijde,                 & ! min/max(id,jd)
                                 ids,ide, jds,jde, kds,kde,  & ! domain dims
                                 ims,ime, jms,jme, kms,kme,  & ! memory dims
                                 ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                                 grid%i_start(ij), grid%i_end(ij),      &
                                 grid%j_start(ij), grid%j_end(ij),      &
                                 k_start, k_end                        )

end if
!by walls
            call spec_bdy_scalar( moist_tend(ims,kms,jms,im),rqr_b,rqr_bt,spec_bdy_width,spec_zone, &
                                  ijds,ijde, &
                                  ids,ide,jds,jde,kds,kde, &
                                  ims,ime,jms,jme,kms,kme, &
                                  ips,ipe,jps,jpe,kps,kpe, &
                                  grid%i_start(ij),grid%i_end(ij), &
                                  grid%j_start(ij),grid%j_end(ij), &
                                  k_start,k_end )
          else if (im .eq. p_qi) then
!by walls
if(walls_open.eq.1) then
         CALL relax_bdy_scalar ( moist_tend(ims,kms,jms,im),            &
                                 moist_2(ims,kms,jms,im),  mut,         &
                                 rqi_b, rqi_bt,                         &
                                 spec_bdy_width, spec_zone, relax_zone, &
                                 dtbc, fcx, gcx,             &
                                 ijds, ijde,                 & ! min/max(id,jd)
                                 ids,ide, jds,jde, kds,kde,  & ! domain dims
                                 ims,ime, jms,jme, kms,kme,  & ! memory dims
                                 ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                                 grid%i_start(ij), grid%i_end(ij),      &
                                 grid%j_start(ij), grid%j_end(ij),      &
                                 k_start, k_end                        )
end if
!by walls
            call spec_bdy_scalar( moist_tend(ims,kms,jms,im),rqi_b,rqi_bt,spec_bdy_width,spec_zone, &
                                  ijds,ijde, &
                                  ids,ide,jds,jde,kds,kde, &
                                  ims,ime,jms,jme,kms,kme, &
                                  ips,ipe,jps,jpe,kps,kpe, &
                                  grid%i_start(ij),grid%i_end(ij), &
                                  grid%j_start(ij),grid%j_end(ij), &
                                  k_start,k_end )
          else if (im .eq. p_qs) then
!by walls
if(walls_open.eq.1) then
         CALL relax_bdy_scalar ( moist_tend(ims,kms,jms,im),            &
                                 moist_2(ims,kms,jms,im),  mut,         &
                                 rqs_b, rqs_bt,                         &
                                 spec_bdy_width, spec_zone, relax_zone, &
                                 dtbc, fcx, gcx,             &
                                 ijds, ijde,                 & ! min/max(id,jd)
                                 ids,ide, jds,jde, kds,kde,  & ! domain dims
                                 ims,ime, jms,jme, kms,kme,  & ! memory dims
                                 ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                                 grid%i_start(ij), grid%i_end(ij),      &
                                 grid%j_start(ij), grid%j_end(ij),      &
                                 k_start, k_end                        )
end if
!by walls
            call spec_bdy_scalar( moist_tend(ims,kms,jms,im),rqs_b,rqs_bt,spec_bdy_width,spec_zone, &
                                  ijds,ijde, &
                                  ids,ide,jds,jde,kds,kde, &
                                  ims,ime,jms,jme,kms,kme, &
                                  ips,ipe,jps,jpe,kps,kpe, &
                                  grid%i_start(ij),grid%i_end(ij), &
                                  grid%j_start(ij),grid%j_end(ij), &
                                  k_start,k_end )
          else if (im .eq. p_qg) then
!by walls
if(walls_open.eq.1) then
         CALL relax_bdy_scalar ( moist_tend(ims,kms,jms,im),            &
                                 moist_2(ims,kms,jms,im),  mut,         &
                                 rqg_b, rqg_bt,                         &
                                 spec_bdy_width, spec_zone, relax_zone, &
                                 dtbc, fcx, gcx,             &
                                 ijds, ijde,                 & ! min/max(id,jd)
                                 ids,ide, jds,jde, kds,kde,  & ! domain dims
                                 ims,ime, jms,jme, kms,kme,  & ! memory dims
                                 ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                                 grid%i_start(ij), grid%i_end(ij),      &
                                 grid%j_start(ij), grid%j_end(ij),      &
                                 k_start, k_end                        )
end if
!by walls
            call spec_bdy_scalar( moist_tend(ims,kms,jms,im),rqg_b,rqg_bt,spec_bdy_width,spec_zone, &
                                  ijds,ijde, &
                                  ids,ide,jds,jde,kds,kde, &
                                  ims,ime,jms,jme,kms,kme, &
                                  ips,ipe,jps,jpe,kps,kpe, &
                                  grid%i_start(ij),grid%i_end(ij), &
                                  grid%j_start(ij),grid%j_end(ij), &
                                  k_start,k_end )
          endif
        endif

!-----Output: moist_1,moist_2,moist_tend (...rqvften)

#ifdef DM_PARALLEL
    if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_RK_SCALAR.inc"
    if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!---Save for rk_update_scalar:
    if(grid%trace_use) call trace_entry("backup")
    call push4backup(advect_tend, "advect_tend")
    call push4backup(moist_1,moist_2, "moist_1,moist_2")
    if(grid%trace_use) call trace_exit("backup")

!-------From: module_em.F
        call rk_update_scalar( im,im,moist_1(ims,kms,jms,im),moist_2(ims,kms,jms,im), &
                               moist_tend(ims,kms,jms,im),advect_tend, &
                               msft,mu_1,mu_2,mub,rk_step,dt_rk, &
                               spec_zone,epsts,leapfrog,config_flags, &
                               ids,ide,jds,jde,kds,kde, &
                               ims,ime,jms,jme,kms,kme, &
                               grid%i_start(ij),grid%i_end(ij), &
                               grid%j_start(ij),grid%j_end(ij), &
                               k_start,k_end )

!-------Output: moist_1,moist_2,moist_tend

!by walls
       if(dyn_opt == DYN_EM) then
       IF( config_flags%specified ) THEN
         IF(im .ne. P_QV)THEN
           CALL flow_dep_bdy  (  moist_2(ims,kms,jms,im),                     &
                               ru_m, rv_m, config_flags, &
                               spec_zone,                  &
                               ids,ide, jds,jde, kds,kde,  & ! domain dims
                               ims,ime, jms,jme, kms,kme,  & ! memory dims
                               ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                               grid%i_start(ij), grid%i_end(ij),                      &
                               grid%j_start(ij), grid%j_end(ij),                      &
                               k_start, k_end                               )
         ENDIF
       ENDIF
       endif
!by walls

    end do moist_variable_loor1

#ifdef DM_PARALLEL
    if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_RK_SCALAR.inc"
    if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
  endif moist_scalar_advancg


!by walls
 if(dyn_opt == DYN_EM) then
 TKE_advance: IF (km_opt .eq. 2) then

#ifdef DM_PARALLEL
      IF      ( h_mom_adv_order <= 4 ) THEN
#       include "HALO_EM_TKE_ADVECT_3.inc"
      ELSE IF ( h_mom_adv_order <= 6 ) THEN
#       include "HALO_EM_TKE_ADVECT_5.inc"
      ELSE
        WRITE(wrf_err_message,*)'solve_em: invalid h_mom_adv_order = ',h_mom_adv_order
        CALL wrf_error_fatal(TRIM(wrf_err_message))
      ENDIF
#endif

     CALL wrf_debug ( 200 , ' call rk_scalar_tend for tke' )
     CALL rk_scalar_tend ( 1, 1, config_flags,               &
                           rk_step, dt_rk,                   &
                           ru_m, rv_m, ww_m,                 &
                           mut, alt,                         &
                           tke_1(ims,kms,jms),               &
                           tke_2(ims,kms,jms),               &
                           tke_tend(ims,kms,jms),            &
                           advect_tend,RQVFTEN,              &
                           qv_base, .false., fnm, fnp,       &
                           msfu, msfv, msft,                 &
                           rdx, rdy, rdn, rdnw, khdif,       &
                           kvdif, xkmhd,                     &
                           leapfrog,                         &
                           ids, ide, jds, jde, kds, kde,     &
                           ims, ime, jms, jme, kms, kme,     &
                           grid%i_start(ij), grid%i_end(ij), &
                           grid%j_start(ij), grid%j_end(ij), &
                           k_start    , k_end               )


     CALL wrf_debug ( 200 , ' call rk_update_scalar' )
     CALL rk_update_scalar( 1, 1,                             &
                            tke_1(ims,kms,jms),               &
                            tke_2(ims,kms,jms),               &
                            tke_tend(ims,kms,jms),            &
                            advect_tend,msft,                 &
                            mu_1, mu_2, mub,                  &
                            rk_step, dt_rk, spec_zone,        &
                            epsts, leapfrog,config_flags,     &
                            ids, ide, jds, jde, kds, kde,     &
                            ims, ime, jms, jme, kms, kme,     &
                            grid%i_start(ij), grid%i_end(ij), &
                            grid%j_start(ij), grid%j_end(ij), &
                            k_start    , k_end               )

! bound the tke (greater than 0, less than tke_upper_bound)

     CALL bound_tke( tke_2(ims,kms,jms), tke_upper_bound, &
                     ids, ide, jds, jde, kds, kde,        &
                     ims, ime, jms, jme, kms, kme,        &
                     grid%i_start(ij), grid%i_end(ij),    &
                     grid%j_start(ij), grid%j_end(ij),    &
                     k_start    , k_end                  )

     IF( config_flags%specified .or. config_flags%nested ) THEN
         CALL flow_dep_bdy (  tke_2(ims,kms,jms),                     &
                              ru_m, rv_m, config_flags,               &
                              spec_zone,                              &
                              ids,ide, jds,jde, kds,kde,  & ! domain dims
                              ims,ime, jms,jme, kms,kme,  & ! memory dims
                              ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                              grid%i_start(ij), grid%i_end(ij),       &
                              grid%j_start(ij), grid%j_end(ij),       &
                              k_start, k_end                               )
     ENDIF

   END IF TKE_advance
   endif

  chem_scalar_advance: IF (num_3d_c >= PARAM_FIRST_SCALAR)  THEN

   chem_variable_loop: do ic = PARAM_FIRST_SCALAR, num_3d_c

       CALL wrf_debug ( 200 , ' call rk_scalar_tend' )
       CALL rk_scalar_tend ( ic, ic, config_flags,                  &
                             rk_step, dt_rk,                   &
                             ru_m, rv_m, ww_m,                 &
                             mut, alt,                         &
                             chem_1(ims,kms,jms,ic),           &
                             chem_2(ims,kms,jms,ic),           &
                             chem_tend(ims,kms,jms,ic),        &
                             advect_tend,RQVFTEN,              &
                             qv_base, .false., fnm, fnp,       &
                             msfu, msfv, msft,                 &
                             rdx, rdy, rdn, rdnw,              &
                             khdif, kvdif, xkmhd,              &
                             leapfrog,                         &
                             ids, ide, jds, jde, kds, kde,     &
                             ims, ime, jms, jme, kms, kme,     &
                             grid%i_start(ij), grid%i_end(ij), &
                             grid%j_start(ij), grid%j_end(ij), &
                             k_start    , k_end               )

       CALL wrf_debug ( 200 , ' call rk_update_scalar' )
       CALL rk_update_scalar( ic, ic,                           &
                              chem_1(ims,kms,jms,ic),           &
                              chem_2(ims,kms,jms,ic),           &
                              chem_tend(ims,kms,jms,ic),        &
                              advect_tend, msft,                &
                              mu_1, mu_2, mub,                  &
                              rk_step, dt_rk, spec_zone,        &
                              epsts, leapfrog,config_flags,     &
                              ids, ide, jds, jde, kds, kde,     &
                              ims, ime, jms, jme, kms, kme,     &
                              grid%i_start(ij), grid%i_end(ij), &
                              grid%j_start(ij), grid%j_end(ij), &
                              k_start    , k_end               )

       IF( config_flags%specified ) THEN
! come back to this and figure out why two different routines are needed. JM 20041203
#ifndef WRF_CHEM
           CALL flow_dep_bdy  ( chem_2(ims,kms,jms,ic),     &
                                ru_m, rv_m, config_flags,   &
                                spec_zone,                  &
                                ids,ide, jds,jde, kds,kde,  & ! domain dims
                                ims,ime, jms,jme, kms,kme,  & ! memory dims
                                ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                                grid%i_start(ij), grid%i_end(ij),  &
                                grid%j_start(ij), grid%j_end(ij),  &
                                k_start, k_end                    )
#else
           CALL flow_dep_bdy_chem( chem_2(ims,kms,jms,ic),z,&
                                ru_m, rv_m, config_flags,alt,   &
                                t_1,pb,p,t0,p1000mb,rcp,ph_2,phb,g, &
                                spec_zone,ic,               &
                                ids,ide, jds,jde, kds,kde,  & ! domain dims
                                ims,ime, jms,jme, kms,kme,  & ! memory dims
                                ips,ipe, jps,jpe, kps,kpe,  & ! patch  dims
                                grid%i_start(ij), grid%i_end(ij),  &
                                grid%j_start(ij), grid%j_end(ij),  &
                                k_start, k_end                    )
#endif
       ENDIF


   ENDDO chem_variable_loop

 ENDIF chem_scalar_advance
!by walls


!print*, '++++++++++++++++++++++++++++++++++++++++++++++030++++++++++++++++++++++++++++++++++++++++++++++++++'
!print*, '+++++++++++++++++++++++++++++++++++++++++++XXXWALLS001++++++++++++++++++++++++++++++++++++++++++++++'
!---Save for calc_p_rho_phi:
    if(grid%trace_use) call trace_entry("backup")
    call push4backup(ph_2,t_2, "ph_2,t_2")
    call push4backup(mu_2,muts, "mu_2,muts")
    if(grid%trace_use) call trace_exit("backup")

!---From: module_big_step_utilities_em.F
    call calc_p_rho_phi( moist_2,num_3d_m,al,alb,mu_2,muts,ph_2,p,pb,t_2,p0,t0, &
                         znu,dnw,rdnw,rdn,non_hydrostatic, &
                         ids,ide,jds,jde,kds,kde, &
                         ims,ime,jms,jme,kms,kme, &
                         grid%i_start(ij),grid%i_end(ij), &
                         grid%j_start(ij),grid%j_end(ij), &
                         k_start,k_end )

!-----Output: al,p,ph_2

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_CALC_P_RHO_PHI.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

    if ( .not. non_hydrostatic) then
!-----Save for diagnose_w:
      if(grid%trace_use) call trace_entry("backup")
      call push4backup(ph_tend, "ph_tend")
      if(grid%trace_use) call trace_exit("backup")

!print*, '+++++++++++++++++++++++++++++++++++++++++++XXXWALLS002++++++++++++++++++++++++++++++++++++++++++++++'
!---From: module_big_step_utilities_em.F
      call diagnose_w( ph_tend,ph_2,ph_1,w_2,muts,dt_rk,u_2,v_2,ht, &
                       cf1,cf2,cf3,rdx,rdy,msft, &
                       ids,ide,jds,jde,kds,kde, &
                       ims,ime,jms,jme,kms,kme, &
                       grid%i_start(ij),grid%i_end(ij), &
                       grid%j_start(ij),grid%j_end(ij), &
                       k_start,k_end )

!-----Output: w_2

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_DIAGNOSE_W.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
    endif

!by walls
   rk_step_1_check: IF ( rk_step < rk_order ) THEN

!-----------------------------------------------------------
!  Stencils for patch communications  (WCS, 29 June 2001)
!
!  here's where we need a wide comm stencil - these are the 
!  uncoupled variables so are used for high order calc in
!  advection and mixong routines.
!
!                              * * * * *
!            *        * * *    * * * * *
!          * + *      * + *    * * + * * 
!            *        * * *    * * * * *
!                              * * * * *
!
!
! u_2                              x
! v_2                              x
! w_2                              x
! t_2                              x
! ph_2                             x
! al         x
!
!  2D variable
! mu_2       x
!
!  4D variable
! moist_2               x
! chem_2                x

#ifdef DM_PARALLEL
   IF      ( h_mom_adv_order <= 4 ) THEN
#    include "HALO_EM_D2_3.inc"
   ELSE IF ( h_mom_adv_order <= 6 ) THEN
#    include "HALO_EM_D2_5.inc"
   ELSE
     WRITE(wrf_err_message,*)'solve_em: invalid h_mom_adv_order = ',h_mom_adv_order
     CALL wrf_error_fatal(TRIM(wrf_err_message))
   ENDIF
#  include "PERIOD_BDY_EM_D.inc"
#  include "PERIOD_BDY_EM_MOIST2.inc"
#  include "PERIOD_BDY_EM_CHEM2.inc"
#endif

!print*, '+++++++++++++++++++++++++++++++++++++++++++XXXWALLS003++++++++++++++++++++++++++++++++++++++++++++++'
   if(dyn_opt == DYN_EM) then

      CALL wrf_debug ( 200 , ' call rk_phys_bc_dry_2' )

      CALL rk_phys_bc_dry_2( config_flags,                         &
                             u_2, v_2, w_2,                    &
                             t_2, ph_2, mu_2,                  &
                             ids, ide, jds, jde, kds, kde,     &
                             ims, ime, jms, jme, kms, kme,     &
                             ips, ipe, jps, jpe, kps, kpe,     &
                             grid%i_start(ij), grid%i_end(ij), &
                             grid%j_start(ij), grid%j_end(ij), &
                             k_start    , k_end               )

      IF (num_3d_m >= PARAM_FIRST_SCALAR) THEN

        moisture_loop_bdy_1 : DO im = PARAM_FIRST_SCALAR , num_3d_m

          CALL set_physical_bc3d( moist_2(ims,kms,jms,im), 'p', config_flags,   &
                                   ids, ide, jds, jde, kds, kde,             &
                                   ims, ime, jms, jme, kms, kme,             &
                                   ips, ipe, jps, jpe, kps, kpe,             &
                                   grid%i_start(ij), grid%i_end(ij),                   &
                                   grid%j_start(ij), grid%j_end(ij),                   &
                                   k_start    , k_end                       )
         END DO moisture_loop_bdy_1

      ENDIF

      IF (num_3d_c >= PARAM_FIRST_SCALAR) THEN

        chem_species_bdy_loop_1 : DO ic = PARAM_FIRST_SCALAR , num_3d_c

          CALL set_physical_bc3d( chem_2(ims,kms,jms,ic), 'p', config_flags,   &
                                  ids, ide, jds, jde, kds, kde,            &
                                  ims, ime, jms, jme, kms, kme,            &
                                  ips, ipe, jps, jpe, kps, kpe,            &
                                  grid%i_start(ij), grid%i_end(ij),                  &
                                  grid%j_start(ij), grid%j_end(ij),                  &
                                  k_start    , k_end-1                    )

        END DO chem_species_bdy_loop_1

      END IF

      IF (km_opt .eq. 2) THEN

        CALL set_physical_bc3d( tke_2(ims,kms,jms) , 'p', config_flags,  &
                                ids, ide, jds, jde, kds, kde,            &
                                ims, ime, jms, jme, kms, kme,            &
                                ips, ipe, jps, jpe, kps, kpe,            &
                                grid%i_start(ij), grid%i_end(ij),        &
                                grid%j_start(ij), grid%j_end(ij),        &
                                k_start    , k_end                      )
      END IF

   endif

#ifdef DM_PARALLEL

      IF      ( h_mom_adv_order <= 4 ) THEN
#       include "HALO_EM_TKE_3.inc"
      ELSE IF ( h_mom_adv_order <= 6 ) THEN
#       include "HALO_EM_TKE_5.inc"
      ELSE
        WRITE(wrf_err_message,*)'solve_em: invalid h_mom_adv_order = ',h_mom_adv_order
        CALL wrf_error_fatal(TRIM(wrf_err_message))
      ENDIF

#if 0
   IF (km_opt .eq. 2) THEN
#      include  "HALO_EM_TKE_F.inc"
   ENDIF
#endif

   if ( num_moist .ge. PARAM_FIRST_SCALAR ) then

!                           * * * * *
!         *        * * *    * * * * *
!       * + *      * + *    * * + * *
!         *        * * *    * * * * *
!                           * * * * *

! moist_2                       x

     IF      ( h_mom_adv_order <= 4 ) THEN
#      include "HALO_EM_MOIST_E_3.inc"
     ELSE IF ( h_mom_adv_order <= 6 ) THEN
#      include "HALO_EM_MOIST_E_5.inc"
     ELSE
       WRITE(wrf_err_message,*)'solve_em: invalid h_mom_adv_order = ',h_mom_adv_order
       CALL wrf_error_fatal(TRIM(wrf_err_message))
     ENDIF
   endif
   if ( num_chem >= PARAM_FIRST_SCALAR ) then

!                           * * * * *
!         *        * * *    * * * * *
!       * + *      * + *    * * + * *
!         *        * * *    * * * * *
!                           * * * * *

! chem_2                        x

     IF      ( h_mom_adv_order <= 4 ) THEN
#      include "HALO_EM_CHEM_E_3.inc"
     ELSE IF ( h_mom_adv_order <= 6 ) THEN
#      include "HALO_EM_CHEM_E_5.inc"
     ELSE
       WRITE(wrf_err_message,*)'solve_em: invalid h_mom_adv_order = ',h_mom_adv_order
       CALL wrf_error_fatal(TRIM(wrf_err_message))
     ENDIF
   endif

#endif

   ENDIF rk_step_1_check
!by walls

end do runge_kutta_looq

!by walls
!by walls
walls_open=0
if(walls_open.eq.1) then
      CALL wrf_debug ( 200 , ' call advance_ppt' )
      CALL advance_ppt(RTHCUTEN,RQVCUTEN,RQCCUTEN,RQRCUTEN, &
                     RQICUTEN,RQSCUTEN,RAINC,RAINCV,NCA,    &
                     CUPPT, config_flags,                   &
                     ids,ide, jds,jde, kds,kde,             &
                     ims,ime, jms,jme, kms,kme,             &
                     grid%i_start(ij), grid%i_end(ij),      &
                     grid%j_start(ij), grid%j_end(ij),      &
                     k_start    , k_end                    )

endif
! for microphysics basic state
 IF (config_flags%mp_physics >= 0)  then   

   IF( config_flags%specified .or. config_flags%nested ) THEN
     sz = spec_zone
   ELSE
     sz = 0
   ENDIF

       its = max(grid%i_start(ij),ids+sz)
       ite = min(grid%i_end(ij),ide-1-sz)
       jts = max(grid%j_start(ij),jds+sz)
       jte = min(grid%j_end(ij),jde-1-sz)

       CALL wrf_debug ( 200 , ' call moist_physics_prep' )
       CALL moist_physics_prep_em( t_2, t_1, t0, rho,                &
                                   al, alb, p, p8w, p0, pb,          &
                                   ph_2, phb, pi_phy, p_phy,         &
                                   z, z_at_w, dz8w,                  &
                                   dtm, h_diabatic,                  &
                                   config_flags,fnm, fnp,            &
                                   ids, ide, jds, jde, kds, kde,     &
                                   ims, ime, jms, jme, kms, kme,     &
                                   max(grid%i_start(ij),ids+sz),  &
                                   min(grid%i_end(ij),ide-1-sz),    &
                                   max(grid%j_start(ij),jds+sz),  &
                                   min(grid%j_end(ij),jde-1-sz),k_start,k_end )

    call push4backup(moist_2, "moist_2")
    call push4backup(rho, "rho")
    call push4backup(p_phy, "p_phy")
    call push4backup(pi_phy, "pi_phy")
    call push4backup(th_phy, "th_phy")
    call push4backup(t_2, "t_2")
    call push4backup(z, "z")
    call push4backup(dz8w, "dz8w")

     if(config_flags%mp_physics == 1)then  

      call kessler(t_2,moist_2(ims,kms,jms,P_QV),moist_2(ims,kms,jms,P_QC),moist_2(ims,kms,jms,P_QR), rho, p_phy,pi_phy, dt&
&      , z, xlv, cp, ep_2, svp1, svp2, svp3, svpt0, rhowater, dz8w, rainnc, &
&       rainncv, ids, ide, jds, jde, kds, kde, ims, ime, &
&       jms, jme, kms, kme, &
                                   max(grid%i_start(ij),ids+sz),          &
                                   min(grid%i_end(ij),ide-1-sz),          &
                                   max(grid%j_start(ij),jds+sz),          &
                                   min(grid%j_end(ij),jde-1-sz),k_start    , min(k_end,kde-1)         )
     elseif(config_flags%mp_physics == 0)then

        CALL lscond(t_2, p_phy                                         &
                    ,moist_2(ims,kms,jms,P_QV)                         &
                    ,rho, pi_phy,r_v, xlv, cp                          &
                    ,ep_2, svp1, svp2                                  &
                    ,svp3, svpt0                                       &
                    ,dz8w                                              &
                    ,rainnc, rainncv                                   &
                    ,ids, ide, jds, jde, kds, kde                      &
                    ,ims, ime, jms, jme, kms, kme                      &
                    ,its, ite, jts, jte                                &
                    ,k_start, min(k_end,kde-1)                         )
     endif

        CALL moist_physics_finish_em( t_2, t_1, t0, muts,              &
                                     h_diabatic, dtm, config_flags,    &
                                     ids, ide, jds, jde, kds, kde,     &
                                     ims, ime, jms, jme, kms, kme,     &
                                     max(grid%i_start(ij),ids+sz),     &
                                     min(grid%i_end(ij),ide-1-sz),     &
                                     max(grid%j_start(ij),jds+sz),     &
                                     min(grid%j_end(ij),jde-1-sz),     &
                                     k_start    , k_end               )

    call push4backup(ph_2,t_2, "ph_2,t_2")
    call push4backup(mu_2,muts, "mu_2,muts")
    call push4backup(moist_2, "moist_2")
    call push4backup(al,p, "al,p")

       CALL calc_p_rho_phi( moist_2, num_3d_m,                &
                            al, alb, mu_2, muts,              &
                            ph_2, p, pb, t_2,                 &
                            p0, t0, znu, dnw, rdnw,           &
                            rdn, non_hydrostatic,             &
                            ids, ide, jds, jde, kds, kde,     &
                            ims, ime, jms, jme, kms, kme,     &
                            its, ite, jts, jte,               &
                            k_start    , k_end               )

      call push4backup(ph_tend, "ph_tend")
      call push4backup(muts, "muts")

       IF (.not. non_hydrostatic)                               &
       CALL diagnose_w( ph_tend, ph_2, ph_1, w_2, muts, dt_rk,  &
                        u_2, v_2, ht,                           &
                        cf1, cf2, cf3, rdx, rdy, msft,          &
                        ids, ide, jds, jde, kds, kde,           &
                        ims, ime, jms, jme, kms, kme,           &
                        its, ite, jts, jte,                     &
                        k_start    , k_end                     )

  ENDIF   !mp

if(walls_open.eq.1) then
          CALL wrf_debug ( 200 , ' call scalar_tile_loop_2' )

     IF ( num_3d_c >= PARAM_FIRST_SCALAR ) then

!
!  tiled chemistry not here, it is called from solve_interface, and found in chem_driver
!

     END IF


!print*, '+++++++++++++++++++++++++++++++++++++++++++XXXWALLS007++++++++++++++++++++++++++++++++++++++++++++++'
   if(dyn_opt == DYN_EM) then
   IF (leapfrog ) THEN

    ! do time filter and switch for the dry variables

      call time_filter( u_1, u_2, u_save,                 &
                        v_1, v_2, v_save,                 &
                        w_1, w_2, w_save,                 &
                        t_1, t_2, t_save,                 &
                        ph_1, ph_2, ph_save,              &
                        mu_1, mu_2, mu_save,              &
                        epsts,                            &
                        ids, ide, jds, jde, kds, kde,     &
                        ims, ime, jms, jme, kms, kme,     &
                        grid%i_start(ij), grid%i_end(ij), &
                        grid%j_start(ij), grid%j_end(ij), &
                        k_start    , k_end               )

    END IF
    endif

#ifdef DM_PARALLEL
   IF      ( h_mom_adv_order <= 4 ) THEN
#    include "HALO_EM_D3_3.inc"
   ELSE IF ( h_mom_adv_order <= 6 ) THEN
#    include "HALO_EM_D3_5.inc"
   ELSE
     WRITE(wrf_err_message,*)'solve_em: invalid h_mom_adv_order = ',h_mom_adv_order
     CALL wrf_error_fatal(TRIM(wrf_err_message))
   ENDIF
#  include "PERIOD_BDY_EM_D3.inc"
#  include "PERIOD_BDY_EM_MOIST.inc"
#  include "PERIOD_BDY_EM_CHEM.inc"
#endif

!  now set physical b.c on a patch

!print*, '+++++++++++++++++++++++++++++++++++++++++++XXXWALLS008++++++++++++++++++++++++++++++++++++++++++++++'
   if(dyn_opt == DYN_EM) then
   !$OMP PARALLEL DO   &
   !$OMP PRIVATE ( ij )

     CALL wrf_debug ( 200 , ' call set_phys_bc_dry_2' )

     CALL set_phys_bc_dry_2( config_flags,                           &
                             u_1, u_2, v_1, v_2, w_1, w_2,           &
                             t_1, t_2, ph_1, ph_2, mu_1, mu_2,       &
                             ids, ide, jds, jde, kds, kde,           &
                             ims, ime, jms, jme, kms, kme,           &
                             ips, ipe, jps, jpe, kps, kpe,           &
                             grid%i_start(ij), grid%i_end(ij),       &
                             grid%j_start(ij), grid%j_end(ij),       &
                             k_start    , k_end                     )

     CALL set_physical_bc3d( tke_1(ims,kms,jms), 'p', config_flags,   &
                             ids, ide, jds, jde, kds, kde,            &
                             ims, ime, jms, jme, kms, kme,            &
                             ips, ipe, jps, jpe, kps, kpe,            &
                             grid%i_start(ij), grid%i_end(ij),        &
                             grid%j_start(ij), grid%j_end(ij),        &
                             k_start    , k_end-1                    )
     CALL set_physical_bc3d( tke_2(ims,kms,jms) , 'p', config_flags,  &
                             ids, ide, jds, jde, kds, kde,            &
                             ims, ime, jms, jme, kms, kme,            &
                             ips, ipe, jps, jpe, kps, kpe,            &
                             grid%i_start(ij), grid%i_end(ij),        &
                             grid%j_start(ij), grid%j_end(ij),        &
                             k_start    , k_end                      )

     moisture_loop_bdy_2 : DO im = PARAM_FIRST_SCALAR , num_3d_m

       CALL set_physical_bc3d( moist_1(ims,kms,jms,im), 'p',           &
                               config_flags,                           &
                               ids, ide, jds, jde, kds, kde,           &
                               ims, ime, jms, jme, kms, kme,           &
                               ips, ipe, jps, jpe, kps, kpe,           &
                               grid%i_start(ij), grid%i_end(ij),       &
                               grid%j_start(ij), grid%j_end(ij),       &
                               k_start    , k_end                     )
       CALL set_physical_bc3d( moist_2(ims,kms,jms,im), 'p',           &
                               config_flags,                           &
                               ids, ide, jds, jde, kds, kde,           &
                               ims, ime, jms, jme, kms, kme,           &
                               ips, ipe, jps, jpe, kps, kpe,           &
                               grid%i_start(ij), grid%i_end(ij),       &
                               grid%j_start(ij), grid%j_end(ij),       &
                               k_start    , k_end                     )

     END DO moisture_loop_bdy_2

!print*, '+++++++++++++++++++++++++++++++++++++++++++XXXWALLS009++++++++++++++++++++++++++++++++++++++++++++++'
     chem_species_bdy_loop_2 : DO ic = PARAM_FIRST_SCALAR , num_3d_c

       CALL set_physical_bc3d( chem_1(ims,kms,jms,ic), 'p', config_flags,   &
                               ids, ide, jds, jde, kds, kde,            &
                               ims, ime, jms, jme, kms, kme,            &
                               ips, ipe, jps, jpe, kps, kpe,            &
                               grid%i_start(ij), grid%i_end(ij),                  &
                               grid%j_start(ij), grid%j_end(ij),                  &
                               k_start    , k_end                    )
       CALL set_physical_bc3d( chem_2(ims,kms,jms,ic) , 'p', config_flags,  &
                               ids, ide, jds, jde, kds, kde,            &
                               ims, ime, jms, jme, kms, kme,            &
                               ips, ipe, jps, jpe, kps, kpe,            &
                               grid%i_start(ij), grid%i_end(ij),                  &
                               grid%j_start(ij), grid%j_end(ij),                  &
                               k_start    , k_end                      )

     END DO chem_species_bdy_loop_2

   endif

   IF( config_flags%specified .or. config_flags%nested ) THEN
     dtbc = dtbc + dt
   ENDIF

#ifdef DM_PARALLEL
!-----------------------------------------------------------------------
! see above
!--------------------------------------------------------------
   CALL wrf_debug ( 200 , ' call HALO_RK_E' )
   IF      ( h_mom_adv_order <= 4 ) THEN
#    include "HALO_EM_E_3.inc"
   ELSE IF ( h_mom_adv_order <= 6 ) THEN
#    include "HALO_EM_E_5.inc"
   ELSE
     WRITE(wrf_err_message,*)'solve_em: invalid h_mom_adv_order = ',h_mom_adv_order
     CALL wrf_error_fatal(TRIM(wrf_err_message))
   ENDIF
#endif

#ifdef DM_PARALLEL
   if ( num_moist >= PARAM_FIRST_SCALAR  ) then
!-----------------------------------------------------------------------
! see above
!--------------------------------------------------------------
     CALL wrf_debug ( 200 , ' call HALO_RK_MOIST' )
     IF      ( h_mom_adv_order <= 4 ) THEN
#      include "HALO_EM_MOIST_E_3.inc"
     ELSE IF ( h_mom_adv_order <= 6 ) THEN
#      include "HALO_EM_MOIST_E_5.inc"
     ELSE
       WRITE(wrf_err_message,*)'solve_em: invalid h_mom_adv_order = ',h_mom_adv_order
       CALL wrf_error_fatal(TRIM(wrf_err_message))
     ENDIF
   endif
   if ( num_chem >= PARAM_FIRST_SCALAR ) then
!-----------------------------------------------------------------------
! see above
!--------------------------------------------------------------
     CALL wrf_debug ( 200 , ' call HALO_RK_CHEM' )
     IF      ( h_mom_adv_order <= 4 ) THEN
#      include "HALO_EM_CHEM_E_3.inc"
     ELSE IF ( h_mom_adv_order <= 6 ) THEN
#      include "HALO_EM_CHEM_E_5.inc"
     ELSE
       WRITE(wrf_err_message,*)'solve_em: invalid h_mom_adv_order = ',h_mom_adv_order
       CALL wrf_error_fatal(TRIM(wrf_err_message))
     ENDIF
   endif
#endif

   CALL wrf_debug ( 200 , ' call end of solve_em' )

! Finish timers if compiled with -DBENCH.
!#include <bench_solve_em_end.h>

! See comment before earlier #include of this file.
#define COPY_OUT
#include <em_scalar_derefs.inc>

end if 
!by walls
!by walls

!print*, '+++++++++++++++++++++++++++++++++++++++++++XXXWALLS010++++++++++++++++++++++++++++++++++++++++++++++'

!-if(grid%trace_use) call trace_exit("solve_ad_runge_kutta_looq")
  if (config_flags%mp_physics >= 0) then
    if (config_flags%specified .or. config_flags%nested) then
      sz = spec_zone
    else
      sz = 0
    endif

      call pop2restore(muts, "muts")
      call pop2restore(ph_tend, "ph_tend")

   if ( .not. non_hydrostatic) then
      call a_diagnose_w( ph_tend,a_ph_tend,a_ph_2,a_ph_1,&
                     a_w_2,muts,a_muts,dt_rk,a_u_2,a_v_2,ht,cf1,cf2,cf3,rdx,rdy,msft,ide,jde,&
                     ims,ime,jms,jme,kms,kme,&
                     max(grid%i_start(ij),ids+sz),  &
                     min(grid%i_end(ij),ide-1-sz),    &
                     max(grid%j_start(ij),jds+sz),  &
                     min(grid%j_end(ij),jde-1-sz),k_end )

    endif

    call pop2restore(al,p, "al,p")
    call pop2restore(moist_2, "moist_2")
    call pop2restore(mu_2,muts, "mu_2,muts")
    call pop2restore(ph_2,t_2, "ph_2,t_2")

    call a_calc_p_rho_phi( moist_2,a_moist_2,num_3d_m,al,a_al,alb,mu_2,&
                      a_mu_2,muts,a_muts,ph_2,a_ph_2,p,a_p,pb,t_2,a_t_2,p0,t0,dnw,&
                      rdnw,rdn,non_hydrostatic,ide,jde,kde,ims,ime,jms,jme,kms,kme,&
                      max(grid%i_start(ij),ids+sz),  &
                      min(grid%i_end(ij),ide-1-sz),    &
                      max(grid%j_start(ij),jds+sz),  &
                      min(grid%j_end(ij),jde-1-sz),k_start,k_end )

       its = max(grid%i_start(ij),ids+sz)
       ite = min(grid%i_end(ij),ide-1-sz)
       jts = max(grid%j_start(ij),jds+sz)
       jte = min(grid%j_end(ij),jde-1-sz)

       call a_moist_physics_finish_em( a_t_2, a_t_1, t0, &
                                    a_h_diabatic, dtm, ide, jde, kde, &
                                    ims, ime, jms, jme, kms, kme, &
                                    its, ite, jts, jte, k_start,k_end )


!        CALL moist_physics_prep_em( t_2, t_1, t0, rho,                &
!                                    al, alb, p, p8w, p0, pb,          &
!                                    ph_2, phb, pi_phy, p_phy,         &
!                                    z, z_at_w, dz8w,                  &
!                                    dtm, h_diabatic,                  &
!                                    config_flags,fnm, fnp,            &
!                                    ids, ide, jds, jde, kds, kde,     &
!                                    ims, ime, jms, jme, kms, kme,     &
!                                    max(grid%i_start(ij),ids+sz),  &
!                                    min(grid%i_end(ij),ide-1-sz),    &
!                                    max(grid%j_start(ij),jds+sz),  &
!                                    min(grid%j_end(ij),jde-1-sz),k_start,k_end )

!---Restore for lscond:
   call pop2restore(dz8w, "dz8w")
   call pop2restore(z, "z")
   call pop2restore(t_2, "t_2")
   call pop2restore(th_phy, "th_phy")
   call pop2restore(pi_phy, "pi_phy")
   call pop2restore(p_phy, "p_phy")
   call pop2restore(rho, "rho")
   call pop2restore(moist_2, "moist_2")

  if (config_flags%mp_physics ==1)then
     call kessler_b(t_2, a_t_2, moist_2(ims,kms,jms,P_QV),  a_moist_2(ims,kms,jms,P_QV),&
                              moist_2(ims,kms,jms,P_QC),  a_moist_2(ims,kms,jms,P_QC),&
                              moist_2(ims,kms,jms,P_QR),  a_moist_2(ims,kms,jms,P_QR),&
                              rho, a_rho, p_phy, a_p_phy, pi_phy, a_pi_phy, dtm&
                              , z, xlv, cp, ep_2,svp1, svp2, svp3, svpt0, rhowater, dz8w, rainnc, &
                              a_rainnc, rainncv, a_rainncv, ids, ide, jds, jde, kds, kde, ims, ime, &
                              jms, jme, kms, kme, &
                              max(grid%i_start(ij),ids+sz),          &
                              min(grid%i_end(ij),ide-1-sz),          &
                              max(grid%j_start(ij),jds+sz),          &
                              min(grid%j_end(ij),jde-1-sz),k_start    , min(k_end,kde-1)        )
  elseif(config_flags%mp_physics ==0)then
        call a_lscond ( t_2,a_t_2,p_phy,a_p_phy,moist_2(ims,kms,jms,P_QV), &
                    a_moist_2(ims,kms,jms,P_QV),rho,a_rho,&
                    pi_phy,a_pi_phy,r_v,xlv,cp,ep_2,svp1,svp2,svp3,svpt0,dz8w,a_dz8w, &
                    rainnc,a_rainnc,rainncv,a_rainncv,ims,ime,jms,jme,kms,kme, &
                    its, ite, jts, jte, min(k_end,kde-1) )
  endif
!-----Output: a_t_2,a_p_phy,a_moist_2,a_rho,a_pi_phy,a_rainnc,a_rainncv,a_dz8w

!print*, '+++++++11111111111111111111111111111111111111111111'

!---From: module_big_step_utilities_em_ad.F
    call a_moist_physics_prep_em( t_2, a_t_2, t_1, a_t_1, t0, rho, a_rho, &
                                  al, a_al, alb, p, a_p, p8w, a_p8w, p0, &
                                  pb, ph_2, a_ph_2, phb, pi_phy, a_pi_phy, &
                                  p_phy, a_p_phy, z, a_z, z_at_w, a_z_at_w, &
                                  dz8w, a_dz8w, h_diabatic, a_h_diabatic, fnm, fnp, &
                                  ide, jde, kde, ims, ime, jms, jme, kms, kme, &
                                  its, ite, jts, jte, k_start,k_end )

!-----Output: a_t_2,a_t_1,a_rho,a_al,a_p,a_p8w,a_ph_2,a_pi_phy,a_p_phy,a_z,a_z_at_w,a_dz8w,a_h_diabatic

endif  ! micro phy
!------------------------------

!-if(grid%trace_use) call trace_entry("solve_ad_a_runge_kutta_loop")

a_runge_kutta_loop: do rk_step = rk_order, 1, -1

    dtm = dt
    if (rk_order .eq. 1) then
      if (step_number .ne. 1) then
        number_of_small_timesteps = 2*time_step_sound
        dt_rk = dt
        dtm = 2*dt
      else
        number_of_small_timesteps = time_step_sound
        dt_rk = dt/2.
        dtm = dt
      endif
      dts_rk = dts
    else if (rk_order .eq. 2) then
      if (rk_step .eq. 1) then
        dt_rk = 0.5*dt
        dts_rk = dts
        number_of_small_timesteps = time_step_sound/2
      else
        dt_rk = dt
        dts_rk = dts
        number_of_small_timesteps = time_step_sound
      endif
    else if (rk_order .eq. 3) then
      if (rk_step .eq. 1) then
        dt_rk = dt/3.
        dts_rk = dt_rk
        number_of_small_timesteps = 1
      else if (rk_step .eq. 2) then
        dt_rk = 0.5*dt
        dts_rk = dts
        number_of_small_timesteps = time_step_sound/2
      else
        dt_rk = dt
        dts_rk = dts
        number_of_small_timesteps = time_step_sound
      endif
    endif

    if ( .not. non_hydrostatic) then
!-----Restore for diagnose_w:
      if(grid%trace_use) call trace_entry("restore")
      call pop2restore(ph_tend, "ph_tend")
      if(grid%trace_use) call trace_exit("restore")

!-----From: module_big_step_utilities_em_ad.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++032++++++++++++++++++++++++++++++++++++++++++++++++++'
      call a_diagnose_w( ph_tend,a_ph_tend,a_ph_2,a_ph_1,a_w_2,muts,a_muts,dt_rk, &
                         a_u_2,a_v_2,ht,cf1,cf2,cf3,rdx,rdy,msft, &
                         ide,jde,ims,ime,jms,jme,kms,kme, &
                         grid%i_start(ij),grid%i_end(ij), &
                         grid%j_start(ij),grid%j_end(ij),k_end )

!-----Output: a_ph_tend,a_ph_2,a_ph_1,a_w_2,a_u_2,a_v_2

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_DIAGNOSE_W.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
    endif

!---Restore for calc_p_rho_phi:
    if(grid%trace_use) call trace_entry("restore")
    call pop2restore(mu_2,muts, "mu_2,muts")
    call pop2restore(ph_2,t_2, "ph_2,t_2")
    if(grid%trace_use) call trace_exit("restore")

!---From: module_big_step_utilities_em_ad.F
!print*, '++++++++++++++++++++++++++++++++++++++++++++++033++++++++++++++++++++++++++++++++++++++++++++++++++'
    call a_calc_p_rho_phi( moist_2,a_moist_2,num_3d_m,al,a_al,alb,mu_2, &
                           a_mu_2,muts,a_muts,ph_2,a_ph_2,p,a_p,pb,t_2,a_t_2,p0,t0, &
                           dnw,rdnw,rdn,non_hydrostatic, &
                           ide,jde,kde,ims,ime,jms,jme,kms,kme, &
                           grid%i_start(ij),grid%i_end(ij), &
                           grid%j_start(ij),grid%j_end(ij), &
                           k_start,k_end )

!---Output: a_moist_2,a_al,a_mu_2,a_muts,a_ph_2,a_p,a_t_2
#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_CALC_P_RHO_PHI.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!---------------------------------------------------------------------------------

  a_moist_scalar_advance: if (num_3d_m .ge. param_first_scalar) then

    a_moist_variable_loop2: do im = num_3d_m, param_first_scalar, -1

!---Restore for a_rk_update_scalar:
    if(grid%trace_use) call trace_entry("restore")
    call pop2restore(moist_1,moist_2, "moist_1,moist_2")
    call pop2restore(advect_tend, "advect_tend")
    if(grid%trace_use) call trace_exit("restore")

    its = max(grid%i_start(ij)-1,ids)
    ite = min(grid%i_end(ij)+1,ide)
    jts = max(grid%j_start(ij)-1,jds)
    jte = min(grid%j_end(ij)+1,jde)

!-------From: module_em_ad.F
        call a_rk_update_scalar( im,im,moist_1(ims,kms,jms,im),a_moist_1(ims,kms,jms,im), &
                                 moist_2(ims,kms,jms,im),a_moist_2(ims,kms,jms,im), &
                                 moist_tend(ims,kms,jms,im),a_moist_tend(ims,kms,jms,im), &
                                 advect_tend,a_advect_tend, &
                                 msft,mu_1,a_mu_1,mu_2,a_mu_2,mub, &
                                 rk_step,dt_rk,spec_zone,epsts,leapfrog,config_flags, &
                                 ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme, &
                                 its, ite, jts, jte, k_start,k_end )
!-------Output: a_moist_1,a_moist_2,a_moist_tend,a_advect_tend,a_mu_1,a_mu_2

#ifdef DM_PARALLEL
    if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_RK_UPDATE_SCALAR.inc"
    if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

       if (config_flags%nested .and. rk_step .eq. 1) then
          if (im .eq. p_qc) then
!-----------From: module_bc_em_ad.F
            call a_spec_bdy_scalar( a_moist_tend(ims,kms,jms,im),a_rqc_bth,spec_bdy_width,spec_zone, &
                                    ijds,ijde, &
                                    ids,ide,jds,jde,kds,kde, &
                                    ims,ime,jms,jme,kms,kme, &
                                    grid%i_start(ij),grid%i_end(ij), &
                                    grid%j_start(ij),grid%j_end(ij), &
                                    k_start,k_end )
!-----------Output: a_moist_tend
          else if (im .eq. p_qr) then
            call a_spec_bdy_scalar( a_moist_tend(ims,kms,jms,im),a_rqr_bth,spec_bdy_width,spec_zone, &
                                    ijds,ijde, &
                                    ids,ide,jds,jde,kds,kde, &
                                    ims,ime,jms,jme,kms,kme, &
                                    grid%i_start(ij),grid%i_end(ij), &
                                    grid%j_start(ij),grid%j_end(ij), &
                                    k_start,k_end )
          else if (im .eq. p_qi) then
            call a_spec_bdy_scalar( a_moist_tend(ims,kms,jms,im),a_rqi_bth,spec_bdy_width,spec_zone, &
                                    ijds,ijde, &
                                    ids,ide,jds,jde,kds,kde, &
                                    ims,ime,jms,jme,kms,kme, &
                                    grid%i_start(ij),grid%i_end(ij), &
                                    grid%j_start(ij),grid%j_end(ij), &
                                    k_start,k_end )
          else if (im .eq. p_qs) then
            call a_spec_bdy_scalar( a_moist_tend(ims,kms,jms,im),a_rqs_bth,spec_bdy_width,spec_zone, &
                                    ijds,ijde, &
                                    ids,ide,jds,jde,kds,kde, &
                                    ims,ime,jms,jme,kms,kme, &
                                    grid%i_start(ij),grid%i_end(ij), &
                                    grid%j_start(ij),grid%j_end(ij), &
                                    k_start,k_end )
          else if (im .eq. p_qg) then
            call a_spec_bdy_scalar( a_moist_tend(ims,kms,jms,im),a_rqg_bth,spec_bdy_width,spec_zone, &
                                    ijds,ijde, &
                                    ids,ide,jds,jde,kds,kde, &
                                    ims,ime,jms,jme,kms,kme, &
                                    grid%i_start(ij),grid%i_end(ij), &
                                    grid%j_start(ij),grid%j_end(ij), &
                                    k_start,k_end )
          endif
        endif

        if ((config_flags%specified .or. config_flags%nested) .and. rk_step .eq. 1) then
          if (im .eq. p_qv) then
            call a_spec_bdy_scalar( a_moist_tend(ims,kms,jms,im),a_rqv_bt,spec_bdy_width,spec_zone, &
                                    ijds,ijde, &
                                    ids,ide,jds,jde,kds,kde, &
                                    ims,ime,jms,jme,kms,kme, &
                                    grid%i_start(ij),grid%i_end(ij), &
                                    grid%j_start(ij),grid%j_end(ij), &
                                    k_start,k_end )
          endif
        endif

!---Restore for a_rk_scalar_tend:
    if(grid%trace_use) call trace_entry("restore")
    call pop2restore(ru_m,rv_m,ww_m,alt, "ru_m,rv_m,ww_m,alt")
    if(grid%trace_use) call trace_exit("restore")

        its = max(grid%i_start(ij)-3,ids)
        ite = min(grid%i_end(ij)+3,ide)
        jts = max(grid%j_start(ij)-3,jds)
        jte = min(grid%j_end(ij)+3,jde)

!-------From: module_em_ad.F
        call a_rk_scalar_tend( im,im,config_flags,rk_step, &
                               ru_m,a_ru_m,rv_m,a_rv_m,ww_m,a_ww_m,mut,a_mut, &
                               alt,a_alt,moist_1(ims,kms,jms,im),a_moist_1(ims,kms,jms,im), &
                               moist_2(ims,kms,jms,im),a_moist_2(ims,kms,jms,im), &
                               a_moist_tend(ims,kms,jms,im),a_advect_tend,qv_base, .true. , &
                               fnm,fnp,msfu,msfv,msft,rdx,rdy,rdn,rdnw,kvdif,xkmhd,a_xkmhd,leapfrog, &
                               ids,ide,jds,jde,kds,kde,&
                               ims,ime,jms,jme,kms,kme, &
                               its, ite, jts, jte, k_start,k_end )


!-------Output: a_ru_m,a_rv_m,a_ww_m,a_mut,a_alt,a_moist_1,a_moist_2,a_moist_tend,a_advect_tend,a_xkmhd

    end do a_moist_variable_loop2

#ifdef DM_PARALLEL
    if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_RK_SCALAR_TEND.inc"
    if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
  endif a_moist_scalar_advance

!------------------------------
!print*, '++++++++++++++++++++++++++++++++++++++++++++++034+++++++++++++++++++++++++++++++++++++++++++++++++'

!---Restore for a_small_step_finish:
    if(grid%trace_use) call trace_entry("restore")
    call pop2restore(ph_tend,rw_tend, "ph_tend,rw_tend")  !ADDED BY WALLS
    call pop2restore(c2a, "c2a")  !ADDED BY WALLS
    call pop2restore(a, "a")  !ADDED BY WALLS
    call pop2restore(alpha, "alpha")  !ADDED BY WALLS
    call pop2restore(gamma, "gamma")  !ADDED BY WALLS
    call pop2restore(mu_tend, "mu_tend")  !ADDED BY WALLS
    call pop2restore(php, "php")  !ADDED BY WALLS
    call pop2restore(cqu,cqv,cqw,"cqu,cqv,cqw")  !ADDED BY WALLS
    call pop2restore(mut,muu,muus,muv,muvs, "mut,muu,muus,muv,muvs")
    call pop2restore(ww1,u_save,v_save,w_save,t_save,ph_save, &
                    "ww1,u_save,v_save,w_save,t_save,ph_save")
    call pop2restore(u_2,v_2,w_2,t_2, "u_2,v_2,w_2,t_2")
    if(grid%trace_use) call trace_exit("restore")

    its = max(grid%i_start(ij)-1,ids)
    ite = min(grid%i_end(ij)+1,ide)
    jts = max(grid%j_start(ij)-1,jds)
    jte = min(grid%j_end(ij)+1,jde)

!---From: module_small_step_em_ad.F
    call a_small_step_finish( u_2,a_u_2,v_2,a_v_2,w_2,a_w_2,t_2,a_t_2,a_ph_2, &
                              a_mu_2,mut,a_mut,muts,a_muts,muu,a_muu, &
                              muus,a_muus,muv,a_muv,muvs,a_muvs, &
                              u_save,a_u_save,v_save,a_v_save,w_save,a_w_save, &
                              t_save,a_t_save,a_ph_save,a_mu_save,msfu,msfv,msft, &
			      number_of_small_timesteps,dts_rk, &
                              ide,jde,kds,kde, &
                              ims,ime,jms,jme,kms,kme, &
                              its, ite, jts, jte )

!-----Output: a_u_2,a_v_2,a_w_2,a_t_2,a_ph_2,a_muus,a_muv,a_muvs,a_u_save,a_v_save,a_w_save,a_t_save,a_ph_save,a_mu_save

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_SMALL_STEP_FINISH.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!---Restore for a_calc_mu_uv_1: (Already restored above)

    its = max(grid%i_start(ij)-1,ids)
    ite = min(grid%i_end(ij)+1,ide)
    jts = max(grid%j_start(ij)-1,jds)
    jte = min(grid%j_end(ij)+1,jde)

!---From: module_big_step_utilities_em_ad.F
    call a_calc_mu_uv_1( config_flags,a_muts,a_muus,a_muvs, &
                         ids,ide,jds,jde,ims,ime,jms,jme, &
                         its, ite, jts, jte )

!---Output: a_muts,a_muus,a_muvs

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_CALC_MU_UV_1.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!------------------------------
!-if(grid%trace_use) call trace_entry("solve_ad_a_small_steps")

  a_small_steps: do iteration = number_of_small_timesteps, 1, -1

!-----Restore for a_calc_p_rho:
      if(grid%trace_use) call trace_entry("restore")
      call pop2restore(mu_2,muts, "mu_2,muts")
      call pop2restore(ph_2,t_2, "ph_2,t_2")
      if(grid%trace_use) call trace_exit("restore")

      its = max(grid%i_start(ij)-1,ids)
      ite = min(grid%i_end(ij)+1,ide)
      jts = max(grid%j_start(ij)-1,jds)
      jte = min(grid%j_end(ij)+1,jde)

!-----From: module_small_step_em_ad.F
      call a_calc_p_rho( al,a_al,p,a_p,ph_2,a_ph_2,alt,a_alt,t_2,a_t_2,t_save,a_t_save, &
                         c2a,a_c2a,a_pm1,mu_2,a_mu_2,muts,a_muts, &
                         znu,t0,rdnw,dnw,smdiv,non_hydrostatic,iteration, &
                         ide,jde,kde,ims,ime,jms,jme,kms,kme, &
                         its,ite,jts,jte,k_start,k_end )

!-----Output: a_al,a_p,a_ph_2,a_alt,a_t_2,a_t_save,a_c2a,a_pm1,a_mu_2,a_muts
!print*, '++++++++++++++++++++++++++++++++++++++++++++++035+++++++++++++++++++++++++++++++++++++++++++++++++'

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_CALC_P_RHO.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

      if (config_flags%specified .or. config_flags%nested) then
        if (non_hydrostatic) then
          if (config_flags%specified) then
!-----------From: module_bc_ad.F
            call a_zero_grad_bdy( a_w_2,'w',spec_zone, &
                                  ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,&
                                  its,ite,jts,jte,k_start)
          else
!-----------Restore for a_spec_bdyupdate:

            call a_spec_bdyupdate( a_w_2,a_rw_tend,dts_rk,'h',spec_zone, &
                                   ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,&
                                   its,ite,jts,jte,k_start,k_end )
          endif

!---------Output: a_w_2,a_rw_tend

#ifdef DM_PARALLEL
          if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_SPEC_BDYUPDATE_W.inc"
          if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!---------Restore for a_spec_bdyupdate_ph:
          if(grid%trace_use) call trace_entry("restore")
          call pop2restore(ph_2, "ph_2")
          if(grid%trace_use) call trace_exit("restore")

!---------From: module_bc_em_ad.F
          call a_spec_bdyupdate_ph( ph_save,a_ph_save,ph_2,a_ph_2,ph_tend,a_ph_tend, &
                                    mu_tend,a_mu_tend,muts,a_muts,dts_rk,'h',spec_zone, &
                                    ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme,&
                                    its,ite,jts,jte,k_start,k_end )
!---------Output: a_ph_save,a_ph_2,a_ph_tend,a_mu_tend,a_muts

#ifdef DM_PARALLEL
          if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_SPEC_BDYUPDATE_PH.inc"
          if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

        endif
      endif

      if (non_hydrostatic) then

!-------Restore for a_advance_w:
        if(grid%trace_use) call trace_entry("restore")
        call pop2restore(muave, "muave")
        call pop2restore(ph_2, "ph_2")
        call pop2restore(w_2,ww,u_2,v_2,t_2save, "w_2,ww,u_2,v_2,t_2save")
        if(grid%trace_use) call trace_exit("restore")

!-------From: module_small_step_em_ad.F
        call a_advance_w( w_2,a_w_2,rw_tend,a_rw_tend,ww,a_ww, &
                          u_2,a_u_2,v_2,a_v_2,mu_2,a_mu_2,mut,a_mut, &
                          muave,a_muave,muts,a_muts,&
                          t_2save,a_t_2save,t_2,a_t_2,t_save,a_t_save, &
                          ph_2,a_ph_2,ph_save,a_ph_save,phb,ph_tend,a_ph_tend, &
                          ht,c2a,a_c2a,cqw,a_cqw,&
                          alt,a_alt,alb,a,a_a,alpha,a_alpha,gamma,a_gamma, &
                          rdx,rdy,dts,t0,epssm,fnm,fnp,rdnw,rdn, &
                          cf1,cf2,cf3,msft,config_flags, &
                          ids,ide,jds,jde,ims,ime,jms,jme,kms,kme, &
                          its,ite,jts,jte,k_start,k_end )

!-------Output: a_w_2,a_rw_tend,a_ww,a_u_2,a_v_2,a_mu_2,a_mut,a_muave,a_muts
!               a_t_2save,a_t_2,a_t_save,a_ph_2,a_ph_save,a_ph_tend,a_c2a,a_cqw
!               a_alt,a_a,a_alpha,a_gamma

#ifdef DM_PARALLEL
        if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_ADVANCE_W.inc"
        if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
      endif

!-----Restore for a_sumflux:
!-----From: module_small_step_em_ad.F
      call a_sumflux( a_u_2,a_v_2,a_ww,u_save,a_u_save,v_save,a_v_save,a_ww1, &
                      muu,a_muu,muv,a_muv,a_ru_m,a_rv_m,a_ww_m,msfu,msfv,&
                      iteration,number_of_small_timesteps, &
                      ide,jde,kde,ims,ime,jms,jme,kms,kme,&
                      its,ite,jts,jte,k_start,k_end )

!-----Output: a_u_2,a_v_2,a_ww,a_u_save,a_v_save,a_ww1,a_muu,a_muv,a_ru_m,a_rv_m,a_ww_m

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_SUMFLUX.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

      if (config_flags%specified .or. config_flags%nested) then
!-------Restore for spec_bdyupdate:
!-------From: module_bc_ad.F
        call a_spec_bdyupdate( a_muts,a_mu_tend,dts_rk,'m',spec_zone, &
                               ids,ide,jds,jde,1,ims,ime,jms,jme,1,1, &
                               grid%i_start(ij),grid%i_end(ij), &
                               grid%j_start(ij),grid%j_end(ij),1,1 )
        call a_spec_bdyupdate( a_mu_2,a_mu_tend,dts_rk,'m',spec_zone, &
                               ids,ide,jds,jde,1,ims,ime,jms,jme,1,1, &
                               grid%i_start(ij),grid%i_end(ij), &
                               grid%j_start(ij),grid%j_end(ij),1,1 )
        call a_spec_bdyupdate( a_t_2,a_t_tend,dts_rk,'t',spec_zone, &
                               ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme, &
                               grid%i_start(ij),grid%i_end(ij), &
                               grid%j_start(ij),grid%j_end(ij),k_start,k_end )

!-----Output: a_muts,a_mu_tend,a_mu_2,a_t_2,a_t_tend

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_SPEC_BDYUPDATE_TMU.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
      endif

!-----Restore for a_advance_mu_t:
      its = max(grid%i_start(ij)-2,ids)
      ite = min(grid%i_end(ij)+2,ide)
      jts = max(grid%j_start(ij)-2,jds)
      jte = min(grid%j_end(ij)+2,jde)

!-----From: module_small_step_em_ad.F
      call a_advance_mu_t( ww,a_ww,ww1,a_ww1,u_2,a_u_2,u_save,a_u_save,v_2,a_v_2,v_save,a_v_save, &
                           a_mu_2,a_mut,a_muave,a_muts,muu,a_muu,muv,a_muv,a_mudf, &
                           a_t_2,t_save,a_t_save,a_t_2save,a_t_tend, &
                           mu_tend,a_mu_tend,rdx,rdy,dts,epssm,dnw,fnm,fnp,rdnw, &
                           msfu,msfv,msft,config_flags, &
                           ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme, &
                           its,ite,jts,jte,k_start,k_end )

!-----Output: a_ww,a_ww1,a_u_2,a_u_save,a_v_2,a_v_save
!             a_mu_2,a_mut,a_muave,a_muts,a_muu,a_muv,a_mudf
!             a_t_2,a_t_save,a_t_2save,a_t_tend,a_mu_tend

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_ADVANCE_MU_T.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

      if (config_flags%specified .or. config_flags%nested) then
!-------Restore for a_spec_bdyupdate:
!-------From: module_bc_ad.F
        if(grid%trace_use) call trace_entry("restore")
        call a_spec_bdyupdate( a_v_2,a_rv_tend,dts_rk,'v',spec_zone, &
                               ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme, &
                               grid%i_start(ij),grid%i_end(ij), &
                               grid%j_start(ij),grid%j_end(ij),k_start,k_end )
        call a_spec_bdyupdate( a_u_2,a_ru_tend,dts_rk,'u',spec_zone, &
                               ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme, &
                               grid%i_start(ij),grid%i_end(ij), &
                               grid%j_start(ij),grid%j_end(ij),k_start,k_end )
        if(grid%trace_use) call trace_exit("restore")

!-------Output: a_u_2,a_ru_tend,a_v_2,a_rv_tend

#ifdef DM_PARALLEL
        if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_SPEC_BDYUPDATE_UV.inc"
        if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
      endif

!-----Restore for a_advance_uv:
      if(grid%trace_use) call trace_entry("restore")
      call pop2restore(mu_2, "mu_2")
      call pop2restore(p,al, "p,al")
      if(grid%trace_use) call trace_exit("restore")

!-----From: module_small_step_em_ad.F
      call a_advance_uv( a_u_2,a_ru_tend,a_v_2,a_rv_tend,p,a_p,pb,ph_2,a_ph_2,php,a_php, &
                         alt,a_alt,al,a_al,mu_2,a_mu_2,muu,a_muu,&
                         cqu,a_cqu,muv,a_muv,cqv,a_cqv,a_mudf,rdx,rdy,dts,cf1,cf2,cf3, &
                         fnm,fnp,emdiv,rdnw,config_flags,spec_zone,non_hydrostatic,ids, &
                         ide,jds,jde,kde,ims,ime,jms,jme,kms,kme, &
                         its,ite,jts,jte,k_start,k_end )

!-----Output: a_u_2,a_ru_tend,a_v_2,a_rv_tend,a_p,a_ph_2,a_php
!             a_alt,a_al,a_mu_2,a_muu,a_cqu,a_muv,a_cqv,a_mudf

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_ADVANCE_UV.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
  end do a_small_steps
!print*, '+++++++2222222222222222222222222222222222222222222222'


!-if(grid%trace_use) call trace_exit("solve_ad_a_small_steps")

!------------------------------

    if (non_hydrostatic) then
!-----Restore for a_calc_coef_w:

      its = max(grid%i_start(ij)-1,ids)
      ite = min(grid%i_end(ij)+1,ide)
      jts = max(grid%j_start(ij)-1,jds)
      jte = min(grid%j_end(ij)+1,jde)

!-----From: module_small_step_em_ad.F
      call a_calc_coef_w( a,a_a,alpha,a_alpha,gamma,a_gamma,mut,a_mut, &
                          cqw,a_cqw,rdn,rdnw,c2a,a_c2a,dts,g,epssm, &
                          ide,jde,kde,ims,ime,jms,jme,kms,kme,&
                          its,ite,jts,jte )

!-----Output: a_a,a_alpha,a_gamma,a_mut,a_cqw,a_c2a

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_CALC_COEF_W.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
    endif

!-----Restore for a_calc_p_rho:
      if(grid%trace_use) call trace_entry("restore")
      call pop2restore(muts, "muts")
      call pop2restore(ph_2,t_2, "ph_2,t_2")
      if(grid%trace_use) call trace_exit("restore")

!-----From: module_small_step_em_ad.F
      call a_calc_p_rho( al,a_al,p,a_p,ph_2,a_ph_2,alt,a_alt,t_2,a_t_2,t_save,a_t_save, &
                         c2a,a_c2a,a_pm1,mu_2,a_mu_2,muts,a_muts, &
                         znu,t0,rdnw,dnw,smdiv,non_hydrostatic,0, &
                         ide,jde,kde,ims,ime,jms,jme,kms,kme, &
                         its,ite,jts,jte,k_start,k_end )

!-----Output: a_al,a_p,a_ph_2,a_alt,a_t_2,a_t_save,a_c2a,a_pm1,a_mu_2,a_muts

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_CALC_P_RHO.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

!---Restore for small_step_prep
    if(grid%trace_use) call trace_entry("restore")
    call pop2restore(mu_1,mu_2,muu,muv,mut, "mu_1,mu_2,muu,muv,mut")
    call pop2restore(p, "p")
    call pop2restore(u_1,u_2,v_1,v_2,w_1,w_2,t_1,t_2,ph_2, &
                    "u_1,u_2,v_1,v_2,w_1,w_2,t_1,t_2,ph_2")
    if(grid%trace_use) call trace_exit("restore")

!---From: module_small_step_em_ad.F
    call a_small_step_prep( u_1,a_u_1,u_2,a_u_2,v_1,a_v_1,v_2,a_v_2,w_1,a_w_1,w_2,a_w_2, &
                            t_1,a_t_1,t_2,a_t_2,a_ph_1,a_ph_2, &
                            mub,mu_1,a_mu_1,mu_2,a_mu_2,muu,a_muu,muus,a_muus, &
                            muv,a_muv,muvs,a_muvs,mut,a_mut,muts,a_muts,a_mudf, &
                            a_u_save,a_v_save,a_w_save,a_t_save,a_ph_save,a_mu_save,a_ww,a_ww1, &
                            a_c2a,pb,p,a_p,alt,a_alt,msfu,msfv,msft,rk_step,leapfrog, &
                            ide,jde,kde,ims,ime,jms,jme,kms,kme, &
                            its,ite,jts,jte,k_start,k_end )

!-----Output: a_u_1,a_u_2,a_v_1,a_v_2,a_w_1,a_w_2,a_t_1,a_t_2,a_ph_1,a_ph_2
!             a_mu_1,a_mu_2,a_muu,a_muus,a_muv,a_muvs,a_mut,a_muts,a_mudf
!             a_u_save,a_v_save,a_w_save,a_t_save,a_ph_save,a_mu_save,a_ww,a_ww1
!             a_c2a,a_p,a_alt

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_SMALL_STEP_PREP.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

    if (config_flags%specified .or. config_flags%nested) then

      its = max(grid%i_start(ij)-2,ids)
      ite = min(grid%i_end(ij)+2,ide)
      jts = max(grid%j_start(ij)-2,jds)
      jte = min(grid%j_end(ij)+2,jde)

!-----From: module_bc_em_ad.F
      call a_spec_bdy_dry( config_flags,a_ru_tend,a_rv_tend,a_ph_tend,a_t_tend, &
                           a_rw_tend,a_mu_tend,a_u_bt,a_v_bt,a_ph_bt,a_t_bt, &
                           a_w_bt,a_mu_bt,spec_bdy_width,spec_zone, &
                           ijds,ijde,ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme,&
                           its,ite,jts,jte,k_start,k_end )

!-----Output: a_ru_tend,a_rv_tend,a_ph_tend,a_t_tend,a_rw_tend,a_mu_tend

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_SPEC_BDY_DRY.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
    endif

!---From: module_em_ad.F
!---Restore for a_rk_addtend_dry:

      its = max(grid%i_start(ij)-2,ids)
      ite = min(grid%i_end(ij)+2,ide)
      jts = max(grid%j_start(ij)-2,jds)
      jte = min(grid%j_end(ij)+2,jde)

    call a_rk_addtend_dry( a_ru_tend,a_rv_tend,a_rw_tend,a_ph_tend,a_t_tend, &
                           a_ru_tendf,a_rv_tendf,a_rw_tendf,a_ph_tendf,a_t_tendf, &
                           a_u_save,a_v_save,a_w_save,a_ph_save,a_t_save,rk_step,h_diabatic, &
                           a_mut,msft,msfu,msfv, &
                           ide,jde,ims,ime,jms,jme,kms,kme,&
                           its,ite,jts,jte,k_start,k_end )

!---Output: a_ru_tend,a_rv_tend,a_rw_tend,a_ph_tend,a_t_tend, &
!           a_ru_tendf,a_rv_tendf,a_rw_tendf,a_ph_tendf,a_t_tendf, &
!           a_u_save,a_v_save,a_w_save,a_ph_save,a_t_save,a_mut

#ifdef DM_PARALLEL
    if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_RK_ADDTEND_DRY.inc"
    if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

    if( (config_flags%specified .or. config_flags%nested) .and. rk_step==1 ) then
!-----Restore for a_relax_bdy_dry

      its = max(grid%i_start(ij)-2,ids)
      ite = min(grid%i_end(ij)+2,ide)
      jts = max(grid%j_start(ij)-2,jds)
      jte = min(grid%j_end(ij)+2,jde)

!-----From: module_bc_em_ad.F
      call a_relax_bdy_dry( config_flags,a_u_save,a_v_save,a_ph_save,a_t_save,a_w_save, &
                            a_mu_tend,a_ru,a_rv,ph_2,a_ph_2,t_2,a_t_2, &
                            w_2,a_w_2,a_mu_2,mut,a_mut,a_u_b,a_v_b,a_ph_b,a_t_b,a_w_b, &
                            a_mu_b,a_u_bt,a_v_bt,a_ph_bt,a_t_bt,a_w_bt,a_mu_bt,spec_bdy_width, &
                            spec_zone,relax_zone,dtbc,fcx,gcx, &
                            ijds,ijde,ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme, &
                            its,ite,jts,jte,k_start,k_end )

!-----Output: a_u_save,a_v_save,a_ph_save,a_t_save,a_w_save, &
!             a_mu_tend,a_ru,a_rv,a_ph_2,a_t_2,a_w_2,a_mu_2,a_mut

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_RELAX_BDY_DRY.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
    endif


!  IF (rk_step == 1 ) then
!
!    call a_surface_drag(ru_tendf, a_ru_tendf, rv_tendf, a_rv_tendf, &
!                        u_2, a_u_2, v_2, a_v_2, xland, &
!                        muu, a_muu, muv, a_muv, z, &
!                        a_z, z_at_w, a_z_at_w, &
!                        ids, ide, jds, jde, kds, kde, &
!                        ims, ime, jms, jme, kms, kme, &
!                        grid%i_start(ij), grid%i_end(ij), &
!                        grid%j_start(ij), grid%j_end(ij), &
!                        k_start, k_end )
!   ENDIF
!---------------------------------------------------------------------------------------------
!

!---Restore for rk_tendency
    if(grid%trace_use) call trace_entry("restore")
    call pop2restore(mu_2, "mu_2")
    call pop2restore(cqu,cqv,cqw, "cqu,cqv,cqw")
    call pop2restore(ru,rv,rw,ww,al, "ru,rv,rw,ww,al")
    if(grid%trace_use) call trace_exit("restore")

    its = max(grid%i_start(ij)-3,ids)
    ite = min(grid%i_end(ij)+3,ide)
    jts = max(grid%j_start(ij)-3,jds)
    jte = min(grid%j_end(ij)+3,jde)


!---From: module_em_ad.F

    call a_rk_tendency1( config_flags,rk_step,a_ru_tend,a_rv_tend,a_rw_tend, &
                         a_ph_tend,a_t_tend,a_ru_tendf,a_rv_tendf,a_rw_tendf, &
                         a_t_tendf,a_mu_tend,a_u_save,a_v_save,a_w_save,a_ph_save, &
                         a_t_save,ru,a_ru,rv,a_rv,rw,a_rw,ww,a_ww, &
                         u_2,a_u_2,v_2,a_v_2,w_2,a_w_2,t_2,a_t_2,ph_2,a_ph_2, &
                         u_1,a_u_1,v_1,a_v_1,w_1,a_w_1,t_1,a_t_1,ph_1,a_ph_1,phb,t_init, &
                         mu_2,a_mu_2,mut,a_mut,muu,a_muu,muv,a_muv,mub, &
                         al,a_al,alt,a_alt,p,a_p,pb,php,a_php,cqu,a_cqu,cqv,a_cqv,cqw,a_cqw, &
                         u_base,v_base,z_base,msfu,msfv,msft, &
                         f,e,sina,cosa,fnm,fnp,rdn,rdnw,dt,rdx,rdy,kvdif,xkmhd,a_xkmhd, &
                         cf1,cf2,cf3,cfn,cfn1,non_hydrostatic,leapfrog, &
                         ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme, &
                         its,ite,jts,jte,k_start,k_end )

    call a_rk_tendency2( config_flags,rk_step,a_ru_tend,a_rv_tend,a_rw_tend,a_ph_tend,a_t_tend, &
                         a_ru_tendf,a_rv_tendf,a_rw_tendf,a_t_tendf,a_mu_tend, &
                         a_u_save,a_v_save,a_w_save,a_ph_save,a_t_save, &
                         ru,a_ru,rv,a_rv,rw,a_rw,ww,a_ww,u_2,a_u_2,v_2,a_v_2, &
                         w_2,a_w_2,t_2,a_t_2,ph_2,a_ph_2, &
                         u_1,a_u_1,v_1,a_v_1,w_1,a_w_1,t_1,a_t_1,ph_1,a_ph_1, &
                         phb,t_init,mu_2,a_mu_2,mut,a_mut,muu,a_muu,muv,a_muv,mub, &
                         al,a_al,alt,a_alt,p,a_p,pb,php,a_php, &
                         cqu,a_cqu,cqv,a_cqv,cqw,a_cqw,u_base,v_base,z_base, &
                         msfu,msfv,msft,f,e,sina,cosa,fnm,fnp,rdn,rdnw,dt, &
                         rdx,rdy,kvdif,xkmhd,a_xkmhd, &
                         cf1,cf2,cf3,cfn,cfn1,non_hydrostatic,leapfrog, &
                         ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme,&
                         its,ite,jts,jte,k_start,k_end )


!-----Output: a_ru_tend,a_rv_tend,a_rw_tend,a_ph_tend,a_t_tend,a_ru_tendf,a_rv_tendf,a_rw_tendf, &
!             a_t_tendf,a_mu_tend,a_u_save,a_v_save,a_w_save,a_ph_save, &
!             a_t_save,a_ru,a_rv,a_rw,a_ww,a_u_2,a_v_2,a_w_2,a_t_2,a_ph_2, &
!             a_u_1,a_v_1,a_w_1,a_t_1,a_ph_1,a_mu_2,a_mut,a_muu,a_muv, &
!             a_al,a_alt,a_p,a_php,a_cqu,a_cqv,a_cqw

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_RK_TENDENCY.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif


  a_rk_step_is_one: if (rk_step .eq. 1) then

    its = max(grid%i_start(ij)-1,ids)
    ite = min(grid%i_end(ij)+1,ide)
    jts = max(grid%j_start(ij)-1,jds)
    jte = min(grid%j_end(ij)+1,jde)

    if (diff_opt .eq. 2 .or. diff_opt .eq. 1) then
!-------Resotore for a_calculate_km_kh:
!-------From: module_diffusion_em_ad.F

        call a_calculate_km_kh( config_flags,dt,dampcoef,zdamp,damp_opt, &
                                xkmh,xkmhd,a_xkmhd,xkmv,xkhh,xkhv,bn2,a_bn2,khdif,div,&
                                defor11,defor22,defor33,defor12,defor13,defor23, &
                                tke_2,p8w,a_p8w,t8w,a_t8w,th_phy,a_th_phy,t_phy,a_t_phy,&
                                p_phy,a_p_phy,moist_2,a_moist_2,dn,dnw,dx,dy,rdz,rdzw,num_3d_m, &
                                cf1,cf2,cf3,kh_tke_upper_bound, &
                                ids,ide,jds,jde,kde,ims,ime,jms,jme,kms,kme, &
!XXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLSXXXWALLS
!                               its,ite,jts,jte,k_start,k_end)  !REVISED BY WALLS
                          grid%i_start(ij),grid%i_end(ij), &    !ADDED BY WALLS
                          grid%j_start(ij),grid%j_end(ij), &    !ADDED BY WALLS
                          k_start,k_end )    !ADDED BY WALLS

!-------Output: a_p8w,a_t8w,a_th_phy,a_t_phy,a_p_phy,a_moist_2,a_bn2

#ifdef DM_PARALLEL
        if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_CALCULATE_KM_KH.inc"
        if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
  endif

!-Save for: phy_prep:
  if(grid%trace_use) call trace_entry("restore")
  call pop2restore(z, "z")
  if(grid%trace_use) call trace_exit("restore")

!-From module_big_step_utilities_em_ad.F
  call a_phy_prep( p,a_p,pb,ph_2,a_ph_2,phb,t_2,a_t_2,th_phy,a_th_phy, &
                   p_phy,a_p_phy,pi_phy,a_pi_phy,a_p8w,t_phy,a_t_phy,a_t8w, &
                   z,a_z,z_at_w,a_z_at_w,fnm,fnp, &
                   ide,jde,kde,ims,ime,jms,jme,kms,kme, &
                   its,ite,jts,jte,k_start,k_end )

!-----Output: a_p,a_ph_2,a_t_2,a_th_phy,a_p_phy,a_pi_phy,a_p8w,a_t_phy,a_t8w,a_z,a_z_at_w

      call a_init_zero_tendency( a_ru_tendf,a_rv_tendf,a_rw_tendf,a_ph_tendf,a_t_tendf,a_moist_tend,num_3d_m,ims,ime,jms,jme,kms,&
&kme,&
        max(grid%i_start(ij)-1,ids),  &
        min(grid%i_end(ij)+1,ide),    &
        max(grid%j_start(ij)-1,jds),  &
        min(grid%j_end(ij)+1,jde),k_start,k_end )

  endif a_rk_step_is_one

!---Restore for a_rk_step_prep
    if(grid%trace_use) call trace_entry("restore")
    call pop2restore(muu,muv, "muu,muv")
    if(grid%trace_use) call trace_exit("restore")

    its = max(grid%i_start(ij)-1,ids)
    ite = min(grid%i_end(ij)+1,ide)
    jts = max(grid%j_start(ij)-1,jds)
    jte = min(grid%j_end(ij)+1,jde)

!---From: module_em_ad.F
    call a_rk_step_prep( config_flags,u_2,a_u_2,v_2,a_v_2,w_2,a_w_2,a_ph_2, &
                         mu_2,a_mu_2,moist_2,a_moist_2,a_ru,a_rv,a_rw,a_ww,a_php,&
                         a_alt,muu,a_muu,muv,a_muv,mub,mut,a_mut, &
                         a_al,a_cqu,a_cqv,a_cqw,msfu,msfv,msft,dnw,rdx,rdy,num_3d_m, &
                         ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme, &
                         its,ite,jts,jte,k_start,k_end )

!-----Output: a_u_2,a_v_2,a_w_2,a_ph_2,a_mu_2,a_moist_2,a_ru,a_rv,a_rw,a_ww,a_php,&
!             a_alt,a_muu,a_muv,a_mut,a_al,a_cqu,a_cqv,a_cqw

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_RK_STEP_PREP.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif

end do a_runge_kutta_loop
!print*, '+++++++333333333333333333333333333333333333333333333333333++++++++'

!---if(grid%trace_use) call trace_exit("solve_ad_a_runge_kutta_loop")

#ifdef DM_PARALLEL
      if(grid%trace_use) call trace_entry("solve_ad_halo_comm")
#include "HALO_A_PHY_PREP.inc"
      if(grid%trace_use) call trace_exit("solve_ad_halo_comm")
#endif
  CALL wrf_debug ( 10 , 'DEBUG:  end solve_em_ad()' )

  if(grid%trace_use) call trace_exit("solve_em_ad")

RETURN

end subroutine solve_em_ad

!---------------------------------
!!!!  Add CUDU Here   !!!!!!!!
!--------------------------------

!        CALL wrf_debug ( 200 , ' call a_cumulus_driver' )
!        IF (cu_physics .eq. 5) then            !IF for CUDU
!           CALL wrf_debug(100,'in du_cps')

!              do j = grid%j_start(ij), min(grid%j_end(ij), jde-1)
!              do k = k_start, min(k_end, kde-1)
!              do i = grid%i_start(ij), min(grid%i_end(ij), ide-1)
!                 rho(i,k,j) = 1./alt(i,k,j)*(1.+moist_2(i,k,j,P_QV))
!                 u_phy(i,k,j) = 0.5*(u_2(i,k,j)+u_2(i+1,k,j))
!                 v_phy(i,k,j) = 0.5*(v_2(i,k,j)+v_2(i,k,j+1))
!                 rthcuten(i,k,j) = rthcuten(i,k,j)/mut(i,j)
!                 rqvcuten(i,k,j) = rqvcuten(i,k,j)/mut(i,j)
!              end do
!              end do
!              end do

!              do j = grid%j_start(ij), min(grid%j_end(ij), jde-1)
!              do k = k_start, kde-1
!              do i = grid%i_start(ij), min(grid%i_end(ij), ide-1)
!                 dz8w(i,k,j)= z_at_w(i,k+1,j)-z_at_w(i,k,j)
!              end do
!              end do
!              end do

!              do j = grid%j_start(ij), min(grid%j_end(ij), jde-1)
!              do i = grid%i_start(ij), min(grid%i_end(ij), ide-1)
!                 dz8w(i,kde,j) = 0.
!              end do
!              end do

!              CALL DUCU( ids,ide,jds,jde,kds,kde &
!              ,ims,ime,jms,jme,kms,kme &
!              ,grid%i_start(ij),min(grid%i_end(ij), ide-1)      &
!              ,grid%j_start(ij), min(grid%j_end(ij), jde-1)    &
!              ,k_start,min(k_end, kde-1) &
!              ,dt ,itimestep ,dx                    &
!              ,rho,raincv                       &
!              ,nca,u_phy ,v_phy                        &
!              ,th_phy,t_phy                   &
!              ,w_2                                           &
!              ,dz8w,z,p_phy                 &
!              ,pi_phy,grid%W0AVG,XLV              &
!              ,CP ,R_d ,R_v ,G ,EP_2             &
!              ,SVP1 ,SVP2 ,SVP3 ,SVPT0    &
!              ,stepcu                                   &
!              ,cu_act_flag ,warm_rain    &
!              ,HTOP,HBOT                           &
!              ,moist_2(ims,kms,jms,P_QV) &
!             ! optionals
!              ,rthcuten, rqvcuten )

!              do j = grid%j_start(ij), min(grid%j_end(ij), jde-1)
!              do i = grid%i_start(ij), min(grid%i_end(ij), ide-1)
!                 do k = k_start, min(k_end, kde-1)
!                    a_mut(I,J) = a_mut(I,J) + rqvcuten(I,K,J) * a_moist_tend(I,K,J,P_QV)
!                    a_rqvcuten(I,K,J) = a_rqvcuten(I,K,J) + a_moist_tend(I,K,J,P_QV) * mut(I,J)
!                    a_mut(I,J) = a_mut(I,J) + rthcuten(I,K,J) * a_t_tendf(I,K,J)
!                    a_rthcuten(I,K,J) = a_rthcuten(I,K,J) + a_t_tendf(I,K,J) * mut(I,J)
!                 end do
!                 a_raincv(I,J) = a_raincv(I,J) + a_rainc(I,J)
!              end do
!              end do

!              CALL DUCU_B( ids,ide,jds,jde,kds,kde &
!              ,ims,ime,jms,jme,kms,kme &
!              ,grid%i_start(ij),min(grid%i_end(ij), ide-1)      &
!              ,grid%j_start(ij), min(grid%j_end(ij), jde-1)    &
!              ,k_start,min(k_end, kde-1) &
!              ,dt ,itimestep ,dx                    &
!              ,rho,a_rho,raincv,a_raincv                       &
!              ,nca,u_phy ,v_phy                        &
!              ,th_phy,a_th_phy,t_phy,a_t_phy                   &
!              ,w_2                                           &
!              ,dz8w,a_dz8w,z,a_z,p_phy,a_p_phy                 &
!              ,pi_phy,grid%W0AVG,XLV              &
!              ,CP ,R_d ,R_v ,G ,EP_2             &
!              ,SVP1 ,SVP2 ,SVP3 ,SVPT0    &
!              ,stepcu                                   &
!              ,cu_act_flag ,warm_rain    &
!              ,HTOP,HBOT                           &
!              ,moist_2(ims,kms,jms,P_QV),a_moist_2(ims,kms,jms,P_QV)&
!              ,rthcuten,a_rthcuten, rqvcuten,a_rqvcuten ) ! optionals

!              do j = grid%j_start(ij), min(grid%j_end(ij), jde-1)
!              do k = k_start, min(k_end, kde-1)
!              do i = grid%i_start(ij), min(grid%i_end(ij), ide-1)
!                  a_rqvcuten(I,K,J) = a_rqvcuten(I,K,J) / mut(I,J)
!                  a_rthcuten(I,K,J) = a_rthcuten(I,K,J) / mut(I,J) 
!              end do
!              end do
!              end do
!          ENDIF
!---------------------------------
!!!! XIAO CUDU End Here   !!!!!!!!
!---------------------------------

