!WRF:MODEL_LAYER:PHYSICS
!

MODULE module_mp_nconvp

CONTAINS
!----------------------------------------------------------------
   SUBROUTINE lscond( th, p, qv, rho, pii                       &
                      ,r_v, xlv, cp                             &
                      ,EP2,SVP1,SVP2,SVP3,SVPT0                 &
                      ,dz8w                                     &
                      ,RAINNC, RAINNCV                          &
                      ,ids,ide, jds,jde, kds,kde                & ! domain dims
                      ,ims,ime, jms,jme, kms,kme                & ! memory dims
                      ,its,ite, jts,jte, kts,kte                & ! tile   dims
                                                                )
!----------------------------------------------------------------
   IMPLICIT NONE
!----------------------------------------------------------------
   !  based on MM5 code (JD November 2006)
!----------------------------------------------------------------
   INTEGER,      INTENT(IN   )    :: ids,ide, jds,jde, kds,kde, &
                                     ims,ime, jms,jme, kms,kme, &
                                     its,ite, jts,jte, kts,kte
   REAL   ,      INTENT(IN   )    :: r_v, xlv, cp
   REAL   ,      INTENT(IN   )    :: EP2,SVP1,SVP2,SVP3,SVPT0

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ),              &
         INTENT(INOUT) ::                                       &
                                                            th, &
                                                            qv

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ),              &
         INTENT(IN   ) ::                                       &
                                                           rho, &
                                                           pii, &
                                                           p  , &
                                                          dz8w 


   REAL, DIMENSION( ims:ime , jms:jme ),                        &
         INTENT(INOUT) ::                               RAINNC, &
                                                       RAINNCV

   ! local variables

   REAL :: TTEMP, ES1, QS1, DQV, COND, R1
   INTEGER :: i,j,k
!----------------------------------------------------------------

   DO j = jts, jte
   DO k = kts, kte
   DO i = its,ite
      TTEMP = PII(I,K,J)*TH(I,K,J)
      ES1 = 1000.*SVP1*EXP(SVP2*(TTEMP-SVPT0)/(TTEMP-SVP3))
      QS1 = EP2*ES1/(P(I,K,J)-ES1)
      DQV = QV(I,K,J) - QS1
      IF(DQV.GT.0.0)THEN
        R1 = 1. + XLV*XLV/(R_V*CP)*QS1/(TTEMP*TTEMP)
        COND = DQV/R1
        QV(I,K,J) = QV(I,K,J) - COND
        TTEMP = TTEMP + XLV/CP*COND
        TH(I,K,J) = TTEMP/PII(I,K,J)
        RAINNC(I,J) = RAINNC(I,J) + RHO(I,K,J)*COND*DZ8W(I,K,J)
      ENDIF
   ENDDO
   ENDDO
   ENDDO
  RETURN

  END SUBROUTINE lscond

!                           DISCLAIMER
!
!   This file was generated by TAF version 1.8.77
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!


subroutine g_lscond( th, g_th, p, g_p, qv, g_qv, rho, g_rho, pii, g_pii, r_v, xlv, cp, ep2, svp1, svp2, svp3, svpt0, dz8w, g_dz8w, &
&rainnc, g_rainnc, rainncv, g_rainncv, ids, ide, jds, jde, kds, kde, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.8.77  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real, intent(in) :: cp
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(in) :: dz8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ep2
real, intent(in) :: g_dz8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: g_pii(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_qv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_rainnc(ims:ime,jms:jme)
real, intent(inout) :: g_rainncv(ims:ime,jms:jme)
real, intent(in) :: g_rho(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: g_th(ims:ime,kms:kme,jms:jme)
integer, intent(in) :: ide
integer, intent(in) :: ids
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jde
integer, intent(in) :: jds
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kde
integer, intent(in) :: kds
integer, intent(in) :: kte
integer, intent(in) :: kts
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pii(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: qv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: r_v
real, intent(inout) :: rainnc(ims:ime,jms:jme)
real, intent(inout) :: rainncv(ims:ime,jms:jme)
real, intent(in) :: rho(ims:ime,kms:kme,jms:jme)
real, intent(in) :: svp1
real, intent(in) :: svp2
real, intent(in) :: svp3
real, intent(in) :: svpt0
real, intent(inout) :: th(ims:ime,kms:kme,jms:jme)
real, intent(in) :: xlv

!==============================================
! declare local variables
!==============================================
real cond
real dqv
real es1
real es1h
real g_cond
real g_dqv
real g_es1
real g_qs1
real g_r1
real g_ttemp
integer i
integer j
integer k
real qs1
real r1
real ttemp

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do j = jts, jte
  do k = 1, kte
    do i = its, ite
      g_ttemp = g_pii(i,k,j)*th(i,k,j)+g_th(i,k,j)*pii(i,k,j)
      ttemp = pii(i,k,j)*th(i,k,j)
      es1h = svp2*(ttemp-svpt0)/(ttemp-svp3)
      g_es1 = 1000.*g_ttemp*(svp2/(ttemp-svp3)-svp2*(ttemp-svpt0)/((ttemp-svp3)*(ttemp-svp3)))*svp1*exp(es1h)
      es1 = 1000.*svp1*exp(es1h)
      g_qs1 = g_es1*(ep2/(p(i,k,j)-es1)+ep2*es1/((p(i,k,j)-es1)*(p(i,k,j)-es1)))-g_p(i,k,j)*(ep2*es1/((p(i,k,j)-es1)*(p(i,k,j)-es1)&
&))
      qs1 = ep2*es1/(p(i,k,j)-es1)
      g_dqv = (-g_qs1)+g_qv(i,k,j)
      dqv = qv(i,k,j)-qs1
      if (dqv .gt. 0.) then
        g_r1 = g_qs1*(xlv*xlv/(r_v*cp)/(ttemp*ttemp))-g_ttemp*(2*xlv*xlv/(r_v*cp)*qs1*ttemp/(ttemp*ttemp*ttemp*ttemp))
        r1 = 1.+xlv*xlv/(r_v*cp)*qs1/(ttemp*ttemp)
        g_cond = g_dqv/r1-g_r1*(dqv/(r1*r1))
        cond = dqv/r1
        g_qv(i,k,j) = (-g_cond)+g_qv(i,k,j)
        g_ttemp = g_cond*(xlv/cp)+g_ttemp
        ttemp = ttemp+xlv/cp*cond
        g_th(i,k,j) = (-(g_pii(i,k,j)*(ttemp/(pii(i,k,j)*pii(i,k,j)))))+g_ttemp/pii(i,k,j)
        g_rainnc(i,j) = g_cond*rho(i,k,j)*dz8w(i,k,j)+g_dz8w(i,k,j)*rho(i,k,j)*cond+g_rainnc(i,j)+g_rho(i,k,j)*cond*dz8w(i,k,j)
        rainnc(i,j) = rainnc(i,j)+rho(i,k,j)*cond*dz8w(i,k,j)
      endif
    end do
  end do
end do

end subroutine g_lscond


!                           DISCLAIMER
!
!   This file was generated by TAF version 1.8.77
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!

!----------------------------------------------------------------
subroutine a_lscond( th, a_th, p, a_p, qv, a_qv, rho, a_rho, pii, a_pii, r_v, xlv, cp, ep2, svp1, svp2, svp3, svpt0, dz8w, a_dz8w, &
&rainnc, a_rainnc, rainncv, a_rainncv, ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kte )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.8.77  **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: ime
integer, intent(in) :: ims
integer, intent(in) :: jme
integer, intent(in) :: jms
integer, intent(in) :: kme
integer, intent(in) :: kms
real, intent(inout) :: a_dz8w(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_p(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_pii(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_qv(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_rainnc(ims:ime,jms:jme)
real, intent(inout) :: a_rainncv(ims:ime,jms:jme)
real, intent(inout) :: a_rho(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: a_th(ims:ime,kms:kme,jms:jme)
real, intent(in) :: cp
real, intent(in) :: dz8w(ims:ime,kms:kme,jms:jme)
real, intent(in) :: ep2
integer, intent(in) :: ite
integer, intent(in) :: its
integer, intent(in) :: jte
integer, intent(in) :: jts
integer, intent(in) :: kte
real, intent(in) :: p(ims:ime,kms:kme,jms:jme)
real, intent(in) :: pii(ims:ime,kms:kme,jms:jme)
real, intent(inout) :: qv(ims:ime,kms:kme,jms:jme)
real, intent(in) :: r_v
real, intent(inout) :: rainnc(ims:ime,jms:jme)
real, intent(inout) :: rainncv(ims:ime,jms:jme)
real, intent(in) :: rho(ims:ime,kms:kme,jms:jme)
real, intent(in) :: svp1
real, intent(in) :: svp2
real, intent(in) :: svp3
real, intent(in) :: svpt0
real, intent(inout) :: th(ims:ime,kms:kme,jms:jme)
real, intent(in) :: xlv

!==============================================
! declare local variables
!==============================================
real a_cond
real a_dqv
real a_es1
real a_qs1
real a_r1
real a_ttemp
real cond
real dqv
real es1
integer i
integer j
integer k
integer k2
real qs1
real qvh(lbound(qv,1):ubound(qv,1),lbound(qv,2):ubound(qv,2),lbound(qv,3):ubound(qv,3))
real r1
real thh(lbound(th,1):ubound(th,1),lbound(th,2):ubound(th,2),lbound(th,3):ubound(th,3))
#ifdef ADJOINT_NO_OPTIMIZE
real qvi(lbound(qv,1):ubound(qv,1),lbound(qv,2):ubound(qv,2),lbound(qv,3):ubound(qv,3))
real thi(lbound(th,1):ubound(th,1),lbound(th,2):ubound(th,2),lbound(th,3):ubound(th,3))
#endif
real ttemp

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
thh(:,:,:) = th(:,:,:)
qvh(:,:,:) = qv(:,:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a_cond = 0.
a_dqv = 0.
a_es1 = 0.
a_qs1 = 0.
a_r1 = 0.
a_ttemp = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
#ifdef ADJOINT_NO_OPTIMIZE
!----------------------------------------------
! FUNCTION AND TAPE COMPUTATIONS
!----------------------------------------------
do j = jts, jte
  do k = 1, kte
    do i = its, ite
      ttemp = pii(i,k,j)*th(i,k,j)
      es1 = 1000.*svp1*exp(svp2*(ttemp-svpt0)/(ttemp-svp3))
      qs1 = ep2*es1/(p(i,k,j)-es1)
      dqv = qv(i,k,j)-qs1
      if (dqv .gt. 0.) then
        r1 = 1.+xlv*xlv/(r_v*cp)*qs1/(ttemp*ttemp)
        cond = dqv/r1
        ttemp = ttemp+xlv/cp*cond
        rainnc(i,j) = rainnc(i,j)+rho(i,k,j)*cond*dz8w(i,k,j)
      endif
    end do
  end do
end do

!----------------------------------------------
! SAVE DEPENDEND VARIABLES
!----------------------------------------------
thi(:,:,:) = th(:,:,:)
qvi(:,:,:) = qv(:,:,:)
!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
qv(:,:,:) = qvh(:,:,:)
th(:,:,:) = thh(:,:,:)
#endif
do j = jts, jte
  a_cond = 0.
  a_dqv = 0.
  a_es1 = 0.
  a_qs1 = 0.
  a_r1 = 0.
  a_ttemp = 0.
  do k = kte, 1, -1
#ifdef ADJOINT_NO_OPTIMIZE
    qv(:,:,:) = qvh(:,:,:)
    th(:,:,:) = thh(:,:,:)
    do k2 = 1, k-1
      do i = its, ite
        ttemp = pii(i,k2,j)*th(i,k2,j)
        es1 = 1000.*svp1*exp(svp2*(ttemp-svpt0)/(ttemp-svp3))
        qs1 = ep2*es1/(p(i,k2,j)-es1)
        dqv = qv(i,k2,j)-qs1
        if (dqv .gt. 0.) then
          r1 = 1.+xlv*xlv/(r_v*cp)*qs1/(ttemp*ttemp)
          cond = dqv/r1
          qv(i,k2,j) = qv(i,k2,j)-cond
          ttemp = ttemp+xlv/cp*cond
          th(i,k2,j) = ttemp/pii(i,k2,j)
        endif
      end do
    end do
#endif
    do i = its, ite
      a_cond = 0.
      a_dqv = 0.
      a_es1 = 0.
      a_qs1 = 0.
      a_r1 = 0.
      a_ttemp = 0.
      ttemp = pii(i,k,j)*th(i,k,j)
! recompute : ttemp
! recompute : ttemp
      es1 = 1000.*svp1*exp(svp2*(ttemp-svpt0)/(ttemp-svp3))
! recompute : es1
! recompute : es1
      qs1 = ep2*es1/(p(i,k,j)-es1)
! recompute : qs1
! recompute : qs1
      dqv = qv(i,k,j)-qs1
! recompute : dqv
! recompute : dqv
      if (dqv .gt. 0.) then
        r1 = 1.+xlv*xlv/(r_v*cp)*qs1/(ttemp*ttemp)
! recompute : r1
! recompute : r1
        cond = dqv/r1
! recompute : cond
! recompute : cond
        ttemp = ttemp+xlv/cp*cond
#ifndef ADJOINT_NO_OPTIMIZE
        rainnc(i,j) = rainnc(i,j)+rho(i,k,j)*cond*dz8w(i,k,j)
#endif
! recompute : ttemp
! recompute : ttemp
        a_cond = a_cond+a_rainnc(i,j)*rho(i,k,j)*dz8w(i,k,j)
        a_dz8w(i,k,j) = a_dz8w(i,k,j)+a_rainnc(i,j)*rho(i,k,j)*cond
        a_rho(i,k,j) = a_rho(i,k,j)+a_rainnc(i,j)*cond*dz8w(i,k,j)
        a_pii(i,k,j) = a_pii(i,k,j)-a_th(i,k,j)*(ttemp/(pii(i,k,j)*pii(i,k,j)))
        a_ttemp = a_ttemp+a_th(i,k,j)/pii(i,k,j)
        a_th(i,k,j) = 0.
        a_cond = a_cond+a_ttemp*(xlv/cp)
        a_cond = a_cond-a_qv(i,k,j)
        a_dqv = a_dqv+a_cond/r1
        a_r1 = a_r1-a_cond*(dqv/(r1*r1))
        a_cond = 0.
! recdepend vars : i,j,k,pii,th
! recompute pos : ASSIGN_STMT lscond.F90:48
! recompute vars : ttemp
        ttemp = pii(i,k,j)*th(i,k,j)
! recompute : ttemp
! recompute vars : ttemp
        a_qs1 = a_qs1+a_r1*(xlv*xlv/(r_v*cp)/(ttemp*ttemp))
        a_ttemp = a_ttemp-a_r1*(2*xlv*xlv/(r_v*cp)*qs1*ttemp/(ttemp*ttemp*ttemp*ttemp))
        a_r1 = 0.
      endif
      a_qs1 = a_qs1-a_dqv
      a_qv(i,k,j) = a_qv(i,k,j)+a_dqv
      a_dqv = 0.
      a_es1 = a_es1+a_qs1*(ep2/(p(i,k,j)-es1)+ep2*es1/((p(i,k,j)-es1)*(p(i,k,j)-es1)))
      a_p(i,k,j) = a_p(i,k,j)-a_qs1*(ep2*es1/((p(i,k,j)-es1)*(p(i,k,j)-es1)))
      a_qs1 = 0.
! recdepend vars : i,j,k,pii,th
! recompute pos : ASSIGN_STMT lscond.F90:48
! recompute vars : ttemp
      ttemp = pii(i,k,j)*th(i,k,j)
! recompute : ttemp
! recompute vars : ttemp
      a_ttemp = a_ttemp+1000.*a_es1*svp1*(svp2/(ttemp-svp3)-svp2*(ttemp-svpt0)/((ttemp-svp3)*(ttemp-svp3)))*exp(svp2*(ttemp-svpt0)/&
&(ttemp-svp3))
      a_es1 = 0.
      a_pii(i,k,j) = a_pii(i,k,j)+a_ttemp*th(i,k,j)
      a_th(i,k,j) = a_th(i,k,j)+a_ttemp*pii(i,k,j)
      a_ttemp = 0.
    end do
  end do
end do

!----------------------------------------------
! GET DEPENDEND VARIABLES
!----------------------------------------------
#ifdef ADJOINT_NO_OPTIMIZE
qv(:,:,:) = qvi(:,:,:)
th(:,:,:) = thi(:,:,:)
#else
qv(:,:,:) = qvh(:,:,:)
th(:,:,:) = thh(:,:,:)
#endif


!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine a_lscond

END MODULE module_mp_nconvp
