!        Generated by TAPENADE     (INRIA, Tropics team)
!  Tapenade 3.7 (r4786) - 21 Feb 2013 15:53
!
!  Differentiation of gwdo in reverse (adjoint) mode (with options r8):
!   gradient     of useful results: rublten p3di u3d dusfcg z dvsfcg
!                dtauy3d rvblten t3d qv3d pi3d v3d dtaux3d mut
!   with respect to varying inputs: rublten p3di u3d dusfcg z dvsfcg
!                dtauy3d rvblten t3d qv3d pi3d v3d dtaux3d mut
! WRf:model_layer:physics
!
!
!
!
!
module a_module_bl_gwdo
contains
!
!-------------------------------------------------------------------
!
SUBROUTINE GWDO_B(u3d, u3db, v3d, v3db, t3d, t3db, qv3d, qv3db, p3d, &
&  p3di, p3dib, pi3d, pi3db, z, zb, rublten, rubltenb, rvblten, rvbltenb&
&  , dtaux3d, dtaux3db, dtauy3d, dtauy3db, dusfcg, dusfcgb, dvsfcg, &
&  dvsfcgb, var2d, oc12d, oa2d1, oa2d2, oa2d3, oa2d4, ol2d1, ol2d2, ol2d3&
&  , ol2d4, znu, znw, mut, mutb, p_top, cp, g, rd, rv, ep1, pi, dt, dx, &
&  kpbl2d, itimestep, ids, ide, jds, jde, kds, kde, ims, ime, jms, jme, &
&  kms, kme, its, ite, jts, jte, kts, kte)
  IMPLICIT NONE
!
!
!------------------------------------------------------------------------------
!
!-- u3d 3d u-velocity interpolated to theta points (m/s)
!-- v3d 3d v-velocity interpolated to theta points (m/s)
!-- t3d temperature (k)
!-- qv3d 3d water vapor mixing ratio (kg/kg)
!-- p3d 3d pressure (pa)
!-- p3di 3d pressure (pa) at interface level
!-- pi3d 3d exner function (dimensionless)
!-- rublten u tendency due to
! pbl parameterization (m/s/s)
!-- rvblten v tendency due to
!-- cp heat capacity at constant pressure for dry air (j/kg/k)
!-- g acceleration due to gravity (m/s^2)
!-- rd gas constant for dry air (j/kg/k)
!-- z height above sea level (m)
!-- rv gas constant for water vapor (j/kg/k)
!-- dt time step (s)
!-- dx model grid interval (m)
!-- ep1 constant for virtual temperature (r_v/r_d - 1) (dimensionless)
!-- ids start index for i in domain
!-- ide end index for i in domain
!-- jds start index for j in domain
!-- jde end index for j in domain
!-- kds start index for k in domain
!-- kde end index for k in domain
!-- ims start index for i in memory
!-- ime end index for i in memory
!-- jms start index for j in memory
!-- jme end index for j in memory
!-- kms start index for k in memory
!-- kme end index for k in memory
!-- its start index for i in tile
!-- ite end index for i in tile
!-- jts start index for j in tile
!-- jte end index for j in tile
!-- kts start index for k in tile
!-- kte end index for k in tile
!-------------------------------------------------------------------
!
  INTEGER, INTENT(IN) :: ids, ide, jds, jde, kds, kde, ims, ime, jms, &
&  jme, kms, kme, its, ite, jts, jte, kts, kte
  INTEGER, INTENT(IN) :: itimestep
!
  REAL, INTENT(IN) :: dt, dx, cp, g, rd, rv, ep1, pi
!
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(IN) :: qv3d, p3d, &
&  pi3d, t3d, z
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: qv3db, pi3db, t3db, zb
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(IN) :: p3di
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: p3dib
!
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: rublten, &
&  rvblten
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: rubltenb
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: dtaux3d, &
&  dtauy3d
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: dtaux3db
!
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(IN) :: u3d, v3d
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: u3db, v3db
!
  INTEGER, DIMENSION(ims:ime, jms:jme), INTENT(IN) :: kpbl2d
  REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: dusfcg, dvsfcg
  REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: dusfcgb
!
  REAL, DIMENSION(ims:ime, jms:jme), INTENT(IN) :: var2d, oc12d, oa2d1, &
&  oa2d2, oa2d3, oa2d4, ol2d1, ol2d2, ol2d3, ol2d4
!
  REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL, INTENT(IN) :: mut
  REAL, DIMENSION(ims:ime, jms:jme), OPTIONAL :: mutb
!
  REAL, DIMENSION(kms:kme), OPTIONAL, INTENT(IN) :: znu, znw
!
  REAL, OPTIONAL, INTENT(IN) :: p_top
!
!local
!
  REAL, DIMENSION(its:ite, kts:kte) :: delprsi, pdh
  REAL, DIMENSION(its:ite, kts:kte) :: delprsib, pdhb
  REAL, DIMENSION(its:ite, kts:kte + 1) :: pdhi
  REAL, DIMENSION(its:ite, kts:kte+1) :: pdhib
  REAL, DIMENSION(its:ite, 4) :: oa4, ol4
  INTEGER :: i, j, k, kdt
  INTEGER :: branch
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: rvbltenb
  REAL, DIMENSION(ims:ime, jms:jme), INTENT(INOUT) :: dvsfcgb
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: dtauy3db
!
  DO j=jts,jte
    IF (PRESENT(mut)) THEN
! For ARW we will replace p and p8w with dry hydrostatic pressure
      DO k=kts,kte+1
        DO i=its,ite
          IF (k .LE. kte) THEN
            CALL PUSHREAL8(pdh(i, k))
            pdh(i, k) = mut(i, j)*znu(k) + p_top
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHREAL8(pdhi(i, k))
          pdhi(i, k) = mut(i, j)*znw(k) + p_top
        END DO
      END DO
      CALL PUSHCONTROL1B(1)
    ELSE
      DO k=kts,kte+1
        DO i=its,ite
          IF (k .LE. kte) THEN
            CALL PUSHREAL8(pdh(i, k))
            pdh(i, k) = p3d(i, k, j)
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHREAL8(pdhi(i, k))
          pdhi(i, k) = p3di(i, k, j)
        END DO
      END DO
      CALL PUSHCONTROL1B(0)
    END IF
!
    DO k=kts,kte
      DO i=its,ite
        CALL PUSHREAL8(delprsi(i, k))
        delprsi(i, k) = pdhi(i, k) - pdhi(i, k+1)
      END DO
    END DO
    DO i=its,ite
      CALL PUSHREAL8(oa4(i, 1))
      oa4(i, 1) = oa2d1(i, j)
      CALL PUSHREAL8(oa4(i, 2))
      oa4(i, 2) = oa2d2(i, j)
      CALL PUSHREAL8(oa4(i, 3))
      oa4(i, 3) = oa2d3(i, j)
      CALL PUSHREAL8(oa4(i, 4))
      oa4(i, 4) = oa2d4(i, j)
      CALL PUSHREAL8(ol4(i, 1))
      ol4(i, 1) = ol2d1(i, j)
      CALL PUSHREAL8(ol4(i, 2))
      ol4(i, 2) = ol2d2(i, j)
      CALL PUSHREAL8(ol4(i, 3))
      ol4(i, 3) = ol2d3(i, j)
      CALL PUSHREAL8(ol4(i, 4))
      ol4(i, 4) = ol2d4(i, j)
    END DO
  END DO
  delprsib = 0.0_8
  pdhib = 0.0_8
  pdhb = 0.0_8
  DO j=jte,jts,-1
    CALL GWDO2D_B(rublten(ims, kms, j), rubltenb(ims, kms, j), rvblten(&
&            ims, kms, j), rvbltenb(ims, kms, j), dtaux3d(ims, kms, j), &
&            dtaux3db(ims, kms, j), dtauy3d(ims, kms, j), dtauy3db(ims, &
&            kms, j), u3d(ims, kms, j), u3db(ims, kms, j), v3d(ims, kms, &
&            j), v3db(ims, kms, j), t3d(ims, kms, j), t3db(ims, kms, j), &
&            qv3d(ims, kms, j), qv3db(ims, kms, j), pdhi(its, kts), pdhib&
&            (its, kts), delprsi(its, kts), delprsib(its, kts), pdh(its, &
&            kts), pdhb(its, kts), pi3d(ims, kms, j), pi3db(ims, kms, j)&
&            , z(ims, kms, j), zb(ims, kms, j), rcl=1.0, var=var2d(ims, j&
&            ), oc1=oc12d(ims, j), oa4=oa4, ol4=ol4, dusfc=dusfcg(ims, j)&
&            , dusfcb=dusfcgb(ims, j), dvsfc=dvsfcg(ims, j), dvsfcb=&
&            dvsfcgb(ims, j), g=g, cp=cp, rd=rd, rv=rv, fv=ep1, pi=pi, &
&            dxmeter=dx, deltim=dt, kpbl=kpbl2d(ims, j), kdt=itimestep, &
&            lat=j, ids=ids, ide=ide, jds=jds, jde=jde, kds=kds, kde=kde&
&            , ims=ims, ime=ime, jms=jms, jme=jme, kms=kms, kme=kme, its=&
&            its, ite=ite, jts=jts, jte=jte, kts=kts, kte=kte)
    DO i=ite,its,-1
      CALL POPREAL8(ol4(i, 4))
      CALL POPREAL8(ol4(i, 3))
      CALL POPREAL8(ol4(i, 2))
      CALL POPREAL8(ol4(i, 1))
      CALL POPREAL8(oa4(i, 4))
      CALL POPREAL8(oa4(i, 3))
      CALL POPREAL8(oa4(i, 2))
      CALL POPREAL8(oa4(i, 1))
    END DO
    DO k=kte,kts,-1
      DO i=ite,its,-1
        CALL POPREAL8(delprsi(i, k))
        pdhib(i, k) = pdhib(i, k) + delprsib(i, k)
        pdhib(i, k+1) = pdhib(i, k+1) - delprsib(i, k)
        delprsib(i, k) = 0.0_8
      END DO
    END DO
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      DO k=kte+1,kts,-1
        DO i=ite,its,-1
          CALL POPREAL8(pdhi(i, k))
          p3dib(i, k, j) = p3dib(i, k, j) + pdhib(i, k)
          pdhib(i, k) = 0.0_8
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL8(pdh(i, k))
            pdhb(i, k) = 0.0_8
          END IF
        END DO
      END DO
    ELSE
      DO k=kte+1,kts,-1
        DO i=ite,its,-1
          CALL POPREAL8(pdhi(i, k))
          mutb(i, j) = mutb(i, j) + znw(k)*pdhib(i, k)
          pdhib(i, k) = 0.0_8
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL8(pdh(i, k))
            mutb(i, j) = mutb(i, j) + znu(k)*pdhb(i, k)
            pdhb(i, k) = 0.0_8
          END IF
        END DO
      END DO
    END IF
  END DO
END SUBROUTINE GWDO_B
!        Generated by TAPENADE     (INRIA, Tropics team)
!  Tapenade 3.7 (r4786) - 21 Feb 2013 15:53
!
!  Differentiation of gwdo2d in reverse (adjoint) mode (with options r8):
!   gradient     of useful results: v1 dvsfc dvdt dtauy2d prsi
!                prsl dusfc del t1 q1 dudt dtaux2d u1 zl prslk
!   with respect to varying inputs: v1 dvsfc dvdt dtauy2d prsi
!                prsl dusfc del t1 q1 dudt dtaux2d u1 zl prslk
!
!-------------------------------------------------------------------
!
!
!
!
SUBROUTINE GWDO2D_B(dudt, dudtb, dvdt, dvdtb, dtaux2d, dtaux2db, dtauy2d&
&  , dtauy2db, u1, u1b, v1, v1b, t1, t1b, q1, q1b, prsi, prsib, del, delb&
&  , prsl, prslb, prslk, prslkb, zl, zlb, rcl, var, oc1, oa4, ol4, dusfc&
&  , dusfcb, dvsfc, dvsfcb, g, cp, rd, rv, fv, pi, dxmeter, deltim, kpbl&
&  , kdt, lat, ids, ide, jds, jde, kds, kde, ims, ime, jms, jme, kms, kme&
&  , its, ite, jts, jte, kts, kte)
  IMPLICIT NONE
!-------------------------------------------------------------------
  INTEGER :: kdt, lat, latd, lond, ids, ide, jds, jde, kds, kde, ims, &
&  ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte
!
  REAL :: g, rd, rv, fv, cp, pi, dxmeter, deltim, rcl
  REAL :: dudt(ims:ime, kms:kme), dvdt(ims:ime, kms:kme), dtaux2d(ims:&
&  ime, kms:kme), dtauy2d(ims:ime, kms:kme), u1(ims:ime, kms:kme), v1(ims&
&  :ime, kms:kme), t1(ims:ime, kms:kme), q1(ims:ime, kms:kme), zl(ims:ime&
&  , kms:kme), prslk(ims:ime, kms:kme)
  REAL :: dudtb(ims:ime, kms:kme), dvdtb(ims:ime, kms:kme), dtaux2db(ims&
&  :ime, kms:kme), dtauy2db(ims:ime, kms:kme), u1b(ims:ime, kms:kme), v1b&
&  (ims:ime, kms:kme), t1b(ims:ime, kms:kme), q1b(ims:ime, kms:kme), zlb(&
&  ims:ime, kms:kme), prslkb(ims:ime, kms:kme)
  REAL :: prsl(its:ite, kts:kte), prsi(its:ite, kts:kte+1), del(its:ite&
&  , kts:kte)
  REAL :: prslb(its:ite, kts:kte), prsib(its:ite, kts:kte+1), delb(its:&
&  ite, kts:kte)
  REAL :: oa4(its:ite, 4), ol4(its:ite, 4)
!
  INTEGER :: kpbl(ims:ime)
  REAL :: var(ims:ime), oc1(ims:ime), dusfc(ims:ime), dvsfc(ims:ime)
  REAL :: dusfcb(ims:ime), dvsfcb(ims:ime)
! critical richardson number for wave breaking : ! larger drag with larger value
!
  REAL, PARAMETER :: ric=0.25
!
  REAL, PARAMETER :: dw2min=1.
  REAL, PARAMETER :: rimin=-100.
  REAL, PARAMETER :: bnv2min=1.0e-5
  REAL, PARAMETER :: efmin=0.0
  REAL, PARAMETER :: efmax=10.0
  REAL, PARAMETER :: xl=4.0e4
  REAL, PARAMETER :: critac=1.0e-5
  REAL, PARAMETER :: gmax=1.
  REAL, PARAMETER :: veleps=1.0
  REAL, PARAMETER :: factop=0.5
  REAL, PARAMETER :: frc=1.0
  REAL, PARAMETER :: ce=0.8
  REAL, PARAMETER :: cg=0.5
!
! local variables
!
  INTEGER :: i, k, lcap, lcapp1, nwd, idir, kpblmin, kpblmax, klcap, kp1&
&  , ikount, kk
!
  REAL :: rcs, rclcs, csg, fdir, cleff, cs, rcsks, wdir, ti, rdz, temp, &
&  tem2, dw2, shr2, bvf2, rdelks, wtkbj, coefm, tem, gfobnv, hd, fro, rim&
&  , temc, tem1, efact, temv, dtaux, dtauy
  REAL :: rcsksb, tib, rdzb, tem2b, dw2b, shr2b, bvf2b, rdelksb, wtkbjb&
&  , temb, gfobnvb, hdb, temcb, tem1b, efactb, dtauxb, dtauyb
!
  LOGICAL :: ldrag(its:ite), icrilv(its:ite), flag(its:ite), kloop1(its:&
&  ite)
!
  REAL :: taub(its:ite), taup(its:ite, kts:kte+1), xn(its:ite), yn(its:&
&  ite), ubar(its:ite), vbar(its:ite), fr(its:ite), ulow(its:ite), rulow(&
&  its:ite), bnv(its:ite), oa(its:ite), ol(its:ite), roll(its:ite), dtfac&
&  (its:ite), brvf(its:ite), xlinv(its:ite), delks(its:ite), delks1(its:&
&  ite), bnv2(its:ite, kts:kte), usqj(its:ite, kts:kte), taud(its:ite, &
&  kts:kte), ro(its:ite, kts:kte), vtk(its:ite, kts:kte), vtj(its:ite, &
&  kts:kte), zlowtop(its:ite), velco(its:ite, kts:kte-1)
  REAL :: taubb(its:ite), taupb(its:ite, kts:kte+1), xnb(its:ite), ynb(&
&  its:ite), ubarb(its:ite), vbarb(its:ite), frb(its:ite), ulowb(its:ite)&
&  , rulowb(its:ite), bnvb(its:ite), rollb(its:ite), dtfacb(its:ite), &
&  brvfb(its:ite), delksb(its:ite), delks1b(its:ite), bnv2b(its:ite, kts:&
&  kte), usqjb(its:ite, kts:kte), taudb(its:ite, kts:kte), rob(its:ite, &
&  kts:kte), vtkb(its:ite, kts:kte), vtjb(its:ite, kts:kte), velcob(its:&
&  ite, kts:kte-1)
!
  INTEGER :: kbl(its:ite), klowtop(its:ite), lowlv(its:ite)
!
  LOGICAL :: iope
  INTEGER, PARAMETER :: mdir=8
  INTEGER :: nwdir(mdir)
  REAL :: tmp
  REAL :: tmp0
  REAL :: tmp1
  REAL :: tmp2
  REAL :: tmp3
  INTEGER :: branch
  REAL :: temp3
  REAL :: x3b
  REAL :: temp2
  REAL :: y1b
  REAL :: temp1
  REAL :: temp0
  REAL :: temp7b
  REAL :: temp9b2
  REAL :: temp9b1
  REAL :: temp9b0
  REAL :: temp0b
  REAL :: tmpb
  REAL :: tmp0b
  REAL :: x3
  REAL :: temp3b
  REAL :: x2
  REAL :: x1
  REAL :: temp7b0
  REAL :: x2b
  REAL :: tmp3b
  REAL :: temp12b
  REAL :: temp6b
  REAL :: temp12
  REAL :: temp11
  REAL :: temp10
  REAL :: temp9b
  REAL :: max1b
  REAL :: temp2b
  REAL :: x1b
  REAL :: tmp2b
  REAL :: temp5b
  REAL :: temp12b0
  REAL :: temp1b
  REAL :: max1
  REAL :: temp9
  REAL :: temp8
  REAL :: tmp1b
  REAL :: temp10b3
  REAL :: temp7
  REAL :: temp10b
  REAL :: temp10b2
  REAL :: temp4b
  REAL :: temp6
  REAL :: temp10b1
  REAL :: temp5
  REAL :: temp10b0
  REAL :: y1
  REAL :: temp4
  DATA nwdir /6, 7, 5, 8, 2, 3, 1, 4/
!
! initialize local variables
!
  kbl = 0
  klowtop = 0
  lowlv = 0
!
!---- constants
!
  rcs = SQRT(rcl)
  cs = 1./SQRT(rcl)
  csg = cs*g
  lcap = kte
  lcapp1 = lcap + 1
  fdir = mdir/(2.0*pi)
  IF (dxmeter .LT. 50.e3) THEN
    cleff = 50.e3
  ELSE
    cleff = dxmeter
  END IF
  DO k=kts,kte
    DO i=its,ite
      usqj(i, k) = 0.0
      bnv2(i, k) = 0.0
      vtj(i, k) = 0.0
      vtk(i, k) = 0.0
      taup(i, k) = 0.0
      taud(i, k) = 0.0
    END DO
  END DO
  DO i=its,ite
    taup(i, kte+1) = 0.0
    xlinv(i) = 1.0/xl
  END DO
!
  DO k=kts,kte
    DO i=its,ite
      vtj(i, k) = t1(i, k)*(1.+fv*q1(i, k))
      vtk(i, k) = vtj(i, k)/prslk(i, k)
! density kg/m**3
      ro(i, k) = 1./rd*prsl(i, k)/vtj(i, k)
    END DO
  END DO
!
  DO i=its,ite
    zlowtop(i) = 2.*var(i)
  END DO
!
!--- determine new reference level > 2*var
!
  DO i=its,ite
    kloop1(i) = .true.
  END DO
  DO k=kts+1,kte
    DO i=its,ite
      IF (kloop1(i) .AND. zl(i, k) - zl(i, 1) .GE. zlowtop(i)) THEN
        klowtop(i) = k + 1
        kloop1(i) = .false.
      END IF
    END DO
  END DO
!
  kpblmax = 2
  DO i=its,ite
    IF (2 .LT. kpbl(i)) THEN
      kbl(i) = kpbl(i)
    ELSE
      kbl(i) = 2
    END IF
    IF (kbl(i) .LT. klowtop(i)) THEN
      kbl(i) = klowtop(i)
    ELSE
      kbl(i) = kbl(i)
    END IF
    delks(i) = 1.0/(prsi(i, 1)-prsi(i, kbl(i)))
    ubar(i) = 0.0
    vbar(i) = 0.0
    taup(i, 1) = 0.0
    oa(i) = 0.0
    IF (kpblmax .LT. kbl(i)) THEN
      kpblmax = kbl(i)
    ELSE
      kpblmax = kpblmax
    END IF
    lowlv(i) = 2
  END DO
  IF (kpblmax + 1 .GT. kte - 1) THEN
    kpblmax = kte - 1
  ELSE
    kpblmax = kpblmax + 1
  END IF
!
! compute low level averages within pbl
!
  DO k=kts,kpblmax
    DO i=its,ite
      IF (k .LT. kbl(i)) THEN
        rcsks = rcs*del(i, k)*delks(i)
! pbl u mean
        ubar(i) = ubar(i) + rcsks*u1(i, k)
! pbl v mean
        vbar(i) = vbar(i) + rcsks*v1(i, k)
        CALL PUSHCONTROL1B(1)
      ELSE
        CALL PUSHCONTROL1B(0)
      END IF
    END DO
  END DO
!
! figure out low-level horizontal wind direction
!
! nwd 1 2 3 4 5 6 7 8
! wd w s sw nw e n ne se
!
  DO i=its,ite
    wdir = ATAN2(ubar(i), vbar(i)) + pi
    idir = MOD(NINT(fdir*wdir), mdir) + 1
    nwd = nwdir(idir)
    oa(i) = (1-2*INT((nwd-1)/4))*oa4(i, MOD(nwd-1, 4)+1)
    ol(i) = ol4(i, MOD(nwd-1, 4)+1)
  END DO
!
  kpblmin = kte
  DO i=its,ite
    IF (kpblmin .GT. kbl(i)) THEN
      kpblmin = kbl(i)
    ELSE
      kpblmin = kpblmin
    END IF
  END DO
!
  DO i=its,ite
    IF (oa(i) .LE. 0.0) THEN
      CALL PUSHINTEGER4(kbl(i))
      kbl(i) = kpbl(i) + 1
      CALL PUSHCONTROL1B(1)
    ELSE
      CALL PUSHCONTROL1B(0)
    END IF
  END DO
!
  DO i=its,ite
    CALL PUSHREAL8(delks(i))
    delks(i) = 1.0/(prsi(i, 1)-prsi(i, kbl(i)))
    delks1(i) = 1.0/(prsl(i, 1)-prsl(i, kbl(i)))
  END DO
!
!--- saving richardson number in usqj for migwdi
!
  DO k=kts,kte-1
    DO i=its,ite
      ti = 2.0/(t1(i, k)+t1(i, k+1))
      rdz = 1./(zl(i, k+1)-zl(i, k))
      CALL PUSHREAL8(tem1)
      tem1 = u1(i, k) - u1(i, k+1)
      CALL PUSHREAL8(tem2)
      tem2 = v1(i, k) - v1(i, k+1)
      dw2 = rcl*(tem1*tem1+tem2*tem2)
      IF (dw2 .LT. dw2min) THEN
        CALL PUSHREAL8(max1)
        max1 = dw2min
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHREAL8(max1)
        max1 = dw2
        CALL PUSHCONTROL1B(1)
      END IF
      shr2 = max1*rdz*rdz
      CALL PUSHREAL8(bvf2)
      bvf2 = g*(g/cp+rdz*(vtj(i, k+1)-vtj(i, k)))*ti
      IF (bvf2/shr2 .LT. rimin) THEN
        usqj(i, k) = rimin
        CALL PUSHCONTROL1B(0)
      ELSE
        usqj(i, k) = bvf2/shr2
        CALL PUSHCONTROL1B(1)
      END IF
      bnv2(i, k) = 2*g*rdz*(vtk(i, k+1)-vtk(i, k))/(vtk(i, k+1)+vtk(i, k&
&        ))
      IF (bnv2(i, k) .LT. bnv2min) THEN
        bnv2(i, k) = bnv2min
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHCONTROL1B(1)
        bnv2(i, k) = bnv2(i, k)
      END IF
    END DO
  END DO
!
!-----initialize arrays
!
  DO i=its,ite
    xn(i) = 0.0
    yn(i) = 0.0
    ubar(i) = 0.0
    vbar(i) = 0.0
    roll(i) = 0.0
    taub(i) = 0.0
    ulow(i) = 0.0
    dtfac(i) = 1.0
    ldrag(i) = .false.
! initialize critical level control vector
    icrilv(i) = .false.
  END DO
!
!---- compute low level averages
!---- (u,v)*cos(lat) use uv=(u1,v1) which is wind at t0-1
!---- use rcs=1/cos(lat) to get wind field
!
  DO k=1,kpblmax
    DO i=its,ite
      IF (k .LT. kbl(i)) THEN
        rdelks = del(i, k)*delks(i)
        rcsks = rcs*rdelks
! u mean
        ubar(i) = ubar(i) + rcsks*u1(i, k)
! v mean
        vbar(i) = vbar(i) + rcsks*v1(i, k)
! ro mean
        roll(i) = roll(i) + rdelks*ro(i, k)
        CALL PUSHCONTROL1B(1)
      ELSE
        CALL PUSHCONTROL1B(0)
      END IF
    END DO
  END DO
!
!----compute the "low level" or 1/3 wind magnitude (m/s)
!
  DO i=its,ite
    x1 = SQRT(ubar(i)*ubar(i) + vbar(i)*vbar(i))
    IF (x1 .LT. 1.0) THEN
      ulow(i) = 1.0
      CALL PUSHCONTROL1B(0)
    ELSE
      ulow(i) = x1
      CALL PUSHCONTROL1B(1)
    END IF
    rulow(i) = 1./ulow(i)
  END DO
!
  DO k=kts,kte-1
    DO i=its,ite
      velco(i, k) = 0.5*rcs*((u1(i, k)+u1(i, k+1))*ubar(i)+(v1(i, k)+v1(&
&        i, k+1))*vbar(i))
      CALL PUSHREAL8(velco(i, k))
      velco(i, k) = velco(i, k)*rulow(i)
      IF (velco(i, k) .LT. veleps .AND. velco(i, k) .GT. 0.) THEN
        velco(i, k) = veleps
        CALL PUSHCONTROL1B(1)
      ELSE
        CALL PUSHCONTROL1B(0)
      END IF
    END DO
  END DO
!
! no drag when critical level in the base layer
!
  DO i=its,ite
    ldrag(i) = velco(i, 1) .LE. 0.
  END DO
!
  DO k=kts+1,kpblmax-1
    DO i=its,ite
      IF (k .LT. kbl(i)) ldrag(i) = ldrag(i) .OR. velco(i, k) .LE. 0.
    END DO
  END DO
!
! no drag when bnv2.lt.0
!
  DO k=kts,kpblmax-1
    DO i=its,ite
      IF (k .LT. kbl(i)) ldrag(i) = ldrag(i) .OR. bnv2(i, k) .LT. 0.
    END DO
  END DO
!
!-----the low level weighted average ri is stored in usqj(1,1; im)
!-----the low level weighted average n**2 is stored in bnv2(1,1; im)
!---- this is called bnvl2 in phys_gwd_alpert_sub not bnv2
!---- rdelks (del(k)/delks) vert ave factor so we can * instead of /
!
  DO i=its,ite
    wtkbj = (prsl(i, 1)-prsl(i, 2))*delks1(i)
    CALL PUSHREAL8(bnv2(i, 1))
    bnv2(i, 1) = wtkbj*bnv2(i, 1)
    CALL PUSHREAL8(usqj(i, 1))
    usqj(i, 1) = wtkbj*usqj(i, 1)
  END DO
!
  DO k=kts+1,kpblmax-1
    DO i=its,ite
      IF (k .LT. kbl(i)) THEN
        rdelks = (prsl(i, k)-prsl(i, k+1))*delks1(i)
        tmp = bnv2(i, 1) + bnv2(i, k)*rdelks
        CALL PUSHREAL8(bnv2(i, 1))
        bnv2(i, 1) = tmp
        tmp0 = usqj(i, 1) + usqj(i, k)*rdelks
        CALL PUSHREAL8(usqj(i, 1))
        usqj(i, 1) = tmp0
        CALL PUSHCONTROL1B(1)
      ELSE
        CALL PUSHCONTROL1B(0)
      END IF
    END DO
  END DO
!
  DO i=its,ite
    ldrag(i) = ldrag(i) .OR. bnv2(i, 1) .LE. 0.0
    ldrag(i) = ldrag(i) .OR. ulow(i) .EQ. 1.0
    ldrag(i) = ldrag(i) .OR. var(i) .LE. 0.0
  END DO
!
! ----- set all ri low level values to the low level value
!
  DO k=kts+1,kpblmax-1
    DO i=its,ite
      IF (k .LT. kbl(i)) THEN
        tmp1 = usqj(i, 1)
        CALL PUSHREAL8(usqj(i, k))
        usqj(i, k) = tmp1
        CALL PUSHCONTROL1B(1)
      ELSE
        CALL PUSHCONTROL1B(0)
      END IF
    END DO
  END DO
!
  DO i=its,ite
    IF (.NOT.ldrag(i)) THEN
      bnv(i) = SQRT(bnv2(i, 1))
      fr(i) = bnv(i)*rulow(i)*var(i)
      xn(i) = ubar(i)*rulow(i)
      yn(i) = vbar(i)*rulow(i)
      CALL PUSHCONTROL1B(1)
    ELSE
      CALL PUSHCONTROL1B(0)
    END IF
  END DO
!
! compute the base level stress and store it in taub
! calculate enhancement factor, number of mountains & aspect
! ratio const. use simplified relationship between standard
! deviation & critical hgt
!
  DO i=its,ite
    IF (.NOT.ldrag(i)) THEN
      CALL PUSHREAL8(efact)
      efact = (oa(i)+2.)**(ce*fr(i)/frc)
      IF (efact .LT. efmin) THEN
        x2 = efmin
        CALL PUSHCONTROL1B(0)
      ELSE
        x2 = efact
        CALL PUSHCONTROL1B(1)
      END IF
      IF (x2 .GT. efmax) THEN
        efact = efmax
        CALL PUSHCONTROL1B(0)
      ELSE
        efact = x2
        CALL PUSHCONTROL1B(1)
      END IF
      coefm = (1.+ol(i))**(oa(i)+1.)
      xlinv(i) = coefm/cleff
      tem = fr(i)*fr(i)*oc1(i)
      gfobnv = gmax*tem/((tem+cg)*bnv(i))
      taub(i) = xlinv(i)*roll(i)*ulow(i)*ulow(i)*ulow(i)*gfobnv*efact
      CALL PUSHCONTROL1B(1)
    ELSE
      taub(i) = 0.0
      xn(i) = 0.0
      yn(i) = 0.0
      CALL PUSHCONTROL1B(0)
    END IF
  END DO
!
! now compute vertical structure of the stress.
!
!----set up bottom values of stress
!
  DO k=kts,kpblmax
    DO i=its,ite
      IF (k .LE. kbl(i)) THEN
        taup(i, k) = taub(i)
        CALL PUSHCONTROL1B(1)
      ELSE
        CALL PUSHCONTROL1B(0)
      END IF
    END DO
  END DO
!
! vertical level k loop!
  DO k=kpblmin,kte-1
    CALL PUSHINTEGER4(kp1)
    kp1 = k + 1
    DO i=its,ite
!
!-----unstablelayer if ri < ric
!-----unstable layer if upper air vel comp along surf vel <=0 (crit lay)
!---- at (u-c)=0. crit layer exists and bit vector should be set (.le.)
!
      IF (k .GE. kbl(i)) THEN
        icrilv(i) = (icrilv(i) .OR. usqj(i, k) .LT. ric) .OR. velco(i, k&
&          ) .LE. 0.0
        IF (bnv2(i, k) .LT. bnv2min) THEN
          CALL PUSHREAL8(brvf(i))
          brvf(i) = bnv2min
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHREAL8(brvf(i))
          brvf(i) = bnv2(i, k)
          CALL PUSHCONTROL1B(1)
        END IF
        CALL PUSHREAL8(brvf(i))
! brunt-vaisala frequency
        brvf(i) = SQRT(brvf(i))
        CALL PUSHCONTROL1B(1)
      ELSE
        CALL PUSHCONTROL1B(0)
      END IF
    END DO
!
    DO i=its,ite
      IF (k .GE. kbl(i) .AND. (.NOT.ldrag(i))) THEN
        IF (.NOT.icrilv(i) .AND. taup(i, k) .GT. 0.0) THEN
          temv = 1.0/velco(i, k)
          CALL PUSHREAL8(tem1)
          tem1 = xlinv(i)*(ro(i, kp1)+ro(i, k))*brvf(i)*velco(i, k)*0.5
          CALL PUSHREAL8(hd)
          hd = SQRT(taup(i, k)/tem1)
          fro = brvf(i)*hd*temv
          CALL PUSHREAL8(tem2)
!
! rim is the minimum-richardson number by shutts (1985)
!
          tem2 = SQRT(usqj(i, k))
          tem = 1. + tem2*fro
          rim = usqj(i, k)*(1.-fro)/(tem*tem)
!
! check stability to employ the 'saturation hypothesis'
! of lindzen (1981) except at tropospheric downstream regions
!
          IF (rim .LE. ric) THEN
! saturation hypothesis!
            IF (oa(i) .LE. 0. .OR. kp1 .GE. lowlv(i)) THEN
              temc = 2.0 + 1.0/tem2
              hd = velco(i, k)*(2.*SQRT(temc)-temc)/brvf(i)
              taup(i, kp1) = tem1*hd*hd
              CALL PUSHCONTROL3B(4)
            ELSE
              CALL PUSHCONTROL3B(3)
            END IF
          ELSE
! no wavebreaking!
            tmp2 = taup(i, k)
            taup(i, kp1) = tmp2
            CALL PUSHCONTROL3B(2)
          END IF
        ELSE
          CALL PUSHCONTROL3B(1)
        END IF
      ELSE
        CALL PUSHCONTROL3B(0)
      END IF
    END DO
  END DO
!
  IF (lcap .LT. kte) THEN
    DO klcap=lcapp1,kte
      DO i=its,ite
        tmp3 = prsi(i, klcap)/prsi(i, lcap)*taup(i, lcap)
        CALL PUSHREAL8(taup(i, klcap))
        taup(i, klcap) = tmp3
      END DO
    END DO
    CALL PUSHCONTROL1B(1)
  ELSE
    CALL PUSHCONTROL1B(0)
  END IF
!
! calculate - (g)*d(tau)/d(pressure) and deceleration terms dtaux, dtauy
!
  DO k=kts,kte
    DO i=its,ite
      taud(i, k) = 1.*(taup(i, k+1)-taup(i, k))*csg/del(i, k)
    END DO
  END DO
!
!------limit de-acceleration (momentum deposition ) at top to 1/2 value
!------the idea is some stuff must go out the 'top'
!
  DO klcap=lcap,kte
    DO i=its,ite
      taud(i, klcap) = taud(i, klcap)*factop
    END DO
  END DO
!
!------if the gravity wave drag would force a critical line
!------in the lower ksmm1 layers during the next deltim timestep,
!------then only apply drag until that critical line is reached.
!
  DO k=kts,kpblmax-1
    DO i=its,ite
      IF (k .LE. kbl(i)) THEN
        IF (taud(i, k) .NE. 0.) THEN
          x3 = velco(i, k)/(deltim*rcs*taud(i, k))
          IF (x3 .GE. 0.) THEN
            y1 = x3
            CALL PUSHCONTROL1B(0)
          ELSE
            y1 = -x3
            CALL PUSHCONTROL1B(1)
          END IF
          IF (dtfac(i) .GT. y1) THEN
            dtfac(i) = y1
            CALL PUSHCONTROL2B(2)
          ELSE
            dtfac(i) = dtfac(i)
            CALL PUSHCONTROL2B(3)
          END IF
        ELSE
          CALL PUSHCONTROL2B(1)
        END IF
      ELSE
        CALL PUSHCONTROL2B(0)
      END IF
    END DO
  END DO
!
  DO k=kts,kte
    DO i=its,ite
      CALL PUSHREAL8(taud(i, k))
      taud(i, k) = taud(i, k)*dtfac(i)
    END DO
  END DO
  DO i=ite,its,-1
    dvsfcb(i) = -(rcs*dvsfcb(i)/g)
    dusfcb(i) = -(rcs*dusfcb(i)/g)
  END DO
  taudb = 0.0_8
  xnb = 0.0_8
  ynb = 0.0_8
  dtfacb = 0.0_8
  DO k=kte,kts,-1
    DO i=ite,its,-1
      dtaux = taud(i, k)*xn(i)
      dtauy = taud(i, k)*yn(i)
      dtauyb = dvdtb(i, k) + dtauy2db(i, k) + del(i, k)*dvsfcb(i)
      delb(i, k) = delb(i, k) + dtaux*dusfcb(i) + dtauy*dvsfcb(i)
      dtauxb = dudtb(i, k) + dtaux2db(i, k) + del(i, k)*dusfcb(i)
      dtauy2db(i, k) = 0.0_8
      dtaux2db(i, k) = 0.0_8
      taudb(i, k) = taudb(i, k) + xn(i)*dtauxb + yn(i)*dtauyb
      ynb(i) = ynb(i) + taud(i, k)*dtauyb
      xnb(i) = xnb(i) + taud(i, k)*dtauxb
      CALL POPREAL8(taud(i, k))
      dtfacb(i) = dtfacb(i) + taud(i, k)*taudb(i, k)
      taudb(i, k) = dtfac(i)*taudb(i, k)
    END DO
  END DO
  DO i=ite,its,-1
    dvsfcb(i) = 0.0_8
    dusfcb(i) = 0.0_8
  END DO
  velcob = 0.0_8
  DO k=kpblmax-1,kts,-1
    DO i=ite,its,-1
      CALL POPCONTROL2B(branch)
      IF (branch .GE. 2) THEN
        IF (branch .EQ. 2) THEN
          y1b = dtfacb(i)
          dtfacb(i) = 0.0_8
        ELSE
          y1b = 0.0_8
        END IF
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          x3b = y1b
        ELSE
          x3b = -y1b
        END IF
        temp12 = deltim*rcs*taud(i, k)
        velcob(i, k) = velcob(i, k) + x3b/temp12
        taudb(i, k) = taudb(i, k) - velco(i, k)*deltim*rcs*x3b/temp12**2
      END IF
    END DO
  END DO
  DO klcap=kte,lcap,-1
    DO i=ite,its,-1
      taudb(i, klcap) = factop*taudb(i, klcap)
    END DO
  END DO
  taupb = 0.0_8
  DO k=kte,kts,-1
    DO i=ite,its,-1
      temp12b0 = csg*taudb(i, k)/del(i, k)
      taupb(i, k+1) = taupb(i, k+1) + temp12b0
      taupb(i, k) = taupb(i, k) - temp12b0
      delb(i, k) = delb(i, k) - (taup(i, k+1)-taup(i, k))*temp12b0/del(i&
&        , k)
      taudb(i, k) = 0.0_8
    END DO
  END DO
  CALL POPCONTROL1B(branch)
  IF (branch .NE. 0) THEN
    DO klcap=kte,lcapp1,-1
      DO i=ite,its,-1
        CALL POPREAL8(taup(i, klcap))
        tmp3b = taupb(i, klcap)
        taupb(i, klcap) = 0.0_8
        temp12b = tmp3b/prsi(i, lcap)
        prsib(i, klcap) = prsib(i, klcap) + taup(i, lcap)*temp12b
        taupb(i, lcap) = taupb(i, lcap) + prsi(i, klcap)*temp12b
        prsib(i, lcap) = prsib(i, lcap) - prsi(i, klcap)*taup(i, lcap)*&
&          temp12b/prsi(i, lcap)
      END DO
    END DO
  END IF
  brvfb = 0.0_8
  bnv2b = 0.0_8
  rob = 0.0_8
  usqjb = 0.0_8
  DO k=kte-1,kpblmin,-1
    DO i=ite,its,-1
      CALL POPCONTROL3B(branch)
      IF (branch .GE. 2) THEN
        IF (branch .EQ. 2) THEN
          tmp2b = taupb(i, kp1)
          taupb(i, kp1) = 0.0_8
          taupb(i, k) = taupb(i, k) + tmp2b
          tem1b = 0.0_8
          tem2b = 0.0_8
        ELSE IF (branch .EQ. 3) THEN
          tem1b = 0.0_8
          tem2b = 0.0_8
        ELSE
          tem1b = hd**2*taupb(i, kp1)
          hdb = tem1*2*hd*taupb(i, kp1)
          taupb(i, kp1) = 0.0_8
          temc = 2.0 + 1.0/tem2
          temp11 = SQRT(temc)
          temp10b3 = (2.*temp11-temc)*hdb/brvf(i)
          temp10 = velco(i, k)/brvf(i)
          velcob(i, k) = velcob(i, k) + temp10b3
          brvfb(i) = brvfb(i) - temp10*temp10b3
          IF (temc .EQ. 0.0_8) THEN
            temcb = -(temp10*hdb)
          ELSE
            temcb = (2.*temp10/(2.0*temp11)-temp10)*hdb
          END IF
          tem2b = -(temcb/tem2**2)
        END IF
        CALL POPREAL8(tem2)
        IF (.NOT.usqj(i, k) .EQ. 0.0_8) usqjb(i, k) = usqjb(i, k) + &
&            tem2b/(2.0*SQRT(usqj(i, k)))
        CALL POPREAL8(hd)
        CALL POPREAL8(tem1)
        temp10b0 = xlinv(i)*0.5*tem1b
        temp10b1 = brvf(i)*velco(i, k)*temp10b0
        temp10b2 = (ro(i, kp1)+ro(i, k))*temp10b0
        rob(i, kp1) = rob(i, kp1) + temp10b1
        rob(i, k) = rob(i, k) + temp10b1
        brvfb(i) = brvfb(i) + velco(i, k)*temp10b2
        velcob(i, k) = velcob(i, k) + brvf(i)*temp10b2
      END IF
    END DO
    DO i=ite,its,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        CALL POPREAL8(brvf(i))
        IF (brvf(i) .EQ. 0.0_8) THEN
          brvfb(i) = 0.0
        ELSE
          brvfb(i) = brvfb(i)/(2.0*SQRT(brvf(i)))
        END IF
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(brvf(i))
          brvfb(i) = 0.0_8
        ELSE
          CALL POPREAL8(brvf(i))
          bnv2b(i, k) = bnv2b(i, k) + brvfb(i)
          brvfb(i) = 0.0_8
        END IF
      END IF
    END DO
    CALL POPINTEGER4(kp1)
  END DO
  taubb = 0.0_8
  DO k=kpblmax,kts,-1
    DO i=ite,its,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        taubb(i) = taubb(i) + taupb(i, k)
        taupb(i, k) = 0.0_8
      END IF
    END DO
  END DO
  rollb = 0.0_8
  bnvb = 0.0_8
  frb = 0.0_8
  ulowb = 0.0_8
  DO i=ite,its,-1
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      ynb(i) = 0.0_8
      xnb(i) = 0.0_8
      taubb(i) = 0.0_8
    ELSE
      tem = fr(i)*fr(i)*oc1(i)
      gfobnv = gmax*tem/((tem+cg)*bnv(i))
      temp10b = xlinv(i)*ulow(i)**3*taubb(i)
      ulowb(i) = ulowb(i) + roll(i)*gfobnv*efact*xlinv(i)*3*ulow(i)**2*&
&        taubb(i)
      rollb(i) = rollb(i) + gfobnv*efact*temp10b
      gfobnvb = roll(i)*efact*temp10b
      efactb = roll(i)*gfobnv*temp10b
      taubb(i) = 0.0_8
      temp9 = (cg+tem)*bnv(i)
      temp9b1 = gmax*gfobnvb/temp9
      temp9b2 = -(tem*temp9b1/temp9)
      temb = bnv(i)*temp9b2 + temp9b1
      bnvb(i) = bnvb(i) + (cg+tem)*temp9b2
      frb(i) = frb(i) + oc1(i)*2*fr(i)*temb
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        x2b = 0.0_8
      ELSE
        x2b = efactb
      END IF
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        efactb = 0.0_8
      ELSE
        efactb = x2b
      END IF
      CALL POPREAL8(efact)
      IF (.NOT.oa(i) + 2. .LE. 0.0_8) frb(i) = frb(i) + ce*(oa(i)+2.)**(&
&          ce*(fr(i)/frc))*LOG(oa(i)+2.)*efactb/frc
    END IF
  END DO
  vbarb = 0.0_8
  ubarb = 0.0_8
  rulowb = 0.0_8
  DO i=ite,its,-1
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) THEN
      vbarb(i) = vbarb(i) + rulow(i)*ynb(i)
      rulowb(i) = rulowb(i) + ubar(i)*xnb(i) + var(i)*bnv(i)*frb(i) + &
&        vbar(i)*ynb(i)
      ynb(i) = 0.0_8
      ubarb(i) = ubarb(i) + rulow(i)*xnb(i)
      xnb(i) = 0.0_8
      bnvb(i) = bnvb(i) + var(i)*rulow(i)*frb(i)
      frb(i) = 0.0_8
      IF (.NOT.bnv2(i, 1) .EQ. 0.0_8) bnv2b(i, 1) = bnv2b(i, 1) + bnvb(i&
&          )/(2.0*SQRT(bnv2(i, 1)))
      bnvb(i) = 0.0_8
    END IF
  END DO
  DO k=kpblmax-1,kts+1,-1
    DO i=ite,its,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        CALL POPREAL8(usqj(i, k))
        tmp1b = usqjb(i, k)
        usqjb(i, k) = 0.0_8
        usqjb(i, 1) = usqjb(i, 1) + tmp1b
      END IF
    END DO
  END DO
  delks1b = 0.0_8
  DO k=kpblmax-1,kts+1,-1
    DO i=ite,its,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        tmpb = bnv2b(i, 1)
        rdelks = (prsl(i, k)-prsl(i, k+1))*delks1(i)
        CALL POPREAL8(usqj(i, 1))
        tmp0b = usqjb(i, 1)
        usqjb(i, 1) = tmp0b
        usqjb(i, k) = usqjb(i, k) + rdelks*tmp0b
        CALL POPREAL8(bnv2(i, 1))
        rdelksb = bnv2(i, k)*tmpb + usqj(i, k)*tmp0b
        bnv2b(i, 1) = tmpb
        bnv2b(i, k) = bnv2b(i, k) + rdelks*tmpb
        prslb(i, k) = prslb(i, k) + delks1(i)*rdelksb
        prslb(i, k+1) = prslb(i, k+1) - delks1(i)*rdelksb
        delks1b(i) = delks1b(i) + (prsl(i, k)-prsl(i, k+1))*rdelksb
      END IF
    END DO
  END DO
  DO i=ite,its,-1
    wtkbj = (prsl(i, 1)-prsl(i, 2))*delks1(i)
    CALL POPREAL8(usqj(i, 1))
    CALL POPREAL8(bnv2(i, 1))
    wtkbjb = bnv2(i, 1)*bnv2b(i, 1) + usqj(i, 1)*usqjb(i, 1)
    usqjb(i, 1) = wtkbj*usqjb(i, 1)
    bnv2b(i, 1) = wtkbj*bnv2b(i, 1)
    prslb(i, 1) = prslb(i, 1) + delks1(i)*wtkbjb
    prslb(i, 2) = prslb(i, 2) - delks1(i)*wtkbjb
    delks1b(i) = delks1b(i) + (prsl(i, 1)-prsl(i, 2))*wtkbjb
  END DO
  DO k=kte-1,kts,-1
    DO i=ite,its,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) velcob(i, k) = 0.0_8
      CALL POPREAL8(velco(i, k))
      rulowb(i) = rulowb(i) + velco(i, k)*velcob(i, k)
      velcob(i, k) = rulow(i)*velcob(i, k)
      temp9b0 = rcs*0.5*velcob(i, k)
      u1b(i, k) = u1b(i, k) + ubar(i)*temp9b0
      u1b(i, k+1) = u1b(i, k+1) + ubar(i)*temp9b0
      ubarb(i) = ubarb(i) + (u1(i, k)+u1(i, k+1))*temp9b0
      v1b(i, k) = v1b(i, k) + vbar(i)*temp9b0
      v1b(i, k+1) = v1b(i, k+1) + vbar(i)*temp9b0
      vbarb(i) = vbarb(i) + (v1(i, k)+v1(i, k+1))*temp9b0
      velcob(i, k) = 0.0_8
    END DO
  END DO
  DO i=ite,its,-1
    ulowb(i) = ulowb(i) - rulowb(i)/ulow(i)**2
    rulowb(i) = 0.0_8
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      ulowb(i) = 0.0_8
      x1b = 0.0_8
    ELSE
      x1b = ulowb(i)
      ulowb(i) = 0.0_8
    END IF
    IF (ubar(i)**2 + vbar(i)**2 .EQ. 0.0_8) THEN
      temp9b = 0.0
    ELSE
      temp9b = x1b/(2.0*SQRT(ubar(i)**2+vbar(i)**2))
    END IF
    ubarb(i) = ubarb(i) + 2*ubar(i)*temp9b
    vbarb(i) = vbarb(i) + 2*vbar(i)*temp9b
  END DO
  delksb = 0.0_8
  DO k=kpblmax,1,-1
    DO i=ite,its,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        rcsksb = u1(i, k)*ubarb(i) + v1(i, k)*vbarb(i)
        rdelks = del(i, k)*delks(i)
        rdelksb = rcs*rcsksb + ro(i, k)*rollb(i)
        rob(i, k) = rob(i, k) + rdelks*rollb(i)
        rcsks = rcs*rdelks
        v1b(i, k) = v1b(i, k) + rcsks*vbarb(i)
        u1b(i, k) = u1b(i, k) + rcsks*ubarb(i)
        delb(i, k) = delb(i, k) + delks(i)*rdelksb
        delksb(i) = delksb(i) + del(i, k)*rdelksb
      END IF
    END DO
  END DO
  DO i=ite,its,-1
    vbarb(i) = 0.0_8
    ubarb(i) = 0.0_8
  END DO
  vtjb = 0.0_8
  vtkb = 0.0_8
  DO k=kte-1,kts,-1
    DO i=ite,its,-1
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) bnv2b(i, k) = 0.0_8
      rdz = 1./(zl(i, k+1)-zl(i, k))
      temp7 = vtk(i, k+1) + vtk(i, k)
      temp8 = vtk(i, k+1) - vtk(i, k)
      temp7b = g*2*bnv2b(i, k)/temp7
      temp7b0 = -(rdz*temp8*temp7b/temp7)
      rdzb = temp8*temp7b
      vtkb(i, k+1) = vtkb(i, k+1) + temp7b0 + rdz*temp7b
      vtkb(i, k) = vtkb(i, k) + temp7b0 - rdz*temp7b
      bnv2b(i, k) = 0.0_8
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        usqjb(i, k) = 0.0_8
        bvf2b = 0.0_8
        shr2b = 0.0_8
      ELSE
        shr2 = max1*rdz*rdz
        bvf2b = usqjb(i, k)/shr2
        shr2b = -(bvf2*usqjb(i, k)/shr2**2)
        usqjb(i, k) = 0.0_8
      END IF
      ti = 2.0/(t1(i, k)+t1(i, k+1))
      CALL POPREAL8(bvf2)
      temp6 = vtj(i, k+1) - vtj(i, k)
      temp6b = g*ti*bvf2b
      rdzb = rdzb + max1*2*rdz*shr2b + temp6*temp6b
      vtjb(i, k+1) = vtjb(i, k+1) + rdz*temp6b
      vtjb(i, k) = vtjb(i, k) - rdz*temp6b
      tib = g*(g/cp+rdz*temp6)*bvf2b
      max1b = rdz**2*shr2b
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        CALL POPREAL8(max1)
        dw2b = 0.0_8
      ELSE
        CALL POPREAL8(max1)
        dw2b = max1b
      END IF
      tem1b = rcl*2*tem1*dw2b
      tem2b = rcl*2*tem2*dw2b
      CALL POPREAL8(tem2)
      v1b(i, k) = v1b(i, k) + tem2b
      v1b(i, k+1) = v1b(i, k+1) - tem2b
      CALL POPREAL8(tem1)
      u1b(i, k) = u1b(i, k) + tem1b
      u1b(i, k+1) = u1b(i, k+1) - tem1b
      temp5 = zl(i, k+1) - zl(i, k)
      temp5b = -(rdzb/temp5**2)
      zlb(i, k+1) = zlb(i, k+1) + temp5b
      zlb(i, k) = zlb(i, k) - temp5b
      temp4 = t1(i, k) + t1(i, k+1)
      temp4b = -(2.0*tib/temp4**2)
      t1b(i, k) = t1b(i, k) + temp4b
      t1b(i, k+1) = t1b(i, k+1) + temp4b
    END DO
  END DO
  DO i=ite,its,-1
    temp3 = prsl(i, 1) - prsl(i, kbl(i))
    temp3b = -(delks1b(i)/temp3**2)
    prslb(i, 1) = prslb(i, 1) + temp3b
    prslb(i, kbl(i)) = prslb(i, kbl(i)) - temp3b
    delks1b(i) = 0.0_8
    CALL POPREAL8(delks(i))
    temp2 = prsi(i, 1) - prsi(i, kbl(i))
    temp2b = -(delksb(i)/temp2**2)
    prsib(i, 1) = prsib(i, 1) + temp2b
    prsib(i, kbl(i)) = prsib(i, kbl(i)) - temp2b
    delksb(i) = 0.0_8
  END DO
  DO i=ite,its,-1
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) CALL POPINTEGER4(kbl(i))
  END DO
  DO k=kpblmax,kts,-1
    DO i=ite,its,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        rcsks = rcs*del(i, k)*delks(i)
        rcsksb = u1(i, k)*ubarb(i) + v1(i, k)*vbarb(i)
        v1b(i, k) = v1b(i, k) + rcsks*vbarb(i)
        u1b(i, k) = u1b(i, k) + rcsks*ubarb(i)
        delb(i, k) = delb(i, k) + rcs*delks(i)*rcsksb
        delksb(i) = delksb(i) + rcs*del(i, k)*rcsksb
      END IF
    END DO
  END DO
  DO i=ite,its,-1
    temp1 = prsi(i, 1) - prsi(i, kbl(i))
    temp1b = -(delksb(i)/temp1**2)
    prsib(i, 1) = prsib(i, 1) + temp1b
    prsib(i, kbl(i)) = prsib(i, kbl(i)) - temp1b
    delksb(i) = 0.0_8
  END DO
  DO k=kte,kts,-1
    DO i=ite,its,-1
      temp0b = vtkb(i, k)/prslk(i, k)
      temp0 = rd*vtj(i, k)
      prslb(i, k) = prslb(i, k) + rob(i, k)/temp0
      vtjb(i, k) = vtjb(i, k) + temp0b - prsl(i, k)*rd*rob(i, k)/temp0**&
&        2
      rob(i, k) = 0.0_8
      prslkb(i, k) = prslkb(i, k) - vtj(i, k)*temp0b/prslk(i, k)
      vtkb(i, k) = 0.0_8
      t1b(i, k) = t1b(i, k) + (fv*q1(i, k)+1.)*vtjb(i, k)
      q1b(i, k) = q1b(i, k) + t1(i, k)*fv*vtjb(i, k)
      vtjb(i, k) = 0.0_8
    END DO
  END DO
  DO k=kte,kts,-1
    DO i=ite,its,-1
      dtauy2db(i, k) = 0.0_8
      dtaux2db(i, k) = 0.0_8
    END DO
  END DO
END SUBROUTINE GWDO2D_B

end module a_module_bl_gwdo
