      SUBROUTINE MTINFO ( CMTDIR, LUNMT1, LUNMT2 )

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    MTINFO
C   PRGMMR: ATOR            ORG: NP12       DATE: 2009-03-23
C
C ABSTRACT: THIS SUBROUTINE IS USED TO SPECIFY THE DIRECTORY LOCATION
C   AND FORTRAN LOGICAL UNIT NUMBERS TO USE WHEN READING BUFR MASTER
C   TABLES ON THE LOCAL FILE SYSTEM.  THE INPUT LOGICAL UNIT NUMBERS
C   SHOULD BE UNIQUE BUT SHOULD NOT ALREADY BE ASSIGNED TO ANY ACTUAL
C   BUFR MASTER TABLE FILES.  IF THIS SUBROUTINE IS NOT CALLED, THEN
C   DEFAULT VALUES ARE USED AS DEFINED WITHIN BUFR ARCHIVE LIBRARY
C   SUBROUTINE BFRINI.
C
C PROGRAM HISTORY LOG:
C 2009-03-23  J. ATOR    -- ORIGINAL AUTHOR
C
C USAGE:    CALL MTINFO ( CMTDIR, LUNMT1, LUNMT2 )
C   INPUT ARGUMENT LIST:
C     CMTDIR   - CHARACTER*(*): DIRECTORY LOCATION OF BUFR MASTER TABLES
C                ON LOCAL FILE SYSTEM (UP TO 100 CHARACTERS)
C     LUNMT1   - INTEGER: FIRST FORTRAN LOGICAL UNIT NUMBER TO USE WHEN
C                READING BUFR MASTER TABLES ON LOCAL FILE SYSTEM
C     LUNMT2   - INTEGER: SECOND FORTRAN LOGICAL UNIT NUMBER TO USE WHEN
C                READING BUFR MASTER TABLES ON LOCAL FILE SYSTEM
C
C REMARKS:
C    THIS ROUTINE CALLS:        BORT2    STRSUC
C    THIS ROUTINE IS CALLED BY: None
C                               Normally called only by application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      COMMON /MSTINF/ LUN1, LUN2, LMTD, MTDIR

      CHARACTER*(*) CMTDIR

      CHARACTER*128 BORT_STR
      CHARACTER*100 MTDIR

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

      CALL STRSUC ( CMTDIR, MTDIR, LMTD )
      IF ( LMTD .LT. 0 ) GOTO 900

      LUN1 = LUNMT1
      LUN2 = LUNMT2

C  EXITS
C  -----

      RETURN
900   BORT_STR = 'BUFRLIB: MTINFO - BAD INPUT MASTER TABLE DIRECTORY:'
      CALL BORT2(BORT_STR,CMTDIR)
      END
